# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataCatalogEncryptionSettingsArgs', 'DataCatalogEncryptionSettings']

@pulumi.input_type
class DataCatalogEncryptionSettingsArgs:
    def __init__(__self__, *,
                 data_catalog_encryption_settings: pulumi.Input['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs'],
                 catalog_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DataCatalogEncryptionSettings resource.
        :param pulumi.Input['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs'] data_catalog_encryption_settings: The security configuration to set. see Data Catalog Encryption Settings.
        :param pulumi.Input[builtins.str] catalog_id: The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID is used by default.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "data_catalog_encryption_settings", data_catalog_encryption_settings)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="dataCatalogEncryptionSettings")
    def data_catalog_encryption_settings(self) -> pulumi.Input['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs']:
        """
        The security configuration to set. see Data Catalog Encryption Settings.
        """
        return pulumi.get(self, "data_catalog_encryption_settings")

    @data_catalog_encryption_settings.setter
    def data_catalog_encryption_settings(self, value: pulumi.Input['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs']):
        pulumi.set(self, "data_catalog_encryption_settings", value)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID is used by default.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DataCatalogEncryptionSettingsState:
    def __init__(__self__, *,
                 catalog_id: Optional[pulumi.Input[builtins.str]] = None,
                 data_catalog_encryption_settings: Optional[pulumi.Input['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DataCatalogEncryptionSettings resources.
        :param pulumi.Input[builtins.str] catalog_id: The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID is used by default.
        :param pulumi.Input['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs'] data_catalog_encryption_settings: The security configuration to set. see Data Catalog Encryption Settings.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if data_catalog_encryption_settings is not None:
            pulumi.set(__self__, "data_catalog_encryption_settings", data_catalog_encryption_settings)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID is used by default.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="dataCatalogEncryptionSettings")
    def data_catalog_encryption_settings(self) -> Optional[pulumi.Input['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs']]:
        """
        The security configuration to set. see Data Catalog Encryption Settings.
        """
        return pulumi.get(self, "data_catalog_encryption_settings")

    @data_catalog_encryption_settings.setter
    def data_catalog_encryption_settings(self, value: Optional[pulumi.Input['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs']]):
        pulumi.set(self, "data_catalog_encryption_settings", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:glue/dataCatalogEncryptionSettings:DataCatalogEncryptionSettings")
class DataCatalogEncryptionSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[builtins.str]] = None,
                 data_catalog_encryption_settings: Optional[pulumi.Input[Union['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs', 'DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Glue Data Catalog Encryption Settings resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.DataCatalogEncryptionSettings("example", data_catalog_encryption_settings={
            "connection_password_encryption": {
                "aws_kms_key_id": test["arn"],
                "return_connection_password_encrypted": True,
            },
            "encryption_at_rest": {
                "catalog_encryption_mode": "SSE-KMS",
                "catalog_encryption_service_role": role["test"]["arn"],
                "sse_aws_kms_key_id": test["arn"],
            },
        })
        ```

        ## Import

        Using `pulumi import`, import Glue Data Catalog Encryption Settings using `CATALOG-ID` (AWS account ID if not custom). For example:

        ```sh
        $ pulumi import aws:glue/dataCatalogEncryptionSettings:DataCatalogEncryptionSettings example 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] catalog_id: The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID is used by default.
        :param pulumi.Input[Union['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs', 'DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgsDict']] data_catalog_encryption_settings: The security configuration to set. see Data Catalog Encryption Settings.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataCatalogEncryptionSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Glue Data Catalog Encryption Settings resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.DataCatalogEncryptionSettings("example", data_catalog_encryption_settings={
            "connection_password_encryption": {
                "aws_kms_key_id": test["arn"],
                "return_connection_password_encrypted": True,
            },
            "encryption_at_rest": {
                "catalog_encryption_mode": "SSE-KMS",
                "catalog_encryption_service_role": role["test"]["arn"],
                "sse_aws_kms_key_id": test["arn"],
            },
        })
        ```

        ## Import

        Using `pulumi import`, import Glue Data Catalog Encryption Settings using `CATALOG-ID` (AWS account ID if not custom). For example:

        ```sh
        $ pulumi import aws:glue/dataCatalogEncryptionSettings:DataCatalogEncryptionSettings example 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param DataCatalogEncryptionSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataCatalogEncryptionSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[builtins.str]] = None,
                 data_catalog_encryption_settings: Optional[pulumi.Input[Union['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs', 'DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataCatalogEncryptionSettingsArgs.__new__(DataCatalogEncryptionSettingsArgs)

            __props__.__dict__["catalog_id"] = catalog_id
            if data_catalog_encryption_settings is None and not opts.urn:
                raise TypeError("Missing required property 'data_catalog_encryption_settings'")
            __props__.__dict__["data_catalog_encryption_settings"] = data_catalog_encryption_settings
            __props__.__dict__["region"] = region
        super(DataCatalogEncryptionSettings, __self__).__init__(
            'aws:glue/dataCatalogEncryptionSettings:DataCatalogEncryptionSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            catalog_id: Optional[pulumi.Input[builtins.str]] = None,
            data_catalog_encryption_settings: Optional[pulumi.Input[Union['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs', 'DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgsDict']]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'DataCatalogEncryptionSettings':
        """
        Get an existing DataCatalogEncryptionSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] catalog_id: The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID is used by default.
        :param pulumi.Input[Union['DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgs', 'DataCatalogEncryptionSettingsDataCatalogEncryptionSettingsArgsDict']] data_catalog_encryption_settings: The security configuration to set. see Data Catalog Encryption Settings.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataCatalogEncryptionSettingsState.__new__(_DataCatalogEncryptionSettingsState)

        __props__.__dict__["catalog_id"] = catalog_id
        __props__.__dict__["data_catalog_encryption_settings"] = data_catalog_encryption_settings
        __props__.__dict__["region"] = region
        return DataCatalogEncryptionSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID is used by default.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="dataCatalogEncryptionSettings")
    def data_catalog_encryption_settings(self) -> pulumi.Output['outputs.DataCatalogEncryptionSettingsDataCatalogEncryptionSettings']:
        """
        The security configuration to set. see Data Catalog Encryption Settings.
        """
        return pulumi.get(self, "data_catalog_encryption_settings")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

