# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataQualityRulesetArgs', 'DataQualityRuleset']

@pulumi.input_type
class DataQualityRulesetArgs:
    def __init__(__self__, *,
                 ruleset: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_table: Optional[pulumi.Input['DataQualityRulesetTargetTableArgs']] = None):
        """
        The set of arguments for constructing a DataQualityRuleset resource.
        :param pulumi.Input[builtins.str] ruleset: A Data Quality Definition Language (DQDL) ruleset. For more information, see the AWS Glue developer guide.
        :param pulumi.Input[builtins.str] description: Description of the data quality ruleset.
        :param pulumi.Input[builtins.str] name: Name of the data quality ruleset.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['DataQualityRulesetTargetTableArgs'] target_table: A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
        """
        pulumi.set(__self__, "ruleset", ruleset)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_table is not None:
            pulumi.set(__self__, "target_table", target_table)

    @property
    @pulumi.getter
    def ruleset(self) -> pulumi.Input[builtins.str]:
        """
        A Data Quality Definition Language (DQDL) ruleset. For more information, see the AWS Glue developer guide.
        """
        return pulumi.get(self, "ruleset")

    @ruleset.setter
    def ruleset(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ruleset", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the data quality ruleset.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the data quality ruleset.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetTable")
    def target_table(self) -> Optional[pulumi.Input['DataQualityRulesetTargetTableArgs']]:
        """
        A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
        """
        return pulumi.get(self, "target_table")

    @target_table.setter
    def target_table(self, value: Optional[pulumi.Input['DataQualityRulesetTargetTableArgs']]):
        pulumi.set(self, "target_table", value)


@pulumi.input_type
class _DataQualityRulesetState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 created_on: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 last_modified_on: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 recommendation_run_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 ruleset: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_table: Optional[pulumi.Input['DataQualityRulesetTargetTableArgs']] = None):
        """
        Input properties used for looking up and filtering DataQualityRuleset resources.
        :param pulumi.Input[builtins.str] arn: ARN of the Glue Data Quality Ruleset.
        :param pulumi.Input[builtins.str] created_on: The time and date that this data quality ruleset was created.
        :param pulumi.Input[builtins.str] description: Description of the data quality ruleset.
        :param pulumi.Input[builtins.str] last_modified_on: The time and date that this data quality ruleset was created.
        :param pulumi.Input[builtins.str] name: Name of the data quality ruleset.
        :param pulumi.Input[builtins.str] recommendation_run_id: When a ruleset was created from a recommendation run, this run ID is generated to link the two together.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] ruleset: A Data Quality Definition Language (DQDL) ruleset. For more information, see the AWS Glue developer guide.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['DataQualityRulesetTargetTableArgs'] target_table: A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if last_modified_on is not None:
            pulumi.set(__self__, "last_modified_on", last_modified_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recommendation_run_id is not None:
            pulumi.set(__self__, "recommendation_run_id", recommendation_run_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if ruleset is not None:
            pulumi.set(__self__, "ruleset", ruleset)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if target_table is not None:
            pulumi.set(__self__, "target_table", target_table)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Glue Data Quality Ruleset.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time and date that this data quality ruleset was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the data quality ruleset.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="lastModifiedOn")
    def last_modified_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time and date that this data quality ruleset was created.
        """
        return pulumi.get(self, "last_modified_on")

    @last_modified_on.setter
    def last_modified_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_modified_on", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the data quality ruleset.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="recommendationRunId")
    def recommendation_run_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When a ruleset was created from a recommendation run, this run ID is generated to link the two together.
        """
        return pulumi.get(self, "recommendation_run_id")

    @recommendation_run_id.setter
    def recommendation_run_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recommendation_run_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def ruleset(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A Data Quality Definition Language (DQDL) ruleset. For more information, see the AWS Glue developer guide.
        """
        return pulumi.get(self, "ruleset")

    @ruleset.setter
    def ruleset(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ruleset", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="targetTable")
    def target_table(self) -> Optional[pulumi.Input['DataQualityRulesetTargetTableArgs']]:
        """
        A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
        """
        return pulumi.get(self, "target_table")

    @target_table.setter
    def target_table(self, value: Optional[pulumi.Input['DataQualityRulesetTargetTableArgs']]):
        pulumi.set(self, "target_table", value)


@pulumi.type_token("aws:glue/dataQualityRuleset:DataQualityRuleset")
class DataQualityRuleset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 ruleset: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_table: Optional[pulumi.Input[Union['DataQualityRulesetTargetTableArgs', 'DataQualityRulesetTargetTableArgsDict']]] = None,
                 __props__=None):
        """
        Provides a Glue Data Quality Ruleset Resource. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/glue-data-quality.html) for a full explanation of the Glue Data Quality Ruleset functionality

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.DataQualityRuleset("example",
            name="example",
            ruleset="Rules = [Completeness \\"colA\\" between 0.4 and 0.8]")
        ```

        ### With description

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.DataQualityRuleset("example",
            name="example",
            description="example",
            ruleset="Rules = [Completeness \\"colA\\" between 0.4 and 0.8]")
        ```

        ### With tags

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.DataQualityRuleset("example",
            name="example",
            ruleset="Rules = [Completeness \\"colA\\" between 0.4 and 0.8]",
            tags={
                "hello": "world",
            })
        ```

        ### With target_table

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.DataQualityRuleset("example",
            name="example",
            ruleset="Rules = [Completeness \\"colA\\" between 0.4 and 0.8]",
            target_table={
                "database_name": example_aws_glue_catalog_database["name"],
                "table_name": example_aws_glue_catalog_table["name"],
            })
        ```

        ## Import

        Using `pulumi import`, import Glue Data Quality Ruleset using the `name`. For example:

        ```sh
        $ pulumi import aws:glue/dataQualityRuleset:DataQualityRuleset example exampleName
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description of the data quality ruleset.
        :param pulumi.Input[builtins.str] name: Name of the data quality ruleset.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] ruleset: A Data Quality Definition Language (DQDL) ruleset. For more information, see the AWS Glue developer guide.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['DataQualityRulesetTargetTableArgs', 'DataQualityRulesetTargetTableArgsDict']] target_table: A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataQualityRulesetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Glue Data Quality Ruleset Resource. You can refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/glue-data-quality.html) for a full explanation of the Glue Data Quality Ruleset functionality

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.DataQualityRuleset("example",
            name="example",
            ruleset="Rules = [Completeness \\"colA\\" between 0.4 and 0.8]")
        ```

        ### With description

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.DataQualityRuleset("example",
            name="example",
            description="example",
            ruleset="Rules = [Completeness \\"colA\\" between 0.4 and 0.8]")
        ```

        ### With tags

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.DataQualityRuleset("example",
            name="example",
            ruleset="Rules = [Completeness \\"colA\\" between 0.4 and 0.8]",
            tags={
                "hello": "world",
            })
        ```

        ### With target_table

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.DataQualityRuleset("example",
            name="example",
            ruleset="Rules = [Completeness \\"colA\\" between 0.4 and 0.8]",
            target_table={
                "database_name": example_aws_glue_catalog_database["name"],
                "table_name": example_aws_glue_catalog_table["name"],
            })
        ```

        ## Import

        Using `pulumi import`, import Glue Data Quality Ruleset using the `name`. For example:

        ```sh
        $ pulumi import aws:glue/dataQualityRuleset:DataQualityRuleset example exampleName
        ```

        :param str resource_name: The name of the resource.
        :param DataQualityRulesetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataQualityRulesetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 ruleset: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_table: Optional[pulumi.Input[Union['DataQualityRulesetTargetTableArgs', 'DataQualityRulesetTargetTableArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataQualityRulesetArgs.__new__(DataQualityRulesetArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if ruleset is None and not opts.urn:
                raise TypeError("Missing required property 'ruleset'")
            __props__.__dict__["ruleset"] = ruleset
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_table"] = target_table
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_on"] = None
            __props__.__dict__["last_modified_on"] = None
            __props__.__dict__["recommendation_run_id"] = None
            __props__.__dict__["tags_all"] = None
        super(DataQualityRuleset, __self__).__init__(
            'aws:glue/dataQualityRuleset:DataQualityRuleset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            created_on: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            last_modified_on: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            recommendation_run_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            ruleset: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            target_table: Optional[pulumi.Input[Union['DataQualityRulesetTargetTableArgs', 'DataQualityRulesetTargetTableArgsDict']]] = None) -> 'DataQualityRuleset':
        """
        Get an existing DataQualityRuleset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the Glue Data Quality Ruleset.
        :param pulumi.Input[builtins.str] created_on: The time and date that this data quality ruleset was created.
        :param pulumi.Input[builtins.str] description: Description of the data quality ruleset.
        :param pulumi.Input[builtins.str] last_modified_on: The time and date that this data quality ruleset was created.
        :param pulumi.Input[builtins.str] name: Name of the data quality ruleset.
        :param pulumi.Input[builtins.str] recommendation_run_id: When a ruleset was created from a recommendation run, this run ID is generated to link the two together.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] ruleset: A Data Quality Definition Language (DQDL) ruleset. For more information, see the AWS Glue developer guide.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union['DataQualityRulesetTargetTableArgs', 'DataQualityRulesetTargetTableArgsDict']] target_table: A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataQualityRulesetState.__new__(_DataQualityRulesetState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["description"] = description
        __props__.__dict__["last_modified_on"] = last_modified_on
        __props__.__dict__["name"] = name
        __props__.__dict__["recommendation_run_id"] = recommendation_run_id
        __props__.__dict__["region"] = region
        __props__.__dict__["ruleset"] = ruleset
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["target_table"] = target_table
        return DataQualityRuleset(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Glue Data Quality Ruleset.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[builtins.str]:
        """
        The time and date that this data quality ruleset was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the data quality ruleset.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="lastModifiedOn")
    def last_modified_on(self) -> pulumi.Output[builtins.str]:
        """
        The time and date that this data quality ruleset was created.
        """
        return pulumi.get(self, "last_modified_on")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the data quality ruleset.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recommendationRunId")
    def recommendation_run_id(self) -> pulumi.Output[builtins.str]:
        """
        When a ruleset was created from a recommendation run, this run ID is generated to link the two together.
        """
        return pulumi.get(self, "recommendation_run_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def ruleset(self) -> pulumi.Output[builtins.str]:
        """
        A Data Quality Definition Language (DQDL) ruleset. For more information, see the AWS Glue developer guide.
        """
        return pulumi.get(self, "ruleset")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="targetTable")
    def target_table(self) -> pulumi.Output[Optional['outputs.DataQualityRulesetTargetTable']]:
        """
        A Configuration block specifying a target table associated with the data quality ruleset. See `target_table` below.
        """
        return pulumi.get(self, "target_table")

