# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetConnectionResult',
    'AwaitableGetConnectionResult',
    'get_connection',
    'get_connection_output',
]

@pulumi.output_type
class GetConnectionResult:
    """
    A collection of values returned by getConnection.
    """
    def __init__(__self__, arn=None, athena_properties=None, catalog_id=None, connection_properties=None, connection_type=None, description=None, id=None, match_criterias=None, name=None, physical_connection_requirements=None, region=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if athena_properties and not isinstance(athena_properties, dict):
            raise TypeError("Expected argument 'athena_properties' to be a dict")
        pulumi.set(__self__, "athena_properties", athena_properties)
        if catalog_id and not isinstance(catalog_id, str):
            raise TypeError("Expected argument 'catalog_id' to be a str")
        pulumi.set(__self__, "catalog_id", catalog_id)
        if connection_properties and not isinstance(connection_properties, dict):
            raise TypeError("Expected argument 'connection_properties' to be a dict")
        pulumi.set(__self__, "connection_properties", connection_properties)
        if connection_type and not isinstance(connection_type, str):
            raise TypeError("Expected argument 'connection_type' to be a str")
        pulumi.set(__self__, "connection_type", connection_type)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if match_criterias and not isinstance(match_criterias, list):
            raise TypeError("Expected argument 'match_criterias' to be a list")
        pulumi.set(__self__, "match_criterias", match_criterias)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if physical_connection_requirements and not isinstance(physical_connection_requirements, list):
            raise TypeError("Expected argument 'physical_connection_requirements' to be a list")
        pulumi.set(__self__, "physical_connection_requirements", physical_connection_requirements)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the Glue Connection.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="athenaProperties")
    def athena_properties(self) -> Mapping[str, builtins.str]:
        """
        A map of connection properties specific to the Athena compute environment.
        """
        return pulumi.get(self, "athena_properties")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> builtins.str:
        """
        Catalog ID of the Glue Connection.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="connectionProperties")
    def connection_properties(self) -> Mapping[str, builtins.str]:
        """
        A map of connection properties.
        """
        return pulumi.get(self, "connection_properties")

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> builtins.str:
        """
        Type of Glue Connection.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="matchCriterias")
    def match_criterias(self) -> Sequence[builtins.str]:
        """
        A list of criteria that can be used in selecting this connection.
        """
        return pulumi.get(self, "match_criterias")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the Glue Connection.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="physicalConnectionRequirements")
    def physical_connection_requirements(self) -> Sequence['outputs.GetConnectionPhysicalConnectionRequirementResult']:
        """
        A map of physical connection requirements, such as VPC and SecurityGroup.
        """
        return pulumi.get(self, "physical_connection_requirements")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Tags assigned to the resource
        """
        return pulumi.get(self, "tags")


class AwaitableGetConnectionResult(GetConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionResult(
            arn=self.arn,
            athena_properties=self.athena_properties,
            catalog_id=self.catalog_id,
            connection_properties=self.connection_properties,
            connection_type=self.connection_type,
            description=self.description,
            id=self.id,
            match_criterias=self.match_criterias,
            name=self.name,
            physical_connection_requirements=self.physical_connection_requirements,
            region=self.region,
            tags=self.tags)


def get_connection(id: Optional[builtins.str] = None,
                   region: Optional[builtins.str] = None,
                   tags: Optional[Mapping[str, builtins.str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionResult:
    """
    This data source can be used to fetch information about a specific Glue Connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.glue.get_connection(id="123456789123:connection")
    ```


    :param builtins.str id: Concatenation of the catalog ID and connection name. For example, if your account ID is
           `123456789123` and the connection name is `conn` then the ID is `123456789123:conn`.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Tags assigned to the resource
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:glue/getConnection:getConnection', __args__, opts=opts, typ=GetConnectionResult).value

    return AwaitableGetConnectionResult(
        arn=pulumi.get(__ret__, 'arn'),
        athena_properties=pulumi.get(__ret__, 'athena_properties'),
        catalog_id=pulumi.get(__ret__, 'catalog_id'),
        connection_properties=pulumi.get(__ret__, 'connection_properties'),
        connection_type=pulumi.get(__ret__, 'connection_type'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        match_criterias=pulumi.get(__ret__, 'match_criterias'),
        name=pulumi.get(__ret__, 'name'),
        physical_connection_requirements=pulumi.get(__ret__, 'physical_connection_requirements'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_connection_output(id: Optional[pulumi.Input[builtins.str]] = None,
                          region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectionResult]:
    """
    This data source can be used to fetch information about a specific Glue Connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.glue.get_connection(id="123456789123:connection")
    ```


    :param builtins.str id: Concatenation of the catalog ID and connection name. For example, if your account ID is
           `123456789123` and the connection name is `conn` then the ID is `123456789123:conn`.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Tags assigned to the resource
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:glue/getConnection:getConnection', __args__, opts=opts, typ=GetConnectionResult)
    return __ret__.apply(lambda __response__: GetConnectionResult(
        arn=pulumi.get(__response__, 'arn'),
        athena_properties=pulumi.get(__response__, 'athena_properties'),
        catalog_id=pulumi.get(__response__, 'catalog_id'),
        connection_properties=pulumi.get(__response__, 'connection_properties'),
        connection_type=pulumi.get(__response__, 'connection_type'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        match_criterias=pulumi.get(__response__, 'match_criterias'),
        name=pulumi.get(__response__, 'name'),
        physical_connection_requirements=pulumi.get(__response__, 'physical_connection_requirements'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
