# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 command: pulumi.Input['JobCommandArgs'],
                 role_arn: pulumi.Input[builtins.str],
                 connections: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 execution_class: Optional[pulumi.Input[builtins.str]] = None,
                 execution_property: Optional[pulumi.Input['JobExecutionPropertyArgs']] = None,
                 glue_version: Optional[pulumi.Input[builtins.str]] = None,
                 job_mode: Optional[pulumi.Input[builtins.str]] = None,
                 job_run_queuing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 max_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 max_retries: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 non_overridable_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 notification_property: Optional[pulumi.Input['JobNotificationPropertyArgs']] = None,
                 number_of_workers: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_configuration: Optional[pulumi.Input[builtins.str]] = None,
                 source_control_details: Optional[pulumi.Input['JobSourceControlDetailsArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 worker_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input['JobCommandArgs'] command: The command of the job. Defined below.
        :param pulumi.Input[builtins.str] role_arn: The ARN of the IAM role associated with this job.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] connections: The list of connections used for this job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] default_arguments: The map of default arguments for this job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes. For information about how to specify and consume your own Job arguments, see the [Calling AWS Glue APIs in Python](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html) topic in the developer guide. For information about the key-value pairs that AWS Glue consumes to set up your job, see the [Special Parameters Used by AWS Glue](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html) topic in the developer guide.
        :param pulumi.Input[builtins.str] description: Description of the job.
        :param pulumi.Input[builtins.str] execution_class: Indicates whether the job is run with a standard or flexible execution class. The standard execution class is ideal for time-sensitive workloads that require fast job startup and dedicated resources. Valid value: `FLEX`, `STANDARD`.
        :param pulumi.Input['JobExecutionPropertyArgs'] execution_property: Execution property of the job. Defined below.
        :param pulumi.Input[builtins.str] glue_version: The version of glue to use, for example "1.0". Ray jobs should set this to 4.0 or greater. For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
        :param pulumi.Input[builtins.str] job_mode: Describes how a job was created. Valid values are `SCRIPT`, `NOTEBOOK` and `VISUAL`.
        :param pulumi.Input[builtins.bool] job_run_queuing_enabled: Specifies whether job run queuing is enabled for the job runs for this job. A value of true means job run queuing is enabled for the job runs. If false or not populated, the job runs will not be considered for queueing.
        :param pulumi.Input[builtins.str] maintenance_window: Specifies the day of the week and hour for the maintenance window for streaming jobs.
        :param pulumi.Input[builtins.float] max_capacity: The maximum number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. `Required` when `pythonshell` is set, accept either `0.0625` or `1.0`. Use `number_of_workers` and `worker_type` arguments instead with `glue_version` `2.0` and above.
        :param pulumi.Input[builtins.int] max_retries: The maximum number of times to retry this job if it fails.
        :param pulumi.Input[builtins.str] name: The name you assign to this job. It must be unique in your account.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] non_overridable_arguments: Non-overridable arguments for this job, specified as name-value pairs.
        :param pulumi.Input['JobNotificationPropertyArgs'] notification_property: Notification property of the job. Defined below.
        :param pulumi.Input[builtins.int] number_of_workers: The number of workers of a defined workerType that are allocated when a job runs.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] security_configuration: The name of the Security Configuration to be associated with the job.
        :param pulumi.Input['JobSourceControlDetailsArgs'] source_control_details: The details for a source control configuration for a job, allowing synchronization of job artifacts to or from a remote repository. Defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.int] timeout: The job timeout in minutes. The default is 2880 minutes (48 hours) for `glueetl` and `pythonshell` jobs, and null (unlimited) for `gluestreaming` jobs.
        :param pulumi.Input[builtins.str] worker_type: The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or G.025X for Spark jobs. Accepts the value Z.2X for Ray jobs.
               * For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
               * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
               * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
               * For the G.4X worker type, each worker maps to 4 DPU (16 vCPUs, 64 GB of memory) with 256GB disk (approximately 235GB free), and provides 1 executor per worker. Recommended for memory-intensive jobs. Only available for Glue version 3.0. Available AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).
               * For the G.8X worker type, each worker maps to 8 DPU (32 vCPUs, 128 GB of memory) with 512GB disk (approximately 487GB free), and provides 1 executor per worker. Recommended for memory-intensive jobs. Only available for Glue version 3.0. Available AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).
               * For the G.025X worker type, each worker maps to 0.25 DPU (2 vCPU, 4GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for low volume streaming jobs. Only available for Glue version 3.0.
               * For the Z.2X worker type, each worker maps to 2 M-DPU (8vCPU, 64 GB of m emory, 128 GB disk), and provides up to 8 Ray workers based on the autoscaler.
        """
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "role_arn", role_arn)
        if connections is not None:
            pulumi.set(__self__, "connections", connections)
        if default_arguments is not None:
            pulumi.set(__self__, "default_arguments", default_arguments)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_class is not None:
            pulumi.set(__self__, "execution_class", execution_class)
        if execution_property is not None:
            pulumi.set(__self__, "execution_property", execution_property)
        if glue_version is not None:
            pulumi.set(__self__, "glue_version", glue_version)
        if job_mode is not None:
            pulumi.set(__self__, "job_mode", job_mode)
        if job_run_queuing_enabled is not None:
            pulumi.set(__self__, "job_run_queuing_enabled", job_run_queuing_enabled)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if non_overridable_arguments is not None:
            pulumi.set(__self__, "non_overridable_arguments", non_overridable_arguments)
        if notification_property is not None:
            pulumi.set(__self__, "notification_property", notification_property)
        if number_of_workers is not None:
            pulumi.set(__self__, "number_of_workers", number_of_workers)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_configuration is not None:
            pulumi.set(__self__, "security_configuration", security_configuration)
        if source_control_details is not None:
            pulumi.set(__self__, "source_control_details", source_control_details)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if worker_type is not None:
            pulumi.set(__self__, "worker_type", worker_type)

    @property
    @pulumi.getter
    def command(self) -> pulumi.Input['JobCommandArgs']:
        """
        The command of the job. Defined below.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: pulumi.Input['JobCommandArgs']):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the IAM role associated with this job.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of connections used for this job.
        """
        return pulumi.get(self, "connections")

    @connections.setter
    def connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "connections", value)

    @property
    @pulumi.getter(name="defaultArguments")
    def default_arguments(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The map of default arguments for this job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes. For information about how to specify and consume your own Job arguments, see the [Calling AWS Glue APIs in Python](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html) topic in the developer guide. For information about the key-value pairs that AWS Glue consumes to set up your job, see the [Special Parameters Used by AWS Glue](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html) topic in the developer guide.
        """
        return pulumi.get(self, "default_arguments")

    @default_arguments.setter
    def default_arguments(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "default_arguments", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executionClass")
    def execution_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether the job is run with a standard or flexible execution class. The standard execution class is ideal for time-sensitive workloads that require fast job startup and dedicated resources. Valid value: `FLEX`, `STANDARD`.
        """
        return pulumi.get(self, "execution_class")

    @execution_class.setter
    def execution_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_class", value)

    @property
    @pulumi.getter(name="executionProperty")
    def execution_property(self) -> Optional[pulumi.Input['JobExecutionPropertyArgs']]:
        """
        Execution property of the job. Defined below.
        """
        return pulumi.get(self, "execution_property")

    @execution_property.setter
    def execution_property(self, value: Optional[pulumi.Input['JobExecutionPropertyArgs']]):
        pulumi.set(self, "execution_property", value)

    @property
    @pulumi.getter(name="glueVersion")
    def glue_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of glue to use, for example "1.0". Ray jobs should set this to 4.0 or greater. For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
        """
        return pulumi.get(self, "glue_version")

    @glue_version.setter
    def glue_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "glue_version", value)

    @property
    @pulumi.getter(name="jobMode")
    def job_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Describes how a job was created. Valid values are `SCRIPT`, `NOTEBOOK` and `VISUAL`.
        """
        return pulumi.get(self, "job_mode")

    @job_mode.setter
    def job_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_mode", value)

    @property
    @pulumi.getter(name="jobRunQueuingEnabled")
    def job_run_queuing_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether job run queuing is enabled for the job runs for this job. A value of true means job run queuing is enabled for the job runs. If false or not populated, the job runs will not be considered for queueing.
        """
        return pulumi.get(self, "job_run_queuing_enabled")

    @job_run_queuing_enabled.setter
    def job_run_queuing_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "job_run_queuing_enabled", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the day of the week and hour for the maintenance window for streaming jobs.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The maximum number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. `Required` when `pythonshell` is set, accept either `0.0625` or `1.0`. Use `number_of_workers` and `worker_type` arguments instead with `glue_version` `2.0` and above.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of times to retry this job if it fails.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name you assign to this job. It must be unique in your account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nonOverridableArguments")
    def non_overridable_arguments(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Non-overridable arguments for this job, specified as name-value pairs.
        """
        return pulumi.get(self, "non_overridable_arguments")

    @non_overridable_arguments.setter
    def non_overridable_arguments(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "non_overridable_arguments", value)

    @property
    @pulumi.getter(name="notificationProperty")
    def notification_property(self) -> Optional[pulumi.Input['JobNotificationPropertyArgs']]:
        """
        Notification property of the job. Defined below.
        """
        return pulumi.get(self, "notification_property")

    @notification_property.setter
    def notification_property(self, value: Optional[pulumi.Input['JobNotificationPropertyArgs']]):
        pulumi.set(self, "notification_property", value)

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of workers of a defined workerType that are allocated when a job runs.
        """
        return pulumi.get(self, "number_of_workers")

    @number_of_workers.setter
    def number_of_workers(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "number_of_workers", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Security Configuration to be associated with the job.
        """
        return pulumi.get(self, "security_configuration")

    @security_configuration.setter
    def security_configuration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_configuration", value)

    @property
    @pulumi.getter(name="sourceControlDetails")
    def source_control_details(self) -> Optional[pulumi.Input['JobSourceControlDetailsArgs']]:
        """
        The details for a source control configuration for a job, allowing synchronization of job artifacts to or from a remote repository. Defined below.
        """
        return pulumi.get(self, "source_control_details")

    @source_control_details.setter
    def source_control_details(self, value: Optional[pulumi.Input['JobSourceControlDetailsArgs']]):
        pulumi.set(self, "source_control_details", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The job timeout in minutes. The default is 2880 minutes (48 hours) for `glueetl` and `pythonshell` jobs, and null (unlimited) for `gluestreaming` jobs.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="workerType")
    def worker_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or G.025X for Spark jobs. Accepts the value Z.2X for Ray jobs.
        * For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
        * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
        * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
        * For the G.4X worker type, each worker maps to 4 DPU (16 vCPUs, 64 GB of memory) with 256GB disk (approximately 235GB free), and provides 1 executor per worker. Recommended for memory-intensive jobs. Only available for Glue version 3.0. Available AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).
        * For the G.8X worker type, each worker maps to 8 DPU (32 vCPUs, 128 GB of memory) with 512GB disk (approximately 487GB free), and provides 1 executor per worker. Recommended for memory-intensive jobs. Only available for Glue version 3.0. Available AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).
        * For the G.025X worker type, each worker maps to 0.25 DPU (2 vCPU, 4GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for low volume streaming jobs. Only available for Glue version 3.0.
        * For the Z.2X worker type, each worker maps to 2 M-DPU (8vCPU, 64 GB of m emory, 128 GB disk), and provides up to 8 Ray workers based on the autoscaler.
        """
        return pulumi.get(self, "worker_type")

    @worker_type.setter
    def worker_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "worker_type", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 command: Optional[pulumi.Input['JobCommandArgs']] = None,
                 connections: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 execution_class: Optional[pulumi.Input[builtins.str]] = None,
                 execution_property: Optional[pulumi.Input['JobExecutionPropertyArgs']] = None,
                 glue_version: Optional[pulumi.Input[builtins.str]] = None,
                 job_mode: Optional[pulumi.Input[builtins.str]] = None,
                 job_run_queuing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 max_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 max_retries: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 non_overridable_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 notification_property: Optional[pulumi.Input['JobNotificationPropertyArgs']] = None,
                 number_of_workers: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 security_configuration: Optional[pulumi.Input[builtins.str]] = None,
                 source_control_details: Optional[pulumi.Input['JobSourceControlDetailsArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 worker_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of Glue Job
        :param pulumi.Input['JobCommandArgs'] command: The command of the job. Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] connections: The list of connections used for this job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] default_arguments: The map of default arguments for this job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes. For information about how to specify and consume your own Job arguments, see the [Calling AWS Glue APIs in Python](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html) topic in the developer guide. For information about the key-value pairs that AWS Glue consumes to set up your job, see the [Special Parameters Used by AWS Glue](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html) topic in the developer guide.
        :param pulumi.Input[builtins.str] description: Description of the job.
        :param pulumi.Input[builtins.str] execution_class: Indicates whether the job is run with a standard or flexible execution class. The standard execution class is ideal for time-sensitive workloads that require fast job startup and dedicated resources. Valid value: `FLEX`, `STANDARD`.
        :param pulumi.Input['JobExecutionPropertyArgs'] execution_property: Execution property of the job. Defined below.
        :param pulumi.Input[builtins.str] glue_version: The version of glue to use, for example "1.0". Ray jobs should set this to 4.0 or greater. For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
        :param pulumi.Input[builtins.str] job_mode: Describes how a job was created. Valid values are `SCRIPT`, `NOTEBOOK` and `VISUAL`.
        :param pulumi.Input[builtins.bool] job_run_queuing_enabled: Specifies whether job run queuing is enabled for the job runs for this job. A value of true means job run queuing is enabled for the job runs. If false or not populated, the job runs will not be considered for queueing.
        :param pulumi.Input[builtins.str] maintenance_window: Specifies the day of the week and hour for the maintenance window for streaming jobs.
        :param pulumi.Input[builtins.float] max_capacity: The maximum number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. `Required` when `pythonshell` is set, accept either `0.0625` or `1.0`. Use `number_of_workers` and `worker_type` arguments instead with `glue_version` `2.0` and above.
        :param pulumi.Input[builtins.int] max_retries: The maximum number of times to retry this job if it fails.
        :param pulumi.Input[builtins.str] name: The name you assign to this job. It must be unique in your account.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] non_overridable_arguments: Non-overridable arguments for this job, specified as name-value pairs.
        :param pulumi.Input['JobNotificationPropertyArgs'] notification_property: Notification property of the job. Defined below.
        :param pulumi.Input[builtins.int] number_of_workers: The number of workers of a defined workerType that are allocated when a job runs.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] role_arn: The ARN of the IAM role associated with this job.
        :param pulumi.Input[builtins.str] security_configuration: The name of the Security Configuration to be associated with the job.
        :param pulumi.Input['JobSourceControlDetailsArgs'] source_control_details: The details for a source control configuration for a job, allowing synchronization of job artifacts to or from a remote repository. Defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.int] timeout: The job timeout in minutes. The default is 2880 minutes (48 hours) for `glueetl` and `pythonshell` jobs, and null (unlimited) for `gluestreaming` jobs.
        :param pulumi.Input[builtins.str] worker_type: The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or G.025X for Spark jobs. Accepts the value Z.2X for Ray jobs.
               * For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
               * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
               * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
               * For the G.4X worker type, each worker maps to 4 DPU (16 vCPUs, 64 GB of memory) with 256GB disk (approximately 235GB free), and provides 1 executor per worker. Recommended for memory-intensive jobs. Only available for Glue version 3.0. Available AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).
               * For the G.8X worker type, each worker maps to 8 DPU (32 vCPUs, 128 GB of memory) with 512GB disk (approximately 487GB free), and provides 1 executor per worker. Recommended for memory-intensive jobs. Only available for Glue version 3.0. Available AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).
               * For the G.025X worker type, each worker maps to 0.25 DPU (2 vCPU, 4GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for low volume streaming jobs. Only available for Glue version 3.0.
               * For the Z.2X worker type, each worker maps to 2 M-DPU (8vCPU, 64 GB of m emory, 128 GB disk), and provides up to 8 Ray workers based on the autoscaler.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if connections is not None:
            pulumi.set(__self__, "connections", connections)
        if default_arguments is not None:
            pulumi.set(__self__, "default_arguments", default_arguments)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_class is not None:
            pulumi.set(__self__, "execution_class", execution_class)
        if execution_property is not None:
            pulumi.set(__self__, "execution_property", execution_property)
        if glue_version is not None:
            pulumi.set(__self__, "glue_version", glue_version)
        if job_mode is not None:
            pulumi.set(__self__, "job_mode", job_mode)
        if job_run_queuing_enabled is not None:
            pulumi.set(__self__, "job_run_queuing_enabled", job_run_queuing_enabled)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if non_overridable_arguments is not None:
            pulumi.set(__self__, "non_overridable_arguments", non_overridable_arguments)
        if notification_property is not None:
            pulumi.set(__self__, "notification_property", notification_property)
        if number_of_workers is not None:
            pulumi.set(__self__, "number_of_workers", number_of_workers)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if security_configuration is not None:
            pulumi.set(__self__, "security_configuration", security_configuration)
        if source_control_details is not None:
            pulumi.set(__self__, "source_control_details", source_control_details)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if worker_type is not None:
            pulumi.set(__self__, "worker_type", worker_type)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of Glue Job
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input['JobCommandArgs']]:
        """
        The command of the job. Defined below.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input['JobCommandArgs']]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter
    def connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of connections used for this job.
        """
        return pulumi.get(self, "connections")

    @connections.setter
    def connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "connections", value)

    @property
    @pulumi.getter(name="defaultArguments")
    def default_arguments(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The map of default arguments for this job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes. For information about how to specify and consume your own Job arguments, see the [Calling AWS Glue APIs in Python](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html) topic in the developer guide. For information about the key-value pairs that AWS Glue consumes to set up your job, see the [Special Parameters Used by AWS Glue](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html) topic in the developer guide.
        """
        return pulumi.get(self, "default_arguments")

    @default_arguments.setter
    def default_arguments(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "default_arguments", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the job.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executionClass")
    def execution_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether the job is run with a standard or flexible execution class. The standard execution class is ideal for time-sensitive workloads that require fast job startup and dedicated resources. Valid value: `FLEX`, `STANDARD`.
        """
        return pulumi.get(self, "execution_class")

    @execution_class.setter
    def execution_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_class", value)

    @property
    @pulumi.getter(name="executionProperty")
    def execution_property(self) -> Optional[pulumi.Input['JobExecutionPropertyArgs']]:
        """
        Execution property of the job. Defined below.
        """
        return pulumi.get(self, "execution_property")

    @execution_property.setter
    def execution_property(self, value: Optional[pulumi.Input['JobExecutionPropertyArgs']]):
        pulumi.set(self, "execution_property", value)

    @property
    @pulumi.getter(name="glueVersion")
    def glue_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of glue to use, for example "1.0". Ray jobs should set this to 4.0 or greater. For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
        """
        return pulumi.get(self, "glue_version")

    @glue_version.setter
    def glue_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "glue_version", value)

    @property
    @pulumi.getter(name="jobMode")
    def job_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Describes how a job was created. Valid values are `SCRIPT`, `NOTEBOOK` and `VISUAL`.
        """
        return pulumi.get(self, "job_mode")

    @job_mode.setter
    def job_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_mode", value)

    @property
    @pulumi.getter(name="jobRunQueuingEnabled")
    def job_run_queuing_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether job run queuing is enabled for the job runs for this job. A value of true means job run queuing is enabled for the job runs. If false or not populated, the job runs will not be considered for queueing.
        """
        return pulumi.get(self, "job_run_queuing_enabled")

    @job_run_queuing_enabled.setter
    def job_run_queuing_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "job_run_queuing_enabled", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the day of the week and hour for the maintenance window for streaming jobs.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The maximum number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. `Required` when `pythonshell` is set, accept either `0.0625` or `1.0`. Use `number_of_workers` and `worker_type` arguments instead with `glue_version` `2.0` and above.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of times to retry this job if it fails.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name you assign to this job. It must be unique in your account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nonOverridableArguments")
    def non_overridable_arguments(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Non-overridable arguments for this job, specified as name-value pairs.
        """
        return pulumi.get(self, "non_overridable_arguments")

    @non_overridable_arguments.setter
    def non_overridable_arguments(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "non_overridable_arguments", value)

    @property
    @pulumi.getter(name="notificationProperty")
    def notification_property(self) -> Optional[pulumi.Input['JobNotificationPropertyArgs']]:
        """
        Notification property of the job. Defined below.
        """
        return pulumi.get(self, "notification_property")

    @notification_property.setter
    def notification_property(self, value: Optional[pulumi.Input['JobNotificationPropertyArgs']]):
        pulumi.set(self, "notification_property", value)

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of workers of a defined workerType that are allocated when a job runs.
        """
        return pulumi.get(self, "number_of_workers")

    @number_of_workers.setter
    def number_of_workers(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "number_of_workers", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the IAM role associated with this job.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Security Configuration to be associated with the job.
        """
        return pulumi.get(self, "security_configuration")

    @security_configuration.setter
    def security_configuration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_configuration", value)

    @property
    @pulumi.getter(name="sourceControlDetails")
    def source_control_details(self) -> Optional[pulumi.Input['JobSourceControlDetailsArgs']]:
        """
        The details for a source control configuration for a job, allowing synchronization of job artifacts to or from a remote repository. Defined below.
        """
        return pulumi.get(self, "source_control_details")

    @source_control_details.setter
    def source_control_details(self, value: Optional[pulumi.Input['JobSourceControlDetailsArgs']]):
        pulumi.set(self, "source_control_details", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The job timeout in minutes. The default is 2880 minutes (48 hours) for `glueetl` and `pythonshell` jobs, and null (unlimited) for `gluestreaming` jobs.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="workerType")
    def worker_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or G.025X for Spark jobs. Accepts the value Z.2X for Ray jobs.
        * For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
        * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
        * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
        * For the G.4X worker type, each worker maps to 4 DPU (16 vCPUs, 64 GB of memory) with 256GB disk (approximately 235GB free), and provides 1 executor per worker. Recommended for memory-intensive jobs. Only available for Glue version 3.0. Available AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).
        * For the G.8X worker type, each worker maps to 8 DPU (32 vCPUs, 128 GB of memory) with 512GB disk (approximately 487GB free), and provides 1 executor per worker. Recommended for memory-intensive jobs. Only available for Glue version 3.0. Available AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).
        * For the G.025X worker type, each worker maps to 0.25 DPU (2 vCPU, 4GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for low volume streaming jobs. Only available for Glue version 3.0.
        * For the Z.2X worker type, each worker maps to 2 M-DPU (8vCPU, 64 GB of m emory, 128 GB disk), and provides up to 8 Ray workers based on the autoscaler.
        """
        return pulumi.get(self, "worker_type")

    @worker_type.setter
    def worker_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "worker_type", value)


@pulumi.type_token("aws:glue/job:Job")
class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 command: Optional[pulumi.Input[Union['JobCommandArgs', 'JobCommandArgsDict']]] = None,
                 connections: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 execution_class: Optional[pulumi.Input[builtins.str]] = None,
                 execution_property: Optional[pulumi.Input[Union['JobExecutionPropertyArgs', 'JobExecutionPropertyArgsDict']]] = None,
                 glue_version: Optional[pulumi.Input[builtins.str]] = None,
                 job_mode: Optional[pulumi.Input[builtins.str]] = None,
                 job_run_queuing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 max_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 max_retries: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 non_overridable_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 notification_property: Optional[pulumi.Input[Union['JobNotificationPropertyArgs', 'JobNotificationPropertyArgsDict']]] = None,
                 number_of_workers: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 security_configuration: Optional[pulumi.Input[builtins.str]] = None,
                 source_control_details: Optional[pulumi.Input[Union['JobSourceControlDetailsArgs', 'JobSourceControlDetailsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 worker_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Glue Job resource.

        > Glue functionality, such as monitoring and logging of jobs, is typically managed with the `default_arguments` argument. See the [Special Parameters Used by AWS Glue](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html) topic in the Glue developer guide for additional information.

        ## Example Usage

        ### Python Glue Job

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        # IAM role for Glue jobs
        glue_job_role = aws.iam.Role("glue_job_role",
            name="glue-job-role",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "glue.amazonaws.com",
                    },
                }],
            }))
        etl_job = aws.glue.Job("etl_job",
            name="example-etl-job",
            description="An example Glue ETL job",
            role_arn=glue_job_role.arn,
            glue_version="5.0",
            max_retries=0,
            timeout=2880,
            number_of_workers=2,
            worker_type="G.1X",
            connections=[example["name"]],
            execution_class="STANDARD",
            command={
                "script_location": f"s3://{glue_scripts['bucket']}/jobs/etl_job.py",
                "name": "glueetl",
                "python_version": "3",
            },
            notification_property={
                "notify_delay_after": 3,
            },
            default_arguments={
                "--job-language": "python",
                "--continuous-log-logGroup": "/aws-glue/jobs",
                "--enable-continuous-cloudwatch-log": "true",
                "--enable-continuous-log-filter": "true",
                "--enable-metrics": "",
                "--enable-auto-scaling": "true",
            },
            execution_property={
                "max_concurrent_runs": 1,
            },
            tags={
                "ManagedBy": "AWS",
            })
        glue_etl_script = aws.s3.BucketObjectv2("glue_etl_script",
            bucket=glue_scripts["id"],
            key="jobs/etl_job.py",
            source=pulumi.FileAsset("jobs/etl_job.py"))
        ```

        ### Pythonshell Job

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        # IAM role for Glue jobs
        glue_job_role = aws.iam.Role("glue_job_role",
            name="glue-job-role",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "glue.amazonaws.com",
                    },
                }],
            }))
        python_shell_job = aws.glue.Job("python_shell_job",
            name="example-python-shell-job",
            description="An example Python shell job",
            role_arn=glue_job_role.arn,
            max_capacity=0.0625,
            max_retries=0,
            timeout=2880,
            connections=[example["name"]],
            command={
                "script_location": f"s3://{glue_scripts['bucket']}/jobs/shell_job.py",
                "name": "pythonshell",
                "python_version": "3.9",
            },
            default_arguments={
                "--job-language": "python",
                "--continuous-log-logGroup": "/aws-glue/jobs",
                "--enable-continuous-cloudwatch-log": "true",
                "library-set": "analytics",
            },
            execution_property={
                "max_concurrent_runs": 1,
            },
            tags={
                "ManagedBy": "AWS",
            })
        python_shell_script = aws.s3.BucketObjectv2("python_shell_script",
            bucket=glue_scripts["id"],
            key="jobs/shell_job.py",
            source=pulumi.FileAsset("jobs/shell_job.py"))
        ```

        ### Ray Job

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.Job("example",
            name="example",
            role_arn=example_aws_iam_role["arn"],
            glue_version="4.0",
            worker_type="Z.2X",
            command={
                "name": "glueray",
                "python_version": "3.9",
                "runtime": "Ray2.4",
                "script_location": f"s3://{example_aws_s3_bucket['bucket']}/example.py",
            })
        ```

        ### Scala Job

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.Job("example",
            name="example",
            role_arn=example_aws_iam_role["arn"],
            command={
                "script_location": f"s3://{example_aws_s3_bucket['bucket']}/example.scala",
            },
            default_arguments={
                "--job-language": "scala",
            })
        ```

        ### Streaming Job

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.Job("example",
            name="example streaming job",
            role_arn=example_aws_iam_role["arn"],
            command={
                "name": "gluestreaming",
                "script_location": f"s3://{example_aws_s3_bucket['bucket']}/example.script",
            })
        ```

        ### Enabling CloudWatch Logs and Metrics

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudwatch.LogGroup("example",
            name="example",
            retention_in_days=14)
        example_job = aws.glue.Job("example", default_arguments={
            "--continuous-log-logGroup": example.name,
            "--enable-continuous-cloudwatch-log": "true",
            "--enable-continuous-log-filter": "true",
            "--enable-metrics": "",
        })
        ```

        ## Import

        Using `pulumi import`, import Glue Jobs using `name`. For example:

        ```sh
        $ pulumi import aws:glue/job:Job MyJob MyJob
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['JobCommandArgs', 'JobCommandArgsDict']] command: The command of the job. Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] connections: The list of connections used for this job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] default_arguments: The map of default arguments for this job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes. For information about how to specify and consume your own Job arguments, see the [Calling AWS Glue APIs in Python](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html) topic in the developer guide. For information about the key-value pairs that AWS Glue consumes to set up your job, see the [Special Parameters Used by AWS Glue](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html) topic in the developer guide.
        :param pulumi.Input[builtins.str] description: Description of the job.
        :param pulumi.Input[builtins.str] execution_class: Indicates whether the job is run with a standard or flexible execution class. The standard execution class is ideal for time-sensitive workloads that require fast job startup and dedicated resources. Valid value: `FLEX`, `STANDARD`.
        :param pulumi.Input[Union['JobExecutionPropertyArgs', 'JobExecutionPropertyArgsDict']] execution_property: Execution property of the job. Defined below.
        :param pulumi.Input[builtins.str] glue_version: The version of glue to use, for example "1.0". Ray jobs should set this to 4.0 or greater. For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
        :param pulumi.Input[builtins.str] job_mode: Describes how a job was created. Valid values are `SCRIPT`, `NOTEBOOK` and `VISUAL`.
        :param pulumi.Input[builtins.bool] job_run_queuing_enabled: Specifies whether job run queuing is enabled for the job runs for this job. A value of true means job run queuing is enabled for the job runs. If false or not populated, the job runs will not be considered for queueing.
        :param pulumi.Input[builtins.str] maintenance_window: Specifies the day of the week and hour for the maintenance window for streaming jobs.
        :param pulumi.Input[builtins.float] max_capacity: The maximum number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. `Required` when `pythonshell` is set, accept either `0.0625` or `1.0`. Use `number_of_workers` and `worker_type` arguments instead with `glue_version` `2.0` and above.
        :param pulumi.Input[builtins.int] max_retries: The maximum number of times to retry this job if it fails.
        :param pulumi.Input[builtins.str] name: The name you assign to this job. It must be unique in your account.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] non_overridable_arguments: Non-overridable arguments for this job, specified as name-value pairs.
        :param pulumi.Input[Union['JobNotificationPropertyArgs', 'JobNotificationPropertyArgsDict']] notification_property: Notification property of the job. Defined below.
        :param pulumi.Input[builtins.int] number_of_workers: The number of workers of a defined workerType that are allocated when a job runs.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] role_arn: The ARN of the IAM role associated with this job.
        :param pulumi.Input[builtins.str] security_configuration: The name of the Security Configuration to be associated with the job.
        :param pulumi.Input[Union['JobSourceControlDetailsArgs', 'JobSourceControlDetailsArgsDict']] source_control_details: The details for a source control configuration for a job, allowing synchronization of job artifacts to or from a remote repository. Defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.int] timeout: The job timeout in minutes. The default is 2880 minutes (48 hours) for `glueetl` and `pythonshell` jobs, and null (unlimited) for `gluestreaming` jobs.
        :param pulumi.Input[builtins.str] worker_type: The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or G.025X for Spark jobs. Accepts the value Z.2X for Ray jobs.
               * For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
               * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
               * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
               * For the G.4X worker type, each worker maps to 4 DPU (16 vCPUs, 64 GB of memory) with 256GB disk (approximately 235GB free), and provides 1 executor per worker. Recommended for memory-intensive jobs. Only available for Glue version 3.0. Available AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).
               * For the G.8X worker type, each worker maps to 8 DPU (32 vCPUs, 128 GB of memory) with 512GB disk (approximately 487GB free), and provides 1 executor per worker. Recommended for memory-intensive jobs. Only available for Glue version 3.0. Available AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).
               * For the G.025X worker type, each worker maps to 0.25 DPU (2 vCPU, 4GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for low volume streaming jobs. Only available for Glue version 3.0.
               * For the Z.2X worker type, each worker maps to 2 M-DPU (8vCPU, 64 GB of m emory, 128 GB disk), and provides up to 8 Ray workers based on the autoscaler.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Glue Job resource.

        > Glue functionality, such as monitoring and logging of jobs, is typically managed with the `default_arguments` argument. See the [Special Parameters Used by AWS Glue](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html) topic in the Glue developer guide for additional information.

        ## Example Usage

        ### Python Glue Job

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        # IAM role for Glue jobs
        glue_job_role = aws.iam.Role("glue_job_role",
            name="glue-job-role",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "glue.amazonaws.com",
                    },
                }],
            }))
        etl_job = aws.glue.Job("etl_job",
            name="example-etl-job",
            description="An example Glue ETL job",
            role_arn=glue_job_role.arn,
            glue_version="5.0",
            max_retries=0,
            timeout=2880,
            number_of_workers=2,
            worker_type="G.1X",
            connections=[example["name"]],
            execution_class="STANDARD",
            command={
                "script_location": f"s3://{glue_scripts['bucket']}/jobs/etl_job.py",
                "name": "glueetl",
                "python_version": "3",
            },
            notification_property={
                "notify_delay_after": 3,
            },
            default_arguments={
                "--job-language": "python",
                "--continuous-log-logGroup": "/aws-glue/jobs",
                "--enable-continuous-cloudwatch-log": "true",
                "--enable-continuous-log-filter": "true",
                "--enable-metrics": "",
                "--enable-auto-scaling": "true",
            },
            execution_property={
                "max_concurrent_runs": 1,
            },
            tags={
                "ManagedBy": "AWS",
            })
        glue_etl_script = aws.s3.BucketObjectv2("glue_etl_script",
            bucket=glue_scripts["id"],
            key="jobs/etl_job.py",
            source=pulumi.FileAsset("jobs/etl_job.py"))
        ```

        ### Pythonshell Job

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        # IAM role for Glue jobs
        glue_job_role = aws.iam.Role("glue_job_role",
            name="glue-job-role",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "glue.amazonaws.com",
                    },
                }],
            }))
        python_shell_job = aws.glue.Job("python_shell_job",
            name="example-python-shell-job",
            description="An example Python shell job",
            role_arn=glue_job_role.arn,
            max_capacity=0.0625,
            max_retries=0,
            timeout=2880,
            connections=[example["name"]],
            command={
                "script_location": f"s3://{glue_scripts['bucket']}/jobs/shell_job.py",
                "name": "pythonshell",
                "python_version": "3.9",
            },
            default_arguments={
                "--job-language": "python",
                "--continuous-log-logGroup": "/aws-glue/jobs",
                "--enable-continuous-cloudwatch-log": "true",
                "library-set": "analytics",
            },
            execution_property={
                "max_concurrent_runs": 1,
            },
            tags={
                "ManagedBy": "AWS",
            })
        python_shell_script = aws.s3.BucketObjectv2("python_shell_script",
            bucket=glue_scripts["id"],
            key="jobs/shell_job.py",
            source=pulumi.FileAsset("jobs/shell_job.py"))
        ```

        ### Ray Job

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.Job("example",
            name="example",
            role_arn=example_aws_iam_role["arn"],
            glue_version="4.0",
            worker_type="Z.2X",
            command={
                "name": "glueray",
                "python_version": "3.9",
                "runtime": "Ray2.4",
                "script_location": f"s3://{example_aws_s3_bucket['bucket']}/example.py",
            })
        ```

        ### Scala Job

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.Job("example",
            name="example",
            role_arn=example_aws_iam_role["arn"],
            command={
                "script_location": f"s3://{example_aws_s3_bucket['bucket']}/example.scala",
            },
            default_arguments={
                "--job-language": "scala",
            })
        ```

        ### Streaming Job

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.Job("example",
            name="example streaming job",
            role_arn=example_aws_iam_role["arn"],
            command={
                "name": "gluestreaming",
                "script_location": f"s3://{example_aws_s3_bucket['bucket']}/example.script",
            })
        ```

        ### Enabling CloudWatch Logs and Metrics

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudwatch.LogGroup("example",
            name="example",
            retention_in_days=14)
        example_job = aws.glue.Job("example", default_arguments={
            "--continuous-log-logGroup": example.name,
            "--enable-continuous-cloudwatch-log": "true",
            "--enable-continuous-log-filter": "true",
            "--enable-metrics": "",
        })
        ```

        ## Import

        Using `pulumi import`, import Glue Jobs using `name`. For example:

        ```sh
        $ pulumi import aws:glue/job:Job MyJob MyJob
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 command: Optional[pulumi.Input[Union['JobCommandArgs', 'JobCommandArgsDict']]] = None,
                 connections: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 execution_class: Optional[pulumi.Input[builtins.str]] = None,
                 execution_property: Optional[pulumi.Input[Union['JobExecutionPropertyArgs', 'JobExecutionPropertyArgsDict']]] = None,
                 glue_version: Optional[pulumi.Input[builtins.str]] = None,
                 job_mode: Optional[pulumi.Input[builtins.str]] = None,
                 job_run_queuing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 max_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 max_retries: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 non_overridable_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 notification_property: Optional[pulumi.Input[Union['JobNotificationPropertyArgs', 'JobNotificationPropertyArgsDict']]] = None,
                 number_of_workers: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 security_configuration: Optional[pulumi.Input[builtins.str]] = None,
                 source_control_details: Optional[pulumi.Input[Union['JobSourceControlDetailsArgs', 'JobSourceControlDetailsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 worker_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            if command is None and not opts.urn:
                raise TypeError("Missing required property 'command'")
            __props__.__dict__["command"] = command
            __props__.__dict__["connections"] = connections
            __props__.__dict__["default_arguments"] = default_arguments
            __props__.__dict__["description"] = description
            __props__.__dict__["execution_class"] = execution_class
            __props__.__dict__["execution_property"] = execution_property
            __props__.__dict__["glue_version"] = glue_version
            __props__.__dict__["job_mode"] = job_mode
            __props__.__dict__["job_run_queuing_enabled"] = job_run_queuing_enabled
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["max_capacity"] = max_capacity
            __props__.__dict__["max_retries"] = max_retries
            __props__.__dict__["name"] = name
            __props__.__dict__["non_overridable_arguments"] = non_overridable_arguments
            __props__.__dict__["notification_property"] = notification_property
            __props__.__dict__["number_of_workers"] = number_of_workers
            __props__.__dict__["region"] = region
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["security_configuration"] = security_configuration
            __props__.__dict__["source_control_details"] = source_control_details
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["worker_type"] = worker_type
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Job, __self__).__init__(
            'aws:glue/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            command: Optional[pulumi.Input[Union['JobCommandArgs', 'JobCommandArgsDict']]] = None,
            connections: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            default_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            execution_class: Optional[pulumi.Input[builtins.str]] = None,
            execution_property: Optional[pulumi.Input[Union['JobExecutionPropertyArgs', 'JobExecutionPropertyArgsDict']]] = None,
            glue_version: Optional[pulumi.Input[builtins.str]] = None,
            job_mode: Optional[pulumi.Input[builtins.str]] = None,
            job_run_queuing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
            max_capacity: Optional[pulumi.Input[builtins.float]] = None,
            max_retries: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            non_overridable_arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            notification_property: Optional[pulumi.Input[Union['JobNotificationPropertyArgs', 'JobNotificationPropertyArgsDict']]] = None,
            number_of_workers: Optional[pulumi.Input[builtins.int]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            role_arn: Optional[pulumi.Input[builtins.str]] = None,
            security_configuration: Optional[pulumi.Input[builtins.str]] = None,
            source_control_details: Optional[pulumi.Input[Union['JobSourceControlDetailsArgs', 'JobSourceControlDetailsArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeout: Optional[pulumi.Input[builtins.int]] = None,
            worker_type: Optional[pulumi.Input[builtins.str]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) of Glue Job
        :param pulumi.Input[Union['JobCommandArgs', 'JobCommandArgsDict']] command: The command of the job. Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] connections: The list of connections used for this job.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] default_arguments: The map of default arguments for this job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes. For information about how to specify and consume your own Job arguments, see the [Calling AWS Glue APIs in Python](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html) topic in the developer guide. For information about the key-value pairs that AWS Glue consumes to set up your job, see the [Special Parameters Used by AWS Glue](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html) topic in the developer guide.
        :param pulumi.Input[builtins.str] description: Description of the job.
        :param pulumi.Input[builtins.str] execution_class: Indicates whether the job is run with a standard or flexible execution class. The standard execution class is ideal for time-sensitive workloads that require fast job startup and dedicated resources. Valid value: `FLEX`, `STANDARD`.
        :param pulumi.Input[Union['JobExecutionPropertyArgs', 'JobExecutionPropertyArgsDict']] execution_property: Execution property of the job. Defined below.
        :param pulumi.Input[builtins.str] glue_version: The version of glue to use, for example "1.0". Ray jobs should set this to 4.0 or greater. For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
        :param pulumi.Input[builtins.str] job_mode: Describes how a job was created. Valid values are `SCRIPT`, `NOTEBOOK` and `VISUAL`.
        :param pulumi.Input[builtins.bool] job_run_queuing_enabled: Specifies whether job run queuing is enabled for the job runs for this job. A value of true means job run queuing is enabled for the job runs. If false or not populated, the job runs will not be considered for queueing.
        :param pulumi.Input[builtins.str] maintenance_window: Specifies the day of the week and hour for the maintenance window for streaming jobs.
        :param pulumi.Input[builtins.float] max_capacity: The maximum number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. `Required` when `pythonshell` is set, accept either `0.0625` or `1.0`. Use `number_of_workers` and `worker_type` arguments instead with `glue_version` `2.0` and above.
        :param pulumi.Input[builtins.int] max_retries: The maximum number of times to retry this job if it fails.
        :param pulumi.Input[builtins.str] name: The name you assign to this job. It must be unique in your account.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] non_overridable_arguments: Non-overridable arguments for this job, specified as name-value pairs.
        :param pulumi.Input[Union['JobNotificationPropertyArgs', 'JobNotificationPropertyArgsDict']] notification_property: Notification property of the job. Defined below.
        :param pulumi.Input[builtins.int] number_of_workers: The number of workers of a defined workerType that are allocated when a job runs.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] role_arn: The ARN of the IAM role associated with this job.
        :param pulumi.Input[builtins.str] security_configuration: The name of the Security Configuration to be associated with the job.
        :param pulumi.Input[Union['JobSourceControlDetailsArgs', 'JobSourceControlDetailsArgsDict']] source_control_details: The details for a source control configuration for a job, allowing synchronization of job artifacts to or from a remote repository. Defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.int] timeout: The job timeout in minutes. The default is 2880 minutes (48 hours) for `glueetl` and `pythonshell` jobs, and null (unlimited) for `gluestreaming` jobs.
        :param pulumi.Input[builtins.str] worker_type: The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or G.025X for Spark jobs. Accepts the value Z.2X for Ray jobs.
               * For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
               * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
               * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
               * For the G.4X worker type, each worker maps to 4 DPU (16 vCPUs, 64 GB of memory) with 256GB disk (approximately 235GB free), and provides 1 executor per worker. Recommended for memory-intensive jobs. Only available for Glue version 3.0. Available AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).
               * For the G.8X worker type, each worker maps to 8 DPU (32 vCPUs, 128 GB of memory) with 512GB disk (approximately 487GB free), and provides 1 executor per worker. Recommended for memory-intensive jobs. Only available for Glue version 3.0. Available AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).
               * For the G.025X worker type, each worker maps to 0.25 DPU (2 vCPU, 4GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for low volume streaming jobs. Only available for Glue version 3.0.
               * For the Z.2X worker type, each worker maps to 2 M-DPU (8vCPU, 64 GB of m emory, 128 GB disk), and provides up to 8 Ray workers based on the autoscaler.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["command"] = command
        __props__.__dict__["connections"] = connections
        __props__.__dict__["default_arguments"] = default_arguments
        __props__.__dict__["description"] = description
        __props__.__dict__["execution_class"] = execution_class
        __props__.__dict__["execution_property"] = execution_property
        __props__.__dict__["glue_version"] = glue_version
        __props__.__dict__["job_mode"] = job_mode
        __props__.__dict__["job_run_queuing_enabled"] = job_run_queuing_enabled
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["max_capacity"] = max_capacity
        __props__.__dict__["max_retries"] = max_retries
        __props__.__dict__["name"] = name
        __props__.__dict__["non_overridable_arguments"] = non_overridable_arguments
        __props__.__dict__["notification_property"] = notification_property
        __props__.__dict__["number_of_workers"] = number_of_workers
        __props__.__dict__["region"] = region
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["security_configuration"] = security_configuration
        __props__.__dict__["source_control_details"] = source_control_details
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["worker_type"] = worker_type
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of Glue Job
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def command(self) -> pulumi.Output['outputs.JobCommand']:
        """
        The command of the job. Defined below.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def connections(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of connections used for this job.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter(name="defaultArguments")
    def default_arguments(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The map of default arguments for this job. You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes. For information about how to specify and consume your own Job arguments, see the [Calling AWS Glue APIs in Python](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html) topic in the developer guide. For information about the key-value pairs that AWS Glue consumes to set up your job, see the [Special Parameters Used by AWS Glue](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html) topic in the developer guide.
        """
        return pulumi.get(self, "default_arguments")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the job.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executionClass")
    def execution_class(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Indicates whether the job is run with a standard or flexible execution class. The standard execution class is ideal for time-sensitive workloads that require fast job startup and dedicated resources. Valid value: `FLEX`, `STANDARD`.
        """
        return pulumi.get(self, "execution_class")

    @property
    @pulumi.getter(name="executionProperty")
    def execution_property(self) -> pulumi.Output['outputs.JobExecutionProperty']:
        """
        Execution property of the job. Defined below.
        """
        return pulumi.get(self, "execution_property")

    @property
    @pulumi.getter(name="glueVersion")
    def glue_version(self) -> pulumi.Output[builtins.str]:
        """
        The version of glue to use, for example "1.0". Ray jobs should set this to 4.0 or greater. For information about available versions, see the [AWS Glue Release Notes](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html).
        """
        return pulumi.get(self, "glue_version")

    @property
    @pulumi.getter(name="jobMode")
    def job_mode(self) -> pulumi.Output[builtins.str]:
        """
        Describes how a job was created. Valid values are `SCRIPT`, `NOTEBOOK` and `VISUAL`.
        """
        return pulumi.get(self, "job_mode")

    @property
    @pulumi.getter(name="jobRunQueuingEnabled")
    def job_run_queuing_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether job run queuing is enabled for the job runs for this job. A value of true means job run queuing is enabled for the job runs. If false or not populated, the job runs will not be considered for queueing.
        """
        return pulumi.get(self, "job_run_queuing_enabled")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the day of the week and hour for the maintenance window for streaming jobs.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Output[builtins.float]:
        """
        The maximum number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. `Required` when `pythonshell` is set, accept either `0.0625` or `1.0`. Use `number_of_workers` and `worker_type` arguments instead with `glue_version` `2.0` and above.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum number of times to retry this job if it fails.
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name you assign to this job. It must be unique in your account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nonOverridableArguments")
    def non_overridable_arguments(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Non-overridable arguments for this job, specified as name-value pairs.
        """
        return pulumi.get(self, "non_overridable_arguments")

    @property
    @pulumi.getter(name="notificationProperty")
    def notification_property(self) -> pulumi.Output['outputs.JobNotificationProperty']:
        """
        Notification property of the job. Defined below.
        """
        return pulumi.get(self, "notification_property")

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> pulumi.Output[builtins.int]:
        """
        The number of workers of a defined workerType that are allocated when a job runs.
        """
        return pulumi.get(self, "number_of_workers")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the IAM role associated with this job.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the Security Configuration to be associated with the job.
        """
        return pulumi.get(self, "security_configuration")

    @property
    @pulumi.getter(name="sourceControlDetails")
    def source_control_details(self) -> pulumi.Output[Optional['outputs.JobSourceControlDetails']]:
        """
        The details for a source control configuration for a job, allowing synchronization of job artifacts to or from a remote repository. Defined below.
        """
        return pulumi.get(self, "source_control_details")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[builtins.int]:
        """
        The job timeout in minutes. The default is 2880 minutes (48 hours) for `glueetl` and `pythonshell` jobs, and null (unlimited) for `gluestreaming` jobs.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="workerType")
    def worker_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, G.2X, or G.025X for Spark jobs. Accepts the value Z.2X for Ray jobs.
        * For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
        * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
        * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. Recommended for memory-intensive jobs.
        * For the G.4X worker type, each worker maps to 4 DPU (16 vCPUs, 64 GB of memory) with 256GB disk (approximately 235GB free), and provides 1 executor per worker. Recommended for memory-intensive jobs. Only available for Glue version 3.0. Available AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).
        * For the G.8X worker type, each worker maps to 8 DPU (32 vCPUs, 128 GB of memory) with 512GB disk (approximately 487GB free), and provides 1 executor per worker. Recommended for memory-intensive jobs. Only available for Glue version 3.0. Available AWS Regions: US East (Ohio), US East (N. Virginia), US West (Oregon), Asia Pacific (Singapore), Asia Pacific (Sydney), Asia Pacific (Tokyo), Canada (Central), Europe (Frankfurt), Europe (Ireland), and Europe (Stockholm).
        * For the G.025X worker type, each worker maps to 0.25 DPU (2 vCPU, 4GB of memory, 64 GB disk), and provides 1 executor per worker. Recommended for low volume streaming jobs. Only available for Glue version 3.0.
        * For the Z.2X worker type, each worker maps to 2 M-DPU (8vCPU, 64 GB of m emory, 128 GB disk), and provides up to 8 Ray workers based on the autoscaler.
        """
        return pulumi.get(self, "worker_type")

