# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkspaceApiKeyArgs', 'WorkspaceApiKey']

@pulumi.input_type
class WorkspaceApiKeyArgs:
    def __init__(__self__, *,
                 key_name: pulumi.Input[builtins.str],
                 key_role: pulumi.Input[builtins.str],
                 seconds_to_live: pulumi.Input[builtins.int],
                 workspace_id: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a WorkspaceApiKey resource.
        :param pulumi.Input[builtins.str] key_name: Specifies the name of the API key. Key names must be unique to the workspace.
        :param pulumi.Input[builtins.str] key_role: Specifies the permission level of the API key. Valid values are `VIEWER`, `EDITOR`, or `ADMIN`.
        :param pulumi.Input[builtins.int] seconds_to_live: Specifies the time in seconds until the API key expires. Keys can be valid for up to 30 days.
        :param pulumi.Input[builtins.str] workspace_id: The ID of the workspace that the API key is valid for.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "key_role", key_role)
        pulumi.set(__self__, "seconds_to_live", seconds_to_live)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the API key. Key names must be unique to the workspace.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="keyRole")
    def key_role(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the permission level of the API key. Valid values are `VIEWER`, `EDITOR`, or `ADMIN`.
        """
        return pulumi.get(self, "key_role")

    @key_role.setter
    def key_role(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_role", value)

    @property
    @pulumi.getter(name="secondsToLive")
    def seconds_to_live(self) -> pulumi.Input[builtins.int]:
        """
        Specifies the time in seconds until the API key expires. Keys can be valid for up to 30 days.
        """
        return pulumi.get(self, "seconds_to_live")

    @seconds_to_live.setter
    def seconds_to_live(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "seconds_to_live", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the workspace that the API key is valid for.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _WorkspaceApiKeyState:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 key_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_role: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 seconds_to_live: Optional[pulumi.Input[builtins.int]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceApiKey resources.
        :param pulumi.Input[builtins.str] key: The key token in JSON format. Use this value as a bearer token to authenticate HTTP requests to the workspace.
        :param pulumi.Input[builtins.str] key_name: Specifies the name of the API key. Key names must be unique to the workspace.
        :param pulumi.Input[builtins.str] key_role: Specifies the permission level of the API key. Valid values are `VIEWER`, `EDITOR`, or `ADMIN`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] seconds_to_live: Specifies the time in seconds until the API key expires. Keys can be valid for up to 30 days.
        :param pulumi.Input[builtins.str] workspace_id: The ID of the workspace that the API key is valid for.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_role is not None:
            pulumi.set(__self__, "key_role", key_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if seconds_to_live is not None:
            pulumi.set(__self__, "seconds_to_live", seconds_to_live)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key token in JSON format. Use this value as a bearer token to authenticate HTTP requests to the workspace.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the API key. Key names must be unique to the workspace.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="keyRole")
    def key_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the permission level of the API key. Valid values are `VIEWER`, `EDITOR`, or `ADMIN`.
        """
        return pulumi.get(self, "key_role")

    @key_role.setter
    def key_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_role", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secondsToLive")
    def seconds_to_live(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the time in seconds until the API key expires. Keys can be valid for up to 30 days.
        """
        return pulumi.get(self, "seconds_to_live")

    @seconds_to_live.setter
    def seconds_to_live(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "seconds_to_live", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the workspace that the API key is valid for.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("aws:grafana/workspaceApiKey:WorkspaceApiKey")
class WorkspaceApiKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_role: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 seconds_to_live: Optional[pulumi.Input[builtins.int]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides an Amazon Managed Grafana workspace API Key resource.

        ## Example Usage

        ### Basic configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        key = aws.grafana.WorkspaceApiKey("key",
            key_name="test-key",
            key_role="VIEWER",
            seconds_to_live=3600,
            workspace_id=test["id"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] key_name: Specifies the name of the API key. Key names must be unique to the workspace.
        :param pulumi.Input[builtins.str] key_role: Specifies the permission level of the API key. Valid values are `VIEWER`, `EDITOR`, or `ADMIN`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] seconds_to_live: Specifies the time in seconds until the API key expires. Keys can be valid for up to 30 days.
        :param pulumi.Input[builtins.str] workspace_id: The ID of the workspace that the API key is valid for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceApiKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Amazon Managed Grafana workspace API Key resource.

        ## Example Usage

        ### Basic configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        key = aws.grafana.WorkspaceApiKey("key",
            key_name="test-key",
            key_role="VIEWER",
            seconds_to_live=3600,
            workspace_id=test["id"])
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceApiKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceApiKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_role: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 seconds_to_live: Optional[pulumi.Input[builtins.int]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceApiKeyArgs.__new__(WorkspaceApiKeyArgs)

            if key_name is None and not opts.urn:
                raise TypeError("Missing required property 'key_name'")
            __props__.__dict__["key_name"] = key_name
            if key_role is None and not opts.urn:
                raise TypeError("Missing required property 'key_role'")
            __props__.__dict__["key_role"] = key_role
            __props__.__dict__["region"] = region
            if seconds_to_live is None and not opts.urn:
                raise TypeError("Missing required property 'seconds_to_live'")
            __props__.__dict__["seconds_to_live"] = seconds_to_live
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["key"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(WorkspaceApiKey, __self__).__init__(
            'aws:grafana/workspaceApiKey:WorkspaceApiKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            key_name: Optional[pulumi.Input[builtins.str]] = None,
            key_role: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            seconds_to_live: Optional[pulumi.Input[builtins.int]] = None,
            workspace_id: Optional[pulumi.Input[builtins.str]] = None) -> 'WorkspaceApiKey':
        """
        Get an existing WorkspaceApiKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] key: The key token in JSON format. Use this value as a bearer token to authenticate HTTP requests to the workspace.
        :param pulumi.Input[builtins.str] key_name: Specifies the name of the API key. Key names must be unique to the workspace.
        :param pulumi.Input[builtins.str] key_role: Specifies the permission level of the API key. Valid values are `VIEWER`, `EDITOR`, or `ADMIN`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] seconds_to_live: Specifies the time in seconds until the API key expires. Keys can be valid for up to 30 days.
        :param pulumi.Input[builtins.str] workspace_id: The ID of the workspace that the API key is valid for.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceApiKeyState.__new__(_WorkspaceApiKeyState)

        __props__.__dict__["key"] = key
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["key_role"] = key_role
        __props__.__dict__["region"] = region
        __props__.__dict__["seconds_to_live"] = seconds_to_live
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceApiKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        The key token in JSON format. Use this value as a bearer token to authenticate HTTP requests to the workspace.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the API key. Key names must be unique to the workspace.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyRole")
    def key_role(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the permission level of the API key. Valid values are `VIEWER`, `EDITOR`, or `ADMIN`.
        """
        return pulumi.get(self, "key_role")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secondsToLive")
    def seconds_to_live(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the time in seconds until the API key expires. Keys can be valid for up to 30 days.
        """
        return pulumi.get(self, "seconds_to_live")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the workspace that the API key is valid for.
        """
        return pulumi.get(self, "workspace_id")

