# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPolicyResult',
    'AwaitableGetPolicyResult',
    'get_policy',
    'get_policy_output',
]

@pulumi.output_type
class GetPolicyResult:
    """
    A collection of values returned by getPolicy.
    """
    def __init__(__self__, arn=None, attachment_count=None, description=None, id=None, name=None, path=None, path_prefix=None, policy=None, policy_id=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if attachment_count and not isinstance(attachment_count, int):
            raise TypeError("Expected argument 'attachment_count' to be a int")
        pulumi.set(__self__, "attachment_count", attachment_count)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if path_prefix and not isinstance(path_prefix, str):
            raise TypeError("Expected argument 'path_prefix' to be a str")
        pulumi.set(__self__, "path_prefix", path_prefix)
        if policy and not isinstance(policy, str):
            raise TypeError("Expected argument 'policy' to be a str")
        pulumi.set(__self__, "policy", policy)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the policy.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="attachmentCount")
    def attachment_count(self) -> builtins.int:
        """
        Number of entities (users, groups, and roles) that the policy is attached to.
        """
        return pulumi.get(self, "attachment_count")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        Path to the policy.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="pathPrefix")
    def path_prefix(self) -> Optional[builtins.str]:
        return pulumi.get(self, "path_prefix")

    @property
    @pulumi.getter
    def policy(self) -> builtins.str:
        """
        Policy document of the policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> builtins.str:
        """
        Policy's ID.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Key-value mapping of tags for the IAM Policy.
        """
        return pulumi.get(self, "tags")


class AwaitableGetPolicyResult(GetPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPolicyResult(
            arn=self.arn,
            attachment_count=self.attachment_count,
            description=self.description,
            id=self.id,
            name=self.name,
            path=self.path,
            path_prefix=self.path_prefix,
            policy=self.policy,
            policy_id=self.policy_id,
            tags=self.tags)


def get_policy(arn: Optional[builtins.str] = None,
               name: Optional[builtins.str] = None,
               path_prefix: Optional[builtins.str] = None,
               tags: Optional[Mapping[str, builtins.str]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPolicyResult:
    """
    This data source can be used to fetch information about a specific
    IAM policy.

    ## Example Usage

    ### By ARN

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.iam.get_policy(arn="arn:aws:iam::123456789012:policy/UsersManageOwnCredentials")
    ```

    ### By Name

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.iam.get_policy(name="test_policy")
    ```


    :param builtins.str arn: ARN of the IAM policy.
           Conflicts with `name` and `path_prefix`.
    :param builtins.str name: Name of the IAM policy.
           Conflicts with `arn`.
    :param builtins.str path_prefix: Prefix of the path to the IAM policy.
           Defaults to a slash (`/`).
           Conflicts with `arn`.
    :param Mapping[str, builtins.str] tags: Key-value mapping of tags for the IAM Policy.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['name'] = name
    __args__['pathPrefix'] = path_prefix
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:iam/getPolicy:getPolicy', __args__, opts=opts, typ=GetPolicyResult).value

    return AwaitableGetPolicyResult(
        arn=pulumi.get(__ret__, 'arn'),
        attachment_count=pulumi.get(__ret__, 'attachment_count'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        path=pulumi.get(__ret__, 'path'),
        path_prefix=pulumi.get(__ret__, 'path_prefix'),
        policy=pulumi.get(__ret__, 'policy'),
        policy_id=pulumi.get(__ret__, 'policy_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_policy_output(arn: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      path_prefix: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                      tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPolicyResult]:
    """
    This data source can be used to fetch information about a specific
    IAM policy.

    ## Example Usage

    ### By ARN

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.iam.get_policy(arn="arn:aws:iam::123456789012:policy/UsersManageOwnCredentials")
    ```

    ### By Name

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.iam.get_policy(name="test_policy")
    ```


    :param builtins.str arn: ARN of the IAM policy.
           Conflicts with `name` and `path_prefix`.
    :param builtins.str name: Name of the IAM policy.
           Conflicts with `arn`.
    :param builtins.str path_prefix: Prefix of the path to the IAM policy.
           Defaults to a slash (`/`).
           Conflicts with `arn`.
    :param Mapping[str, builtins.str] tags: Key-value mapping of tags for the IAM Policy.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['name'] = name
    __args__['pathPrefix'] = path_prefix
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:iam/getPolicy:getPolicy', __args__, opts=opts, typ=GetPolicyResult)
    return __ret__.apply(lambda __response__: GetPolicyResult(
        arn=pulumi.get(__response__, 'arn'),
        attachment_count=pulumi.get(__response__, 'attachment_count'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        path=pulumi.get(__response__, 'path'),
        path_prefix=pulumi.get(__response__, 'path_prefix'),
        policy=pulumi.get(__response__, 'policy'),
        policy_id=pulumi.get(__response__, 'policy_id'),
        tags=pulumi.get(__response__, 'tags')))
