# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PolicyAttachmentArgs', 'PolicyAttachment']

@pulumi.input_type
class PolicyAttachmentArgs:
    def __init__(__self__, *,
                 policy_arn: pulumi.Input[builtins.str],
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a PolicyAttachment resource.
        :param pulumi.Input[builtins.str] policy_arn: ARN of the policy you want to apply. Typically this should be a reference to the ARN of another resource to ensure dependency ordering, such as `aws_iam_policy.example.arn`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] groups: Group(s) the policy should be applied to.
        :param pulumi.Input[builtins.str] name: Name of the attachment. This cannot be an empty string.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] roles: Role(s) the policy should be applied to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] users: User(s) the policy should be applied to.
        """
        pulumi.set(__self__, "policy_arn", policy_arn)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the policy you want to apply. Typically this should be a reference to the ARN of another resource to ensure dependency ordering, such as `aws_iam_policy.example.arn`.
        """
        return pulumi.get(self, "policy_arn")

    @policy_arn.setter
    def policy_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "policy_arn", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Group(s) the policy should be applied to.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the attachment. This cannot be an empty string.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Role(s) the policy should be applied to.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        User(s) the policy should be applied to.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _PolicyAttachmentState:
    def __init__(__self__, *,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_arn: Optional[pulumi.Input[builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering PolicyAttachment resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] groups: Group(s) the policy should be applied to.
        :param pulumi.Input[builtins.str] name: Name of the attachment. This cannot be an empty string.
        :param pulumi.Input[builtins.str] policy_arn: ARN of the policy you want to apply. Typically this should be a reference to the ARN of another resource to ensure dependency ordering, such as `aws_iam_policy.example.arn`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] roles: Role(s) the policy should be applied to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] users: User(s) the policy should be applied to.
        """
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_arn is not None:
            pulumi.set(__self__, "policy_arn", policy_arn)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Group(s) the policy should be applied to.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the attachment. This cannot be an empty string.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the policy you want to apply. Typically this should be a reference to the ARN of another resource to ensure dependency ordering, such as `aws_iam_policy.example.arn`.
        """
        return pulumi.get(self, "policy_arn")

    @policy_arn.setter
    def policy_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_arn", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Role(s) the policy should be applied to.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        User(s) the policy should be applied to.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "users", value)


@pulumi.type_token("aws:iam/policyAttachment:PolicyAttachment")
class PolicyAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_arn: Optional[pulumi.Input[builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Attaches a Managed IAM Policy to user(s), role(s), and/or group(s)

        !> **WARNING:** The iam.PolicyAttachment resource creates **exclusive** attachments of IAM policies. Across the entire AWS account, all of the users/roles/groups to which a single policy is attached must be declared by a single iam.PolicyAttachment resource. This means that even any users/roles/groups that have the attached policy via any other mechanism (including other resources managed by this provider) will have that attached policy revoked by this resource. Consider `iam.RolePolicyAttachment`, `iam.UserPolicyAttachment`, or `iam.GroupPolicyAttachment` instead. These resources do not enforce exclusive attachment of an IAM policy.

        > **NOTE:** The usage of this resource conflicts with the `iam.GroupPolicyAttachment`, `iam.RolePolicyAttachment`, and `iam.UserPolicyAttachment` resources and will permanently show a difference if both are defined.

        > **NOTE:** For a given role, this resource is incompatible with using the `iam.Role` resource `managed_policy_arns` argument. When using that argument and this resource, both will attempt to manage the role's managed policy attachments and the provider will show a permanent difference.

        > **NOTE:** To ensure Pulumi correctly manages dependencies during updates, use a reference to the IAM resource when defining the `policy_arn` for `iam.PolicyAttachment`, rather than constructing the ARN directly. For example, use `policy_arn = aws_iam_policy.example.arn` instead of `policy_arn = "arn:aws:iam::${data.aws_caller_identity.current.account_id}:policy/Example"`. Failing to do so may lead to errors like `DeleteConflict: Cannot delete a policy attached to entities` or `NoSuchEntity`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        user = aws.iam.User("user", name="test-user")
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["ec2.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        role = aws.iam.Role("role",
            name="test-role",
            assume_role_policy=assume_role.json)
        group = aws.iam.Group("group", name="test-group")
        policy = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "actions": ["ec2:Describe*"],
            "resources": ["*"],
        }])
        policy_policy = aws.iam.Policy("policy",
            name="test-policy",
            description="A test policy",
            policy=policy.json)
        test_attach = aws.iam.PolicyAttachment("test-attach",
            name="test-attachment",
            users=[user.name],
            roles=[role.name],
            groups=[group.name],
            policy_arn=policy_policy.arn)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] groups: Group(s) the policy should be applied to.
        :param pulumi.Input[builtins.str] name: Name of the attachment. This cannot be an empty string.
        :param pulumi.Input[builtins.str] policy_arn: ARN of the policy you want to apply. Typically this should be a reference to the ARN of another resource to ensure dependency ordering, such as `aws_iam_policy.example.arn`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] roles: Role(s) the policy should be applied to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] users: User(s) the policy should be applied to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Attaches a Managed IAM Policy to user(s), role(s), and/or group(s)

        !> **WARNING:** The iam.PolicyAttachment resource creates **exclusive** attachments of IAM policies. Across the entire AWS account, all of the users/roles/groups to which a single policy is attached must be declared by a single iam.PolicyAttachment resource. This means that even any users/roles/groups that have the attached policy via any other mechanism (including other resources managed by this provider) will have that attached policy revoked by this resource. Consider `iam.RolePolicyAttachment`, `iam.UserPolicyAttachment`, or `iam.GroupPolicyAttachment` instead. These resources do not enforce exclusive attachment of an IAM policy.

        > **NOTE:** The usage of this resource conflicts with the `iam.GroupPolicyAttachment`, `iam.RolePolicyAttachment`, and `iam.UserPolicyAttachment` resources and will permanently show a difference if both are defined.

        > **NOTE:** For a given role, this resource is incompatible with using the `iam.Role` resource `managed_policy_arns` argument. When using that argument and this resource, both will attempt to manage the role's managed policy attachments and the provider will show a permanent difference.

        > **NOTE:** To ensure Pulumi correctly manages dependencies during updates, use a reference to the IAM resource when defining the `policy_arn` for `iam.PolicyAttachment`, rather than constructing the ARN directly. For example, use `policy_arn = aws_iam_policy.example.arn` instead of `policy_arn = "arn:aws:iam::${data.aws_caller_identity.current.account_id}:policy/Example"`. Failing to do so may lead to errors like `DeleteConflict: Cannot delete a policy attached to entities` or `NoSuchEntity`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        user = aws.iam.User("user", name="test-user")
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["ec2.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        role = aws.iam.Role("role",
            name="test-role",
            assume_role_policy=assume_role.json)
        group = aws.iam.Group("group", name="test-group")
        policy = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "actions": ["ec2:Describe*"],
            "resources": ["*"],
        }])
        policy_policy = aws.iam.Policy("policy",
            name="test-policy",
            description="A test policy",
            policy=policy.json)
        test_attach = aws.iam.PolicyAttachment("test-attach",
            name="test-attachment",
            users=[user.name],
            roles=[role.name],
            groups=[group.name],
            policy_arn=policy_policy.arn)
        ```

        :param str resource_name: The name of the resource.
        :param PolicyAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_arn: Optional[pulumi.Input[builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyAttachmentArgs.__new__(PolicyAttachmentArgs)

            __props__.__dict__["groups"] = groups
            __props__.__dict__["name"] = name
            if policy_arn is None and not opts.urn:
                raise TypeError("Missing required property 'policy_arn'")
            __props__.__dict__["policy_arn"] = policy_arn
            __props__.__dict__["roles"] = roles
            __props__.__dict__["users"] = users
        super(PolicyAttachment, __self__).__init__(
            'aws:iam/policyAttachment:PolicyAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            policy_arn: Optional[pulumi.Input[builtins.str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'PolicyAttachment':
        """
        Get an existing PolicyAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] groups: Group(s) the policy should be applied to.
        :param pulumi.Input[builtins.str] name: Name of the attachment. This cannot be an empty string.
        :param pulumi.Input[builtins.str] policy_arn: ARN of the policy you want to apply. Typically this should be a reference to the ARN of another resource to ensure dependency ordering, such as `aws_iam_policy.example.arn`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] roles: Role(s) the policy should be applied to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] users: User(s) the policy should be applied to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyAttachmentState.__new__(_PolicyAttachmentState)

        __props__.__dict__["groups"] = groups
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_arn"] = policy_arn
        __props__.__dict__["roles"] = roles
        __props__.__dict__["users"] = users
        return PolicyAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Group(s) the policy should be applied to.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the attachment. This cannot be an empty string.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the policy you want to apply. Typically this should be a reference to the ARN of another resource to ensure dependency ordering, such as `aws_iam_policy.example.arn`.
        """
        return pulumi.get(self, "policy_arn")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Role(s) the policy should be applied to.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        User(s) the policy should be applied to.
        """
        return pulumi.get(self, "users")

