# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RolePolicyAttachmentsExclusiveArgs', 'RolePolicyAttachmentsExclusive']

@pulumi.input_type
class RolePolicyAttachmentsExclusiveArgs:
    def __init__(__self__, *,
                 policy_arns: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 role_name: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a RolePolicyAttachmentsExclusive resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] policy_arns: A list of managed IAM policy ARNs to be attached to the role. Policies attached to this role but not configured in this argument will be removed.
        :param pulumi.Input[builtins.str] role_name: IAM role name.
        """
        pulumi.set(__self__, "policy_arns", policy_arns)
        pulumi.set(__self__, "role_name", role_name)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of managed IAM policy ARNs to be attached to the role. Policies attached to this role but not configured in this argument will be removed.
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "policy_arns", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Input[builtins.str]:
        """
        IAM role name.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_name", value)


@pulumi.input_type
class _RolePolicyAttachmentsExclusiveState:
    def __init__(__self__, *,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 role_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RolePolicyAttachmentsExclusive resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] policy_arns: A list of managed IAM policy ARNs to be attached to the role. Policies attached to this role but not configured in this argument will be removed.
        :param pulumi.Input[builtins.str] role_name: IAM role name.
        """
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of managed IAM policy ARNs to be attached to the role. Policies attached to this role but not configured in this argument will be removed.
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "policy_arns", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IAM role name.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_name", value)


@pulumi.type_token("aws:iam/rolePolicyAttachmentsExclusive:RolePolicyAttachmentsExclusive")
class RolePolicyAttachmentsExclusive(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 role_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        > **NOTE:**: To reliably detect drift between customer managed policies listed in this resource and actual policies attached to the role in the cloud, you currently need to run Pulumi with `pulumi up --refresh`. See [#4766](https://github.com/pulumi/pulumi-aws/issues/4766) for tracking making this work with regular `pulumi up`

        Resource for maintaining exclusive management of managed IAM policies assigned to an AWS IAM (Identity & Access Management) role.

        !> This resource takes exclusive ownership over managed IAM policies attached to a role. This includes removal of managed IAM policies which are not explicitly configured. To prevent persistent drift, ensure any `iam.RolePolicyAttachment` resources managed alongside this resource are included in the `policy_arns` argument.

        > Destruction of this resource means Pulumi will no longer manage reconciliation of the configured policy attachments. It **will not** detach the configured policies from the role.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iam.RolePolicyAttachmentsExclusive("example",
            role_name=example_aws_iam_role["name"],
            policy_arns=[example_aws_iam_policy["arn"]])
        ```

        ### Disallow Managed IAM Policies

        To automatically remove any configured managed IAM policies, set the `policy_arns` argument to an empty list.

        > This will not **prevent** managed IAM policies from being assigned to a role via Pulumi (or any other interface). This resource enables bringing managed IAM policy assignments into a configured state, however, this reconciliation happens only when `apply` is proactively run.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iam.RolePolicyAttachmentsExclusive("example",
            role_name=example_aws_iam_role["name"],
            policy_arns=[])
        ```

        ## Import

        Using `pulumi import`, import exclusive management of managed IAM policy assignments using the `role_name`. For example:

        ```sh
        $ pulumi import aws:iam/rolePolicyAttachmentsExclusive:RolePolicyAttachmentsExclusive example MyRole
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] policy_arns: A list of managed IAM policy ARNs to be attached to the role. Policies attached to this role but not configured in this argument will be removed.
        :param pulumi.Input[builtins.str] role_name: IAM role name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RolePolicyAttachmentsExclusiveArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **NOTE:**: To reliably detect drift between customer managed policies listed in this resource and actual policies attached to the role in the cloud, you currently need to run Pulumi with `pulumi up --refresh`. See [#4766](https://github.com/pulumi/pulumi-aws/issues/4766) for tracking making this work with regular `pulumi up`

        Resource for maintaining exclusive management of managed IAM policies assigned to an AWS IAM (Identity & Access Management) role.

        !> This resource takes exclusive ownership over managed IAM policies attached to a role. This includes removal of managed IAM policies which are not explicitly configured. To prevent persistent drift, ensure any `iam.RolePolicyAttachment` resources managed alongside this resource are included in the `policy_arns` argument.

        > Destruction of this resource means Pulumi will no longer manage reconciliation of the configured policy attachments. It **will not** detach the configured policies from the role.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iam.RolePolicyAttachmentsExclusive("example",
            role_name=example_aws_iam_role["name"],
            policy_arns=[example_aws_iam_policy["arn"]])
        ```

        ### Disallow Managed IAM Policies

        To automatically remove any configured managed IAM policies, set the `policy_arns` argument to an empty list.

        > This will not **prevent** managed IAM policies from being assigned to a role via Pulumi (or any other interface). This resource enables bringing managed IAM policy assignments into a configured state, however, this reconciliation happens only when `apply` is proactively run.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iam.RolePolicyAttachmentsExclusive("example",
            role_name=example_aws_iam_role["name"],
            policy_arns=[])
        ```

        ## Import

        Using `pulumi import`, import exclusive management of managed IAM policy assignments using the `role_name`. For example:

        ```sh
        $ pulumi import aws:iam/rolePolicyAttachmentsExclusive:RolePolicyAttachmentsExclusive example MyRole
        ```

        :param str resource_name: The name of the resource.
        :param RolePolicyAttachmentsExclusiveArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RolePolicyAttachmentsExclusiveArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 role_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RolePolicyAttachmentsExclusiveArgs.__new__(RolePolicyAttachmentsExclusiveArgs)

            if policy_arns is None and not opts.urn:
                raise TypeError("Missing required property 'policy_arns'")
            __props__.__dict__["policy_arns"] = policy_arns
            if role_name is None and not opts.urn:
                raise TypeError("Missing required property 'role_name'")
            __props__.__dict__["role_name"] = role_name
        super(RolePolicyAttachmentsExclusive, __self__).__init__(
            'aws:iam/rolePolicyAttachmentsExclusive:RolePolicyAttachmentsExclusive',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            role_name: Optional[pulumi.Input[builtins.str]] = None) -> 'RolePolicyAttachmentsExclusive':
        """
        Get an existing RolePolicyAttachmentsExclusive resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] policy_arns: A list of managed IAM policy ARNs to be attached to the role. Policies attached to this role but not configured in this argument will be removed.
        :param pulumi.Input[builtins.str] role_name: IAM role name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RolePolicyAttachmentsExclusiveState.__new__(_RolePolicyAttachmentsExclusiveState)

        __props__.__dict__["policy_arns"] = policy_arns
        __props__.__dict__["role_name"] = role_name
        return RolePolicyAttachmentsExclusive(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of managed IAM policy ARNs to be attached to the role. Policies attached to this role but not configured in this argument will be removed.
        """
        return pulumi.get(self, "policy_arns")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[builtins.str]:
        """
        IAM role name.
        """
        return pulumi.get(self, "role_name")

