# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecurityTokenServicePreferencesArgs', 'SecurityTokenServicePreferences']

@pulumi.input_type
class SecurityTokenServicePreferencesArgs:
    def __init__(__self__, *,
                 global_endpoint_token_version: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a SecurityTokenServicePreferences resource.
        :param pulumi.Input[builtins.str] global_endpoint_token_version: The version of the STS global endpoint token. Valid values: `v1Token`, `v2Token`.
        """
        pulumi.set(__self__, "global_endpoint_token_version", global_endpoint_token_version)

    @property
    @pulumi.getter(name="globalEndpointTokenVersion")
    def global_endpoint_token_version(self) -> pulumi.Input[builtins.str]:
        """
        The version of the STS global endpoint token. Valid values: `v1Token`, `v2Token`.
        """
        return pulumi.get(self, "global_endpoint_token_version")

    @global_endpoint_token_version.setter
    def global_endpoint_token_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "global_endpoint_token_version", value)


@pulumi.input_type
class _SecurityTokenServicePreferencesState:
    def __init__(__self__, *,
                 global_endpoint_token_version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecurityTokenServicePreferences resources.
        :param pulumi.Input[builtins.str] global_endpoint_token_version: The version of the STS global endpoint token. Valid values: `v1Token`, `v2Token`.
        """
        if global_endpoint_token_version is not None:
            pulumi.set(__self__, "global_endpoint_token_version", global_endpoint_token_version)

    @property
    @pulumi.getter(name="globalEndpointTokenVersion")
    def global_endpoint_token_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the STS global endpoint token. Valid values: `v1Token`, `v2Token`.
        """
        return pulumi.get(self, "global_endpoint_token_version")

    @global_endpoint_token_version.setter
    def global_endpoint_token_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "global_endpoint_token_version", value)


@pulumi.type_token("aws:iam/securityTokenServicePreferences:SecurityTokenServicePreferences")
class SecurityTokenServicePreferences(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 global_endpoint_token_version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides an IAM Security Token Service Preferences resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iam.SecurityTokenServicePreferences("example", global_endpoint_token_version="v2Token")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] global_endpoint_token_version: The version of the STS global endpoint token. Valid values: `v1Token`, `v2Token`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityTokenServicePreferencesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an IAM Security Token Service Preferences resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iam.SecurityTokenServicePreferences("example", global_endpoint_token_version="v2Token")
        ```

        :param str resource_name: The name of the resource.
        :param SecurityTokenServicePreferencesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityTokenServicePreferencesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 global_endpoint_token_version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityTokenServicePreferencesArgs.__new__(SecurityTokenServicePreferencesArgs)

            if global_endpoint_token_version is None and not opts.urn:
                raise TypeError("Missing required property 'global_endpoint_token_version'")
            __props__.__dict__["global_endpoint_token_version"] = global_endpoint_token_version
        super(SecurityTokenServicePreferences, __self__).__init__(
            'aws:iam/securityTokenServicePreferences:SecurityTokenServicePreferences',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            global_endpoint_token_version: Optional[pulumi.Input[builtins.str]] = None) -> 'SecurityTokenServicePreferences':
        """
        Get an existing SecurityTokenServicePreferences resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] global_endpoint_token_version: The version of the STS global endpoint token. Valid values: `v1Token`, `v2Token`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityTokenServicePreferencesState.__new__(_SecurityTokenServicePreferencesState)

        __props__.__dict__["global_endpoint_token_version"] = global_endpoint_token_version
        return SecurityTokenServicePreferences(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="globalEndpointTokenVersion")
    def global_endpoint_token_version(self) -> pulumi.Output[builtins.str]:
        """
        The version of the STS global endpoint token. Valid values: `v1Token`, `v2Token`.
        """
        return pulumi.get(self, "global_endpoint_token_version")

