# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServerCertificateArgs', 'ServerCertificate']

@pulumi.input_type
class ServerCertificateArgs:
    def __init__(__self__, *,
                 certificate_body: pulumi.Input[builtins.str],
                 private_key: pulumi.Input[builtins.str],
                 certificate_chain: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ServerCertificate resource.
        :param pulumi.Input[builtins.str] certificate_body: The contents of the public key certificate in
               PEM-encoded format.
        :param pulumi.Input[builtins.str] private_key: The contents of the private key in PEM-encoded format.
        :param pulumi.Input[builtins.str] certificate_chain: The contents of the certificate chain.
               This is typically a concatenation of the PEM-encoded public key certificates
               of the chain.
        :param pulumi.Input[builtins.str] name: The name of the Server Certificate. Do not include the path in this value. If omitted, the provider will assign a random, unique name.
        :param pulumi.Input[builtins.str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`.
        :param pulumi.Input[builtins.str] path: The IAM path for the server certificate.  If it is not
               included, it defaults to a slash (/). If this certificate is for use with
               AWS CloudFront, the path must be in format `/cloudfront/your_path_here`.
               See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more details on IAM Paths.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of resource tags for the server certificate. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               > **NOTE:** AWS performs behind-the-scenes modifications to some certificate files if they do not adhere to a specific format. These modifications will result in this provider forever believing that it needs to update the resources since the local and AWS file contents will not match after theses modifications occur. In order to prevent this from happening you must ensure that all your PEM-encoded files use UNIX line-breaks and that `certificate_body` contains only one certificate. All other certificates should go in `certificate_chain`. It is common for some Certificate Authorities to issue certificate files that have DOS line-breaks and that are actually multiple certificates concatenated together in order to form a full certificate chain.
        """
        pulumi.set(__self__, "certificate_body", certificate_body)
        pulumi.set(__self__, "private_key", private_key)
        if certificate_chain is not None:
            pulumi.set(__self__, "certificate_chain", certificate_chain)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="certificateBody")
    def certificate_body(self) -> pulumi.Input[builtins.str]:
        """
        The contents of the public key certificate in
        PEM-encoded format.
        """
        return pulumi.get(self, "certificate_body")

    @certificate_body.setter
    def certificate_body(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "certificate_body", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[builtins.str]:
        """
        The contents of the private key in PEM-encoded format.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The contents of the certificate chain.
        This is typically a concatenation of the PEM-encoded public key certificates
        of the chain.
        """
        return pulumi.get(self, "certificate_chain")

    @certificate_chain.setter
    def certificate_chain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_chain", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Server Certificate. Do not include the path in this value. If omitted, the provider will assign a random, unique name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creates a unique name beginning with the specified
        prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IAM path for the server certificate.  If it is not
        included, it defaults to a slash (/). If this certificate is for use with
        AWS CloudFront, the path must be in format `/cloudfront/your_path_here`.
        See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more details on IAM Paths.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of resource tags for the server certificate. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        > **NOTE:** AWS performs behind-the-scenes modifications to some certificate files if they do not adhere to a specific format. These modifications will result in this provider forever believing that it needs to update the resources since the local and AWS file contents will not match after theses modifications occur. In order to prevent this from happening you must ensure that all your PEM-encoded files use UNIX line-breaks and that `certificate_body` contains only one certificate. All other certificates should go in `certificate_chain`. It is common for some Certificate Authorities to issue certificate files that have DOS line-breaks and that are actually multiple certificates concatenated together in order to form a full certificate chain.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ServerCertificateState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_body: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_chain: Optional[pulumi.Input[builtins.str]] = None,
                 expiration: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 upload_date: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServerCertificate resources.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) specifying the server certificate.
        :param pulumi.Input[builtins.str] certificate_body: The contents of the public key certificate in
               PEM-encoded format.
        :param pulumi.Input[builtins.str] certificate_chain: The contents of the certificate chain.
               This is typically a concatenation of the PEM-encoded public key certificates
               of the chain.
        :param pulumi.Input[builtins.str] expiration: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) on which the certificate is set to expire.
        :param pulumi.Input[builtins.str] name: The name of the Server Certificate. Do not include the path in this value. If omitted, the provider will assign a random, unique name.
        :param pulumi.Input[builtins.str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`.
        :param pulumi.Input[builtins.str] path: The IAM path for the server certificate.  If it is not
               included, it defaults to a slash (/). If this certificate is for use with
               AWS CloudFront, the path must be in format `/cloudfront/your_path_here`.
               See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more details on IAM Paths.
        :param pulumi.Input[builtins.str] private_key: The contents of the private key in PEM-encoded format.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of resource tags for the server certificate. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               > **NOTE:** AWS performs behind-the-scenes modifications to some certificate files if they do not adhere to a specific format. These modifications will result in this provider forever believing that it needs to update the resources since the local and AWS file contents will not match after theses modifications occur. In order to prevent this from happening you must ensure that all your PEM-encoded files use UNIX line-breaks and that `certificate_body` contains only one certificate. All other certificates should go in `certificate_chain`. It is common for some Certificate Authorities to issue certificate files that have DOS line-breaks and that are actually multiple certificates concatenated together in order to form a full certificate chain.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] upload_date: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) when the server certificate was uploaded.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if certificate_body is not None:
            pulumi.set(__self__, "certificate_body", certificate_body)
        if certificate_chain is not None:
            pulumi.set(__self__, "certificate_chain", certificate_chain)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if upload_date is not None:
            pulumi.set(__self__, "upload_date", upload_date)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) specifying the server certificate.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="certificateBody")
    def certificate_body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The contents of the public key certificate in
        PEM-encoded format.
        """
        return pulumi.get(self, "certificate_body")

    @certificate_body.setter
    def certificate_body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_body", value)

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The contents of the certificate chain.
        This is typically a concatenation of the PEM-encoded public key certificates
        of the chain.
        """
        return pulumi.get(self, "certificate_chain")

    @certificate_chain.setter
    def certificate_chain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_chain", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) on which the certificate is set to expire.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Server Certificate. Do not include the path in this value. If omitted, the provider will assign a random, unique name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creates a unique name beginning with the specified
        prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IAM path for the server certificate.  If it is not
        included, it defaults to a slash (/). If this certificate is for use with
        AWS CloudFront, the path must be in format `/cloudfront/your_path_here`.
        See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more details on IAM Paths.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The contents of the private key in PEM-encoded format.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of resource tags for the server certificate. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        > **NOTE:** AWS performs behind-the-scenes modifications to some certificate files if they do not adhere to a specific format. These modifications will result in this provider forever believing that it needs to update the resources since the local and AWS file contents will not match after theses modifications occur. In order to prevent this from happening you must ensure that all your PEM-encoded files use UNIX line-breaks and that `certificate_body` contains only one certificate. All other certificates should go in `certificate_chain`. It is common for some Certificate Authorities to issue certificate files that have DOS line-breaks and that are actually multiple certificates concatenated together in order to form a full certificate chain.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="uploadDate")
    def upload_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) when the server certificate was uploaded.
        """
        return pulumi.get(self, "upload_date")

    @upload_date.setter
    def upload_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "upload_date", value)


@pulumi.type_token("aws:iam/serverCertificate:ServerCertificate")
class ServerCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_body: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_chain: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Provides an IAM Server Certificate resource to upload Server Certificates.
        Certs uploaded to IAM can easily work with other AWS services such as:

        - AWS Elastic Beanstalk
        - Elastic Load Balancing
        - CloudFront
        - AWS OpsWorks

        For information about server certificates in IAM, see [Managing Server
        Certificates][2] in AWS Documentation.

        ## Example Usage

        **Using certs on file:**

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        test_cert = aws.iam.ServerCertificate("test_cert",
            name="some_test_cert",
            certificate_body=std.file(input="self-ca-cert.pem").result,
            private_key=std.file(input="test-key.pem").result)
        ```

        **Example with cert in-line:**

        ```python
        import pulumi
        import pulumi_aws as aws

        test_cert_alt = aws.iam.ServerCertificate("test_cert_alt",
            name="alt_test_cert",
            certificate_body=\"\"\"-----BEGIN CERTIFICATE-----
        [......] # cert contents
        -----END CERTIFICATE-----
        \"\"\",
            private_key=\"\"\"-----BEGIN RSA PRIVATE KEY-----
        [......] # cert contents
        -----END RSA PRIVATE KEY-----
        \"\"\")
        ```

        **Use in combination with an AWS ELB resource:**

        Some properties of an IAM Server Certificates cannot be updated while they are
        in use. In order for the provider to effectively manage a Certificate in this situation, it is
        recommended you utilize the `name_prefix` attribute and enable the
        `create_before_destroy`. This will allow this provider
        to create a new, updated `iam.ServerCertificate` resource and replace it in
        dependant resources before attempting to destroy the old version.

        ## Import

        Using `pulumi import`, import IAM Server Certificates using the `name`. For example:

        ```sh
        $ pulumi import aws:iam/serverCertificate:ServerCertificate certificate example.com-certificate-until-2018
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] certificate_body: The contents of the public key certificate in
               PEM-encoded format.
        :param pulumi.Input[builtins.str] certificate_chain: The contents of the certificate chain.
               This is typically a concatenation of the PEM-encoded public key certificates
               of the chain.
        :param pulumi.Input[builtins.str] name: The name of the Server Certificate. Do not include the path in this value. If omitted, the provider will assign a random, unique name.
        :param pulumi.Input[builtins.str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`.
        :param pulumi.Input[builtins.str] path: The IAM path for the server certificate.  If it is not
               included, it defaults to a slash (/). If this certificate is for use with
               AWS CloudFront, the path must be in format `/cloudfront/your_path_here`.
               See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more details on IAM Paths.
        :param pulumi.Input[builtins.str] private_key: The contents of the private key in PEM-encoded format.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of resource tags for the server certificate. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               > **NOTE:** AWS performs behind-the-scenes modifications to some certificate files if they do not adhere to a specific format. These modifications will result in this provider forever believing that it needs to update the resources since the local and AWS file contents will not match after theses modifications occur. In order to prevent this from happening you must ensure that all your PEM-encoded files use UNIX line-breaks and that `certificate_body` contains only one certificate. All other certificates should go in `certificate_chain`. It is common for some Certificate Authorities to issue certificate files that have DOS line-breaks and that are actually multiple certificates concatenated together in order to form a full certificate chain.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an IAM Server Certificate resource to upload Server Certificates.
        Certs uploaded to IAM can easily work with other AWS services such as:

        - AWS Elastic Beanstalk
        - Elastic Load Balancing
        - CloudFront
        - AWS OpsWorks

        For information about server certificates in IAM, see [Managing Server
        Certificates][2] in AWS Documentation.

        ## Example Usage

        **Using certs on file:**

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        test_cert = aws.iam.ServerCertificate("test_cert",
            name="some_test_cert",
            certificate_body=std.file(input="self-ca-cert.pem").result,
            private_key=std.file(input="test-key.pem").result)
        ```

        **Example with cert in-line:**

        ```python
        import pulumi
        import pulumi_aws as aws

        test_cert_alt = aws.iam.ServerCertificate("test_cert_alt",
            name="alt_test_cert",
            certificate_body=\"\"\"-----BEGIN CERTIFICATE-----
        [......] # cert contents
        -----END CERTIFICATE-----
        \"\"\",
            private_key=\"\"\"-----BEGIN RSA PRIVATE KEY-----
        [......] # cert contents
        -----END RSA PRIVATE KEY-----
        \"\"\")
        ```

        **Use in combination with an AWS ELB resource:**

        Some properties of an IAM Server Certificates cannot be updated while they are
        in use. In order for the provider to effectively manage a Certificate in this situation, it is
        recommended you utilize the `name_prefix` attribute and enable the
        `create_before_destroy`. This will allow this provider
        to create a new, updated `iam.ServerCertificate` resource and replace it in
        dependant resources before attempting to destroy the old version.

        ## Import

        Using `pulumi import`, import IAM Server Certificates using the `name`. For example:

        ```sh
        $ pulumi import aws:iam/serverCertificate:ServerCertificate certificate example.com-certificate-until-2018
        ```

        :param str resource_name: The name of the resource.
        :param ServerCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_body: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_chain: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerCertificateArgs.__new__(ServerCertificateArgs)

            if certificate_body is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_body'")
            __props__.__dict__["certificate_body"] = certificate_body
            __props__.__dict__["certificate_chain"] = certificate_chain
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["path"] = path
            if private_key is None and not opts.urn:
                raise TypeError("Missing required property 'private_key'")
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["expiration"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["upload_date"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServerCertificate, __self__).__init__(
            'aws:iam/serverCertificate:ServerCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            certificate_body: Optional[pulumi.Input[builtins.str]] = None,
            certificate_chain: Optional[pulumi.Input[builtins.str]] = None,
            expiration: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[builtins.str]] = None,
            path: Optional[pulumi.Input[builtins.str]] = None,
            private_key: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            upload_date: Optional[pulumi.Input[builtins.str]] = None) -> 'ServerCertificate':
        """
        Get an existing ServerCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) specifying the server certificate.
        :param pulumi.Input[builtins.str] certificate_body: The contents of the public key certificate in
               PEM-encoded format.
        :param pulumi.Input[builtins.str] certificate_chain: The contents of the certificate chain.
               This is typically a concatenation of the PEM-encoded public key certificates
               of the chain.
        :param pulumi.Input[builtins.str] expiration: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) on which the certificate is set to expire.
        :param pulumi.Input[builtins.str] name: The name of the Server Certificate. Do not include the path in this value. If omitted, the provider will assign a random, unique name.
        :param pulumi.Input[builtins.str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`.
        :param pulumi.Input[builtins.str] path: The IAM path for the server certificate.  If it is not
               included, it defaults to a slash (/). If this certificate is for use with
               AWS CloudFront, the path must be in format `/cloudfront/your_path_here`.
               See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more details on IAM Paths.
        :param pulumi.Input[builtins.str] private_key: The contents of the private key in PEM-encoded format.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of resource tags for the server certificate. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               > **NOTE:** AWS performs behind-the-scenes modifications to some certificate files if they do not adhere to a specific format. These modifications will result in this provider forever believing that it needs to update the resources since the local and AWS file contents will not match after theses modifications occur. In order to prevent this from happening you must ensure that all your PEM-encoded files use UNIX line-breaks and that `certificate_body` contains only one certificate. All other certificates should go in `certificate_chain`. It is common for some Certificate Authorities to issue certificate files that have DOS line-breaks and that are actually multiple certificates concatenated together in order to form a full certificate chain.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] upload_date: Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) when the server certificate was uploaded.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerCertificateState.__new__(_ServerCertificateState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["certificate_body"] = certificate_body
        __props__.__dict__["certificate_chain"] = certificate_chain
        __props__.__dict__["expiration"] = expiration
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["path"] = path
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["upload_date"] = upload_date
        return ServerCertificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) specifying the server certificate.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="certificateBody")
    def certificate_body(self) -> pulumi.Output[builtins.str]:
        """
        The contents of the public key certificate in
        PEM-encoded format.
        """
        return pulumi.get(self, "certificate_body")

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The contents of the certificate chain.
        This is typically a concatenation of the PEM-encoded public key certificates
        of the chain.
        """
        return pulumi.get(self, "certificate_chain")

    @property
    @pulumi.getter
    def expiration(self) -> pulumi.Output[builtins.str]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) on which the certificate is set to expire.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Server Certificate. Do not include the path in this value. If omitted, the provider will assign a random, unique name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[builtins.str]:
        """
        Creates a unique name beginning with the specified
        prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The IAM path for the server certificate.  If it is not
        included, it defaults to a slash (/). If this certificate is for use with
        AWS CloudFront, the path must be in format `/cloudfront/your_path_here`.
        See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more details on IAM Paths.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[builtins.str]:
        """
        The contents of the private key in PEM-encoded format.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of resource tags for the server certificate. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        > **NOTE:** AWS performs behind-the-scenes modifications to some certificate files if they do not adhere to a specific format. These modifications will result in this provider forever believing that it needs to update the resources since the local and AWS file contents will not match after theses modifications occur. In order to prevent this from happening you must ensure that all your PEM-encoded files use UNIX line-breaks and that `certificate_body` contains only one certificate. All other certificates should go in `certificate_chain`. It is common for some Certificate Authorities to issue certificate files that have DOS line-breaks and that are actually multiple certificates concatenated together in order to form a full certificate chain.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="uploadDate")
    def upload_date(self) -> pulumi.Output[builtins.str]:
        """
        Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) when the server certificate was uploaded.
        """
        return pulumi.get(self, "upload_date")

