# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserGroupMembershipArgs', 'UserGroupMembership']

@pulumi.input_type
class UserGroupMembershipArgs:
    def __init__(__self__, *,
                 groups: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 user: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a UserGroupMembership resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] groups: A list of IAM Groups to add the user to
        :param pulumi.Input[builtins.str] user: The name of the IAM User to add to groups
        """
        pulumi.set(__self__, "groups", groups)
        pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of IAM Groups to add the user to
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[builtins.str]:
        """
        The name of the IAM User to add to groups
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class _UserGroupMembershipState:
    def __init__(__self__, *,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserGroupMembership resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] groups: A list of IAM Groups to add the user to
        :param pulumi.Input[builtins.str] user: The name of the IAM User to add to groups
        """
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of IAM Groups to add the user to
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the IAM User to add to groups
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.type_token("aws:iam/userGroupMembership:UserGroupMembership")
class UserGroupMembership(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource for adding an IAM User to IAM Groups. This
        resource can be used multiple times with the same user for non-overlapping
        groups.

        To exclusively manage the users in a group, see the
        `iam.GroupMembership` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        user1 = aws.iam.User("user1", name="user1")
        group1 = aws.iam.Group("group1", name="group1")
        group2 = aws.iam.Group("group2", name="group2")
        example1 = aws.iam.UserGroupMembership("example1",
            user=user1.name,
            groups=[
                group1.name,
                group2.name,
            ])
        group3 = aws.iam.Group("group3", name="group3")
        example2 = aws.iam.UserGroupMembership("example2",
            user=user1.name,
            groups=[group3.name])
        ```

        ## Import

        Using `pulumi import`, import IAM user group membership using the user name and group names separated by `/`. For example:

        ```sh
        $ pulumi import aws:iam/userGroupMembership:UserGroupMembership example1 user1/group1/group2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] groups: A list of IAM Groups to add the user to
        :param pulumi.Input[builtins.str] user: The name of the IAM User to add to groups
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserGroupMembershipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource for adding an IAM User to IAM Groups. This
        resource can be used multiple times with the same user for non-overlapping
        groups.

        To exclusively manage the users in a group, see the
        `iam.GroupMembership` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        user1 = aws.iam.User("user1", name="user1")
        group1 = aws.iam.Group("group1", name="group1")
        group2 = aws.iam.Group("group2", name="group2")
        example1 = aws.iam.UserGroupMembership("example1",
            user=user1.name,
            groups=[
                group1.name,
                group2.name,
            ])
        group3 = aws.iam.Group("group3", name="group3")
        example2 = aws.iam.UserGroupMembership("example2",
            user=user1.name,
            groups=[group3.name])
        ```

        ## Import

        Using `pulumi import`, import IAM user group membership using the user name and group names separated by `/`. For example:

        ```sh
        $ pulumi import aws:iam/userGroupMembership:UserGroupMembership example1 user1/group1/group2
        ```

        :param str resource_name: The name of the resource.
        :param UserGroupMembershipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserGroupMembershipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserGroupMembershipArgs.__new__(UserGroupMembershipArgs)

            if groups is None and not opts.urn:
                raise TypeError("Missing required property 'groups'")
            __props__.__dict__["groups"] = groups
            if user is None and not opts.urn:
                raise TypeError("Missing required property 'user'")
            __props__.__dict__["user"] = user
        super(UserGroupMembership, __self__).__init__(
            'aws:iam/userGroupMembership:UserGroupMembership',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            user: Optional[pulumi.Input[builtins.str]] = None) -> 'UserGroupMembership':
        """
        Get an existing UserGroupMembership resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] groups: A list of IAM Groups to add the user to
        :param pulumi.Input[builtins.str] user: The name of the IAM User to add to groups
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserGroupMembershipState.__new__(_UserGroupMembershipState)

        __props__.__dict__["groups"] = groups
        __props__.__dict__["user"] = user
        return UserGroupMembership(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of IAM Groups to add the user to
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def user(self) -> pulumi.Output[builtins.str]:
        """
        The name of the IAM User to add to groups
        """
        return pulumi.get(self, "user")

