# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GroupExternalId',
    'UserAddresses',
    'UserEmails',
    'UserExternalId',
    'UserName',
    'UserPhoneNumbers',
    'GetGroupAlternateIdentifierResult',
    'GetGroupAlternateIdentifierExternalIdResult',
    'GetGroupAlternateIdentifierUniqueAttributeResult',
    'GetGroupExternalIdResult',
    'GetGroupMembershipsGroupMembershipResult',
    'GetGroupMembershipsGroupMembershipMemberIdResult',
    'GetGroupsGroupResult',
    'GetGroupsGroupExternalIdResult',
    'GetUserAddressResult',
    'GetUserAlternateIdentifierResult',
    'GetUserAlternateIdentifierExternalIdResult',
    'GetUserAlternateIdentifierUniqueAttributeResult',
    'GetUserEmailResult',
    'GetUserExternalIdResult',
    'GetUserNameResult',
    'GetUserPhoneNumberResult',
    'GetUsersUserResult',
    'GetUsersUserAddressResult',
    'GetUsersUserEmailResult',
    'GetUsersUserExternalIdResult',
    'GetUsersUserNameResult',
    'GetUsersUserPhoneNumberResult',
]

@pulumi.output_type
class GroupExternalId(dict):
    def __init__(__self__, *,
                 id: Optional[builtins.str] = None,
                 issuer: Optional[builtins.str] = None):
        """
        :param builtins.str id: The identifier issued to this resource by an external identity provider.
        :param builtins.str issuer: The issuer for an external identifier.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The identifier issued to this resource by an external identity provider.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[builtins.str]:
        """
        The issuer for an external identifier.
        """
        return pulumi.get(self, "issuer")


@pulumi.output_type
class UserAddresses(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postalCode":
            suggest = "postal_code"
        elif key == "streetAddress":
            suggest = "street_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAddresses. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAddresses.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAddresses.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 country: Optional[builtins.str] = None,
                 formatted: Optional[builtins.str] = None,
                 locality: Optional[builtins.str] = None,
                 postal_code: Optional[builtins.str] = None,
                 primary: Optional[builtins.bool] = None,
                 region: Optional[builtins.str] = None,
                 street_address: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str country: The country that this address is in.
        :param builtins.str formatted: The name that is typically displayed when the address is shown for display.
        :param builtins.str locality: The address locality.
        :param builtins.str postal_code: The postal code of the address.
        :param builtins.bool primary: When `true`, this is the primary address associated with the user.
        :param builtins.str region: The region of the address.
        :param builtins.str street_address: The street of the address.
        :param builtins.str type: The type of address.
        """
        if country is not None:
            pulumi.set(__self__, "country", country)
        if formatted is not None:
            pulumi.set(__self__, "formatted", formatted)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def country(self) -> Optional[builtins.str]:
        """
        The country that this address is in.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def formatted(self) -> Optional[builtins.str]:
        """
        The name that is typically displayed when the address is shown for display.
        """
        return pulumi.get(self, "formatted")

    @property
    @pulumi.getter
    def locality(self) -> Optional[builtins.str]:
        """
        The address locality.
        """
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[builtins.str]:
        """
        The postal code of the address.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def primary(self) -> Optional[builtins.bool]:
        """
        When `true`, this is the primary address associated with the user.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region of the address.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[builtins.str]:
        """
        The street of the address.
        """
        return pulumi.get(self, "street_address")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of address.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class UserEmails(dict):
    def __init__(__self__, *,
                 primary: Optional[builtins.bool] = None,
                 type: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.bool primary: When `true`, this is the primary email associated with the user.
        :param builtins.str type: The type of email.
        :param builtins.str value: The email address. This value must be unique across the identity store.
        """
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def primary(self) -> Optional[builtins.bool]:
        """
        When `true`, this is the primary email associated with the user.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of email.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The email address. This value must be unique across the identity store.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class UserExternalId(dict):
    def __init__(__self__, *,
                 id: Optional[builtins.str] = None,
                 issuer: Optional[builtins.str] = None):
        """
        :param builtins.str id: The identifier issued to this resource by an external identity provider.
        :param builtins.str issuer: The issuer for an external identifier.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The identifier issued to this resource by an external identity provider.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[builtins.str]:
        """
        The issuer for an external identifier.
        """
        return pulumi.get(self, "issuer")


@pulumi.output_type
class UserName(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "familyName":
            suggest = "family_name"
        elif key == "givenName":
            suggest = "given_name"
        elif key == "honorificPrefix":
            suggest = "honorific_prefix"
        elif key == "honorificSuffix":
            suggest = "honorific_suffix"
        elif key == "middleName":
            suggest = "middle_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 family_name: builtins.str,
                 given_name: builtins.str,
                 formatted: Optional[builtins.str] = None,
                 honorific_prefix: Optional[builtins.str] = None,
                 honorific_suffix: Optional[builtins.str] = None,
                 middle_name: Optional[builtins.str] = None):
        """
        :param builtins.str family_name: The family name of the user.
        :param builtins.str given_name: The given name of the user.
               
               The following arguments are optional:
        :param builtins.str formatted: The name that is typically displayed when the name is shown for display.
        :param builtins.str honorific_prefix: The honorific prefix of the user.
        :param builtins.str honorific_suffix: The honorific suffix of the user.
        :param builtins.str middle_name: The middle name of the user.
        """
        pulumi.set(__self__, "family_name", family_name)
        pulumi.set(__self__, "given_name", given_name)
        if formatted is not None:
            pulumi.set(__self__, "formatted", formatted)
        if honorific_prefix is not None:
            pulumi.set(__self__, "honorific_prefix", honorific_prefix)
        if honorific_suffix is not None:
            pulumi.set(__self__, "honorific_suffix", honorific_suffix)
        if middle_name is not None:
            pulumi.set(__self__, "middle_name", middle_name)

    @property
    @pulumi.getter(name="familyName")
    def family_name(self) -> builtins.str:
        """
        The family name of the user.
        """
        return pulumi.get(self, "family_name")

    @property
    @pulumi.getter(name="givenName")
    def given_name(self) -> builtins.str:
        """
        The given name of the user.

        The following arguments are optional:
        """
        return pulumi.get(self, "given_name")

    @property
    @pulumi.getter
    def formatted(self) -> Optional[builtins.str]:
        """
        The name that is typically displayed when the name is shown for display.
        """
        return pulumi.get(self, "formatted")

    @property
    @pulumi.getter(name="honorificPrefix")
    def honorific_prefix(self) -> Optional[builtins.str]:
        """
        The honorific prefix of the user.
        """
        return pulumi.get(self, "honorific_prefix")

    @property
    @pulumi.getter(name="honorificSuffix")
    def honorific_suffix(self) -> Optional[builtins.str]:
        """
        The honorific suffix of the user.
        """
        return pulumi.get(self, "honorific_suffix")

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> Optional[builtins.str]:
        """
        The middle name of the user.
        """
        return pulumi.get(self, "middle_name")


@pulumi.output_type
class UserPhoneNumbers(dict):
    def __init__(__self__, *,
                 primary: Optional[builtins.bool] = None,
                 type: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.bool primary: When `true`, this is the primary phone number associated with the user.
        :param builtins.str type: The type of phone number.
        :param builtins.str value: The user's phone number.
        """
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def primary(self) -> Optional[builtins.bool]:
        """
        When `true`, this is the primary phone number associated with the user.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of phone number.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The user's phone number.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetGroupAlternateIdentifierResult(dict):
    def __init__(__self__, *,
                 external_id: Optional['outputs.GetGroupAlternateIdentifierExternalIdResult'] = None,
                 unique_attribute: Optional['outputs.GetGroupAlternateIdentifierUniqueAttributeResult'] = None):
        """
        :param 'GetGroupAlternateIdentifierExternalIdArgs' external_id: Configuration block for filtering by the identifier issued by an external identity provider. Detailed below.
        :param 'GetGroupAlternateIdentifierUniqueAttributeArgs' unique_attribute: An entity attribute that's unique to a specific entity. Detailed below.
               
               > Exactly one of the above arguments must be provided.
        """
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if unique_attribute is not None:
            pulumi.set(__self__, "unique_attribute", unique_attribute)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional['outputs.GetGroupAlternateIdentifierExternalIdResult']:
        """
        Configuration block for filtering by the identifier issued by an external identity provider. Detailed below.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="uniqueAttribute")
    def unique_attribute(self) -> Optional['outputs.GetGroupAlternateIdentifierUniqueAttributeResult']:
        """
        An entity attribute that's unique to a specific entity. Detailed below.

        > Exactly one of the above arguments must be provided.
        """
        return pulumi.get(self, "unique_attribute")


@pulumi.output_type
class GetGroupAlternateIdentifierExternalIdResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 issuer: builtins.str):
        """
        :param builtins.str id: The identifier issued to this resource by an external identity provider.
        :param builtins.str issuer: The issuer for an external identifier.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "issuer", issuer)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The identifier issued to this resource by an external identity provider.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def issuer(self) -> builtins.str:
        """
        The issuer for an external identifier.
        """
        return pulumi.get(self, "issuer")


@pulumi.output_type
class GetGroupAlternateIdentifierUniqueAttributeResult(dict):
    def __init__(__self__, *,
                 attribute_path: builtins.str,
                 attribute_value: builtins.str):
        """
        :param builtins.str attribute_path: Attribute path that is used to specify which attribute name to search. For example: `DisplayName`. Refer to the [Group data type](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html).
        :param builtins.str attribute_value: Value for an attribute.
        """
        pulumi.set(__self__, "attribute_path", attribute_path)
        pulumi.set(__self__, "attribute_value", attribute_value)

    @property
    @pulumi.getter(name="attributePath")
    def attribute_path(self) -> builtins.str:
        """
        Attribute path that is used to specify which attribute name to search. For example: `DisplayName`. Refer to the [Group data type](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html).
        """
        return pulumi.get(self, "attribute_path")

    @property
    @pulumi.getter(name="attributeValue")
    def attribute_value(self) -> builtins.str:
        """
        Value for an attribute.
        """
        return pulumi.get(self, "attribute_value")


@pulumi.output_type
class GetGroupExternalIdResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 issuer: builtins.str):
        """
        :param builtins.str id: The identifier issued to this resource by an external identity provider.
        :param builtins.str issuer: The issuer for an external identifier.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "issuer", issuer)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The identifier issued to this resource by an external identity provider.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def issuer(self) -> builtins.str:
        """
        The issuer for an external identifier.
        """
        return pulumi.get(self, "issuer")


@pulumi.output_type
class GetGroupMembershipsGroupMembershipResult(dict):
    def __init__(__self__, *,
                 group_id: builtins.str,
                 identity_store_id: builtins.str,
                 member_id: 'outputs.GetGroupMembershipsGroupMembershipMemberIdResult',
                 membership_id: builtins.str):
        """
        :param builtins.str group_id: The identifier for a group in the Identity Store.
        :param builtins.str identity_store_id: Identity Store ID associated with the Single Sign-On Instance.
        :param 'GetGroupMembershipsGroupMembershipMemberIdArgs' member_id: An object containing the identifier of a group member. See `member_id` below.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "identity_store_id", identity_store_id)
        pulumi.set(__self__, "member_id", member_id)
        pulumi.set(__self__, "membership_id", membership_id)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> builtins.str:
        """
        The identifier for a group in the Identity Store.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="identityStoreId")
    def identity_store_id(self) -> builtins.str:
        """
        Identity Store ID associated with the Single Sign-On Instance.
        """
        return pulumi.get(self, "identity_store_id")

    @property
    @pulumi.getter(name="memberId")
    def member_id(self) -> 'outputs.GetGroupMembershipsGroupMembershipMemberIdResult':
        """
        An object containing the identifier of a group member. See `member_id` below.
        """
        return pulumi.get(self, "member_id")

    @property
    @pulumi.getter(name="membershipId")
    def membership_id(self) -> builtins.str:
        return pulumi.get(self, "membership_id")


@pulumi.output_type
class GetGroupMembershipsGroupMembershipMemberIdResult(dict):
    def __init__(__self__, *,
                 user_id: builtins.str):
        """
        :param builtins.str user_id: User identifier of the group member.
        """
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> builtins.str:
        """
        User identifier of the group member.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetGroupsGroupResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 display_name: builtins.str,
                 external_ids: Sequence['outputs.GetGroupsGroupExternalIdResult'],
                 group_id: builtins.str,
                 identity_store_id: builtins.str):
        """
        :param builtins.str description: Description of the specified group.
        :param builtins.str display_name: Group's display name.
        :param Sequence['GetGroupsGroupExternalIdArgs'] external_ids: List of identifiers issued to this resource by an external identity provider.
        :param builtins.str group_id: Identifier of the group in the Identity Store.
        :param builtins.str identity_store_id: Identity Store ID associated with the Single Sign-On (SSO) Instance.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "external_ids", external_ids)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "identity_store_id", identity_store_id)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the specified group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Group's display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalIds")
    def external_ids(self) -> Sequence['outputs.GetGroupsGroupExternalIdResult']:
        """
        List of identifiers issued to this resource by an external identity provider.
        """
        return pulumi.get(self, "external_ids")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> builtins.str:
        """
        Identifier of the group in the Identity Store.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="identityStoreId")
    def identity_store_id(self) -> builtins.str:
        """
        Identity Store ID associated with the Single Sign-On (SSO) Instance.
        """
        return pulumi.get(self, "identity_store_id")


@pulumi.output_type
class GetGroupsGroupExternalIdResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 issuer: builtins.str):
        """
        :param builtins.str id: Identifier issued to this resource by an external identity provider.
        :param builtins.str issuer: Issuer for an external identifier.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "issuer", issuer)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Identifier issued to this resource by an external identity provider.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def issuer(self) -> builtins.str:
        """
        Issuer for an external identifier.
        """
        return pulumi.get(self, "issuer")


@pulumi.output_type
class GetUserAddressResult(dict):
    def __init__(__self__, *,
                 country: builtins.str,
                 formatted: builtins.str,
                 locality: builtins.str,
                 postal_code: builtins.str,
                 primary: builtins.bool,
                 region: builtins.str,
                 street_address: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str country: The country that this address is in.
        :param builtins.str formatted: The name that is typically displayed when the name is shown for display.
        :param builtins.str locality: The address locality.
        :param builtins.str postal_code: The postal code of the address.
        :param builtins.bool primary: When `true`, this is the primary phone number associated with the user.
        :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param builtins.str street_address: The street of the address.
        :param builtins.str type: The type of phone number.
        """
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "formatted", formatted)
        pulumi.set(__self__, "locality", locality)
        pulumi.set(__self__, "postal_code", postal_code)
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "street_address", street_address)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def country(self) -> builtins.str:
        """
        The country that this address is in.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def formatted(self) -> builtins.str:
        """
        The name that is typically displayed when the name is shown for display.
        """
        return pulumi.get(self, "formatted")

    @property
    @pulumi.getter
    def locality(self) -> builtins.str:
        """
        The address locality.
        """
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> builtins.str:
        """
        The postal code of the address.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def primary(self) -> builtins.bool:
        """
        When `true`, this is the primary phone number associated with the user.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> builtins.str:
        """
        The street of the address.
        """
        return pulumi.get(self, "street_address")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of phone number.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetUserAlternateIdentifierResult(dict):
    def __init__(__self__, *,
                 external_id: Optional['outputs.GetUserAlternateIdentifierExternalIdResult'] = None,
                 unique_attribute: Optional['outputs.GetUserAlternateIdentifierUniqueAttributeResult'] = None):
        """
        :param 'GetUserAlternateIdentifierExternalIdArgs' external_id: Configuration block for filtering by the identifier issued by an external identity provider. Detailed below.
        :param 'GetUserAlternateIdentifierUniqueAttributeArgs' unique_attribute: An entity attribute that's unique to a specific entity. Detailed below.
               
               > Exactly one of the above arguments must be provided.
        """
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if unique_attribute is not None:
            pulumi.set(__self__, "unique_attribute", unique_attribute)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional['outputs.GetUserAlternateIdentifierExternalIdResult']:
        """
        Configuration block for filtering by the identifier issued by an external identity provider. Detailed below.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="uniqueAttribute")
    def unique_attribute(self) -> Optional['outputs.GetUserAlternateIdentifierUniqueAttributeResult']:
        """
        An entity attribute that's unique to a specific entity. Detailed below.

        > Exactly one of the above arguments must be provided.
        """
        return pulumi.get(self, "unique_attribute")


@pulumi.output_type
class GetUserAlternateIdentifierExternalIdResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 issuer: builtins.str):
        """
        :param builtins.str id: The identifier issued to this resource by an external identity provider.
        :param builtins.str issuer: The issuer for an external identifier.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "issuer", issuer)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The identifier issued to this resource by an external identity provider.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def issuer(self) -> builtins.str:
        """
        The issuer for an external identifier.
        """
        return pulumi.get(self, "issuer")


@pulumi.output_type
class GetUserAlternateIdentifierUniqueAttributeResult(dict):
    def __init__(__self__, *,
                 attribute_path: builtins.str,
                 attribute_value: builtins.str):
        """
        :param builtins.str attribute_path: Attribute path that is used to specify which attribute name to search. For example: `UserName`. Refer to the [User data type](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html).
        :param builtins.str attribute_value: Value for an attribute.
        """
        pulumi.set(__self__, "attribute_path", attribute_path)
        pulumi.set(__self__, "attribute_value", attribute_value)

    @property
    @pulumi.getter(name="attributePath")
    def attribute_path(self) -> builtins.str:
        """
        Attribute path that is used to specify which attribute name to search. For example: `UserName`. Refer to the [User data type](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html).
        """
        return pulumi.get(self, "attribute_path")

    @property
    @pulumi.getter(name="attributeValue")
    def attribute_value(self) -> builtins.str:
        """
        Value for an attribute.
        """
        return pulumi.get(self, "attribute_value")


@pulumi.output_type
class GetUserEmailResult(dict):
    def __init__(__self__, *,
                 primary: builtins.bool,
                 type: builtins.str,
                 value: builtins.str):
        """
        :param builtins.bool primary: When `true`, this is the primary phone number associated with the user.
        :param builtins.str type: The type of phone number.
        :param builtins.str value: The user's phone number.
        """
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def primary(self) -> builtins.bool:
        """
        When `true`, this is the primary phone number associated with the user.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of phone number.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The user's phone number.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetUserExternalIdResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 issuer: builtins.str):
        """
        :param builtins.str id: The identifier issued to this resource by an external identity provider.
        :param builtins.str issuer: The issuer for an external identifier.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "issuer", issuer)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The identifier issued to this resource by an external identity provider.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def issuer(self) -> builtins.str:
        """
        The issuer for an external identifier.
        """
        return pulumi.get(self, "issuer")


@pulumi.output_type
class GetUserNameResult(dict):
    def __init__(__self__, *,
                 family_name: builtins.str,
                 formatted: builtins.str,
                 given_name: builtins.str,
                 honorific_prefix: builtins.str,
                 honorific_suffix: builtins.str,
                 middle_name: builtins.str):
        """
        :param builtins.str family_name: The family name of the user.
        :param builtins.str formatted: The name that is typically displayed when the name is shown for display.
        :param builtins.str given_name: The given name of the user.
        :param builtins.str honorific_prefix: The honorific prefix of the user.
        :param builtins.str honorific_suffix: The honorific suffix of the user.
        :param builtins.str middle_name: The middle name of the user.
        """
        pulumi.set(__self__, "family_name", family_name)
        pulumi.set(__self__, "formatted", formatted)
        pulumi.set(__self__, "given_name", given_name)
        pulumi.set(__self__, "honorific_prefix", honorific_prefix)
        pulumi.set(__self__, "honorific_suffix", honorific_suffix)
        pulumi.set(__self__, "middle_name", middle_name)

    @property
    @pulumi.getter(name="familyName")
    def family_name(self) -> builtins.str:
        """
        The family name of the user.
        """
        return pulumi.get(self, "family_name")

    @property
    @pulumi.getter
    def formatted(self) -> builtins.str:
        """
        The name that is typically displayed when the name is shown for display.
        """
        return pulumi.get(self, "formatted")

    @property
    @pulumi.getter(name="givenName")
    def given_name(self) -> builtins.str:
        """
        The given name of the user.
        """
        return pulumi.get(self, "given_name")

    @property
    @pulumi.getter(name="honorificPrefix")
    def honorific_prefix(self) -> builtins.str:
        """
        The honorific prefix of the user.
        """
        return pulumi.get(self, "honorific_prefix")

    @property
    @pulumi.getter(name="honorificSuffix")
    def honorific_suffix(self) -> builtins.str:
        """
        The honorific suffix of the user.
        """
        return pulumi.get(self, "honorific_suffix")

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> builtins.str:
        """
        The middle name of the user.
        """
        return pulumi.get(self, "middle_name")


@pulumi.output_type
class GetUserPhoneNumberResult(dict):
    def __init__(__self__, *,
                 primary: builtins.bool,
                 type: builtins.str,
                 value: builtins.str):
        """
        :param builtins.bool primary: When `true`, this is the primary phone number associated with the user.
        :param builtins.str type: The type of phone number.
        :param builtins.str value: The user's phone number.
        """
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def primary(self) -> builtins.bool:
        """
        When `true`, this is the primary phone number associated with the user.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of phone number.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The user's phone number.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 addresses: Sequence['outputs.GetUsersUserAddressResult'],
                 display_name: builtins.str,
                 emails: Sequence['outputs.GetUsersUserEmailResult'],
                 external_ids: Sequence['outputs.GetUsersUserExternalIdResult'],
                 identity_store_id: builtins.str,
                 locale: builtins.str,
                 names: Sequence['outputs.GetUsersUserNameResult'],
                 nickname: builtins.str,
                 phone_numbers: Sequence['outputs.GetUsersUserPhoneNumberResult'],
                 preferred_language: builtins.str,
                 profile_url: builtins.str,
                 timezone: builtins.str,
                 title: builtins.str,
                 user_id: builtins.str,
                 user_name: builtins.str,
                 user_type: builtins.str):
        """
        :param Sequence['GetUsersUserAddressArgs'] addresses: List of details about the user's address.
        :param builtins.str display_name: Name that is typically displayed when the user is referenced.
        :param Sequence['GetUsersUserEmailArgs'] emails: List of details about the user's email.
        :param Sequence['GetUsersUserExternalIdArgs'] external_ids: List of identifiers issued to this resource by an external identity provider.
        :param builtins.str identity_store_id: Identity Store ID associated with the Single Sign-On Instance.
        :param builtins.str locale: User's geographical region or location.
        :param Sequence['GetUsersUserNameArgs'] names: Details about the user's full name.
        :param builtins.str nickname: An alternate name for the user.
        :param Sequence['GetUsersUserPhoneNumberArgs'] phone_numbers: List of details about the user's phone number.
        :param builtins.str preferred_language: Preferred language of the user.
        :param builtins.str profile_url: An URL that may be associated with the user.
        :param builtins.str timezone: User's time zone.
        :param builtins.str title: User's title.
        :param builtins.str user_id: Identifier of the user in the Identity Store.
        :param builtins.str user_name: User's user name value.
        :param builtins.str user_type: User type.
        """
        pulumi.set(__self__, "addresses", addresses)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "emails", emails)
        pulumi.set(__self__, "external_ids", external_ids)
        pulumi.set(__self__, "identity_store_id", identity_store_id)
        pulumi.set(__self__, "locale", locale)
        pulumi.set(__self__, "names", names)
        pulumi.set(__self__, "nickname", nickname)
        pulumi.set(__self__, "phone_numbers", phone_numbers)
        pulumi.set(__self__, "preferred_language", preferred_language)
        pulumi.set(__self__, "profile_url", profile_url)
        pulumi.set(__self__, "timezone", timezone)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "user_type", user_type)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence['outputs.GetUsersUserAddressResult']:
        """
        List of details about the user's address.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Name that is typically displayed when the user is referenced.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def emails(self) -> Sequence['outputs.GetUsersUserEmailResult']:
        """
        List of details about the user's email.
        """
        return pulumi.get(self, "emails")

    @property
    @pulumi.getter(name="externalIds")
    def external_ids(self) -> Sequence['outputs.GetUsersUserExternalIdResult']:
        """
        List of identifiers issued to this resource by an external identity provider.
        """
        return pulumi.get(self, "external_ids")

    @property
    @pulumi.getter(name="identityStoreId")
    def identity_store_id(self) -> builtins.str:
        """
        Identity Store ID associated with the Single Sign-On Instance.
        """
        return pulumi.get(self, "identity_store_id")

    @property
    @pulumi.getter
    def locale(self) -> builtins.str:
        """
        User's geographical region or location.
        """
        return pulumi.get(self, "locale")

    @property
    @pulumi.getter
    def names(self) -> Sequence['outputs.GetUsersUserNameResult']:
        """
        Details about the user's full name.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def nickname(self) -> builtins.str:
        """
        An alternate name for the user.
        """
        return pulumi.get(self, "nickname")

    @property
    @pulumi.getter(name="phoneNumbers")
    def phone_numbers(self) -> Sequence['outputs.GetUsersUserPhoneNumberResult']:
        """
        List of details about the user's phone number.
        """
        return pulumi.get(self, "phone_numbers")

    @property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> builtins.str:
        """
        Preferred language of the user.
        """
        return pulumi.get(self, "preferred_language")

    @property
    @pulumi.getter(name="profileUrl")
    def profile_url(self) -> builtins.str:
        """
        An URL that may be associated with the user.
        """
        return pulumi.get(self, "profile_url")

    @property
    @pulumi.getter
    def timezone(self) -> builtins.str:
        """
        User's time zone.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        User's title.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> builtins.str:
        """
        Identifier of the user in the Identity Store.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> builtins.str:
        """
        User's user name value.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="userType")
    def user_type(self) -> builtins.str:
        """
        User type.
        """
        return pulumi.get(self, "user_type")


@pulumi.output_type
class GetUsersUserAddressResult(dict):
    def __init__(__self__, *,
                 country: builtins.str,
                 formatted: builtins.str,
                 locality: builtins.str,
                 postal_code: builtins.str,
                 primary: builtins.bool,
                 region: builtins.str,
                 street_address: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str country: Country that this address is in.
        :param builtins.str formatted: Name that is typically displayed when the name is shown for display.
        :param builtins.str locality: Address locality.
        :param builtins.str postal_code: Postal code of the address.
        :param builtins.bool primary: When `true`, this is the primary phone number associated with the user.
        :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param builtins.str street_address: Street of the address.
        :param builtins.str type: Type of phone number.
        """
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "formatted", formatted)
        pulumi.set(__self__, "locality", locality)
        pulumi.set(__self__, "postal_code", postal_code)
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "street_address", street_address)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def country(self) -> builtins.str:
        """
        Country that this address is in.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def formatted(self) -> builtins.str:
        """
        Name that is typically displayed when the name is shown for display.
        """
        return pulumi.get(self, "formatted")

    @property
    @pulumi.getter
    def locality(self) -> builtins.str:
        """
        Address locality.
        """
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> builtins.str:
        """
        Postal code of the address.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def primary(self) -> builtins.bool:
        """
        When `true`, this is the primary phone number associated with the user.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> builtins.str:
        """
        Street of the address.
        """
        return pulumi.get(self, "street_address")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of phone number.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetUsersUserEmailResult(dict):
    def __init__(__self__, *,
                 primary: builtins.bool,
                 type: builtins.str,
                 value: builtins.str):
        """
        :param builtins.bool primary: When `true`, this is the primary phone number associated with the user.
        :param builtins.str type: Type of phone number.
        :param builtins.str value: User's phone number.
        """
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def primary(self) -> builtins.bool:
        """
        When `true`, this is the primary phone number associated with the user.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of phone number.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        User's phone number.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetUsersUserExternalIdResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 issuer: builtins.str):
        """
        :param builtins.str id: Identifier issued to this resource by an external identity provider.
        :param builtins.str issuer: Issuer for an external identifier.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "issuer", issuer)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Identifier issued to this resource by an external identity provider.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def issuer(self) -> builtins.str:
        """
        Issuer for an external identifier.
        """
        return pulumi.get(self, "issuer")


@pulumi.output_type
class GetUsersUserNameResult(dict):
    def __init__(__self__, *,
                 family_name: builtins.str,
                 formatted: builtins.str,
                 given_name: builtins.str,
                 honorific_prefix: builtins.str,
                 honorific_suffix: builtins.str,
                 middle_name: builtins.str):
        """
        :param builtins.str family_name: Family name of the user.
        :param builtins.str formatted: Name that is typically displayed when the name is shown for display.
        :param builtins.str given_name: Given name of the user.
        :param builtins.str honorific_prefix: Honorific prefix of the user.
        :param builtins.str honorific_suffix: Honorific suffix of the user.
        :param builtins.str middle_name: Middle name of the user.
        """
        pulumi.set(__self__, "family_name", family_name)
        pulumi.set(__self__, "formatted", formatted)
        pulumi.set(__self__, "given_name", given_name)
        pulumi.set(__self__, "honorific_prefix", honorific_prefix)
        pulumi.set(__self__, "honorific_suffix", honorific_suffix)
        pulumi.set(__self__, "middle_name", middle_name)

    @property
    @pulumi.getter(name="familyName")
    def family_name(self) -> builtins.str:
        """
        Family name of the user.
        """
        return pulumi.get(self, "family_name")

    @property
    @pulumi.getter
    def formatted(self) -> builtins.str:
        """
        Name that is typically displayed when the name is shown for display.
        """
        return pulumi.get(self, "formatted")

    @property
    @pulumi.getter(name="givenName")
    def given_name(self) -> builtins.str:
        """
        Given name of the user.
        """
        return pulumi.get(self, "given_name")

    @property
    @pulumi.getter(name="honorificPrefix")
    def honorific_prefix(self) -> builtins.str:
        """
        Honorific prefix of the user.
        """
        return pulumi.get(self, "honorific_prefix")

    @property
    @pulumi.getter(name="honorificSuffix")
    def honorific_suffix(self) -> builtins.str:
        """
        Honorific suffix of the user.
        """
        return pulumi.get(self, "honorific_suffix")

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> builtins.str:
        """
        Middle name of the user.
        """
        return pulumi.get(self, "middle_name")


@pulumi.output_type
class GetUsersUserPhoneNumberResult(dict):
    def __init__(__self__, *,
                 primary: builtins.bool,
                 type: builtins.str,
                 value: builtins.str):
        """
        :param builtins.bool primary: When `true`, this is the primary phone number associated with the user.
        :param builtins.str type: Type of phone number.
        :param builtins.str value: User's phone number.
        """
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def primary(self) -> builtins.bool:
        """
        When `true`, this is the primary phone number associated with the user.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of phone number.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        User's phone number.
        """
        return pulumi.get(self, "value")


