# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContainerRecipeArgs', 'ContainerRecipe']

@pulumi.input_type
class ContainerRecipeArgs:
    def __init__(__self__, *,
                 components: pulumi.Input[Sequence[pulumi.Input['ContainerRecipeComponentArgs']]],
                 container_type: pulumi.Input[builtins.str],
                 parent_image: pulumi.Input[builtins.str],
                 target_repository: pulumi.Input['ContainerRecipeTargetRepositoryArgs'],
                 version: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dockerfile_template_data: Optional[pulumi.Input[builtins.str]] = None,
                 dockerfile_template_uri: Optional[pulumi.Input[builtins.str]] = None,
                 instance_configuration: Optional[pulumi.Input['ContainerRecipeInstanceConfigurationArgs']] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 platform_override: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 working_directory: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ContainerRecipe resource.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerRecipeComponentArgs']]] components: Ordered configuration block(s) with components for the container recipe. Detailed below.
        :param pulumi.Input[builtins.str] container_type: The type of the container to create. Valid values: `DOCKER`.
        :param pulumi.Input[builtins.str] parent_image: The base image for the container recipe.
        :param pulumi.Input['ContainerRecipeTargetRepositoryArgs'] target_repository: The destination repository for the container image. Detailed below.
        :param pulumi.Input[builtins.str] version: Version of the container recipe.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] description: The description of the container recipe.
        :param pulumi.Input[builtins.str] dockerfile_template_data: The Dockerfile template used to build the image as an inline data blob.
        :param pulumi.Input[builtins.str] dockerfile_template_uri: The Amazon S3 URI for the Dockerfile that will be used to build the container image.
        :param pulumi.Input['ContainerRecipeInstanceConfigurationArgs'] instance_configuration: Configuration block used to configure an instance for building and testing container images. Detailed below.
        :param pulumi.Input[builtins.str] kms_key_id: The KMS key used to encrypt the container image.
        :param pulumi.Input[builtins.str] name: The name of the container recipe.
        :param pulumi.Input[builtins.str] platform_override: Specifies the operating system platform when you use a custom base image.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags for the container recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] working_directory: The working directory to be used during build and test workflows.
        """
        pulumi.set(__self__, "components", components)
        pulumi.set(__self__, "container_type", container_type)
        pulumi.set(__self__, "parent_image", parent_image)
        pulumi.set(__self__, "target_repository", target_repository)
        pulumi.set(__self__, "version", version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dockerfile_template_data is not None:
            pulumi.set(__self__, "dockerfile_template_data", dockerfile_template_data)
        if dockerfile_template_uri is not None:
            pulumi.set(__self__, "dockerfile_template_uri", dockerfile_template_uri)
        if instance_configuration is not None:
            pulumi.set(__self__, "instance_configuration", instance_configuration)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform_override is not None:
            pulumi.set(__self__, "platform_override", platform_override)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter
    def components(self) -> pulumi.Input[Sequence[pulumi.Input['ContainerRecipeComponentArgs']]]:
        """
        Ordered configuration block(s) with components for the container recipe. Detailed below.
        """
        return pulumi.get(self, "components")

    @components.setter
    def components(self, value: pulumi.Input[Sequence[pulumi.Input['ContainerRecipeComponentArgs']]]):
        pulumi.set(self, "components", value)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the container to create. Valid values: `DOCKER`.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="parentImage")
    def parent_image(self) -> pulumi.Input[builtins.str]:
        """
        The base image for the container recipe.
        """
        return pulumi.get(self, "parent_image")

    @parent_image.setter
    def parent_image(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parent_image", value)

    @property
    @pulumi.getter(name="targetRepository")
    def target_repository(self) -> pulumi.Input['ContainerRecipeTargetRepositoryArgs']:
        """
        The destination repository for the container image. Detailed below.
        """
        return pulumi.get(self, "target_repository")

    @target_repository.setter
    def target_repository(self, value: pulumi.Input['ContainerRecipeTargetRepositoryArgs']):
        pulumi.set(self, "target_repository", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[builtins.str]:
        """
        Version of the container recipe.

        The following arguments are optional:
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the container recipe.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dockerfileTemplateData")
    def dockerfile_template_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Dockerfile template used to build the image as an inline data blob.
        """
        return pulumi.get(self, "dockerfile_template_data")

    @dockerfile_template_data.setter
    def dockerfile_template_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dockerfile_template_data", value)

    @property
    @pulumi.getter(name="dockerfileTemplateUri")
    def dockerfile_template_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon S3 URI for the Dockerfile that will be used to build the container image.
        """
        return pulumi.get(self, "dockerfile_template_uri")

    @dockerfile_template_uri.setter
    def dockerfile_template_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dockerfile_template_uri", value)

    @property
    @pulumi.getter(name="instanceConfiguration")
    def instance_configuration(self) -> Optional[pulumi.Input['ContainerRecipeInstanceConfigurationArgs']]:
        """
        Configuration block used to configure an instance for building and testing container images. Detailed below.
        """
        return pulumi.get(self, "instance_configuration")

    @instance_configuration.setter
    def instance_configuration(self, value: Optional[pulumi.Input['ContainerRecipeInstanceConfigurationArgs']]):
        pulumi.set(self, "instance_configuration", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The KMS key used to encrypt the container image.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the container recipe.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="platformOverride")
    def platform_override(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the operating system platform when you use a custom base image.
        """
        return pulumi.get(self, "platform_override")

    @platform_override.setter
    def platform_override(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform_override", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags for the container recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The working directory to be used during build and test workflows.
        """
        return pulumi.get(self, "working_directory")

    @working_directory.setter
    def working_directory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "working_directory", value)


@pulumi.input_type
class _ContainerRecipeState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRecipeComponentArgs']]]] = None,
                 container_type: Optional[pulumi.Input[builtins.str]] = None,
                 date_created: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dockerfile_template_data: Optional[pulumi.Input[builtins.str]] = None,
                 dockerfile_template_uri: Optional[pulumi.Input[builtins.str]] = None,
                 encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_configuration: Optional[pulumi.Input['ContainerRecipeInstanceConfigurationArgs']] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 parent_image: Optional[pulumi.Input[builtins.str]] = None,
                 platform: Optional[pulumi.Input[builtins.str]] = None,
                 platform_override: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_repository: Optional[pulumi.Input['ContainerRecipeTargetRepositoryArgs']] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ContainerRecipe resources.
        :param pulumi.Input[builtins.str] arn: (Required) Amazon Resource Name (ARN) of the container recipe.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerRecipeComponentArgs']]] components: Ordered configuration block(s) with components for the container recipe. Detailed below.
        :param pulumi.Input[builtins.str] container_type: The type of the container to create. Valid values: `DOCKER`.
        :param pulumi.Input[builtins.str] date_created: Date the container recipe was created.
        :param pulumi.Input[builtins.str] description: The description of the container recipe.
        :param pulumi.Input[builtins.str] dockerfile_template_data: The Dockerfile template used to build the image as an inline data blob.
        :param pulumi.Input[builtins.str] dockerfile_template_uri: The Amazon S3 URI for the Dockerfile that will be used to build the container image.
        :param pulumi.Input[builtins.bool] encrypted: A flag that indicates if the target container is encrypted.
        :param pulumi.Input['ContainerRecipeInstanceConfigurationArgs'] instance_configuration: Configuration block used to configure an instance for building and testing container images. Detailed below.
        :param pulumi.Input[builtins.str] kms_key_id: The KMS key used to encrypt the container image.
        :param pulumi.Input[builtins.str] name: The name of the container recipe.
        :param pulumi.Input[builtins.str] owner: Owner of the container recipe.
        :param pulumi.Input[builtins.str] parent_image: The base image for the container recipe.
        :param pulumi.Input[builtins.str] platform: Platform of the container recipe.
        :param pulumi.Input[builtins.str] platform_override: Specifies the operating system platform when you use a custom base image.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags for the container recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['ContainerRecipeTargetRepositoryArgs'] target_repository: The destination repository for the container image. Detailed below.
        :param pulumi.Input[builtins.str] version: Version of the container recipe.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] working_directory: The working directory to be used during build and test workflows.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if components is not None:
            pulumi.set(__self__, "components", components)
        if container_type is not None:
            pulumi.set(__self__, "container_type", container_type)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dockerfile_template_data is not None:
            pulumi.set(__self__, "dockerfile_template_data", dockerfile_template_data)
        if dockerfile_template_uri is not None:
            pulumi.set(__self__, "dockerfile_template_uri", dockerfile_template_uri)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if instance_configuration is not None:
            pulumi.set(__self__, "instance_configuration", instance_configuration)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if parent_image is not None:
            pulumi.set(__self__, "parent_image", parent_image)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if platform_override is not None:
            pulumi.set(__self__, "platform_override", platform_override)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if target_repository is not None:
            pulumi.set(__self__, "target_repository", target_repository)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Required) Amazon Resource Name (ARN) of the container recipe.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRecipeComponentArgs']]]]:
        """
        Ordered configuration block(s) with components for the container recipe. Detailed below.
        """
        return pulumi.get(self, "components")

    @components.setter
    def components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRecipeComponentArgs']]]]):
        pulumi.set(self, "components", value)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the container to create. Valid values: `DOCKER`.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date the container recipe was created.
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "date_created", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the container recipe.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dockerfileTemplateData")
    def dockerfile_template_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Dockerfile template used to build the image as an inline data blob.
        """
        return pulumi.get(self, "dockerfile_template_data")

    @dockerfile_template_data.setter
    def dockerfile_template_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dockerfile_template_data", value)

    @property
    @pulumi.getter(name="dockerfileTemplateUri")
    def dockerfile_template_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon S3 URI for the Dockerfile that will be used to build the container image.
        """
        return pulumi.get(self, "dockerfile_template_uri")

    @dockerfile_template_uri.setter
    def dockerfile_template_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dockerfile_template_uri", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A flag that indicates if the target container is encrypted.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter(name="instanceConfiguration")
    def instance_configuration(self) -> Optional[pulumi.Input['ContainerRecipeInstanceConfigurationArgs']]:
        """
        Configuration block used to configure an instance for building and testing container images. Detailed below.
        """
        return pulumi.get(self, "instance_configuration")

    @instance_configuration.setter
    def instance_configuration(self, value: Optional[pulumi.Input['ContainerRecipeInstanceConfigurationArgs']]):
        pulumi.set(self, "instance_configuration", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The KMS key used to encrypt the container image.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the container recipe.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Owner of the container recipe.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="parentImage")
    def parent_image(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The base image for the container recipe.
        """
        return pulumi.get(self, "parent_image")

    @parent_image.setter
    def parent_image(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_image", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Platform of the container recipe.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="platformOverride")
    def platform_override(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the operating system platform when you use a custom base image.
        """
        return pulumi.get(self, "platform_override")

    @platform_override.setter
    def platform_override(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform_override", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags for the container recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="targetRepository")
    def target_repository(self) -> Optional[pulumi.Input['ContainerRecipeTargetRepositoryArgs']]:
        """
        The destination repository for the container image. Detailed below.
        """
        return pulumi.get(self, "target_repository")

    @target_repository.setter
    def target_repository(self, value: Optional[pulumi.Input['ContainerRecipeTargetRepositoryArgs']]):
        pulumi.set(self, "target_repository", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Version of the container recipe.

        The following arguments are optional:
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The working directory to be used during build and test workflows.
        """
        return pulumi.get(self, "working_directory")

    @working_directory.setter
    def working_directory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "working_directory", value)


@pulumi.type_token("aws:imagebuilder/containerRecipe:ContainerRecipe")
class ContainerRecipe(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerRecipeComponentArgs', 'ContainerRecipeComponentArgsDict']]]]] = None,
                 container_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dockerfile_template_data: Optional[pulumi.Input[builtins.str]] = None,
                 dockerfile_template_uri: Optional[pulumi.Input[builtins.str]] = None,
                 instance_configuration: Optional[pulumi.Input[Union['ContainerRecipeInstanceConfigurationArgs', 'ContainerRecipeInstanceConfigurationArgsDict']]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_image: Optional[pulumi.Input[builtins.str]] = None,
                 platform_override: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_repository: Optional[pulumi.Input[Union['ContainerRecipeTargetRepositoryArgs', 'ContainerRecipeTargetRepositoryArgsDict']]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an Image Builder Container Recipe.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.imagebuilder.ContainerRecipe("example",
            name="example",
            version="1.0.0",
            container_type="DOCKER",
            parent_image="arn:aws:imagebuilder:eu-central-1:aws:image/amazon-linux-x86-latest/x.x.x",
            target_repository={
                "repository_name": example_aws_ecr_repository["name"],
                "service": "ECR",
            },
            components=[{
                "component_arn": example_aws_imagebuilder_component["arn"],
                "parameters": [
                    {
                        "name": "Parameter1",
                        "value": "Value1",
                    },
                    {
                        "name": "Parameter2",
                        "value": "Value2",
                    },
                ],
            }],
            dockerfile_template_data=\"\"\"FROM {{{ imagebuilder:parentImage }}}
        {{{ imagebuilder:environments }}}
        {{{ imagebuilder:components }}}
        \"\"\")
        ```

        ## Import

        Using `pulumi import`, import `aws_imagebuilder_container_recipe` resources using the Amazon Resource Name (ARN). For example:

        ```sh
        $ pulumi import aws:imagebuilder/containerRecipe:ContainerRecipe example arn:aws:imagebuilder:us-east-1:123456789012:container-recipe/example/1.0.0
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerRecipeComponentArgs', 'ContainerRecipeComponentArgsDict']]]] components: Ordered configuration block(s) with components for the container recipe. Detailed below.
        :param pulumi.Input[builtins.str] container_type: The type of the container to create. Valid values: `DOCKER`.
        :param pulumi.Input[builtins.str] description: The description of the container recipe.
        :param pulumi.Input[builtins.str] dockerfile_template_data: The Dockerfile template used to build the image as an inline data blob.
        :param pulumi.Input[builtins.str] dockerfile_template_uri: The Amazon S3 URI for the Dockerfile that will be used to build the container image.
        :param pulumi.Input[Union['ContainerRecipeInstanceConfigurationArgs', 'ContainerRecipeInstanceConfigurationArgsDict']] instance_configuration: Configuration block used to configure an instance for building and testing container images. Detailed below.
        :param pulumi.Input[builtins.str] kms_key_id: The KMS key used to encrypt the container image.
        :param pulumi.Input[builtins.str] name: The name of the container recipe.
        :param pulumi.Input[builtins.str] parent_image: The base image for the container recipe.
        :param pulumi.Input[builtins.str] platform_override: Specifies the operating system platform when you use a custom base image.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags for the container recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['ContainerRecipeTargetRepositoryArgs', 'ContainerRecipeTargetRepositoryArgsDict']] target_repository: The destination repository for the container image. Detailed below.
        :param pulumi.Input[builtins.str] version: Version of the container recipe.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] working_directory: The working directory to be used during build and test workflows.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerRecipeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Image Builder Container Recipe.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.imagebuilder.ContainerRecipe("example",
            name="example",
            version="1.0.0",
            container_type="DOCKER",
            parent_image="arn:aws:imagebuilder:eu-central-1:aws:image/amazon-linux-x86-latest/x.x.x",
            target_repository={
                "repository_name": example_aws_ecr_repository["name"],
                "service": "ECR",
            },
            components=[{
                "component_arn": example_aws_imagebuilder_component["arn"],
                "parameters": [
                    {
                        "name": "Parameter1",
                        "value": "Value1",
                    },
                    {
                        "name": "Parameter2",
                        "value": "Value2",
                    },
                ],
            }],
            dockerfile_template_data=\"\"\"FROM {{{ imagebuilder:parentImage }}}
        {{{ imagebuilder:environments }}}
        {{{ imagebuilder:components }}}
        \"\"\")
        ```

        ## Import

        Using `pulumi import`, import `aws_imagebuilder_container_recipe` resources using the Amazon Resource Name (ARN). For example:

        ```sh
        $ pulumi import aws:imagebuilder/containerRecipe:ContainerRecipe example arn:aws:imagebuilder:us-east-1:123456789012:container-recipe/example/1.0.0
        ```

        :param str resource_name: The name of the resource.
        :param ContainerRecipeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerRecipeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerRecipeComponentArgs', 'ContainerRecipeComponentArgsDict']]]]] = None,
                 container_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dockerfile_template_data: Optional[pulumi.Input[builtins.str]] = None,
                 dockerfile_template_uri: Optional[pulumi.Input[builtins.str]] = None,
                 instance_configuration: Optional[pulumi.Input[Union['ContainerRecipeInstanceConfigurationArgs', 'ContainerRecipeInstanceConfigurationArgsDict']]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_image: Optional[pulumi.Input[builtins.str]] = None,
                 platform_override: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_repository: Optional[pulumi.Input[Union['ContainerRecipeTargetRepositoryArgs', 'ContainerRecipeTargetRepositoryArgsDict']]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerRecipeArgs.__new__(ContainerRecipeArgs)

            if components is None and not opts.urn:
                raise TypeError("Missing required property 'components'")
            __props__.__dict__["components"] = components
            if container_type is None and not opts.urn:
                raise TypeError("Missing required property 'container_type'")
            __props__.__dict__["container_type"] = container_type
            __props__.__dict__["description"] = description
            __props__.__dict__["dockerfile_template_data"] = dockerfile_template_data
            __props__.__dict__["dockerfile_template_uri"] = dockerfile_template_uri
            __props__.__dict__["instance_configuration"] = instance_configuration
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["name"] = name
            if parent_image is None and not opts.urn:
                raise TypeError("Missing required property 'parent_image'")
            __props__.__dict__["parent_image"] = parent_image
            __props__.__dict__["platform_override"] = platform_override
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            if target_repository is None and not opts.urn:
                raise TypeError("Missing required property 'target_repository'")
            __props__.__dict__["target_repository"] = target_repository
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["working_directory"] = working_directory
            __props__.__dict__["arn"] = None
            __props__.__dict__["date_created"] = None
            __props__.__dict__["encrypted"] = None
            __props__.__dict__["owner"] = None
            __props__.__dict__["platform"] = None
            __props__.__dict__["tags_all"] = None
        super(ContainerRecipe, __self__).__init__(
            'aws:imagebuilder/containerRecipe:ContainerRecipe',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            components: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerRecipeComponentArgs', 'ContainerRecipeComponentArgsDict']]]]] = None,
            container_type: Optional[pulumi.Input[builtins.str]] = None,
            date_created: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            dockerfile_template_data: Optional[pulumi.Input[builtins.str]] = None,
            dockerfile_template_uri: Optional[pulumi.Input[builtins.str]] = None,
            encrypted: Optional[pulumi.Input[builtins.bool]] = None,
            instance_configuration: Optional[pulumi.Input[Union['ContainerRecipeInstanceConfigurationArgs', 'ContainerRecipeInstanceConfigurationArgsDict']]] = None,
            kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            owner: Optional[pulumi.Input[builtins.str]] = None,
            parent_image: Optional[pulumi.Input[builtins.str]] = None,
            platform: Optional[pulumi.Input[builtins.str]] = None,
            platform_override: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            target_repository: Optional[pulumi.Input[Union['ContainerRecipeTargetRepositoryArgs', 'ContainerRecipeTargetRepositoryArgsDict']]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None,
            working_directory: Optional[pulumi.Input[builtins.str]] = None) -> 'ContainerRecipe':
        """
        Get an existing ContainerRecipe resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: (Required) Amazon Resource Name (ARN) of the container recipe.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerRecipeComponentArgs', 'ContainerRecipeComponentArgsDict']]]] components: Ordered configuration block(s) with components for the container recipe. Detailed below.
        :param pulumi.Input[builtins.str] container_type: The type of the container to create. Valid values: `DOCKER`.
        :param pulumi.Input[builtins.str] date_created: Date the container recipe was created.
        :param pulumi.Input[builtins.str] description: The description of the container recipe.
        :param pulumi.Input[builtins.str] dockerfile_template_data: The Dockerfile template used to build the image as an inline data blob.
        :param pulumi.Input[builtins.str] dockerfile_template_uri: The Amazon S3 URI for the Dockerfile that will be used to build the container image.
        :param pulumi.Input[builtins.bool] encrypted: A flag that indicates if the target container is encrypted.
        :param pulumi.Input[Union['ContainerRecipeInstanceConfigurationArgs', 'ContainerRecipeInstanceConfigurationArgsDict']] instance_configuration: Configuration block used to configure an instance for building and testing container images. Detailed below.
        :param pulumi.Input[builtins.str] kms_key_id: The KMS key used to encrypt the container image.
        :param pulumi.Input[builtins.str] name: The name of the container recipe.
        :param pulumi.Input[builtins.str] owner: Owner of the container recipe.
        :param pulumi.Input[builtins.str] parent_image: The base image for the container recipe.
        :param pulumi.Input[builtins.str] platform: Platform of the container recipe.
        :param pulumi.Input[builtins.str] platform_override: Specifies the operating system platform when you use a custom base image.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags for the container recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union['ContainerRecipeTargetRepositoryArgs', 'ContainerRecipeTargetRepositoryArgsDict']] target_repository: The destination repository for the container image. Detailed below.
        :param pulumi.Input[builtins.str] version: Version of the container recipe.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] working_directory: The working directory to be used during build and test workflows.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerRecipeState.__new__(_ContainerRecipeState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["components"] = components
        __props__.__dict__["container_type"] = container_type
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["description"] = description
        __props__.__dict__["dockerfile_template_data"] = dockerfile_template_data
        __props__.__dict__["dockerfile_template_uri"] = dockerfile_template_uri
        __props__.__dict__["encrypted"] = encrypted
        __props__.__dict__["instance_configuration"] = instance_configuration
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["parent_image"] = parent_image
        __props__.__dict__["platform"] = platform
        __props__.__dict__["platform_override"] = platform_override
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["target_repository"] = target_repository
        __props__.__dict__["version"] = version
        __props__.__dict__["working_directory"] = working_directory
        return ContainerRecipe(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        (Required) Amazon Resource Name (ARN) of the container recipe.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def components(self) -> pulumi.Output[Sequence['outputs.ContainerRecipeComponent']]:
        """
        Ordered configuration block(s) with components for the container recipe. Detailed below.
        """
        return pulumi.get(self, "components")

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the container to create. Valid values: `DOCKER`.
        """
        return pulumi.get(self, "container_type")

    @property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[builtins.str]:
        """
        Date the container recipe was created.
        """
        return pulumi.get(self, "date_created")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the container recipe.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dockerfileTemplateData")
    def dockerfile_template_data(self) -> pulumi.Output[builtins.str]:
        """
        The Dockerfile template used to build the image as an inline data blob.
        """
        return pulumi.get(self, "dockerfile_template_data")

    @property
    @pulumi.getter(name="dockerfileTemplateUri")
    def dockerfile_template_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon S3 URI for the Dockerfile that will be used to build the container image.
        """
        return pulumi.get(self, "dockerfile_template_uri")

    @property
    @pulumi.getter
    def encrypted(self) -> pulumi.Output[builtins.bool]:
        """
        A flag that indicates if the target container is encrypted.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter(name="instanceConfiguration")
    def instance_configuration(self) -> pulumi.Output[Optional['outputs.ContainerRecipeInstanceConfiguration']]:
        """
        Configuration block used to configure an instance for building and testing container images. Detailed below.
        """
        return pulumi.get(self, "instance_configuration")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The KMS key used to encrypt the container image.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the container recipe.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[builtins.str]:
        """
        Owner of the container recipe.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="parentImage")
    def parent_image(self) -> pulumi.Output[builtins.str]:
        """
        The base image for the container recipe.
        """
        return pulumi.get(self, "parent_image")

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Output[builtins.str]:
        """
        Platform of the container recipe.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="platformOverride")
    def platform_override(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the operating system platform when you use a custom base image.
        """
        return pulumi.get(self, "platform_override")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value map of resource tags for the container recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="targetRepository")
    def target_repository(self) -> pulumi.Output['outputs.ContainerRecipeTargetRepository']:
        """
        The destination repository for the container image. Detailed below.
        """
        return pulumi.get(self, "target_repository")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        Version of the container recipe.

        The following arguments are optional:
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The working directory to be used during build and test workflows.
        """
        return pulumi.get(self, "working_directory")

