# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDistributionConfigurationResult',
    'AwaitableGetDistributionConfigurationResult',
    'get_distribution_configuration',
    'get_distribution_configuration_output',
]

@pulumi.output_type
class GetDistributionConfigurationResult:
    """
    A collection of values returned by getDistributionConfiguration.
    """
    def __init__(__self__, arn=None, date_created=None, date_updated=None, description=None, distributions=None, id=None, name=None, region=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if date_updated and not isinstance(date_updated, str):
            raise TypeError("Expected argument 'date_updated' to be a str")
        pulumi.set(__self__, "date_updated", date_updated)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if distributions and not isinstance(distributions, list):
            raise TypeError("Expected argument 'distributions' to be a list")
        pulumi.set(__self__, "distributions", distributions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> builtins.str:
        """
        Date the distribution configuration was created.
        """
        return pulumi.get(self, "date_created")

    @property
    @pulumi.getter(name="dateUpdated")
    def date_updated(self) -> builtins.str:
        """
        Date the distribution configuration was updated.
        """
        return pulumi.get(self, "date_updated")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the container distribution configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def distributions(self) -> Sequence['outputs.GetDistributionConfigurationDistributionResult']:
        """
        Set of distributions.
        """
        return pulumi.get(self, "distributions")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the distribution configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        AWS Region of distribution.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Key-value map of resource tags for the distribution configuration.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDistributionConfigurationResult(GetDistributionConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDistributionConfigurationResult(
            arn=self.arn,
            date_created=self.date_created,
            date_updated=self.date_updated,
            description=self.description,
            distributions=self.distributions,
            id=self.id,
            name=self.name,
            region=self.region,
            tags=self.tags)


def get_distribution_configuration(arn: Optional[builtins.str] = None,
                                   region: Optional[builtins.str] = None,
                                   tags: Optional[Mapping[str, builtins.str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDistributionConfigurationResult:
    """
    Provides details about an Image Builder Distribution Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.imagebuilder.get_distribution_configuration(arn="arn:aws:imagebuilder:us-west-2:aws:distribution-configuration/example")
    ```


    :param builtins.str arn: ARN of the distribution configuration.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Key-value map of resource tags for the distribution configuration.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:imagebuilder/getDistributionConfiguration:getDistributionConfiguration', __args__, opts=opts, typ=GetDistributionConfigurationResult).value

    return AwaitableGetDistributionConfigurationResult(
        arn=pulumi.get(__ret__, 'arn'),
        date_created=pulumi.get(__ret__, 'date_created'),
        date_updated=pulumi.get(__ret__, 'date_updated'),
        description=pulumi.get(__ret__, 'description'),
        distributions=pulumi.get(__ret__, 'distributions'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_distribution_configuration_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                                          region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDistributionConfigurationResult]:
    """
    Provides details about an Image Builder Distribution Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.imagebuilder.get_distribution_configuration(arn="arn:aws:imagebuilder:us-west-2:aws:distribution-configuration/example")
    ```


    :param builtins.str arn: ARN of the distribution configuration.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Key-value map of resource tags for the distribution configuration.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:imagebuilder/getDistributionConfiguration:getDistributionConfiguration', __args__, opts=opts, typ=GetDistributionConfigurationResult)
    return __ret__.apply(lambda __response__: GetDistributionConfigurationResult(
        arn=pulumi.get(__response__, 'arn'),
        date_created=pulumi.get(__response__, 'date_created'),
        date_updated=pulumi.get(__response__, 'date_updated'),
        description=pulumi.get(__response__, 'description'),
        distributions=pulumi.get(__response__, 'distributions'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
