# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetImagePipelineResult',
    'AwaitableGetImagePipelineResult',
    'get_image_pipeline',
    'get_image_pipeline_output',
]

@pulumi.output_type
class GetImagePipelineResult:
    """
    A collection of values returned by getImagePipeline.
    """
    def __init__(__self__, arn=None, container_recipe_arn=None, date_created=None, date_last_run=None, date_next_run=None, date_updated=None, description=None, distribution_configuration_arn=None, enhanced_image_metadata_enabled=None, id=None, image_recipe_arn=None, image_scanning_configurations=None, image_tests_configurations=None, infrastructure_configuration_arn=None, name=None, platform=None, region=None, schedules=None, status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if container_recipe_arn and not isinstance(container_recipe_arn, str):
            raise TypeError("Expected argument 'container_recipe_arn' to be a str")
        pulumi.set(__self__, "container_recipe_arn", container_recipe_arn)
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if date_last_run and not isinstance(date_last_run, str):
            raise TypeError("Expected argument 'date_last_run' to be a str")
        pulumi.set(__self__, "date_last_run", date_last_run)
        if date_next_run and not isinstance(date_next_run, str):
            raise TypeError("Expected argument 'date_next_run' to be a str")
        pulumi.set(__self__, "date_next_run", date_next_run)
        if date_updated and not isinstance(date_updated, str):
            raise TypeError("Expected argument 'date_updated' to be a str")
        pulumi.set(__self__, "date_updated", date_updated)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if distribution_configuration_arn and not isinstance(distribution_configuration_arn, str):
            raise TypeError("Expected argument 'distribution_configuration_arn' to be a str")
        pulumi.set(__self__, "distribution_configuration_arn", distribution_configuration_arn)
        if enhanced_image_metadata_enabled and not isinstance(enhanced_image_metadata_enabled, bool):
            raise TypeError("Expected argument 'enhanced_image_metadata_enabled' to be a bool")
        pulumi.set(__self__, "enhanced_image_metadata_enabled", enhanced_image_metadata_enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_recipe_arn and not isinstance(image_recipe_arn, str):
            raise TypeError("Expected argument 'image_recipe_arn' to be a str")
        pulumi.set(__self__, "image_recipe_arn", image_recipe_arn)
        if image_scanning_configurations and not isinstance(image_scanning_configurations, list):
            raise TypeError("Expected argument 'image_scanning_configurations' to be a list")
        pulumi.set(__self__, "image_scanning_configurations", image_scanning_configurations)
        if image_tests_configurations and not isinstance(image_tests_configurations, list):
            raise TypeError("Expected argument 'image_tests_configurations' to be a list")
        pulumi.set(__self__, "image_tests_configurations", image_tests_configurations)
        if infrastructure_configuration_arn and not isinstance(infrastructure_configuration_arn, str):
            raise TypeError("Expected argument 'infrastructure_configuration_arn' to be a str")
        pulumi.set(__self__, "infrastructure_configuration_arn", infrastructure_configuration_arn)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if platform and not isinstance(platform, str):
            raise TypeError("Expected argument 'platform' to be a str")
        pulumi.set(__self__, "platform", platform)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if schedules and not isinstance(schedules, list):
            raise TypeError("Expected argument 'schedules' to be a list")
        pulumi.set(__self__, "schedules", schedules)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="containerRecipeArn")
    def container_recipe_arn(self) -> builtins.str:
        """
        ARN of the container recipe.
        """
        return pulumi.get(self, "container_recipe_arn")

    @property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> builtins.str:
        """
        Date the image pipeline was created.
        """
        return pulumi.get(self, "date_created")

    @property
    @pulumi.getter(name="dateLastRun")
    def date_last_run(self) -> builtins.str:
        """
        Date the image pipeline was last run.
        """
        return pulumi.get(self, "date_last_run")

    @property
    @pulumi.getter(name="dateNextRun")
    def date_next_run(self) -> builtins.str:
        """
        Date the image pipeline will run next.
        """
        return pulumi.get(self, "date_next_run")

    @property
    @pulumi.getter(name="dateUpdated")
    def date_updated(self) -> builtins.str:
        """
        Date the image pipeline was updated.
        """
        return pulumi.get(self, "date_updated")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the image pipeline.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="distributionConfigurationArn")
    def distribution_configuration_arn(self) -> builtins.str:
        """
        ARN of the Image Builder Distribution Configuration.
        """
        return pulumi.get(self, "distribution_configuration_arn")

    @property
    @pulumi.getter(name="enhancedImageMetadataEnabled")
    def enhanced_image_metadata_enabled(self) -> builtins.bool:
        """
        Whether additional information about the image being created is collected.
        """
        return pulumi.get(self, "enhanced_image_metadata_enabled")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageRecipeArn")
    def image_recipe_arn(self) -> builtins.str:
        """
        ARN of the image recipe.
        """
        return pulumi.get(self, "image_recipe_arn")

    @property
    @pulumi.getter(name="imageScanningConfigurations")
    def image_scanning_configurations(self) -> Sequence['outputs.GetImagePipelineImageScanningConfigurationResult']:
        return pulumi.get(self, "image_scanning_configurations")

    @property
    @pulumi.getter(name="imageTestsConfigurations")
    def image_tests_configurations(self) -> Sequence['outputs.GetImagePipelineImageTestsConfigurationResult']:
        """
        List of an object with image tests configuration.
        """
        return pulumi.get(self, "image_tests_configurations")

    @property
    @pulumi.getter(name="infrastructureConfigurationArn")
    def infrastructure_configuration_arn(self) -> builtins.str:
        """
        ARN of the Image Builder Infrastructure Configuration.
        """
        return pulumi.get(self, "infrastructure_configuration_arn")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the image pipeline.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def platform(self) -> builtins.str:
        """
        Platform of the image pipeline.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def schedules(self) -> Sequence['outputs.GetImagePipelineScheduleResult']:
        """
        List of an object with schedule settings.
        """
        return pulumi.get(self, "schedules")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Status of the image pipeline.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Key-value map of resource tags for the image pipeline.
        """
        return pulumi.get(self, "tags")


class AwaitableGetImagePipelineResult(GetImagePipelineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImagePipelineResult(
            arn=self.arn,
            container_recipe_arn=self.container_recipe_arn,
            date_created=self.date_created,
            date_last_run=self.date_last_run,
            date_next_run=self.date_next_run,
            date_updated=self.date_updated,
            description=self.description,
            distribution_configuration_arn=self.distribution_configuration_arn,
            enhanced_image_metadata_enabled=self.enhanced_image_metadata_enabled,
            id=self.id,
            image_recipe_arn=self.image_recipe_arn,
            image_scanning_configurations=self.image_scanning_configurations,
            image_tests_configurations=self.image_tests_configurations,
            infrastructure_configuration_arn=self.infrastructure_configuration_arn,
            name=self.name,
            platform=self.platform,
            region=self.region,
            schedules=self.schedules,
            status=self.status,
            tags=self.tags)


def get_image_pipeline(arn: Optional[builtins.str] = None,
                       region: Optional[builtins.str] = None,
                       tags: Optional[Mapping[str, builtins.str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImagePipelineResult:
    """
    Provides details about an Image Builder Image Pipeline.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.imagebuilder.get_image_pipeline(arn="arn:aws:imagebuilder:us-west-2:aws:image-pipeline/example")
    ```


    :param builtins.str arn: ARN of the image pipeline.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Key-value map of resource tags for the image pipeline.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:imagebuilder/getImagePipeline:getImagePipeline', __args__, opts=opts, typ=GetImagePipelineResult).value

    return AwaitableGetImagePipelineResult(
        arn=pulumi.get(__ret__, 'arn'),
        container_recipe_arn=pulumi.get(__ret__, 'container_recipe_arn'),
        date_created=pulumi.get(__ret__, 'date_created'),
        date_last_run=pulumi.get(__ret__, 'date_last_run'),
        date_next_run=pulumi.get(__ret__, 'date_next_run'),
        date_updated=pulumi.get(__ret__, 'date_updated'),
        description=pulumi.get(__ret__, 'description'),
        distribution_configuration_arn=pulumi.get(__ret__, 'distribution_configuration_arn'),
        enhanced_image_metadata_enabled=pulumi.get(__ret__, 'enhanced_image_metadata_enabled'),
        id=pulumi.get(__ret__, 'id'),
        image_recipe_arn=pulumi.get(__ret__, 'image_recipe_arn'),
        image_scanning_configurations=pulumi.get(__ret__, 'image_scanning_configurations'),
        image_tests_configurations=pulumi.get(__ret__, 'image_tests_configurations'),
        infrastructure_configuration_arn=pulumi.get(__ret__, 'infrastructure_configuration_arn'),
        name=pulumi.get(__ret__, 'name'),
        platform=pulumi.get(__ret__, 'platform'),
        region=pulumi.get(__ret__, 'region'),
        schedules=pulumi.get(__ret__, 'schedules'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_image_pipeline_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                              region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImagePipelineResult]:
    """
    Provides details about an Image Builder Image Pipeline.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.imagebuilder.get_image_pipeline(arn="arn:aws:imagebuilder:us-west-2:aws:image-pipeline/example")
    ```


    :param builtins.str arn: ARN of the image pipeline.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Key-value map of resource tags for the image pipeline.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:imagebuilder/getImagePipeline:getImagePipeline', __args__, opts=opts, typ=GetImagePipelineResult)
    return __ret__.apply(lambda __response__: GetImagePipelineResult(
        arn=pulumi.get(__response__, 'arn'),
        container_recipe_arn=pulumi.get(__response__, 'container_recipe_arn'),
        date_created=pulumi.get(__response__, 'date_created'),
        date_last_run=pulumi.get(__response__, 'date_last_run'),
        date_next_run=pulumi.get(__response__, 'date_next_run'),
        date_updated=pulumi.get(__response__, 'date_updated'),
        description=pulumi.get(__response__, 'description'),
        distribution_configuration_arn=pulumi.get(__response__, 'distribution_configuration_arn'),
        enhanced_image_metadata_enabled=pulumi.get(__response__, 'enhanced_image_metadata_enabled'),
        id=pulumi.get(__response__, 'id'),
        image_recipe_arn=pulumi.get(__response__, 'image_recipe_arn'),
        image_scanning_configurations=pulumi.get(__response__, 'image_scanning_configurations'),
        image_tests_configurations=pulumi.get(__response__, 'image_tests_configurations'),
        infrastructure_configuration_arn=pulumi.get(__response__, 'infrastructure_configuration_arn'),
        name=pulumi.get(__response__, 'name'),
        platform=pulumi.get(__response__, 'platform'),
        region=pulumi.get(__response__, 'region'),
        schedules=pulumi.get(__response__, 'schedules'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
