# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'RecordingConfigurationDestinationConfiguration',
    'RecordingConfigurationDestinationConfigurationS3',
    'RecordingConfigurationThumbnailConfiguration',
]

@pulumi.output_type
class RecordingConfigurationDestinationConfiguration(dict):
    def __init__(__self__, *,
                 s3: 'outputs.RecordingConfigurationDestinationConfigurationS3'):
        """
        :param 'RecordingConfigurationDestinationConfigurationS3Args' s3: S3 destination configuration where recorded videos will be stored.
        """
        pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> 'outputs.RecordingConfigurationDestinationConfigurationS3':
        """
        S3 destination configuration where recorded videos will be stored.
        """
        return pulumi.get(self, "s3")


@pulumi.output_type
class RecordingConfigurationDestinationConfigurationS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordingConfigurationDestinationConfigurationS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordingConfigurationDestinationConfigurationS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordingConfigurationDestinationConfigurationS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str):
        """
        :param builtins.str bucket_name: S3 bucket name where recorded videos will be stored.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "bucket_name", bucket_name)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        S3 bucket name where recorded videos will be stored.

        The following arguments are optional:
        """
        return pulumi.get(self, "bucket_name")


@pulumi.output_type
class RecordingConfigurationThumbnailConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordingMode":
            suggest = "recording_mode"
        elif key == "targetIntervalSeconds":
            suggest = "target_interval_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordingConfigurationThumbnailConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordingConfigurationThumbnailConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordingConfigurationThumbnailConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recording_mode: Optional[builtins.str] = None,
                 target_interval_seconds: Optional[builtins.int] = None):
        """
        :param builtins.str recording_mode: Thumbnail recording mode. Valid values: `DISABLED`, `INTERVAL`.
        :param builtins.int target_interval_seconds: The targeted thumbnail-generation interval in seconds.
        """
        if recording_mode is not None:
            pulumi.set(__self__, "recording_mode", recording_mode)
        if target_interval_seconds is not None:
            pulumi.set(__self__, "target_interval_seconds", target_interval_seconds)

    @property
    @pulumi.getter(name="recordingMode")
    def recording_mode(self) -> Optional[builtins.str]:
        """
        Thumbnail recording mode. Valid values: `DISABLED`, `INTERVAL`.
        """
        return pulumi.get(self, "recording_mode")

    @property
    @pulumi.getter(name="targetIntervalSeconds")
    def target_interval_seconds(self) -> Optional[builtins.int]:
        """
        The targeted thumbnail-generation interval in seconds.
        """
        return pulumi.get(self, "target_interval_seconds")


