# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataSourceArgs', 'DataSource']

@pulumi.input_type
class DataSourceArgs:
    def __init__(__self__, *,
                 index_id: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 configuration: Optional[pulumi.Input['DataSourceConfigurationArgs']] = None,
                 custom_document_enrichment_configuration: Optional[pulumi.Input['DataSourceCustomDocumentEnrichmentConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a DataSource resource.
        :param pulumi.Input[builtins.str] index_id: The identifier of the index for your Amazon Kendra data source.
        :param pulumi.Input[builtins.str] type: The type of data source repository. For an updated list of values, refer to [Valid Values for Type](https://docs.aws.amazon.com/kendra/latest/dg/API_CreateDataSource.html#Kendra-CreateDataSource-request-Type).
               
               The following arguments are optional:
        :param pulumi.Input['DataSourceConfigurationArgs'] configuration: A block with the configuration information to connect to your Data Source repository. You can't specify the `configuration` block when the `type` parameter is set to `CUSTOM`. Detailed below.
        :param pulumi.Input['DataSourceCustomDocumentEnrichmentConfigurationArgs'] custom_document_enrichment_configuration: A block with the configuration information for altering document metadata and content during the document ingestion process. For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html). Detailed below.
        :param pulumi.Input[builtins.str] description: A description for the Data Source connector.
        :param pulumi.Input[builtins.str] language_code: The code for a language. This allows you to support a language for all documents when creating the Data Source connector. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
        :param pulumi.Input[builtins.str] name: A name for your data source connector.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of a role with permission to access the data source connector. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html). You can't specify the `role_arn` parameter when the `type` parameter is set to `CUSTOM`. The `role_arn` parameter is required for all other data sources.
        :param pulumi.Input[builtins.str] schedule: Sets the frequency for Amazon Kendra to check the documents in your Data Source repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the `StartDataSourceSyncJob` API to update the index.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "index_id", index_id)
        pulumi.set(__self__, "type", type)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if custom_document_enrichment_configuration is not None:
            pulumi.set(__self__, "custom_document_enrichment_configuration", custom_document_enrichment_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the index for your Amazon Kendra data source.
        """
        return pulumi.get(self, "index_id")

    @index_id.setter
    def index_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "index_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of data source repository. For an updated list of values, refer to [Valid Values for Type](https://docs.aws.amazon.com/kendra/latest/dg/API_CreateDataSource.html#Kendra-CreateDataSource-request-Type).

        The following arguments are optional:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['DataSourceConfigurationArgs']]:
        """
        A block with the configuration information to connect to your Data Source repository. You can't specify the `configuration` block when the `type` parameter is set to `CUSTOM`. Detailed below.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['DataSourceConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="customDocumentEnrichmentConfiguration")
    def custom_document_enrichment_configuration(self) -> Optional[pulumi.Input['DataSourceCustomDocumentEnrichmentConfigurationArgs']]:
        """
        A block with the configuration information for altering document metadata and content during the document ingestion process. For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html). Detailed below.
        """
        return pulumi.get(self, "custom_document_enrichment_configuration")

    @custom_document_enrichment_configuration.setter
    def custom_document_enrichment_configuration(self, value: Optional[pulumi.Input['DataSourceCustomDocumentEnrichmentConfigurationArgs']]):
        pulumi.set(self, "custom_document_enrichment_configuration", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the Data Source connector.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The code for a language. This allows you to support a language for all documents when creating the Data Source connector. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name for your data source connector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of a role with permission to access the data source connector. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html). You can't specify the `role_arn` parameter when the `type` parameter is set to `CUSTOM`. The `role_arn` parameter is required for all other data sources.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets the frequency for Amazon Kendra to check the documents in your Data Source repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the `StartDataSourceSyncJob` API to update the index.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DataSourceState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input['DataSourceConfigurationArgs']] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 custom_document_enrichment_configuration: Optional[pulumi.Input['DataSourceCustomDocumentEnrichmentConfigurationArgs']] = None,
                 data_source_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 error_message: Optional[pulumi.Input[builtins.str]] = None,
                 index_id: Optional[pulumi.Input[builtins.str]] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DataSource resources.
        :param pulumi.Input[builtins.str] arn: ARN of the Data Source.
        :param pulumi.Input['DataSourceConfigurationArgs'] configuration: A block with the configuration information to connect to your Data Source repository. You can't specify the `configuration` block when the `type` parameter is set to `CUSTOM`. Detailed below.
        :param pulumi.Input[builtins.str] created_at: The Unix time stamp of when the Data Source was created.
        :param pulumi.Input['DataSourceCustomDocumentEnrichmentConfigurationArgs'] custom_document_enrichment_configuration: A block with the configuration information for altering document metadata and content during the document ingestion process. For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html). Detailed below.
        :param pulumi.Input[builtins.str] data_source_id: The unique identifiers of the Data Source.
        :param pulumi.Input[builtins.str] description: A description for the Data Source connector.
        :param pulumi.Input[builtins.str] error_message: When the Status field value is `FAILED`, contains a description of the error that caused the Data Source to fail.
        :param pulumi.Input[builtins.str] index_id: The identifier of the index for your Amazon Kendra data source.
        :param pulumi.Input[builtins.str] language_code: The code for a language. This allows you to support a language for all documents when creating the Data Source connector. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
        :param pulumi.Input[builtins.str] name: A name for your data source connector.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of a role with permission to access the data source connector. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html). You can't specify the `role_arn` parameter when the `type` parameter is set to `CUSTOM`. The `role_arn` parameter is required for all other data sources.
        :param pulumi.Input[builtins.str] schedule: Sets the frequency for Amazon Kendra to check the documents in your Data Source repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the `StartDataSourceSyncJob` API to update the index.
        :param pulumi.Input[builtins.str] status: The current status of the Data Source. When the status is `ACTIVE` the Data Source is ready to use. When the status is `FAILED`, the `error_message` field contains the reason that the Data Source failed.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] type: The type of data source repository. For an updated list of values, refer to [Valid Values for Type](https://docs.aws.amazon.com/kendra/latest/dg/API_CreateDataSource.html#Kendra-CreateDataSource-request-Type).
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] updated_at: The Unix time stamp of when the Data Source was last updated.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if custom_document_enrichment_configuration is not None:
            pulumi.set(__self__, "custom_document_enrichment_configuration", custom_document_enrichment_configuration)
        if data_source_id is not None:
            pulumi.set(__self__, "data_source_id", data_source_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if index_id is not None:
            pulumi.set(__self__, "index_id", index_id)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Data Source.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['DataSourceConfigurationArgs']]:
        """
        A block with the configuration information to connect to your Data Source repository. You can't specify the `configuration` block when the `type` parameter is set to `CUSTOM`. Detailed below.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['DataSourceConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Unix time stamp of when the Data Source was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="customDocumentEnrichmentConfiguration")
    def custom_document_enrichment_configuration(self) -> Optional[pulumi.Input['DataSourceCustomDocumentEnrichmentConfigurationArgs']]:
        """
        A block with the configuration information for altering document metadata and content during the document ingestion process. For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html). Detailed below.
        """
        return pulumi.get(self, "custom_document_enrichment_configuration")

    @custom_document_enrichment_configuration.setter
    def custom_document_enrichment_configuration(self, value: Optional[pulumi.Input['DataSourceCustomDocumentEnrichmentConfigurationArgs']]):
        pulumi.set(self, "custom_document_enrichment_configuration", value)

    @property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifiers of the Data Source.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_source_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the Data Source connector.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When the Status field value is `FAILED`, contains a description of the error that caused the Data Source to fail.
        """
        return pulumi.get(self, "error_message")

    @error_message.setter
    def error_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "error_message", value)

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the index for your Amazon Kendra data source.
        """
        return pulumi.get(self, "index_id")

    @index_id.setter
    def index_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "index_id", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The code for a language. This allows you to support a language for all documents when creating the Data Source connector. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name for your data source connector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of a role with permission to access the data source connector. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html). You can't specify the `role_arn` parameter when the `type` parameter is set to `CUSTOM`. The `role_arn` parameter is required for all other data sources.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets the frequency for Amazon Kendra to check the documents in your Data Source repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the `StartDataSourceSyncJob` API to update the index.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current status of the Data Source. When the status is `ACTIVE` the Data Source is ready to use. When the status is `FAILED`, the `error_message` field contains the reason that the Data Source failed.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of data source repository. For an updated list of values, refer to [Valid Values for Type](https://docs.aws.amazon.com/kendra/latest/dg/API_CreateDataSource.html#Kendra-CreateDataSource-request-Type).

        The following arguments are optional:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Unix time stamp of when the Data Source was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("aws:kendra/dataSource:DataSource")
class DataSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['DataSourceConfigurationArgs', 'DataSourceConfigurationArgsDict']]] = None,
                 custom_document_enrichment_configuration: Optional[pulumi.Input[Union['DataSourceCustomDocumentEnrichmentConfigurationArgs', 'DataSourceCustomDocumentEnrichmentConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 index_id: Optional[pulumi.Input[builtins.str]] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Kendra Data Source.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            description="example",
            language_code="en",
            type="CUSTOM",
            tags={
                "hello": "world",
            })
        ```

        ### S3 Connector

        ### With Schedule

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="S3",
            role_arn=example_aws_iam_role["arn"],
            schedule="cron(9 10 1 * ? *)",
            configuration={
                "s3_configuration": {
                    "bucket_name": example_aws_s3_bucket["id"],
                },
            })
        ```

        ### With Access Control List

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="S3",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "s3_configuration": {
                    "bucket_name": example_aws_s3_bucket["id"],
                    "access_control_list_configuration": {
                        "key_path": f"s3://{example_aws_s3_bucket['id']}/path-1",
                    },
                },
            })
        ```

        ### With Documents Metadata Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="S3",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "s3_configuration": {
                    "bucket_name": example_aws_s3_bucket["id"],
                    "exclusion_patterns": ["example"],
                    "inclusion_patterns": ["hello"],
                    "inclusion_prefixes": ["world"],
                    "documents_metadata_configuration": {
                        "s3_prefix": "example",
                    },
                },
            })
        ```

        ### Web Crawler Connector

        ### With Seed URLs

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "urls": {
                        "seed_url_configuration": {
                            "seed_urls": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            })
        ```

        ### With Site Maps

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "urls": {
                        "site_maps_configuration": {
                            "site_maps": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            })
        ```

        ### With Web Crawler Mode

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "urls": {
                        "seed_url_configuration": {
                            "web_crawler_mode": "SUBDOMAINS",
                            "seed_urls": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            })
        ```

        ### With Authentication Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "authentication_configuration": {
                        "basic_authentications": [{
                            "credentials": example_aws_secretsmanager_secret["arn"],
                            "host": "a.example.com",
                            "port": 443,
                        }],
                    },
                    "urls": {
                        "seed_url_configuration": {
                            "seed_urls": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[example_aws_secretsmanager_secret_version]))
        ```

        ### With Crawl Depth

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "crawl_depth": 3,
                    "urls": {
                        "seed_url_configuration": {
                            "seed_urls": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            })
        ```

        ### With Max Links Per Page

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "max_links_per_page": 100,
                    "urls": {
                        "seed_url_configuration": {
                            "seed_urls": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            })
        ```

        ### With Max Urls Per Minute Crawl Rate

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "max_urls_per_minute_crawl_rate": 300,
                    "urls": {
                        "seed_url_configuration": {
                            "seed_urls": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            })
        ```

        ### With Proxy Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "proxy_configuration": {
                        "credentials": example_aws_secretsmanager_secret["arn"],
                        "host": "a.example.com",
                        "port": 443,
                    },
                    "urls": {
                        "seed_url_configuration": {
                            "seed_urls": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[example_aws_secretsmanager_secret_version]))
        ```

        ### With URL Exclusion and Inclusion Patterns

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "url_exclusion_patterns": ["example"],
                    "url_inclusion_patterns": ["hello"],
                    "urls": {
                        "seed_url_configuration": {
                            "seed_urls": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            })
        ```

        ### With `WEBCRAWLERV2` Template

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="TEMPLATE",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "template_configuration": {
                    "template": json.dumps({
                        "connectionConfiguration": {
                            "repositoryEndpointMetadata": {
                                "seedUrlConnections": [{
                                    "seedUrl": "https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/kendra_index",
                                }],
                            },
                        },
                        "additionalProperties": {
                            "inclusionURLIndexPatterns": ["https:\\\\/\\\\/registry[.]terraform[.]io\\\\/providers\\\\/hashicorp\\\\/aws\\\\/latest\\\\/docs\\\\/resources\\\\/kendra_index"],
                        },
                        "version": "1.0.0",
                        "syncMode": "FULL_CRAWL",
                        "type": "WEBCRAWLERV2",
                    }),
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Kendra Data Source using the unique identifiers of the data_source and index separated by a slash (`/`). For example:

        ```sh
        $ pulumi import aws:kendra/dataSource:DataSource example 1045d08d-66ef-4882-b3ed-dfb7df183e90/b34dfdf7-1f2b-4704-9581-79e00296845f
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DataSourceConfigurationArgs', 'DataSourceConfigurationArgsDict']] configuration: A block with the configuration information to connect to your Data Source repository. You can't specify the `configuration` block when the `type` parameter is set to `CUSTOM`. Detailed below.
        :param pulumi.Input[Union['DataSourceCustomDocumentEnrichmentConfigurationArgs', 'DataSourceCustomDocumentEnrichmentConfigurationArgsDict']] custom_document_enrichment_configuration: A block with the configuration information for altering document metadata and content during the document ingestion process. For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html). Detailed below.
        :param pulumi.Input[builtins.str] description: A description for the Data Source connector.
        :param pulumi.Input[builtins.str] index_id: The identifier of the index for your Amazon Kendra data source.
        :param pulumi.Input[builtins.str] language_code: The code for a language. This allows you to support a language for all documents when creating the Data Source connector. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
        :param pulumi.Input[builtins.str] name: A name for your data source connector.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of a role with permission to access the data source connector. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html). You can't specify the `role_arn` parameter when the `type` parameter is set to `CUSTOM`. The `role_arn` parameter is required for all other data sources.
        :param pulumi.Input[builtins.str] schedule: Sets the frequency for Amazon Kendra to check the documents in your Data Source repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the `StartDataSourceSyncJob` API to update the index.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] type: The type of data source repository. For an updated list of values, refer to [Valid Values for Type](https://docs.aws.amazon.com/kendra/latest/dg/API_CreateDataSource.html#Kendra-CreateDataSource-request-Type).
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Kendra Data Source.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            description="example",
            language_code="en",
            type="CUSTOM",
            tags={
                "hello": "world",
            })
        ```

        ### S3 Connector

        ### With Schedule

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="S3",
            role_arn=example_aws_iam_role["arn"],
            schedule="cron(9 10 1 * ? *)",
            configuration={
                "s3_configuration": {
                    "bucket_name": example_aws_s3_bucket["id"],
                },
            })
        ```

        ### With Access Control List

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="S3",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "s3_configuration": {
                    "bucket_name": example_aws_s3_bucket["id"],
                    "access_control_list_configuration": {
                        "key_path": f"s3://{example_aws_s3_bucket['id']}/path-1",
                    },
                },
            })
        ```

        ### With Documents Metadata Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="S3",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "s3_configuration": {
                    "bucket_name": example_aws_s3_bucket["id"],
                    "exclusion_patterns": ["example"],
                    "inclusion_patterns": ["hello"],
                    "inclusion_prefixes": ["world"],
                    "documents_metadata_configuration": {
                        "s3_prefix": "example",
                    },
                },
            })
        ```

        ### Web Crawler Connector

        ### With Seed URLs

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "urls": {
                        "seed_url_configuration": {
                            "seed_urls": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            })
        ```

        ### With Site Maps

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "urls": {
                        "site_maps_configuration": {
                            "site_maps": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            })
        ```

        ### With Web Crawler Mode

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "urls": {
                        "seed_url_configuration": {
                            "web_crawler_mode": "SUBDOMAINS",
                            "seed_urls": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            })
        ```

        ### With Authentication Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "authentication_configuration": {
                        "basic_authentications": [{
                            "credentials": example_aws_secretsmanager_secret["arn"],
                            "host": "a.example.com",
                            "port": 443,
                        }],
                    },
                    "urls": {
                        "seed_url_configuration": {
                            "seed_urls": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[example_aws_secretsmanager_secret_version]))
        ```

        ### With Crawl Depth

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "crawl_depth": 3,
                    "urls": {
                        "seed_url_configuration": {
                            "seed_urls": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            })
        ```

        ### With Max Links Per Page

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "max_links_per_page": 100,
                    "urls": {
                        "seed_url_configuration": {
                            "seed_urls": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            })
        ```

        ### With Max Urls Per Minute Crawl Rate

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "max_urls_per_minute_crawl_rate": 300,
                    "urls": {
                        "seed_url_configuration": {
                            "seed_urls": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            })
        ```

        ### With Proxy Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "proxy_configuration": {
                        "credentials": example_aws_secretsmanager_secret["arn"],
                        "host": "a.example.com",
                        "port": 443,
                    },
                    "urls": {
                        "seed_url_configuration": {
                            "seed_urls": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[example_aws_secretsmanager_secret_version]))
        ```

        ### With URL Exclusion and Inclusion Patterns

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="WEBCRAWLER",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "web_crawler_configuration": {
                    "url_exclusion_patterns": ["example"],
                    "url_inclusion_patterns": ["hello"],
                    "urls": {
                        "seed_url_configuration": {
                            "seed_urls": ["REPLACE_WITH_YOUR_URL"],
                        },
                    },
                },
            })
        ```

        ### With `WEBCRAWLERV2` Template

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.kendra.DataSource("example",
            index_id=example_aws_kendra_index["id"],
            name="example",
            type="TEMPLATE",
            role_arn=example_aws_iam_role["arn"],
            configuration={
                "template_configuration": {
                    "template": json.dumps({
                        "connectionConfiguration": {
                            "repositoryEndpointMetadata": {
                                "seedUrlConnections": [{
                                    "seedUrl": "https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/kendra_index",
                                }],
                            },
                        },
                        "additionalProperties": {
                            "inclusionURLIndexPatterns": ["https:\\\\/\\\\/registry[.]terraform[.]io\\\\/providers\\\\/hashicorp\\\\/aws\\\\/latest\\\\/docs\\\\/resources\\\\/kendra_index"],
                        },
                        "version": "1.0.0",
                        "syncMode": "FULL_CRAWL",
                        "type": "WEBCRAWLERV2",
                    }),
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Kendra Data Source using the unique identifiers of the data_source and index separated by a slash (`/`). For example:

        ```sh
        $ pulumi import aws:kendra/dataSource:DataSource example 1045d08d-66ef-4882-b3ed-dfb7df183e90/b34dfdf7-1f2b-4704-9581-79e00296845f
        ```

        :param str resource_name: The name of the resource.
        :param DataSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['DataSourceConfigurationArgs', 'DataSourceConfigurationArgsDict']]] = None,
                 custom_document_enrichment_configuration: Optional[pulumi.Input[Union['DataSourceCustomDocumentEnrichmentConfigurationArgs', 'DataSourceCustomDocumentEnrichmentConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 index_id: Optional[pulumi.Input[builtins.str]] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataSourceArgs.__new__(DataSourceArgs)

            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["custom_document_enrichment_configuration"] = custom_document_enrichment_configuration
            __props__.__dict__["description"] = description
            if index_id is None and not opts.urn:
                raise TypeError("Missing required property 'index_id'")
            __props__.__dict__["index_id"] = index_id
            __props__.__dict__["language_code"] = language_code
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["data_source_id"] = None
            __props__.__dict__["error_message"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["updated_at"] = None
        super(DataSource, __self__).__init__(
            'aws:kendra/dataSource:DataSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            configuration: Optional[pulumi.Input[Union['DataSourceConfigurationArgs', 'DataSourceConfigurationArgsDict']]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            custom_document_enrichment_configuration: Optional[pulumi.Input[Union['DataSourceCustomDocumentEnrichmentConfigurationArgs', 'DataSourceCustomDocumentEnrichmentConfigurationArgsDict']]] = None,
            data_source_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            error_message: Optional[pulumi.Input[builtins.str]] = None,
            index_id: Optional[pulumi.Input[builtins.str]] = None,
            language_code: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            role_arn: Optional[pulumi.Input[builtins.str]] = None,
            schedule: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'DataSource':
        """
        Get an existing DataSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the Data Source.
        :param pulumi.Input[Union['DataSourceConfigurationArgs', 'DataSourceConfigurationArgsDict']] configuration: A block with the configuration information to connect to your Data Source repository. You can't specify the `configuration` block when the `type` parameter is set to `CUSTOM`. Detailed below.
        :param pulumi.Input[builtins.str] created_at: The Unix time stamp of when the Data Source was created.
        :param pulumi.Input[Union['DataSourceCustomDocumentEnrichmentConfigurationArgs', 'DataSourceCustomDocumentEnrichmentConfigurationArgsDict']] custom_document_enrichment_configuration: A block with the configuration information for altering document metadata and content during the document ingestion process. For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html). Detailed below.
        :param pulumi.Input[builtins.str] data_source_id: The unique identifiers of the Data Source.
        :param pulumi.Input[builtins.str] description: A description for the Data Source connector.
        :param pulumi.Input[builtins.str] error_message: When the Status field value is `FAILED`, contains a description of the error that caused the Data Source to fail.
        :param pulumi.Input[builtins.str] index_id: The identifier of the index for your Amazon Kendra data source.
        :param pulumi.Input[builtins.str] language_code: The code for a language. This allows you to support a language for all documents when creating the Data Source connector. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
        :param pulumi.Input[builtins.str] name: A name for your data source connector.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of a role with permission to access the data source connector. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html). You can't specify the `role_arn` parameter when the `type` parameter is set to `CUSTOM`. The `role_arn` parameter is required for all other data sources.
        :param pulumi.Input[builtins.str] schedule: Sets the frequency for Amazon Kendra to check the documents in your Data Source repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the `StartDataSourceSyncJob` API to update the index.
        :param pulumi.Input[builtins.str] status: The current status of the Data Source. When the status is `ACTIVE` the Data Source is ready to use. When the status is `FAILED`, the `error_message` field contains the reason that the Data Source failed.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] type: The type of data source repository. For an updated list of values, refer to [Valid Values for Type](https://docs.aws.amazon.com/kendra/latest/dg/API_CreateDataSource.html#Kendra-CreateDataSource-request-Type).
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] updated_at: The Unix time stamp of when the Data Source was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataSourceState.__new__(_DataSourceState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["custom_document_enrichment_configuration"] = custom_document_enrichment_configuration
        __props__.__dict__["data_source_id"] = data_source_id
        __props__.__dict__["description"] = description
        __props__.__dict__["error_message"] = error_message
        __props__.__dict__["index_id"] = index_id
        __props__.__dict__["language_code"] = language_code
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        return DataSource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Data Source.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Optional['outputs.DataSourceConfiguration']]:
        """
        A block with the configuration information to connect to your Data Source repository. You can't specify the `configuration` block when the `type` parameter is set to `CUSTOM`. Detailed below.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The Unix time stamp of when the Data Source was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customDocumentEnrichmentConfiguration")
    def custom_document_enrichment_configuration(self) -> pulumi.Output[Optional['outputs.DataSourceCustomDocumentEnrichmentConfiguration']]:
        """
        A block with the configuration information for altering document metadata and content during the document ingestion process. For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html). Detailed below.
        """
        return pulumi.get(self, "custom_document_enrichment_configuration")

    @property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifiers of the Data Source.
        """
        return pulumi.get(self, "data_source_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description for the Data Source connector.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> pulumi.Output[builtins.str]:
        """
        When the Status field value is `FAILED`, contains a description of the error that caused the Data Source to fail.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the index for your Amazon Kendra data source.
        """
        return pulumi.get(self, "index_id")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output[builtins.str]:
        """
        The code for a language. This allows you to support a language for all documents when creating the Data Source connector. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A name for your data source connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of a role with permission to access the data source connector. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html). You can't specify the `role_arn` parameter when the `type` parameter is set to `CUSTOM`. The `role_arn` parameter is required for all other data sources.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Sets the frequency for Amazon Kendra to check the documents in your Data Source repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the `StartDataSourceSyncJob` API to update the index.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The current status of the Data Source. When the status is `ACTIVE` the Data Source is ready to use. When the status is `FAILED`, the `error_message` field contains the reason that the Data Source failed.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of data source repository. For an updated list of values, refer to [Valid Values for Type](https://docs.aws.amazon.com/kendra/latest/dg/API_CreateDataSource.html#Kendra-CreateDataSource-request-Type).

        The following arguments are optional:
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The Unix time stamp of when the Data Source was last updated.
        """
        return pulumi.get(self, "updated_at")

