# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FaqArgs', 'Faq']

@pulumi.input_type
class FaqArgs:
    def __init__(__self__, *,
                 index_id: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str],
                 s3_path: pulumi.Input['FaqS3PathArgs'],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 file_format: Optional[pulumi.Input[builtins.str]] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Faq resource.
        :param pulumi.Input[builtins.str] index_id: The identifier of the index for a FAQ.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see [IAM Roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
        :param pulumi.Input['FaqS3PathArgs'] s3_path: The S3 location of the FAQ input data. Detailed below.
        :param pulumi.Input[builtins.str] name: The name that should be associated with the FAQ.
        """
        pulumi.set(__self__, "index_id", index_id)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "s3_path", s3_path)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_format is not None:
            pulumi.set(__self__, "file_format", file_format)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the index for a FAQ.
        """
        return pulumi.get(self, "index_id")

    @index_id.setter
    def index_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "index_id", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see [IAM Roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="s3Path")
    def s3_path(self) -> pulumi.Input['FaqS3PathArgs']:
        """
        The S3 location of the FAQ input data. Detailed below.
        """
        return pulumi.get(self, "s3_path")

    @s3_path.setter
    def s3_path(self, value: pulumi.Input['FaqS3PathArgs']):
        pulumi.set(self, "s3_path", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "file_format")

    @file_format.setter
    def file_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_format", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name that should be associated with the FAQ.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _FaqState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 error_message: Optional[pulumi.Input[builtins.str]] = None,
                 faq_id: Optional[pulumi.Input[builtins.str]] = None,
                 file_format: Optional[pulumi.Input[builtins.str]] = None,
                 index_id: Optional[pulumi.Input[builtins.str]] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 s3_path: Optional[pulumi.Input['FaqS3PathArgs']] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Faq resources.
        :param pulumi.Input[builtins.str] arn: ARN of the FAQ.
        :param pulumi.Input[builtins.str] created_at: The Unix datetime that the FAQ was created.
        :param pulumi.Input[builtins.str] error_message: When the Status field value is `FAILED`, this contains a message that explains why.
        :param pulumi.Input[builtins.str] faq_id: The identifier of the FAQ.
        :param pulumi.Input[builtins.str] index_id: The identifier of the index for a FAQ.
        :param pulumi.Input[builtins.str] name: The name that should be associated with the FAQ.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see [IAM Roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
        :param pulumi.Input['FaqS3PathArgs'] s3_path: The S3 location of the FAQ input data. Detailed below.
        :param pulumi.Input[builtins.str] status: The status of the FAQ. It is ready to use when the status is ACTIVE.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] updated_at: The date and time that the FAQ was last updated.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if faq_id is not None:
            pulumi.set(__self__, "faq_id", faq_id)
        if file_format is not None:
            pulumi.set(__self__, "file_format", file_format)
        if index_id is not None:
            pulumi.set(__self__, "index_id", index_id)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if s3_path is not None:
            pulumi.set(__self__, "s3_path", s3_path)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the FAQ.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Unix datetime that the FAQ was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When the Status field value is `FAILED`, this contains a message that explains why.
        """
        return pulumi.get(self, "error_message")

    @error_message.setter
    def error_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "error_message", value)

    @property
    @pulumi.getter(name="faqId")
    def faq_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the FAQ.
        """
        return pulumi.get(self, "faq_id")

    @faq_id.setter
    def faq_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "faq_id", value)

    @property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "file_format")

    @file_format.setter
    def file_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_format", value)

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the index for a FAQ.
        """
        return pulumi.get(self, "index_id")

    @index_id.setter
    def index_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "index_id", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name that should be associated with the FAQ.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see [IAM Roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="s3Path")
    def s3_path(self) -> Optional[pulumi.Input['FaqS3PathArgs']]:
        """
        The S3 location of the FAQ input data. Detailed below.
        """
        return pulumi.get(self, "s3_path")

    @s3_path.setter
    def s3_path(self, value: Optional[pulumi.Input['FaqS3PathArgs']]):
        pulumi.set(self, "s3_path", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the FAQ. It is ready to use when the status is ACTIVE.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time that the FAQ was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("aws:kendra/faq:Faq")
class Faq(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 file_format: Optional[pulumi.Input[builtins.str]] = None,
                 index_id: Optional[pulumi.Input[builtins.str]] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 s3_path: Optional[pulumi.Input[Union['FaqS3PathArgs', 'FaqS3PathArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Kendra FAQ.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Faq("example",
            index_id=example_aws_kendra_index["id"],
            name="Example",
            role_arn=example_aws_iam_role["arn"],
            s3_path={
                "bucket": example_aws_s3_bucket["id"],
                "key": example_aws_s3_object["key"],
            },
            tags={
                "Name": "Example Kendra Faq",
            })
        ```

        ### With File Format

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Faq("example",
            index_id=example_aws_kendra_index["id"],
            name="Example",
            file_format="CSV",
            role_arn=example_aws_iam_role["arn"],
            s3_path={
                "bucket": example_aws_s3_bucket["id"],
                "key": example_aws_s3_object["key"],
            })
        ```

        ### With Language Code

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Faq("example",
            index_id=example_aws_kendra_index["id"],
            name="Example",
            language_code="en",
            role_arn=example_aws_iam_role["arn"],
            s3_path={
                "bucket": example_aws_s3_bucket["id"],
                "key": example_aws_s3_object["key"],
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_kendra_faq` using the unique identifiers of the FAQ and index separated by a slash (`/`). For example:

        ```sh
        $ pulumi import aws:kendra/faq:Faq example faq-123456780/idx-8012925589
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] index_id: The identifier of the index for a FAQ.
        :param pulumi.Input[builtins.str] name: The name that should be associated with the FAQ.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see [IAM Roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
        :param pulumi.Input[Union['FaqS3PathArgs', 'FaqS3PathArgsDict']] s3_path: The S3 location of the FAQ input data. Detailed below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FaqArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Kendra FAQ.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Faq("example",
            index_id=example_aws_kendra_index["id"],
            name="Example",
            role_arn=example_aws_iam_role["arn"],
            s3_path={
                "bucket": example_aws_s3_bucket["id"],
                "key": example_aws_s3_object["key"],
            },
            tags={
                "Name": "Example Kendra Faq",
            })
        ```

        ### With File Format

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Faq("example",
            index_id=example_aws_kendra_index["id"],
            name="Example",
            file_format="CSV",
            role_arn=example_aws_iam_role["arn"],
            s3_path={
                "bucket": example_aws_s3_bucket["id"],
                "key": example_aws_s3_object["key"],
            })
        ```

        ### With Language Code

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Faq("example",
            index_id=example_aws_kendra_index["id"],
            name="Example",
            language_code="en",
            role_arn=example_aws_iam_role["arn"],
            s3_path={
                "bucket": example_aws_s3_bucket["id"],
                "key": example_aws_s3_object["key"],
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_kendra_faq` using the unique identifiers of the FAQ and index separated by a slash (`/`). For example:

        ```sh
        $ pulumi import aws:kendra/faq:Faq example faq-123456780/idx-8012925589
        ```

        :param str resource_name: The name of the resource.
        :param FaqArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FaqArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 file_format: Optional[pulumi.Input[builtins.str]] = None,
                 index_id: Optional[pulumi.Input[builtins.str]] = None,
                 language_code: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 s3_path: Optional[pulumi.Input[Union['FaqS3PathArgs', 'FaqS3PathArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FaqArgs.__new__(FaqArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["file_format"] = file_format
            if index_id is None and not opts.urn:
                raise TypeError("Missing required property 'index_id'")
            __props__.__dict__["index_id"] = index_id
            __props__.__dict__["language_code"] = language_code
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            if s3_path is None and not opts.urn:
                raise TypeError("Missing required property 's3_path'")
            __props__.__dict__["s3_path"] = s3_path
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["error_message"] = None
            __props__.__dict__["faq_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["updated_at"] = None
        super(Faq, __self__).__init__(
            'aws:kendra/faq:Faq',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            error_message: Optional[pulumi.Input[builtins.str]] = None,
            faq_id: Optional[pulumi.Input[builtins.str]] = None,
            file_format: Optional[pulumi.Input[builtins.str]] = None,
            index_id: Optional[pulumi.Input[builtins.str]] = None,
            language_code: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            role_arn: Optional[pulumi.Input[builtins.str]] = None,
            s3_path: Optional[pulumi.Input[Union['FaqS3PathArgs', 'FaqS3PathArgsDict']]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'Faq':
        """
        Get an existing Faq resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the FAQ.
        :param pulumi.Input[builtins.str] created_at: The Unix datetime that the FAQ was created.
        :param pulumi.Input[builtins.str] error_message: When the Status field value is `FAILED`, this contains a message that explains why.
        :param pulumi.Input[builtins.str] faq_id: The identifier of the FAQ.
        :param pulumi.Input[builtins.str] index_id: The identifier of the index for a FAQ.
        :param pulumi.Input[builtins.str] name: The name that should be associated with the FAQ.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see [IAM Roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
        :param pulumi.Input[Union['FaqS3PathArgs', 'FaqS3PathArgsDict']] s3_path: The S3 location of the FAQ input data. Detailed below.
        :param pulumi.Input[builtins.str] status: The status of the FAQ. It is ready to use when the status is ACTIVE.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] updated_at: The date and time that the FAQ was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FaqState.__new__(_FaqState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["error_message"] = error_message
        __props__.__dict__["faq_id"] = faq_id
        __props__.__dict__["file_format"] = file_format
        __props__.__dict__["index_id"] = index_id
        __props__.__dict__["language_code"] = language_code
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["s3_path"] = s3_path
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["updated_at"] = updated_at
        return Faq(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the FAQ.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The Unix datetime that the FAQ was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> pulumi.Output[builtins.str]:
        """
        When the Status field value is `FAILED`, this contains a message that explains why.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="faqId")
    def faq_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the FAQ.
        """
        return pulumi.get(self, "faq_id")

    @property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "file_format")

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the index for a FAQ.
        """
        return pulumi.get(self, "index_id")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name that should be associated with the FAQ.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more information, see [IAM Roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="s3Path")
    def s3_path(self) -> pulumi.Output['outputs.FaqS3Path']:
        """
        The S3 location of the FAQ input data. Detailed below.
        """
        return pulumi.get(self, "s3_path")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the FAQ. It is ready to use when the status is ACTIVE.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time that the FAQ was last updated.
        """
        return pulumi.get(self, "updated_at")

