# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IndexArgs', 'Index']

@pulumi.input_type
class IndexArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[builtins.str],
                 capacity_units: Optional[pulumi.Input['IndexCapacityUnitsArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 document_metadata_configuration_updates: Optional[pulumi.Input[Sequence[pulumi.Input['IndexDocumentMetadataConfigurationUpdateArgs']]]] = None,
                 edition: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input['IndexServerSideEncryptionConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 user_context_policy: Optional[pulumi.Input[builtins.str]] = None,
                 user_group_resolution_configuration: Optional[pulumi.Input['IndexUserGroupResolutionConfigurationArgs']] = None,
                 user_token_configurations: Optional[pulumi.Input['IndexUserTokenConfigurationsArgs']] = None):
        """
        The set of arguments for constructing a Index resource.
        :param pulumi.Input[builtins.str] role_arn: An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
        :param pulumi.Input['IndexCapacityUnitsArgs'] capacity_units: A block that sets the number of additional document storage and query capacity units that should be used by the index. Detailed below.
        :param pulumi.Input[builtins.str] description: The description of the Index.
        :param pulumi.Input[Sequence[pulumi.Input['IndexDocumentMetadataConfigurationUpdateArgs']]] document_metadata_configuration_updates: One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
        :param pulumi.Input[builtins.str] edition: The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for your production databases. Use `GEN_AI_ENTERPRISE_EDITION` for creating generative AI applications. Once you set the edition for an index, it can't be changed. Defaults to `ENTERPRISE_EDITION`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Index.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['IndexServerSideEncryptionConfigurationArgs'] server_side_encryption_configuration: A block that specifies the identifier of the AWS KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Tags to apply to the Index. If configured with a provider
               `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] user_context_policy: The user context policy. Valid values are `ATTRIBUTE_FILTER` or `USER_TOKEN`. For more information, refer to [UserContextPolicy](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html#kendra-CreateIndex-request-UserContextPolicy). Defaults to `ATTRIBUTE_FILTER`.
        :param pulumi.Input['IndexUserGroupResolutionConfigurationArgs'] user_group_resolution_configuration: A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). Detailed below.
        :param pulumi.Input['IndexUserTokenConfigurationsArgs'] user_token_configurations: A block that specifies the user token configuration. Detailed below.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if capacity_units is not None:
            pulumi.set(__self__, "capacity_units", capacity_units)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if document_metadata_configuration_updates is not None:
            pulumi.set(__self__, "document_metadata_configuration_updates", document_metadata_configuration_updates)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if server_side_encryption_configuration is not None:
            pulumi.set(__self__, "server_side_encryption_configuration", server_side_encryption_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_context_policy is not None:
            pulumi.set(__self__, "user_context_policy", user_context_policy)
        if user_group_resolution_configuration is not None:
            pulumi.set(__self__, "user_group_resolution_configuration", user_group_resolution_configuration)
        if user_token_configurations is not None:
            pulumi.set(__self__, "user_token_configurations", user_token_configurations)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="capacityUnits")
    def capacity_units(self) -> Optional[pulumi.Input['IndexCapacityUnitsArgs']]:
        """
        A block that sets the number of additional document storage and query capacity units that should be used by the index. Detailed below.
        """
        return pulumi.get(self, "capacity_units")

    @capacity_units.setter
    def capacity_units(self, value: Optional[pulumi.Input['IndexCapacityUnitsArgs']]):
        pulumi.set(self, "capacity_units", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Index.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="documentMetadataConfigurationUpdates")
    def document_metadata_configuration_updates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndexDocumentMetadataConfigurationUpdateArgs']]]]:
        """
        One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
        """
        return pulumi.get(self, "document_metadata_configuration_updates")

    @document_metadata_configuration_updates.setter
    def document_metadata_configuration_updates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndexDocumentMetadataConfigurationUpdateArgs']]]]):
        pulumi.set(self, "document_metadata_configuration_updates", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for your production databases. Use `GEN_AI_ENTERPRISE_EDITION` for creating generative AI applications. Once you set the edition for an index, it can't be changed. Defaults to `ENTERPRISE_EDITION`.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Index.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    def server_side_encryption_configuration(self) -> Optional[pulumi.Input['IndexServerSideEncryptionConfigurationArgs']]:
        """
        A block that specifies the identifier of the AWS KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs. Detailed below.
        """
        return pulumi.get(self, "server_side_encryption_configuration")

    @server_side_encryption_configuration.setter
    def server_side_encryption_configuration(self, value: Optional[pulumi.Input['IndexServerSideEncryptionConfigurationArgs']]):
        pulumi.set(self, "server_side_encryption_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Tags to apply to the Index. If configured with a provider
        `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userContextPolicy")
    def user_context_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user context policy. Valid values are `ATTRIBUTE_FILTER` or `USER_TOKEN`. For more information, refer to [UserContextPolicy](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html#kendra-CreateIndex-request-UserContextPolicy). Defaults to `ATTRIBUTE_FILTER`.
        """
        return pulumi.get(self, "user_context_policy")

    @user_context_policy.setter
    def user_context_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_context_policy", value)

    @property
    @pulumi.getter(name="userGroupResolutionConfiguration")
    def user_group_resolution_configuration(self) -> Optional[pulumi.Input['IndexUserGroupResolutionConfigurationArgs']]:
        """
        A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). Detailed below.
        """
        return pulumi.get(self, "user_group_resolution_configuration")

    @user_group_resolution_configuration.setter
    def user_group_resolution_configuration(self, value: Optional[pulumi.Input['IndexUserGroupResolutionConfigurationArgs']]):
        pulumi.set(self, "user_group_resolution_configuration", value)

    @property
    @pulumi.getter(name="userTokenConfigurations")
    def user_token_configurations(self) -> Optional[pulumi.Input['IndexUserTokenConfigurationsArgs']]:
        """
        A block that specifies the user token configuration. Detailed below.
        """
        return pulumi.get(self, "user_token_configurations")

    @user_token_configurations.setter
    def user_token_configurations(self, value: Optional[pulumi.Input['IndexUserTokenConfigurationsArgs']]):
        pulumi.set(self, "user_token_configurations", value)


@pulumi.input_type
class _IndexState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_units: Optional[pulumi.Input['IndexCapacityUnitsArgs']] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 document_metadata_configuration_updates: Optional[pulumi.Input[Sequence[pulumi.Input['IndexDocumentMetadataConfigurationUpdateArgs']]]] = None,
                 edition: Optional[pulumi.Input[builtins.str]] = None,
                 error_message: Optional[pulumi.Input[builtins.str]] = None,
                 index_statistics: Optional[pulumi.Input[Sequence[pulumi.Input['IndexIndexStatisticArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input['IndexServerSideEncryptionConfigurationArgs']] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 user_context_policy: Optional[pulumi.Input[builtins.str]] = None,
                 user_group_resolution_configuration: Optional[pulumi.Input['IndexUserGroupResolutionConfigurationArgs']] = None,
                 user_token_configurations: Optional[pulumi.Input['IndexUserTokenConfigurationsArgs']] = None):
        """
        Input properties used for looking up and filtering Index resources.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) of the Index.
        :param pulumi.Input['IndexCapacityUnitsArgs'] capacity_units: A block that sets the number of additional document storage and query capacity units that should be used by the index. Detailed below.
        :param pulumi.Input[builtins.str] created_at: The Unix datetime that the index was created.
        :param pulumi.Input[builtins.str] description: The description of the Index.
        :param pulumi.Input[Sequence[pulumi.Input['IndexDocumentMetadataConfigurationUpdateArgs']]] document_metadata_configuration_updates: One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
        :param pulumi.Input[builtins.str] edition: The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for your production databases. Use `GEN_AI_ENTERPRISE_EDITION` for creating generative AI applications. Once you set the edition for an index, it can't be changed. Defaults to `ENTERPRISE_EDITION`.
        :param pulumi.Input[builtins.str] error_message: When the Status field value is `FAILED`, this contains a message that explains why.
        :param pulumi.Input[Sequence[pulumi.Input['IndexIndexStatisticArgs']]] index_statistics: A block that provides information about the number of FAQ questions and answers and the number of text documents indexed. Detailed below.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Index.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] role_arn: An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
        :param pulumi.Input['IndexServerSideEncryptionConfigurationArgs'] server_side_encryption_configuration: A block that specifies the identifier of the AWS KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs. Detailed below.
        :param pulumi.Input[builtins.str] status: The current status of the index. When the value is `ACTIVE`, the index is ready for use. If the Status field value is `FAILED`, the `error_message` field contains a message that explains why.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Tags to apply to the Index. If configured with a provider
               `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] updated_at: The Unix datetime that the index was last updated.
        :param pulumi.Input[builtins.str] user_context_policy: The user context policy. Valid values are `ATTRIBUTE_FILTER` or `USER_TOKEN`. For more information, refer to [UserContextPolicy](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html#kendra-CreateIndex-request-UserContextPolicy). Defaults to `ATTRIBUTE_FILTER`.
        :param pulumi.Input['IndexUserGroupResolutionConfigurationArgs'] user_group_resolution_configuration: A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). Detailed below.
        :param pulumi.Input['IndexUserTokenConfigurationsArgs'] user_token_configurations: A block that specifies the user token configuration. Detailed below.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if capacity_units is not None:
            pulumi.set(__self__, "capacity_units", capacity_units)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if document_metadata_configuration_updates is not None:
            pulumi.set(__self__, "document_metadata_configuration_updates", document_metadata_configuration_updates)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if index_statistics is not None:
            pulumi.set(__self__, "index_statistics", index_statistics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if server_side_encryption_configuration is not None:
            pulumi.set(__self__, "server_side_encryption_configuration", server_side_encryption_configuration)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if user_context_policy is not None:
            pulumi.set(__self__, "user_context_policy", user_context_policy)
        if user_group_resolution_configuration is not None:
            pulumi.set(__self__, "user_group_resolution_configuration", user_group_resolution_configuration)
        if user_token_configurations is not None:
            pulumi.set(__self__, "user_token_configurations", user_token_configurations)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Index.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="capacityUnits")
    def capacity_units(self) -> Optional[pulumi.Input['IndexCapacityUnitsArgs']]:
        """
        A block that sets the number of additional document storage and query capacity units that should be used by the index. Detailed below.
        """
        return pulumi.get(self, "capacity_units")

    @capacity_units.setter
    def capacity_units(self, value: Optional[pulumi.Input['IndexCapacityUnitsArgs']]):
        pulumi.set(self, "capacity_units", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Unix datetime that the index was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Index.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="documentMetadataConfigurationUpdates")
    def document_metadata_configuration_updates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndexDocumentMetadataConfigurationUpdateArgs']]]]:
        """
        One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
        """
        return pulumi.get(self, "document_metadata_configuration_updates")

    @document_metadata_configuration_updates.setter
    def document_metadata_configuration_updates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndexDocumentMetadataConfigurationUpdateArgs']]]]):
        pulumi.set(self, "document_metadata_configuration_updates", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for your production databases. Use `GEN_AI_ENTERPRISE_EDITION` for creating generative AI applications. Once you set the edition for an index, it can't be changed. Defaults to `ENTERPRISE_EDITION`.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When the Status field value is `FAILED`, this contains a message that explains why.
        """
        return pulumi.get(self, "error_message")

    @error_message.setter
    def error_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "error_message", value)

    @property
    @pulumi.getter(name="indexStatistics")
    def index_statistics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndexIndexStatisticArgs']]]]:
        """
        A block that provides information about the number of FAQ questions and answers and the number of text documents indexed. Detailed below.
        """
        return pulumi.get(self, "index_statistics")

    @index_statistics.setter
    def index_statistics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndexIndexStatisticArgs']]]]):
        pulumi.set(self, "index_statistics", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Index.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    def server_side_encryption_configuration(self) -> Optional[pulumi.Input['IndexServerSideEncryptionConfigurationArgs']]:
        """
        A block that specifies the identifier of the AWS KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs. Detailed below.
        """
        return pulumi.get(self, "server_side_encryption_configuration")

    @server_side_encryption_configuration.setter
    def server_side_encryption_configuration(self, value: Optional[pulumi.Input['IndexServerSideEncryptionConfigurationArgs']]):
        pulumi.set(self, "server_side_encryption_configuration", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current status of the index. When the value is `ACTIVE`, the index is ready for use. If the Status field value is `FAILED`, the `error_message` field contains a message that explains why.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Tags to apply to the Index. If configured with a provider
        `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Unix datetime that the index was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="userContextPolicy")
    def user_context_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user context policy. Valid values are `ATTRIBUTE_FILTER` or `USER_TOKEN`. For more information, refer to [UserContextPolicy](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html#kendra-CreateIndex-request-UserContextPolicy). Defaults to `ATTRIBUTE_FILTER`.
        """
        return pulumi.get(self, "user_context_policy")

    @user_context_policy.setter
    def user_context_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_context_policy", value)

    @property
    @pulumi.getter(name="userGroupResolutionConfiguration")
    def user_group_resolution_configuration(self) -> Optional[pulumi.Input['IndexUserGroupResolutionConfigurationArgs']]:
        """
        A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). Detailed below.
        """
        return pulumi.get(self, "user_group_resolution_configuration")

    @user_group_resolution_configuration.setter
    def user_group_resolution_configuration(self, value: Optional[pulumi.Input['IndexUserGroupResolutionConfigurationArgs']]):
        pulumi.set(self, "user_group_resolution_configuration", value)

    @property
    @pulumi.getter(name="userTokenConfigurations")
    def user_token_configurations(self) -> Optional[pulumi.Input['IndexUserTokenConfigurationsArgs']]:
        """
        A block that specifies the user token configuration. Detailed below.
        """
        return pulumi.get(self, "user_token_configurations")

    @user_token_configurations.setter
    def user_token_configurations(self, value: Optional[pulumi.Input['IndexUserTokenConfigurationsArgs']]):
        pulumi.set(self, "user_token_configurations", value)


@pulumi.type_token("aws:kendra/index:Index")
class Index(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_units: Optional[pulumi.Input[Union['IndexCapacityUnitsArgs', 'IndexCapacityUnitsArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 document_metadata_configuration_updates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IndexDocumentMetadataConfigurationUpdateArgs', 'IndexDocumentMetadataConfigurationUpdateArgsDict']]]]] = None,
                 edition: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input[Union['IndexServerSideEncryptionConfigurationArgs', 'IndexServerSideEncryptionConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 user_context_policy: Optional[pulumi.Input[builtins.str]] = None,
                 user_group_resolution_configuration: Optional[pulumi.Input[Union['IndexUserGroupResolutionConfigurationArgs', 'IndexUserGroupResolutionConfigurationArgsDict']]] = None,
                 user_token_configurations: Optional[pulumi.Input[Union['IndexUserTokenConfigurationsArgs', 'IndexUserTokenConfigurationsArgsDict']]] = None,
                 __props__=None):
        """
        Provides an Amazon Kendra Index resource.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Index("example",
            name="example",
            description="example",
            edition="DEVELOPER_EDITION",
            role_arn=this["arn"],
            tags={
                "Key1": "Value1",
            })
        ```

        ### With capacity units

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Index("example",
            name="example",
            edition="DEVELOPER_EDITION",
            role_arn=this["arn"],
            capacity_units={
                "query_capacity_units": 2,
                "storage_capacity_units": 2,
            })
        ```

        ### With server side encryption configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Index("example",
            name="example",
            role_arn=this_aws_iam_role["arn"],
            server_side_encryption_configuration={
                "kms_key_id": this["arn"],
            })
        ```

        ### With user group resolution configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Index("example",
            name="example",
            role_arn=this["arn"],
            user_group_resolution_configuration={
                "user_group_resolution_mode": "AWS_SSO",
            })
        ```

        ### With Document Metadata Configuration Updates

        ### Specifying the predefined elements

        Refer to [Amazon Kendra documentation on built-in document fields](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html#index-reserved-fields) for more information.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Index("example",
            name="example",
            role_arn=this["arn"],
            document_metadata_configuration_updates=[
                {
                    "name": "_authors",
                    "type": "STRING_LIST_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": False,
                    },
                    "relevance": {
                        "importance": 1,
                    },
                },
                {
                    "name": "_category",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_created_at",
                    "type": "DATE_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "freshness": False,
                        "importance": 1,
                        "duration": "25920000s",
                        "rank_order": "ASCENDING",
                    },
                },
                {
                    "name": "_data_source_id",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_document_title",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": True,
                        "facetable": False,
                        "searchable": True,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 2,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_excerpt_page_number",
                    "type": "LONG_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": False,
                    },
                    "relevance": {
                        "importance": 2,
                        "rank_order": "ASCENDING",
                    },
                },
                {
                    "name": "_faq_id",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_file_type",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_language_code",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_last_updated_at",
                    "type": "DATE_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "freshness": False,
                        "importance": 1,
                        "duration": "25920000s",
                        "rank_order": "ASCENDING",
                    },
                },
                {
                    "name": "_source_uri",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": True,
                        "facetable": False,
                        "searchable": False,
                        "sortable": False,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_tenant_id",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_version",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_view_count",
                    "type": "LONG_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "rank_order": "ASCENDING",
                    },
                },
            ])
        ```

        ### Appending additional elements

        The example below shows additional elements with names, `example-string-value`, `example-long-value`, `example-string-list-value`, `example-date-value` representing the 4 types of `STRING_VALUE`, `LONG_VALUE`, `STRING_LIST_VALUE`, `DATE_VALUE` respectively.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Index("example",
            name="example",
            role_arn=this["arn"],
            document_metadata_configuration_updates=[
                {
                    "name": "_authors",
                    "type": "STRING_LIST_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": False,
                    },
                    "relevance": {
                        "importance": 1,
                    },
                },
                {
                    "name": "_category",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_created_at",
                    "type": "DATE_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "freshness": False,
                        "importance": 1,
                        "duration": "25920000s",
                        "rank_order": "ASCENDING",
                    },
                },
                {
                    "name": "_data_source_id",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_document_title",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": True,
                        "facetable": False,
                        "searchable": True,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 2,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_excerpt_page_number",
                    "type": "LONG_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": False,
                    },
                    "relevance": {
                        "importance": 2,
                        "rank_order": "ASCENDING",
                    },
                },
                {
                    "name": "_faq_id",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_file_type",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_language_code",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_last_updated_at",
                    "type": "DATE_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "freshness": False,
                        "importance": 1,
                        "duration": "25920000s",
                        "rank_order": "ASCENDING",
                    },
                },
                {
                    "name": "_source_uri",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": True,
                        "facetable": False,
                        "searchable": False,
                        "sortable": False,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_tenant_id",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_version",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_view_count",
                    "type": "LONG_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "rank_order": "ASCENDING",
                    },
                },
                {
                    "name": "example-string-value",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": True,
                        "facetable": True,
                        "searchable": True,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "example-long-value",
                    "type": "LONG_VALUE",
                    "search": {
                        "displayable": True,
                        "facetable": True,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "rank_order": "ASCENDING",
                    },
                },
                {
                    "name": "example-string-list-value",
                    "type": "STRING_LIST_VALUE",
                    "search": {
                        "displayable": True,
                        "facetable": True,
                        "searchable": True,
                        "sortable": False,
                    },
                    "relevance": {
                        "importance": 1,
                    },
                },
                {
                    "name": "example-date-value",
                    "type": "DATE_VALUE",
                    "search": {
                        "displayable": True,
                        "facetable": True,
                        "searchable": False,
                        "sortable": False,
                    },
                    "relevance": {
                        "freshness": False,
                        "importance": 1,
                        "duration": "25920000s",
                        "rank_order": "ASCENDING",
                    },
                },
            ])
        ```

        ### With JSON token type configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Index("example",
            name="example",
            role_arn=this["arn"],
            user_token_configurations={
                "json_token_type_configuration": {
                    "group_attribute_field": "groups",
                    "user_name_attribute_field": "username",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Amazon Kendra Indexes using its `id`. For example:

        ```sh
        $ pulumi import aws:kendra/index:Index example 12345678-1234-5678-9123-123456789123
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IndexCapacityUnitsArgs', 'IndexCapacityUnitsArgsDict']] capacity_units: A block that sets the number of additional document storage and query capacity units that should be used by the index. Detailed below.
        :param pulumi.Input[builtins.str] description: The description of the Index.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IndexDocumentMetadataConfigurationUpdateArgs', 'IndexDocumentMetadataConfigurationUpdateArgsDict']]]] document_metadata_configuration_updates: One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
        :param pulumi.Input[builtins.str] edition: The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for your production databases. Use `GEN_AI_ENTERPRISE_EDITION` for creating generative AI applications. Once you set the edition for an index, it can't be changed. Defaults to `ENTERPRISE_EDITION`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Index.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] role_arn: An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
        :param pulumi.Input[Union['IndexServerSideEncryptionConfigurationArgs', 'IndexServerSideEncryptionConfigurationArgsDict']] server_side_encryption_configuration: A block that specifies the identifier of the AWS KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Tags to apply to the Index. If configured with a provider
               `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] user_context_policy: The user context policy. Valid values are `ATTRIBUTE_FILTER` or `USER_TOKEN`. For more information, refer to [UserContextPolicy](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html#kendra-CreateIndex-request-UserContextPolicy). Defaults to `ATTRIBUTE_FILTER`.
        :param pulumi.Input[Union['IndexUserGroupResolutionConfigurationArgs', 'IndexUserGroupResolutionConfigurationArgsDict']] user_group_resolution_configuration: A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). Detailed below.
        :param pulumi.Input[Union['IndexUserTokenConfigurationsArgs', 'IndexUserTokenConfigurationsArgsDict']] user_token_configurations: A block that specifies the user token configuration. Detailed below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IndexArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Amazon Kendra Index resource.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Index("example",
            name="example",
            description="example",
            edition="DEVELOPER_EDITION",
            role_arn=this["arn"],
            tags={
                "Key1": "Value1",
            })
        ```

        ### With capacity units

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Index("example",
            name="example",
            edition="DEVELOPER_EDITION",
            role_arn=this["arn"],
            capacity_units={
                "query_capacity_units": 2,
                "storage_capacity_units": 2,
            })
        ```

        ### With server side encryption configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Index("example",
            name="example",
            role_arn=this_aws_iam_role["arn"],
            server_side_encryption_configuration={
                "kms_key_id": this["arn"],
            })
        ```

        ### With user group resolution configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Index("example",
            name="example",
            role_arn=this["arn"],
            user_group_resolution_configuration={
                "user_group_resolution_mode": "AWS_SSO",
            })
        ```

        ### With Document Metadata Configuration Updates

        ### Specifying the predefined elements

        Refer to [Amazon Kendra documentation on built-in document fields](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html#index-reserved-fields) for more information.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Index("example",
            name="example",
            role_arn=this["arn"],
            document_metadata_configuration_updates=[
                {
                    "name": "_authors",
                    "type": "STRING_LIST_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": False,
                    },
                    "relevance": {
                        "importance": 1,
                    },
                },
                {
                    "name": "_category",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_created_at",
                    "type": "DATE_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "freshness": False,
                        "importance": 1,
                        "duration": "25920000s",
                        "rank_order": "ASCENDING",
                    },
                },
                {
                    "name": "_data_source_id",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_document_title",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": True,
                        "facetable": False,
                        "searchable": True,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 2,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_excerpt_page_number",
                    "type": "LONG_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": False,
                    },
                    "relevance": {
                        "importance": 2,
                        "rank_order": "ASCENDING",
                    },
                },
                {
                    "name": "_faq_id",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_file_type",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_language_code",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_last_updated_at",
                    "type": "DATE_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "freshness": False,
                        "importance": 1,
                        "duration": "25920000s",
                        "rank_order": "ASCENDING",
                    },
                },
                {
                    "name": "_source_uri",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": True,
                        "facetable": False,
                        "searchable": False,
                        "sortable": False,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_tenant_id",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_version",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_view_count",
                    "type": "LONG_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "rank_order": "ASCENDING",
                    },
                },
            ])
        ```

        ### Appending additional elements

        The example below shows additional elements with names, `example-string-value`, `example-long-value`, `example-string-list-value`, `example-date-value` representing the 4 types of `STRING_VALUE`, `LONG_VALUE`, `STRING_LIST_VALUE`, `DATE_VALUE` respectively.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Index("example",
            name="example",
            role_arn=this["arn"],
            document_metadata_configuration_updates=[
                {
                    "name": "_authors",
                    "type": "STRING_LIST_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": False,
                    },
                    "relevance": {
                        "importance": 1,
                    },
                },
                {
                    "name": "_category",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_created_at",
                    "type": "DATE_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "freshness": False,
                        "importance": 1,
                        "duration": "25920000s",
                        "rank_order": "ASCENDING",
                    },
                },
                {
                    "name": "_data_source_id",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_document_title",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": True,
                        "facetable": False,
                        "searchable": True,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 2,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_excerpt_page_number",
                    "type": "LONG_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": False,
                    },
                    "relevance": {
                        "importance": 2,
                        "rank_order": "ASCENDING",
                    },
                },
                {
                    "name": "_faq_id",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_file_type",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_language_code",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_last_updated_at",
                    "type": "DATE_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "freshness": False,
                        "importance": 1,
                        "duration": "25920000s",
                        "rank_order": "ASCENDING",
                    },
                },
                {
                    "name": "_source_uri",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": True,
                        "facetable": False,
                        "searchable": False,
                        "sortable": False,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_tenant_id",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_version",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "_view_count",
                    "type": "LONG_VALUE",
                    "search": {
                        "displayable": False,
                        "facetable": False,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "rank_order": "ASCENDING",
                    },
                },
                {
                    "name": "example-string-value",
                    "type": "STRING_VALUE",
                    "search": {
                        "displayable": True,
                        "facetable": True,
                        "searchable": True,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "values_importance_map": {},
                    },
                },
                {
                    "name": "example-long-value",
                    "type": "LONG_VALUE",
                    "search": {
                        "displayable": True,
                        "facetable": True,
                        "searchable": False,
                        "sortable": True,
                    },
                    "relevance": {
                        "importance": 1,
                        "rank_order": "ASCENDING",
                    },
                },
                {
                    "name": "example-string-list-value",
                    "type": "STRING_LIST_VALUE",
                    "search": {
                        "displayable": True,
                        "facetable": True,
                        "searchable": True,
                        "sortable": False,
                    },
                    "relevance": {
                        "importance": 1,
                    },
                },
                {
                    "name": "example-date-value",
                    "type": "DATE_VALUE",
                    "search": {
                        "displayable": True,
                        "facetable": True,
                        "searchable": False,
                        "sortable": False,
                    },
                    "relevance": {
                        "freshness": False,
                        "importance": 1,
                        "duration": "25920000s",
                        "rank_order": "ASCENDING",
                    },
                },
            ])
        ```

        ### With JSON token type configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kendra.Index("example",
            name="example",
            role_arn=this["arn"],
            user_token_configurations={
                "json_token_type_configuration": {
                    "group_attribute_field": "groups",
                    "user_name_attribute_field": "username",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Amazon Kendra Indexes using its `id`. For example:

        ```sh
        $ pulumi import aws:kendra/index:Index example 12345678-1234-5678-9123-123456789123
        ```

        :param str resource_name: The name of the resource.
        :param IndexArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IndexArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_units: Optional[pulumi.Input[Union['IndexCapacityUnitsArgs', 'IndexCapacityUnitsArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 document_metadata_configuration_updates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IndexDocumentMetadataConfigurationUpdateArgs', 'IndexDocumentMetadataConfigurationUpdateArgsDict']]]]] = None,
                 edition: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input[Union['IndexServerSideEncryptionConfigurationArgs', 'IndexServerSideEncryptionConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 user_context_policy: Optional[pulumi.Input[builtins.str]] = None,
                 user_group_resolution_configuration: Optional[pulumi.Input[Union['IndexUserGroupResolutionConfigurationArgs', 'IndexUserGroupResolutionConfigurationArgsDict']]] = None,
                 user_token_configurations: Optional[pulumi.Input[Union['IndexUserTokenConfigurationsArgs', 'IndexUserTokenConfigurationsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IndexArgs.__new__(IndexArgs)

            __props__.__dict__["capacity_units"] = capacity_units
            __props__.__dict__["description"] = description
            __props__.__dict__["document_metadata_configuration_updates"] = document_metadata_configuration_updates
            __props__.__dict__["edition"] = edition
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["server_side_encryption_configuration"] = server_side_encryption_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_context_policy"] = user_context_policy
            __props__.__dict__["user_group_resolution_configuration"] = user_group_resolution_configuration
            __props__.__dict__["user_token_configurations"] = user_token_configurations
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["error_message"] = None
            __props__.__dict__["index_statistics"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["updated_at"] = None
        super(Index, __self__).__init__(
            'aws:kendra/index:Index',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            capacity_units: Optional[pulumi.Input[Union['IndexCapacityUnitsArgs', 'IndexCapacityUnitsArgsDict']]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            document_metadata_configuration_updates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IndexDocumentMetadataConfigurationUpdateArgs', 'IndexDocumentMetadataConfigurationUpdateArgsDict']]]]] = None,
            edition: Optional[pulumi.Input[builtins.str]] = None,
            error_message: Optional[pulumi.Input[builtins.str]] = None,
            index_statistics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IndexIndexStatisticArgs', 'IndexIndexStatisticArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            role_arn: Optional[pulumi.Input[builtins.str]] = None,
            server_side_encryption_configuration: Optional[pulumi.Input[Union['IndexServerSideEncryptionConfigurationArgs', 'IndexServerSideEncryptionConfigurationArgsDict']]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            user_context_policy: Optional[pulumi.Input[builtins.str]] = None,
            user_group_resolution_configuration: Optional[pulumi.Input[Union['IndexUserGroupResolutionConfigurationArgs', 'IndexUserGroupResolutionConfigurationArgsDict']]] = None,
            user_token_configurations: Optional[pulumi.Input[Union['IndexUserTokenConfigurationsArgs', 'IndexUserTokenConfigurationsArgsDict']]] = None) -> 'Index':
        """
        Get an existing Index resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) of the Index.
        :param pulumi.Input[Union['IndexCapacityUnitsArgs', 'IndexCapacityUnitsArgsDict']] capacity_units: A block that sets the number of additional document storage and query capacity units that should be used by the index. Detailed below.
        :param pulumi.Input[builtins.str] created_at: The Unix datetime that the index was created.
        :param pulumi.Input[builtins.str] description: The description of the Index.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IndexDocumentMetadataConfigurationUpdateArgs', 'IndexDocumentMetadataConfigurationUpdateArgsDict']]]] document_metadata_configuration_updates: One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
        :param pulumi.Input[builtins.str] edition: The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for your production databases. Use `GEN_AI_ENTERPRISE_EDITION` for creating generative AI applications. Once you set the edition for an index, it can't be changed. Defaults to `ENTERPRISE_EDITION`.
        :param pulumi.Input[builtins.str] error_message: When the Status field value is `FAILED`, this contains a message that explains why.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IndexIndexStatisticArgs', 'IndexIndexStatisticArgsDict']]]] index_statistics: A block that provides information about the number of FAQ questions and answers and the number of text documents indexed. Detailed below.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Index.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] role_arn: An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
        :param pulumi.Input[Union['IndexServerSideEncryptionConfigurationArgs', 'IndexServerSideEncryptionConfigurationArgsDict']] server_side_encryption_configuration: A block that specifies the identifier of the AWS KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs. Detailed below.
        :param pulumi.Input[builtins.str] status: The current status of the index. When the value is `ACTIVE`, the index is ready for use. If the Status field value is `FAILED`, the `error_message` field contains a message that explains why.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Tags to apply to the Index. If configured with a provider
               `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] updated_at: The Unix datetime that the index was last updated.
        :param pulumi.Input[builtins.str] user_context_policy: The user context policy. Valid values are `ATTRIBUTE_FILTER` or `USER_TOKEN`. For more information, refer to [UserContextPolicy](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html#kendra-CreateIndex-request-UserContextPolicy). Defaults to `ATTRIBUTE_FILTER`.
        :param pulumi.Input[Union['IndexUserGroupResolutionConfigurationArgs', 'IndexUserGroupResolutionConfigurationArgsDict']] user_group_resolution_configuration: A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). Detailed below.
        :param pulumi.Input[Union['IndexUserTokenConfigurationsArgs', 'IndexUserTokenConfigurationsArgsDict']] user_token_configurations: A block that specifies the user token configuration. Detailed below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IndexState.__new__(_IndexState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["capacity_units"] = capacity_units
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["document_metadata_configuration_updates"] = document_metadata_configuration_updates
        __props__.__dict__["edition"] = edition
        __props__.__dict__["error_message"] = error_message
        __props__.__dict__["index_statistics"] = index_statistics
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["server_side_encryption_configuration"] = server_side_encryption_configuration
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["user_context_policy"] = user_context_policy
        __props__.__dict__["user_group_resolution_configuration"] = user_group_resolution_configuration
        __props__.__dict__["user_token_configurations"] = user_token_configurations
        return Index(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Index.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="capacityUnits")
    def capacity_units(self) -> pulumi.Output['outputs.IndexCapacityUnits']:
        """
        A block that sets the number of additional document storage and query capacity units that should be used by the index. Detailed below.
        """
        return pulumi.get(self, "capacity_units")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The Unix datetime that the index was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Index.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="documentMetadataConfigurationUpdates")
    def document_metadata_configuration_updates(self) -> pulumi.Output[Sequence['outputs.IndexDocumentMetadataConfigurationUpdate']]:
        """
        One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Minimum number of 0 items. Maximum number of 500 items. If specified, you must define all elements, including those that are provided by default. These index fields are documented at [Amazon Kendra Index documentation](https://docs.aws.amazon.com/kendra/latest/dg/hiw-index.html). For an example resource that defines these default index fields, refer to the default example above. For an example resource that appends additional index fields, refer to the append example above. All arguments for each block must be specified. Note that blocks cannot be removed since index fields cannot be deleted. This argument is detailed below.
        """
        return pulumi.get(self, "document_metadata_configuration_updates")

    @property
    @pulumi.getter
    def edition(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for your production databases. Use `GEN_AI_ENTERPRISE_EDITION` for creating generative AI applications. Once you set the edition for an index, it can't be changed. Defaults to `ENTERPRISE_EDITION`.
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> pulumi.Output[builtins.str]:
        """
        When the Status field value is `FAILED`, this contains a message that explains why.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="indexStatistics")
    def index_statistics(self) -> pulumi.Output[Sequence['outputs.IndexIndexStatistic']]:
        """
        A block that provides information about the number of FAQ questions and answers and the number of text documents indexed. Detailed below.
        """
        return pulumi.get(self, "index_statistics")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Index.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[builtins.str]:
        """
        An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    def server_side_encryption_configuration(self) -> pulumi.Output[Optional['outputs.IndexServerSideEncryptionConfiguration']]:
        """
        A block that specifies the identifier of the AWS KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs. Detailed below.
        """
        return pulumi.get(self, "server_side_encryption_configuration")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The current status of the index. When the value is `ACTIVE`, the index is ready for use. If the Status field value is `FAILED`, the `error_message` field contains a message that explains why.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Tags to apply to the Index. If configured with a provider
        `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The Unix datetime that the index was last updated.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userContextPolicy")
    def user_context_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user context policy. Valid values are `ATTRIBUTE_FILTER` or `USER_TOKEN`. For more information, refer to [UserContextPolicy](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html#kendra-CreateIndex-request-UserContextPolicy). Defaults to `ATTRIBUTE_FILTER`.
        """
        return pulumi.get(self, "user_context_policy")

    @property
    @pulumi.getter(name="userGroupResolutionConfiguration")
    def user_group_resolution_configuration(self) -> pulumi.Output[Optional['outputs.IndexUserGroupResolutionConfiguration']]:
        """
        A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html). Detailed below.
        """
        return pulumi.get(self, "user_group_resolution_configuration")

    @property
    @pulumi.getter(name="userTokenConfigurations")
    def user_token_configurations(self) -> pulumi.Output[Optional['outputs.IndexUserTokenConfigurations']]:
        """
        A block that specifies the user token configuration. Detailed below.
        """
        return pulumi.get(self, "user_token_configurations")

