# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AnalyticsApplicationArgs', 'AnalyticsApplication']

@pulumi.input_type
class AnalyticsApplicationArgs:
    def __init__(__self__, *,
                 cloudwatch_logging_options: Optional[pulumi.Input['AnalyticsApplicationCloudwatchLoggingOptionsArgs']] = None,
                 code: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 inputs: Optional[pulumi.Input['AnalyticsApplicationInputsArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsApplicationOutputArgs']]]] = None,
                 reference_data_sources: Optional[pulumi.Input['AnalyticsApplicationReferenceDataSourcesArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 start_application: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a AnalyticsApplication resource.
        :param pulumi.Input['AnalyticsApplicationCloudwatchLoggingOptionsArgs'] cloudwatch_logging_options: The CloudWatch log stream options to monitor application errors.
               See CloudWatch Logging Options below for more details.
        :param pulumi.Input[builtins.str] code: SQL Code to transform input data, and generate output.
        :param pulumi.Input[builtins.str] description: Description of the application.
        :param pulumi.Input['AnalyticsApplicationInputsArgs'] inputs: Input configuration of the application. See Inputs below for more details.
        :param pulumi.Input[builtins.str] name: Name of the Kinesis Analytics Application.
        :param pulumi.Input[Sequence[pulumi.Input['AnalyticsApplicationOutputArgs']]] outputs: Output destination configuration of the application. See Outputs below for more details.
        :param pulumi.Input['AnalyticsApplicationReferenceDataSourcesArgs'] reference_data_sources: An S3 Reference Data Source for the application.
               See Reference Data Sources below for more details.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] start_application: Whether to start or stop the Kinesis Analytics Application. To start an application, an input with a defined `starting_position` must be configured.
               To modify an application's starting position, first stop the application by setting `start_application = false`, then update `starting_position` and set `start_application = true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of tags for the Kinesis Analytics Application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if cloudwatch_logging_options is not None:
            pulumi.set(__self__, "cloudwatch_logging_options", cloudwatch_logging_options)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if reference_data_sources is not None:
            pulumi.set(__self__, "reference_data_sources", reference_data_sources)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if start_application is not None:
            pulumi.set(__self__, "start_application", start_application)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="cloudwatchLoggingOptions")
    def cloudwatch_logging_options(self) -> Optional[pulumi.Input['AnalyticsApplicationCloudwatchLoggingOptionsArgs']]:
        """
        The CloudWatch log stream options to monitor application errors.
        See CloudWatch Logging Options below for more details.
        """
        return pulumi.get(self, "cloudwatch_logging_options")

    @cloudwatch_logging_options.setter
    def cloudwatch_logging_options(self, value: Optional[pulumi.Input['AnalyticsApplicationCloudwatchLoggingOptionsArgs']]):
        pulumi.set(self, "cloudwatch_logging_options", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SQL Code to transform input data, and generate output.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the application.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input['AnalyticsApplicationInputsArgs']]:
        """
        Input configuration of the application. See Inputs below for more details.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input['AnalyticsApplicationInputsArgs']]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Kinesis Analytics Application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsApplicationOutputArgs']]]]:
        """
        Output destination configuration of the application. See Outputs below for more details.
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsApplicationOutputArgs']]]]):
        pulumi.set(self, "outputs", value)

    @property
    @pulumi.getter(name="referenceDataSources")
    def reference_data_sources(self) -> Optional[pulumi.Input['AnalyticsApplicationReferenceDataSourcesArgs']]:
        """
        An S3 Reference Data Source for the application.
        See Reference Data Sources below for more details.
        """
        return pulumi.get(self, "reference_data_sources")

    @reference_data_sources.setter
    def reference_data_sources(self, value: Optional[pulumi.Input['AnalyticsApplicationReferenceDataSourcesArgs']]):
        pulumi.set(self, "reference_data_sources", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="startApplication")
    def start_application(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to start or stop the Kinesis Analytics Application. To start an application, an input with a defined `starting_position` must be configured.
        To modify an application's starting position, first stop the application by setting `start_application = false`, then update `starting_position` and set `start_application = true`.
        """
        return pulumi.get(self, "start_application")

    @start_application.setter
    def start_application(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "start_application", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of tags for the Kinesis Analytics Application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AnalyticsApplicationState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 cloudwatch_logging_options: Optional[pulumi.Input['AnalyticsApplicationCloudwatchLoggingOptionsArgs']] = None,
                 code: Optional[pulumi.Input[builtins.str]] = None,
                 create_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 inputs: Optional[pulumi.Input['AnalyticsApplicationInputsArgs']] = None,
                 last_update_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsApplicationOutputArgs']]]] = None,
                 reference_data_sources: Optional[pulumi.Input['AnalyticsApplicationReferenceDataSourcesArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 start_application: Optional[pulumi.Input[builtins.bool]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering AnalyticsApplication resources.
        :param pulumi.Input[builtins.str] arn: The ARN of the Kinesis Analytics Appliation.
        :param pulumi.Input['AnalyticsApplicationCloudwatchLoggingOptionsArgs'] cloudwatch_logging_options: The CloudWatch log stream options to monitor application errors.
               See CloudWatch Logging Options below for more details.
        :param pulumi.Input[builtins.str] code: SQL Code to transform input data, and generate output.
        :param pulumi.Input[builtins.str] create_timestamp: The Timestamp when the application version was created.
        :param pulumi.Input[builtins.str] description: Description of the application.
        :param pulumi.Input['AnalyticsApplicationInputsArgs'] inputs: Input configuration of the application. See Inputs below for more details.
        :param pulumi.Input[builtins.str] last_update_timestamp: The Timestamp when the application was last updated.
        :param pulumi.Input[builtins.str] name: Name of the Kinesis Analytics Application.
        :param pulumi.Input[Sequence[pulumi.Input['AnalyticsApplicationOutputArgs']]] outputs: Output destination configuration of the application. See Outputs below for more details.
        :param pulumi.Input['AnalyticsApplicationReferenceDataSourcesArgs'] reference_data_sources: An S3 Reference Data Source for the application.
               See Reference Data Sources below for more details.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] start_application: Whether to start or stop the Kinesis Analytics Application. To start an application, an input with a defined `starting_position` must be configured.
               To modify an application's starting position, first stop the application by setting `start_application = false`, then update `starting_position` and set `start_application = true`.
        :param pulumi.Input[builtins.str] status: The Status of the application.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of tags for the Kinesis Analytics Application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.int] version: The Version of the application.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if cloudwatch_logging_options is not None:
            pulumi.set(__self__, "cloudwatch_logging_options", cloudwatch_logging_options)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if create_timestamp is not None:
            pulumi.set(__self__, "create_timestamp", create_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if last_update_timestamp is not None:
            pulumi.set(__self__, "last_update_timestamp", last_update_timestamp)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if reference_data_sources is not None:
            pulumi.set(__self__, "reference_data_sources", reference_data_sources)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if start_application is not None:
            pulumi.set(__self__, "start_application", start_application)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the Kinesis Analytics Appliation.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="cloudwatchLoggingOptions")
    def cloudwatch_logging_options(self) -> Optional[pulumi.Input['AnalyticsApplicationCloudwatchLoggingOptionsArgs']]:
        """
        The CloudWatch log stream options to monitor application errors.
        See CloudWatch Logging Options below for more details.
        """
        return pulumi.get(self, "cloudwatch_logging_options")

    @cloudwatch_logging_options.setter
    def cloudwatch_logging_options(self, value: Optional[pulumi.Input['AnalyticsApplicationCloudwatchLoggingOptionsArgs']]):
        pulumi.set(self, "cloudwatch_logging_options", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SQL Code to transform input data, and generate output.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="createTimestamp")
    def create_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Timestamp when the application version was created.
        """
        return pulumi.get(self, "create_timestamp")

    @create_timestamp.setter
    def create_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the application.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input['AnalyticsApplicationInputsArgs']]:
        """
        Input configuration of the application. See Inputs below for more details.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input['AnalyticsApplicationInputsArgs']]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter(name="lastUpdateTimestamp")
    def last_update_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Timestamp when the application was last updated.
        """
        return pulumi.get(self, "last_update_timestamp")

    @last_update_timestamp.setter
    def last_update_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_update_timestamp", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Kinesis Analytics Application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsApplicationOutputArgs']]]]:
        """
        Output destination configuration of the application. See Outputs below for more details.
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AnalyticsApplicationOutputArgs']]]]):
        pulumi.set(self, "outputs", value)

    @property
    @pulumi.getter(name="referenceDataSources")
    def reference_data_sources(self) -> Optional[pulumi.Input['AnalyticsApplicationReferenceDataSourcesArgs']]:
        """
        An S3 Reference Data Source for the application.
        See Reference Data Sources below for more details.
        """
        return pulumi.get(self, "reference_data_sources")

    @reference_data_sources.setter
    def reference_data_sources(self, value: Optional[pulumi.Input['AnalyticsApplicationReferenceDataSourcesArgs']]):
        pulumi.set(self, "reference_data_sources", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="startApplication")
    def start_application(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to start or stop the Kinesis Analytics Application. To start an application, an input with a defined `starting_position` must be configured.
        To modify an application's starting position, first stop the application by setting `start_application = false`, then update `starting_position` and set `start_application = true`.
        """
        return pulumi.get(self, "start_application")

    @start_application.setter
    def start_application(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "start_application", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Status of the application.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of tags for the Kinesis Analytics Application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The Version of the application.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("aws:kinesis/analyticsApplication:AnalyticsApplication")
class AnalyticsApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloudwatch_logging_options: Optional[pulumi.Input[Union['AnalyticsApplicationCloudwatchLoggingOptionsArgs', 'AnalyticsApplicationCloudwatchLoggingOptionsArgsDict']]] = None,
                 code: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 inputs: Optional[pulumi.Input[Union['AnalyticsApplicationInputsArgs', 'AnalyticsApplicationInputsArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AnalyticsApplicationOutputArgs', 'AnalyticsApplicationOutputArgsDict']]]]] = None,
                 reference_data_sources: Optional[pulumi.Input[Union['AnalyticsApplicationReferenceDataSourcesArgs', 'AnalyticsApplicationReferenceDataSourcesArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 start_application: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Kinesis Analytics Application resource. Kinesis Analytics is a managed service that
        allows processing and analyzing streaming data using standard SQL.

        For more details, see the [Amazon Kinesis Analytics Documentation](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/what-is.html).

        !> **WARNING:** _This resource is deprecated and will be removed in a future version._ [Effective January 27, 2026](https://aws.amazon.com/blogs/big-data/migrate-from-amazon-kinesis-data-analytics-for-sql-to-amazon-managed-service-for-apache-flink-and-amazon-managed-service-for-apache-flink-studio/), AWS will [no longer support](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/discontinuation.html) Amazon Kinesis Data Analytics for SQL. Use the `kinesisanalyticsv2.Application` resource instead to manage Amazon Kinesis Data Analytics for Apache Flink applications. AWS provides guidance for migrating from [Amazon Kinesis Data Analytics for SQL Applications to Amazon Managed Service for Apache Flink Studio](https://aws.amazon.com/blogs/big-data/migrate-from-amazon-kinesis-data-analytics-for-sql-applications-to-amazon-managed-service-for-apache-flink-studio/) including [examples](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/migrating-to-kda-studio-overview.html).

        > **Note:** To manage Amazon Kinesis Data Analytics for Apache Flink applications, use the `kinesisanalyticsv2.Application` resource.

        ## Example Usage

        ### Kinesis Stream Input

        ```python
        import pulumi
        import pulumi_aws as aws

        test_stream = aws.kinesis.Stream("test_stream",
            name="kinesis-test",
            shard_count=1)
        test_application = aws.kinesis.AnalyticsApplication("test_application",
            name="kinesis-analytics-application-test",
            inputs={
                "name_prefix": "test_prefix",
                "kinesis_stream": {
                    "resource_arn": test_stream.arn,
                    "role_arn": test["arn"],
                },
                "parallelism": {
                    "count": 1,
                },
                "schema": {
                    "record_columns": [{
                        "mapping": "$.test",
                        "name": "test",
                        "sql_type": "VARCHAR(8)",
                    }],
                    "record_encoding": "UTF-8",
                    "record_format": {
                        "mapping_parameters": {
                            "json": {
                                "record_row_path": "$",
                            },
                        },
                    },
                },
            })
        ```

        ### Starting An Application

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudwatch.LogGroup("example", name="analytics")
        example_log_stream = aws.cloudwatch.LogStream("example",
            name="example-kinesis-application",
            log_group_name=example.name)
        example_stream = aws.kinesis.Stream("example",
            name="example-kinesis-stream",
            shard_count=1)
        example_firehose_delivery_stream = aws.kinesis.FirehoseDeliveryStream("example",
            name="example-kinesis-delivery-stream",
            destination="extended_s3",
            extended_s3_configuration={
                "bucket_arn": example_aws_s3_bucket["arn"],
                "role_arn": example_aws_iam_role["arn"],
            })
        test = aws.kinesis.AnalyticsApplication("test",
            name="example-application",
            cloudwatch_logging_options={
                "log_stream_arn": example_log_stream.arn,
                "role_arn": example_aws_iam_role["arn"],
            },
            inputs={
                "name_prefix": "example_prefix",
                "schema": {
                    "record_columns": [{
                        "name": "COLUMN_1",
                        "sql_type": "INTEGER",
                    }],
                    "record_format": {
                        "mapping_parameters": {
                            "csv": {
                                "record_column_delimiter": ",",
                                "record_row_delimiter": "|",
                            },
                        },
                    },
                },
                "kinesis_stream": {
                    "resource_arn": example_stream.arn,
                    "role_arn": example_aws_iam_role["arn"],
                },
                "starting_position_configurations": [{
                    "starting_position": "NOW",
                }],
            },
            outputs=[{
                "name": "OUTPUT_1",
                "schema": {
                    "record_format_type": "CSV",
                },
                "kinesis_firehose": {
                    "resource_arn": example_firehose_delivery_stream.arn,
                    "role_arn": example_aws_iam_role["arn"],
                },
            }],
            start_application=True)
        ```

        ## Import

        Using `pulumi import`, import Kinesis Analytics Application using ARN. For example:

        ```sh
        $ pulumi import aws:kinesis/analyticsApplication:AnalyticsApplication example arn:aws:kinesisanalytics:us-west-2:1234567890:application/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AnalyticsApplicationCloudwatchLoggingOptionsArgs', 'AnalyticsApplicationCloudwatchLoggingOptionsArgsDict']] cloudwatch_logging_options: The CloudWatch log stream options to monitor application errors.
               See CloudWatch Logging Options below for more details.
        :param pulumi.Input[builtins.str] code: SQL Code to transform input data, and generate output.
        :param pulumi.Input[builtins.str] description: Description of the application.
        :param pulumi.Input[Union['AnalyticsApplicationInputsArgs', 'AnalyticsApplicationInputsArgsDict']] inputs: Input configuration of the application. See Inputs below for more details.
        :param pulumi.Input[builtins.str] name: Name of the Kinesis Analytics Application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AnalyticsApplicationOutputArgs', 'AnalyticsApplicationOutputArgsDict']]]] outputs: Output destination configuration of the application. See Outputs below for more details.
        :param pulumi.Input[Union['AnalyticsApplicationReferenceDataSourcesArgs', 'AnalyticsApplicationReferenceDataSourcesArgsDict']] reference_data_sources: An S3 Reference Data Source for the application.
               See Reference Data Sources below for more details.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] start_application: Whether to start or stop the Kinesis Analytics Application. To start an application, an input with a defined `starting_position` must be configured.
               To modify an application's starting position, first stop the application by setting `start_application = false`, then update `starting_position` and set `start_application = true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of tags for the Kinesis Analytics Application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AnalyticsApplicationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Kinesis Analytics Application resource. Kinesis Analytics is a managed service that
        allows processing and analyzing streaming data using standard SQL.

        For more details, see the [Amazon Kinesis Analytics Documentation](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/what-is.html).

        !> **WARNING:** _This resource is deprecated and will be removed in a future version._ [Effective January 27, 2026](https://aws.amazon.com/blogs/big-data/migrate-from-amazon-kinesis-data-analytics-for-sql-to-amazon-managed-service-for-apache-flink-and-amazon-managed-service-for-apache-flink-studio/), AWS will [no longer support](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/discontinuation.html) Amazon Kinesis Data Analytics for SQL. Use the `kinesisanalyticsv2.Application` resource instead to manage Amazon Kinesis Data Analytics for Apache Flink applications. AWS provides guidance for migrating from [Amazon Kinesis Data Analytics for SQL Applications to Amazon Managed Service for Apache Flink Studio](https://aws.amazon.com/blogs/big-data/migrate-from-amazon-kinesis-data-analytics-for-sql-applications-to-amazon-managed-service-for-apache-flink-studio/) including [examples](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/migrating-to-kda-studio-overview.html).

        > **Note:** To manage Amazon Kinesis Data Analytics for Apache Flink applications, use the `kinesisanalyticsv2.Application` resource.

        ## Example Usage

        ### Kinesis Stream Input

        ```python
        import pulumi
        import pulumi_aws as aws

        test_stream = aws.kinesis.Stream("test_stream",
            name="kinesis-test",
            shard_count=1)
        test_application = aws.kinesis.AnalyticsApplication("test_application",
            name="kinesis-analytics-application-test",
            inputs={
                "name_prefix": "test_prefix",
                "kinesis_stream": {
                    "resource_arn": test_stream.arn,
                    "role_arn": test["arn"],
                },
                "parallelism": {
                    "count": 1,
                },
                "schema": {
                    "record_columns": [{
                        "mapping": "$.test",
                        "name": "test",
                        "sql_type": "VARCHAR(8)",
                    }],
                    "record_encoding": "UTF-8",
                    "record_format": {
                        "mapping_parameters": {
                            "json": {
                                "record_row_path": "$",
                            },
                        },
                    },
                },
            })
        ```

        ### Starting An Application

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudwatch.LogGroup("example", name="analytics")
        example_log_stream = aws.cloudwatch.LogStream("example",
            name="example-kinesis-application",
            log_group_name=example.name)
        example_stream = aws.kinesis.Stream("example",
            name="example-kinesis-stream",
            shard_count=1)
        example_firehose_delivery_stream = aws.kinesis.FirehoseDeliveryStream("example",
            name="example-kinesis-delivery-stream",
            destination="extended_s3",
            extended_s3_configuration={
                "bucket_arn": example_aws_s3_bucket["arn"],
                "role_arn": example_aws_iam_role["arn"],
            })
        test = aws.kinesis.AnalyticsApplication("test",
            name="example-application",
            cloudwatch_logging_options={
                "log_stream_arn": example_log_stream.arn,
                "role_arn": example_aws_iam_role["arn"],
            },
            inputs={
                "name_prefix": "example_prefix",
                "schema": {
                    "record_columns": [{
                        "name": "COLUMN_1",
                        "sql_type": "INTEGER",
                    }],
                    "record_format": {
                        "mapping_parameters": {
                            "csv": {
                                "record_column_delimiter": ",",
                                "record_row_delimiter": "|",
                            },
                        },
                    },
                },
                "kinesis_stream": {
                    "resource_arn": example_stream.arn,
                    "role_arn": example_aws_iam_role["arn"],
                },
                "starting_position_configurations": [{
                    "starting_position": "NOW",
                }],
            },
            outputs=[{
                "name": "OUTPUT_1",
                "schema": {
                    "record_format_type": "CSV",
                },
                "kinesis_firehose": {
                    "resource_arn": example_firehose_delivery_stream.arn,
                    "role_arn": example_aws_iam_role["arn"],
                },
            }],
            start_application=True)
        ```

        ## Import

        Using `pulumi import`, import Kinesis Analytics Application using ARN. For example:

        ```sh
        $ pulumi import aws:kinesis/analyticsApplication:AnalyticsApplication example arn:aws:kinesisanalytics:us-west-2:1234567890:application/example
        ```

        :param str resource_name: The name of the resource.
        :param AnalyticsApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnalyticsApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloudwatch_logging_options: Optional[pulumi.Input[Union['AnalyticsApplicationCloudwatchLoggingOptionsArgs', 'AnalyticsApplicationCloudwatchLoggingOptionsArgsDict']]] = None,
                 code: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 inputs: Optional[pulumi.Input[Union['AnalyticsApplicationInputsArgs', 'AnalyticsApplicationInputsArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AnalyticsApplicationOutputArgs', 'AnalyticsApplicationOutputArgsDict']]]]] = None,
                 reference_data_sources: Optional[pulumi.Input[Union['AnalyticsApplicationReferenceDataSourcesArgs', 'AnalyticsApplicationReferenceDataSourcesArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 start_application: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnalyticsApplicationArgs.__new__(AnalyticsApplicationArgs)

            __props__.__dict__["cloudwatch_logging_options"] = cloudwatch_logging_options
            __props__.__dict__["code"] = code
            __props__.__dict__["description"] = description
            __props__.__dict__["inputs"] = inputs
            __props__.__dict__["name"] = name
            __props__.__dict__["outputs"] = outputs
            __props__.__dict__["reference_data_sources"] = reference_data_sources
            __props__.__dict__["region"] = region
            __props__.__dict__["start_application"] = start_application
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["create_timestamp"] = None
            __props__.__dict__["last_update_timestamp"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["version"] = None
        super(AnalyticsApplication, __self__).__init__(
            'aws:kinesis/analyticsApplication:AnalyticsApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            cloudwatch_logging_options: Optional[pulumi.Input[Union['AnalyticsApplicationCloudwatchLoggingOptionsArgs', 'AnalyticsApplicationCloudwatchLoggingOptionsArgsDict']]] = None,
            code: Optional[pulumi.Input[builtins.str]] = None,
            create_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            inputs: Optional[pulumi.Input[Union['AnalyticsApplicationInputsArgs', 'AnalyticsApplicationInputsArgsDict']]] = None,
            last_update_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AnalyticsApplicationOutputArgs', 'AnalyticsApplicationOutputArgsDict']]]]] = None,
            reference_data_sources: Optional[pulumi.Input[Union['AnalyticsApplicationReferenceDataSourcesArgs', 'AnalyticsApplicationReferenceDataSourcesArgsDict']]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            start_application: Optional[pulumi.Input[builtins.bool]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'AnalyticsApplication':
        """
        Get an existing AnalyticsApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: The ARN of the Kinesis Analytics Appliation.
        :param pulumi.Input[Union['AnalyticsApplicationCloudwatchLoggingOptionsArgs', 'AnalyticsApplicationCloudwatchLoggingOptionsArgsDict']] cloudwatch_logging_options: The CloudWatch log stream options to monitor application errors.
               See CloudWatch Logging Options below for more details.
        :param pulumi.Input[builtins.str] code: SQL Code to transform input data, and generate output.
        :param pulumi.Input[builtins.str] create_timestamp: The Timestamp when the application version was created.
        :param pulumi.Input[builtins.str] description: Description of the application.
        :param pulumi.Input[Union['AnalyticsApplicationInputsArgs', 'AnalyticsApplicationInputsArgsDict']] inputs: Input configuration of the application. See Inputs below for more details.
        :param pulumi.Input[builtins.str] last_update_timestamp: The Timestamp when the application was last updated.
        :param pulumi.Input[builtins.str] name: Name of the Kinesis Analytics Application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AnalyticsApplicationOutputArgs', 'AnalyticsApplicationOutputArgsDict']]]] outputs: Output destination configuration of the application. See Outputs below for more details.
        :param pulumi.Input[Union['AnalyticsApplicationReferenceDataSourcesArgs', 'AnalyticsApplicationReferenceDataSourcesArgsDict']] reference_data_sources: An S3 Reference Data Source for the application.
               See Reference Data Sources below for more details.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] start_application: Whether to start or stop the Kinesis Analytics Application. To start an application, an input with a defined `starting_position` must be configured.
               To modify an application's starting position, first stop the application by setting `start_application = false`, then update `starting_position` and set `start_application = true`.
        :param pulumi.Input[builtins.str] status: The Status of the application.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of tags for the Kinesis Analytics Application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.int] version: The Version of the application.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AnalyticsApplicationState.__new__(_AnalyticsApplicationState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["cloudwatch_logging_options"] = cloudwatch_logging_options
        __props__.__dict__["code"] = code
        __props__.__dict__["create_timestamp"] = create_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["inputs"] = inputs
        __props__.__dict__["last_update_timestamp"] = last_update_timestamp
        __props__.__dict__["name"] = name
        __props__.__dict__["outputs"] = outputs
        __props__.__dict__["reference_data_sources"] = reference_data_sources
        __props__.__dict__["region"] = region
        __props__.__dict__["start_application"] = start_application
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["version"] = version
        return AnalyticsApplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the Kinesis Analytics Appliation.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="cloudwatchLoggingOptions")
    def cloudwatch_logging_options(self) -> pulumi.Output[Optional['outputs.AnalyticsApplicationCloudwatchLoggingOptions']]:
        """
        The CloudWatch log stream options to monitor application errors.
        See CloudWatch Logging Options below for more details.
        """
        return pulumi.get(self, "cloudwatch_logging_options")

    @property
    @pulumi.getter
    def code(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        SQL Code to transform input data, and generate output.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="createTimestamp")
    def create_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        The Timestamp when the application version was created.
        """
        return pulumi.get(self, "create_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the application.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def inputs(self) -> pulumi.Output[Optional['outputs.AnalyticsApplicationInputs']]:
        """
        Input configuration of the application. See Inputs below for more details.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter(name="lastUpdateTimestamp")
    def last_update_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        The Timestamp when the application was last updated.
        """
        return pulumi.get(self, "last_update_timestamp")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Kinesis Analytics Application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def outputs(self) -> pulumi.Output[Optional[Sequence['outputs.AnalyticsApplicationOutput']]]:
        """
        Output destination configuration of the application. See Outputs below for more details.
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter(name="referenceDataSources")
    def reference_data_sources(self) -> pulumi.Output[Optional['outputs.AnalyticsApplicationReferenceDataSources']]:
        """
        An S3 Reference Data Source for the application.
        See Reference Data Sources below for more details.
        """
        return pulumi.get(self, "reference_data_sources")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="startApplication")
    def start_application(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to start or stop the Kinesis Analytics Application. To start an application, an input with a defined `starting_position` must be configured.
        To modify an application's starting position, first stop the application by setting `start_application = false`, then update `starting_position` and set `start_application = true`.
        """
        return pulumi.get(self, "start_application")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The Status of the application.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value map of tags for the Kinesis Analytics Application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The Version of the application.
        """
        return pulumi.get(self, "version")

