# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAliasResult',
    'AwaitableGetAliasResult',
    'get_alias',
    'get_alias_output',
]

@pulumi.output_type
class GetAliasResult:
    """
    A collection of values returned by getAlias.
    """
    def __init__(__self__, arn=None, id=None, name=None, region=None, target_key_arn=None, target_key_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if target_key_arn and not isinstance(target_key_arn, str):
            raise TypeError("Expected argument 'target_key_arn' to be a str")
        pulumi.set(__self__, "target_key_arn", target_key_arn)
        if target_key_id and not isinstance(target_key_id, str):
            raise TypeError("Expected argument 'target_key_id' to be a str")
        pulumi.set(__self__, "target_key_id", target_key_id)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        Amazon Resource Name(ARN) of the key alias.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the alias
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="targetKeyArn")
    def target_key_arn(self) -> builtins.str:
        """
        ARN pointed to by the alias.
        """
        return pulumi.get(self, "target_key_arn")

    @property
    @pulumi.getter(name="targetKeyId")
    def target_key_id(self) -> builtins.str:
        """
        Key identifier pointed to by the alias.
        """
        return pulumi.get(self, "target_key_id")


class AwaitableGetAliasResult(GetAliasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAliasResult(
            arn=self.arn,
            id=self.id,
            name=self.name,
            region=self.region,
            target_key_arn=self.target_key_arn,
            target_key_id=self.target_key_id)


def get_alias(name: Optional[builtins.str] = None,
              region: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAliasResult:
    """
    Use this data source to get the ARN of a KMS key alias.
    By using this data source, you can reference key alias
    without having to hard code the ARN as input.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    s3 = aws.kms.get_alias(name="alias/aws/s3")
    ```


    :param builtins.str name: Display name of the alias. The name must start with the word "alias" followed by a forward slash (alias/)
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:kms/getAlias:getAlias', __args__, opts=opts, typ=GetAliasResult).value

    return AwaitableGetAliasResult(
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        target_key_arn=pulumi.get(__ret__, 'target_key_arn'),
        target_key_id=pulumi.get(__ret__, 'target_key_id'))
def get_alias_output(name: Optional[pulumi.Input[builtins.str]] = None,
                     region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAliasResult]:
    """
    Use this data source to get the ARN of a KMS key alias.
    By using this data source, you can reference key alias
    without having to hard code the ARN as input.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    s3 = aws.kms.get_alias(name="alias/aws/s3")
    ```


    :param builtins.str name: Display name of the alias. The name must start with the word "alias" followed by a forward slash (alias/)
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:kms/getAlias:getAlias', __args__, opts=opts, typ=GetAliasResult)
    return __ret__.apply(lambda __response__: GetAliasResult(
        arn=pulumi.get(__response__, 'arn'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        target_key_arn=pulumi.get(__response__, 'target_key_arn'),
        target_key_id=pulumi.get(__response__, 'target_key_id')))
