# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecretsResult',
    'AwaitableGetSecretsResult',
    'get_secrets',
    'get_secrets_output',
]

@pulumi.output_type
class GetSecretsResult:
    """
    A collection of values returned by getSecrets.
    """
    def __init__(__self__, id=None, plaintext=None, region=None, secrets=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if plaintext and not isinstance(plaintext, dict):
            raise TypeError("Expected argument 'plaintext' to be a dict")
        pulumi.set(__self__, "plaintext", plaintext)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if secrets and not isinstance(secrets, list):
            raise TypeError("Expected argument 'secrets' to be a list")
        pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def plaintext(self) -> Mapping[str, builtins.str]:
        """
        Map containing each `secret` `name` as the key with its decrypted plaintext value
        """
        return pulumi.get(self, "plaintext")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def secrets(self) -> Sequence['outputs.GetSecretsSecretResult']:
        return pulumi.get(self, "secrets")


class AwaitableGetSecretsResult(GetSecretsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretsResult(
            id=self.id,
            plaintext=self.plaintext,
            region=self.region,
            secrets=self.secrets)


def get_secrets(region: Optional[builtins.str] = None,
                secrets: Optional[Sequence[Union['GetSecretsSecretArgs', 'GetSecretsSecretArgsDict']]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretsResult:
    """
    Decrypt multiple secrets from data encrypted with the AWS KMS service.

    ## Example Usage

    If you do not already have a `CiphertextBlob` from encrypting a KMS secret, you can use the below commands to obtain one using the [AWS CLI kms encrypt](https://docs.aws.amazon.com/cli/latest/reference/kms/encrypt.html) command. This requires you to have your AWS CLI setup correctly and replace the `--key-id` with your own. Alternatively you can use `--plaintext 'master-password'` (CLIv1) or `--plaintext fileb://<(echo -n 'master-password')` (CLIv2) instead of reading from a file.

    > If you have a newline character at the end of your file, it will be decrypted with this newline character intact. For most use cases this is undesirable and leads to incorrect passwords or invalid values, as well as possible changes in the plan. Be sure to use `echo -n` if necessary.
    If you are using asymmetric keys ensure you are using the right encryption algorithm when you encrypt and decrypt else you will get IncorrectKeyException during the decrypt phase.

    That encrypted output can now be inserted into provider configurations without exposing the plaintext secret directly.


    :param Sequence[Union['GetSecretsSecretArgs', 'GetSecretsSecretArgsDict']] secrets: One or more encrypted payload definitions from the KMS service. See the Secret Definitions below.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['secrets'] = secrets
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:kms/getSecrets:getSecrets', __args__, opts=opts, typ=GetSecretsResult).value

    return AwaitableGetSecretsResult(
        id=pulumi.get(__ret__, 'id'),
        plaintext=pulumi.get(__ret__, 'plaintext'),
        region=pulumi.get(__ret__, 'region'),
        secrets=pulumi.get(__ret__, 'secrets'))
def get_secrets_output(region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       secrets: Optional[pulumi.Input[Sequence[Union['GetSecretsSecretArgs', 'GetSecretsSecretArgsDict']]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecretsResult]:
    """
    Decrypt multiple secrets from data encrypted with the AWS KMS service.

    ## Example Usage

    If you do not already have a `CiphertextBlob` from encrypting a KMS secret, you can use the below commands to obtain one using the [AWS CLI kms encrypt](https://docs.aws.amazon.com/cli/latest/reference/kms/encrypt.html) command. This requires you to have your AWS CLI setup correctly and replace the `--key-id` with your own. Alternatively you can use `--plaintext 'master-password'` (CLIv1) or `--plaintext fileb://<(echo -n 'master-password')` (CLIv2) instead of reading from a file.

    > If you have a newline character at the end of your file, it will be decrypted with this newline character intact. For most use cases this is undesirable and leads to incorrect passwords or invalid values, as well as possible changes in the plan. Be sure to use `echo -n` if necessary.
    If you are using asymmetric keys ensure you are using the right encryption algorithm when you encrypt and decrypt else you will get IncorrectKeyException during the decrypt phase.

    That encrypted output can now be inserted into provider configurations without exposing the plaintext secret directly.


    :param Sequence[Union['GetSecretsSecretArgs', 'GetSecretsSecretArgsDict']] secrets: One or more encrypted payload definitions from the KMS service. See the Secret Definitions below.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['secrets'] = secrets
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:kms/getSecrets:getSecrets', __args__, opts=opts, typ=GetSecretsResult)
    return __ret__.apply(lambda __response__: GetSecretsResult(
        id=pulumi.get(__response__, 'id'),
        plaintext=pulumi.get(__response__, 'plaintext'),
        region=pulumi.get(__response__, 'region'),
        secrets=pulumi.get(__response__, 'secrets')))
