# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataLakeSettingsArgs', 'DataLakeSettings']

@pulumi.input_type
class DataLakeSettingsArgs:
    def __init__(__self__, *,
                 admins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allow_external_data_filtering: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_full_table_external_data_access: Optional[pulumi.Input[builtins.bool]] = None,
                 authorized_session_tag_value_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 catalog_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_database_default_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeSettingsCreateDatabaseDefaultPermissionArgs']]]] = None,
                 create_table_default_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeSettingsCreateTableDefaultPermissionArgs']]]] = None,
                 external_data_filtering_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 read_only_admins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 trusted_resource_owners: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a DataLakeSettings resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] admins: Set of ARNs of AWS Lake Formation principals (IAM users or roles).
        :param pulumi.Input[builtins.bool] allow_external_data_filtering: Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
        :param pulumi.Input[builtins.bool] allow_full_table_external_data_access: Whether to allow a third-party query engine to get data access credentials without session tags when a caller has full data access permissions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] authorized_session_tag_value_lists: Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
        :param pulumi.Input[builtins.str] catalog_id: Identifier for the Data Catalog. By default, the account ID.
        :param pulumi.Input[Sequence[pulumi.Input['DataLakeSettingsCreateDatabaseDefaultPermissionArgs']]] create_database_default_permissions: Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['DataLakeSettingsCreateTableDefaultPermissionArgs']]] create_table_default_permissions: Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] external_data_filtering_allow_lists: A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: Key-value map of additional configuration. Valid values for the `CROSS_ACCOUNT_VERSION` key are `"1"`, `"2"`, `"3"`, or `"4"`. `SET_CONTEXT` is also returned with a value of `TRUE`. In a fresh account, prior to configuring, `CROSS_ACCOUNT_VERSION` is `"1"`. Destroying this resource sets the `CROSS_ACCOUNT_VERSION` to `"1"`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] read_only_admins: Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] trusted_resource_owners: List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).
               
               > **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, `parameters`, and/or `trusted_resource_owners` results in the setting being cleared.
        """
        if admins is not None:
            pulumi.set(__self__, "admins", admins)
        if allow_external_data_filtering is not None:
            pulumi.set(__self__, "allow_external_data_filtering", allow_external_data_filtering)
        if allow_full_table_external_data_access is not None:
            pulumi.set(__self__, "allow_full_table_external_data_access", allow_full_table_external_data_access)
        if authorized_session_tag_value_lists is not None:
            pulumi.set(__self__, "authorized_session_tag_value_lists", authorized_session_tag_value_lists)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if create_database_default_permissions is not None:
            pulumi.set(__self__, "create_database_default_permissions", create_database_default_permissions)
        if create_table_default_permissions is not None:
            pulumi.set(__self__, "create_table_default_permissions", create_table_default_permissions)
        if external_data_filtering_allow_lists is not None:
            pulumi.set(__self__, "external_data_filtering_allow_lists", external_data_filtering_allow_lists)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if read_only_admins is not None:
            pulumi.set(__self__, "read_only_admins", read_only_admins)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if trusted_resource_owners is not None:
            pulumi.set(__self__, "trusted_resource_owners", trusted_resource_owners)

    @property
    @pulumi.getter
    def admins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Set of ARNs of AWS Lake Formation principals (IAM users or roles).
        """
        return pulumi.get(self, "admins")

    @admins.setter
    def admins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "admins", value)

    @property
    @pulumi.getter(name="allowExternalDataFiltering")
    def allow_external_data_filtering(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
        """
        return pulumi.get(self, "allow_external_data_filtering")

    @allow_external_data_filtering.setter
    def allow_external_data_filtering(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_external_data_filtering", value)

    @property
    @pulumi.getter(name="allowFullTableExternalDataAccess")
    def allow_full_table_external_data_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to allow a third-party query engine to get data access credentials without session tags when a caller has full data access permissions.
        """
        return pulumi.get(self, "allow_full_table_external_data_access")

    @allow_full_table_external_data_access.setter
    def allow_full_table_external_data_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_full_table_external_data_access", value)

    @property
    @pulumi.getter(name="authorizedSessionTagValueLists")
    def authorized_session_tag_value_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
        """
        return pulumi.get(self, "authorized_session_tag_value_lists")

    @authorized_session_tag_value_lists.setter
    def authorized_session_tag_value_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "authorized_session_tag_value_lists", value)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier for the Data Catalog. By default, the account ID.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="createDatabaseDefaultPermissions")
    def create_database_default_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeSettingsCreateDatabaseDefaultPermissionArgs']]]]:
        """
        Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
        """
        return pulumi.get(self, "create_database_default_permissions")

    @create_database_default_permissions.setter
    def create_database_default_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeSettingsCreateDatabaseDefaultPermissionArgs']]]]):
        pulumi.set(self, "create_database_default_permissions", value)

    @property
    @pulumi.getter(name="createTableDefaultPermissions")
    def create_table_default_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeSettingsCreateTableDefaultPermissionArgs']]]]:
        """
        Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
        """
        return pulumi.get(self, "create_table_default_permissions")

    @create_table_default_permissions.setter
    def create_table_default_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeSettingsCreateTableDefaultPermissionArgs']]]]):
        pulumi.set(self, "create_table_default_permissions", value)

    @property
    @pulumi.getter(name="externalDataFilteringAllowLists")
    def external_data_filtering_allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
        """
        return pulumi.get(self, "external_data_filtering_allow_lists")

    @external_data_filtering_allow_lists.setter
    def external_data_filtering_allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "external_data_filtering_allow_lists", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of additional configuration. Valid values for the `CROSS_ACCOUNT_VERSION` key are `"1"`, `"2"`, `"3"`, or `"4"`. `SET_CONTEXT` is also returned with a value of `TRUE`. In a fresh account, prior to configuring, `CROSS_ACCOUNT_VERSION` is `"1"`. Destroying this resource sets the `CROSS_ACCOUNT_VERSION` to `"1"`.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="readOnlyAdmins")
    def read_only_admins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
        """
        return pulumi.get(self, "read_only_admins")

    @read_only_admins.setter
    def read_only_admins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "read_only_admins", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="trustedResourceOwners")
    def trusted_resource_owners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).

        > **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, `parameters`, and/or `trusted_resource_owners` results in the setting being cleared.
        """
        return pulumi.get(self, "trusted_resource_owners")

    @trusted_resource_owners.setter
    def trusted_resource_owners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "trusted_resource_owners", value)


@pulumi.input_type
class _DataLakeSettingsState:
    def __init__(__self__, *,
                 admins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allow_external_data_filtering: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_full_table_external_data_access: Optional[pulumi.Input[builtins.bool]] = None,
                 authorized_session_tag_value_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 catalog_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_database_default_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeSettingsCreateDatabaseDefaultPermissionArgs']]]] = None,
                 create_table_default_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeSettingsCreateTableDefaultPermissionArgs']]]] = None,
                 external_data_filtering_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 read_only_admins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 trusted_resource_owners: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DataLakeSettings resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] admins: Set of ARNs of AWS Lake Formation principals (IAM users or roles).
        :param pulumi.Input[builtins.bool] allow_external_data_filtering: Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
        :param pulumi.Input[builtins.bool] allow_full_table_external_data_access: Whether to allow a third-party query engine to get data access credentials without session tags when a caller has full data access permissions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] authorized_session_tag_value_lists: Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
        :param pulumi.Input[builtins.str] catalog_id: Identifier for the Data Catalog. By default, the account ID.
        :param pulumi.Input[Sequence[pulumi.Input['DataLakeSettingsCreateDatabaseDefaultPermissionArgs']]] create_database_default_permissions: Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['DataLakeSettingsCreateTableDefaultPermissionArgs']]] create_table_default_permissions: Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] external_data_filtering_allow_lists: A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: Key-value map of additional configuration. Valid values for the `CROSS_ACCOUNT_VERSION` key are `"1"`, `"2"`, `"3"`, or `"4"`. `SET_CONTEXT` is also returned with a value of `TRUE`. In a fresh account, prior to configuring, `CROSS_ACCOUNT_VERSION` is `"1"`. Destroying this resource sets the `CROSS_ACCOUNT_VERSION` to `"1"`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] read_only_admins: Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] trusted_resource_owners: List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).
               
               > **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, `parameters`, and/or `trusted_resource_owners` results in the setting being cleared.
        """
        if admins is not None:
            pulumi.set(__self__, "admins", admins)
        if allow_external_data_filtering is not None:
            pulumi.set(__self__, "allow_external_data_filtering", allow_external_data_filtering)
        if allow_full_table_external_data_access is not None:
            pulumi.set(__self__, "allow_full_table_external_data_access", allow_full_table_external_data_access)
        if authorized_session_tag_value_lists is not None:
            pulumi.set(__self__, "authorized_session_tag_value_lists", authorized_session_tag_value_lists)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if create_database_default_permissions is not None:
            pulumi.set(__self__, "create_database_default_permissions", create_database_default_permissions)
        if create_table_default_permissions is not None:
            pulumi.set(__self__, "create_table_default_permissions", create_table_default_permissions)
        if external_data_filtering_allow_lists is not None:
            pulumi.set(__self__, "external_data_filtering_allow_lists", external_data_filtering_allow_lists)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if read_only_admins is not None:
            pulumi.set(__self__, "read_only_admins", read_only_admins)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if trusted_resource_owners is not None:
            pulumi.set(__self__, "trusted_resource_owners", trusted_resource_owners)

    @property
    @pulumi.getter
    def admins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Set of ARNs of AWS Lake Formation principals (IAM users or roles).
        """
        return pulumi.get(self, "admins")

    @admins.setter
    def admins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "admins", value)

    @property
    @pulumi.getter(name="allowExternalDataFiltering")
    def allow_external_data_filtering(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
        """
        return pulumi.get(self, "allow_external_data_filtering")

    @allow_external_data_filtering.setter
    def allow_external_data_filtering(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_external_data_filtering", value)

    @property
    @pulumi.getter(name="allowFullTableExternalDataAccess")
    def allow_full_table_external_data_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to allow a third-party query engine to get data access credentials without session tags when a caller has full data access permissions.
        """
        return pulumi.get(self, "allow_full_table_external_data_access")

    @allow_full_table_external_data_access.setter
    def allow_full_table_external_data_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_full_table_external_data_access", value)

    @property
    @pulumi.getter(name="authorizedSessionTagValueLists")
    def authorized_session_tag_value_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
        """
        return pulumi.get(self, "authorized_session_tag_value_lists")

    @authorized_session_tag_value_lists.setter
    def authorized_session_tag_value_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "authorized_session_tag_value_lists", value)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier for the Data Catalog. By default, the account ID.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="createDatabaseDefaultPermissions")
    def create_database_default_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeSettingsCreateDatabaseDefaultPermissionArgs']]]]:
        """
        Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
        """
        return pulumi.get(self, "create_database_default_permissions")

    @create_database_default_permissions.setter
    def create_database_default_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeSettingsCreateDatabaseDefaultPermissionArgs']]]]):
        pulumi.set(self, "create_database_default_permissions", value)

    @property
    @pulumi.getter(name="createTableDefaultPermissions")
    def create_table_default_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeSettingsCreateTableDefaultPermissionArgs']]]]:
        """
        Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
        """
        return pulumi.get(self, "create_table_default_permissions")

    @create_table_default_permissions.setter
    def create_table_default_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeSettingsCreateTableDefaultPermissionArgs']]]]):
        pulumi.set(self, "create_table_default_permissions", value)

    @property
    @pulumi.getter(name="externalDataFilteringAllowLists")
    def external_data_filtering_allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
        """
        return pulumi.get(self, "external_data_filtering_allow_lists")

    @external_data_filtering_allow_lists.setter
    def external_data_filtering_allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "external_data_filtering_allow_lists", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of additional configuration. Valid values for the `CROSS_ACCOUNT_VERSION` key are `"1"`, `"2"`, `"3"`, or `"4"`. `SET_CONTEXT` is also returned with a value of `TRUE`. In a fresh account, prior to configuring, `CROSS_ACCOUNT_VERSION` is `"1"`. Destroying this resource sets the `CROSS_ACCOUNT_VERSION` to `"1"`.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="readOnlyAdmins")
    def read_only_admins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
        """
        return pulumi.get(self, "read_only_admins")

    @read_only_admins.setter
    def read_only_admins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "read_only_admins", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="trustedResourceOwners")
    def trusted_resource_owners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).

        > **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, `parameters`, and/or `trusted_resource_owners` results in the setting being cleared.
        """
        return pulumi.get(self, "trusted_resource_owners")

    @trusted_resource_owners.setter
    def trusted_resource_owners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "trusted_resource_owners", value)


@pulumi.type_token("aws:lakeformation/dataLakeSettings:DataLakeSettings")
class DataLakeSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allow_external_data_filtering: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_full_table_external_data_access: Optional[pulumi.Input[builtins.bool]] = None,
                 authorized_session_tag_value_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 catalog_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_database_default_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataLakeSettingsCreateDatabaseDefaultPermissionArgs', 'DataLakeSettingsCreateDatabaseDefaultPermissionArgsDict']]]]] = None,
                 create_table_default_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataLakeSettingsCreateTableDefaultPermissionArgs', 'DataLakeSettingsCreateTableDefaultPermissionArgsDict']]]]] = None,
                 external_data_filtering_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 read_only_admins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 trusted_resource_owners: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages Lake Formation principals designated as data lake administrators and lists of principal permission entries for default create database and default create table permissions.

        > **NOTE:** Lake Formation introduces fine-grained access control for data in your data lake. Part of the changes include the `IAMAllowedPrincipals` principal in order to make Lake Formation backwards compatible with existing IAM and Glue permissions. For more information, see [Changing the Default Security Settings for Your Data Lake](https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html) and [Upgrading AWS Glue Data Permissions to the AWS Lake Formation Model](https://docs.aws.amazon.com/lake-formation/latest/dg/upgrade-glue-lake-formation.html).

        ## Example Usage

        ### Data Lake Admins

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.DataLakeSettings("example", admins=[
            test["arn"],
            test_aws_iam_role["arn"],
        ])
        ```

        ### Create Default Permissions

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.DataLakeSettings("example",
            admins=[
                test["arn"],
                test_aws_iam_role["arn"],
            ],
            create_database_default_permissions=[{
                "permissions": [
                    "SELECT",
                    "ALTER",
                    "DROP",
                ],
                "principal": test["arn"],
            }],
            create_table_default_permissions=[{
                "permissions": ["ALL"],
                "principal": test_aws_iam_role["arn"],
            }])
        ```

        ### Enable EMR access to LakeFormation resources

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.DataLakeSettings("example",
            admins=[
                test["arn"],
                test_aws_iam_role["arn"],
            ],
            create_database_default_permissions=[{
                "permissions": [
                    "SELECT",
                    "ALTER",
                    "DROP",
                ],
                "principal": test["arn"],
            }],
            create_table_default_permissions=[{
                "permissions": ["ALL"],
                "principal": test_aws_iam_role["arn"],
            }],
            allow_external_data_filtering=True,
            external_data_filtering_allow_lists=[
                current["accountId"],
                third_party["accountId"],
            ],
            authorized_session_tag_value_lists=["Amazon EMR"],
            allow_full_table_external_data_access=True)
        ```

        ### Change Cross Account Version

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.DataLakeSettings("example", parameters={
            "CROSS_ACCOUNT_VERSION": "3",
        })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] admins: Set of ARNs of AWS Lake Formation principals (IAM users or roles).
        :param pulumi.Input[builtins.bool] allow_external_data_filtering: Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
        :param pulumi.Input[builtins.bool] allow_full_table_external_data_access: Whether to allow a third-party query engine to get data access credentials without session tags when a caller has full data access permissions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] authorized_session_tag_value_lists: Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
        :param pulumi.Input[builtins.str] catalog_id: Identifier for the Data Catalog. By default, the account ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataLakeSettingsCreateDatabaseDefaultPermissionArgs', 'DataLakeSettingsCreateDatabaseDefaultPermissionArgsDict']]]] create_database_default_permissions: Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataLakeSettingsCreateTableDefaultPermissionArgs', 'DataLakeSettingsCreateTableDefaultPermissionArgsDict']]]] create_table_default_permissions: Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] external_data_filtering_allow_lists: A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: Key-value map of additional configuration. Valid values for the `CROSS_ACCOUNT_VERSION` key are `"1"`, `"2"`, `"3"`, or `"4"`. `SET_CONTEXT` is also returned with a value of `TRUE`. In a fresh account, prior to configuring, `CROSS_ACCOUNT_VERSION` is `"1"`. Destroying this resource sets the `CROSS_ACCOUNT_VERSION` to `"1"`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] read_only_admins: Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] trusted_resource_owners: List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).
               
               > **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, `parameters`, and/or `trusted_resource_owners` results in the setting being cleared.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DataLakeSettingsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Lake Formation principals designated as data lake administrators and lists of principal permission entries for default create database and default create table permissions.

        > **NOTE:** Lake Formation introduces fine-grained access control for data in your data lake. Part of the changes include the `IAMAllowedPrincipals` principal in order to make Lake Formation backwards compatible with existing IAM and Glue permissions. For more information, see [Changing the Default Security Settings for Your Data Lake](https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html) and [Upgrading AWS Glue Data Permissions to the AWS Lake Formation Model](https://docs.aws.amazon.com/lake-formation/latest/dg/upgrade-glue-lake-formation.html).

        ## Example Usage

        ### Data Lake Admins

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.DataLakeSettings("example", admins=[
            test["arn"],
            test_aws_iam_role["arn"],
        ])
        ```

        ### Create Default Permissions

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.DataLakeSettings("example",
            admins=[
                test["arn"],
                test_aws_iam_role["arn"],
            ],
            create_database_default_permissions=[{
                "permissions": [
                    "SELECT",
                    "ALTER",
                    "DROP",
                ],
                "principal": test["arn"],
            }],
            create_table_default_permissions=[{
                "permissions": ["ALL"],
                "principal": test_aws_iam_role["arn"],
            }])
        ```

        ### Enable EMR access to LakeFormation resources

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.DataLakeSettings("example",
            admins=[
                test["arn"],
                test_aws_iam_role["arn"],
            ],
            create_database_default_permissions=[{
                "permissions": [
                    "SELECT",
                    "ALTER",
                    "DROP",
                ],
                "principal": test["arn"],
            }],
            create_table_default_permissions=[{
                "permissions": ["ALL"],
                "principal": test_aws_iam_role["arn"],
            }],
            allow_external_data_filtering=True,
            external_data_filtering_allow_lists=[
                current["accountId"],
                third_party["accountId"],
            ],
            authorized_session_tag_value_lists=["Amazon EMR"],
            allow_full_table_external_data_access=True)
        ```

        ### Change Cross Account Version

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.DataLakeSettings("example", parameters={
            "CROSS_ACCOUNT_VERSION": "3",
        })
        ```

        :param str resource_name: The name of the resource.
        :param DataLakeSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataLakeSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allow_external_data_filtering: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_full_table_external_data_access: Optional[pulumi.Input[builtins.bool]] = None,
                 authorized_session_tag_value_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 catalog_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_database_default_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataLakeSettingsCreateDatabaseDefaultPermissionArgs', 'DataLakeSettingsCreateDatabaseDefaultPermissionArgsDict']]]]] = None,
                 create_table_default_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataLakeSettingsCreateTableDefaultPermissionArgs', 'DataLakeSettingsCreateTableDefaultPermissionArgsDict']]]]] = None,
                 external_data_filtering_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 read_only_admins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 trusted_resource_owners: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataLakeSettingsArgs.__new__(DataLakeSettingsArgs)

            __props__.__dict__["admins"] = admins
            __props__.__dict__["allow_external_data_filtering"] = allow_external_data_filtering
            __props__.__dict__["allow_full_table_external_data_access"] = allow_full_table_external_data_access
            __props__.__dict__["authorized_session_tag_value_lists"] = authorized_session_tag_value_lists
            __props__.__dict__["catalog_id"] = catalog_id
            __props__.__dict__["create_database_default_permissions"] = create_database_default_permissions
            __props__.__dict__["create_table_default_permissions"] = create_table_default_permissions
            __props__.__dict__["external_data_filtering_allow_lists"] = external_data_filtering_allow_lists
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["read_only_admins"] = read_only_admins
            __props__.__dict__["region"] = region
            __props__.__dict__["trusted_resource_owners"] = trusted_resource_owners
        super(DataLakeSettings, __self__).__init__(
            'aws:lakeformation/dataLakeSettings:DataLakeSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            allow_external_data_filtering: Optional[pulumi.Input[builtins.bool]] = None,
            allow_full_table_external_data_access: Optional[pulumi.Input[builtins.bool]] = None,
            authorized_session_tag_value_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            catalog_id: Optional[pulumi.Input[builtins.str]] = None,
            create_database_default_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataLakeSettingsCreateDatabaseDefaultPermissionArgs', 'DataLakeSettingsCreateDatabaseDefaultPermissionArgsDict']]]]] = None,
            create_table_default_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataLakeSettingsCreateTableDefaultPermissionArgs', 'DataLakeSettingsCreateTableDefaultPermissionArgsDict']]]]] = None,
            external_data_filtering_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            read_only_admins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            trusted_resource_owners: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'DataLakeSettings':
        """
        Get an existing DataLakeSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] admins: Set of ARNs of AWS Lake Formation principals (IAM users or roles).
        :param pulumi.Input[builtins.bool] allow_external_data_filtering: Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
        :param pulumi.Input[builtins.bool] allow_full_table_external_data_access: Whether to allow a third-party query engine to get data access credentials without session tags when a caller has full data access permissions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] authorized_session_tag_value_lists: Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
        :param pulumi.Input[builtins.str] catalog_id: Identifier for the Data Catalog. By default, the account ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataLakeSettingsCreateDatabaseDefaultPermissionArgs', 'DataLakeSettingsCreateDatabaseDefaultPermissionArgsDict']]]] create_database_default_permissions: Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataLakeSettingsCreateTableDefaultPermissionArgs', 'DataLakeSettingsCreateTableDefaultPermissionArgsDict']]]] create_table_default_permissions: Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] external_data_filtering_allow_lists: A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: Key-value map of additional configuration. Valid values for the `CROSS_ACCOUNT_VERSION` key are `"1"`, `"2"`, `"3"`, or `"4"`. `SET_CONTEXT` is also returned with a value of `TRUE`. In a fresh account, prior to configuring, `CROSS_ACCOUNT_VERSION` is `"1"`. Destroying this resource sets the `CROSS_ACCOUNT_VERSION` to `"1"`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] read_only_admins: Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] trusted_resource_owners: List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).
               
               > **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, `parameters`, and/or `trusted_resource_owners` results in the setting being cleared.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataLakeSettingsState.__new__(_DataLakeSettingsState)

        __props__.__dict__["admins"] = admins
        __props__.__dict__["allow_external_data_filtering"] = allow_external_data_filtering
        __props__.__dict__["allow_full_table_external_data_access"] = allow_full_table_external_data_access
        __props__.__dict__["authorized_session_tag_value_lists"] = authorized_session_tag_value_lists
        __props__.__dict__["catalog_id"] = catalog_id
        __props__.__dict__["create_database_default_permissions"] = create_database_default_permissions
        __props__.__dict__["create_table_default_permissions"] = create_table_default_permissions
        __props__.__dict__["external_data_filtering_allow_lists"] = external_data_filtering_allow_lists
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["read_only_admins"] = read_only_admins
        __props__.__dict__["region"] = region
        __props__.__dict__["trusted_resource_owners"] = trusted_resource_owners
        return DataLakeSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def admins(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Set of ARNs of AWS Lake Formation principals (IAM users or roles).
        """
        return pulumi.get(self, "admins")

    @property
    @pulumi.getter(name="allowExternalDataFiltering")
    def allow_external_data_filtering(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
        """
        return pulumi.get(self, "allow_external_data_filtering")

    @property
    @pulumi.getter(name="allowFullTableExternalDataAccess")
    def allow_full_table_external_data_access(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to allow a third-party query engine to get data access credentials without session tags when a caller has full data access permissions.
        """
        return pulumi.get(self, "allow_full_table_external_data_access")

    @property
    @pulumi.getter(name="authorizedSessionTagValueLists")
    def authorized_session_tag_value_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
        """
        return pulumi.get(self, "authorized_session_tag_value_lists")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier for the Data Catalog. By default, the account ID.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="createDatabaseDefaultPermissions")
    def create_database_default_permissions(self) -> pulumi.Output[Sequence['outputs.DataLakeSettingsCreateDatabaseDefaultPermission']]:
        """
        Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
        """
        return pulumi.get(self, "create_database_default_permissions")

    @property
    @pulumi.getter(name="createTableDefaultPermissions")
    def create_table_default_permissions(self) -> pulumi.Output[Sequence['outputs.DataLakeSettingsCreateTableDefaultPermission']]:
        """
        Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
        """
        return pulumi.get(self, "create_table_default_permissions")

    @property
    @pulumi.getter(name="externalDataFilteringAllowLists")
    def external_data_filtering_allow_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
        """
        return pulumi.get(self, "external_data_filtering_allow_lists")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Key-value map of additional configuration. Valid values for the `CROSS_ACCOUNT_VERSION` key are `"1"`, `"2"`, `"3"`, or `"4"`. `SET_CONTEXT` is also returned with a value of `TRUE`. In a fresh account, prior to configuring, `CROSS_ACCOUNT_VERSION` is `"1"`. Destroying this resource sets the `CROSS_ACCOUNT_VERSION` to `"1"`.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="readOnlyAdmins")
    def read_only_admins(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
        """
        return pulumi.get(self, "read_only_admins")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="trustedResourceOwners")
    def trusted_resource_owners(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).

        > **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, `parameters`, and/or `trusted_resource_owners` results in the setting being cleared.
        """
        return pulumi.get(self, "trusted_resource_owners")

