# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DataCellsFilterTableData',
    'DataCellsFilterTableDataColumnWildcard',
    'DataCellsFilterTableDataRowFilter',
    'DataCellsFilterTableDataRowFilterAllRowsWildcard',
    'DataCellsFilterTimeouts',
    'DataLakeSettingsCreateDatabaseDefaultPermission',
    'DataLakeSettingsCreateTableDefaultPermission',
    'OptInCondition',
    'OptInPrincipal',
    'OptInResourceData',
    'OptInResourceDataCatalog',
    'OptInResourceDataDataCellsFilter',
    'OptInResourceDataDataLocation',
    'OptInResourceDataDatabase',
    'OptInResourceDataLfTag',
    'OptInResourceDataLfTagExpression',
    'OptInResourceDataLfTagPolicy',
    'OptInResourceDataTable',
    'OptInResourceDataTableWithColumns',
    'OptInResourceDataTableWithColumnsColumnWildcard',
    'PermissionsDataCellsFilter',
    'PermissionsDataLocation',
    'PermissionsDatabase',
    'PermissionsLfTag',
    'PermissionsLfTagPolicy',
    'PermissionsLfTagPolicyExpression',
    'PermissionsTable',
    'PermissionsTableWithColumns',
    'ResourceLfTagDatabase',
    'ResourceLfTagLfTag',
    'ResourceLfTagTable',
    'ResourceLfTagTableWithColumns',
    'ResourceLfTagTableWithColumnsColumnWildcard',
    'ResourceLfTagTimeouts',
    'ResourceLfTagsDatabase',
    'ResourceLfTagsLfTag',
    'ResourceLfTagsTable',
    'ResourceLfTagsTableWithColumns',
    'GetDataLakeSettingsCreateDatabaseDefaultPermissionResult',
    'GetDataLakeSettingsCreateTableDefaultPermissionResult',
    'GetPermissionsDataCellsFilterResult',
    'GetPermissionsDataLocationResult',
    'GetPermissionsDatabaseResult',
    'GetPermissionsLfTagResult',
    'GetPermissionsLfTagPolicyResult',
    'GetPermissionsLfTagPolicyExpressionResult',
    'GetPermissionsTableResult',
    'GetPermissionsTableWithColumnsResult',
]

@pulumi.output_type
class DataCellsFilterTableData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "tableCatalogId":
            suggest = "table_catalog_id"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "columnNames":
            suggest = "column_names"
        elif key == "columnWildcard":
            suggest = "column_wildcard"
        elif key == "rowFilter":
            suggest = "row_filter"
        elif key == "versionId":
            suggest = "version_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCellsFilterTableData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCellsFilterTableData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCellsFilterTableData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 name: builtins.str,
                 table_catalog_id: builtins.str,
                 table_name: builtins.str,
                 column_names: Optional[Sequence[builtins.str]] = None,
                 column_wildcard: Optional['outputs.DataCellsFilterTableDataColumnWildcard'] = None,
                 row_filter: Optional['outputs.DataCellsFilterTableDataRowFilter'] = None,
                 version_id: Optional[builtins.str] = None):
        """
        :param builtins.str database_name: The name of the database.
        :param builtins.str name: The name of the data cells filter.
        :param builtins.str table_catalog_id: The ID of the Data Catalog.
        :param builtins.str table_name: The name of the table.
        :param Sequence[builtins.str] column_names: A list of column names and/or nested column attributes.
        :param 'DataCellsFilterTableDataColumnWildcardArgs' column_wildcard: A wildcard with exclusions. See Column Wildcard below for details.
        :param 'DataCellsFilterTableDataRowFilterArgs' row_filter: A PartiQL predicate. See Row Filter below for details.
        :param builtins.str version_id: ID of the data cells filter version.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "table_catalog_id", table_catalog_id)
        pulumi.set(__self__, "table_name", table_name)
        if column_names is not None:
            pulumi.set(__self__, "column_names", column_names)
        if column_wildcard is not None:
            pulumi.set(__self__, "column_wildcard", column_wildcard)
        if row_filter is not None:
            pulumi.set(__self__, "row_filter", row_filter)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        The name of the database.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the data cells filter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tableCatalogId")
    def table_catalog_id(self) -> builtins.str:
        """
        The ID of the Data Catalog.
        """
        return pulumi.get(self, "table_catalog_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> builtins.str:
        """
        The name of the table.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of column names and/or nested column attributes.
        """
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter(name="columnWildcard")
    def column_wildcard(self) -> Optional['outputs.DataCellsFilterTableDataColumnWildcard']:
        """
        A wildcard with exclusions. See Column Wildcard below for details.
        """
        return pulumi.get(self, "column_wildcard")

    @property
    @pulumi.getter(name="rowFilter")
    def row_filter(self) -> Optional['outputs.DataCellsFilterTableDataRowFilter']:
        """
        A PartiQL predicate. See Row Filter below for details.
        """
        return pulumi.get(self, "row_filter")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[builtins.str]:
        """
        ID of the data cells filter version.
        """
        return pulumi.get(self, "version_id")


@pulumi.output_type
class DataCellsFilterTableDataColumnWildcard(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedColumnNames":
            suggest = "excluded_column_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCellsFilterTableDataColumnWildcard. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCellsFilterTableDataColumnWildcard.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCellsFilterTableDataColumnWildcard.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excluded_column_names: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] excluded_column_names: (Optional) Excludes column names. Any column with this name will be excluded.
        """
        if excluded_column_names is not None:
            pulumi.set(__self__, "excluded_column_names", excluded_column_names)

    @property
    @pulumi.getter(name="excludedColumnNames")
    def excluded_column_names(self) -> Optional[Sequence[builtins.str]]:
        """
        (Optional) Excludes column names. Any column with this name will be excluded.
        """
        return pulumi.get(self, "excluded_column_names")


@pulumi.output_type
class DataCellsFilterTableDataRowFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allRowsWildcard":
            suggest = "all_rows_wildcard"
        elif key == "filterExpression":
            suggest = "filter_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCellsFilterTableDataRowFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCellsFilterTableDataRowFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCellsFilterTableDataRowFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_rows_wildcard: Optional['outputs.DataCellsFilterTableDataRowFilterAllRowsWildcard'] = None,
                 filter_expression: Optional[builtins.str] = None):
        """
        :param 'DataCellsFilterTableDataRowFilterAllRowsWildcardArgs' all_rows_wildcard: (Optional) A wildcard that matches all rows.
        :param builtins.str filter_expression: (Optional) A filter expression.
        """
        if all_rows_wildcard is not None:
            pulumi.set(__self__, "all_rows_wildcard", all_rows_wildcard)
        if filter_expression is not None:
            pulumi.set(__self__, "filter_expression", filter_expression)

    @property
    @pulumi.getter(name="allRowsWildcard")
    def all_rows_wildcard(self) -> Optional['outputs.DataCellsFilterTableDataRowFilterAllRowsWildcard']:
        """
        (Optional) A wildcard that matches all rows.
        """
        return pulumi.get(self, "all_rows_wildcard")

    @property
    @pulumi.getter(name="filterExpression")
    def filter_expression(self) -> Optional[builtins.str]:
        """
        (Optional) A filter expression.
        """
        return pulumi.get(self, "filter_expression")


@pulumi.output_type
class DataCellsFilterTableDataRowFilterAllRowsWildcard(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class DataCellsFilterTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")


@pulumi.output_type
class DataLakeSettingsCreateDatabaseDefaultPermission(dict):
    def __init__(__self__, *,
                 permissions: Optional[Sequence[builtins.str]] = None,
                 principal: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] permissions: List of permissions that are granted to the principal. Valid values may include `ALL`, `SELECT`, `ALTER`, `DROP`, `DELETE`, `INSERT`, `DESCRIBE`, and `CREATE_TABLE`. For more details, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
        :param builtins.str principal: Principal who is granted permissions. To enforce metadata and underlying data access control only by IAM on new databases and tables set `principal` to `IAM_ALLOWED_PRINCIPALS` and `permissions` to `["ALL"]`.
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence[builtins.str]]:
        """
        List of permissions that are granted to the principal. Valid values may include `ALL`, `SELECT`, `ALTER`, `DROP`, `DELETE`, `INSERT`, `DESCRIBE`, and `CREATE_TABLE`. For more details, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def principal(self) -> Optional[builtins.str]:
        """
        Principal who is granted permissions. To enforce metadata and underlying data access control only by IAM on new databases and tables set `principal` to `IAM_ALLOWED_PRINCIPALS` and `permissions` to `["ALL"]`.
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class DataLakeSettingsCreateTableDefaultPermission(dict):
    def __init__(__self__, *,
                 permissions: Optional[Sequence[builtins.str]] = None,
                 principal: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] permissions: List of permissions that are granted to the principal. Valid values may include `ALL`, `SELECT`, `ALTER`, `DROP`, `DELETE`, `INSERT`, and `DESCRIBE`. For more details, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
        :param builtins.str principal: Principal who is granted permissions. To enforce metadata and underlying data access control only by IAM on new databases and tables set `principal` to `IAM_ALLOWED_PRINCIPALS` and `permissions` to `["ALL"]`.
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence[builtins.str]]:
        """
        List of permissions that are granted to the principal. Valid values may include `ALL`, `SELECT`, `ALTER`, `DROP`, `DELETE`, `INSERT`, and `DESCRIBE`. For more details, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def principal(self) -> Optional[builtins.str]:
        """
        Principal who is granted permissions. To enforce metadata and underlying data access control only by IAM on new databases and tables set `principal` to `IAM_ALLOWED_PRINCIPALS` and `permissions` to `["ALL"]`.
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class OptInCondition(dict):
    def __init__(__self__, *,
                 expression: Optional[builtins.str] = None):
        """
        :param builtins.str expression: List of LF-tag conditions or a saved expression that apply to the resource's LF-Tag policy.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def expression(self) -> Optional[builtins.str]:
        """
        List of LF-tag conditions or a saved expression that apply to the resource's LF-Tag policy.
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class OptInPrincipal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataLakePrincipalIdentifier":
            suggest = "data_lake_principal_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OptInPrincipal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OptInPrincipal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OptInPrincipal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_lake_principal_identifier: builtins.str):
        pulumi.set(__self__, "data_lake_principal_identifier", data_lake_principal_identifier)

    @property
    @pulumi.getter(name="dataLakePrincipalIdentifier")
    def data_lake_principal_identifier(self) -> builtins.str:
        return pulumi.get(self, "data_lake_principal_identifier")


@pulumi.output_type
class OptInResourceData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataCellsFilters":
            suggest = "data_cells_filters"
        elif key == "dataLocations":
            suggest = "data_locations"
        elif key == "lfTag":
            suggest = "lf_tag"
        elif key == "lfTagExpressions":
            suggest = "lf_tag_expressions"
        elif key == "lfTagPolicies":
            suggest = "lf_tag_policies"
        elif key == "tableWithColumns":
            suggest = "table_with_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OptInResourceData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OptInResourceData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OptInResourceData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 catalogs: Optional[Sequence['outputs.OptInResourceDataCatalog']] = None,
                 data_cells_filters: Optional[Sequence['outputs.OptInResourceDataDataCellsFilter']] = None,
                 data_locations: Optional[Sequence['outputs.OptInResourceDataDataLocation']] = None,
                 database: Optional['outputs.OptInResourceDataDatabase'] = None,
                 lf_tag: Optional['outputs.OptInResourceDataLfTag'] = None,
                 lf_tag_expressions: Optional[Sequence['outputs.OptInResourceDataLfTagExpression']] = None,
                 lf_tag_policies: Optional[Sequence['outputs.OptInResourceDataLfTagPolicy']] = None,
                 table: Optional['outputs.OptInResourceDataTable'] = None,
                 table_with_columns: Optional['outputs.OptInResourceDataTableWithColumns'] = None):
        """
        :param Sequence['OptInResourceDataCatalogArgs'] catalogs: Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. See Catalog for more details.
        :param Sequence['OptInResourceDataDataCellsFilterArgs'] data_cells_filters: Data cell filter. See Data Cells Filter for more details.
        :param Sequence['OptInResourceDataDataLocationArgs'] data_locations: Location of an Amazon S3 path where permissions are granted or revoked. See Data Location for more details.
        :param 'OptInResourceDataDatabaseArgs' database: Database for the resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database permissions to a principal. See Database for more details.
        :param 'OptInResourceDataLfTagArgs' lf_tag: LF-tag key and values attached to a resource.
        :param Sequence['OptInResourceDataLfTagExpressionArgs'] lf_tag_expressions: Logical expression composed of one or more LF-Tag key:value pairs. See LF-Tag Expression for more details.
        :param Sequence['OptInResourceDataLfTagPolicyArgs'] lf_tag_policies: List of LF-Tag conditions or saved LF-Tag expressions that define a resource's LF-Tag policy. See LF-Tag Policy for more details.
        :param 'OptInResourceDataTableArgs' table: Table for the resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal. See Table for more details.
        :param 'OptInResourceDataTableWithColumnsArgs' table_with_columns: Table with columns for the resource. A principal with permissions to this resource can select metadata from the columns of a table in the Data Catalog and the underlying data in Amazon S3. See Table With Columns for more details.
        """
        if catalogs is not None:
            pulumi.set(__self__, "catalogs", catalogs)
        if data_cells_filters is not None:
            pulumi.set(__self__, "data_cells_filters", data_cells_filters)
        if data_locations is not None:
            pulumi.set(__self__, "data_locations", data_locations)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if lf_tag is not None:
            pulumi.set(__self__, "lf_tag", lf_tag)
        if lf_tag_expressions is not None:
            pulumi.set(__self__, "lf_tag_expressions", lf_tag_expressions)
        if lf_tag_policies is not None:
            pulumi.set(__self__, "lf_tag_policies", lf_tag_policies)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if table_with_columns is not None:
            pulumi.set(__self__, "table_with_columns", table_with_columns)

    @property
    @pulumi.getter
    def catalogs(self) -> Optional[Sequence['outputs.OptInResourceDataCatalog']]:
        """
        Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment. See Catalog for more details.
        """
        return pulumi.get(self, "catalogs")

    @property
    @pulumi.getter(name="dataCellsFilters")
    def data_cells_filters(self) -> Optional[Sequence['outputs.OptInResourceDataDataCellsFilter']]:
        """
        Data cell filter. See Data Cells Filter for more details.
        """
        return pulumi.get(self, "data_cells_filters")

    @property
    @pulumi.getter(name="dataLocations")
    def data_locations(self) -> Optional[Sequence['outputs.OptInResourceDataDataLocation']]:
        """
        Location of an Amazon S3 path where permissions are granted or revoked. See Data Location for more details.
        """
        return pulumi.get(self, "data_locations")

    @property
    @pulumi.getter
    def database(self) -> Optional['outputs.OptInResourceDataDatabase']:
        """
        Database for the resource. Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database permissions to a principal. See Database for more details.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="lfTag")
    def lf_tag(self) -> Optional['outputs.OptInResourceDataLfTag']:
        """
        LF-tag key and values attached to a resource.
        """
        return pulumi.get(self, "lf_tag")

    @property
    @pulumi.getter(name="lfTagExpressions")
    def lf_tag_expressions(self) -> Optional[Sequence['outputs.OptInResourceDataLfTagExpression']]:
        """
        Logical expression composed of one or more LF-Tag key:value pairs. See LF-Tag Expression for more details.
        """
        return pulumi.get(self, "lf_tag_expressions")

    @property
    @pulumi.getter(name="lfTagPolicies")
    def lf_tag_policies(self) -> Optional[Sequence['outputs.OptInResourceDataLfTagPolicy']]:
        """
        List of LF-Tag conditions or saved LF-Tag expressions that define a resource's LF-Tag policy. See LF-Tag Policy for more details.
        """
        return pulumi.get(self, "lf_tag_policies")

    @property
    @pulumi.getter
    def table(self) -> Optional['outputs.OptInResourceDataTable']:
        """
        Table for the resource. A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal. See Table for more details.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="tableWithColumns")
    def table_with_columns(self) -> Optional['outputs.OptInResourceDataTableWithColumns']:
        """
        Table with columns for the resource. A principal with permissions to this resource can select metadata from the columns of a table in the Data Catalog and the underlying data in Amazon S3. See Table With Columns for more details.
        """
        return pulumi.get(self, "table_with_columns")


@pulumi.output_type
class OptInResourceDataCatalog(dict):
    def __init__(__self__, *,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.str id: Identifier for the catalog resource.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Identifier for the catalog resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class OptInResourceDataDataCellsFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "tableCatalogId":
            suggest = "table_catalog_id"
        elif key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OptInResourceDataDataCellsFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OptInResourceDataDataCellsFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OptInResourceDataDataCellsFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 table_catalog_id: Optional[builtins.str] = None,
                 table_name: Optional[builtins.str] = None):
        """
        :param builtins.str database_name: The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
        :param builtins.str name: Name of the table.
        :param builtins.str table_catalog_id: ID of the catalog to which the table belongs.
        :param builtins.str table_name: Name of the table.
        """
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if table_catalog_id is not None:
            pulumi.set(__self__, "table_catalog_id", table_catalog_id)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[builtins.str]:
        """
        The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tableCatalogId")
    def table_catalog_id(self) -> Optional[builtins.str]:
        """
        ID of the catalog to which the table belongs.
        """
        return pulumi.get(self, "table_catalog_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[builtins.str]:
        """
        Name of the table.
        """
        return pulumi.get(self, "table_name")


@pulumi.output_type
class OptInResourceDataDataLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceArn":
            suggest = "resource_arn"
        elif key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OptInResourceDataDataLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OptInResourceDataDataLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OptInResourceDataDataLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_arn: builtins.str,
                 catalog_id: Optional[builtins.str] = None):
        """
        :param builtins.str resource_arn: ARN that uniquely identifies the data location resource.
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "resource_arn", resource_arn)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> builtins.str:
        """
        ARN that uniquely identifies the data location resource.
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class OptInResourceDataDatabase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OptInResourceDataDatabase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OptInResourceDataDatabase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OptInResourceDataDatabase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 catalog_id: Optional[builtins.str] = None):
        """
        :param builtins.str name: Name of the table.
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "name", name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class OptInResourceDataLfTag(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OptInResourceDataLfTag. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OptInResourceDataLfTag.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OptInResourceDataLfTag.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str,
                 catalog_id: Optional[builtins.str] = None):
        """
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class OptInResourceDataLfTagExpression(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OptInResourceDataLfTagExpression. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OptInResourceDataLfTagExpression.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OptInResourceDataLfTagExpression.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 catalog_id: Optional[builtins.str] = None):
        """
        :param builtins.str name: Name of the table.
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "name", name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class OptInResourceDataLfTagPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "catalogId":
            suggest = "catalog_id"
        elif key == "expressionName":
            suggest = "expression_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OptInResourceDataLfTagPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OptInResourceDataLfTagPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OptInResourceDataLfTagPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: builtins.str,
                 catalog_id: Optional[builtins.str] = None,
                 expression_name: Optional[builtins.str] = None,
                 expressions: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str resource_type: Resource type for which the LF-tag policy applies.
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param builtins.str expression_name: If provided, permissions are granted to the Data Catalog resources whose assigned LF-Tags match the expression body of the saved expression under the provided ExpressionName .
        :param Sequence[builtins.str] expressions: List of LF-tag conditions or a saved expression that apply to the resource's LF-Tag policy.
        """
        pulumi.set(__self__, "resource_type", resource_type)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if expression_name is not None:
            pulumi.set(__self__, "expression_name", expression_name)
        if expressions is not None:
            pulumi.set(__self__, "expressions", expressions)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        Resource type for which the LF-tag policy applies.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="expressionName")
    def expression_name(self) -> Optional[builtins.str]:
        """
        If provided, permissions are granted to the Data Catalog resources whose assigned LF-Tags match the expression body of the saved expression under the provided ExpressionName .
        """
        return pulumi.get(self, "expression_name")

    @property
    @pulumi.getter
    def expressions(self) -> Optional[Sequence[builtins.str]]:
        """
        List of LF-tag conditions or a saved expression that apply to the resource's LF-Tag policy.
        """
        return pulumi.get(self, "expressions")


@pulumi.output_type
class OptInResourceDataTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OptInResourceDataTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OptInResourceDataTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OptInResourceDataTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 catalog_id: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 wildcard: Optional[builtins.bool] = None):
        """
        :param builtins.str database_name: The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param builtins.str name: Name of the table.
        :param builtins.bool wildcard: Boolean value that indicates whether to use a wildcard representing every table under the specified database. When set to true, this represents all tables within the specified database. At least one of TableResource$Name or TableResource$Wildcard is required.
        """
        pulumi.set(__self__, "database_name", database_name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if wildcard is not None:
            pulumi.set(__self__, "wildcard", wildcard)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def wildcard(self) -> Optional[builtins.bool]:
        """
        Boolean value that indicates whether to use a wildcard representing every table under the specified database. When set to true, this represents all tables within the specified database. At least one of TableResource$Name or TableResource$Wildcard is required.
        """
        return pulumi.get(self, "wildcard")


@pulumi.output_type
class OptInResourceDataTableWithColumns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "catalogId":
            suggest = "catalog_id"
        elif key == "columnNames":
            suggest = "column_names"
        elif key == "columnWildcard":
            suggest = "column_wildcard"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OptInResourceDataTableWithColumns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OptInResourceDataTableWithColumns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OptInResourceDataTableWithColumns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 name: builtins.str,
                 catalog_id: Optional[builtins.str] = None,
                 column_names: Optional[Sequence[builtins.str]] = None,
                 column_wildcard: Optional['outputs.OptInResourceDataTableWithColumnsColumnWildcard'] = None):
        """
        :param builtins.str database_name: The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
        :param builtins.str name: Name of the table.
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param Sequence[builtins.str] column_names: List of column names for the table. At least one of ColumnNames or ColumnWildcard is required.
        :param 'OptInResourceDataTableWithColumnsColumnWildcardArgs' column_wildcard: Wildcard specified by a ColumnWildcard object. At least one of ColumnNames or ColumnWildcard is required.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if column_names is not None:
            pulumi.set(__self__, "column_names", column_names)
        if column_wildcard is not None:
            pulumi.set(__self__, "column_wildcard", column_wildcard)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        The name of the database for the table. Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[Sequence[builtins.str]]:
        """
        List of column names for the table. At least one of ColumnNames or ColumnWildcard is required.
        """
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter(name="columnWildcard")
    def column_wildcard(self) -> Optional['outputs.OptInResourceDataTableWithColumnsColumnWildcard']:
        """
        Wildcard specified by a ColumnWildcard object. At least one of ColumnNames or ColumnWildcard is required.
        """
        return pulumi.get(self, "column_wildcard")


@pulumi.output_type
class OptInResourceDataTableWithColumnsColumnWildcard(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedColumnNames":
            suggest = "excluded_column_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OptInResourceDataTableWithColumnsColumnWildcard. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OptInResourceDataTableWithColumnsColumnWildcard.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OptInResourceDataTableWithColumnsColumnWildcard.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excluded_column_names: Optional[Sequence[builtins.str]] = None):
        if excluded_column_names is not None:
            pulumi.set(__self__, "excluded_column_names", excluded_column_names)

    @property
    @pulumi.getter(name="excludedColumnNames")
    def excluded_column_names(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "excluded_column_names")


@pulumi.output_type
class PermissionsDataCellsFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "tableCatalogId":
            suggest = "table_catalog_id"
        elif key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsDataCellsFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsDataCellsFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsDataCellsFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 name: builtins.str,
                 table_catalog_id: builtins.str,
                 table_name: builtins.str):
        """
        :param builtins.str database_name: The name of the database.
        :param builtins.str name: The name of the data cells filter.
        :param builtins.str table_catalog_id: The ID of the Data Catalog.
        :param builtins.str table_name: The name of the table.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "table_catalog_id", table_catalog_id)
        pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        The name of the database.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the data cells filter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tableCatalogId")
    def table_catalog_id(self) -> builtins.str:
        """
        The ID of the Data Catalog.
        """
        return pulumi.get(self, "table_catalog_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> builtins.str:
        """
        The name of the table.
        """
        return pulumi.get(self, "table_name")


@pulumi.output_type
class PermissionsDataLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsDataLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsDataLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsDataLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: builtins.str,
                 catalog_id: Optional[builtins.str] = None):
        """
        :param builtins.str arn: Amazon Resource Name (ARN) that uniquely identifies the data location resource.
               
               The following argument is optional:
        :param builtins.str catalog_id: Identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "arn", arn)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        Amazon Resource Name (ARN) that uniquely identifies the data location resource.

        The following argument is optional:
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class PermissionsDatabase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsDatabase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsDatabase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsDatabase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 catalog_id: Optional[builtins.str] = None):
        """
        :param builtins.str name: Name of the database resource. Unique to the Data Catalog.
               
               The following argument is optional:
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "name", name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the database resource. Unique to the Data Catalog.

        The following argument is optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class PermissionsLfTag(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsLfTag. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsLfTag.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsLfTag.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str],
                 catalog_id: Optional[builtins.str] = None):
        """
        :param builtins.str key: The key-name for the tag.
        :param Sequence[builtins.str] values: A list of possible values an attribute can take.
               
               The following argument is optional:
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key-name for the tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        A list of possible values an attribute can take.

        The following argument is optional:
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class PermissionsLfTagPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsLfTagPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsLfTagPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsLfTagPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expressions: Sequence['outputs.PermissionsLfTagPolicyExpression'],
                 resource_type: builtins.str,
                 catalog_id: Optional[builtins.str] = None):
        """
        :param Sequence['PermissionsLfTagPolicyExpressionArgs'] expressions: A list of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
               
               The following argument is optional:
        :param builtins.str resource_type: The resource type for which the tag policy applies. Valid values are `DATABASE` and `TABLE`.
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "expressions", expressions)
        pulumi.set(__self__, "resource_type", resource_type)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def expressions(self) -> Sequence['outputs.PermissionsLfTagPolicyExpression']:
        """
        A list of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.

        The following argument is optional:
        """
        return pulumi.get(self, "expressions")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        The resource type for which the tag policy applies. Valid values are `DATABASE` and `TABLE`.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class PermissionsLfTagPolicyExpression(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: The key-name of an LF-Tag.
        :param Sequence[builtins.str] values: A list of possible values of an LF-Tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key-name of an LF-Tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        A list of possible values of an LF-Tag.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class PermissionsTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 catalog_id: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 wildcard: Optional[builtins.bool] = None):
        """
        :param builtins.str database_name: Name of the database for the table. Unique to a Data Catalog.
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param builtins.str name: Name of the table.
        :param builtins.bool wildcard: Whether to use a wildcard representing every table under a database. Defaults to `false`.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "database_name", database_name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if wildcard is not None:
            pulumi.set(__self__, "wildcard", wildcard)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        Name of the database for the table. Unique to a Data Catalog.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def wildcard(self) -> Optional[builtins.bool]:
        """
        Whether to use a wildcard representing every table under a database. Defaults to `false`.

        The following arguments are optional:
        """
        return pulumi.get(self, "wildcard")


@pulumi.output_type
class PermissionsTableWithColumns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "catalogId":
            suggest = "catalog_id"
        elif key == "columnNames":
            suggest = "column_names"
        elif key == "excludedColumnNames":
            suggest = "excluded_column_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PermissionsTableWithColumns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PermissionsTableWithColumns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PermissionsTableWithColumns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 name: builtins.str,
                 catalog_id: Optional[builtins.str] = None,
                 column_names: Optional[Sequence[builtins.str]] = None,
                 excluded_column_names: Optional[Sequence[builtins.str]] = None,
                 wildcard: Optional[builtins.bool] = None):
        """
        :param builtins.str database_name: Name of the database for the table with columns resource. Unique to the Data Catalog.
        :param builtins.str name: Name of the table resource.
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param Sequence[builtins.str] column_names: Set of column names for the table.
        :param Sequence[builtins.str] excluded_column_names: Set of column names for the table to exclude. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
        :param builtins.bool wildcard: Whether to use a column wildcard. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if column_names is not None:
            pulumi.set(__self__, "column_names", column_names)
        if excluded_column_names is not None:
            pulumi.set(__self__, "excluded_column_names", excluded_column_names)
        if wildcard is not None:
            pulumi.set(__self__, "wildcard", wildcard)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        Name of the database for the table with columns resource. Unique to the Data Catalog.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the table resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[Sequence[builtins.str]]:
        """
        Set of column names for the table.
        """
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter(name="excludedColumnNames")
    def excluded_column_names(self) -> Optional[Sequence[builtins.str]]:
        """
        Set of column names for the table to exclude. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
        """
        return pulumi.get(self, "excluded_column_names")

    @property
    @pulumi.getter
    def wildcard(self) -> Optional[builtins.bool]:
        """
        Whether to use a column wildcard. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.

        The following arguments are optional:
        """
        return pulumi.get(self, "wildcard")


@pulumi.output_type
class ResourceLfTagDatabase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceLfTagDatabase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceLfTagDatabase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceLfTagDatabase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 catalog_id: Optional[builtins.str] = None):
        """
        :param builtins.str name: Name of the database resource. Unique to the Data Catalog.
               
               The following argument is optional:
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "name", name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the database resource. Unique to the Data Catalog.

        The following argument is optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class ResourceLfTagLfTag(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceLfTagLfTag. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceLfTagLfTag.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceLfTagLfTag.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str,
                 catalog_id: Optional[builtins.str] = None):
        """
        :param builtins.str key: Key name for an existing LF-tag.
        :param builtins.str value: Value from the possible values for the LF-tag.
               
               The following argument is optional:
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Key name for an existing LF-tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value from the possible values for the LF-tag.

        The following argument is optional:
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class ResourceLfTagTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceLfTagTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceLfTagTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceLfTagTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 catalog_id: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 wildcard: Optional[builtins.bool] = None):
        """
        :param builtins.str database_name: Name of the database for the table. Unique to a Data Catalog.
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param builtins.str name: Name of the table.
        :param builtins.bool wildcard: Whether to use a wildcard representing every table under a database. Defaults to `false`.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "database_name", database_name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if wildcard is not None:
            pulumi.set(__self__, "wildcard", wildcard)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        Name of the database for the table. Unique to a Data Catalog.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def wildcard(self) -> Optional[builtins.bool]:
        """
        Whether to use a wildcard representing every table under a database. Defaults to `false`.

        The following arguments are optional:
        """
        return pulumi.get(self, "wildcard")


@pulumi.output_type
class ResourceLfTagTableWithColumns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "catalogId":
            suggest = "catalog_id"
        elif key == "columnNames":
            suggest = "column_names"
        elif key == "columnWildcard":
            suggest = "column_wildcard"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceLfTagTableWithColumns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceLfTagTableWithColumns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceLfTagTableWithColumns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 name: builtins.str,
                 catalog_id: Optional[builtins.str] = None,
                 column_names: Optional[Sequence[builtins.str]] = None,
                 column_wildcard: Optional['outputs.ResourceLfTagTableWithColumnsColumnWildcard'] = None):
        """
        :param builtins.str database_name: Name of the database for the table with columns resource. Unique to the Data Catalog.
        :param builtins.str name: Name of the table resource.
               
               The following arguments are optional:
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param Sequence[builtins.str] column_names: Set of column names for the table.
        :param 'ResourceLfTagTableWithColumnsColumnWildcardArgs' column_wildcard: Option to add column wildcard. See Column Wildcard for more details.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if column_names is not None:
            pulumi.set(__self__, "column_names", column_names)
        if column_wildcard is not None:
            pulumi.set(__self__, "column_wildcard", column_wildcard)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        Name of the database for the table with columns resource. Unique to the Data Catalog.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the table resource.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[Sequence[builtins.str]]:
        """
        Set of column names for the table.
        """
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter(name="columnWildcard")
    def column_wildcard(self) -> Optional['outputs.ResourceLfTagTableWithColumnsColumnWildcard']:
        """
        Option to add column wildcard. See Column Wildcard for more details.
        """
        return pulumi.get(self, "column_wildcard")


@pulumi.output_type
class ResourceLfTagTableWithColumnsColumnWildcard(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedColumnNames":
            suggest = "excluded_column_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceLfTagTableWithColumnsColumnWildcard. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceLfTagTableWithColumnsColumnWildcard.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceLfTagTableWithColumnsColumnWildcard.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excluded_column_names: Optional[Sequence[builtins.str]] = None):
        if excluded_column_names is not None:
            pulumi.set(__self__, "excluded_column_names", excluded_column_names)

    @property
    @pulumi.getter(name="excludedColumnNames")
    def excluded_column_names(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "excluded_column_names")


@pulumi.output_type
class ResourceLfTagTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class ResourceLfTagsDatabase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceLfTagsDatabase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceLfTagsDatabase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceLfTagsDatabase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 catalog_id: Optional[builtins.str] = None):
        """
        :param builtins.str name: Name of the database resource. Unique to the Data Catalog.
               
               The following argument is optional:
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "name", name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the database resource. Unique to the Data Catalog.

        The following argument is optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class ResourceLfTagsLfTag(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceLfTagsLfTag. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceLfTagsLfTag.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceLfTagsLfTag.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str,
                 catalog_id: Optional[builtins.str] = None):
        """
        :param builtins.str key: Key name for an existing LF-tag.
        :param builtins.str value: Value from the possible values for the LF-tag.
               
               The following argument is optional:
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Key name for an existing LF-tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value from the possible values for the LF-tag.

        The following argument is optional:
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class ResourceLfTagsTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "catalogId":
            suggest = "catalog_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceLfTagsTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceLfTagsTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceLfTagsTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 catalog_id: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 wildcard: Optional[builtins.bool] = None):
        """
        :param builtins.str database_name: Name of the database for the table. Unique to a Data Catalog.
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param builtins.str name: Name of the table.
        :param builtins.bool wildcard: Whether to use a wildcard representing every table under a database. Defaults to `false`.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "database_name", database_name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if wildcard is not None:
            pulumi.set(__self__, "wildcard", wildcard)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        Name of the database for the table. Unique to a Data Catalog.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def wildcard(self) -> Optional[builtins.bool]:
        """
        Whether to use a wildcard representing every table under a database. Defaults to `false`.

        The following arguments are optional:
        """
        return pulumi.get(self, "wildcard")


@pulumi.output_type
class ResourceLfTagsTableWithColumns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "catalogId":
            suggest = "catalog_id"
        elif key == "columnNames":
            suggest = "column_names"
        elif key == "excludedColumnNames":
            suggest = "excluded_column_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceLfTagsTableWithColumns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceLfTagsTableWithColumns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceLfTagsTableWithColumns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 name: builtins.str,
                 catalog_id: Optional[builtins.str] = None,
                 column_names: Optional[Sequence[builtins.str]] = None,
                 excluded_column_names: Optional[Sequence[builtins.str]] = None,
                 wildcard: Optional[builtins.bool] = None):
        """
        :param builtins.str database_name: Name of the database for the table with columns resource. Unique to the Data Catalog.
        :param builtins.str name: Name of the table resource.
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param Sequence[builtins.str] column_names: Set of column names for the table.
        :param Sequence[builtins.str] excluded_column_names: Set of column names for the table to exclude. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
        :param builtins.bool wildcard: Whether to use a column wildcard. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if column_names is not None:
            pulumi.set(__self__, "column_names", column_names)
        if excluded_column_names is not None:
            pulumi.set(__self__, "excluded_column_names", excluded_column_names)
        if wildcard is not None:
            pulumi.set(__self__, "wildcard", wildcard)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        Name of the database for the table with columns resource. Unique to the Data Catalog.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the table resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[builtins.str]:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[Sequence[builtins.str]]:
        """
        Set of column names for the table.
        """
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter(name="excludedColumnNames")
    def excluded_column_names(self) -> Optional[Sequence[builtins.str]]:
        """
        Set of column names for the table to exclude. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
        """
        return pulumi.get(self, "excluded_column_names")

    @property
    @pulumi.getter
    def wildcard(self) -> Optional[builtins.bool]:
        """
        Whether to use a column wildcard. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.

        The following arguments are optional:
        """
        return pulumi.get(self, "wildcard")


@pulumi.output_type
class GetDataLakeSettingsCreateDatabaseDefaultPermissionResult(dict):
    def __init__(__self__, *,
                 permissions: Sequence[builtins.str],
                 principal: builtins.str):
        """
        :param Sequence[builtins.str] permissions: List of permissions granted to the principal.
        :param builtins.str principal: Principal who is granted permissions.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[builtins.str]:
        """
        List of permissions granted to the principal.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def principal(self) -> builtins.str:
        """
        Principal who is granted permissions.
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class GetDataLakeSettingsCreateTableDefaultPermissionResult(dict):
    def __init__(__self__, *,
                 permissions: Sequence[builtins.str],
                 principal: builtins.str):
        """
        :param Sequence[builtins.str] permissions: List of permissions granted to the principal.
        :param builtins.str principal: Principal who is granted permissions.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[builtins.str]:
        """
        List of permissions granted to the principal.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def principal(self) -> builtins.str:
        """
        Principal who is granted permissions.
        """
        return pulumi.get(self, "principal")


@pulumi.output_type
class GetPermissionsDataCellsFilterResult(dict):
    def __init__(__self__, *,
                 database_name: builtins.str,
                 name: builtins.str,
                 table_catalog_id: builtins.str,
                 table_name: builtins.str):
        """
        :param builtins.str database_name: The name of the database.
        :param builtins.str name: The name of the data cells filter.
        :param builtins.str table_catalog_id: The ID of the Data Catalog.
        :param builtins.str table_name: The name of the table.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "table_catalog_id", table_catalog_id)
        pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        The name of the database.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the data cells filter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tableCatalogId")
    def table_catalog_id(self) -> builtins.str:
        """
        The ID of the Data Catalog.
        """
        return pulumi.get(self, "table_catalog_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> builtins.str:
        """
        The name of the table.
        """
        return pulumi.get(self, "table_name")


@pulumi.output_type
class GetPermissionsDataLocationResult(dict):
    def __init__(__self__, *,
                 arn: builtins.str,
                 catalog_id: builtins.str):
        """
        :param builtins.str arn: ARN that uniquely identifies the data location resource.
               
               The following argument is optional:
        :param builtins.str catalog_id: Identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "catalog_id", catalog_id)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN that uniquely identifies the data location resource.

        The following argument is optional:
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> builtins.str:
        """
        Identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")


@pulumi.output_type
class GetPermissionsDatabaseResult(dict):
    def __init__(__self__, *,
                 catalog_id: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param builtins.str name: Name of the database resource. Unique to the Data Catalog.
               
               The following argument is optional:
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> builtins.str:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the database resource. Unique to the Data Catalog.

        The following argument is optional:
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPermissionsLfTagResult(dict):
    def __init__(__self__, *,
                 catalog_id: builtins.str,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param builtins.str key: Key-name for the tag.
        :param Sequence[builtins.str] values: List of possible values an attribute can take.
               
               The following argument is optional:
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> builtins.str:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Key-name for the tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        List of possible values an attribute can take.

        The following argument is optional:
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetPermissionsLfTagPolicyResult(dict):
    def __init__(__self__, *,
                 catalog_id: builtins.str,
                 expressions: Sequence['outputs.GetPermissionsLfTagPolicyExpressionResult'],
                 resource_type: builtins.str):
        """
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param Sequence['GetPermissionsLfTagPolicyExpressionArgs'] expressions: List of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
               
               The following argument is optional:
        :param builtins.str resource_type: Resource type for which the tag policy applies. Valid values are `DATABASE` and `TABLE`.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "expressions", expressions)
        pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> builtins.str:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter
    def expressions(self) -> Sequence['outputs.GetPermissionsLfTagPolicyExpressionResult']:
        """
        List of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.

        The following argument is optional:
        """
        return pulumi.get(self, "expressions")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        Resource type for which the tag policy applies. Valid values are `DATABASE` and `TABLE`.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class GetPermissionsLfTagPolicyExpressionResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Key-name of an LF-Tag.
        :param Sequence[builtins.str] values: List of possible values of an LF-Tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Key-name of an LF-Tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        List of possible values of an LF-Tag.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetPermissionsTableResult(dict):
    def __init__(__self__, *,
                 catalog_id: builtins.str,
                 database_name: builtins.str,
                 name: builtins.str,
                 wildcard: Optional[builtins.bool] = None):
        """
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param builtins.str database_name: Name of the database for the table. Unique to a Data Catalog.
               
               The following arguments are optional:
        :param builtins.str name: Name of the table. At least one of `name` or `wildcard` is required.
        :param builtins.bool wildcard: Whether to use a wildcard representing every table under a database. At least one of `name` or `wildcard` is required. Defaults to `false`.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)
        if wildcard is not None:
            pulumi.set(__self__, "wildcard", wildcard)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> builtins.str:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        Name of the database for the table. Unique to a Data Catalog.

        The following arguments are optional:
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the table. At least one of `name` or `wildcard` is required.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def wildcard(self) -> Optional[builtins.bool]:
        """
        Whether to use a wildcard representing every table under a database. At least one of `name` or `wildcard` is required. Defaults to `false`.
        """
        return pulumi.get(self, "wildcard")


@pulumi.output_type
class GetPermissionsTableWithColumnsResult(dict):
    def __init__(__self__, *,
                 catalog_id: builtins.str,
                 database_name: builtins.str,
                 name: builtins.str,
                 column_names: Optional[Sequence[builtins.str]] = None,
                 excluded_column_names: Optional[Sequence[builtins.str]] = None,
                 wildcard: Optional[builtins.bool] = None):
        """
        :param builtins.str catalog_id: Identifier for the Data Catalog. By default, it is the account ID of the caller.
        :param builtins.str database_name: Name of the database for the table with columns resource. Unique to the Data Catalog.
        :param builtins.str name: Name of the table resource.
               
               The following arguments are optional:
        :param Sequence[builtins.str] column_names: Set of column names for the table. At least one of `column_names` or `excluded_column_names` is required.
        :param Sequence[builtins.str] excluded_column_names: Set of column names for the table to exclude. At least one of `column_names` or `excluded_column_names` is required.
        :param builtins.bool wildcard: Whether to use a wildcard representing every table under a database. At least one of `name` or `wildcard` is required. Defaults to `false`.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "name", name)
        if column_names is not None:
            pulumi.set(__self__, "column_names", column_names)
        if excluded_column_names is not None:
            pulumi.set(__self__, "excluded_column_names", excluded_column_names)
        if wildcard is not None:
            pulumi.set(__self__, "wildcard", wildcard)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> builtins.str:
        """
        Identifier for the Data Catalog. By default, it is the account ID of the caller.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        Name of the database for the table with columns resource. Unique to the Data Catalog.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the table resource.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[Sequence[builtins.str]]:
        """
        Set of column names for the table. At least one of `column_names` or `excluded_column_names` is required.
        """
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter(name="excludedColumnNames")
    def excluded_column_names(self) -> Optional[Sequence[builtins.str]]:
        """
        Set of column names for the table to exclude. At least one of `column_names` or `excluded_column_names` is required.
        """
        return pulumi.get(self, "excluded_column_names")

    @property
    @pulumi.getter
    def wildcard(self) -> Optional[builtins.bool]:
        """
        Whether to use a wildcard representing every table under a database. At least one of `name` or `wildcard` is required. Defaults to `false`.
        """
        return pulumi.get(self, "wildcard")


