# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EventSourceMappingArgs', 'EventSourceMapping']

@pulumi.input_type
class EventSourceMappingArgs:
    def __init__(__self__, *,
                 function_name: pulumi.Input[builtins.str],
                 amazon_managed_kafka_event_source_config: Optional[pulumi.Input['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs']] = None,
                 batch_size: Optional[pulumi.Input[builtins.int]] = None,
                 bisect_batch_on_function_error: Optional[pulumi.Input[builtins.bool]] = None,
                 destination_config: Optional[pulumi.Input['EventSourceMappingDestinationConfigArgs']] = None,
                 document_db_event_source_config: Optional[pulumi.Input['EventSourceMappingDocumentDbEventSourceConfigArgs']] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 event_source_arn: Optional[pulumi.Input[builtins.str]] = None,
                 filter_criteria: Optional[pulumi.Input['EventSourceMappingFilterCriteriaArgs']] = None,
                 function_response_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 maximum_batching_window_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 maximum_record_age_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 maximum_retry_attempts: Optional[pulumi.Input[builtins.int]] = None,
                 metrics_config: Optional[pulumi.Input['EventSourceMappingMetricsConfigArgs']] = None,
                 parallelization_factor: Optional[pulumi.Input[builtins.int]] = None,
                 provisioned_poller_config: Optional[pulumi.Input['EventSourceMappingProvisionedPollerConfigArgs']] = None,
                 queues: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scaling_config: Optional[pulumi.Input['EventSourceMappingScalingConfigArgs']] = None,
                 self_managed_event_source: Optional[pulumi.Input['EventSourceMappingSelfManagedEventSourceArgs']] = None,
                 self_managed_kafka_event_source_config: Optional[pulumi.Input['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs']] = None,
                 source_access_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingSourceAccessConfigurationArgs']]]] = None,
                 starting_position: Optional[pulumi.Input[builtins.str]] = None,
                 starting_position_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tumbling_window_in_seconds: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a EventSourceMapping resource.
        :param pulumi.Input[builtins.str] function_name: Name or ARN of the Lambda function that will be subscribing to events.
               
               The following arguments are optional:
        :param pulumi.Input['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs'] amazon_managed_kafka_event_source_config: Additional configuration block for Amazon Managed Kafka sources. Incompatible with `self_managed_event_source` and `self_managed_kafka_event_source_config`. See below.
        :param pulumi.Input[builtins.int] batch_size: Largest number of records that Lambda will retrieve from your event source at the time of invocation. Defaults to `100` for DynamoDB, Kinesis, MQ and MSK, `10` for SQS.
        :param pulumi.Input[builtins.bool] bisect_batch_on_function_error: Whether to split the batch in two and retry if the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Defaults to `false`.
        :param pulumi.Input['EventSourceMappingDestinationConfigArgs'] destination_config: Amazon SQS queue, Amazon SNS topic or Amazon S3 bucket (only available for Kafka sources) destination for failed records. Only available for stream sources (DynamoDB and Kinesis) and Kafka sources (Amazon MSK and Self-managed Apache Kafka). See below.
        :param pulumi.Input['EventSourceMappingDocumentDbEventSourceConfigArgs'] document_db_event_source_config: Configuration settings for a DocumentDB event source. See below.
        :param pulumi.Input[builtins.bool] enabled: Whether the mapping is enabled. Defaults to `true`.
        :param pulumi.Input[builtins.str] event_source_arn: Event source ARN - required for Kinesis stream, DynamoDB stream, SQS queue, MQ broker, MSK cluster or DocumentDB change stream. Incompatible with Self Managed Kafka source.
        :param pulumi.Input['EventSourceMappingFilterCriteriaArgs'] filter_criteria: Criteria to use for [event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html) Kinesis stream, DynamoDB stream, SQS queue event sources. See below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] function_response_types: List of current response type enums applied to the event source mapping for [AWS Lambda checkpointing](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting). Only available for SQS and stream sources (DynamoDB and Kinesis). Valid values: `ReportBatchItemFailures`.
        :param pulumi.Input[builtins.str] kms_key_arn: ARN of the Key Management Service (KMS) customer managed key that Lambda uses to encrypt your function's filter criteria.
        :param pulumi.Input[builtins.int] maximum_batching_window_in_seconds: Maximum amount of time to gather records before invoking the function, in seconds (between 0 and 300). Records will continue to buffer until either `maximum_batching_window_in_seconds` expires or `batch_size` has been met. For streaming event sources, defaults to as soon as records are available in the stream. Only available for stream sources (DynamoDB and Kinesis) and SQS standard queues.
        :param pulumi.Input[builtins.int] maximum_record_age_in_seconds: Maximum age of a record that Lambda sends to a function for processing. Only available for stream sources (DynamoDB and Kinesis). Must be either -1 (forever, and the default value) or between 60 and 604800 (inclusive).
        :param pulumi.Input[builtins.int] maximum_retry_attempts: Maximum number of times to retry when the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of -1 (forever), maximum of 10000.
        :param pulumi.Input['EventSourceMappingMetricsConfigArgs'] metrics_config: CloudWatch metrics configuration of the event source. Only available for stream sources (DynamoDB and Kinesis) and SQS queues. See below.
        :param pulumi.Input[builtins.int] parallelization_factor: Number of batches to process from each shard concurrently. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of 1, maximum of 10.
        :param pulumi.Input['EventSourceMappingProvisionedPollerConfigArgs'] provisioned_poller_config: Event poller configuration for the event source. Only valid for Amazon MSK or self-managed Apache Kafka sources. See below.
        :param pulumi.Input[builtins.str] queues: Name of the Amazon MQ broker destination queue to consume. Only available for MQ sources. The list must contain exactly one queue name.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['EventSourceMappingScalingConfigArgs'] scaling_config: Scaling configuration of the event source. Only available for SQS queues. See below.
        :param pulumi.Input['EventSourceMappingSelfManagedEventSourceArgs'] self_managed_event_source: For Self Managed Kafka sources, the location of the self managed cluster. If set, configuration must also include `source_access_configuration`. See below.
        :param pulumi.Input['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs'] self_managed_kafka_event_source_config: Additional configuration block for Self Managed Kafka sources. Incompatible with `event_source_arn` and `amazon_managed_kafka_event_source_config`. See below.
        :param pulumi.Input[Sequence[pulumi.Input['EventSourceMappingSourceAccessConfigurationArgs']]] source_access_configurations: For Self Managed Kafka sources, the access configuration for the source. If set, configuration must also include `self_managed_event_source`. See below.
        :param pulumi.Input[builtins.str] starting_position: Position in the stream where AWS Lambda should start reading. Must be one of `AT_TIMESTAMP` (Kinesis only), `LATEST` or `TRIM_HORIZON` if getting events from Kinesis, DynamoDB, MSK or Self Managed Apache Kafka. Must not be provided if getting events from SQS. More information about these positions can be found in the [AWS DynamoDB Streams API Reference](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator.html) and [AWS Kinesis API Reference](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType).
        :param pulumi.Input[builtins.str] starting_position_timestamp: Timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of the data record which to start reading when using `starting_position` set to `AT_TIMESTAMP`. If a record with this exact timestamp does not exist, the next later record is chosen. If the timestamp is older than the current trim horizon, the oldest available record is chosen.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] topics: Name of the Kafka topics. Only available for MSK sources. A single topic name must be specified.
        :param pulumi.Input[builtins.int] tumbling_window_in_seconds: Duration in seconds of a processing window for [AWS Lambda streaming analytics](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-windows). The range is between 1 second up to 900 seconds. Only available for stream sources (DynamoDB and Kinesis).
        """
        pulumi.set(__self__, "function_name", function_name)
        if amazon_managed_kafka_event_source_config is not None:
            pulumi.set(__self__, "amazon_managed_kafka_event_source_config", amazon_managed_kafka_event_source_config)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if bisect_batch_on_function_error is not None:
            pulumi.set(__self__, "bisect_batch_on_function_error", bisect_batch_on_function_error)
        if destination_config is not None:
            pulumi.set(__self__, "destination_config", destination_config)
        if document_db_event_source_config is not None:
            pulumi.set(__self__, "document_db_event_source_config", document_db_event_source_config)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if event_source_arn is not None:
            pulumi.set(__self__, "event_source_arn", event_source_arn)
        if filter_criteria is not None:
            pulumi.set(__self__, "filter_criteria", filter_criteria)
        if function_response_types is not None:
            pulumi.set(__self__, "function_response_types", function_response_types)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)
        if maximum_record_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_record_age_in_seconds", maximum_record_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)
        if metrics_config is not None:
            pulumi.set(__self__, "metrics_config", metrics_config)
        if parallelization_factor is not None:
            pulumi.set(__self__, "parallelization_factor", parallelization_factor)
        if provisioned_poller_config is not None:
            pulumi.set(__self__, "provisioned_poller_config", provisioned_poller_config)
        if queues is not None:
            pulumi.set(__self__, "queues", queues)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scaling_config is not None:
            pulumi.set(__self__, "scaling_config", scaling_config)
        if self_managed_event_source is not None:
            pulumi.set(__self__, "self_managed_event_source", self_managed_event_source)
        if self_managed_kafka_event_source_config is not None:
            pulumi.set(__self__, "self_managed_kafka_event_source_config", self_managed_kafka_event_source_config)
        if source_access_configurations is not None:
            pulumi.set(__self__, "source_access_configurations", source_access_configurations)
        if starting_position is not None:
            pulumi.set(__self__, "starting_position", starting_position)
        if starting_position_timestamp is not None:
            pulumi.set(__self__, "starting_position_timestamp", starting_position_timestamp)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if tumbling_window_in_seconds is not None:
            pulumi.set(__self__, "tumbling_window_in_seconds", tumbling_window_in_seconds)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[builtins.str]:
        """
        Name or ARN of the Lambda function that will be subscribing to events.

        The following arguments are optional:
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter(name="amazonManagedKafkaEventSourceConfig")
    def amazon_managed_kafka_event_source_config(self) -> Optional[pulumi.Input['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs']]:
        """
        Additional configuration block for Amazon Managed Kafka sources. Incompatible with `self_managed_event_source` and `self_managed_kafka_event_source_config`. See below.
        """
        return pulumi.get(self, "amazon_managed_kafka_event_source_config")

    @amazon_managed_kafka_event_source_config.setter
    def amazon_managed_kafka_event_source_config(self, value: Optional[pulumi.Input['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs']]):
        pulumi.set(self, "amazon_managed_kafka_event_source_config", value)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Largest number of records that Lambda will retrieve from your event source at the time of invocation. Defaults to `100` for DynamoDB, Kinesis, MQ and MSK, `10` for SQS.
        """
        return pulumi.get(self, "batch_size")

    @batch_size.setter
    def batch_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "batch_size", value)

    @property
    @pulumi.getter(name="bisectBatchOnFunctionError")
    def bisect_batch_on_function_error(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to split the batch in two and retry if the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Defaults to `false`.
        """
        return pulumi.get(self, "bisect_batch_on_function_error")

    @bisect_batch_on_function_error.setter
    def bisect_batch_on_function_error(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "bisect_batch_on_function_error", value)

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> Optional[pulumi.Input['EventSourceMappingDestinationConfigArgs']]:
        """
        Amazon SQS queue, Amazon SNS topic or Amazon S3 bucket (only available for Kafka sources) destination for failed records. Only available for stream sources (DynamoDB and Kinesis) and Kafka sources (Amazon MSK and Self-managed Apache Kafka). See below.
        """
        return pulumi.get(self, "destination_config")

    @destination_config.setter
    def destination_config(self, value: Optional[pulumi.Input['EventSourceMappingDestinationConfigArgs']]):
        pulumi.set(self, "destination_config", value)

    @property
    @pulumi.getter(name="documentDbEventSourceConfig")
    def document_db_event_source_config(self) -> Optional[pulumi.Input['EventSourceMappingDocumentDbEventSourceConfigArgs']]:
        """
        Configuration settings for a DocumentDB event source. See below.
        """
        return pulumi.get(self, "document_db_event_source_config")

    @document_db_event_source_config.setter
    def document_db_event_source_config(self, value: Optional[pulumi.Input['EventSourceMappingDocumentDbEventSourceConfigArgs']]):
        pulumi.set(self, "document_db_event_source_config", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the mapping is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="eventSourceArn")
    def event_source_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Event source ARN - required for Kinesis stream, DynamoDB stream, SQS queue, MQ broker, MSK cluster or DocumentDB change stream. Incompatible with Self Managed Kafka source.
        """
        return pulumi.get(self, "event_source_arn")

    @event_source_arn.setter
    def event_source_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_source_arn", value)

    @property
    @pulumi.getter(name="filterCriteria")
    def filter_criteria(self) -> Optional[pulumi.Input['EventSourceMappingFilterCriteriaArgs']]:
        """
        Criteria to use for [event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html) Kinesis stream, DynamoDB stream, SQS queue event sources. See below.
        """
        return pulumi.get(self, "filter_criteria")

    @filter_criteria.setter
    def filter_criteria(self, value: Optional[pulumi.Input['EventSourceMappingFilterCriteriaArgs']]):
        pulumi.set(self, "filter_criteria", value)

    @property
    @pulumi.getter(name="functionResponseTypes")
    def function_response_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of current response type enums applied to the event source mapping for [AWS Lambda checkpointing](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting). Only available for SQS and stream sources (DynamoDB and Kinesis). Valid values: `ReportBatchItemFailures`.
        """
        return pulumi.get(self, "function_response_types")

    @function_response_types.setter
    def function_response_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "function_response_types", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Key Management Service (KMS) customer managed key that Lambda uses to encrypt your function's filter criteria.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum amount of time to gather records before invoking the function, in seconds (between 0 and 300). Records will continue to buffer until either `maximum_batching_window_in_seconds` expires or `batch_size` has been met. For streaming event sources, defaults to as soon as records are available in the stream. Only available for stream sources (DynamoDB and Kinesis) and SQS standard queues.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @maximum_batching_window_in_seconds.setter
    def maximum_batching_window_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "maximum_batching_window_in_seconds", value)

    @property
    @pulumi.getter(name="maximumRecordAgeInSeconds")
    def maximum_record_age_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum age of a record that Lambda sends to a function for processing. Only available for stream sources (DynamoDB and Kinesis). Must be either -1 (forever, and the default value) or between 60 and 604800 (inclusive).
        """
        return pulumi.get(self, "maximum_record_age_in_seconds")

    @maximum_record_age_in_seconds.setter
    def maximum_record_age_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "maximum_record_age_in_seconds", value)

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum number of times to retry when the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of -1 (forever), maximum of 10000.
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @maximum_retry_attempts.setter
    def maximum_retry_attempts(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "maximum_retry_attempts", value)

    @property
    @pulumi.getter(name="metricsConfig")
    def metrics_config(self) -> Optional[pulumi.Input['EventSourceMappingMetricsConfigArgs']]:
        """
        CloudWatch metrics configuration of the event source. Only available for stream sources (DynamoDB and Kinesis) and SQS queues. See below.
        """
        return pulumi.get(self, "metrics_config")

    @metrics_config.setter
    def metrics_config(self, value: Optional[pulumi.Input['EventSourceMappingMetricsConfigArgs']]):
        pulumi.set(self, "metrics_config", value)

    @property
    @pulumi.getter(name="parallelizationFactor")
    def parallelization_factor(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of batches to process from each shard concurrently. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of 1, maximum of 10.
        """
        return pulumi.get(self, "parallelization_factor")

    @parallelization_factor.setter
    def parallelization_factor(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "parallelization_factor", value)

    @property
    @pulumi.getter(name="provisionedPollerConfig")
    def provisioned_poller_config(self) -> Optional[pulumi.Input['EventSourceMappingProvisionedPollerConfigArgs']]:
        """
        Event poller configuration for the event source. Only valid for Amazon MSK or self-managed Apache Kafka sources. See below.
        """
        return pulumi.get(self, "provisioned_poller_config")

    @provisioned_poller_config.setter
    def provisioned_poller_config(self, value: Optional[pulumi.Input['EventSourceMappingProvisionedPollerConfigArgs']]):
        pulumi.set(self, "provisioned_poller_config", value)

    @property
    @pulumi.getter
    def queues(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Amazon MQ broker destination queue to consume. Only available for MQ sources. The list must contain exactly one queue name.
        """
        return pulumi.get(self, "queues")

    @queues.setter
    def queues(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "queues", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> Optional[pulumi.Input['EventSourceMappingScalingConfigArgs']]:
        """
        Scaling configuration of the event source. Only available for SQS queues. See below.
        """
        return pulumi.get(self, "scaling_config")

    @scaling_config.setter
    def scaling_config(self, value: Optional[pulumi.Input['EventSourceMappingScalingConfigArgs']]):
        pulumi.set(self, "scaling_config", value)

    @property
    @pulumi.getter(name="selfManagedEventSource")
    def self_managed_event_source(self) -> Optional[pulumi.Input['EventSourceMappingSelfManagedEventSourceArgs']]:
        """
        For Self Managed Kafka sources, the location of the self managed cluster. If set, configuration must also include `source_access_configuration`. See below.
        """
        return pulumi.get(self, "self_managed_event_source")

    @self_managed_event_source.setter
    def self_managed_event_source(self, value: Optional[pulumi.Input['EventSourceMappingSelfManagedEventSourceArgs']]):
        pulumi.set(self, "self_managed_event_source", value)

    @property
    @pulumi.getter(name="selfManagedKafkaEventSourceConfig")
    def self_managed_kafka_event_source_config(self) -> Optional[pulumi.Input['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs']]:
        """
        Additional configuration block for Self Managed Kafka sources. Incompatible with `event_source_arn` and `amazon_managed_kafka_event_source_config`. See below.
        """
        return pulumi.get(self, "self_managed_kafka_event_source_config")

    @self_managed_kafka_event_source_config.setter
    def self_managed_kafka_event_source_config(self, value: Optional[pulumi.Input['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs']]):
        pulumi.set(self, "self_managed_kafka_event_source_config", value)

    @property
    @pulumi.getter(name="sourceAccessConfigurations")
    def source_access_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingSourceAccessConfigurationArgs']]]]:
        """
        For Self Managed Kafka sources, the access configuration for the source. If set, configuration must also include `self_managed_event_source`. See below.
        """
        return pulumi.get(self, "source_access_configurations")

    @source_access_configurations.setter
    def source_access_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingSourceAccessConfigurationArgs']]]]):
        pulumi.set(self, "source_access_configurations", value)

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Position in the stream where AWS Lambda should start reading. Must be one of `AT_TIMESTAMP` (Kinesis only), `LATEST` or `TRIM_HORIZON` if getting events from Kinesis, DynamoDB, MSK or Self Managed Apache Kafka. Must not be provided if getting events from SQS. More information about these positions can be found in the [AWS DynamoDB Streams API Reference](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator.html) and [AWS Kinesis API Reference](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType).
        """
        return pulumi.get(self, "starting_position")

    @starting_position.setter
    def starting_position(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "starting_position", value)

    @property
    @pulumi.getter(name="startingPositionTimestamp")
    def starting_position_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of the data record which to start reading when using `starting_position` set to `AT_TIMESTAMP`. If a record with this exact timestamp does not exist, the next later record is chosen. If the timestamp is older than the current trim horizon, the oldest available record is chosen.
        """
        return pulumi.get(self, "starting_position_timestamp")

    @starting_position_timestamp.setter
    def starting_position_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "starting_position_timestamp", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Name of the Kafka topics. Only available for MSK sources. A single topic name must be specified.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter(name="tumblingWindowInSeconds")
    def tumbling_window_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Duration in seconds of a processing window for [AWS Lambda streaming analytics](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-windows). The range is between 1 second up to 900 seconds. Only available for stream sources (DynamoDB and Kinesis).
        """
        return pulumi.get(self, "tumbling_window_in_seconds")

    @tumbling_window_in_seconds.setter
    def tumbling_window_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tumbling_window_in_seconds", value)


@pulumi.input_type
class _EventSourceMappingState:
    def __init__(__self__, *,
                 amazon_managed_kafka_event_source_config: Optional[pulumi.Input['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs']] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 batch_size: Optional[pulumi.Input[builtins.int]] = None,
                 bisect_batch_on_function_error: Optional[pulumi.Input[builtins.bool]] = None,
                 destination_config: Optional[pulumi.Input['EventSourceMappingDestinationConfigArgs']] = None,
                 document_db_event_source_config: Optional[pulumi.Input['EventSourceMappingDocumentDbEventSourceConfigArgs']] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 event_source_arn: Optional[pulumi.Input[builtins.str]] = None,
                 filter_criteria: Optional[pulumi.Input['EventSourceMappingFilterCriteriaArgs']] = None,
                 function_arn: Optional[pulumi.Input[builtins.str]] = None,
                 function_name: Optional[pulumi.Input[builtins.str]] = None,
                 function_response_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 last_modified: Optional[pulumi.Input[builtins.str]] = None,
                 last_processing_result: Optional[pulumi.Input[builtins.str]] = None,
                 maximum_batching_window_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 maximum_record_age_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 maximum_retry_attempts: Optional[pulumi.Input[builtins.int]] = None,
                 metrics_config: Optional[pulumi.Input['EventSourceMappingMetricsConfigArgs']] = None,
                 parallelization_factor: Optional[pulumi.Input[builtins.int]] = None,
                 provisioned_poller_config: Optional[pulumi.Input['EventSourceMappingProvisionedPollerConfigArgs']] = None,
                 queues: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scaling_config: Optional[pulumi.Input['EventSourceMappingScalingConfigArgs']] = None,
                 self_managed_event_source: Optional[pulumi.Input['EventSourceMappingSelfManagedEventSourceArgs']] = None,
                 self_managed_kafka_event_source_config: Optional[pulumi.Input['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs']] = None,
                 source_access_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingSourceAccessConfigurationArgs']]]] = None,
                 starting_position: Optional[pulumi.Input[builtins.str]] = None,
                 starting_position_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 state_transition_reason: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tumbling_window_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 uuid: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EventSourceMapping resources.
        :param pulumi.Input['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs'] amazon_managed_kafka_event_source_config: Additional configuration block for Amazon Managed Kafka sources. Incompatible with `self_managed_event_source` and `self_managed_kafka_event_source_config`. See below.
        :param pulumi.Input[builtins.str] arn: Event source mapping ARN.
        :param pulumi.Input[builtins.int] batch_size: Largest number of records that Lambda will retrieve from your event source at the time of invocation. Defaults to `100` for DynamoDB, Kinesis, MQ and MSK, `10` for SQS.
        :param pulumi.Input[builtins.bool] bisect_batch_on_function_error: Whether to split the batch in two and retry if the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Defaults to `false`.
        :param pulumi.Input['EventSourceMappingDestinationConfigArgs'] destination_config: Amazon SQS queue, Amazon SNS topic or Amazon S3 bucket (only available for Kafka sources) destination for failed records. Only available for stream sources (DynamoDB and Kinesis) and Kafka sources (Amazon MSK and Self-managed Apache Kafka). See below.
        :param pulumi.Input['EventSourceMappingDocumentDbEventSourceConfigArgs'] document_db_event_source_config: Configuration settings for a DocumentDB event source. See below.
        :param pulumi.Input[builtins.bool] enabled: Whether the mapping is enabled. Defaults to `true`.
        :param pulumi.Input[builtins.str] event_source_arn: Event source ARN - required for Kinesis stream, DynamoDB stream, SQS queue, MQ broker, MSK cluster or DocumentDB change stream. Incompatible with Self Managed Kafka source.
        :param pulumi.Input['EventSourceMappingFilterCriteriaArgs'] filter_criteria: Criteria to use for [event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html) Kinesis stream, DynamoDB stream, SQS queue event sources. See below.
        :param pulumi.Input[builtins.str] function_arn: ARN of the Lambda function the event source mapping is sending events to. (Note: this is a computed value that differs from `function_name` above.)
        :param pulumi.Input[builtins.str] function_name: Name or ARN of the Lambda function that will be subscribing to events.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] function_response_types: List of current response type enums applied to the event source mapping for [AWS Lambda checkpointing](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting). Only available for SQS and stream sources (DynamoDB and Kinesis). Valid values: `ReportBatchItemFailures`.
        :param pulumi.Input[builtins.str] kms_key_arn: ARN of the Key Management Service (KMS) customer managed key that Lambda uses to encrypt your function's filter criteria.
        :param pulumi.Input[builtins.str] last_modified: Date this resource was last modified.
        :param pulumi.Input[builtins.str] last_processing_result: Result of the last AWS Lambda invocation of your Lambda function.
        :param pulumi.Input[builtins.int] maximum_batching_window_in_seconds: Maximum amount of time to gather records before invoking the function, in seconds (between 0 and 300). Records will continue to buffer until either `maximum_batching_window_in_seconds` expires or `batch_size` has been met. For streaming event sources, defaults to as soon as records are available in the stream. Only available for stream sources (DynamoDB and Kinesis) and SQS standard queues.
        :param pulumi.Input[builtins.int] maximum_record_age_in_seconds: Maximum age of a record that Lambda sends to a function for processing. Only available for stream sources (DynamoDB and Kinesis). Must be either -1 (forever, and the default value) or between 60 and 604800 (inclusive).
        :param pulumi.Input[builtins.int] maximum_retry_attempts: Maximum number of times to retry when the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of -1 (forever), maximum of 10000.
        :param pulumi.Input['EventSourceMappingMetricsConfigArgs'] metrics_config: CloudWatch metrics configuration of the event source. Only available for stream sources (DynamoDB and Kinesis) and SQS queues. See below.
        :param pulumi.Input[builtins.int] parallelization_factor: Number of batches to process from each shard concurrently. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of 1, maximum of 10.
        :param pulumi.Input['EventSourceMappingProvisionedPollerConfigArgs'] provisioned_poller_config: Event poller configuration for the event source. Only valid for Amazon MSK or self-managed Apache Kafka sources. See below.
        :param pulumi.Input[builtins.str] queues: Name of the Amazon MQ broker destination queue to consume. Only available for MQ sources. The list must contain exactly one queue name.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['EventSourceMappingScalingConfigArgs'] scaling_config: Scaling configuration of the event source. Only available for SQS queues. See below.
        :param pulumi.Input['EventSourceMappingSelfManagedEventSourceArgs'] self_managed_event_source: For Self Managed Kafka sources, the location of the self managed cluster. If set, configuration must also include `source_access_configuration`. See below.
        :param pulumi.Input['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs'] self_managed_kafka_event_source_config: Additional configuration block for Self Managed Kafka sources. Incompatible with `event_source_arn` and `amazon_managed_kafka_event_source_config`. See below.
        :param pulumi.Input[Sequence[pulumi.Input['EventSourceMappingSourceAccessConfigurationArgs']]] source_access_configurations: For Self Managed Kafka sources, the access configuration for the source. If set, configuration must also include `self_managed_event_source`. See below.
        :param pulumi.Input[builtins.str] starting_position: Position in the stream where AWS Lambda should start reading. Must be one of `AT_TIMESTAMP` (Kinesis only), `LATEST` or `TRIM_HORIZON` if getting events from Kinesis, DynamoDB, MSK or Self Managed Apache Kafka. Must not be provided if getting events from SQS. More information about these positions can be found in the [AWS DynamoDB Streams API Reference](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator.html) and [AWS Kinesis API Reference](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType).
        :param pulumi.Input[builtins.str] starting_position_timestamp: Timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of the data record which to start reading when using `starting_position` set to `AT_TIMESTAMP`. If a record with this exact timestamp does not exist, the next later record is chosen. If the timestamp is older than the current trim horizon, the oldest available record is chosen.
        :param pulumi.Input[builtins.str] state: State of the event source mapping.
        :param pulumi.Input[builtins.str] state_transition_reason: Reason the event source mapping is in its current state.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] topics: Name of the Kafka topics. Only available for MSK sources. A single topic name must be specified.
        :param pulumi.Input[builtins.int] tumbling_window_in_seconds: Duration in seconds of a processing window for [AWS Lambda streaming analytics](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-windows). The range is between 1 second up to 900 seconds. Only available for stream sources (DynamoDB and Kinesis).
        :param pulumi.Input[builtins.str] uuid: UUID of the created event source mapping.
        """
        if amazon_managed_kafka_event_source_config is not None:
            pulumi.set(__self__, "amazon_managed_kafka_event_source_config", amazon_managed_kafka_event_source_config)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if bisect_batch_on_function_error is not None:
            pulumi.set(__self__, "bisect_batch_on_function_error", bisect_batch_on_function_error)
        if destination_config is not None:
            pulumi.set(__self__, "destination_config", destination_config)
        if document_db_event_source_config is not None:
            pulumi.set(__self__, "document_db_event_source_config", document_db_event_source_config)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if event_source_arn is not None:
            pulumi.set(__self__, "event_source_arn", event_source_arn)
        if filter_criteria is not None:
            pulumi.set(__self__, "filter_criteria", filter_criteria)
        if function_arn is not None:
            pulumi.set(__self__, "function_arn", function_arn)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if function_response_types is not None:
            pulumi.set(__self__, "function_response_types", function_response_types)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if last_modified is not None:
            pulumi.set(__self__, "last_modified", last_modified)
        if last_processing_result is not None:
            pulumi.set(__self__, "last_processing_result", last_processing_result)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)
        if maximum_record_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_record_age_in_seconds", maximum_record_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)
        if metrics_config is not None:
            pulumi.set(__self__, "metrics_config", metrics_config)
        if parallelization_factor is not None:
            pulumi.set(__self__, "parallelization_factor", parallelization_factor)
        if provisioned_poller_config is not None:
            pulumi.set(__self__, "provisioned_poller_config", provisioned_poller_config)
        if queues is not None:
            pulumi.set(__self__, "queues", queues)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scaling_config is not None:
            pulumi.set(__self__, "scaling_config", scaling_config)
        if self_managed_event_source is not None:
            pulumi.set(__self__, "self_managed_event_source", self_managed_event_source)
        if self_managed_kafka_event_source_config is not None:
            pulumi.set(__self__, "self_managed_kafka_event_source_config", self_managed_kafka_event_source_config)
        if source_access_configurations is not None:
            pulumi.set(__self__, "source_access_configurations", source_access_configurations)
        if starting_position is not None:
            pulumi.set(__self__, "starting_position", starting_position)
        if starting_position_timestamp is not None:
            pulumi.set(__self__, "starting_position_timestamp", starting_position_timestamp)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_transition_reason is not None:
            pulumi.set(__self__, "state_transition_reason", state_transition_reason)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if tumbling_window_in_seconds is not None:
            pulumi.set(__self__, "tumbling_window_in_seconds", tumbling_window_in_seconds)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="amazonManagedKafkaEventSourceConfig")
    def amazon_managed_kafka_event_source_config(self) -> Optional[pulumi.Input['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs']]:
        """
        Additional configuration block for Amazon Managed Kafka sources. Incompatible with `self_managed_event_source` and `self_managed_kafka_event_source_config`. See below.
        """
        return pulumi.get(self, "amazon_managed_kafka_event_source_config")

    @amazon_managed_kafka_event_source_config.setter
    def amazon_managed_kafka_event_source_config(self, value: Optional[pulumi.Input['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs']]):
        pulumi.set(self, "amazon_managed_kafka_event_source_config", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Event source mapping ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Largest number of records that Lambda will retrieve from your event source at the time of invocation. Defaults to `100` for DynamoDB, Kinesis, MQ and MSK, `10` for SQS.
        """
        return pulumi.get(self, "batch_size")

    @batch_size.setter
    def batch_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "batch_size", value)

    @property
    @pulumi.getter(name="bisectBatchOnFunctionError")
    def bisect_batch_on_function_error(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to split the batch in two and retry if the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Defaults to `false`.
        """
        return pulumi.get(self, "bisect_batch_on_function_error")

    @bisect_batch_on_function_error.setter
    def bisect_batch_on_function_error(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "bisect_batch_on_function_error", value)

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> Optional[pulumi.Input['EventSourceMappingDestinationConfigArgs']]:
        """
        Amazon SQS queue, Amazon SNS topic or Amazon S3 bucket (only available for Kafka sources) destination for failed records. Only available for stream sources (DynamoDB and Kinesis) and Kafka sources (Amazon MSK and Self-managed Apache Kafka). See below.
        """
        return pulumi.get(self, "destination_config")

    @destination_config.setter
    def destination_config(self, value: Optional[pulumi.Input['EventSourceMappingDestinationConfigArgs']]):
        pulumi.set(self, "destination_config", value)

    @property
    @pulumi.getter(name="documentDbEventSourceConfig")
    def document_db_event_source_config(self) -> Optional[pulumi.Input['EventSourceMappingDocumentDbEventSourceConfigArgs']]:
        """
        Configuration settings for a DocumentDB event source. See below.
        """
        return pulumi.get(self, "document_db_event_source_config")

    @document_db_event_source_config.setter
    def document_db_event_source_config(self, value: Optional[pulumi.Input['EventSourceMappingDocumentDbEventSourceConfigArgs']]):
        pulumi.set(self, "document_db_event_source_config", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the mapping is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="eventSourceArn")
    def event_source_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Event source ARN - required for Kinesis stream, DynamoDB stream, SQS queue, MQ broker, MSK cluster or DocumentDB change stream. Incompatible with Self Managed Kafka source.
        """
        return pulumi.get(self, "event_source_arn")

    @event_source_arn.setter
    def event_source_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_source_arn", value)

    @property
    @pulumi.getter(name="filterCriteria")
    def filter_criteria(self) -> Optional[pulumi.Input['EventSourceMappingFilterCriteriaArgs']]:
        """
        Criteria to use for [event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html) Kinesis stream, DynamoDB stream, SQS queue event sources. See below.
        """
        return pulumi.get(self, "filter_criteria")

    @filter_criteria.setter
    def filter_criteria(self, value: Optional[pulumi.Input['EventSourceMappingFilterCriteriaArgs']]):
        pulumi.set(self, "filter_criteria", value)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Lambda function the event source mapping is sending events to. (Note: this is a computed value that differs from `function_name` above.)
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "function_arn", value)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name or ARN of the Lambda function that will be subscribing to events.

        The following arguments are optional:
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter(name="functionResponseTypes")
    def function_response_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of current response type enums applied to the event source mapping for [AWS Lambda checkpointing](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting). Only available for SQS and stream sources (DynamoDB and Kinesis). Valid values: `ReportBatchItemFailures`.
        """
        return pulumi.get(self, "function_response_types")

    @function_response_types.setter
    def function_response_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "function_response_types", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Key Management Service (KMS) customer managed key that Lambda uses to encrypt your function's filter criteria.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date this resource was last modified.
        """
        return pulumi.get(self, "last_modified")

    @last_modified.setter
    def last_modified(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_modified", value)

    @property
    @pulumi.getter(name="lastProcessingResult")
    def last_processing_result(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Result of the last AWS Lambda invocation of your Lambda function.
        """
        return pulumi.get(self, "last_processing_result")

    @last_processing_result.setter
    def last_processing_result(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_processing_result", value)

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum amount of time to gather records before invoking the function, in seconds (between 0 and 300). Records will continue to buffer until either `maximum_batching_window_in_seconds` expires or `batch_size` has been met. For streaming event sources, defaults to as soon as records are available in the stream. Only available for stream sources (DynamoDB and Kinesis) and SQS standard queues.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @maximum_batching_window_in_seconds.setter
    def maximum_batching_window_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "maximum_batching_window_in_seconds", value)

    @property
    @pulumi.getter(name="maximumRecordAgeInSeconds")
    def maximum_record_age_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum age of a record that Lambda sends to a function for processing. Only available for stream sources (DynamoDB and Kinesis). Must be either -1 (forever, and the default value) or between 60 and 604800 (inclusive).
        """
        return pulumi.get(self, "maximum_record_age_in_seconds")

    @maximum_record_age_in_seconds.setter
    def maximum_record_age_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "maximum_record_age_in_seconds", value)

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum number of times to retry when the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of -1 (forever), maximum of 10000.
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @maximum_retry_attempts.setter
    def maximum_retry_attempts(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "maximum_retry_attempts", value)

    @property
    @pulumi.getter(name="metricsConfig")
    def metrics_config(self) -> Optional[pulumi.Input['EventSourceMappingMetricsConfigArgs']]:
        """
        CloudWatch metrics configuration of the event source. Only available for stream sources (DynamoDB and Kinesis) and SQS queues. See below.
        """
        return pulumi.get(self, "metrics_config")

    @metrics_config.setter
    def metrics_config(self, value: Optional[pulumi.Input['EventSourceMappingMetricsConfigArgs']]):
        pulumi.set(self, "metrics_config", value)

    @property
    @pulumi.getter(name="parallelizationFactor")
    def parallelization_factor(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of batches to process from each shard concurrently. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of 1, maximum of 10.
        """
        return pulumi.get(self, "parallelization_factor")

    @parallelization_factor.setter
    def parallelization_factor(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "parallelization_factor", value)

    @property
    @pulumi.getter(name="provisionedPollerConfig")
    def provisioned_poller_config(self) -> Optional[pulumi.Input['EventSourceMappingProvisionedPollerConfigArgs']]:
        """
        Event poller configuration for the event source. Only valid for Amazon MSK or self-managed Apache Kafka sources. See below.
        """
        return pulumi.get(self, "provisioned_poller_config")

    @provisioned_poller_config.setter
    def provisioned_poller_config(self, value: Optional[pulumi.Input['EventSourceMappingProvisionedPollerConfigArgs']]):
        pulumi.set(self, "provisioned_poller_config", value)

    @property
    @pulumi.getter
    def queues(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Amazon MQ broker destination queue to consume. Only available for MQ sources. The list must contain exactly one queue name.
        """
        return pulumi.get(self, "queues")

    @queues.setter
    def queues(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "queues", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> Optional[pulumi.Input['EventSourceMappingScalingConfigArgs']]:
        """
        Scaling configuration of the event source. Only available for SQS queues. See below.
        """
        return pulumi.get(self, "scaling_config")

    @scaling_config.setter
    def scaling_config(self, value: Optional[pulumi.Input['EventSourceMappingScalingConfigArgs']]):
        pulumi.set(self, "scaling_config", value)

    @property
    @pulumi.getter(name="selfManagedEventSource")
    def self_managed_event_source(self) -> Optional[pulumi.Input['EventSourceMappingSelfManagedEventSourceArgs']]:
        """
        For Self Managed Kafka sources, the location of the self managed cluster. If set, configuration must also include `source_access_configuration`. See below.
        """
        return pulumi.get(self, "self_managed_event_source")

    @self_managed_event_source.setter
    def self_managed_event_source(self, value: Optional[pulumi.Input['EventSourceMappingSelfManagedEventSourceArgs']]):
        pulumi.set(self, "self_managed_event_source", value)

    @property
    @pulumi.getter(name="selfManagedKafkaEventSourceConfig")
    def self_managed_kafka_event_source_config(self) -> Optional[pulumi.Input['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs']]:
        """
        Additional configuration block for Self Managed Kafka sources. Incompatible with `event_source_arn` and `amazon_managed_kafka_event_source_config`. See below.
        """
        return pulumi.get(self, "self_managed_kafka_event_source_config")

    @self_managed_kafka_event_source_config.setter
    def self_managed_kafka_event_source_config(self, value: Optional[pulumi.Input['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs']]):
        pulumi.set(self, "self_managed_kafka_event_source_config", value)

    @property
    @pulumi.getter(name="sourceAccessConfigurations")
    def source_access_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingSourceAccessConfigurationArgs']]]]:
        """
        For Self Managed Kafka sources, the access configuration for the source. If set, configuration must also include `self_managed_event_source`. See below.
        """
        return pulumi.get(self, "source_access_configurations")

    @source_access_configurations.setter
    def source_access_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventSourceMappingSourceAccessConfigurationArgs']]]]):
        pulumi.set(self, "source_access_configurations", value)

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Position in the stream where AWS Lambda should start reading. Must be one of `AT_TIMESTAMP` (Kinesis only), `LATEST` or `TRIM_HORIZON` if getting events from Kinesis, DynamoDB, MSK or Self Managed Apache Kafka. Must not be provided if getting events from SQS. More information about these positions can be found in the [AWS DynamoDB Streams API Reference](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator.html) and [AWS Kinesis API Reference](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType).
        """
        return pulumi.get(self, "starting_position")

    @starting_position.setter
    def starting_position(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "starting_position", value)

    @property
    @pulumi.getter(name="startingPositionTimestamp")
    def starting_position_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of the data record which to start reading when using `starting_position` set to `AT_TIMESTAMP`. If a record with this exact timestamp does not exist, the next later record is chosen. If the timestamp is older than the current trim horizon, the oldest available record is chosen.
        """
        return pulumi.get(self, "starting_position_timestamp")

    @starting_position_timestamp.setter
    def starting_position_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "starting_position_timestamp", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        State of the event source mapping.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateTransitionReason")
    def state_transition_reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reason the event source mapping is in its current state.
        """
        return pulumi.get(self, "state_transition_reason")

    @state_transition_reason.setter
    def state_transition_reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state_transition_reason", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Name of the Kafka topics. Only available for MSK sources. A single topic name must be specified.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter(name="tumblingWindowInSeconds")
    def tumbling_window_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Duration in seconds of a processing window for [AWS Lambda streaming analytics](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-windows). The range is between 1 second up to 900 seconds. Only available for stream sources (DynamoDB and Kinesis).
        """
        return pulumi.get(self, "tumbling_window_in_seconds")

    @tumbling_window_in_seconds.setter
    def tumbling_window_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tumbling_window_in_seconds", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UUID of the created event source mapping.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uuid", value)


@pulumi.type_token("aws:lambda/eventSourceMapping:EventSourceMapping")
class EventSourceMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amazon_managed_kafka_event_source_config: Optional[pulumi.Input[Union['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs', 'EventSourceMappingAmazonManagedKafkaEventSourceConfigArgsDict']]] = None,
                 batch_size: Optional[pulumi.Input[builtins.int]] = None,
                 bisect_batch_on_function_error: Optional[pulumi.Input[builtins.bool]] = None,
                 destination_config: Optional[pulumi.Input[Union['EventSourceMappingDestinationConfigArgs', 'EventSourceMappingDestinationConfigArgsDict']]] = None,
                 document_db_event_source_config: Optional[pulumi.Input[Union['EventSourceMappingDocumentDbEventSourceConfigArgs', 'EventSourceMappingDocumentDbEventSourceConfigArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 event_source_arn: Optional[pulumi.Input[builtins.str]] = None,
                 filter_criteria: Optional[pulumi.Input[Union['EventSourceMappingFilterCriteriaArgs', 'EventSourceMappingFilterCriteriaArgsDict']]] = None,
                 function_name: Optional[pulumi.Input[builtins.str]] = None,
                 function_response_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 maximum_batching_window_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 maximum_record_age_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 maximum_retry_attempts: Optional[pulumi.Input[builtins.int]] = None,
                 metrics_config: Optional[pulumi.Input[Union['EventSourceMappingMetricsConfigArgs', 'EventSourceMappingMetricsConfigArgsDict']]] = None,
                 parallelization_factor: Optional[pulumi.Input[builtins.int]] = None,
                 provisioned_poller_config: Optional[pulumi.Input[Union['EventSourceMappingProvisionedPollerConfigArgs', 'EventSourceMappingProvisionedPollerConfigArgsDict']]] = None,
                 queues: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scaling_config: Optional[pulumi.Input[Union['EventSourceMappingScalingConfigArgs', 'EventSourceMappingScalingConfigArgsDict']]] = None,
                 self_managed_event_source: Optional[pulumi.Input[Union['EventSourceMappingSelfManagedEventSourceArgs', 'EventSourceMappingSelfManagedEventSourceArgsDict']]] = None,
                 self_managed_kafka_event_source_config: Optional[pulumi.Input[Union['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs', 'EventSourceMappingSelfManagedKafkaEventSourceConfigArgsDict']]] = None,
                 source_access_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventSourceMappingSourceAccessConfigurationArgs', 'EventSourceMappingSourceAccessConfigurationArgsDict']]]]] = None,
                 starting_position: Optional[pulumi.Input[builtins.str]] = None,
                 starting_position_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tumbling_window_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Manages an AWS Lambda Event Source Mapping. Use this resource to connect Lambda functions to event sources like Kinesis, DynamoDB, SQS, Amazon MQ, and Managed Streaming for Apache Kafka (MSK).

        For information about Lambda and how to use it, see [What is AWS Lambda?](http://docs.aws.amazon.com/lambda/latest/dg/welcome.html). For information about event source mappings, see [CreateEventSourceMapping](http://docs.aws.amazon.com/lambda/latest/dg/API_CreateEventSourceMapping.html) in the API docs.

        ## Example Usage

        ### DynamoDB Stream

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            event_source_arn=example_aws_dynamodb_table["streamArn"],
            function_name=example_aws_lambda_function["arn"],
            starting_position="LATEST",
            tags={
                "Name": "dynamodb-stream-mapping",
            })
        ```

        ### Kinesis Stream

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            event_source_arn=example_aws_kinesis_stream["arn"],
            function_name=example_aws_lambda_function["arn"],
            starting_position="LATEST",
            batch_size=100,
            maximum_batching_window_in_seconds=5,
            parallelization_factor=2,
            destination_config={
                "on_failure": {
                    "destination_arn": dlq["arn"],
                },
            })
        ```

        ### SQS Queue

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            event_source_arn=example_aws_sqs_queue["arn"],
            function_name=example_aws_lambda_function["arn"],
            batch_size=10,
            scaling_config={
                "maximum_concurrency": 100,
            })
        ```

        ### SQS with Event Filtering

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            event_source_arn=example_aws_sqs_queue["arn"],
            function_name=example_aws_lambda_function["arn"],
            filter_criteria={
                "filters": [{
                    "pattern": json.dumps({
                        "body": {
                            "Temperature": [{
                                "numeric": [
                                    ">",
                                    0,
                                    "<=",
                                    100,
                                ],
                            }],
                            "Location": ["New York"],
                        },
                    }),
                }],
            })
        ```

        ### Amazon MSK

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            event_source_arn=example_aws_msk_cluster["arn"],
            function_name=example_aws_lambda_function["arn"],
            topics=[
                "orders",
                "inventory",
            ],
            starting_position="TRIM_HORIZON",
            batch_size=100,
            amazon_managed_kafka_event_source_config={
                "consumer_group_id": "lambda-consumer-group",
            })
        ```

        ### Self-Managed Apache Kafka

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            function_name=example_aws_lambda_function["arn"],
            topics=["orders"],
            starting_position="TRIM_HORIZON",
            self_managed_event_source={
                "endpoints": {
                    "KAFKA_BOOTSTRAP_SERVERS": "kafka1.example.com:9092,kafka2.example.com:9092",
                },
            },
            self_managed_kafka_event_source_config={
                "consumer_group_id": "lambda-consumer-group",
            },
            source_access_configurations=[
                {
                    "type": "VPC_SUBNET",
                    "uri": f"subnet:{example1['id']}",
                },
                {
                    "type": "VPC_SUBNET",
                    "uri": f"subnet:{example2['id']}",
                },
                {
                    "type": "VPC_SECURITY_GROUP",
                    "uri": f"security_group:{example_aws_security_group['id']}",
                },
            ],
            provisioned_poller_config={
                "maximum_pollers": 100,
                "minimum_pollers": 10,
            })
        ```

        ### Amazon MQ (ActiveMQ)

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            event_source_arn=example_aws_mq_broker["arn"],
            function_name=example_aws_lambda_function["arn"],
            queues="orders",
            batch_size=10,
            source_access_configurations=[{
                "type": "BASIC_AUTH",
                "uri": example_aws_secretsmanager_secret_version["arn"],
            }])
        ```

        ### Amazon MQ (RabbitMQ)

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            event_source_arn=example_aws_mq_broker["arn"],
            function_name=example_aws_lambda_function["arn"],
            queues="orders",
            batch_size=1,
            source_access_configurations=[
                {
                    "type": "VIRTUAL_HOST",
                    "uri": "/production",
                },
                {
                    "type": "BASIC_AUTH",
                    "uri": example_aws_secretsmanager_secret_version["arn"],
                },
            ])
        ```

        ### DocumentDB Change Stream

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            event_source_arn=example_aws_docdb_cluster["arn"],
            function_name=example_aws_lambda_function["arn"],
            starting_position="LATEST",
            document_db_event_source_config={
                "database_name": "orders",
                "collection_name": "transactions",
                "full_document": "UpdateLookup",
            },
            source_access_configurations=[{
                "type": "BASIC_AUTH",
                "uri": example_aws_secretsmanager_secret_version["arn"],
            }])
        ```

        ## Import

        Using `pulumi import`, import Lambda event source mappings using the `UUID` (event source mapping identifier). For example:

        ```sh
        $ pulumi import aws:lambda/eventSourceMapping:EventSourceMapping example 12345kxodurf3443
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs', 'EventSourceMappingAmazonManagedKafkaEventSourceConfigArgsDict']] amazon_managed_kafka_event_source_config: Additional configuration block for Amazon Managed Kafka sources. Incompatible with `self_managed_event_source` and `self_managed_kafka_event_source_config`. See below.
        :param pulumi.Input[builtins.int] batch_size: Largest number of records that Lambda will retrieve from your event source at the time of invocation. Defaults to `100` for DynamoDB, Kinesis, MQ and MSK, `10` for SQS.
        :param pulumi.Input[builtins.bool] bisect_batch_on_function_error: Whether to split the batch in two and retry if the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Defaults to `false`.
        :param pulumi.Input[Union['EventSourceMappingDestinationConfigArgs', 'EventSourceMappingDestinationConfigArgsDict']] destination_config: Amazon SQS queue, Amazon SNS topic or Amazon S3 bucket (only available for Kafka sources) destination for failed records. Only available for stream sources (DynamoDB and Kinesis) and Kafka sources (Amazon MSK and Self-managed Apache Kafka). See below.
        :param pulumi.Input[Union['EventSourceMappingDocumentDbEventSourceConfigArgs', 'EventSourceMappingDocumentDbEventSourceConfigArgsDict']] document_db_event_source_config: Configuration settings for a DocumentDB event source. See below.
        :param pulumi.Input[builtins.bool] enabled: Whether the mapping is enabled. Defaults to `true`.
        :param pulumi.Input[builtins.str] event_source_arn: Event source ARN - required for Kinesis stream, DynamoDB stream, SQS queue, MQ broker, MSK cluster or DocumentDB change stream. Incompatible with Self Managed Kafka source.
        :param pulumi.Input[Union['EventSourceMappingFilterCriteriaArgs', 'EventSourceMappingFilterCriteriaArgsDict']] filter_criteria: Criteria to use for [event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html) Kinesis stream, DynamoDB stream, SQS queue event sources. See below.
        :param pulumi.Input[builtins.str] function_name: Name or ARN of the Lambda function that will be subscribing to events.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] function_response_types: List of current response type enums applied to the event source mapping for [AWS Lambda checkpointing](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting). Only available for SQS and stream sources (DynamoDB and Kinesis). Valid values: `ReportBatchItemFailures`.
        :param pulumi.Input[builtins.str] kms_key_arn: ARN of the Key Management Service (KMS) customer managed key that Lambda uses to encrypt your function's filter criteria.
        :param pulumi.Input[builtins.int] maximum_batching_window_in_seconds: Maximum amount of time to gather records before invoking the function, in seconds (between 0 and 300). Records will continue to buffer until either `maximum_batching_window_in_seconds` expires or `batch_size` has been met. For streaming event sources, defaults to as soon as records are available in the stream. Only available for stream sources (DynamoDB and Kinesis) and SQS standard queues.
        :param pulumi.Input[builtins.int] maximum_record_age_in_seconds: Maximum age of a record that Lambda sends to a function for processing. Only available for stream sources (DynamoDB and Kinesis). Must be either -1 (forever, and the default value) or between 60 and 604800 (inclusive).
        :param pulumi.Input[builtins.int] maximum_retry_attempts: Maximum number of times to retry when the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of -1 (forever), maximum of 10000.
        :param pulumi.Input[Union['EventSourceMappingMetricsConfigArgs', 'EventSourceMappingMetricsConfigArgsDict']] metrics_config: CloudWatch metrics configuration of the event source. Only available for stream sources (DynamoDB and Kinesis) and SQS queues. See below.
        :param pulumi.Input[builtins.int] parallelization_factor: Number of batches to process from each shard concurrently. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of 1, maximum of 10.
        :param pulumi.Input[Union['EventSourceMappingProvisionedPollerConfigArgs', 'EventSourceMappingProvisionedPollerConfigArgsDict']] provisioned_poller_config: Event poller configuration for the event source. Only valid for Amazon MSK or self-managed Apache Kafka sources. See below.
        :param pulumi.Input[builtins.str] queues: Name of the Amazon MQ broker destination queue to consume. Only available for MQ sources. The list must contain exactly one queue name.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['EventSourceMappingScalingConfigArgs', 'EventSourceMappingScalingConfigArgsDict']] scaling_config: Scaling configuration of the event source. Only available for SQS queues. See below.
        :param pulumi.Input[Union['EventSourceMappingSelfManagedEventSourceArgs', 'EventSourceMappingSelfManagedEventSourceArgsDict']] self_managed_event_source: For Self Managed Kafka sources, the location of the self managed cluster. If set, configuration must also include `source_access_configuration`. See below.
        :param pulumi.Input[Union['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs', 'EventSourceMappingSelfManagedKafkaEventSourceConfigArgsDict']] self_managed_kafka_event_source_config: Additional configuration block for Self Managed Kafka sources. Incompatible with `event_source_arn` and `amazon_managed_kafka_event_source_config`. See below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EventSourceMappingSourceAccessConfigurationArgs', 'EventSourceMappingSourceAccessConfigurationArgsDict']]]] source_access_configurations: For Self Managed Kafka sources, the access configuration for the source. If set, configuration must also include `self_managed_event_source`. See below.
        :param pulumi.Input[builtins.str] starting_position: Position in the stream where AWS Lambda should start reading. Must be one of `AT_TIMESTAMP` (Kinesis only), `LATEST` or `TRIM_HORIZON` if getting events from Kinesis, DynamoDB, MSK or Self Managed Apache Kafka. Must not be provided if getting events from SQS. More information about these positions can be found in the [AWS DynamoDB Streams API Reference](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator.html) and [AWS Kinesis API Reference](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType).
        :param pulumi.Input[builtins.str] starting_position_timestamp: Timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of the data record which to start reading when using `starting_position` set to `AT_TIMESTAMP`. If a record with this exact timestamp does not exist, the next later record is chosen. If the timestamp is older than the current trim horizon, the oldest available record is chosen.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] topics: Name of the Kafka topics. Only available for MSK sources. A single topic name must be specified.
        :param pulumi.Input[builtins.int] tumbling_window_in_seconds: Duration in seconds of a processing window for [AWS Lambda streaming analytics](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-windows). The range is between 1 second up to 900 seconds. Only available for stream sources (DynamoDB and Kinesis).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventSourceMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Lambda Event Source Mapping. Use this resource to connect Lambda functions to event sources like Kinesis, DynamoDB, SQS, Amazon MQ, and Managed Streaming for Apache Kafka (MSK).

        For information about Lambda and how to use it, see [What is AWS Lambda?](http://docs.aws.amazon.com/lambda/latest/dg/welcome.html). For information about event source mappings, see [CreateEventSourceMapping](http://docs.aws.amazon.com/lambda/latest/dg/API_CreateEventSourceMapping.html) in the API docs.

        ## Example Usage

        ### DynamoDB Stream

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            event_source_arn=example_aws_dynamodb_table["streamArn"],
            function_name=example_aws_lambda_function["arn"],
            starting_position="LATEST",
            tags={
                "Name": "dynamodb-stream-mapping",
            })
        ```

        ### Kinesis Stream

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            event_source_arn=example_aws_kinesis_stream["arn"],
            function_name=example_aws_lambda_function["arn"],
            starting_position="LATEST",
            batch_size=100,
            maximum_batching_window_in_seconds=5,
            parallelization_factor=2,
            destination_config={
                "on_failure": {
                    "destination_arn": dlq["arn"],
                },
            })
        ```

        ### SQS Queue

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            event_source_arn=example_aws_sqs_queue["arn"],
            function_name=example_aws_lambda_function["arn"],
            batch_size=10,
            scaling_config={
                "maximum_concurrency": 100,
            })
        ```

        ### SQS with Event Filtering

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            event_source_arn=example_aws_sqs_queue["arn"],
            function_name=example_aws_lambda_function["arn"],
            filter_criteria={
                "filters": [{
                    "pattern": json.dumps({
                        "body": {
                            "Temperature": [{
                                "numeric": [
                                    ">",
                                    0,
                                    "<=",
                                    100,
                                ],
                            }],
                            "Location": ["New York"],
                        },
                    }),
                }],
            })
        ```

        ### Amazon MSK

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            event_source_arn=example_aws_msk_cluster["arn"],
            function_name=example_aws_lambda_function["arn"],
            topics=[
                "orders",
                "inventory",
            ],
            starting_position="TRIM_HORIZON",
            batch_size=100,
            amazon_managed_kafka_event_source_config={
                "consumer_group_id": "lambda-consumer-group",
            })
        ```

        ### Self-Managed Apache Kafka

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            function_name=example_aws_lambda_function["arn"],
            topics=["orders"],
            starting_position="TRIM_HORIZON",
            self_managed_event_source={
                "endpoints": {
                    "KAFKA_BOOTSTRAP_SERVERS": "kafka1.example.com:9092,kafka2.example.com:9092",
                },
            },
            self_managed_kafka_event_source_config={
                "consumer_group_id": "lambda-consumer-group",
            },
            source_access_configurations=[
                {
                    "type": "VPC_SUBNET",
                    "uri": f"subnet:{example1['id']}",
                },
                {
                    "type": "VPC_SUBNET",
                    "uri": f"subnet:{example2['id']}",
                },
                {
                    "type": "VPC_SECURITY_GROUP",
                    "uri": f"security_group:{example_aws_security_group['id']}",
                },
            ],
            provisioned_poller_config={
                "maximum_pollers": 100,
                "minimum_pollers": 10,
            })
        ```

        ### Amazon MQ (ActiveMQ)

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            event_source_arn=example_aws_mq_broker["arn"],
            function_name=example_aws_lambda_function["arn"],
            queues="orders",
            batch_size=10,
            source_access_configurations=[{
                "type": "BASIC_AUTH",
                "uri": example_aws_secretsmanager_secret_version["arn"],
            }])
        ```

        ### Amazon MQ (RabbitMQ)

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            event_source_arn=example_aws_mq_broker["arn"],
            function_name=example_aws_lambda_function["arn"],
            queues="orders",
            batch_size=1,
            source_access_configurations=[
                {
                    "type": "VIRTUAL_HOST",
                    "uri": "/production",
                },
                {
                    "type": "BASIC_AUTH",
                    "uri": example_aws_secretsmanager_secret_version["arn"],
                },
            ])
        ```

        ### DocumentDB Change Stream

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.EventSourceMapping("example",
            event_source_arn=example_aws_docdb_cluster["arn"],
            function_name=example_aws_lambda_function["arn"],
            starting_position="LATEST",
            document_db_event_source_config={
                "database_name": "orders",
                "collection_name": "transactions",
                "full_document": "UpdateLookup",
            },
            source_access_configurations=[{
                "type": "BASIC_AUTH",
                "uri": example_aws_secretsmanager_secret_version["arn"],
            }])
        ```

        ## Import

        Using `pulumi import`, import Lambda event source mappings using the `UUID` (event source mapping identifier). For example:

        ```sh
        $ pulumi import aws:lambda/eventSourceMapping:EventSourceMapping example 12345kxodurf3443
        ```

        :param str resource_name: The name of the resource.
        :param EventSourceMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventSourceMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amazon_managed_kafka_event_source_config: Optional[pulumi.Input[Union['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs', 'EventSourceMappingAmazonManagedKafkaEventSourceConfigArgsDict']]] = None,
                 batch_size: Optional[pulumi.Input[builtins.int]] = None,
                 bisect_batch_on_function_error: Optional[pulumi.Input[builtins.bool]] = None,
                 destination_config: Optional[pulumi.Input[Union['EventSourceMappingDestinationConfigArgs', 'EventSourceMappingDestinationConfigArgsDict']]] = None,
                 document_db_event_source_config: Optional[pulumi.Input[Union['EventSourceMappingDocumentDbEventSourceConfigArgs', 'EventSourceMappingDocumentDbEventSourceConfigArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 event_source_arn: Optional[pulumi.Input[builtins.str]] = None,
                 filter_criteria: Optional[pulumi.Input[Union['EventSourceMappingFilterCriteriaArgs', 'EventSourceMappingFilterCriteriaArgsDict']]] = None,
                 function_name: Optional[pulumi.Input[builtins.str]] = None,
                 function_response_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 maximum_batching_window_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 maximum_record_age_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 maximum_retry_attempts: Optional[pulumi.Input[builtins.int]] = None,
                 metrics_config: Optional[pulumi.Input[Union['EventSourceMappingMetricsConfigArgs', 'EventSourceMappingMetricsConfigArgsDict']]] = None,
                 parallelization_factor: Optional[pulumi.Input[builtins.int]] = None,
                 provisioned_poller_config: Optional[pulumi.Input[Union['EventSourceMappingProvisionedPollerConfigArgs', 'EventSourceMappingProvisionedPollerConfigArgsDict']]] = None,
                 queues: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scaling_config: Optional[pulumi.Input[Union['EventSourceMappingScalingConfigArgs', 'EventSourceMappingScalingConfigArgsDict']]] = None,
                 self_managed_event_source: Optional[pulumi.Input[Union['EventSourceMappingSelfManagedEventSourceArgs', 'EventSourceMappingSelfManagedEventSourceArgsDict']]] = None,
                 self_managed_kafka_event_source_config: Optional[pulumi.Input[Union['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs', 'EventSourceMappingSelfManagedKafkaEventSourceConfigArgsDict']]] = None,
                 source_access_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventSourceMappingSourceAccessConfigurationArgs', 'EventSourceMappingSourceAccessConfigurationArgsDict']]]]] = None,
                 starting_position: Optional[pulumi.Input[builtins.str]] = None,
                 starting_position_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tumbling_window_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventSourceMappingArgs.__new__(EventSourceMappingArgs)

            __props__.__dict__["amazon_managed_kafka_event_source_config"] = amazon_managed_kafka_event_source_config
            __props__.__dict__["batch_size"] = batch_size
            __props__.__dict__["bisect_batch_on_function_error"] = bisect_batch_on_function_error
            __props__.__dict__["destination_config"] = destination_config
            __props__.__dict__["document_db_event_source_config"] = document_db_event_source_config
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["event_source_arn"] = event_source_arn
            __props__.__dict__["filter_criteria"] = filter_criteria
            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            __props__.__dict__["function_response_types"] = function_response_types
            __props__.__dict__["kms_key_arn"] = kms_key_arn
            __props__.__dict__["maximum_batching_window_in_seconds"] = maximum_batching_window_in_seconds
            __props__.__dict__["maximum_record_age_in_seconds"] = maximum_record_age_in_seconds
            __props__.__dict__["maximum_retry_attempts"] = maximum_retry_attempts
            __props__.__dict__["metrics_config"] = metrics_config
            __props__.__dict__["parallelization_factor"] = parallelization_factor
            __props__.__dict__["provisioned_poller_config"] = provisioned_poller_config
            __props__.__dict__["queues"] = queues
            __props__.__dict__["region"] = region
            __props__.__dict__["scaling_config"] = scaling_config
            __props__.__dict__["self_managed_event_source"] = self_managed_event_source
            __props__.__dict__["self_managed_kafka_event_source_config"] = self_managed_kafka_event_source_config
            __props__.__dict__["source_access_configurations"] = source_access_configurations
            __props__.__dict__["starting_position"] = starting_position
            __props__.__dict__["starting_position_timestamp"] = starting_position_timestamp
            __props__.__dict__["tags"] = tags
            __props__.__dict__["topics"] = topics
            __props__.__dict__["tumbling_window_in_seconds"] = tumbling_window_in_seconds
            __props__.__dict__["arn"] = None
            __props__.__dict__["function_arn"] = None
            __props__.__dict__["last_modified"] = None
            __props__.__dict__["last_processing_result"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_transition_reason"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["uuid"] = None
        super(EventSourceMapping, __self__).__init__(
            'aws:lambda/eventSourceMapping:EventSourceMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            amazon_managed_kafka_event_source_config: Optional[pulumi.Input[Union['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs', 'EventSourceMappingAmazonManagedKafkaEventSourceConfigArgsDict']]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            batch_size: Optional[pulumi.Input[builtins.int]] = None,
            bisect_batch_on_function_error: Optional[pulumi.Input[builtins.bool]] = None,
            destination_config: Optional[pulumi.Input[Union['EventSourceMappingDestinationConfigArgs', 'EventSourceMappingDestinationConfigArgsDict']]] = None,
            document_db_event_source_config: Optional[pulumi.Input[Union['EventSourceMappingDocumentDbEventSourceConfigArgs', 'EventSourceMappingDocumentDbEventSourceConfigArgsDict']]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            event_source_arn: Optional[pulumi.Input[builtins.str]] = None,
            filter_criteria: Optional[pulumi.Input[Union['EventSourceMappingFilterCriteriaArgs', 'EventSourceMappingFilterCriteriaArgsDict']]] = None,
            function_arn: Optional[pulumi.Input[builtins.str]] = None,
            function_name: Optional[pulumi.Input[builtins.str]] = None,
            function_response_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
            last_modified: Optional[pulumi.Input[builtins.str]] = None,
            last_processing_result: Optional[pulumi.Input[builtins.str]] = None,
            maximum_batching_window_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
            maximum_record_age_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
            maximum_retry_attempts: Optional[pulumi.Input[builtins.int]] = None,
            metrics_config: Optional[pulumi.Input[Union['EventSourceMappingMetricsConfigArgs', 'EventSourceMappingMetricsConfigArgsDict']]] = None,
            parallelization_factor: Optional[pulumi.Input[builtins.int]] = None,
            provisioned_poller_config: Optional[pulumi.Input[Union['EventSourceMappingProvisionedPollerConfigArgs', 'EventSourceMappingProvisionedPollerConfigArgsDict']]] = None,
            queues: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            scaling_config: Optional[pulumi.Input[Union['EventSourceMappingScalingConfigArgs', 'EventSourceMappingScalingConfigArgsDict']]] = None,
            self_managed_event_source: Optional[pulumi.Input[Union['EventSourceMappingSelfManagedEventSourceArgs', 'EventSourceMappingSelfManagedEventSourceArgsDict']]] = None,
            self_managed_kafka_event_source_config: Optional[pulumi.Input[Union['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs', 'EventSourceMappingSelfManagedKafkaEventSourceConfigArgsDict']]] = None,
            source_access_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EventSourceMappingSourceAccessConfigurationArgs', 'EventSourceMappingSourceAccessConfigurationArgsDict']]]]] = None,
            starting_position: Optional[pulumi.Input[builtins.str]] = None,
            starting_position_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            state_transition_reason: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            topics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tumbling_window_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
            uuid: Optional[pulumi.Input[builtins.str]] = None) -> 'EventSourceMapping':
        """
        Get an existing EventSourceMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['EventSourceMappingAmazonManagedKafkaEventSourceConfigArgs', 'EventSourceMappingAmazonManagedKafkaEventSourceConfigArgsDict']] amazon_managed_kafka_event_source_config: Additional configuration block for Amazon Managed Kafka sources. Incompatible with `self_managed_event_source` and `self_managed_kafka_event_source_config`. See below.
        :param pulumi.Input[builtins.str] arn: Event source mapping ARN.
        :param pulumi.Input[builtins.int] batch_size: Largest number of records that Lambda will retrieve from your event source at the time of invocation. Defaults to `100` for DynamoDB, Kinesis, MQ and MSK, `10` for SQS.
        :param pulumi.Input[builtins.bool] bisect_batch_on_function_error: Whether to split the batch in two and retry if the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Defaults to `false`.
        :param pulumi.Input[Union['EventSourceMappingDestinationConfigArgs', 'EventSourceMappingDestinationConfigArgsDict']] destination_config: Amazon SQS queue, Amazon SNS topic or Amazon S3 bucket (only available for Kafka sources) destination for failed records. Only available for stream sources (DynamoDB and Kinesis) and Kafka sources (Amazon MSK and Self-managed Apache Kafka). See below.
        :param pulumi.Input[Union['EventSourceMappingDocumentDbEventSourceConfigArgs', 'EventSourceMappingDocumentDbEventSourceConfigArgsDict']] document_db_event_source_config: Configuration settings for a DocumentDB event source. See below.
        :param pulumi.Input[builtins.bool] enabled: Whether the mapping is enabled. Defaults to `true`.
        :param pulumi.Input[builtins.str] event_source_arn: Event source ARN - required for Kinesis stream, DynamoDB stream, SQS queue, MQ broker, MSK cluster or DocumentDB change stream. Incompatible with Self Managed Kafka source.
        :param pulumi.Input[Union['EventSourceMappingFilterCriteriaArgs', 'EventSourceMappingFilterCriteriaArgsDict']] filter_criteria: Criteria to use for [event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html) Kinesis stream, DynamoDB stream, SQS queue event sources. See below.
        :param pulumi.Input[builtins.str] function_arn: ARN of the Lambda function the event source mapping is sending events to. (Note: this is a computed value that differs from `function_name` above.)
        :param pulumi.Input[builtins.str] function_name: Name or ARN of the Lambda function that will be subscribing to events.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] function_response_types: List of current response type enums applied to the event source mapping for [AWS Lambda checkpointing](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting). Only available for SQS and stream sources (DynamoDB and Kinesis). Valid values: `ReportBatchItemFailures`.
        :param pulumi.Input[builtins.str] kms_key_arn: ARN of the Key Management Service (KMS) customer managed key that Lambda uses to encrypt your function's filter criteria.
        :param pulumi.Input[builtins.str] last_modified: Date this resource was last modified.
        :param pulumi.Input[builtins.str] last_processing_result: Result of the last AWS Lambda invocation of your Lambda function.
        :param pulumi.Input[builtins.int] maximum_batching_window_in_seconds: Maximum amount of time to gather records before invoking the function, in seconds (between 0 and 300). Records will continue to buffer until either `maximum_batching_window_in_seconds` expires or `batch_size` has been met. For streaming event sources, defaults to as soon as records are available in the stream. Only available for stream sources (DynamoDB and Kinesis) and SQS standard queues.
        :param pulumi.Input[builtins.int] maximum_record_age_in_seconds: Maximum age of a record that Lambda sends to a function for processing. Only available for stream sources (DynamoDB and Kinesis). Must be either -1 (forever, and the default value) or between 60 and 604800 (inclusive).
        :param pulumi.Input[builtins.int] maximum_retry_attempts: Maximum number of times to retry when the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of -1 (forever), maximum of 10000.
        :param pulumi.Input[Union['EventSourceMappingMetricsConfigArgs', 'EventSourceMappingMetricsConfigArgsDict']] metrics_config: CloudWatch metrics configuration of the event source. Only available for stream sources (DynamoDB and Kinesis) and SQS queues. See below.
        :param pulumi.Input[builtins.int] parallelization_factor: Number of batches to process from each shard concurrently. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of 1, maximum of 10.
        :param pulumi.Input[Union['EventSourceMappingProvisionedPollerConfigArgs', 'EventSourceMappingProvisionedPollerConfigArgsDict']] provisioned_poller_config: Event poller configuration for the event source. Only valid for Amazon MSK or self-managed Apache Kafka sources. See below.
        :param pulumi.Input[builtins.str] queues: Name of the Amazon MQ broker destination queue to consume. Only available for MQ sources. The list must contain exactly one queue name.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['EventSourceMappingScalingConfigArgs', 'EventSourceMappingScalingConfigArgsDict']] scaling_config: Scaling configuration of the event source. Only available for SQS queues. See below.
        :param pulumi.Input[Union['EventSourceMappingSelfManagedEventSourceArgs', 'EventSourceMappingSelfManagedEventSourceArgsDict']] self_managed_event_source: For Self Managed Kafka sources, the location of the self managed cluster. If set, configuration must also include `source_access_configuration`. See below.
        :param pulumi.Input[Union['EventSourceMappingSelfManagedKafkaEventSourceConfigArgs', 'EventSourceMappingSelfManagedKafkaEventSourceConfigArgsDict']] self_managed_kafka_event_source_config: Additional configuration block for Self Managed Kafka sources. Incompatible with `event_source_arn` and `amazon_managed_kafka_event_source_config`. See below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EventSourceMappingSourceAccessConfigurationArgs', 'EventSourceMappingSourceAccessConfigurationArgsDict']]]] source_access_configurations: For Self Managed Kafka sources, the access configuration for the source. If set, configuration must also include `self_managed_event_source`. See below.
        :param pulumi.Input[builtins.str] starting_position: Position in the stream where AWS Lambda should start reading. Must be one of `AT_TIMESTAMP` (Kinesis only), `LATEST` or `TRIM_HORIZON` if getting events from Kinesis, DynamoDB, MSK or Self Managed Apache Kafka. Must not be provided if getting events from SQS. More information about these positions can be found in the [AWS DynamoDB Streams API Reference](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator.html) and [AWS Kinesis API Reference](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType).
        :param pulumi.Input[builtins.str] starting_position_timestamp: Timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of the data record which to start reading when using `starting_position` set to `AT_TIMESTAMP`. If a record with this exact timestamp does not exist, the next later record is chosen. If the timestamp is older than the current trim horizon, the oldest available record is chosen.
        :param pulumi.Input[builtins.str] state: State of the event source mapping.
        :param pulumi.Input[builtins.str] state_transition_reason: Reason the event source mapping is in its current state.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] topics: Name of the Kafka topics. Only available for MSK sources. A single topic name must be specified.
        :param pulumi.Input[builtins.int] tumbling_window_in_seconds: Duration in seconds of a processing window for [AWS Lambda streaming analytics](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-windows). The range is between 1 second up to 900 seconds. Only available for stream sources (DynamoDB and Kinesis).
        :param pulumi.Input[builtins.str] uuid: UUID of the created event source mapping.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventSourceMappingState.__new__(_EventSourceMappingState)

        __props__.__dict__["amazon_managed_kafka_event_source_config"] = amazon_managed_kafka_event_source_config
        __props__.__dict__["arn"] = arn
        __props__.__dict__["batch_size"] = batch_size
        __props__.__dict__["bisect_batch_on_function_error"] = bisect_batch_on_function_error
        __props__.__dict__["destination_config"] = destination_config
        __props__.__dict__["document_db_event_source_config"] = document_db_event_source_config
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["event_source_arn"] = event_source_arn
        __props__.__dict__["filter_criteria"] = filter_criteria
        __props__.__dict__["function_arn"] = function_arn
        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["function_response_types"] = function_response_types
        __props__.__dict__["kms_key_arn"] = kms_key_arn
        __props__.__dict__["last_modified"] = last_modified
        __props__.__dict__["last_processing_result"] = last_processing_result
        __props__.__dict__["maximum_batching_window_in_seconds"] = maximum_batching_window_in_seconds
        __props__.__dict__["maximum_record_age_in_seconds"] = maximum_record_age_in_seconds
        __props__.__dict__["maximum_retry_attempts"] = maximum_retry_attempts
        __props__.__dict__["metrics_config"] = metrics_config
        __props__.__dict__["parallelization_factor"] = parallelization_factor
        __props__.__dict__["provisioned_poller_config"] = provisioned_poller_config
        __props__.__dict__["queues"] = queues
        __props__.__dict__["region"] = region
        __props__.__dict__["scaling_config"] = scaling_config
        __props__.__dict__["self_managed_event_source"] = self_managed_event_source
        __props__.__dict__["self_managed_kafka_event_source_config"] = self_managed_kafka_event_source_config
        __props__.__dict__["source_access_configurations"] = source_access_configurations
        __props__.__dict__["starting_position"] = starting_position
        __props__.__dict__["starting_position_timestamp"] = starting_position_timestamp
        __props__.__dict__["state"] = state
        __props__.__dict__["state_transition_reason"] = state_transition_reason
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["topics"] = topics
        __props__.__dict__["tumbling_window_in_seconds"] = tumbling_window_in_seconds
        __props__.__dict__["uuid"] = uuid
        return EventSourceMapping(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="amazonManagedKafkaEventSourceConfig")
    def amazon_managed_kafka_event_source_config(self) -> pulumi.Output['outputs.EventSourceMappingAmazonManagedKafkaEventSourceConfig']:
        """
        Additional configuration block for Amazon Managed Kafka sources. Incompatible with `self_managed_event_source` and `self_managed_kafka_event_source_config`. See below.
        """
        return pulumi.get(self, "amazon_managed_kafka_event_source_config")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Event source mapping ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Largest number of records that Lambda will retrieve from your event source at the time of invocation. Defaults to `100` for DynamoDB, Kinesis, MQ and MSK, `10` for SQS.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="bisectBatchOnFunctionError")
    def bisect_batch_on_function_error(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to split the batch in two and retry if the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Defaults to `false`.
        """
        return pulumi.get(self, "bisect_batch_on_function_error")

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> pulumi.Output[Optional['outputs.EventSourceMappingDestinationConfig']]:
        """
        Amazon SQS queue, Amazon SNS topic or Amazon S3 bucket (only available for Kafka sources) destination for failed records. Only available for stream sources (DynamoDB and Kinesis) and Kafka sources (Amazon MSK and Self-managed Apache Kafka). See below.
        """
        return pulumi.get(self, "destination_config")

    @property
    @pulumi.getter(name="documentDbEventSourceConfig")
    def document_db_event_source_config(self) -> pulumi.Output[Optional['outputs.EventSourceMappingDocumentDbEventSourceConfig']]:
        """
        Configuration settings for a DocumentDB event source. See below.
        """
        return pulumi.get(self, "document_db_event_source_config")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the mapping is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="eventSourceArn")
    def event_source_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Event source ARN - required for Kinesis stream, DynamoDB stream, SQS queue, MQ broker, MSK cluster or DocumentDB change stream. Incompatible with Self Managed Kafka source.
        """
        return pulumi.get(self, "event_source_arn")

    @property
    @pulumi.getter(name="filterCriteria")
    def filter_criteria(self) -> pulumi.Output[Optional['outputs.EventSourceMappingFilterCriteria']]:
        """
        Criteria to use for [event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html) Kinesis stream, DynamoDB stream, SQS queue event sources. See below.
        """
        return pulumi.get(self, "filter_criteria")

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Lambda function the event source mapping is sending events to. (Note: this is a computed value that differs from `function_name` above.)
        """
        return pulumi.get(self, "function_arn")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[builtins.str]:
        """
        Name or ARN of the Lambda function that will be subscribing to events.

        The following arguments are optional:
        """
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter(name="functionResponseTypes")
    def function_response_types(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of current response type enums applied to the event source mapping for [AWS Lambda checkpointing](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting). Only available for SQS and stream sources (DynamoDB and Kinesis). Valid values: `ReportBatchItemFailures`.
        """
        return pulumi.get(self, "function_response_types")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ARN of the Key Management Service (KMS) customer managed key that Lambda uses to encrypt your function's filter criteria.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[builtins.str]:
        """
        Date this resource was last modified.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter(name="lastProcessingResult")
    def last_processing_result(self) -> pulumi.Output[builtins.str]:
        """
        Result of the last AWS Lambda invocation of your Lambda function.
        """
        return pulumi.get(self, "last_processing_result")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Maximum amount of time to gather records before invoking the function, in seconds (between 0 and 300). Records will continue to buffer until either `maximum_batching_window_in_seconds` expires or `batch_size` has been met. For streaming event sources, defaults to as soon as records are available in the stream. Only available for stream sources (DynamoDB and Kinesis) and SQS standard queues.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @property
    @pulumi.getter(name="maximumRecordAgeInSeconds")
    def maximum_record_age_in_seconds(self) -> pulumi.Output[builtins.int]:
        """
        Maximum age of a record that Lambda sends to a function for processing. Only available for stream sources (DynamoDB and Kinesis). Must be either -1 (forever, and the default value) or between 60 and 604800 (inclusive).
        """
        return pulumi.get(self, "maximum_record_age_in_seconds")

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> pulumi.Output[builtins.int]:
        """
        Maximum number of times to retry when the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of -1 (forever), maximum of 10000.
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @property
    @pulumi.getter(name="metricsConfig")
    def metrics_config(self) -> pulumi.Output[Optional['outputs.EventSourceMappingMetricsConfig']]:
        """
        CloudWatch metrics configuration of the event source. Only available for stream sources (DynamoDB and Kinesis) and SQS queues. See below.
        """
        return pulumi.get(self, "metrics_config")

    @property
    @pulumi.getter(name="parallelizationFactor")
    def parallelization_factor(self) -> pulumi.Output[builtins.int]:
        """
        Number of batches to process from each shard concurrently. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of 1, maximum of 10.
        """
        return pulumi.get(self, "parallelization_factor")

    @property
    @pulumi.getter(name="provisionedPollerConfig")
    def provisioned_poller_config(self) -> pulumi.Output[Optional['outputs.EventSourceMappingProvisionedPollerConfig']]:
        """
        Event poller configuration for the event source. Only valid for Amazon MSK or self-managed Apache Kafka sources. See below.
        """
        return pulumi.get(self, "provisioned_poller_config")

    @property
    @pulumi.getter
    def queues(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of the Amazon MQ broker destination queue to consume. Only available for MQ sources. The list must contain exactly one queue name.
        """
        return pulumi.get(self, "queues")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> pulumi.Output[Optional['outputs.EventSourceMappingScalingConfig']]:
        """
        Scaling configuration of the event source. Only available for SQS queues. See below.
        """
        return pulumi.get(self, "scaling_config")

    @property
    @pulumi.getter(name="selfManagedEventSource")
    def self_managed_event_source(self) -> pulumi.Output[Optional['outputs.EventSourceMappingSelfManagedEventSource']]:
        """
        For Self Managed Kafka sources, the location of the self managed cluster. If set, configuration must also include `source_access_configuration`. See below.
        """
        return pulumi.get(self, "self_managed_event_source")

    @property
    @pulumi.getter(name="selfManagedKafkaEventSourceConfig")
    def self_managed_kafka_event_source_config(self) -> pulumi.Output['outputs.EventSourceMappingSelfManagedKafkaEventSourceConfig']:
        """
        Additional configuration block for Self Managed Kafka sources. Incompatible with `event_source_arn` and `amazon_managed_kafka_event_source_config`. See below.
        """
        return pulumi.get(self, "self_managed_kafka_event_source_config")

    @property
    @pulumi.getter(name="sourceAccessConfigurations")
    def source_access_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.EventSourceMappingSourceAccessConfiguration']]]:
        """
        For Self Managed Kafka sources, the access configuration for the source. If set, configuration must also include `self_managed_event_source`. See below.
        """
        return pulumi.get(self, "source_access_configurations")

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Position in the stream where AWS Lambda should start reading. Must be one of `AT_TIMESTAMP` (Kinesis only), `LATEST` or `TRIM_HORIZON` if getting events from Kinesis, DynamoDB, MSK or Self Managed Apache Kafka. Must not be provided if getting events from SQS. More information about these positions can be found in the [AWS DynamoDB Streams API Reference](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator.html) and [AWS Kinesis API Reference](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType).
        """
        return pulumi.get(self, "starting_position")

    @property
    @pulumi.getter(name="startingPositionTimestamp")
    def starting_position_timestamp(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of the data record which to start reading when using `starting_position` set to `AT_TIMESTAMP`. If a record with this exact timestamp does not exist, the next later record is chosen. If the timestamp is older than the current trim horizon, the oldest available record is chosen.
        """
        return pulumi.get(self, "starting_position_timestamp")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        State of the event source mapping.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateTransitionReason")
    def state_transition_reason(self) -> pulumi.Output[builtins.str]:
        """
        Reason the event source mapping is in its current state.
        """
        return pulumi.get(self, "state_transition_reason")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def topics(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Name of the Kafka topics. Only available for MSK sources. A single topic name must be specified.
        """
        return pulumi.get(self, "topics")

    @property
    @pulumi.getter(name="tumblingWindowInSeconds")
    def tumbling_window_in_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Duration in seconds of a processing window for [AWS Lambda streaming analytics](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-windows). The range is between 1 second up to 900 seconds. Only available for stream sources (DynamoDB and Kinesis).
        """
        return pulumi.get(self, "tumbling_window_in_seconds")

    @property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[builtins.str]:
        """
        UUID of the created event source mapping.
        """
        return pulumi.get(self, "uuid")

