# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['FunctionArgs', 'Function']

@pulumi.input_type
class FunctionArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[builtins.str],
                 architectures: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 code: Optional[pulumi.Input[pulumi.Archive]] = None,
                 code_signing_config_arn: Optional[pulumi.Input[builtins.str]] = None,
                 dead_letter_config: Optional[pulumi.Input['FunctionDeadLetterConfigArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input['FunctionEnvironmentArgs']] = None,
                 ephemeral_storage: Optional[pulumi.Input['FunctionEphemeralStorageArgs']] = None,
                 file_system_config: Optional[pulumi.Input['FunctionFileSystemConfigArgs']] = None,
                 handler: Optional[pulumi.Input[builtins.str]] = None,
                 image_config: Optional[pulumi.Input['FunctionImageConfigArgs']] = None,
                 image_uri: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 logging_config: Optional[pulumi.Input['FunctionLoggingConfigArgs']] = None,
                 memory_size: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 package_type: Optional[pulumi.Input[builtins.str]] = None,
                 publish: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replace_security_groups_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 replacement_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 reserved_concurrent_executions: Optional[pulumi.Input[builtins.int]] = None,
                 runtime: Optional[pulumi.Input[Union[builtins.str, 'Runtime']]] = None,
                 s3_bucket: Optional[pulumi.Input[builtins.str]] = None,
                 s3_key: Optional[pulumi.Input[builtins.str]] = None,
                 s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
                 skip_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 snap_start: Optional[pulumi.Input['FunctionSnapStartArgs']] = None,
                 source_code_hash: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 tracing_config: Optional[pulumi.Input['FunctionTracingConfigArgs']] = None,
                 vpc_config: Optional[pulumi.Input['FunctionVpcConfigArgs']] = None):
        """
        The set of arguments for constructing a Function resource.
        :param pulumi.Input[builtins.str] role: ARN of the function's execution role. The role provides the function's identity and access to AWS services and resources.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] architectures: Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`. Default is `["x86_64"]`. Removing this attribute, function's architecture stays the same.
        :param pulumi.Input[pulumi.Archive] code: Path to the function's deployment package within the local filesystem. Conflicts with `image_uri` and `s3_bucket`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        :param pulumi.Input[builtins.str] code_signing_config_arn: ARN of a code-signing configuration to enable code signing for this function.
        :param pulumi.Input['FunctionDeadLetterConfigArgs'] dead_letter_config: Configuration block for dead letter queue. See below.
        :param pulumi.Input[builtins.str] description: Description of what your Lambda Function does.
        :param pulumi.Input['FunctionEnvironmentArgs'] environment: Configuration block for environment variables. See below.
        :param pulumi.Input['FunctionEphemeralStorageArgs'] ephemeral_storage: Amount of ephemeral storage (`/tmp`) to allocate for the Lambda Function. See below.
        :param pulumi.Input['FunctionFileSystemConfigArgs'] file_system_config: Configuration block for EFS file system. See below.
        :param pulumi.Input[builtins.str] handler: Function entry point in your code. Required if `package_type` is `Zip`.
        :param pulumi.Input['FunctionImageConfigArgs'] image_config: Container image configuration values. See below.
        :param pulumi.Input[builtins.str] image_uri: ECR image URI containing the function's deployment package. Conflicts with `filename` and `s3_bucket`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        :param pulumi.Input[builtins.str] kms_key_arn: ARN of the AWS Key Management Service key used to encrypt environment variables. If not provided when environment variables are in use, AWS Lambda uses a default service key. If provided when environment variables are not in use, the AWS Lambda API does not save this configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] layers: List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function.
        :param pulumi.Input['FunctionLoggingConfigArgs'] logging_config: Configuration block for advanced logging settings. See below.
        :param pulumi.Input[builtins.int] memory_size: Amount of memory in MB your Lambda Function can use at runtime. Valid value between 128 MB to 10,240 MB (10 GB), in 1 MB increments. Defaults to 128.
        :param pulumi.Input[builtins.str] name: Unique name for your Lambda Function.
        :param pulumi.Input[builtins.str] package_type: Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
        :param pulumi.Input[builtins.bool] publish: Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] replace_security_groups_on_destroy: Whether to replace the security groups on the function's VPC configuration prior to destruction. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] replacement_security_group_ids: List of security group IDs to assign to the function's VPC configuration prior to destruction. Required if `replace_security_groups_on_destroy` is `true`.
        :param pulumi.Input[builtins.int] reserved_concurrent_executions: Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`.
        :param pulumi.Input[Union[builtins.str, 'Runtime']] runtime: Identifier of the function's runtime. Required if `package_type` is `Zip`. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
        :param pulumi.Input[builtins.str] s3_bucket: S3 bucket location containing the function's deployment package. Conflicts with `filename` and `image_uri`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        :param pulumi.Input[builtins.str] s3_key: S3 key of an object containing the function's deployment package. Required if `s3_bucket` is set.
        :param pulumi.Input[builtins.str] s3_object_version: Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
        :param pulumi.Input[builtins.bool] skip_destroy: Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`.
        :param pulumi.Input['FunctionSnapStartArgs'] snap_start: Configuration block for snap start settings. See below.
        :param pulumi.Input[builtins.str] source_code_hash: Base64-encoded SHA256 hash of the package file. Used to trigger updates when source code changes.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of tags for the Lambda function. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.int] timeout: Amount of time your Lambda Function has to run in seconds. Defaults to 3. Valid between 1 and 900.
        :param pulumi.Input['FunctionTracingConfigArgs'] tracing_config: Configuration block for X-Ray tracing. See below.
        :param pulumi.Input['FunctionVpcConfigArgs'] vpc_config: Configuration block for VPC. See below.
        """
        pulumi.set(__self__, "role", role)
        if architectures is not None:
            pulumi.set(__self__, "architectures", architectures)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if code_signing_config_arn is not None:
            pulumi.set(__self__, "code_signing_config_arn", code_signing_config_arn)
        if dead_letter_config is not None:
            pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if file_system_config is not None:
            pulumi.set(__self__, "file_system_config", file_system_config)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if image_config is not None:
            pulumi.set(__self__, "image_config", image_config)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if memory_size is not None:
            pulumi.set(__self__, "memory_size", memory_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if publish is not None:
            pulumi.set(__self__, "publish", publish)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replace_security_groups_on_destroy is not None:
            pulumi.set(__self__, "replace_security_groups_on_destroy", replace_security_groups_on_destroy)
        if replacement_security_group_ids is not None:
            pulumi.set(__self__, "replacement_security_group_ids", replacement_security_group_ids)
        if reserved_concurrent_executions is not None:
            pulumi.set(__self__, "reserved_concurrent_executions", reserved_concurrent_executions)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)
        if s3_key is not None:
            pulumi.set(__self__, "s3_key", s3_key)
        if s3_object_version is not None:
            pulumi.set(__self__, "s3_object_version", s3_object_version)
        if skip_destroy is not None:
            pulumi.set(__self__, "skip_destroy", skip_destroy)
        if snap_start is not None:
            pulumi.set(__self__, "snap_start", snap_start)
        if source_code_hash is not None:
            pulumi.set(__self__, "source_code_hash", source_code_hash)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tracing_config is not None:
            pulumi.set(__self__, "tracing_config", tracing_config)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the function's execution role. The role provides the function's identity and access to AWS services and resources.

        The following arguments are optional:
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def architectures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`. Default is `["x86_64"]`. Removing this attribute, function's architecture stays the same.
        """
        return pulumi.get(self, "architectures")

    @architectures.setter
    def architectures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "architectures", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[pulumi.Archive]]:
        """
        Path to the function's deployment package within the local filesystem. Conflicts with `image_uri` and `s3_bucket`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[pulumi.Archive]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="codeSigningConfigArn")
    def code_signing_config_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of a code-signing configuration to enable code signing for this function.
        """
        return pulumi.get(self, "code_signing_config_arn")

    @code_signing_config_arn.setter
    def code_signing_config_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "code_signing_config_arn", value)

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> Optional[pulumi.Input['FunctionDeadLetterConfigArgs']]:
        """
        Configuration block for dead letter queue. See below.
        """
        return pulumi.get(self, "dead_letter_config")

    @dead_letter_config.setter
    def dead_letter_config(self, value: Optional[pulumi.Input['FunctionDeadLetterConfigArgs']]):
        pulumi.set(self, "dead_letter_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of what your Lambda Function does.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['FunctionEnvironmentArgs']]:
        """
        Configuration block for environment variables. See below.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['FunctionEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input['FunctionEphemeralStorageArgs']]:
        """
        Amount of ephemeral storage (`/tmp`) to allocate for the Lambda Function. See below.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input['FunctionEphemeralStorageArgs']]):
        pulumi.set(self, "ephemeral_storage", value)

    @property
    @pulumi.getter(name="fileSystemConfig")
    def file_system_config(self) -> Optional[pulumi.Input['FunctionFileSystemConfigArgs']]:
        """
        Configuration block for EFS file system. See below.
        """
        return pulumi.get(self, "file_system_config")

    @file_system_config.setter
    def file_system_config(self, value: Optional[pulumi.Input['FunctionFileSystemConfigArgs']]):
        pulumi.set(self, "file_system_config", value)

    @property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Function entry point in your code. Required if `package_type` is `Zip`.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter(name="imageConfig")
    def image_config(self) -> Optional[pulumi.Input['FunctionImageConfigArgs']]:
        """
        Container image configuration values. See below.
        """
        return pulumi.get(self, "image_config")

    @image_config.setter
    def image_config(self, value: Optional[pulumi.Input['FunctionImageConfigArgs']]):
        pulumi.set(self, "image_config", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ECR image URI containing the function's deployment package. Conflicts with `filename` and `s3_bucket`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_uri", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the AWS Key Management Service key used to encrypt environment variables. If not provided when environment variables are in use, AWS Lambda uses a default service key. If provided when environment variables are not in use, the AWS Lambda API does not save this configuration.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "layers", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['FunctionLoggingConfigArgs']]:
        """
        Configuration block for advanced logging settings. See below.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['FunctionLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of memory in MB your Lambda Function can use at runtime. Valid value between 128 MB to 10,240 MB (10 GB), in 1 MB increments. Defaults to 128.
        """
        return pulumi.get(self, "memory_size")

    @memory_size.setter
    def memory_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique name for your Lambda Function.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "package_type", value)

    @property
    @pulumi.getter
    def publish(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
        """
        return pulumi.get(self, "publish")

    @publish.setter
    def publish(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "publish", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replaceSecurityGroupsOnDestroy")
    def replace_security_groups_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to replace the security groups on the function's VPC configuration prior to destruction. Default is `false`.
        """
        return pulumi.get(self, "replace_security_groups_on_destroy")

    @replace_security_groups_on_destroy.setter
    def replace_security_groups_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "replace_security_groups_on_destroy", value)

    @property
    @pulumi.getter(name="replacementSecurityGroupIds")
    def replacement_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of security group IDs to assign to the function's VPC configuration prior to destruction. Required if `replace_security_groups_on_destroy` is `true`.
        """
        return pulumi.get(self, "replacement_security_group_ids")

    @replacement_security_group_ids.setter
    def replacement_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "replacement_security_group_ids", value)

    @property
    @pulumi.getter(name="reservedConcurrentExecutions")
    def reserved_concurrent_executions(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`.
        """
        return pulumi.get(self, "reserved_concurrent_executions")

    @reserved_concurrent_executions.setter
    def reserved_concurrent_executions(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "reserved_concurrent_executions", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[Union[builtins.str, 'Runtime']]]:
        """
        Identifier of the function's runtime. Required if `package_type` is `Zip`. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[Union[builtins.str, 'Runtime']]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        S3 bucket location containing the function's deployment package. Conflicts with `filename` and `image_uri`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_bucket", value)

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        S3 key of an object containing the function's deployment package. Required if `s3_bucket` is set.
        """
        return pulumi.get(self, "s3_key")

    @s3_key.setter
    def s3_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_key", value)

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
        """
        return pulumi.get(self, "s3_object_version")

    @s3_object_version.setter
    def s3_object_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_object_version", value)

    @property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`.
        """
        return pulumi.get(self, "skip_destroy")

    @skip_destroy.setter
    def skip_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_destroy", value)

    @property
    @pulumi.getter(name="snapStart")
    def snap_start(self) -> Optional[pulumi.Input['FunctionSnapStartArgs']]:
        """
        Configuration block for snap start settings. See below.
        """
        return pulumi.get(self, "snap_start")

    @snap_start.setter
    def snap_start(self, value: Optional[pulumi.Input['FunctionSnapStartArgs']]):
        pulumi.set(self, "snap_start", value)

    @property
    @pulumi.getter(name="sourceCodeHash")
    def source_code_hash(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64-encoded SHA256 hash of the package file. Used to trigger updates when source code changes.
        """
        return pulumi.get(self, "source_code_hash")

    @source_code_hash.setter
    def source_code_hash(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_code_hash", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of tags for the Lambda function. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of time your Lambda Function has to run in seconds. Defaults to 3. Valid between 1 and 900.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="tracingConfig")
    def tracing_config(self) -> Optional[pulumi.Input['FunctionTracingConfigArgs']]:
        """
        Configuration block for X-Ray tracing. See below.
        """
        return pulumi.get(self, "tracing_config")

    @tracing_config.setter
    def tracing_config(self, value: Optional[pulumi.Input['FunctionTracingConfigArgs']]):
        pulumi.set(self, "tracing_config", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['FunctionVpcConfigArgs']]:
        """
        Configuration block for VPC. See below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['FunctionVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


@pulumi.input_type
class _FunctionState:
    def __init__(__self__, *,
                 architectures: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 code: Optional[pulumi.Input[pulumi.Archive]] = None,
                 code_sha256: Optional[pulumi.Input[builtins.str]] = None,
                 code_signing_config_arn: Optional[pulumi.Input[builtins.str]] = None,
                 dead_letter_config: Optional[pulumi.Input['FunctionDeadLetterConfigArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input['FunctionEnvironmentArgs']] = None,
                 ephemeral_storage: Optional[pulumi.Input['FunctionEphemeralStorageArgs']] = None,
                 file_system_config: Optional[pulumi.Input['FunctionFileSystemConfigArgs']] = None,
                 handler: Optional[pulumi.Input[builtins.str]] = None,
                 image_config: Optional[pulumi.Input['FunctionImageConfigArgs']] = None,
                 image_uri: Optional[pulumi.Input[builtins.str]] = None,
                 invoke_arn: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 last_modified: Optional[pulumi.Input[builtins.str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 logging_config: Optional[pulumi.Input['FunctionLoggingConfigArgs']] = None,
                 memory_size: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 package_type: Optional[pulumi.Input[builtins.str]] = None,
                 publish: Optional[pulumi.Input[builtins.bool]] = None,
                 qualified_arn: Optional[pulumi.Input[builtins.str]] = None,
                 qualified_invoke_arn: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replace_security_groups_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 replacement_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 reserved_concurrent_executions: Optional[pulumi.Input[builtins.int]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 runtime: Optional[pulumi.Input[Union[builtins.str, 'Runtime']]] = None,
                 s3_bucket: Optional[pulumi.Input[builtins.str]] = None,
                 s3_key: Optional[pulumi.Input[builtins.str]] = None,
                 s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
                 signing_job_arn: Optional[pulumi.Input[builtins.str]] = None,
                 signing_profile_version_arn: Optional[pulumi.Input[builtins.str]] = None,
                 skip_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 snap_start: Optional[pulumi.Input['FunctionSnapStartArgs']] = None,
                 source_code_hash: Optional[pulumi.Input[builtins.str]] = None,
                 source_code_size: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 tracing_config: Optional[pulumi.Input['FunctionTracingConfigArgs']] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_config: Optional[pulumi.Input['FunctionVpcConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Function resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] architectures: Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`. Default is `["x86_64"]`. Removing this attribute, function's architecture stays the same.
        :param pulumi.Input[builtins.str] arn: ARN identifying your Lambda Function.
        :param pulumi.Input[pulumi.Archive] code: Path to the function's deployment package within the local filesystem. Conflicts with `image_uri` and `s3_bucket`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        :param pulumi.Input[builtins.str] code_sha256: Base64-encoded representation of raw SHA-256 sum of the zip file.
        :param pulumi.Input[builtins.str] code_signing_config_arn: ARN of a code-signing configuration to enable code signing for this function.
        :param pulumi.Input['FunctionDeadLetterConfigArgs'] dead_letter_config: Configuration block for dead letter queue. See below.
        :param pulumi.Input[builtins.str] description: Description of what your Lambda Function does.
        :param pulumi.Input['FunctionEnvironmentArgs'] environment: Configuration block for environment variables. See below.
        :param pulumi.Input['FunctionEphemeralStorageArgs'] ephemeral_storage: Amount of ephemeral storage (`/tmp`) to allocate for the Lambda Function. See below.
        :param pulumi.Input['FunctionFileSystemConfigArgs'] file_system_config: Configuration block for EFS file system. See below.
        :param pulumi.Input[builtins.str] handler: Function entry point in your code. Required if `package_type` is `Zip`.
        :param pulumi.Input['FunctionImageConfigArgs'] image_config: Container image configuration values. See below.
        :param pulumi.Input[builtins.str] image_uri: ECR image URI containing the function's deployment package. Conflicts with `filename` and `s3_bucket`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        :param pulumi.Input[builtins.str] invoke_arn: ARN to be used for invoking Lambda Function from API Gateway - to be used in `apigateway.Integration`'s `uri`.
        :param pulumi.Input[builtins.str] kms_key_arn: ARN of the AWS Key Management Service key used to encrypt environment variables. If not provided when environment variables are in use, AWS Lambda uses a default service key. If provided when environment variables are not in use, the AWS Lambda API does not save this configuration.
        :param pulumi.Input[builtins.str] last_modified: Date this resource was last modified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] layers: List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function.
        :param pulumi.Input['FunctionLoggingConfigArgs'] logging_config: Configuration block for advanced logging settings. See below.
        :param pulumi.Input[builtins.int] memory_size: Amount of memory in MB your Lambda Function can use at runtime. Valid value between 128 MB to 10,240 MB (10 GB), in 1 MB increments. Defaults to 128.
        :param pulumi.Input[builtins.str] name: Unique name for your Lambda Function.
        :param pulumi.Input[builtins.str] package_type: Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
        :param pulumi.Input[builtins.bool] publish: Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
        :param pulumi.Input[builtins.str] qualified_arn: ARN identifying your Lambda Function Version (if versioning is enabled via `publish = true`).
        :param pulumi.Input[builtins.str] qualified_invoke_arn: Qualified ARN (ARN with lambda version number) to be used for invoking Lambda Function from API Gateway - to be used in `apigateway.Integration`'s `uri`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] replace_security_groups_on_destroy: Whether to replace the security groups on the function's VPC configuration prior to destruction. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] replacement_security_group_ids: List of security group IDs to assign to the function's VPC configuration prior to destruction. Required if `replace_security_groups_on_destroy` is `true`.
        :param pulumi.Input[builtins.int] reserved_concurrent_executions: Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`.
        :param pulumi.Input[builtins.str] role: ARN of the function's execution role. The role provides the function's identity and access to AWS services and resources.
               
               The following arguments are optional:
        :param pulumi.Input[Union[builtins.str, 'Runtime']] runtime: Identifier of the function's runtime. Required if `package_type` is `Zip`. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
        :param pulumi.Input[builtins.str] s3_bucket: S3 bucket location containing the function's deployment package. Conflicts with `filename` and `image_uri`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        :param pulumi.Input[builtins.str] s3_key: S3 key of an object containing the function's deployment package. Required if `s3_bucket` is set.
        :param pulumi.Input[builtins.str] s3_object_version: Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
        :param pulumi.Input[builtins.str] signing_job_arn: ARN of the signing job.
        :param pulumi.Input[builtins.str] signing_profile_version_arn: ARN of the signing profile version.
        :param pulumi.Input[builtins.bool] skip_destroy: Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`.
        :param pulumi.Input['FunctionSnapStartArgs'] snap_start: Configuration block for snap start settings. See below.
        :param pulumi.Input[builtins.str] source_code_hash: Base64-encoded SHA256 hash of the package file. Used to trigger updates when source code changes.
        :param pulumi.Input[builtins.int] source_code_size: Size in bytes of the function .zip file.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of tags for the Lambda function. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.int] timeout: Amount of time your Lambda Function has to run in seconds. Defaults to 3. Valid between 1 and 900.
        :param pulumi.Input['FunctionTracingConfigArgs'] tracing_config: Configuration block for X-Ray tracing. See below.
        :param pulumi.Input[builtins.str] version: Latest published version of your Lambda Function.
        :param pulumi.Input['FunctionVpcConfigArgs'] vpc_config: Configuration block for VPC. See below.
        """
        if architectures is not None:
            pulumi.set(__self__, "architectures", architectures)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if code_sha256 is not None:
            pulumi.set(__self__, "code_sha256", code_sha256)
        if code_signing_config_arn is not None:
            pulumi.set(__self__, "code_signing_config_arn", code_signing_config_arn)
        if dead_letter_config is not None:
            pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if file_system_config is not None:
            pulumi.set(__self__, "file_system_config", file_system_config)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if image_config is not None:
            pulumi.set(__self__, "image_config", image_config)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if invoke_arn is not None:
            pulumi.set(__self__, "invoke_arn", invoke_arn)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if last_modified is not None:
            pulumi.set(__self__, "last_modified", last_modified)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if memory_size is not None:
            pulumi.set(__self__, "memory_size", memory_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if publish is not None:
            pulumi.set(__self__, "publish", publish)
        if qualified_arn is not None:
            pulumi.set(__self__, "qualified_arn", qualified_arn)
        if qualified_invoke_arn is not None:
            pulumi.set(__self__, "qualified_invoke_arn", qualified_invoke_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replace_security_groups_on_destroy is not None:
            pulumi.set(__self__, "replace_security_groups_on_destroy", replace_security_groups_on_destroy)
        if replacement_security_group_ids is not None:
            pulumi.set(__self__, "replacement_security_group_ids", replacement_security_group_ids)
        if reserved_concurrent_executions is not None:
            pulumi.set(__self__, "reserved_concurrent_executions", reserved_concurrent_executions)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)
        if s3_key is not None:
            pulumi.set(__self__, "s3_key", s3_key)
        if s3_object_version is not None:
            pulumi.set(__self__, "s3_object_version", s3_object_version)
        if signing_job_arn is not None:
            pulumi.set(__self__, "signing_job_arn", signing_job_arn)
        if signing_profile_version_arn is not None:
            pulumi.set(__self__, "signing_profile_version_arn", signing_profile_version_arn)
        if skip_destroy is not None:
            pulumi.set(__self__, "skip_destroy", skip_destroy)
        if snap_start is not None:
            pulumi.set(__self__, "snap_start", snap_start)
        if source_code_hash is not None:
            pulumi.set(__self__, "source_code_hash", source_code_hash)
        if source_code_size is not None:
            pulumi.set(__self__, "source_code_size", source_code_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tracing_config is not None:
            pulumi.set(__self__, "tracing_config", tracing_config)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter
    def architectures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`. Default is `["x86_64"]`. Removing this attribute, function's architecture stays the same.
        """
        return pulumi.get(self, "architectures")

    @architectures.setter
    def architectures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "architectures", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN identifying your Lambda Function.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[pulumi.Archive]]:
        """
        Path to the function's deployment package within the local filesystem. Conflicts with `image_uri` and `s3_bucket`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[pulumi.Archive]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="codeSha256")
    def code_sha256(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64-encoded representation of raw SHA-256 sum of the zip file.
        """
        return pulumi.get(self, "code_sha256")

    @code_sha256.setter
    def code_sha256(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "code_sha256", value)

    @property
    @pulumi.getter(name="codeSigningConfigArn")
    def code_signing_config_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of a code-signing configuration to enable code signing for this function.
        """
        return pulumi.get(self, "code_signing_config_arn")

    @code_signing_config_arn.setter
    def code_signing_config_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "code_signing_config_arn", value)

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> Optional[pulumi.Input['FunctionDeadLetterConfigArgs']]:
        """
        Configuration block for dead letter queue. See below.
        """
        return pulumi.get(self, "dead_letter_config")

    @dead_letter_config.setter
    def dead_letter_config(self, value: Optional[pulumi.Input['FunctionDeadLetterConfigArgs']]):
        pulumi.set(self, "dead_letter_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of what your Lambda Function does.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['FunctionEnvironmentArgs']]:
        """
        Configuration block for environment variables. See below.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['FunctionEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input['FunctionEphemeralStorageArgs']]:
        """
        Amount of ephemeral storage (`/tmp`) to allocate for the Lambda Function. See below.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input['FunctionEphemeralStorageArgs']]):
        pulumi.set(self, "ephemeral_storage", value)

    @property
    @pulumi.getter(name="fileSystemConfig")
    def file_system_config(self) -> Optional[pulumi.Input['FunctionFileSystemConfigArgs']]:
        """
        Configuration block for EFS file system. See below.
        """
        return pulumi.get(self, "file_system_config")

    @file_system_config.setter
    def file_system_config(self, value: Optional[pulumi.Input['FunctionFileSystemConfigArgs']]):
        pulumi.set(self, "file_system_config", value)

    @property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Function entry point in your code. Required if `package_type` is `Zip`.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter(name="imageConfig")
    def image_config(self) -> Optional[pulumi.Input['FunctionImageConfigArgs']]:
        """
        Container image configuration values. See below.
        """
        return pulumi.get(self, "image_config")

    @image_config.setter
    def image_config(self, value: Optional[pulumi.Input['FunctionImageConfigArgs']]):
        pulumi.set(self, "image_config", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ECR image URI containing the function's deployment package. Conflicts with `filename` and `s3_bucket`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_uri", value)

    @property
    @pulumi.getter(name="invokeArn")
    def invoke_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN to be used for invoking Lambda Function from API Gateway - to be used in `apigateway.Integration`'s `uri`.
        """
        return pulumi.get(self, "invoke_arn")

    @invoke_arn.setter
    def invoke_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "invoke_arn", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the AWS Key Management Service key used to encrypt environment variables. If not provided when environment variables are in use, AWS Lambda uses a default service key. If provided when environment variables are not in use, the AWS Lambda API does not save this configuration.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date this resource was last modified.
        """
        return pulumi.get(self, "last_modified")

    @last_modified.setter
    def last_modified(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_modified", value)

    @property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "layers", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['FunctionLoggingConfigArgs']]:
        """
        Configuration block for advanced logging settings. See below.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['FunctionLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of memory in MB your Lambda Function can use at runtime. Valid value between 128 MB to 10,240 MB (10 GB), in 1 MB increments. Defaults to 128.
        """
        return pulumi.get(self, "memory_size")

    @memory_size.setter
    def memory_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique name for your Lambda Function.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "package_type", value)

    @property
    @pulumi.getter
    def publish(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
        """
        return pulumi.get(self, "publish")

    @publish.setter
    def publish(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "publish", value)

    @property
    @pulumi.getter(name="qualifiedArn")
    def qualified_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN identifying your Lambda Function Version (if versioning is enabled via `publish = true`).
        """
        return pulumi.get(self, "qualified_arn")

    @qualified_arn.setter
    def qualified_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "qualified_arn", value)

    @property
    @pulumi.getter(name="qualifiedInvokeArn")
    def qualified_invoke_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Qualified ARN (ARN with lambda version number) to be used for invoking Lambda Function from API Gateway - to be used in `apigateway.Integration`'s `uri`.
        """
        return pulumi.get(self, "qualified_invoke_arn")

    @qualified_invoke_arn.setter
    def qualified_invoke_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "qualified_invoke_arn", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replaceSecurityGroupsOnDestroy")
    def replace_security_groups_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to replace the security groups on the function's VPC configuration prior to destruction. Default is `false`.
        """
        return pulumi.get(self, "replace_security_groups_on_destroy")

    @replace_security_groups_on_destroy.setter
    def replace_security_groups_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "replace_security_groups_on_destroy", value)

    @property
    @pulumi.getter(name="replacementSecurityGroupIds")
    def replacement_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of security group IDs to assign to the function's VPC configuration prior to destruction. Required if `replace_security_groups_on_destroy` is `true`.
        """
        return pulumi.get(self, "replacement_security_group_ids")

    @replacement_security_group_ids.setter
    def replacement_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "replacement_security_group_ids", value)

    @property
    @pulumi.getter(name="reservedConcurrentExecutions")
    def reserved_concurrent_executions(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`.
        """
        return pulumi.get(self, "reserved_concurrent_executions")

    @reserved_concurrent_executions.setter
    def reserved_concurrent_executions(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "reserved_concurrent_executions", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the function's execution role. The role provides the function's identity and access to AWS services and resources.

        The following arguments are optional:
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[Union[builtins.str, 'Runtime']]]:
        """
        Identifier of the function's runtime. Required if `package_type` is `Zip`. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[Union[builtins.str, 'Runtime']]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        S3 bucket location containing the function's deployment package. Conflicts with `filename` and `image_uri`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_bucket", value)

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        S3 key of an object containing the function's deployment package. Required if `s3_bucket` is set.
        """
        return pulumi.get(self, "s3_key")

    @s3_key.setter
    def s3_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_key", value)

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
        """
        return pulumi.get(self, "s3_object_version")

    @s3_object_version.setter
    def s3_object_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_object_version", value)

    @property
    @pulumi.getter(name="signingJobArn")
    def signing_job_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the signing job.
        """
        return pulumi.get(self, "signing_job_arn")

    @signing_job_arn.setter
    def signing_job_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signing_job_arn", value)

    @property
    @pulumi.getter(name="signingProfileVersionArn")
    def signing_profile_version_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the signing profile version.
        """
        return pulumi.get(self, "signing_profile_version_arn")

    @signing_profile_version_arn.setter
    def signing_profile_version_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signing_profile_version_arn", value)

    @property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`.
        """
        return pulumi.get(self, "skip_destroy")

    @skip_destroy.setter
    def skip_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_destroy", value)

    @property
    @pulumi.getter(name="snapStart")
    def snap_start(self) -> Optional[pulumi.Input['FunctionSnapStartArgs']]:
        """
        Configuration block for snap start settings. See below.
        """
        return pulumi.get(self, "snap_start")

    @snap_start.setter
    def snap_start(self, value: Optional[pulumi.Input['FunctionSnapStartArgs']]):
        pulumi.set(self, "snap_start", value)

    @property
    @pulumi.getter(name="sourceCodeHash")
    def source_code_hash(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64-encoded SHA256 hash of the package file. Used to trigger updates when source code changes.
        """
        return pulumi.get(self, "source_code_hash")

    @source_code_hash.setter
    def source_code_hash(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_code_hash", value)

    @property
    @pulumi.getter(name="sourceCodeSize")
    def source_code_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Size in bytes of the function .zip file.
        """
        return pulumi.get(self, "source_code_size")

    @source_code_size.setter
    def source_code_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "source_code_size", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of tags for the Lambda function. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of time your Lambda Function has to run in seconds. Defaults to 3. Valid between 1 and 900.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="tracingConfig")
    def tracing_config(self) -> Optional[pulumi.Input['FunctionTracingConfigArgs']]:
        """
        Configuration block for X-Ray tracing. See below.
        """
        return pulumi.get(self, "tracing_config")

    @tracing_config.setter
    def tracing_config(self, value: Optional[pulumi.Input['FunctionTracingConfigArgs']]):
        pulumi.set(self, "tracing_config", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Latest published version of your Lambda Function.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['FunctionVpcConfigArgs']]:
        """
        Configuration block for VPC. See below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['FunctionVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


@pulumi.type_token("aws:lambda/function:Function")
class Function(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architectures: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 code: Optional[pulumi.Input[pulumi.Archive]] = None,
                 code_signing_config_arn: Optional[pulumi.Input[builtins.str]] = None,
                 dead_letter_config: Optional[pulumi.Input[Union['FunctionDeadLetterConfigArgs', 'FunctionDeadLetterConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['FunctionEnvironmentArgs', 'FunctionEnvironmentArgsDict']]] = None,
                 ephemeral_storage: Optional[pulumi.Input[Union['FunctionEphemeralStorageArgs', 'FunctionEphemeralStorageArgsDict']]] = None,
                 file_system_config: Optional[pulumi.Input[Union['FunctionFileSystemConfigArgs', 'FunctionFileSystemConfigArgsDict']]] = None,
                 handler: Optional[pulumi.Input[builtins.str]] = None,
                 image_config: Optional[pulumi.Input[Union['FunctionImageConfigArgs', 'FunctionImageConfigArgsDict']]] = None,
                 image_uri: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 logging_config: Optional[pulumi.Input[Union['FunctionLoggingConfigArgs', 'FunctionLoggingConfigArgsDict']]] = None,
                 memory_size: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 package_type: Optional[pulumi.Input[builtins.str]] = None,
                 publish: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replace_security_groups_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 replacement_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 reserved_concurrent_executions: Optional[pulumi.Input[builtins.int]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 runtime: Optional[pulumi.Input[Union[builtins.str, 'Runtime']]] = None,
                 s3_bucket: Optional[pulumi.Input[builtins.str]] = None,
                 s3_key: Optional[pulumi.Input[builtins.str]] = None,
                 s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
                 skip_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 snap_start: Optional[pulumi.Input[Union['FunctionSnapStartArgs', 'FunctionSnapStartArgsDict']]] = None,
                 source_code_hash: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 tracing_config: Optional[pulumi.Input[Union['FunctionTracingConfigArgs', 'FunctionTracingConfigArgsDict']]] = None,
                 vpc_config: Optional[pulumi.Input[Union['FunctionVpcConfigArgs', 'FunctionVpcConfigArgsDict']]] = None,
                 __props__=None):
        """
        Manages an AWS Lambda Function. Use this resource to create serverless functions that run code in response to events without provisioning or managing servers.

        For information about Lambda and how to use it, see [What is AWS Lambda?](https://docs.aws.amazon.com/lambda/latest/dg/welcome.html). For a detailed example of setting up Lambda and API Gateway, see Serverless Applications with AWS Lambda and API Gateway.

        > **Note:** Due to [AWS Lambda improved VPC networking changes that began deploying in September 2019](https://aws.amazon.com/blogs/compute/announcing-improved-vpc-networking-for-aws-lambda-functions/), EC2 subnets and security groups associated with Lambda Functions can take up to 45 minutes to successfully delete. Pulumi AWS Provider version 2.31.0 and later automatically handles this increased timeout, however prior versions require setting the customizable deletion timeouts of those Pulumi resources to 45 minutes (`delete = "45m"`). AWS and HashiCorp are working together to reduce the amount of time required for resource deletion and updates can be tracked in this GitHub issue.

        > **Note:** If you get a `KMSAccessDeniedException: Lambda was unable to decrypt the environment variables because KMS access was denied` error when invoking an `lambda.Function` with environment variables, the IAM role associated with the function may have been deleted and recreated after the function was created. You can fix the problem two ways: 1) updating the function's role to another role and then updating it back again to the recreated role. (When you create a function, Lambda grants permissions on the KMS key to the function's IAM role. If the IAM role is recreated, the grant is no longer valid. Changing the function's role or recreating the function causes Lambda to update the grant.)

        > **Tip:** To give an external source (like an EventBridge Rule, SNS, or S3) permission to access the Lambda function, use the `lambda.Permission` resource. See [Lambda Permission Model](https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html) for more details. On the other hand, the `role` argument of this resource is the function's execution role for identity and access to AWS services and resources.

        ## Example Usage

        ### Container Image Function

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.Function("example",
            name="example_container_function",
            role=example_aws_iam_role["arn"],
            package_type="Image",
            image_uri=f"{example_aws_ecr_repository['repositoryUrl']}:latest",
            image_config={
                "entry_points": ["/lambda-entrypoint.sh"],
                "commands": ["app.handler"],
            },
            memory_size=512,
            timeout=30,
            architectures=["arm64"])
        ```

        ### Function with Lambda Layers

        > **Note:** The `lambda.LayerVersion` attribute values for `arn` and `layer_arn` were swapped in version 2.0.0 of the Pulumi AWS Provider. For version 2.x, use `arn` references.

        ```python
        import pulumi
        import pulumi_aws as aws

        # Common dependencies layer
        example = aws.lambda_.LayerVersion("example",
            code=pulumi.FileArchive("layer.zip"),
            layer_name="example_dependencies_layer",
            description="Common dependencies for Lambda functions",
            compatible_runtimes=[
                "nodejs20.x",
                "python3.12",
            ],
            compatible_architectures=[
                "x86_64",
                "arm64",
            ])
        # Function using the layer
        example_function = aws.lambda_.Function("example",
            code=pulumi.FileArchive("function.zip"),
            name="example_layered_function",
            role=example_aws_iam_role["arn"],
            handler="index.handler",
            runtime=aws.lambda_.Runtime.NODE_JS20D_X,
            layers=[example.arn],
            tracing_config={
                "mode": "Active",
            })
        ```

        ### VPC Function with Enhanced Networking

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.Function("example",
            code=pulumi.FileArchive("function.zip"),
            name="example_vpc_function",
            role=example_aws_iam_role["arn"],
            handler="app.handler",
            runtime=aws.lambda_.Runtime.PYTHON3D12,
            memory_size=1024,
            timeout=30,
            vpc_config={
                "subnet_ids": [
                    example_private1["id"],
                    example_private2["id"],
                ],
                "security_group_ids": [example_lambda["id"]],
                "ipv6_allowed_for_dual_stack": True,
            },
            ephemeral_storage={
                "size": 5120,
            },
            snap_start={
                "apply_on": "PublishedVersions",
            })
        ```

        ### Function with EFS Integration

        ```python
        import pulumi
        import pulumi_aws as aws

        # EFS file system for Lambda
        example = aws.efs.FileSystem("example",
            encrypted=True,
            tags={
                "Name": "lambda-efs",
            })
        config = pulumi.Config()
        # List of subnet IDs for EFS mount targets
        subnet_ids = config.get_object("subnetIds")
        if subnet_ids is None:
            subnet_ids = [
                "subnet-12345678",
                "subnet-87654321",
            ]
        # Mount target in each subnet
        example_mount_target = []
        for range in [{"value": i} for i in range(0, len(subnet_ids))]:
            example_mount_target.append(aws.efs.MountTarget(f"example-{range['value']}",
                file_system_id=example.id,
                subnet_id=subnet_ids[range["value"]],
                security_groups=[efs["id"]]))
        # Access point for Lambda
        example_access_point = aws.efs.AccessPoint("example",
            file_system_id=example.id,
            root_directory={
                "path": "/lambda",
                "creation_info": {
                    "owner_gid": 1000,
                    "owner_uid": 1000,
                    "permissions": "755",
                },
            },
            posix_user={
                "gid": 1000,
                "uid": 1000,
            })
        # Lambda function with EFS
        example_function = aws.lambda_.Function("example",
            code=pulumi.FileArchive("function.zip"),
            name="example_efs_function",
            role=example_aws_iam_role["arn"],
            handler="index.handler",
            runtime=aws.lambda_.Runtime.NODE_JS20D_X,
            vpc_config={
                "subnet_ids": subnet_ids,
                "security_group_ids": [lambda_["id"]],
            },
            file_system_config={
                "arn": example_access_point.arn,
                "local_mount_path": "/mnt/data",
            },
            opts = pulumi.ResourceOptions(depends_on=[example_mount_target]))
        ```

        ### Function with Advanced Logging

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudwatch.LogGroup("example",
            name="/aws/lambda/example_function",
            retention_in_days=14,
            tags={
                "Environment": "production",
                "Application": "example",
            })
        example_function = aws.lambda_.Function("example",
            code=pulumi.FileArchive("function.zip"),
            name="example_function",
            role=example_aws_iam_role["arn"],
            handler="index.handler",
            runtime=aws.lambda_.Runtime.NODE_JS20D_X,
            logging_config={
                "log_format": "JSON",
                "application_log_level": "INFO",
                "system_log_level": "WARN",
            },
            opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ### Function with Error Handling

        ```python
        import pulumi
        import pulumi_aws as aws

        # Main Lambda function
        example = aws.lambda_.Function("example",
            code=pulumi.FileArchive("function.zip"),
            name="example_function",
            role=example_aws_iam_role["arn"],
            handler="index.handler",
            runtime=aws.lambda_.Runtime.NODE_JS20D_X,
            dead_letter_config={
                "target_arn": dlq["arn"],
            })
        # Event invoke configuration for retries
        example_function_event_invoke_config = aws.lambda_.FunctionEventInvokeConfig("example",
            function_name=example.name,
            maximum_event_age_in_seconds=60,
            maximum_retry_attempts=2,
            destination_config={
                "on_failure": {
                    "destination": dlq["arn"],
                },
                "on_success": {
                    "destination": success["arn"],
                },
            })
        ```

        ### CloudWatch Logging and Permissions

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        config = pulumi.Config()
        # Name of the Lambda function
        function_name = config.get("functionName")
        if function_name is None:
            function_name = "example_function"
        # CloudWatch Log Group with retention
        example = aws.cloudwatch.LogGroup("example",
            name=f"/aws/lambda/{function_name}",
            retention_in_days=14,
            tags={
                "Environment": "production",
                "Function": function_name,
            })
        # Lambda execution role
        example_role = aws.iam.Role("example",
            name="lambda_execution_role",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "lambda.amazonaws.com",
                    },
                }],
            }))
        # CloudWatch Logs policy
        lambda_logging = aws.iam.Policy("lambda_logging",
            name="lambda_logging",
            path="/",
            description="IAM policy for logging from Lambda",
            policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Effect": "Allow",
                    "Action": [
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents",
                    ],
                    "Resource": ["arn:aws:logs:*:*:*"],
                }],
            }))
        # Attach logging policy to Lambda role
        lambda_logs = aws.iam.RolePolicyAttachment("lambda_logs",
            role=example_role.name,
            policy_arn=lambda_logging.arn)
        # Lambda function with logging
        example_function = aws.lambda_.Function("example",
            code=pulumi.FileArchive("function.zip"),
            name=function_name,
            role=example_role.arn,
            handler="index.handler",
            runtime=aws.lambda_.Runtime.NODE_JS20D_X,
            logging_config={
                "log_format": "JSON",
                "application_log_level": "INFO",
                "system_log_level": "WARN",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    lambda_logs,
                    example,
                ]))
        ```

        ## Specifying the Deployment Package

        AWS Lambda expects source code to be provided as a deployment package whose structure varies depending on which `runtime` is in use. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for the valid values of `runtime`. The expected structure of the deployment package can be found in [the AWS Lambda documentation for each runtime](https://docs.aws.amazon.com/lambda/latest/dg/deployment-package-v2.html).

        Once you have created your deployment package you can specify it either directly as a local file (using the `filename` argument) or indirectly via Amazon S3 (using the `s3_bucket`, `s3_key` and `s3_object_version` arguments). When providing the deployment package via S3 it may be useful to use the `s3.BucketObjectv2` resource to upload it.

        For larger deployment packages it is recommended by Amazon to upload via S3, since the S3 API has better support for uploading large files efficiently.

        ## Import

        Using `pulumi import`, import Lambda Functions using the `function_name`. For example:

        ```sh
        $ pulumi import aws:lambda/function:Function example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] architectures: Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`. Default is `["x86_64"]`. Removing this attribute, function's architecture stays the same.
        :param pulumi.Input[pulumi.Archive] code: Path to the function's deployment package within the local filesystem. Conflicts with `image_uri` and `s3_bucket`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        :param pulumi.Input[builtins.str] code_signing_config_arn: ARN of a code-signing configuration to enable code signing for this function.
        :param pulumi.Input[Union['FunctionDeadLetterConfigArgs', 'FunctionDeadLetterConfigArgsDict']] dead_letter_config: Configuration block for dead letter queue. See below.
        :param pulumi.Input[builtins.str] description: Description of what your Lambda Function does.
        :param pulumi.Input[Union['FunctionEnvironmentArgs', 'FunctionEnvironmentArgsDict']] environment: Configuration block for environment variables. See below.
        :param pulumi.Input[Union['FunctionEphemeralStorageArgs', 'FunctionEphemeralStorageArgsDict']] ephemeral_storage: Amount of ephemeral storage (`/tmp`) to allocate for the Lambda Function. See below.
        :param pulumi.Input[Union['FunctionFileSystemConfigArgs', 'FunctionFileSystemConfigArgsDict']] file_system_config: Configuration block for EFS file system. See below.
        :param pulumi.Input[builtins.str] handler: Function entry point in your code. Required if `package_type` is `Zip`.
        :param pulumi.Input[Union['FunctionImageConfigArgs', 'FunctionImageConfigArgsDict']] image_config: Container image configuration values. See below.
        :param pulumi.Input[builtins.str] image_uri: ECR image URI containing the function's deployment package. Conflicts with `filename` and `s3_bucket`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        :param pulumi.Input[builtins.str] kms_key_arn: ARN of the AWS Key Management Service key used to encrypt environment variables. If not provided when environment variables are in use, AWS Lambda uses a default service key. If provided when environment variables are not in use, the AWS Lambda API does not save this configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] layers: List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function.
        :param pulumi.Input[Union['FunctionLoggingConfigArgs', 'FunctionLoggingConfigArgsDict']] logging_config: Configuration block for advanced logging settings. See below.
        :param pulumi.Input[builtins.int] memory_size: Amount of memory in MB your Lambda Function can use at runtime. Valid value between 128 MB to 10,240 MB (10 GB), in 1 MB increments. Defaults to 128.
        :param pulumi.Input[builtins.str] name: Unique name for your Lambda Function.
        :param pulumi.Input[builtins.str] package_type: Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
        :param pulumi.Input[builtins.bool] publish: Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] replace_security_groups_on_destroy: Whether to replace the security groups on the function's VPC configuration prior to destruction. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] replacement_security_group_ids: List of security group IDs to assign to the function's VPC configuration prior to destruction. Required if `replace_security_groups_on_destroy` is `true`.
        :param pulumi.Input[builtins.int] reserved_concurrent_executions: Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`.
        :param pulumi.Input[builtins.str] role: ARN of the function's execution role. The role provides the function's identity and access to AWS services and resources.
               
               The following arguments are optional:
        :param pulumi.Input[Union[builtins.str, 'Runtime']] runtime: Identifier of the function's runtime. Required if `package_type` is `Zip`. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
        :param pulumi.Input[builtins.str] s3_bucket: S3 bucket location containing the function's deployment package. Conflicts with `filename` and `image_uri`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        :param pulumi.Input[builtins.str] s3_key: S3 key of an object containing the function's deployment package. Required if `s3_bucket` is set.
        :param pulumi.Input[builtins.str] s3_object_version: Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
        :param pulumi.Input[builtins.bool] skip_destroy: Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`.
        :param pulumi.Input[Union['FunctionSnapStartArgs', 'FunctionSnapStartArgsDict']] snap_start: Configuration block for snap start settings. See below.
        :param pulumi.Input[builtins.str] source_code_hash: Base64-encoded SHA256 hash of the package file. Used to trigger updates when source code changes.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of tags for the Lambda function. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.int] timeout: Amount of time your Lambda Function has to run in seconds. Defaults to 3. Valid between 1 and 900.
        :param pulumi.Input[Union['FunctionTracingConfigArgs', 'FunctionTracingConfigArgsDict']] tracing_config: Configuration block for X-Ray tracing. See below.
        :param pulumi.Input[Union['FunctionVpcConfigArgs', 'FunctionVpcConfigArgsDict']] vpc_config: Configuration block for VPC. See below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Lambda Function. Use this resource to create serverless functions that run code in response to events without provisioning or managing servers.

        For information about Lambda and how to use it, see [What is AWS Lambda?](https://docs.aws.amazon.com/lambda/latest/dg/welcome.html). For a detailed example of setting up Lambda and API Gateway, see Serverless Applications with AWS Lambda and API Gateway.

        > **Note:** Due to [AWS Lambda improved VPC networking changes that began deploying in September 2019](https://aws.amazon.com/blogs/compute/announcing-improved-vpc-networking-for-aws-lambda-functions/), EC2 subnets and security groups associated with Lambda Functions can take up to 45 minutes to successfully delete. Pulumi AWS Provider version 2.31.0 and later automatically handles this increased timeout, however prior versions require setting the customizable deletion timeouts of those Pulumi resources to 45 minutes (`delete = "45m"`). AWS and HashiCorp are working together to reduce the amount of time required for resource deletion and updates can be tracked in this GitHub issue.

        > **Note:** If you get a `KMSAccessDeniedException: Lambda was unable to decrypt the environment variables because KMS access was denied` error when invoking an `lambda.Function` with environment variables, the IAM role associated with the function may have been deleted and recreated after the function was created. You can fix the problem two ways: 1) updating the function's role to another role and then updating it back again to the recreated role. (When you create a function, Lambda grants permissions on the KMS key to the function's IAM role. If the IAM role is recreated, the grant is no longer valid. Changing the function's role or recreating the function causes Lambda to update the grant.)

        > **Tip:** To give an external source (like an EventBridge Rule, SNS, or S3) permission to access the Lambda function, use the `lambda.Permission` resource. See [Lambda Permission Model](https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html) for more details. On the other hand, the `role` argument of this resource is the function's execution role for identity and access to AWS services and resources.

        ## Example Usage

        ### Container Image Function

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.Function("example",
            name="example_container_function",
            role=example_aws_iam_role["arn"],
            package_type="Image",
            image_uri=f"{example_aws_ecr_repository['repositoryUrl']}:latest",
            image_config={
                "entry_points": ["/lambda-entrypoint.sh"],
                "commands": ["app.handler"],
            },
            memory_size=512,
            timeout=30,
            architectures=["arm64"])
        ```

        ### Function with Lambda Layers

        > **Note:** The `lambda.LayerVersion` attribute values for `arn` and `layer_arn` were swapped in version 2.0.0 of the Pulumi AWS Provider. For version 2.x, use `arn` references.

        ```python
        import pulumi
        import pulumi_aws as aws

        # Common dependencies layer
        example = aws.lambda_.LayerVersion("example",
            code=pulumi.FileArchive("layer.zip"),
            layer_name="example_dependencies_layer",
            description="Common dependencies for Lambda functions",
            compatible_runtimes=[
                "nodejs20.x",
                "python3.12",
            ],
            compatible_architectures=[
                "x86_64",
                "arm64",
            ])
        # Function using the layer
        example_function = aws.lambda_.Function("example",
            code=pulumi.FileArchive("function.zip"),
            name="example_layered_function",
            role=example_aws_iam_role["arn"],
            handler="index.handler",
            runtime=aws.lambda_.Runtime.NODE_JS20D_X,
            layers=[example.arn],
            tracing_config={
                "mode": "Active",
            })
        ```

        ### VPC Function with Enhanced Networking

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.Function("example",
            code=pulumi.FileArchive("function.zip"),
            name="example_vpc_function",
            role=example_aws_iam_role["arn"],
            handler="app.handler",
            runtime=aws.lambda_.Runtime.PYTHON3D12,
            memory_size=1024,
            timeout=30,
            vpc_config={
                "subnet_ids": [
                    example_private1["id"],
                    example_private2["id"],
                ],
                "security_group_ids": [example_lambda["id"]],
                "ipv6_allowed_for_dual_stack": True,
            },
            ephemeral_storage={
                "size": 5120,
            },
            snap_start={
                "apply_on": "PublishedVersions",
            })
        ```

        ### Function with EFS Integration

        ```python
        import pulumi
        import pulumi_aws as aws

        # EFS file system for Lambda
        example = aws.efs.FileSystem("example",
            encrypted=True,
            tags={
                "Name": "lambda-efs",
            })
        config = pulumi.Config()
        # List of subnet IDs for EFS mount targets
        subnet_ids = config.get_object("subnetIds")
        if subnet_ids is None:
            subnet_ids = [
                "subnet-12345678",
                "subnet-87654321",
            ]
        # Mount target in each subnet
        example_mount_target = []
        for range in [{"value": i} for i in range(0, len(subnet_ids))]:
            example_mount_target.append(aws.efs.MountTarget(f"example-{range['value']}",
                file_system_id=example.id,
                subnet_id=subnet_ids[range["value"]],
                security_groups=[efs["id"]]))
        # Access point for Lambda
        example_access_point = aws.efs.AccessPoint("example",
            file_system_id=example.id,
            root_directory={
                "path": "/lambda",
                "creation_info": {
                    "owner_gid": 1000,
                    "owner_uid": 1000,
                    "permissions": "755",
                },
            },
            posix_user={
                "gid": 1000,
                "uid": 1000,
            })
        # Lambda function with EFS
        example_function = aws.lambda_.Function("example",
            code=pulumi.FileArchive("function.zip"),
            name="example_efs_function",
            role=example_aws_iam_role["arn"],
            handler="index.handler",
            runtime=aws.lambda_.Runtime.NODE_JS20D_X,
            vpc_config={
                "subnet_ids": subnet_ids,
                "security_group_ids": [lambda_["id"]],
            },
            file_system_config={
                "arn": example_access_point.arn,
                "local_mount_path": "/mnt/data",
            },
            opts = pulumi.ResourceOptions(depends_on=[example_mount_target]))
        ```

        ### Function with Advanced Logging

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudwatch.LogGroup("example",
            name="/aws/lambda/example_function",
            retention_in_days=14,
            tags={
                "Environment": "production",
                "Application": "example",
            })
        example_function = aws.lambda_.Function("example",
            code=pulumi.FileArchive("function.zip"),
            name="example_function",
            role=example_aws_iam_role["arn"],
            handler="index.handler",
            runtime=aws.lambda_.Runtime.NODE_JS20D_X,
            logging_config={
                "log_format": "JSON",
                "application_log_level": "INFO",
                "system_log_level": "WARN",
            },
            opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ### Function with Error Handling

        ```python
        import pulumi
        import pulumi_aws as aws

        # Main Lambda function
        example = aws.lambda_.Function("example",
            code=pulumi.FileArchive("function.zip"),
            name="example_function",
            role=example_aws_iam_role["arn"],
            handler="index.handler",
            runtime=aws.lambda_.Runtime.NODE_JS20D_X,
            dead_letter_config={
                "target_arn": dlq["arn"],
            })
        # Event invoke configuration for retries
        example_function_event_invoke_config = aws.lambda_.FunctionEventInvokeConfig("example",
            function_name=example.name,
            maximum_event_age_in_seconds=60,
            maximum_retry_attempts=2,
            destination_config={
                "on_failure": {
                    "destination": dlq["arn"],
                },
                "on_success": {
                    "destination": success["arn"],
                },
            })
        ```

        ### CloudWatch Logging and Permissions

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        config = pulumi.Config()
        # Name of the Lambda function
        function_name = config.get("functionName")
        if function_name is None:
            function_name = "example_function"
        # CloudWatch Log Group with retention
        example = aws.cloudwatch.LogGroup("example",
            name=f"/aws/lambda/{function_name}",
            retention_in_days=14,
            tags={
                "Environment": "production",
                "Function": function_name,
            })
        # Lambda execution role
        example_role = aws.iam.Role("example",
            name="lambda_execution_role",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "lambda.amazonaws.com",
                    },
                }],
            }))
        # CloudWatch Logs policy
        lambda_logging = aws.iam.Policy("lambda_logging",
            name="lambda_logging",
            path="/",
            description="IAM policy for logging from Lambda",
            policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Effect": "Allow",
                    "Action": [
                        "logs:CreateLogGroup",
                        "logs:CreateLogStream",
                        "logs:PutLogEvents",
                    ],
                    "Resource": ["arn:aws:logs:*:*:*"],
                }],
            }))
        # Attach logging policy to Lambda role
        lambda_logs = aws.iam.RolePolicyAttachment("lambda_logs",
            role=example_role.name,
            policy_arn=lambda_logging.arn)
        # Lambda function with logging
        example_function = aws.lambda_.Function("example",
            code=pulumi.FileArchive("function.zip"),
            name=function_name,
            role=example_role.arn,
            handler="index.handler",
            runtime=aws.lambda_.Runtime.NODE_JS20D_X,
            logging_config={
                "log_format": "JSON",
                "application_log_level": "INFO",
                "system_log_level": "WARN",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    lambda_logs,
                    example,
                ]))
        ```

        ## Specifying the Deployment Package

        AWS Lambda expects source code to be provided as a deployment package whose structure varies depending on which `runtime` is in use. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for the valid values of `runtime`. The expected structure of the deployment package can be found in [the AWS Lambda documentation for each runtime](https://docs.aws.amazon.com/lambda/latest/dg/deployment-package-v2.html).

        Once you have created your deployment package you can specify it either directly as a local file (using the `filename` argument) or indirectly via Amazon S3 (using the `s3_bucket`, `s3_key` and `s3_object_version` arguments). When providing the deployment package via S3 it may be useful to use the `s3.BucketObjectv2` resource to upload it.

        For larger deployment packages it is recommended by Amazon to upload via S3, since the S3 API has better support for uploading large files efficiently.

        ## Import

        Using `pulumi import`, import Lambda Functions using the `function_name`. For example:

        ```sh
        $ pulumi import aws:lambda/function:Function example example
        ```

        :param str resource_name: The name of the resource.
        :param FunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architectures: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 code: Optional[pulumi.Input[pulumi.Archive]] = None,
                 code_signing_config_arn: Optional[pulumi.Input[builtins.str]] = None,
                 dead_letter_config: Optional[pulumi.Input[Union['FunctionDeadLetterConfigArgs', 'FunctionDeadLetterConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['FunctionEnvironmentArgs', 'FunctionEnvironmentArgsDict']]] = None,
                 ephemeral_storage: Optional[pulumi.Input[Union['FunctionEphemeralStorageArgs', 'FunctionEphemeralStorageArgsDict']]] = None,
                 file_system_config: Optional[pulumi.Input[Union['FunctionFileSystemConfigArgs', 'FunctionFileSystemConfigArgsDict']]] = None,
                 handler: Optional[pulumi.Input[builtins.str]] = None,
                 image_config: Optional[pulumi.Input[Union['FunctionImageConfigArgs', 'FunctionImageConfigArgsDict']]] = None,
                 image_uri: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 logging_config: Optional[pulumi.Input[Union['FunctionLoggingConfigArgs', 'FunctionLoggingConfigArgsDict']]] = None,
                 memory_size: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 package_type: Optional[pulumi.Input[builtins.str]] = None,
                 publish: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replace_security_groups_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 replacement_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 reserved_concurrent_executions: Optional[pulumi.Input[builtins.int]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 runtime: Optional[pulumi.Input[Union[builtins.str, 'Runtime']]] = None,
                 s3_bucket: Optional[pulumi.Input[builtins.str]] = None,
                 s3_key: Optional[pulumi.Input[builtins.str]] = None,
                 s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
                 skip_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 snap_start: Optional[pulumi.Input[Union['FunctionSnapStartArgs', 'FunctionSnapStartArgsDict']]] = None,
                 source_code_hash: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 tracing_config: Optional[pulumi.Input[Union['FunctionTracingConfigArgs', 'FunctionTracingConfigArgsDict']]] = None,
                 vpc_config: Optional[pulumi.Input[Union['FunctionVpcConfigArgs', 'FunctionVpcConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionArgs.__new__(FunctionArgs)

            __props__.__dict__["architectures"] = architectures
            __props__.__dict__["code"] = code
            __props__.__dict__["code_signing_config_arn"] = code_signing_config_arn
            __props__.__dict__["dead_letter_config"] = dead_letter_config
            __props__.__dict__["description"] = description
            __props__.__dict__["environment"] = environment
            __props__.__dict__["ephemeral_storage"] = ephemeral_storage
            __props__.__dict__["file_system_config"] = file_system_config
            __props__.__dict__["handler"] = handler
            __props__.__dict__["image_config"] = image_config
            __props__.__dict__["image_uri"] = image_uri
            __props__.__dict__["kms_key_arn"] = kms_key_arn
            __props__.__dict__["layers"] = layers
            __props__.__dict__["logging_config"] = logging_config
            __props__.__dict__["memory_size"] = memory_size
            __props__.__dict__["name"] = name
            __props__.__dict__["package_type"] = package_type
            __props__.__dict__["publish"] = publish
            __props__.__dict__["region"] = region
            __props__.__dict__["replace_security_groups_on_destroy"] = replace_security_groups_on_destroy
            __props__.__dict__["replacement_security_group_ids"] = replacement_security_group_ids
            __props__.__dict__["reserved_concurrent_executions"] = reserved_concurrent_executions
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["s3_bucket"] = s3_bucket
            __props__.__dict__["s3_key"] = s3_key
            __props__.__dict__["s3_object_version"] = s3_object_version
            __props__.__dict__["skip_destroy"] = skip_destroy
            __props__.__dict__["snap_start"] = snap_start
            __props__.__dict__["source_code_hash"] = source_code_hash
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["tracing_config"] = tracing_config
            __props__.__dict__["vpc_config"] = vpc_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["code_sha256"] = None
            __props__.__dict__["invoke_arn"] = None
            __props__.__dict__["last_modified"] = None
            __props__.__dict__["qualified_arn"] = None
            __props__.__dict__["qualified_invoke_arn"] = None
            __props__.__dict__["signing_job_arn"] = None
            __props__.__dict__["signing_profile_version_arn"] = None
            __props__.__dict__["source_code_size"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["version"] = None
        super(Function, __self__).__init__(
            'aws:lambda/function:Function',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            architectures: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            code: Optional[pulumi.Input[pulumi.Archive]] = None,
            code_sha256: Optional[pulumi.Input[builtins.str]] = None,
            code_signing_config_arn: Optional[pulumi.Input[builtins.str]] = None,
            dead_letter_config: Optional[pulumi.Input[Union['FunctionDeadLetterConfigArgs', 'FunctionDeadLetterConfigArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            environment: Optional[pulumi.Input[Union['FunctionEnvironmentArgs', 'FunctionEnvironmentArgsDict']]] = None,
            ephemeral_storage: Optional[pulumi.Input[Union['FunctionEphemeralStorageArgs', 'FunctionEphemeralStorageArgsDict']]] = None,
            file_system_config: Optional[pulumi.Input[Union['FunctionFileSystemConfigArgs', 'FunctionFileSystemConfigArgsDict']]] = None,
            handler: Optional[pulumi.Input[builtins.str]] = None,
            image_config: Optional[pulumi.Input[Union['FunctionImageConfigArgs', 'FunctionImageConfigArgsDict']]] = None,
            image_uri: Optional[pulumi.Input[builtins.str]] = None,
            invoke_arn: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
            last_modified: Optional[pulumi.Input[builtins.str]] = None,
            layers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            logging_config: Optional[pulumi.Input[Union['FunctionLoggingConfigArgs', 'FunctionLoggingConfigArgsDict']]] = None,
            memory_size: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            package_type: Optional[pulumi.Input[builtins.str]] = None,
            publish: Optional[pulumi.Input[builtins.bool]] = None,
            qualified_arn: Optional[pulumi.Input[builtins.str]] = None,
            qualified_invoke_arn: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            replace_security_groups_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            replacement_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            reserved_concurrent_executions: Optional[pulumi.Input[builtins.int]] = None,
            role: Optional[pulumi.Input[builtins.str]] = None,
            runtime: Optional[pulumi.Input[Union[builtins.str, 'Runtime']]] = None,
            s3_bucket: Optional[pulumi.Input[builtins.str]] = None,
            s3_key: Optional[pulumi.Input[builtins.str]] = None,
            s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
            signing_job_arn: Optional[pulumi.Input[builtins.str]] = None,
            signing_profile_version_arn: Optional[pulumi.Input[builtins.str]] = None,
            skip_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            snap_start: Optional[pulumi.Input[Union['FunctionSnapStartArgs', 'FunctionSnapStartArgsDict']]] = None,
            source_code_hash: Optional[pulumi.Input[builtins.str]] = None,
            source_code_size: Optional[pulumi.Input[builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeout: Optional[pulumi.Input[builtins.int]] = None,
            tracing_config: Optional[pulumi.Input[Union['FunctionTracingConfigArgs', 'FunctionTracingConfigArgsDict']]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None,
            vpc_config: Optional[pulumi.Input[Union['FunctionVpcConfigArgs', 'FunctionVpcConfigArgsDict']]] = None) -> 'Function':
        """
        Get an existing Function resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] architectures: Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`. Default is `["x86_64"]`. Removing this attribute, function's architecture stays the same.
        :param pulumi.Input[builtins.str] arn: ARN identifying your Lambda Function.
        :param pulumi.Input[pulumi.Archive] code: Path to the function's deployment package within the local filesystem. Conflicts with `image_uri` and `s3_bucket`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        :param pulumi.Input[builtins.str] code_sha256: Base64-encoded representation of raw SHA-256 sum of the zip file.
        :param pulumi.Input[builtins.str] code_signing_config_arn: ARN of a code-signing configuration to enable code signing for this function.
        :param pulumi.Input[Union['FunctionDeadLetterConfigArgs', 'FunctionDeadLetterConfigArgsDict']] dead_letter_config: Configuration block for dead letter queue. See below.
        :param pulumi.Input[builtins.str] description: Description of what your Lambda Function does.
        :param pulumi.Input[Union['FunctionEnvironmentArgs', 'FunctionEnvironmentArgsDict']] environment: Configuration block for environment variables. See below.
        :param pulumi.Input[Union['FunctionEphemeralStorageArgs', 'FunctionEphemeralStorageArgsDict']] ephemeral_storage: Amount of ephemeral storage (`/tmp`) to allocate for the Lambda Function. See below.
        :param pulumi.Input[Union['FunctionFileSystemConfigArgs', 'FunctionFileSystemConfigArgsDict']] file_system_config: Configuration block for EFS file system. See below.
        :param pulumi.Input[builtins.str] handler: Function entry point in your code. Required if `package_type` is `Zip`.
        :param pulumi.Input[Union['FunctionImageConfigArgs', 'FunctionImageConfigArgsDict']] image_config: Container image configuration values. See below.
        :param pulumi.Input[builtins.str] image_uri: ECR image URI containing the function's deployment package. Conflicts with `filename` and `s3_bucket`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        :param pulumi.Input[builtins.str] invoke_arn: ARN to be used for invoking Lambda Function from API Gateway - to be used in `apigateway.Integration`'s `uri`.
        :param pulumi.Input[builtins.str] kms_key_arn: ARN of the AWS Key Management Service key used to encrypt environment variables. If not provided when environment variables are in use, AWS Lambda uses a default service key. If provided when environment variables are not in use, the AWS Lambda API does not save this configuration.
        :param pulumi.Input[builtins.str] last_modified: Date this resource was last modified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] layers: List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function.
        :param pulumi.Input[Union['FunctionLoggingConfigArgs', 'FunctionLoggingConfigArgsDict']] logging_config: Configuration block for advanced logging settings. See below.
        :param pulumi.Input[builtins.int] memory_size: Amount of memory in MB your Lambda Function can use at runtime. Valid value between 128 MB to 10,240 MB (10 GB), in 1 MB increments. Defaults to 128.
        :param pulumi.Input[builtins.str] name: Unique name for your Lambda Function.
        :param pulumi.Input[builtins.str] package_type: Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
        :param pulumi.Input[builtins.bool] publish: Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
        :param pulumi.Input[builtins.str] qualified_arn: ARN identifying your Lambda Function Version (if versioning is enabled via `publish = true`).
        :param pulumi.Input[builtins.str] qualified_invoke_arn: Qualified ARN (ARN with lambda version number) to be used for invoking Lambda Function from API Gateway - to be used in `apigateway.Integration`'s `uri`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] replace_security_groups_on_destroy: Whether to replace the security groups on the function's VPC configuration prior to destruction. Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] replacement_security_group_ids: List of security group IDs to assign to the function's VPC configuration prior to destruction. Required if `replace_security_groups_on_destroy` is `true`.
        :param pulumi.Input[builtins.int] reserved_concurrent_executions: Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`.
        :param pulumi.Input[builtins.str] role: ARN of the function's execution role. The role provides the function's identity and access to AWS services and resources.
               
               The following arguments are optional:
        :param pulumi.Input[Union[builtins.str, 'Runtime']] runtime: Identifier of the function's runtime. Required if `package_type` is `Zip`. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
        :param pulumi.Input[builtins.str] s3_bucket: S3 bucket location containing the function's deployment package. Conflicts with `filename` and `image_uri`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        :param pulumi.Input[builtins.str] s3_key: S3 key of an object containing the function's deployment package. Required if `s3_bucket` is set.
        :param pulumi.Input[builtins.str] s3_object_version: Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
        :param pulumi.Input[builtins.str] signing_job_arn: ARN of the signing job.
        :param pulumi.Input[builtins.str] signing_profile_version_arn: ARN of the signing profile version.
        :param pulumi.Input[builtins.bool] skip_destroy: Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`.
        :param pulumi.Input[Union['FunctionSnapStartArgs', 'FunctionSnapStartArgsDict']] snap_start: Configuration block for snap start settings. See below.
        :param pulumi.Input[builtins.str] source_code_hash: Base64-encoded SHA256 hash of the package file. Used to trigger updates when source code changes.
        :param pulumi.Input[builtins.int] source_code_size: Size in bytes of the function .zip file.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of tags for the Lambda function. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.int] timeout: Amount of time your Lambda Function has to run in seconds. Defaults to 3. Valid between 1 and 900.
        :param pulumi.Input[Union['FunctionTracingConfigArgs', 'FunctionTracingConfigArgsDict']] tracing_config: Configuration block for X-Ray tracing. See below.
        :param pulumi.Input[builtins.str] version: Latest published version of your Lambda Function.
        :param pulumi.Input[Union['FunctionVpcConfigArgs', 'FunctionVpcConfigArgsDict']] vpc_config: Configuration block for VPC. See below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionState.__new__(_FunctionState)

        __props__.__dict__["architectures"] = architectures
        __props__.__dict__["arn"] = arn
        __props__.__dict__["code"] = code
        __props__.__dict__["code_sha256"] = code_sha256
        __props__.__dict__["code_signing_config_arn"] = code_signing_config_arn
        __props__.__dict__["dead_letter_config"] = dead_letter_config
        __props__.__dict__["description"] = description
        __props__.__dict__["environment"] = environment
        __props__.__dict__["ephemeral_storage"] = ephemeral_storage
        __props__.__dict__["file_system_config"] = file_system_config
        __props__.__dict__["handler"] = handler
        __props__.__dict__["image_config"] = image_config
        __props__.__dict__["image_uri"] = image_uri
        __props__.__dict__["invoke_arn"] = invoke_arn
        __props__.__dict__["kms_key_arn"] = kms_key_arn
        __props__.__dict__["last_modified"] = last_modified
        __props__.__dict__["layers"] = layers
        __props__.__dict__["logging_config"] = logging_config
        __props__.__dict__["memory_size"] = memory_size
        __props__.__dict__["name"] = name
        __props__.__dict__["package_type"] = package_type
        __props__.__dict__["publish"] = publish
        __props__.__dict__["qualified_arn"] = qualified_arn
        __props__.__dict__["qualified_invoke_arn"] = qualified_invoke_arn
        __props__.__dict__["region"] = region
        __props__.__dict__["replace_security_groups_on_destroy"] = replace_security_groups_on_destroy
        __props__.__dict__["replacement_security_group_ids"] = replacement_security_group_ids
        __props__.__dict__["reserved_concurrent_executions"] = reserved_concurrent_executions
        __props__.__dict__["role"] = role
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["s3_bucket"] = s3_bucket
        __props__.__dict__["s3_key"] = s3_key
        __props__.__dict__["s3_object_version"] = s3_object_version
        __props__.__dict__["signing_job_arn"] = signing_job_arn
        __props__.__dict__["signing_profile_version_arn"] = signing_profile_version_arn
        __props__.__dict__["skip_destroy"] = skip_destroy
        __props__.__dict__["snap_start"] = snap_start
        __props__.__dict__["source_code_hash"] = source_code_hash
        __props__.__dict__["source_code_size"] = source_code_size
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["tracing_config"] = tracing_config
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_config"] = vpc_config
        return Function(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def architectures(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`. Default is `["x86_64"]`. Removing this attribute, function's architecture stays the same.
        """
        return pulumi.get(self, "architectures")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN identifying your Lambda Function.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def code(self) -> pulumi.Output[Optional[pulumi.Archive]]:
        """
        Path to the function's deployment package within the local filesystem. Conflicts with `image_uri` and `s3_bucket`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="codeSha256")
    def code_sha256(self) -> pulumi.Output[builtins.str]:
        """
        Base64-encoded representation of raw SHA-256 sum of the zip file.
        """
        return pulumi.get(self, "code_sha256")

    @property
    @pulumi.getter(name="codeSigningConfigArn")
    def code_signing_config_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ARN of a code-signing configuration to enable code signing for this function.
        """
        return pulumi.get(self, "code_signing_config_arn")

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> pulumi.Output[Optional['outputs.FunctionDeadLetterConfig']]:
        """
        Configuration block for dead letter queue. See below.
        """
        return pulumi.get(self, "dead_letter_config")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of what your Lambda Function does.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional['outputs.FunctionEnvironment']]:
        """
        Configuration block for environment variables. See below.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> pulumi.Output['outputs.FunctionEphemeralStorage']:
        """
        Amount of ephemeral storage (`/tmp`) to allocate for the Lambda Function. See below.
        """
        return pulumi.get(self, "ephemeral_storage")

    @property
    @pulumi.getter(name="fileSystemConfig")
    def file_system_config(self) -> pulumi.Output[Optional['outputs.FunctionFileSystemConfig']]:
        """
        Configuration block for EFS file system. See below.
        """
        return pulumi.get(self, "file_system_config")

    @property
    @pulumi.getter
    def handler(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Function entry point in your code. Required if `package_type` is `Zip`.
        """
        return pulumi.get(self, "handler")

    @property
    @pulumi.getter(name="imageConfig")
    def image_config(self) -> pulumi.Output[Optional['outputs.FunctionImageConfig']]:
        """
        Container image configuration values. See below.
        """
        return pulumi.get(self, "image_config")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ECR image URI containing the function's deployment package. Conflicts with `filename` and `s3_bucket`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter(name="invokeArn")
    def invoke_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN to be used for invoking Lambda Function from API Gateway - to be used in `apigateway.Integration`'s `uri`.
        """
        return pulumi.get(self, "invoke_arn")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ARN of the AWS Key Management Service key used to encrypt environment variables. If not provided when environment variables are in use, AWS Lambda uses a default service key. If provided when environment variables are not in use, the AWS Lambda API does not save this configuration.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[builtins.str]:
        """
        Date this resource was last modified.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter
    def layers(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function.
        """
        return pulumi.get(self, "layers")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> pulumi.Output['outputs.FunctionLoggingConfig']:
        """
        Configuration block for advanced logging settings. See below.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Amount of memory in MB your Lambda Function can use at runtime. Valid value between 128 MB to 10,240 MB (10 GB), in 1 MB increments. Defaults to 128.
        """
        return pulumi.get(self, "memory_size")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Unique name for your Lambda Function.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter
    def publish(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
        """
        return pulumi.get(self, "publish")

    @property
    @pulumi.getter(name="qualifiedArn")
    def qualified_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN identifying your Lambda Function Version (if versioning is enabled via `publish = true`).
        """
        return pulumi.get(self, "qualified_arn")

    @property
    @pulumi.getter(name="qualifiedInvokeArn")
    def qualified_invoke_arn(self) -> pulumi.Output[builtins.str]:
        """
        Qualified ARN (ARN with lambda version number) to be used for invoking Lambda Function from API Gateway - to be used in `apigateway.Integration`'s `uri`.
        """
        return pulumi.get(self, "qualified_invoke_arn")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replaceSecurityGroupsOnDestroy")
    def replace_security_groups_on_destroy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to replace the security groups on the function's VPC configuration prior to destruction. Default is `false`.
        """
        return pulumi.get(self, "replace_security_groups_on_destroy")

    @property
    @pulumi.getter(name="replacementSecurityGroupIds")
    def replacement_security_group_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of security group IDs to assign to the function's VPC configuration prior to destruction. Required if `replace_security_groups_on_destroy` is `true`.
        """
        return pulumi.get(self, "replacement_security_group_ids")

    @property
    @pulumi.getter(name="reservedConcurrentExecutions")
    def reserved_concurrent_executions(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`.
        """
        return pulumi.get(self, "reserved_concurrent_executions")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the function's execution role. The role provides the function's identity and access to AWS services and resources.

        The following arguments are optional:
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier of the function's runtime. Required if `package_type` is `Zip`. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        S3 bucket location containing the function's deployment package. Conflicts with `filename` and `image_uri`. One of `filename`, `image_uri`, or `s3_bucket` must be specified.
        """
        return pulumi.get(self, "s3_bucket")

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        S3 key of an object containing the function's deployment package. Required if `s3_bucket` is set.
        """
        return pulumi.get(self, "s3_key")

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
        """
        return pulumi.get(self, "s3_object_version")

    @property
    @pulumi.getter(name="signingJobArn")
    def signing_job_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the signing job.
        """
        return pulumi.get(self, "signing_job_arn")

    @property
    @pulumi.getter(name="signingProfileVersionArn")
    def signing_profile_version_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the signing profile version.
        """
        return pulumi.get(self, "signing_profile_version_arn")

    @property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`.
        """
        return pulumi.get(self, "skip_destroy")

    @property
    @pulumi.getter(name="snapStart")
    def snap_start(self) -> pulumi.Output[Optional['outputs.FunctionSnapStart']]:
        """
        Configuration block for snap start settings. See below.
        """
        return pulumi.get(self, "snap_start")

    @property
    @pulumi.getter(name="sourceCodeHash")
    def source_code_hash(self) -> pulumi.Output[builtins.str]:
        """
        Base64-encoded SHA256 hash of the package file. Used to trigger updates when source code changes.
        """
        return pulumi.get(self, "source_code_hash")

    @property
    @pulumi.getter(name="sourceCodeSize")
    def source_code_size(self) -> pulumi.Output[builtins.int]:
        """
        Size in bytes of the function .zip file.
        """
        return pulumi.get(self, "source_code_size")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value map of tags for the Lambda function. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Amount of time your Lambda Function has to run in seconds. Defaults to 3. Valid between 1 and 900.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="tracingConfig")
    def tracing_config(self) -> pulumi.Output['outputs.FunctionTracingConfig']:
        """
        Configuration block for X-Ray tracing. See below.
        """
        return pulumi.get(self, "tracing_config")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        Latest published version of your Lambda Function.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Output[Optional['outputs.FunctionVpcConfig']]:
        """
        Configuration block for VPC. See below.
        """
        return pulumi.get(self, "vpc_config")

