# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InvocationArgs', 'Invocation']

@pulumi.input_type
class InvocationArgs:
    def __init__(__self__, *,
                 function_name: pulumi.Input[builtins.str],
                 input: pulumi.Input[builtins.str],
                 lifecycle_scope: Optional[pulumi.Input[builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 terraform_key: Optional[pulumi.Input[builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Invocation resource.
        :param pulumi.Input[builtins.str] function_name: Name of the Lambda function.
        :param pulumi.Input[builtins.str] input: JSON payload to the Lambda function.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] lifecycle_scope: Lifecycle scope of the resource to manage. Valid values are `CREATE_ONLY` and `CRUD`. Defaults to `CREATE_ONLY`. `CREATE_ONLY` will invoke the function only on creation or replacement. `CRUD` will invoke the function on each lifecycle event, and augment the input JSON payload with additional lifecycle information.
        :param pulumi.Input[builtins.str] qualifier: Qualifier (i.e., version) of the Lambda function. Defaults to `$LATEST`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] triggers: Map of arbitrary keys and values that, when changed, will trigger a re-invocation.
        """
        pulumi.set(__self__, "function_name", function_name)
        pulumi.set(__self__, "input", input)
        if lifecycle_scope is not None:
            pulumi.set(__self__, "lifecycle_scope", lifecycle_scope)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if terraform_key is not None:
            pulumi.set(__self__, "terraform_key", terraform_key)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the Lambda function.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter
    def input(self) -> pulumi.Input[builtins.str]:
        """
        JSON payload to the Lambda function.

        The following arguments are optional:
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter(name="lifecycleScope")
    def lifecycle_scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lifecycle scope of the resource to manage. Valid values are `CREATE_ONLY` and `CRUD`. Defaults to `CREATE_ONLY`. `CREATE_ONLY` will invoke the function only on creation or replacement. `CRUD` will invoke the function on each lifecycle event, and augment the input JSON payload with additional lifecycle information.
        """
        return pulumi.get(self, "lifecycle_scope")

    @lifecycle_scope.setter
    def lifecycle_scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_scope", value)

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Qualifier (i.e., version) of the Lambda function. Defaults to `$LATEST`.
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "qualifier", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="terraformKey")
    def terraform_key(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "terraform_key")

    @terraform_key.setter
    def terraform_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "terraform_key", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of arbitrary keys and values that, when changed, will trigger a re-invocation.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "triggers", value)


@pulumi.input_type
class _InvocationState:
    def __init__(__self__, *,
                 function_name: Optional[pulumi.Input[builtins.str]] = None,
                 input: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_scope: Optional[pulumi.Input[builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 result: Optional[pulumi.Input[builtins.str]] = None,
                 terraform_key: Optional[pulumi.Input[builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Invocation resources.
        :param pulumi.Input[builtins.str] function_name: Name of the Lambda function.
        :param pulumi.Input[builtins.str] input: JSON payload to the Lambda function.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] lifecycle_scope: Lifecycle scope of the resource to manage. Valid values are `CREATE_ONLY` and `CRUD`. Defaults to `CREATE_ONLY`. `CREATE_ONLY` will invoke the function only on creation or replacement. `CRUD` will invoke the function on each lifecycle event, and augment the input JSON payload with additional lifecycle information.
        :param pulumi.Input[builtins.str] qualifier: Qualifier (i.e., version) of the Lambda function. Defaults to `$LATEST`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] result: String result of the Lambda function invocation.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] triggers: Map of arbitrary keys and values that, when changed, will trigger a re-invocation.
        """
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if lifecycle_scope is not None:
            pulumi.set(__self__, "lifecycle_scope", lifecycle_scope)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if result is not None:
            pulumi.set(__self__, "result", result)
        if terraform_key is not None:
            pulumi.set(__self__, "terraform_key", terraform_key)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Lambda function.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        JSON payload to the Lambda function.

        The following arguments are optional:
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter(name="lifecycleScope")
    def lifecycle_scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lifecycle scope of the resource to manage. Valid values are `CREATE_ONLY` and `CRUD`. Defaults to `CREATE_ONLY`. `CREATE_ONLY` will invoke the function only on creation or replacement. `CRUD` will invoke the function on each lifecycle event, and augment the input JSON payload with additional lifecycle information.
        """
        return pulumi.get(self, "lifecycle_scope")

    @lifecycle_scope.setter
    def lifecycle_scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_scope", value)

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Qualifier (i.e., version) of the Lambda function. Defaults to `$LATEST`.
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "qualifier", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def result(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        String result of the Lambda function invocation.
        """
        return pulumi.get(self, "result")

    @result.setter
    def result(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "result", value)

    @property
    @pulumi.getter(name="terraformKey")
    def terraform_key(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "terraform_key")

    @terraform_key.setter
    def terraform_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "terraform_key", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of arbitrary keys and values that, when changed, will trigger a re-invocation.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "triggers", value)


@pulumi.type_token("aws:lambda/invocation:Invocation")
class Invocation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 function_name: Optional[pulumi.Input[builtins.str]] = None,
                 input: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_scope: Optional[pulumi.Input[builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 terraform_key: Optional[pulumi.Input[builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an AWS Lambda Function invocation. Use this resource to invoke a Lambda function with the [RequestResponse](https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax) invocation type.

        > **Note:** By default this resource _only_ invokes the function when the arguments call for a create or replace. After an initial invocation on _apply_, if the arguments do not change, a subsequent _apply_ does not invoke the function again. To dynamically invoke the function, see the `triggers` example below. To always invoke a function on each _apply_, see the `lambda.Invocation` data source. To invoke the Lambda function when the Pulumi resource is updated and deleted, see the CRUD Lifecycle Management example below.

        > **Note:** If you get a `KMSAccessDeniedException: Lambda was unable to decrypt the environment variables because KMS access was denied` error when invoking a Lambda function with environment variables, the IAM role associated with the function may have been deleted and recreated after the function was created. You can fix the problem two ways: 1) updating the function's role to another role and then updating it back again to the recreated role. (When you create a function, Lambda grants permissions on the KMS key to the function's IAM role. If the IAM role is recreated, the grant is no longer valid. Changing the function's role or recreating the function causes Lambda to update the grant.)

        ## Example Usage

        ### Dynamic Invocation with Triggers

        ```python
        import pulumi
        import json
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.lambda_.Invocation("example",
            function_name=example_aws_lambda_function["functionName"],
            triggers={
                "function_version": example_aws_lambda_function["version"],
                "config_hash": std.sha256_output(input=json.dumps({
                    "environment": environment,
                    "timestamp": std.timestamp().result,
                })).apply(lambda invoke: invoke.result),
            },
            input=json.dumps({
                "operation": "process_data",
                "environment": environment,
                "batch_id": batch_id["result"],
            }))
        ```

        ### CRUD Lifecycle Management

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.lambda_.Invocation("example",
            function_name=example_aws_lambda_function["functionName"],
            input=json.dumps({
                "resource_name": "database_setup",
                "database_url": example_aws_db_instance["endpoint"],
                "credentials": {
                    "username": db_username,
                    "password": db_password,
                },
            }),
            lifecycle_scope="CRUD")
        ```

        > **Note:** `lifecycle_scope = "CRUD"` will inject a key `tf` in the input event to pass lifecycle information! This allows the Lambda function to handle different lifecycle transitions uniquely. If you need to use a key `tf` in your own input JSON, the default key name can be overridden with the `pulumi_key` argument.

        The lifecycle key gets added with subkeys:

        * `action` - Action Pulumi performs on the resource. Values are `create`, `update`, or `delete`.
        * `prev_input` - Input JSON payload from the previous invocation. This can be used to handle update and delete events.

        When the resource from the CRUD example above is created, the Lambda will receive the following JSON payload:

        If the `database_url` changes, the Lambda will be invoked again with:

        When the invocation resource is removed, the final invocation will have:

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] function_name: Name of the Lambda function.
        :param pulumi.Input[builtins.str] input: JSON payload to the Lambda function.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] lifecycle_scope: Lifecycle scope of the resource to manage. Valid values are `CREATE_ONLY` and `CRUD`. Defaults to `CREATE_ONLY`. `CREATE_ONLY` will invoke the function only on creation or replacement. `CRUD` will invoke the function on each lifecycle event, and augment the input JSON payload with additional lifecycle information.
        :param pulumi.Input[builtins.str] qualifier: Qualifier (i.e., version) of the Lambda function. Defaults to `$LATEST`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] triggers: Map of arbitrary keys and values that, when changed, will trigger a re-invocation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InvocationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Lambda Function invocation. Use this resource to invoke a Lambda function with the [RequestResponse](https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax) invocation type.

        > **Note:** By default this resource _only_ invokes the function when the arguments call for a create or replace. After an initial invocation on _apply_, if the arguments do not change, a subsequent _apply_ does not invoke the function again. To dynamically invoke the function, see the `triggers` example below. To always invoke a function on each _apply_, see the `lambda.Invocation` data source. To invoke the Lambda function when the Pulumi resource is updated and deleted, see the CRUD Lifecycle Management example below.

        > **Note:** If you get a `KMSAccessDeniedException: Lambda was unable to decrypt the environment variables because KMS access was denied` error when invoking a Lambda function with environment variables, the IAM role associated with the function may have been deleted and recreated after the function was created. You can fix the problem two ways: 1) updating the function's role to another role and then updating it back again to the recreated role. (When you create a function, Lambda grants permissions on the KMS key to the function's IAM role. If the IAM role is recreated, the grant is no longer valid. Changing the function's role or recreating the function causes Lambda to update the grant.)

        ## Example Usage

        ### Dynamic Invocation with Triggers

        ```python
        import pulumi
        import json
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.lambda_.Invocation("example",
            function_name=example_aws_lambda_function["functionName"],
            triggers={
                "function_version": example_aws_lambda_function["version"],
                "config_hash": std.sha256_output(input=json.dumps({
                    "environment": environment,
                    "timestamp": std.timestamp().result,
                })).apply(lambda invoke: invoke.result),
            },
            input=json.dumps({
                "operation": "process_data",
                "environment": environment,
                "batch_id": batch_id["result"],
            }))
        ```

        ### CRUD Lifecycle Management

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.lambda_.Invocation("example",
            function_name=example_aws_lambda_function["functionName"],
            input=json.dumps({
                "resource_name": "database_setup",
                "database_url": example_aws_db_instance["endpoint"],
                "credentials": {
                    "username": db_username,
                    "password": db_password,
                },
            }),
            lifecycle_scope="CRUD")
        ```

        > **Note:** `lifecycle_scope = "CRUD"` will inject a key `tf` in the input event to pass lifecycle information! This allows the Lambda function to handle different lifecycle transitions uniquely. If you need to use a key `tf` in your own input JSON, the default key name can be overridden with the `pulumi_key` argument.

        The lifecycle key gets added with subkeys:

        * `action` - Action Pulumi performs on the resource. Values are `create`, `update`, or `delete`.
        * `prev_input` - Input JSON payload from the previous invocation. This can be used to handle update and delete events.

        When the resource from the CRUD example above is created, the Lambda will receive the following JSON payload:

        If the `database_url` changes, the Lambda will be invoked again with:

        When the invocation resource is removed, the final invocation will have:

        :param str resource_name: The name of the resource.
        :param InvocationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InvocationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 function_name: Optional[pulumi.Input[builtins.str]] = None,
                 input: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_scope: Optional[pulumi.Input[builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 terraform_key: Optional[pulumi.Input[builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InvocationArgs.__new__(InvocationArgs)

            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            if input is None and not opts.urn:
                raise TypeError("Missing required property 'input'")
            __props__.__dict__["input"] = input
            __props__.__dict__["lifecycle_scope"] = lifecycle_scope
            __props__.__dict__["qualifier"] = qualifier
            __props__.__dict__["region"] = region
            __props__.__dict__["terraform_key"] = terraform_key
            __props__.__dict__["triggers"] = triggers
            __props__.__dict__["result"] = None
        super(Invocation, __self__).__init__(
            'aws:lambda/invocation:Invocation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            function_name: Optional[pulumi.Input[builtins.str]] = None,
            input: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_scope: Optional[pulumi.Input[builtins.str]] = None,
            qualifier: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            result: Optional[pulumi.Input[builtins.str]] = None,
            terraform_key: Optional[pulumi.Input[builtins.str]] = None,
            triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Invocation':
        """
        Get an existing Invocation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] function_name: Name of the Lambda function.
        :param pulumi.Input[builtins.str] input: JSON payload to the Lambda function.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] lifecycle_scope: Lifecycle scope of the resource to manage. Valid values are `CREATE_ONLY` and `CRUD`. Defaults to `CREATE_ONLY`. `CREATE_ONLY` will invoke the function only on creation or replacement. `CRUD` will invoke the function on each lifecycle event, and augment the input JSON payload with additional lifecycle information.
        :param pulumi.Input[builtins.str] qualifier: Qualifier (i.e., version) of the Lambda function. Defaults to `$LATEST`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] result: String result of the Lambda function invocation.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] triggers: Map of arbitrary keys and values that, when changed, will trigger a re-invocation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InvocationState.__new__(_InvocationState)

        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["input"] = input
        __props__.__dict__["lifecycle_scope"] = lifecycle_scope
        __props__.__dict__["qualifier"] = qualifier
        __props__.__dict__["region"] = region
        __props__.__dict__["result"] = result
        __props__.__dict__["terraform_key"] = terraform_key
        __props__.__dict__["triggers"] = triggers
        return Invocation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Lambda function.
        """
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter
    def input(self) -> pulumi.Output[builtins.str]:
        """
        JSON payload to the Lambda function.

        The following arguments are optional:
        """
        return pulumi.get(self, "input")

    @property
    @pulumi.getter(name="lifecycleScope")
    def lifecycle_scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Lifecycle scope of the resource to manage. Valid values are `CREATE_ONLY` and `CRUD`. Defaults to `CREATE_ONLY`. `CREATE_ONLY` will invoke the function only on creation or replacement. `CRUD` will invoke the function on each lifecycle event, and augment the input JSON payload with additional lifecycle information.
        """
        return pulumi.get(self, "lifecycle_scope")

    @property
    @pulumi.getter
    def qualifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Qualifier (i.e., version) of the Lambda function. Defaults to `$LATEST`.
        """
        return pulumi.get(self, "qualifier")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def result(self) -> pulumi.Output[builtins.str]:
        """
        String result of the Lambda function invocation.
        """
        return pulumi.get(self, "result")

    @property
    @pulumi.getter(name="terraformKey")
    def terraform_key(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "terraform_key")

    @property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of arbitrary keys and values that, when changed, will trigger a re-invocation.
        """
        return pulumi.get(self, "triggers")

