# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LayerVersionArgs', 'LayerVersion']

@pulumi.input_type
class LayerVersionArgs:
    def __init__(__self__, *,
                 layer_name: pulumi.Input[builtins.str],
                 code: Optional[pulumi.Input[pulumi.Archive]] = None,
                 compatible_architectures: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 compatible_runtimes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 license_info: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 s3_bucket: Optional[pulumi.Input[builtins.str]] = None,
                 s3_key: Optional[pulumi.Input[builtins.str]] = None,
                 s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
                 skip_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 source_code_hash: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a LayerVersion resource.
        :param pulumi.Input[builtins.str] layer_name: Unique name for your Lambda Layer.
               
               The following arguments are optional:
        :param pulumi.Input[pulumi.Archive] code: Path to the function's deployment package within the local filesystem. If defined, The `s3_`-prefixed options cannot be used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] compatible_architectures: List of [Architectures](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleArchitectures) this layer is compatible with. Currently `x86_64` and `arm64` can be specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] compatible_runtimes: List of [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleRuntimes) this layer is compatible with. Up to 15 runtimes can be specified.
        :param pulumi.Input[builtins.str] description: Description of what your Lambda Layer does.
        :param pulumi.Input[builtins.str] license_info: License info for your Lambda Layer. See [License Info](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-LicenseInfo).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] s3_bucket: S3 bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same AWS region where you are creating the Lambda function.
        :param pulumi.Input[builtins.str] s3_key: S3 key of an object containing the function's deployment package. Conflicts with `filename`.
        :param pulumi.Input[builtins.str] s3_object_version: Object version containing the function's deployment package. Conflicts with `filename`.
        :param pulumi.Input[builtins.bool] skip_destroy: Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
        :param pulumi.Input[builtins.str] source_code_hash: Virtual attribute used to trigger replacement when source code changes. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`. The usual way to set this is `filebase64sha256("file.zip")` or `base64sha256(file("file.zip"))`, where "file.zip" is the local filename of the lambda layer source archive.
        """
        pulumi.set(__self__, "layer_name", layer_name)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if compatible_architectures is not None:
            pulumi.set(__self__, "compatible_architectures", compatible_architectures)
        if compatible_runtimes is not None:
            pulumi.set(__self__, "compatible_runtimes", compatible_runtimes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if license_info is not None:
            pulumi.set(__self__, "license_info", license_info)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)
        if s3_key is not None:
            pulumi.set(__self__, "s3_key", s3_key)
        if s3_object_version is not None:
            pulumi.set(__self__, "s3_object_version", s3_object_version)
        if skip_destroy is not None:
            pulumi.set(__self__, "skip_destroy", skip_destroy)
        if source_code_hash is not None:
            pulumi.set(__self__, "source_code_hash", source_code_hash)

    @property
    @pulumi.getter(name="layerName")
    def layer_name(self) -> pulumi.Input[builtins.str]:
        """
        Unique name for your Lambda Layer.

        The following arguments are optional:
        """
        return pulumi.get(self, "layer_name")

    @layer_name.setter
    def layer_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "layer_name", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[pulumi.Archive]]:
        """
        Path to the function's deployment package within the local filesystem. If defined, The `s3_`-prefixed options cannot be used.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[pulumi.Archive]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="compatibleArchitectures")
    def compatible_architectures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of [Architectures](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleArchitectures) this layer is compatible with. Currently `x86_64` and `arm64` can be specified.
        """
        return pulumi.get(self, "compatible_architectures")

    @compatible_architectures.setter
    def compatible_architectures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "compatible_architectures", value)

    @property
    @pulumi.getter(name="compatibleRuntimes")
    def compatible_runtimes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleRuntimes) this layer is compatible with. Up to 15 runtimes can be specified.
        """
        return pulumi.get(self, "compatible_runtimes")

    @compatible_runtimes.setter
    def compatible_runtimes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "compatible_runtimes", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of what your Lambda Layer does.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="licenseInfo")
    def license_info(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        License info for your Lambda Layer. See [License Info](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-LicenseInfo).
        """
        return pulumi.get(self, "license_info")

    @license_info.setter
    def license_info(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "license_info", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        S3 bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same AWS region where you are creating the Lambda function.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_bucket", value)

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        S3 key of an object containing the function's deployment package. Conflicts with `filename`.
        """
        return pulumi.get(self, "s3_key")

    @s3_key.setter
    def s3_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_key", value)

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Object version containing the function's deployment package. Conflicts with `filename`.
        """
        return pulumi.get(self, "s3_object_version")

    @s3_object_version.setter
    def s3_object_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_object_version", value)

    @property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
        """
        return pulumi.get(self, "skip_destroy")

    @skip_destroy.setter
    def skip_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_destroy", value)

    @property
    @pulumi.getter(name="sourceCodeHash")
    def source_code_hash(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Virtual attribute used to trigger replacement when source code changes. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`. The usual way to set this is `filebase64sha256("file.zip")` or `base64sha256(file("file.zip"))`, where "file.zip" is the local filename of the lambda layer source archive.
        """
        return pulumi.get(self, "source_code_hash")

    @source_code_hash.setter
    def source_code_hash(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_code_hash", value)


@pulumi.input_type
class _LayerVersionState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 code: Optional[pulumi.Input[pulumi.Archive]] = None,
                 code_sha256: Optional[pulumi.Input[builtins.str]] = None,
                 compatible_architectures: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 compatible_runtimes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 created_date: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 layer_arn: Optional[pulumi.Input[builtins.str]] = None,
                 layer_name: Optional[pulumi.Input[builtins.str]] = None,
                 license_info: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 s3_bucket: Optional[pulumi.Input[builtins.str]] = None,
                 s3_key: Optional[pulumi.Input[builtins.str]] = None,
                 s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
                 signing_job_arn: Optional[pulumi.Input[builtins.str]] = None,
                 signing_profile_version_arn: Optional[pulumi.Input[builtins.str]] = None,
                 skip_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 source_code_hash: Optional[pulumi.Input[builtins.str]] = None,
                 source_code_size: Optional[pulumi.Input[builtins.int]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering LayerVersion resources.
        :param pulumi.Input[builtins.str] arn: ARN of the Lambda Layer with version.
        :param pulumi.Input[pulumi.Archive] code: Path to the function's deployment package within the local filesystem. If defined, The `s3_`-prefixed options cannot be used.
        :param pulumi.Input[builtins.str] code_sha256: Base64-encoded representation of raw SHA-256 sum of the zip file.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] compatible_architectures: List of [Architectures](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleArchitectures) this layer is compatible with. Currently `x86_64` and `arm64` can be specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] compatible_runtimes: List of [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleRuntimes) this layer is compatible with. Up to 15 runtimes can be specified.
        :param pulumi.Input[builtins.str] created_date: Date this resource was created.
        :param pulumi.Input[builtins.str] description: Description of what your Lambda Layer does.
        :param pulumi.Input[builtins.str] layer_arn: ARN of the Lambda Layer without version.
        :param pulumi.Input[builtins.str] layer_name: Unique name for your Lambda Layer.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] license_info: License info for your Lambda Layer. See [License Info](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-LicenseInfo).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] s3_bucket: S3 bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same AWS region where you are creating the Lambda function.
        :param pulumi.Input[builtins.str] s3_key: S3 key of an object containing the function's deployment package. Conflicts with `filename`.
        :param pulumi.Input[builtins.str] s3_object_version: Object version containing the function's deployment package. Conflicts with `filename`.
        :param pulumi.Input[builtins.str] signing_job_arn: ARN of a signing job.
        :param pulumi.Input[builtins.str] signing_profile_version_arn: ARN for a signing profile version.
        :param pulumi.Input[builtins.bool] skip_destroy: Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
        :param pulumi.Input[builtins.str] source_code_hash: Virtual attribute used to trigger replacement when source code changes. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`. The usual way to set this is `filebase64sha256("file.zip")` or `base64sha256(file("file.zip"))`, where "file.zip" is the local filename of the lambda layer source archive.
        :param pulumi.Input[builtins.int] source_code_size: Size in bytes of the function .zip file.
        :param pulumi.Input[builtins.str] version: Lambda Layer version.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if code_sha256 is not None:
            pulumi.set(__self__, "code_sha256", code_sha256)
        if compatible_architectures is not None:
            pulumi.set(__self__, "compatible_architectures", compatible_architectures)
        if compatible_runtimes is not None:
            pulumi.set(__self__, "compatible_runtimes", compatible_runtimes)
        if created_date is not None:
            pulumi.set(__self__, "created_date", created_date)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if layer_arn is not None:
            pulumi.set(__self__, "layer_arn", layer_arn)
        if layer_name is not None:
            pulumi.set(__self__, "layer_name", layer_name)
        if license_info is not None:
            pulumi.set(__self__, "license_info", license_info)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)
        if s3_key is not None:
            pulumi.set(__self__, "s3_key", s3_key)
        if s3_object_version is not None:
            pulumi.set(__self__, "s3_object_version", s3_object_version)
        if signing_job_arn is not None:
            pulumi.set(__self__, "signing_job_arn", signing_job_arn)
        if signing_profile_version_arn is not None:
            pulumi.set(__self__, "signing_profile_version_arn", signing_profile_version_arn)
        if skip_destroy is not None:
            pulumi.set(__self__, "skip_destroy", skip_destroy)
        if source_code_hash is not None:
            pulumi.set(__self__, "source_code_hash", source_code_hash)
        if source_code_size is not None:
            pulumi.set(__self__, "source_code_size", source_code_size)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Lambda Layer with version.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[pulumi.Archive]]:
        """
        Path to the function's deployment package within the local filesystem. If defined, The `s3_`-prefixed options cannot be used.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[pulumi.Archive]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="codeSha256")
    def code_sha256(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base64-encoded representation of raw SHA-256 sum of the zip file.
        """
        return pulumi.get(self, "code_sha256")

    @code_sha256.setter
    def code_sha256(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "code_sha256", value)

    @property
    @pulumi.getter(name="compatibleArchitectures")
    def compatible_architectures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of [Architectures](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleArchitectures) this layer is compatible with. Currently `x86_64` and `arm64` can be specified.
        """
        return pulumi.get(self, "compatible_architectures")

    @compatible_architectures.setter
    def compatible_architectures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "compatible_architectures", value)

    @property
    @pulumi.getter(name="compatibleRuntimes")
    def compatible_runtimes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleRuntimes) this layer is compatible with. Up to 15 runtimes can be specified.
        """
        return pulumi.get(self, "compatible_runtimes")

    @compatible_runtimes.setter
    def compatible_runtimes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "compatible_runtimes", value)

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date this resource was created.
        """
        return pulumi.get(self, "created_date")

    @created_date.setter
    def created_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_date", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of what your Lambda Layer does.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="layerArn")
    def layer_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Lambda Layer without version.
        """
        return pulumi.get(self, "layer_arn")

    @layer_arn.setter
    def layer_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "layer_arn", value)

    @property
    @pulumi.getter(name="layerName")
    def layer_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique name for your Lambda Layer.

        The following arguments are optional:
        """
        return pulumi.get(self, "layer_name")

    @layer_name.setter
    def layer_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "layer_name", value)

    @property
    @pulumi.getter(name="licenseInfo")
    def license_info(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        License info for your Lambda Layer. See [License Info](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-LicenseInfo).
        """
        return pulumi.get(self, "license_info")

    @license_info.setter
    def license_info(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "license_info", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        S3 bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same AWS region where you are creating the Lambda function.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_bucket", value)

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        S3 key of an object containing the function's deployment package. Conflicts with `filename`.
        """
        return pulumi.get(self, "s3_key")

    @s3_key.setter
    def s3_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_key", value)

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Object version containing the function's deployment package. Conflicts with `filename`.
        """
        return pulumi.get(self, "s3_object_version")

    @s3_object_version.setter
    def s3_object_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_object_version", value)

    @property
    @pulumi.getter(name="signingJobArn")
    def signing_job_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of a signing job.
        """
        return pulumi.get(self, "signing_job_arn")

    @signing_job_arn.setter
    def signing_job_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signing_job_arn", value)

    @property
    @pulumi.getter(name="signingProfileVersionArn")
    def signing_profile_version_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN for a signing profile version.
        """
        return pulumi.get(self, "signing_profile_version_arn")

    @signing_profile_version_arn.setter
    def signing_profile_version_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signing_profile_version_arn", value)

    @property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
        """
        return pulumi.get(self, "skip_destroy")

    @skip_destroy.setter
    def skip_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_destroy", value)

    @property
    @pulumi.getter(name="sourceCodeHash")
    def source_code_hash(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Virtual attribute used to trigger replacement when source code changes. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`. The usual way to set this is `filebase64sha256("file.zip")` or `base64sha256(file("file.zip"))`, where "file.zip" is the local filename of the lambda layer source archive.
        """
        return pulumi.get(self, "source_code_hash")

    @source_code_hash.setter
    def source_code_hash(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_code_hash", value)

    @property
    @pulumi.getter(name="sourceCodeSize")
    def source_code_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Size in bytes of the function .zip file.
        """
        return pulumi.get(self, "source_code_size")

    @source_code_size.setter
    def source_code_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "source_code_size", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lambda Layer version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("aws:lambda/layerVersion:LayerVersion")
class LayerVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code: Optional[pulumi.Input[pulumi.Archive]] = None,
                 compatible_architectures: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 compatible_runtimes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 layer_name: Optional[pulumi.Input[builtins.str]] = None,
                 license_info: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 s3_bucket: Optional[pulumi.Input[builtins.str]] = None,
                 s3_key: Optional[pulumi.Input[builtins.str]] = None,
                 s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
                 skip_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 source_code_hash: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an AWS Lambda Layer Version. Use this resource to share code and dependencies across multiple Lambda functions.

        For information about Lambda Layers and how to use them, see [AWS Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).

        > **Note:** Setting `skip_destroy` to `true` means that the AWS Provider will not destroy any layer version, even when running `pulumi destroy`. Layer versions are thus intentional dangling resources that are not managed by Pulumi and may incur extra expense in your AWS account.

        ## Example Usage

        ### Basic Layer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.LayerVersion("example",
            code=pulumi.FileArchive("lambda_layer_payload.zip"),
            layer_name="lambda_layer_name",
            compatible_runtimes=["nodejs20.x"])
        ```

        ### Layer with S3 Source

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.LayerVersion("example",
            s3_bucket=lambda_layer_zip["bucket"],
            s3_key=lambda_layer_zip["key"],
            layer_name="lambda_layer_name",
            compatible_runtimes=[
                "nodejs20.x",
                "python3.12",
            ],
            compatible_architectures=[
                "x86_64",
                "arm64",
            ])
        ```

        ### Layer with Multiple Runtimes and Architectures

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.lambda_.LayerVersion("example",
            code=pulumi.FileArchive("lambda_layer_payload.zip"),
            layer_name="multi_runtime_layer",
            description="Shared utilities for Lambda functions",
            license_info="MIT",
            source_code_hash=std.filebase64sha256(input="lambda_layer_payload.zip").result,
            compatible_runtimes=[
                "nodejs18.x",
                "nodejs20.x",
                "python3.11",
                "python3.12",
            ],
            compatible_architectures=[
                "x86_64",
                "arm64",
            ])
        ```

        ## Specifying the Deployment Package

        AWS Lambda Layers expect source code to be provided as a deployment package whose structure varies depending on which `compatible_runtimes` this layer specifies. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleRuntimes) for the valid values of `compatible_runtimes`.

        Once you have created your deployment package you can specify it either directly as a local file (using the `filename` argument) or indirectly via Amazon S3 (using the `s3_bucket`, `s3_key` and `s3_object_version` arguments). When providing the deployment package via S3 it may be useful to use the `s3.BucketObjectv2` resource to upload it.

        For larger deployment packages it is recommended by Amazon to upload via S3, since the S3 API has better support for uploading large files efficiently.

        ## Import

        Using `pulumi import`, import Lambda Layers using `arn`. For example:

        ```sh
        $ pulumi import aws:lambda/layerVersion:LayerVersion example arn:aws:lambda:us-west-2:123456789012:layer:example:1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.Archive] code: Path to the function's deployment package within the local filesystem. If defined, The `s3_`-prefixed options cannot be used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] compatible_architectures: List of [Architectures](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleArchitectures) this layer is compatible with. Currently `x86_64` and `arm64` can be specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] compatible_runtimes: List of [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleRuntimes) this layer is compatible with. Up to 15 runtimes can be specified.
        :param pulumi.Input[builtins.str] description: Description of what your Lambda Layer does.
        :param pulumi.Input[builtins.str] layer_name: Unique name for your Lambda Layer.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] license_info: License info for your Lambda Layer. See [License Info](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-LicenseInfo).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] s3_bucket: S3 bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same AWS region where you are creating the Lambda function.
        :param pulumi.Input[builtins.str] s3_key: S3 key of an object containing the function's deployment package. Conflicts with `filename`.
        :param pulumi.Input[builtins.str] s3_object_version: Object version containing the function's deployment package. Conflicts with `filename`.
        :param pulumi.Input[builtins.bool] skip_destroy: Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
        :param pulumi.Input[builtins.str] source_code_hash: Virtual attribute used to trigger replacement when source code changes. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`. The usual way to set this is `filebase64sha256("file.zip")` or `base64sha256(file("file.zip"))`, where "file.zip" is the local filename of the lambda layer source archive.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LayerVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Lambda Layer Version. Use this resource to share code and dependencies across multiple Lambda functions.

        For information about Lambda Layers and how to use them, see [AWS Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).

        > **Note:** Setting `skip_destroy` to `true` means that the AWS Provider will not destroy any layer version, even when running `pulumi destroy`. Layer versions are thus intentional dangling resources that are not managed by Pulumi and may incur extra expense in your AWS account.

        ## Example Usage

        ### Basic Layer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.LayerVersion("example",
            code=pulumi.FileArchive("lambda_layer_payload.zip"),
            layer_name="lambda_layer_name",
            compatible_runtimes=["nodejs20.x"])
        ```

        ### Layer with S3 Source

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.LayerVersion("example",
            s3_bucket=lambda_layer_zip["bucket"],
            s3_key=lambda_layer_zip["key"],
            layer_name="lambda_layer_name",
            compatible_runtimes=[
                "nodejs20.x",
                "python3.12",
            ],
            compatible_architectures=[
                "x86_64",
                "arm64",
            ])
        ```

        ### Layer with Multiple Runtimes and Architectures

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.lambda_.LayerVersion("example",
            code=pulumi.FileArchive("lambda_layer_payload.zip"),
            layer_name="multi_runtime_layer",
            description="Shared utilities for Lambda functions",
            license_info="MIT",
            source_code_hash=std.filebase64sha256(input="lambda_layer_payload.zip").result,
            compatible_runtimes=[
                "nodejs18.x",
                "nodejs20.x",
                "python3.11",
                "python3.12",
            ],
            compatible_architectures=[
                "x86_64",
                "arm64",
            ])
        ```

        ## Specifying the Deployment Package

        AWS Lambda Layers expect source code to be provided as a deployment package whose structure varies depending on which `compatible_runtimes` this layer specifies. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleRuntimes) for the valid values of `compatible_runtimes`.

        Once you have created your deployment package you can specify it either directly as a local file (using the `filename` argument) or indirectly via Amazon S3 (using the `s3_bucket`, `s3_key` and `s3_object_version` arguments). When providing the deployment package via S3 it may be useful to use the `s3.BucketObjectv2` resource to upload it.

        For larger deployment packages it is recommended by Amazon to upload via S3, since the S3 API has better support for uploading large files efficiently.

        ## Import

        Using `pulumi import`, import Lambda Layers using `arn`. For example:

        ```sh
        $ pulumi import aws:lambda/layerVersion:LayerVersion example arn:aws:lambda:us-west-2:123456789012:layer:example:1
        ```

        :param str resource_name: The name of the resource.
        :param LayerVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LayerVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code: Optional[pulumi.Input[pulumi.Archive]] = None,
                 compatible_architectures: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 compatible_runtimes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 layer_name: Optional[pulumi.Input[builtins.str]] = None,
                 license_info: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 s3_bucket: Optional[pulumi.Input[builtins.str]] = None,
                 s3_key: Optional[pulumi.Input[builtins.str]] = None,
                 s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
                 skip_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 source_code_hash: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LayerVersionArgs.__new__(LayerVersionArgs)

            __props__.__dict__["code"] = code
            __props__.__dict__["compatible_architectures"] = compatible_architectures
            __props__.__dict__["compatible_runtimes"] = compatible_runtimes
            __props__.__dict__["description"] = description
            if layer_name is None and not opts.urn:
                raise TypeError("Missing required property 'layer_name'")
            __props__.__dict__["layer_name"] = layer_name
            __props__.__dict__["license_info"] = license_info
            __props__.__dict__["region"] = region
            __props__.__dict__["s3_bucket"] = s3_bucket
            __props__.__dict__["s3_key"] = s3_key
            __props__.__dict__["s3_object_version"] = s3_object_version
            __props__.__dict__["skip_destroy"] = skip_destroy
            __props__.__dict__["source_code_hash"] = source_code_hash
            __props__.__dict__["arn"] = None
            __props__.__dict__["code_sha256"] = None
            __props__.__dict__["created_date"] = None
            __props__.__dict__["layer_arn"] = None
            __props__.__dict__["signing_job_arn"] = None
            __props__.__dict__["signing_profile_version_arn"] = None
            __props__.__dict__["source_code_size"] = None
            __props__.__dict__["version"] = None
        super(LayerVersion, __self__).__init__(
            'aws:lambda/layerVersion:LayerVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            code: Optional[pulumi.Input[pulumi.Archive]] = None,
            code_sha256: Optional[pulumi.Input[builtins.str]] = None,
            compatible_architectures: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            compatible_runtimes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            created_date: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            layer_arn: Optional[pulumi.Input[builtins.str]] = None,
            layer_name: Optional[pulumi.Input[builtins.str]] = None,
            license_info: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            s3_bucket: Optional[pulumi.Input[builtins.str]] = None,
            s3_key: Optional[pulumi.Input[builtins.str]] = None,
            s3_object_version: Optional[pulumi.Input[builtins.str]] = None,
            signing_job_arn: Optional[pulumi.Input[builtins.str]] = None,
            signing_profile_version_arn: Optional[pulumi.Input[builtins.str]] = None,
            skip_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            source_code_hash: Optional[pulumi.Input[builtins.str]] = None,
            source_code_size: Optional[pulumi.Input[builtins.int]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'LayerVersion':
        """
        Get an existing LayerVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the Lambda Layer with version.
        :param pulumi.Input[pulumi.Archive] code: Path to the function's deployment package within the local filesystem. If defined, The `s3_`-prefixed options cannot be used.
        :param pulumi.Input[builtins.str] code_sha256: Base64-encoded representation of raw SHA-256 sum of the zip file.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] compatible_architectures: List of [Architectures](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleArchitectures) this layer is compatible with. Currently `x86_64` and `arm64` can be specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] compatible_runtimes: List of [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleRuntimes) this layer is compatible with. Up to 15 runtimes can be specified.
        :param pulumi.Input[builtins.str] created_date: Date this resource was created.
        :param pulumi.Input[builtins.str] description: Description of what your Lambda Layer does.
        :param pulumi.Input[builtins.str] layer_arn: ARN of the Lambda Layer without version.
        :param pulumi.Input[builtins.str] layer_name: Unique name for your Lambda Layer.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] license_info: License info for your Lambda Layer. See [License Info](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-LicenseInfo).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] s3_bucket: S3 bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same AWS region where you are creating the Lambda function.
        :param pulumi.Input[builtins.str] s3_key: S3 key of an object containing the function's deployment package. Conflicts with `filename`.
        :param pulumi.Input[builtins.str] s3_object_version: Object version containing the function's deployment package. Conflicts with `filename`.
        :param pulumi.Input[builtins.str] signing_job_arn: ARN of a signing job.
        :param pulumi.Input[builtins.str] signing_profile_version_arn: ARN for a signing profile version.
        :param pulumi.Input[builtins.bool] skip_destroy: Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
        :param pulumi.Input[builtins.str] source_code_hash: Virtual attribute used to trigger replacement when source code changes. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`. The usual way to set this is `filebase64sha256("file.zip")` or `base64sha256(file("file.zip"))`, where "file.zip" is the local filename of the lambda layer source archive.
        :param pulumi.Input[builtins.int] source_code_size: Size in bytes of the function .zip file.
        :param pulumi.Input[builtins.str] version: Lambda Layer version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LayerVersionState.__new__(_LayerVersionState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["code"] = code
        __props__.__dict__["code_sha256"] = code_sha256
        __props__.__dict__["compatible_architectures"] = compatible_architectures
        __props__.__dict__["compatible_runtimes"] = compatible_runtimes
        __props__.__dict__["created_date"] = created_date
        __props__.__dict__["description"] = description
        __props__.__dict__["layer_arn"] = layer_arn
        __props__.__dict__["layer_name"] = layer_name
        __props__.__dict__["license_info"] = license_info
        __props__.__dict__["region"] = region
        __props__.__dict__["s3_bucket"] = s3_bucket
        __props__.__dict__["s3_key"] = s3_key
        __props__.__dict__["s3_object_version"] = s3_object_version
        __props__.__dict__["signing_job_arn"] = signing_job_arn
        __props__.__dict__["signing_profile_version_arn"] = signing_profile_version_arn
        __props__.__dict__["skip_destroy"] = skip_destroy
        __props__.__dict__["source_code_hash"] = source_code_hash
        __props__.__dict__["source_code_size"] = source_code_size
        __props__.__dict__["version"] = version
        return LayerVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Lambda Layer with version.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def code(self) -> pulumi.Output[Optional[pulumi.Archive]]:
        """
        Path to the function's deployment package within the local filesystem. If defined, The `s3_`-prefixed options cannot be used.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="codeSha256")
    def code_sha256(self) -> pulumi.Output[builtins.str]:
        """
        Base64-encoded representation of raw SHA-256 sum of the zip file.
        """
        return pulumi.get(self, "code_sha256")

    @property
    @pulumi.getter(name="compatibleArchitectures")
    def compatible_architectures(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of [Architectures](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleArchitectures) this layer is compatible with. Currently `x86_64` and `arm64` can be specified.
        """
        return pulumi.get(self, "compatible_architectures")

    @property
    @pulumi.getter(name="compatibleRuntimes")
    def compatible_runtimes(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleRuntimes) this layer is compatible with. Up to 15 runtimes can be specified.
        """
        return pulumi.get(self, "compatible_runtimes")

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> pulumi.Output[builtins.str]:
        """
        Date this resource was created.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of what your Lambda Layer does.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="layerArn")
    def layer_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Lambda Layer without version.
        """
        return pulumi.get(self, "layer_arn")

    @property
    @pulumi.getter(name="layerName")
    def layer_name(self) -> pulumi.Output[builtins.str]:
        """
        Unique name for your Lambda Layer.

        The following arguments are optional:
        """
        return pulumi.get(self, "layer_name")

    @property
    @pulumi.getter(name="licenseInfo")
    def license_info(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        License info for your Lambda Layer. See [License Info](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-LicenseInfo).
        """
        return pulumi.get(self, "license_info")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        S3 bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same AWS region where you are creating the Lambda function.
        """
        return pulumi.get(self, "s3_bucket")

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        S3 key of an object containing the function's deployment package. Conflicts with `filename`.
        """
        return pulumi.get(self, "s3_key")

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Object version containing the function's deployment package. Conflicts with `filename`.
        """
        return pulumi.get(self, "s3_object_version")

    @property
    @pulumi.getter(name="signingJobArn")
    def signing_job_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of a signing job.
        """
        return pulumi.get(self, "signing_job_arn")

    @property
    @pulumi.getter(name="signingProfileVersionArn")
    def signing_profile_version_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN for a signing profile version.
        """
        return pulumi.get(self, "signing_profile_version_arn")

    @property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
        """
        return pulumi.get(self, "skip_destroy")

    @property
    @pulumi.getter(name="sourceCodeHash")
    def source_code_hash(self) -> pulumi.Output[builtins.str]:
        """
        Virtual attribute used to trigger replacement when source code changes. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`. The usual way to set this is `filebase64sha256("file.zip")` or `base64sha256(file("file.zip"))`, where "file.zip" is the local filename of the lambda layer source archive.
        """
        return pulumi.get(self, "source_code_hash")

    @property
    @pulumi.getter(name="sourceCodeSize")
    def source_code_size(self) -> pulumi.Output[builtins.int]:
        """
        Size in bytes of the function .zip file.
        """
        return pulumi.get(self, "source_code_size")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        Lambda Layer version.
        """
        return pulumi.get(self, "version")

