# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AliasRoutingConfig',
    'CodeSigningConfigAllowedPublishers',
    'CodeSigningConfigPolicies',
    'EventSourceMappingAmazonManagedKafkaEventSourceConfig',
    'EventSourceMappingDestinationConfig',
    'EventSourceMappingDestinationConfigOnFailure',
    'EventSourceMappingDocumentDbEventSourceConfig',
    'EventSourceMappingFilterCriteria',
    'EventSourceMappingFilterCriteriaFilter',
    'EventSourceMappingMetricsConfig',
    'EventSourceMappingProvisionedPollerConfig',
    'EventSourceMappingScalingConfig',
    'EventSourceMappingSelfManagedEventSource',
    'EventSourceMappingSelfManagedKafkaEventSourceConfig',
    'EventSourceMappingSourceAccessConfiguration',
    'FunctionDeadLetterConfig',
    'FunctionEnvironment',
    'FunctionEphemeralStorage',
    'FunctionEventInvokeConfigDestinationConfig',
    'FunctionEventInvokeConfigDestinationConfigOnFailure',
    'FunctionEventInvokeConfigDestinationConfigOnSuccess',
    'FunctionFileSystemConfig',
    'FunctionImageConfig',
    'FunctionLoggingConfig',
    'FunctionSnapStart',
    'FunctionTracingConfig',
    'FunctionUrlCors',
    'FunctionVpcConfig',
    'GetCodeSigningConfigAllowedPublisherResult',
    'GetCodeSigningConfigPolicyResult',
    'GetFunctionDeadLetterConfigResult',
    'GetFunctionEnvironmentResult',
    'GetFunctionEphemeralStorageResult',
    'GetFunctionFileSystemConfigResult',
    'GetFunctionLoggingConfigResult',
    'GetFunctionTracingConfigResult',
    'GetFunctionUrlCorResult',
    'GetFunctionVpcConfigResult',
]

@pulumi.output_type
class AliasRoutingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalVersionWeights":
            suggest = "additional_version_weights"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AliasRoutingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AliasRoutingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AliasRoutingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_version_weights: Optional[Mapping[str, builtins.float]] = None):
        """
        :param Mapping[str, builtins.float] additional_version_weights: Map that defines the proportion of events that should be sent to different versions of a Lambda function.
        """
        if additional_version_weights is not None:
            pulumi.set(__self__, "additional_version_weights", additional_version_weights)

    @property
    @pulumi.getter(name="additionalVersionWeights")
    def additional_version_weights(self) -> Optional[Mapping[str, builtins.float]]:
        """
        Map that defines the proportion of events that should be sent to different versions of a Lambda function.
        """
        return pulumi.get(self, "additional_version_weights")


@pulumi.output_type
class CodeSigningConfigAllowedPublishers(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signingProfileVersionArns":
            suggest = "signing_profile_version_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeSigningConfigAllowedPublishers. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeSigningConfigAllowedPublishers.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeSigningConfigAllowedPublishers.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 signing_profile_version_arns: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] signing_profile_version_arns: Set of ARNs for each of the signing profiles. A signing profile defines a trusted user who can sign a code package. Maximum of 20 signing profiles.
        """
        pulumi.set(__self__, "signing_profile_version_arns", signing_profile_version_arns)

    @property
    @pulumi.getter(name="signingProfileVersionArns")
    def signing_profile_version_arns(self) -> Sequence[builtins.str]:
        """
        Set of ARNs for each of the signing profiles. A signing profile defines a trusted user who can sign a code package. Maximum of 20 signing profiles.
        """
        return pulumi.get(self, "signing_profile_version_arns")


@pulumi.output_type
class CodeSigningConfigPolicies(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "untrustedArtifactOnDeployment":
            suggest = "untrusted_artifact_on_deployment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeSigningConfigPolicies. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeSigningConfigPolicies.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeSigningConfigPolicies.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 untrusted_artifact_on_deployment: builtins.str):
        """
        :param builtins.str untrusted_artifact_on_deployment: Code signing configuration policy for deployment validation failure. If you set the policy to `Enforce`, Lambda blocks the deployment request if code-signing validation checks fail. If you set the policy to `Warn`, Lambda allows the deployment and creates a CloudWatch log. Valid values: `Warn`, `Enforce`. Default value: `Warn`.
        """
        pulumi.set(__self__, "untrusted_artifact_on_deployment", untrusted_artifact_on_deployment)

    @property
    @pulumi.getter(name="untrustedArtifactOnDeployment")
    def untrusted_artifact_on_deployment(self) -> builtins.str:
        """
        Code signing configuration policy for deployment validation failure. If you set the policy to `Enforce`, Lambda blocks the deployment request if code-signing validation checks fail. If you set the policy to `Warn`, Lambda allows the deployment and creates a CloudWatch log. Valid values: `Warn`, `Enforce`. Default value: `Warn`.
        """
        return pulumi.get(self, "untrusted_artifact_on_deployment")


@pulumi.output_type
class EventSourceMappingAmazonManagedKafkaEventSourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerGroupId":
            suggest = "consumer_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingAmazonManagedKafkaEventSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingAmazonManagedKafkaEventSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingAmazonManagedKafkaEventSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_group_id: Optional[builtins.str] = None):
        """
        :param builtins.str consumer_group_id: Kafka consumer group ID between 1 and 200 characters for use when creating this event source mapping. If one is not specified, this value will be automatically generated. See [AmazonManagedKafkaEventSourceConfig Syntax](https://docs.aws.amazon.com/lambda/latest/dg/API_AmazonManagedKafkaEventSourceConfig.html).
        """
        if consumer_group_id is not None:
            pulumi.set(__self__, "consumer_group_id", consumer_group_id)

    @property
    @pulumi.getter(name="consumerGroupId")
    def consumer_group_id(self) -> Optional[builtins.str]:
        """
        Kafka consumer group ID between 1 and 200 characters for use when creating this event source mapping. If one is not specified, this value will be automatically generated. See [AmazonManagedKafkaEventSourceConfig Syntax](https://docs.aws.amazon.com/lambda/latest/dg/API_AmazonManagedKafkaEventSourceConfig.html).
        """
        return pulumi.get(self, "consumer_group_id")


@pulumi.output_type
class EventSourceMappingDestinationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onFailure":
            suggest = "on_failure"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingDestinationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingDestinationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingDestinationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_failure: Optional['outputs.EventSourceMappingDestinationConfigOnFailure'] = None):
        """
        :param 'EventSourceMappingDestinationConfigOnFailureArgs' on_failure: Destination configuration for failed invocations. See below.
        """
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)

    @property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional['outputs.EventSourceMappingDestinationConfigOnFailure']:
        """
        Destination configuration for failed invocations. See below.
        """
        return pulumi.get(self, "on_failure")


@pulumi.output_type
class EventSourceMappingDestinationConfigOnFailure(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationArn":
            suggest = "destination_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingDestinationConfigOnFailure. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingDestinationConfigOnFailure.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingDestinationConfigOnFailure.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_arn: builtins.str):
        """
        :param builtins.str destination_arn: ARN of the destination resource.
        """
        pulumi.set(__self__, "destination_arn", destination_arn)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> builtins.str:
        """
        ARN of the destination resource.
        """
        return pulumi.get(self, "destination_arn")


@pulumi.output_type
class EventSourceMappingDocumentDbEventSourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "collectionName":
            suggest = "collection_name"
        elif key == "fullDocument":
            suggest = "full_document"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingDocumentDbEventSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingDocumentDbEventSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingDocumentDbEventSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 collection_name: Optional[builtins.str] = None,
                 full_document: Optional[builtins.str] = None):
        """
        :param builtins.str database_name: Name of the database to consume within the DocumentDB cluster.
        :param builtins.str collection_name: Name of the collection to consume within the database. If you do not specify a collection, Lambda consumes all collections.
        :param builtins.str full_document: Determines what DocumentDB sends to your event stream during document update operations. If set to `UpdateLookup`, DocumentDB sends a delta describing the changes, along with a copy of the entire document. Otherwise, DocumentDB sends only a partial document that contains the changes. Valid values: `UpdateLookup`, `Default`.
        """
        pulumi.set(__self__, "database_name", database_name)
        if collection_name is not None:
            pulumi.set(__self__, "collection_name", collection_name)
        if full_document is not None:
            pulumi.set(__self__, "full_document", full_document)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        Name of the database to consume within the DocumentDB cluster.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="collectionName")
    def collection_name(self) -> Optional[builtins.str]:
        """
        Name of the collection to consume within the database. If you do not specify a collection, Lambda consumes all collections.
        """
        return pulumi.get(self, "collection_name")

    @property
    @pulumi.getter(name="fullDocument")
    def full_document(self) -> Optional[builtins.str]:
        """
        Determines what DocumentDB sends to your event stream during document update operations. If set to `UpdateLookup`, DocumentDB sends a delta describing the changes, along with a copy of the entire document. Otherwise, DocumentDB sends only a partial document that contains the changes. Valid values: `UpdateLookup`, `Default`.
        """
        return pulumi.get(self, "full_document")


@pulumi.output_type
class EventSourceMappingFilterCriteria(dict):
    def __init__(__self__, *,
                 filters: Optional[Sequence['outputs.EventSourceMappingFilterCriteriaFilter']] = None):
        """
        :param Sequence['EventSourceMappingFilterCriteriaFilterArgs'] filters: Set of up to 5 filter. If an event satisfies at least one, Lambda sends the event to the function or adds it to the next batch. See below.
        """
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.EventSourceMappingFilterCriteriaFilter']]:
        """
        Set of up to 5 filter. If an event satisfies at least one, Lambda sends the event to the function or adds it to the next batch. See below.
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class EventSourceMappingFilterCriteriaFilter(dict):
    def __init__(__self__, *,
                 pattern: Optional[builtins.str] = None):
        """
        :param builtins.str pattern: Filter pattern up to 4096 characters. See [Filter Rule Syntax](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-syntax).
        """
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[builtins.str]:
        """
        Filter pattern up to 4096 characters. See [Filter Rule Syntax](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-syntax).
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class EventSourceMappingMetricsConfig(dict):
    def __init__(__self__, *,
                 metrics: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] metrics: List containing the metrics to be produced by the event source mapping. Valid values: `EventCount`.
        """
        pulumi.set(__self__, "metrics", metrics)

    @property
    @pulumi.getter
    def metrics(self) -> Sequence[builtins.str]:
        """
        List containing the metrics to be produced by the event source mapping. Valid values: `EventCount`.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class EventSourceMappingProvisionedPollerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumPollers":
            suggest = "maximum_pollers"
        elif key == "minimumPollers":
            suggest = "minimum_pollers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingProvisionedPollerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingProvisionedPollerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingProvisionedPollerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_pollers: Optional[builtins.int] = None,
                 minimum_pollers: Optional[builtins.int] = None):
        """
        :param builtins.int maximum_pollers: Maximum number of event pollers this event source can scale up to. The range is between 1 and 2000.
        :param builtins.int minimum_pollers: Minimum number of event pollers this event source can scale down to. The range is between 1 and 200.
        """
        if maximum_pollers is not None:
            pulumi.set(__self__, "maximum_pollers", maximum_pollers)
        if minimum_pollers is not None:
            pulumi.set(__self__, "minimum_pollers", minimum_pollers)

    @property
    @pulumi.getter(name="maximumPollers")
    def maximum_pollers(self) -> Optional[builtins.int]:
        """
        Maximum number of event pollers this event source can scale up to. The range is between 1 and 2000.
        """
        return pulumi.get(self, "maximum_pollers")

    @property
    @pulumi.getter(name="minimumPollers")
    def minimum_pollers(self) -> Optional[builtins.int]:
        """
        Minimum number of event pollers this event source can scale down to. The range is between 1 and 200.
        """
        return pulumi.get(self, "minimum_pollers")


@pulumi.output_type
class EventSourceMappingScalingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumConcurrency":
            suggest = "maximum_concurrency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingScalingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingScalingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingScalingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_concurrency: Optional[builtins.int] = None):
        """
        :param builtins.int maximum_concurrency: Limits the number of concurrent instances that the Amazon SQS event source can invoke. Must be greater than or equal to 2. See [Configuring maximum concurrency for Amazon SQS event sources](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency). You need to raise a [Service Quota Ticket](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to increase the concurrency beyond 1000.
        """
        if maximum_concurrency is not None:
            pulumi.set(__self__, "maximum_concurrency", maximum_concurrency)

    @property
    @pulumi.getter(name="maximumConcurrency")
    def maximum_concurrency(self) -> Optional[builtins.int]:
        """
        Limits the number of concurrent instances that the Amazon SQS event source can invoke. Must be greater than or equal to 2. See [Configuring maximum concurrency for Amazon SQS event sources](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency). You need to raise a [Service Quota Ticket](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to increase the concurrency beyond 1000.
        """
        return pulumi.get(self, "maximum_concurrency")


@pulumi.output_type
class EventSourceMappingSelfManagedEventSource(dict):
    def __init__(__self__, *,
                 endpoints: Mapping[str, builtins.str]):
        """
        :param Mapping[str, builtins.str] endpoints: Map of endpoints for the self managed source. For Kafka self-managed sources, the key should be `KAFKA_BOOTSTRAP_SERVERS` and the value should be a string with a comma separated list of broker endpoints.
        """
        pulumi.set(__self__, "endpoints", endpoints)

    @property
    @pulumi.getter
    def endpoints(self) -> Mapping[str, builtins.str]:
        """
        Map of endpoints for the self managed source. For Kafka self-managed sources, the key should be `KAFKA_BOOTSTRAP_SERVERS` and the value should be a string with a comma separated list of broker endpoints.
        """
        return pulumi.get(self, "endpoints")


@pulumi.output_type
class EventSourceMappingSelfManagedKafkaEventSourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerGroupId":
            suggest = "consumer_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSourceMappingSelfManagedKafkaEventSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSourceMappingSelfManagedKafkaEventSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSourceMappingSelfManagedKafkaEventSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_group_id: Optional[builtins.str] = None):
        """
        :param builtins.str consumer_group_id: Kafka consumer group ID between 1 and 200 characters for use when creating this event source mapping. If one is not specified, this value will be automatically generated. See [SelfManagedKafkaEventSourceConfig Syntax](https://docs.aws.amazon.com/lambda/latest/dg/API_SelfManagedKafkaEventSourceConfig.html).
        """
        if consumer_group_id is not None:
            pulumi.set(__self__, "consumer_group_id", consumer_group_id)

    @property
    @pulumi.getter(name="consumerGroupId")
    def consumer_group_id(self) -> Optional[builtins.str]:
        """
        Kafka consumer group ID between 1 and 200 characters for use when creating this event source mapping. If one is not specified, this value will be automatically generated. See [SelfManagedKafkaEventSourceConfig Syntax](https://docs.aws.amazon.com/lambda/latest/dg/API_SelfManagedKafkaEventSourceConfig.html).
        """
        return pulumi.get(self, "consumer_group_id")


@pulumi.output_type
class EventSourceMappingSourceAccessConfiguration(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 uri: builtins.str):
        """
        :param builtins.str type: Type of authentication protocol, VPC components, or virtual host for your event source. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/lambda/latest/api/API_SourceAccessConfiguration.html).
        :param builtins.str uri: URI for this configuration. For type `VPC_SUBNET` the value should be `subnet:subnet_id` where `subnet_id` is the value you would find in an ec2.Subnet resource's id attribute. For type `VPC_SECURITY_GROUP` the value should be `security_group:security_group_id` where `security_group_id` is the value you would find in an ec2.SecurityGroup resource's id attribute.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of authentication protocol, VPC components, or virtual host for your event source. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/lambda/latest/api/API_SourceAccessConfiguration.html).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        URI for this configuration. For type `VPC_SUBNET` the value should be `subnet:subnet_id` where `subnet_id` is the value you would find in an ec2.Subnet resource's id attribute. For type `VPC_SECURITY_GROUP` the value should be `security_group:security_group_id` where `security_group_id` is the value you would find in an ec2.SecurityGroup resource's id attribute.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class FunctionDeadLetterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetArn":
            suggest = "target_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionDeadLetterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionDeadLetterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionDeadLetterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_arn: builtins.str):
        """
        :param builtins.str target_arn: ARN of an SNS topic or SQS queue to notify when an invocation fails.
        """
        pulumi.set(__self__, "target_arn", target_arn)

    @property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> builtins.str:
        """
        ARN of an SNS topic or SQS queue to notify when an invocation fails.
        """
        return pulumi.get(self, "target_arn")


@pulumi.output_type
class FunctionEnvironment(dict):
    def __init__(__self__, *,
                 variables: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Mapping[str, builtins.str] variables: Map of environment variables available to your Lambda function during execution.
        """
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def variables(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Map of environment variables available to your Lambda function during execution.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class FunctionEphemeralStorage(dict):
    def __init__(__self__, *,
                 size: Optional[builtins.int] = None):
        """
        :param builtins.int size: Amount of ephemeral storage (`/tmp`) in MB. Valid between 512 MB and 10,240 MB (10 GB).
        """
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.int]:
        """
        Amount of ephemeral storage (`/tmp`) in MB. Valid between 512 MB and 10,240 MB (10 GB).
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class FunctionEventInvokeConfigDestinationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onFailure":
            suggest = "on_failure"
        elif key == "onSuccess":
            suggest = "on_success"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionEventInvokeConfigDestinationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionEventInvokeConfigDestinationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionEventInvokeConfigDestinationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_failure: Optional['outputs.FunctionEventInvokeConfigDestinationConfigOnFailure'] = None,
                 on_success: Optional['outputs.FunctionEventInvokeConfigDestinationConfigOnSuccess'] = None):
        """
        :param 'FunctionEventInvokeConfigDestinationConfigOnFailureArgs' on_failure: Configuration block with destination configuration for failed asynchronous invocations. See below.
        :param 'FunctionEventInvokeConfigDestinationConfigOnSuccessArgs' on_success: Configuration block with destination configuration for successful asynchronous invocations. See below.
        """
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)
        if on_success is not None:
            pulumi.set(__self__, "on_success", on_success)

    @property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional['outputs.FunctionEventInvokeConfigDestinationConfigOnFailure']:
        """
        Configuration block with destination configuration for failed asynchronous invocations. See below.
        """
        return pulumi.get(self, "on_failure")

    @property
    @pulumi.getter(name="onSuccess")
    def on_success(self) -> Optional['outputs.FunctionEventInvokeConfigDestinationConfigOnSuccess']:
        """
        Configuration block with destination configuration for successful asynchronous invocations. See below.
        """
        return pulumi.get(self, "on_success")


@pulumi.output_type
class FunctionEventInvokeConfigDestinationConfigOnFailure(dict):
    def __init__(__self__, *,
                 destination: builtins.str):
        """
        :param builtins.str destination: ARN of the destination resource. See the [Lambda Developer Guide](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations) for acceptable resource types and associated IAM permissions.
        """
        pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter
    def destination(self) -> builtins.str:
        """
        ARN of the destination resource. See the [Lambda Developer Guide](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations) for acceptable resource types and associated IAM permissions.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class FunctionEventInvokeConfigDestinationConfigOnSuccess(dict):
    def __init__(__self__, *,
                 destination: builtins.str):
        """
        :param builtins.str destination: ARN of the destination resource. See the [Lambda Developer Guide](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations) for acceptable resource types and associated IAM permissions.
        """
        pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter
    def destination(self) -> builtins.str:
        """
        ARN of the destination resource. See the [Lambda Developer Guide](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations) for acceptable resource types and associated IAM permissions.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class FunctionFileSystemConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localMountPath":
            suggest = "local_mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionFileSystemConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionFileSystemConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionFileSystemConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: builtins.str,
                 local_mount_path: builtins.str):
        """
        :param builtins.str arn: ARN of the Amazon EFS Access Point.
        :param builtins.str local_mount_path: Path where the function can access the file system. Must start with `/mnt/`.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "local_mount_path", local_mount_path)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the Amazon EFS Access Point.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="localMountPath")
    def local_mount_path(self) -> builtins.str:
        """
        Path where the function can access the file system. Must start with `/mnt/`.
        """
        return pulumi.get(self, "local_mount_path")


@pulumi.output_type
class FunctionImageConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entryPoints":
            suggest = "entry_points"
        elif key == "workingDirectory":
            suggest = "working_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionImageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionImageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionImageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Optional[Sequence[builtins.str]] = None,
                 entry_points: Optional[Sequence[builtins.str]] = None,
                 working_directory: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] commands: Parameters to pass to the container image.
        :param Sequence[builtins.str] entry_points: Entry point to your application.
        :param builtins.str working_directory: Working directory for the container image.
        """
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if entry_points is not None:
            pulumi.set(__self__, "entry_points", entry_points)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[builtins.str]]:
        """
        Parameters to pass to the container image.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="entryPoints")
    def entry_points(self) -> Optional[Sequence[builtins.str]]:
        """
        Entry point to your application.
        """
        return pulumi.get(self, "entry_points")

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[builtins.str]:
        """
        Working directory for the container image.
        """
        return pulumi.get(self, "working_directory")


@pulumi.output_type
class FunctionLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logFormat":
            suggest = "log_format"
        elif key == "applicationLogLevel":
            suggest = "application_log_level"
        elif key == "logGroup":
            suggest = "log_group"
        elif key == "systemLogLevel":
            suggest = "system_log_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_format: builtins.str,
                 application_log_level: Optional[builtins.str] = None,
                 log_group: Optional[builtins.str] = None,
                 system_log_level: Optional[builtins.str] = None):
        """
        :param builtins.str log_format: Log format. Valid values: `Text`, `JSON`.
        :param builtins.str application_log_level: Detail level of application logs. Valid values: `TRACE`, `DEBUG`, `INFO`, `WARN`, `ERROR`, `FATAL`.
        :param builtins.str log_group: CloudWatch log group where logs are sent.
        :param builtins.str system_log_level: Detail level of Lambda platform logs. Valid values: `DEBUG`, `INFO`, `WARN`.
        """
        pulumi.set(__self__, "log_format", log_format)
        if application_log_level is not None:
            pulumi.set(__self__, "application_log_level", application_log_level)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)
        if system_log_level is not None:
            pulumi.set(__self__, "system_log_level", system_log_level)

    @property
    @pulumi.getter(name="logFormat")
    def log_format(self) -> builtins.str:
        """
        Log format. Valid values: `Text`, `JSON`.
        """
        return pulumi.get(self, "log_format")

    @property
    @pulumi.getter(name="applicationLogLevel")
    def application_log_level(self) -> Optional[builtins.str]:
        """
        Detail level of application logs. Valid values: `TRACE`, `DEBUG`, `INFO`, `WARN`, `ERROR`, `FATAL`.
        """
        return pulumi.get(self, "application_log_level")

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional[builtins.str]:
        """
        CloudWatch log group where logs are sent.
        """
        return pulumi.get(self, "log_group")

    @property
    @pulumi.getter(name="systemLogLevel")
    def system_log_level(self) -> Optional[builtins.str]:
        """
        Detail level of Lambda platform logs. Valid values: `DEBUG`, `INFO`, `WARN`.
        """
        return pulumi.get(self, "system_log_level")


@pulumi.output_type
class FunctionSnapStart(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyOn":
            suggest = "apply_on"
        elif key == "optimizationStatus":
            suggest = "optimization_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionSnapStart. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionSnapStart.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionSnapStart.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apply_on: builtins.str,
                 optimization_status: Optional[builtins.str] = None):
        """
        :param builtins.str apply_on: When to apply snap start optimization. Valid value: `PublishedVersions`.
        :param builtins.str optimization_status: Optimization status of the snap start configuration. Valid values are `On` and `Off`.
        """
        pulumi.set(__self__, "apply_on", apply_on)
        if optimization_status is not None:
            pulumi.set(__self__, "optimization_status", optimization_status)

    @property
    @pulumi.getter(name="applyOn")
    def apply_on(self) -> builtins.str:
        """
        When to apply snap start optimization. Valid value: `PublishedVersions`.
        """
        return pulumi.get(self, "apply_on")

    @property
    @pulumi.getter(name="optimizationStatus")
    def optimization_status(self) -> Optional[builtins.str]:
        """
        Optimization status of the snap start configuration. Valid values are `On` and `Off`.
        """
        return pulumi.get(self, "optimization_status")


@pulumi.output_type
class FunctionTracingConfig(dict):
    def __init__(__self__, *,
                 mode: builtins.str):
        """
        :param builtins.str mode: X-Ray tracing mode. Valid values: `Active`, `PassThrough`.
        """
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        X-Ray tracing mode. Valid values: `Active`, `PassThrough`.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class FunctionUrlCors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowHeaders":
            suggest = "allow_headers"
        elif key == "allowMethods":
            suggest = "allow_methods"
        elif key == "allowOrigins":
            suggest = "allow_origins"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAge":
            suggest = "max_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionUrlCors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionUrlCors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionUrlCors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_credentials: Optional[builtins.bool] = None,
                 allow_headers: Optional[Sequence[builtins.str]] = None,
                 allow_methods: Optional[Sequence[builtins.str]] = None,
                 allow_origins: Optional[Sequence[builtins.str]] = None,
                 expose_headers: Optional[Sequence[builtins.str]] = None,
                 max_age: Optional[builtins.int] = None):
        """
        :param builtins.bool allow_credentials: Whether to allow cookies or other credentials in requests to the function URL.
        :param Sequence[builtins.str] allow_headers: HTTP headers that origins can include in requests to the function URL.
        :param Sequence[builtins.str] allow_methods: HTTP methods that are allowed when calling the function URL.
        :param Sequence[builtins.str] allow_origins: Origins that can access the function URL.
        :param Sequence[builtins.str] expose_headers: HTTP headers in your function response that you want to expose to origins that call the function URL.
        :param builtins.int max_age: Maximum amount of time, in seconds, that web browsers can cache results of a preflight request. Maximum value is `86400`.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[builtins.bool]:
        """
        Whether to allow cookies or other credentials in requests to the function URL.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        HTTP headers that origins can include in requests to the function URL.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[Sequence[builtins.str]]:
        """
        HTTP methods that are allowed when calling the function URL.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional[Sequence[builtins.str]]:
        """
        Origins that can access the function URL.
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        HTTP headers in your function response that you want to expose to origins that call the function URL.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[builtins.int]:
        """
        Maximum amount of time, in seconds, that web browsers can cache results of a preflight request. Maximum value is `86400`.
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class FunctionVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "ipv6AllowedForDualStack":
            suggest = "ipv6_allowed_for_dual_stack"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[builtins.str],
                 subnet_ids: Sequence[builtins.str],
                 ipv6_allowed_for_dual_stack: Optional[builtins.bool] = None,
                 vpc_id: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] security_group_ids: List of security group IDs associated with the Lambda function.
        :param Sequence[builtins.str] subnet_ids: List of subnet IDs associated with the Lambda function.
        :param builtins.bool ipv6_allowed_for_dual_stack: Whether to allow outbound IPv6 traffic on VPC functions connected to dual-stack subnets. Default: `false`.
        :param builtins.str vpc_id: ID of the VPC.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if ipv6_allowed_for_dual_stack is not None:
            pulumi.set(__self__, "ipv6_allowed_for_dual_stack", ipv6_allowed_for_dual_stack)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[builtins.str]:
        """
        List of security group IDs associated with the Lambda function.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        """
        List of subnet IDs associated with the Lambda function.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="ipv6AllowedForDualStack")
    def ipv6_allowed_for_dual_stack(self) -> Optional[builtins.bool]:
        """
        Whether to allow outbound IPv6 traffic on VPC functions connected to dual-stack subnets. Default: `false`.
        """
        return pulumi.get(self, "ipv6_allowed_for_dual_stack")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[builtins.str]:
        """
        ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetCodeSigningConfigAllowedPublisherResult(dict):
    def __init__(__self__, *,
                 signing_profile_version_arns: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] signing_profile_version_arns: Set of ARNs for each of the signing profiles. A signing profile defines a trusted user who can sign a code package.
        """
        pulumi.set(__self__, "signing_profile_version_arns", signing_profile_version_arns)

    @property
    @pulumi.getter(name="signingProfileVersionArns")
    def signing_profile_version_arns(self) -> Sequence[builtins.str]:
        """
        Set of ARNs for each of the signing profiles. A signing profile defines a trusted user who can sign a code package.
        """
        return pulumi.get(self, "signing_profile_version_arns")


@pulumi.output_type
class GetCodeSigningConfigPolicyResult(dict):
    def __init__(__self__, *,
                 untrusted_artifact_on_deployment: builtins.str):
        """
        :param builtins.str untrusted_artifact_on_deployment: Code signing configuration policy for deployment validation failure. Valid values: `Warn`, `Enforce`.
        """
        pulumi.set(__self__, "untrusted_artifact_on_deployment", untrusted_artifact_on_deployment)

    @property
    @pulumi.getter(name="untrustedArtifactOnDeployment")
    def untrusted_artifact_on_deployment(self) -> builtins.str:
        """
        Code signing configuration policy for deployment validation failure. Valid values: `Warn`, `Enforce`.
        """
        return pulumi.get(self, "untrusted_artifact_on_deployment")


@pulumi.output_type
class GetFunctionDeadLetterConfigResult(dict):
    def __init__(__self__, *,
                 target_arn: builtins.str):
        """
        :param builtins.str target_arn: ARN of an SNS topic or SQS queue to notify when an invocation fails.
        """
        pulumi.set(__self__, "target_arn", target_arn)

    @property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> builtins.str:
        """
        ARN of an SNS topic or SQS queue to notify when an invocation fails.
        """
        return pulumi.get(self, "target_arn")


@pulumi.output_type
class GetFunctionEnvironmentResult(dict):
    def __init__(__self__, *,
                 variables: Mapping[str, builtins.str]):
        """
        :param Mapping[str, builtins.str] variables: Map of environment variables that are accessible from the function code during execution.
        """
        pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def variables(self) -> Mapping[str, builtins.str]:
        """
        Map of environment variables that are accessible from the function code during execution.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class GetFunctionEphemeralStorageResult(dict):
    def __init__(__self__, *,
                 size: builtins.int):
        """
        :param builtins.int size: Size of the Lambda function ephemeral storage (`/tmp`) in MB.
        """
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def size(self) -> builtins.int:
        """
        Size of the Lambda function ephemeral storage (`/tmp`) in MB.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class GetFunctionFileSystemConfigResult(dict):
    def __init__(__self__, *,
                 arn: builtins.str,
                 local_mount_path: builtins.str):
        """
        :param builtins.str arn: ARN of the Amazon EFS Access Point that provides access to the file system.
        :param builtins.str local_mount_path: Path where the function can access the file system, starting with `/mnt/`.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "local_mount_path", local_mount_path)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the Amazon EFS Access Point that provides access to the file system.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="localMountPath")
    def local_mount_path(self) -> builtins.str:
        """
        Path where the function can access the file system, starting with `/mnt/`.
        """
        return pulumi.get(self, "local_mount_path")


@pulumi.output_type
class GetFunctionLoggingConfigResult(dict):
    def __init__(__self__, *,
                 application_log_level: builtins.str,
                 log_format: builtins.str,
                 log_group: builtins.str,
                 system_log_level: builtins.str):
        """
        :param builtins.str application_log_level: Detail level of the logs your application sends to CloudWatch when using supported logging libraries.
        :param builtins.str log_format: Format for your function's logs. Valid values: `Text`, `JSON`.
        :param builtins.str log_group: CloudWatch log group your function sends logs to.
        :param builtins.str system_log_level: Detail level of the Lambda platform event logs sent to CloudWatch.
        """
        pulumi.set(__self__, "application_log_level", application_log_level)
        pulumi.set(__self__, "log_format", log_format)
        pulumi.set(__self__, "log_group", log_group)
        pulumi.set(__self__, "system_log_level", system_log_level)

    @property
    @pulumi.getter(name="applicationLogLevel")
    def application_log_level(self) -> builtins.str:
        """
        Detail level of the logs your application sends to CloudWatch when using supported logging libraries.
        """
        return pulumi.get(self, "application_log_level")

    @property
    @pulumi.getter(name="logFormat")
    def log_format(self) -> builtins.str:
        """
        Format for your function's logs. Valid values: `Text`, `JSON`.
        """
        return pulumi.get(self, "log_format")

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> builtins.str:
        """
        CloudWatch log group your function sends logs to.
        """
        return pulumi.get(self, "log_group")

    @property
    @pulumi.getter(name="systemLogLevel")
    def system_log_level(self) -> builtins.str:
        """
        Detail level of the Lambda platform event logs sent to CloudWatch.
        """
        return pulumi.get(self, "system_log_level")


@pulumi.output_type
class GetFunctionTracingConfigResult(dict):
    def __init__(__self__, *,
                 mode: builtins.str):
        """
        :param builtins.str mode: Tracing mode. Valid values: `Active`, `PassThrough`.
        """
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        Tracing mode. Valid values: `Active`, `PassThrough`.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class GetFunctionUrlCorResult(dict):
    def __init__(__self__, *,
                 allow_credentials: builtins.bool,
                 allow_headers: Sequence[builtins.str],
                 allow_methods: Sequence[builtins.str],
                 allow_origins: Sequence[builtins.str],
                 expose_headers: Sequence[builtins.str],
                 max_age: builtins.int):
        """
        :param builtins.bool allow_credentials: Whether credentials are included in the CORS request.
        :param Sequence[builtins.str] allow_headers: List of headers that are specified in the Access-Control-Request-Headers header.
        :param Sequence[builtins.str] allow_methods: List of HTTP methods that are allowed when calling the function URL.
        :param Sequence[builtins.str] allow_origins: List of origins that are allowed to make requests to the function URL.
        :param Sequence[builtins.str] expose_headers: List of headers in the response that you want to expose to the origin that called the function URL.
        :param builtins.int max_age: Maximum amount of time, in seconds, that web browsers can cache results of a preflight request.
        """
        pulumi.set(__self__, "allow_credentials", allow_credentials)
        pulumi.set(__self__, "allow_headers", allow_headers)
        pulumi.set(__self__, "allow_methods", allow_methods)
        pulumi.set(__self__, "allow_origins", allow_origins)
        pulumi.set(__self__, "expose_headers", expose_headers)
        pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> builtins.bool:
        """
        Whether credentials are included in the CORS request.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Sequence[builtins.str]:
        """
        List of headers that are specified in the Access-Control-Request-Headers header.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Sequence[builtins.str]:
        """
        List of HTTP methods that are allowed when calling the function URL.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Sequence[builtins.str]:
        """
        List of origins that are allowed to make requests to the function URL.
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Sequence[builtins.str]:
        """
        List of headers in the response that you want to expose to the origin that called the function URL.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> builtins.int:
        """
        Maximum amount of time, in seconds, that web browsers can cache results of a preflight request.
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class GetFunctionVpcConfigResult(dict):
    def __init__(__self__, *,
                 ipv6_allowed_for_dual_stack: builtins.bool,
                 security_group_ids: Sequence[builtins.str],
                 subnet_ids: Sequence[builtins.str],
                 vpc_id: builtins.str):
        """
        :param Sequence[builtins.str] security_group_ids: List of security group IDs associated with the Lambda function.
        :param Sequence[builtins.str] subnet_ids: List of subnet IDs associated with the Lambda function.
        :param builtins.str vpc_id: ID of the VPC.
        """
        pulumi.set(__self__, "ipv6_allowed_for_dual_stack", ipv6_allowed_for_dual_stack)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="ipv6AllowedForDualStack")
    def ipv6_allowed_for_dual_stack(self) -> builtins.bool:
        return pulumi.get(self, "ipv6_allowed_for_dual_stack")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[builtins.str]:
        """
        List of security group IDs associated with the Lambda function.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        """
        List of subnet IDs associated with the Lambda function.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> builtins.str:
        """
        ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")


