# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PermissionArgs', 'Permission']

@pulumi.input_type
class PermissionArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[builtins.str],
                 function: pulumi.Input[builtins.str],
                 principal: pulumi.Input[builtins.str],
                 event_source_token: Optional[pulumi.Input[builtins.str]] = None,
                 function_url_auth_type: Optional[pulumi.Input[builtins.str]] = None,
                 principal_org_id: Optional[pulumi.Input[builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 source_account: Optional[pulumi.Input[builtins.str]] = None,
                 source_arn: Optional[pulumi.Input[builtins.str]] = None,
                 statement_id: Optional[pulumi.Input[builtins.str]] = None,
                 statement_id_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Permission resource.
        :param pulumi.Input[builtins.str] action: Lambda action to allow in this statement (e.g., `lambda:InvokeFunction`)
        :param pulumi.Input[builtins.str] function: Name of the Lambda function
        :param pulumi.Input[builtins.str] principal: AWS service or account that invokes the function (e.g., `s3.amazonaws.com`, `sns.amazonaws.com`, AWS account ID, or AWS IAM principal)
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] event_source_token: Event Source Token for Alexa Skills
        :param pulumi.Input[builtins.str] function_url_auth_type: Lambda Function URL authentication type. Valid values: `AWS_IAM` or `NONE`. Only valid with `lambda:InvokeFunctionUrl` action
        :param pulumi.Input[builtins.str] principal_org_id: AWS Organizations ID to grant permission to all accounts under this organization
        :param pulumi.Input[builtins.str] qualifier: Lambda function version or alias name
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration
        :param pulumi.Input[builtins.str] source_account: AWS account ID of the source owner for cross-account access, S3, or SES
        :param pulumi.Input[builtins.str] source_arn: ARN of the source resource granting permission to invoke the Lambda function
        :param pulumi.Input[builtins.str] statement_id: Statement identifier. Generated by Pulumi if not provided
        :param pulumi.Input[builtins.str] statement_id_prefix: Statement identifier prefix. Conflicts with `statement_id`
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "function", function)
        pulumi.set(__self__, "principal", principal)
        if event_source_token is not None:
            pulumi.set(__self__, "event_source_token", event_source_token)
        if function_url_auth_type is not None:
            pulumi.set(__self__, "function_url_auth_type", function_url_auth_type)
        if principal_org_id is not None:
            pulumi.set(__self__, "principal_org_id", principal_org_id)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_account is not None:
            pulumi.set(__self__, "source_account", source_account)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)
        if statement_id is not None:
            pulumi.set(__self__, "statement_id", statement_id)
        if statement_id_prefix is not None:
            pulumi.set(__self__, "statement_id_prefix", statement_id_prefix)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[builtins.str]:
        """
        Lambda action to allow in this statement (e.g., `lambda:InvokeFunction`)
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def function(self) -> pulumi.Input[builtins.str]:
        """
        Name of the Lambda function
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Input[builtins.str]:
        """
        AWS service or account that invokes the function (e.g., `s3.amazonaws.com`, `sns.amazonaws.com`, AWS account ID, or AWS IAM principal)

        The following arguments are optional:
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "principal", value)

    @property
    @pulumi.getter(name="eventSourceToken")
    def event_source_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Event Source Token for Alexa Skills
        """
        return pulumi.get(self, "event_source_token")

    @event_source_token.setter
    def event_source_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_source_token", value)

    @property
    @pulumi.getter(name="functionUrlAuthType")
    def function_url_auth_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lambda Function URL authentication type. Valid values: `AWS_IAM` or `NONE`. Only valid with `lambda:InvokeFunctionUrl` action
        """
        return pulumi.get(self, "function_url_auth_type")

    @function_url_auth_type.setter
    def function_url_auth_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "function_url_auth_type", value)

    @property
    @pulumi.getter(name="principalOrgId")
    def principal_org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS Organizations ID to grant permission to all accounts under this organization
        """
        return pulumi.get(self, "principal_org_id")

    @principal_org_id.setter
    def principal_org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_org_id", value)

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lambda function version or alias name
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "qualifier", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sourceAccount")
    def source_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS account ID of the source owner for cross-account access, S3, or SES
        """
        return pulumi.get(self, "source_account")

    @source_account.setter
    def source_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_account", value)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the source resource granting permission to invoke the Lambda function
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_arn", value)

    @property
    @pulumi.getter(name="statementId")
    def statement_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Statement identifier. Generated by Pulumi if not provided
        """
        return pulumi.get(self, "statement_id")

    @statement_id.setter
    def statement_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "statement_id", value)

    @property
    @pulumi.getter(name="statementIdPrefix")
    def statement_id_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Statement identifier prefix. Conflicts with `statement_id`
        """
        return pulumi.get(self, "statement_id_prefix")

    @statement_id_prefix.setter
    def statement_id_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "statement_id_prefix", value)


@pulumi.input_type
class _PermissionState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 event_source_token: Optional[pulumi.Input[builtins.str]] = None,
                 function: Optional[pulumi.Input[builtins.str]] = None,
                 function_url_auth_type: Optional[pulumi.Input[builtins.str]] = None,
                 principal: Optional[pulumi.Input[builtins.str]] = None,
                 principal_org_id: Optional[pulumi.Input[builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 source_account: Optional[pulumi.Input[builtins.str]] = None,
                 source_arn: Optional[pulumi.Input[builtins.str]] = None,
                 statement_id: Optional[pulumi.Input[builtins.str]] = None,
                 statement_id_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Permission resources.
        :param pulumi.Input[builtins.str] action: Lambda action to allow in this statement (e.g., `lambda:InvokeFunction`)
        :param pulumi.Input[builtins.str] event_source_token: Event Source Token for Alexa Skills
        :param pulumi.Input[builtins.str] function: Name of the Lambda function
        :param pulumi.Input[builtins.str] function_url_auth_type: Lambda Function URL authentication type. Valid values: `AWS_IAM` or `NONE`. Only valid with `lambda:InvokeFunctionUrl` action
        :param pulumi.Input[builtins.str] principal: AWS service or account that invokes the function (e.g., `s3.amazonaws.com`, `sns.amazonaws.com`, AWS account ID, or AWS IAM principal)
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] principal_org_id: AWS Organizations ID to grant permission to all accounts under this organization
        :param pulumi.Input[builtins.str] qualifier: Lambda function version or alias name
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration
        :param pulumi.Input[builtins.str] source_account: AWS account ID of the source owner for cross-account access, S3, or SES
        :param pulumi.Input[builtins.str] source_arn: ARN of the source resource granting permission to invoke the Lambda function
        :param pulumi.Input[builtins.str] statement_id: Statement identifier. Generated by Pulumi if not provided
        :param pulumi.Input[builtins.str] statement_id_prefix: Statement identifier prefix. Conflicts with `statement_id`
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if event_source_token is not None:
            pulumi.set(__self__, "event_source_token", event_source_token)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if function_url_auth_type is not None:
            pulumi.set(__self__, "function_url_auth_type", function_url_auth_type)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if principal_org_id is not None:
            pulumi.set(__self__, "principal_org_id", principal_org_id)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_account is not None:
            pulumi.set(__self__, "source_account", source_account)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)
        if statement_id is not None:
            pulumi.set(__self__, "statement_id", statement_id)
        if statement_id_prefix is not None:
            pulumi.set(__self__, "statement_id_prefix", statement_id_prefix)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lambda action to allow in this statement (e.g., `lambda:InvokeFunction`)
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="eventSourceToken")
    def event_source_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Event Source Token for Alexa Skills
        """
        return pulumi.get(self, "event_source_token")

    @event_source_token.setter
    def event_source_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_source_token", value)

    @property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Lambda function
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter(name="functionUrlAuthType")
    def function_url_auth_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lambda Function URL authentication type. Valid values: `AWS_IAM` or `NONE`. Only valid with `lambda:InvokeFunctionUrl` action
        """
        return pulumi.get(self, "function_url_auth_type")

    @function_url_auth_type.setter
    def function_url_auth_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "function_url_auth_type", value)

    @property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS service or account that invokes the function (e.g., `s3.amazonaws.com`, `sns.amazonaws.com`, AWS account ID, or AWS IAM principal)

        The following arguments are optional:
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal", value)

    @property
    @pulumi.getter(name="principalOrgId")
    def principal_org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS Organizations ID to grant permission to all accounts under this organization
        """
        return pulumi.get(self, "principal_org_id")

    @principal_org_id.setter
    def principal_org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_org_id", value)

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lambda function version or alias name
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "qualifier", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sourceAccount")
    def source_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS account ID of the source owner for cross-account access, S3, or SES
        """
        return pulumi.get(self, "source_account")

    @source_account.setter
    def source_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_account", value)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the source resource granting permission to invoke the Lambda function
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_arn", value)

    @property
    @pulumi.getter(name="statementId")
    def statement_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Statement identifier. Generated by Pulumi if not provided
        """
        return pulumi.get(self, "statement_id")

    @statement_id.setter
    def statement_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "statement_id", value)

    @property
    @pulumi.getter(name="statementIdPrefix")
    def statement_id_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Statement identifier prefix. Conflicts with `statement_id`
        """
        return pulumi.get(self, "statement_id_prefix")

    @statement_id_prefix.setter
    def statement_id_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "statement_id_prefix", value)


@pulumi.type_token("aws:lambda/permission:Permission")
class Permission(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 event_source_token: Optional[pulumi.Input[builtins.str]] = None,
                 function: Optional[pulumi.Input[builtins.str]] = None,
                 function_url_auth_type: Optional[pulumi.Input[builtins.str]] = None,
                 principal: Optional[pulumi.Input[builtins.str]] = None,
                 principal_org_id: Optional[pulumi.Input[builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 source_account: Optional[pulumi.Input[builtins.str]] = None,
                 source_arn: Optional[pulumi.Input[builtins.str]] = None,
                 statement_id: Optional[pulumi.Input[builtins.str]] = None,
                 statement_id_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an AWS Lambda permission. Use this resource to grant external sources (e.g., EventBridge Rules, SNS, or S3) permission to invoke Lambda functions.

        ## Example Usage

        ### Basic Usage with EventBridge

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        iam_for_lambda = aws.iam.Role("iam_for_lambda",
            name="iam_for_lambda",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Sid": "",
                    "Principal": {
                        "Service": "lambda.amazonaws.com",
                    },
                }],
            }))
        test_lambda = aws.lambda_.Function("test_lambda",
            code=pulumi.FileArchive("lambdatest.zip"),
            name="lambda_function_name",
            role=iam_for_lambda.arn,
            handler="exports.handler",
            runtime=aws.lambda_.Runtime.NODE_JS20D_X)
        test_alias = aws.lambda_.Alias("test_alias",
            name="testalias",
            description="a sample description",
            function_name=test_lambda.name,
            function_version="$LATEST")
        allow_cloudwatch = aws.lambda_.Permission("allow_cloudwatch",
            statement_id="AllowExecutionFromCloudWatch",
            action="lambda:InvokeFunction",
            function=test_lambda.name,
            principal="events.amazonaws.com",
            source_arn="arn:aws:events:eu-west-1:111122223333:rule/RunDaily",
            qualifier=test_alias.name)
        ```

        ### SNS Integration

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        default = aws.sns.Topic("default", name="call-lambda-maybe")
        default_role = aws.iam.Role("default",
            name="iam_for_lambda_with_sns",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Sid": "",
                    "Principal": {
                        "Service": "lambda.amazonaws.com",
                    },
                }],
            }))
        func = aws.lambda_.Function("func",
            code=pulumi.FileArchive("lambdatest.zip"),
            name="lambda_called_from_sns",
            role=default_role.arn,
            handler="exports.handler",
            runtime=aws.lambda_.Runtime.PYTHON3D12)
        with_sns = aws.lambda_.Permission("with_sns",
            statement_id="AllowExecutionFromSNS",
            action="lambda:InvokeFunction",
            function=func.name,
            principal="sns.amazonaws.com",
            source_arn=default.arn)
        lambda_ = aws.sns.TopicSubscription("lambda",
            topic=default.arn,
            protocol="lambda",
            endpoint=func.arn)
        ```

        ### API Gateway REST API Integration

        ```python
        import pulumi
        import pulumi_aws as aws

        my_demo_api = aws.apigateway.RestApi("MyDemoAPI",
            name="MyDemoAPI",
            description="This is my API for demonstration purposes")
        lambda_permission = aws.lambda_.Permission("lambda_permission",
            statement_id="AllowMyDemoAPIInvoke",
            action="lambda:InvokeFunction",
            function="MyDemoFunction",
            principal="apigateway.amazonaws.com",
            source_arn=my_demo_api.execution_arn.apply(lambda execution_arn: f"{execution_arn}/*"))
        ```

        ### CloudWatch Log Group Integration

        ```python
        import pulumi
        import pulumi_aws as aws

        default = aws.cloudwatch.LogGroup("default", name="/default")
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["lambda.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        default_role = aws.iam.Role("default",
            name="iam_for_lambda_called_from_cloudwatch_logs",
            assume_role_policy=assume_role.json)
        logging_function = aws.lambda_.Function("logging",
            code=pulumi.FileArchive("lamba_logging.zip"),
            name="lambda_called_from_cloudwatch_logs",
            handler="exports.handler",
            role=default_role.arn,
            runtime=aws.lambda_.Runtime.PYTHON3D12)
        logging = aws.lambda_.Permission("logging",
            action="lambda:InvokeFunction",
            function=logging_function.name,
            principal="logs.eu-west-1.amazonaws.com",
            source_arn=default.arn.apply(lambda arn: f"{arn}:*"))
        logging_log_subscription_filter = aws.cloudwatch.LogSubscriptionFilter("logging",
            destination_arn=logging_function.arn,
            filter_pattern="",
            log_group=default.name,
            name="logging_default",
            opts = pulumi.ResourceOptions(depends_on=[logging]))
        ```

        ### Cross-Account Function URL Access

        ```python
        import pulumi
        import pulumi_aws as aws

        url = aws.lambda_.FunctionUrl("url",
            function_name=example["functionName"],
            authorization_type="AWS_IAM")
        url_permission = aws.lambda_.Permission("url",
            action="lambda:InvokeFunctionUrl",
            function=example["functionName"],
            principal="arn:aws:iam::444455556666:role/example",
            source_account="444455556666",
            function_url_auth_type="AWS_IAM")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: Lambda action to allow in this statement (e.g., `lambda:InvokeFunction`)
        :param pulumi.Input[builtins.str] event_source_token: Event Source Token for Alexa Skills
        :param pulumi.Input[builtins.str] function: Name of the Lambda function
        :param pulumi.Input[builtins.str] function_url_auth_type: Lambda Function URL authentication type. Valid values: `AWS_IAM` or `NONE`. Only valid with `lambda:InvokeFunctionUrl` action
        :param pulumi.Input[builtins.str] principal: AWS service or account that invokes the function (e.g., `s3.amazonaws.com`, `sns.amazonaws.com`, AWS account ID, or AWS IAM principal)
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] principal_org_id: AWS Organizations ID to grant permission to all accounts under this organization
        :param pulumi.Input[builtins.str] qualifier: Lambda function version or alias name
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration
        :param pulumi.Input[builtins.str] source_account: AWS account ID of the source owner for cross-account access, S3, or SES
        :param pulumi.Input[builtins.str] source_arn: ARN of the source resource granting permission to invoke the Lambda function
        :param pulumi.Input[builtins.str] statement_id: Statement identifier. Generated by Pulumi if not provided
        :param pulumi.Input[builtins.str] statement_id_prefix: Statement identifier prefix. Conflicts with `statement_id`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PermissionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Lambda permission. Use this resource to grant external sources (e.g., EventBridge Rules, SNS, or S3) permission to invoke Lambda functions.

        ## Example Usage

        ### Basic Usage with EventBridge

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        iam_for_lambda = aws.iam.Role("iam_for_lambda",
            name="iam_for_lambda",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Sid": "",
                    "Principal": {
                        "Service": "lambda.amazonaws.com",
                    },
                }],
            }))
        test_lambda = aws.lambda_.Function("test_lambda",
            code=pulumi.FileArchive("lambdatest.zip"),
            name="lambda_function_name",
            role=iam_for_lambda.arn,
            handler="exports.handler",
            runtime=aws.lambda_.Runtime.NODE_JS20D_X)
        test_alias = aws.lambda_.Alias("test_alias",
            name="testalias",
            description="a sample description",
            function_name=test_lambda.name,
            function_version="$LATEST")
        allow_cloudwatch = aws.lambda_.Permission("allow_cloudwatch",
            statement_id="AllowExecutionFromCloudWatch",
            action="lambda:InvokeFunction",
            function=test_lambda.name,
            principal="events.amazonaws.com",
            source_arn="arn:aws:events:eu-west-1:111122223333:rule/RunDaily",
            qualifier=test_alias.name)
        ```

        ### SNS Integration

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        default = aws.sns.Topic("default", name="call-lambda-maybe")
        default_role = aws.iam.Role("default",
            name="iam_for_lambda_with_sns",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Sid": "",
                    "Principal": {
                        "Service": "lambda.amazonaws.com",
                    },
                }],
            }))
        func = aws.lambda_.Function("func",
            code=pulumi.FileArchive("lambdatest.zip"),
            name="lambda_called_from_sns",
            role=default_role.arn,
            handler="exports.handler",
            runtime=aws.lambda_.Runtime.PYTHON3D12)
        with_sns = aws.lambda_.Permission("with_sns",
            statement_id="AllowExecutionFromSNS",
            action="lambda:InvokeFunction",
            function=func.name,
            principal="sns.amazonaws.com",
            source_arn=default.arn)
        lambda_ = aws.sns.TopicSubscription("lambda",
            topic=default.arn,
            protocol="lambda",
            endpoint=func.arn)
        ```

        ### API Gateway REST API Integration

        ```python
        import pulumi
        import pulumi_aws as aws

        my_demo_api = aws.apigateway.RestApi("MyDemoAPI",
            name="MyDemoAPI",
            description="This is my API for demonstration purposes")
        lambda_permission = aws.lambda_.Permission("lambda_permission",
            statement_id="AllowMyDemoAPIInvoke",
            action="lambda:InvokeFunction",
            function="MyDemoFunction",
            principal="apigateway.amazonaws.com",
            source_arn=my_demo_api.execution_arn.apply(lambda execution_arn: f"{execution_arn}/*"))
        ```

        ### CloudWatch Log Group Integration

        ```python
        import pulumi
        import pulumi_aws as aws

        default = aws.cloudwatch.LogGroup("default", name="/default")
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["lambda.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        default_role = aws.iam.Role("default",
            name="iam_for_lambda_called_from_cloudwatch_logs",
            assume_role_policy=assume_role.json)
        logging_function = aws.lambda_.Function("logging",
            code=pulumi.FileArchive("lamba_logging.zip"),
            name="lambda_called_from_cloudwatch_logs",
            handler="exports.handler",
            role=default_role.arn,
            runtime=aws.lambda_.Runtime.PYTHON3D12)
        logging = aws.lambda_.Permission("logging",
            action="lambda:InvokeFunction",
            function=logging_function.name,
            principal="logs.eu-west-1.amazonaws.com",
            source_arn=default.arn.apply(lambda arn: f"{arn}:*"))
        logging_log_subscription_filter = aws.cloudwatch.LogSubscriptionFilter("logging",
            destination_arn=logging_function.arn,
            filter_pattern="",
            log_group=default.name,
            name="logging_default",
            opts = pulumi.ResourceOptions(depends_on=[logging]))
        ```

        ### Cross-Account Function URL Access

        ```python
        import pulumi
        import pulumi_aws as aws

        url = aws.lambda_.FunctionUrl("url",
            function_name=example["functionName"],
            authorization_type="AWS_IAM")
        url_permission = aws.lambda_.Permission("url",
            action="lambda:InvokeFunctionUrl",
            function=example["functionName"],
            principal="arn:aws:iam::444455556666:role/example",
            source_account="444455556666",
            function_url_auth_type="AWS_IAM")
        ```

        :param str resource_name: The name of the resource.
        :param PermissionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PermissionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 event_source_token: Optional[pulumi.Input[builtins.str]] = None,
                 function: Optional[pulumi.Input[builtins.str]] = None,
                 function_url_auth_type: Optional[pulumi.Input[builtins.str]] = None,
                 principal: Optional[pulumi.Input[builtins.str]] = None,
                 principal_org_id: Optional[pulumi.Input[builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 source_account: Optional[pulumi.Input[builtins.str]] = None,
                 source_arn: Optional[pulumi.Input[builtins.str]] = None,
                 statement_id: Optional[pulumi.Input[builtins.str]] = None,
                 statement_id_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PermissionArgs.__new__(PermissionArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["event_source_token"] = event_source_token
            if function is None and not opts.urn:
                raise TypeError("Missing required property 'function'")
            __props__.__dict__["function"] = function
            __props__.__dict__["function_url_auth_type"] = function_url_auth_type
            if principal is None and not opts.urn:
                raise TypeError("Missing required property 'principal'")
            __props__.__dict__["principal"] = principal
            __props__.__dict__["principal_org_id"] = principal_org_id
            __props__.__dict__["qualifier"] = qualifier
            __props__.__dict__["region"] = region
            __props__.__dict__["source_account"] = source_account
            __props__.__dict__["source_arn"] = source_arn
            __props__.__dict__["statement_id"] = statement_id
            __props__.__dict__["statement_id_prefix"] = statement_id_prefix
        super(Permission, __self__).__init__(
            'aws:lambda/permission:Permission',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[builtins.str]] = None,
            event_source_token: Optional[pulumi.Input[builtins.str]] = None,
            function: Optional[pulumi.Input[builtins.str]] = None,
            function_url_auth_type: Optional[pulumi.Input[builtins.str]] = None,
            principal: Optional[pulumi.Input[builtins.str]] = None,
            principal_org_id: Optional[pulumi.Input[builtins.str]] = None,
            qualifier: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            source_account: Optional[pulumi.Input[builtins.str]] = None,
            source_arn: Optional[pulumi.Input[builtins.str]] = None,
            statement_id: Optional[pulumi.Input[builtins.str]] = None,
            statement_id_prefix: Optional[pulumi.Input[builtins.str]] = None) -> 'Permission':
        """
        Get an existing Permission resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: Lambda action to allow in this statement (e.g., `lambda:InvokeFunction`)
        :param pulumi.Input[builtins.str] event_source_token: Event Source Token for Alexa Skills
        :param pulumi.Input[builtins.str] function: Name of the Lambda function
        :param pulumi.Input[builtins.str] function_url_auth_type: Lambda Function URL authentication type. Valid values: `AWS_IAM` or `NONE`. Only valid with `lambda:InvokeFunctionUrl` action
        :param pulumi.Input[builtins.str] principal: AWS service or account that invokes the function (e.g., `s3.amazonaws.com`, `sns.amazonaws.com`, AWS account ID, or AWS IAM principal)
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] principal_org_id: AWS Organizations ID to grant permission to all accounts under this organization
        :param pulumi.Input[builtins.str] qualifier: Lambda function version or alias name
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration
        :param pulumi.Input[builtins.str] source_account: AWS account ID of the source owner for cross-account access, S3, or SES
        :param pulumi.Input[builtins.str] source_arn: ARN of the source resource granting permission to invoke the Lambda function
        :param pulumi.Input[builtins.str] statement_id: Statement identifier. Generated by Pulumi if not provided
        :param pulumi.Input[builtins.str] statement_id_prefix: Statement identifier prefix. Conflicts with `statement_id`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PermissionState.__new__(_PermissionState)

        __props__.__dict__["action"] = action
        __props__.__dict__["event_source_token"] = event_source_token
        __props__.__dict__["function"] = function
        __props__.__dict__["function_url_auth_type"] = function_url_auth_type
        __props__.__dict__["principal"] = principal
        __props__.__dict__["principal_org_id"] = principal_org_id
        __props__.__dict__["qualifier"] = qualifier
        __props__.__dict__["region"] = region
        __props__.__dict__["source_account"] = source_account
        __props__.__dict__["source_arn"] = source_arn
        __props__.__dict__["statement_id"] = statement_id
        __props__.__dict__["statement_id_prefix"] = statement_id_prefix
        return Permission(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[builtins.str]:
        """
        Lambda action to allow in this statement (e.g., `lambda:InvokeFunction`)
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="eventSourceToken")
    def event_source_token(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Event Source Token for Alexa Skills
        """
        return pulumi.get(self, "event_source_token")

    @property
    @pulumi.getter
    def function(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Lambda function
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter(name="functionUrlAuthType")
    def function_url_auth_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Lambda Function URL authentication type. Valid values: `AWS_IAM` or `NONE`. Only valid with `lambda:InvokeFunctionUrl` action
        """
        return pulumi.get(self, "function_url_auth_type")

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Output[builtins.str]:
        """
        AWS service or account that invokes the function (e.g., `s3.amazonaws.com`, `sns.amazonaws.com`, AWS account ID, or AWS IAM principal)

        The following arguments are optional:
        """
        return pulumi.get(self, "principal")

    @property
    @pulumi.getter(name="principalOrgId")
    def principal_org_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        AWS Organizations ID to grant permission to all accounts under this organization
        """
        return pulumi.get(self, "principal_org_id")

    @property
    @pulumi.getter
    def qualifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Lambda function version or alias name
        """
        return pulumi.get(self, "qualifier")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sourceAccount")
    def source_account(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        AWS account ID of the source owner for cross-account access, S3, or SES
        """
        return pulumi.get(self, "source_account")

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ARN of the source resource granting permission to invoke the Lambda function
        """
        return pulumi.get(self, "source_arn")

    @property
    @pulumi.getter(name="statementId")
    def statement_id(self) -> pulumi.Output[builtins.str]:
        """
        Statement identifier. Generated by Pulumi if not provided
        """
        return pulumi.get(self, "statement_id")

    @property
    @pulumi.getter(name="statementIdPrefix")
    def statement_id_prefix(self) -> pulumi.Output[builtins.str]:
        """
        Statement identifier prefix. Conflicts with `statement_id`
        """
        return pulumi.get(self, "statement_id_prefix")

