# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLbsResult',
    'AwaitableGetLbsResult',
    'get_lbs',
    'get_lbs_output',
]

@pulumi.output_type
class GetLbsResult:
    """
    A collection of values returned by getLbs.
    """
    def __init__(__self__, arns=None, id=None, region=None, tags=None):
        if arns and not isinstance(arns, list):
            raise TypeError("Expected argument 'arns' to be a list")
        pulumi.set(__self__, "arns", arns)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arns(self) -> Sequence[builtins.str]:
        """
        Set of Load Balancer ARNs.
        """
        return pulumi.get(self, "arns")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags")


class AwaitableGetLbsResult(GetLbsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLbsResult(
            arns=self.arns,
            id=self.id,
            region=self.region,
            tags=self.tags)


def get_lbs(region: Optional[builtins.str] = None,
            tags: Optional[Mapping[str, builtins.str]] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLbsResult:
    """
    Use this data source to get a list of Load Balancer ARNs matching the specified criteria. Useful for passing to other
    resources.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.lb.get_lbs(tags={
        "elbv2.k8s.aws/cluster": "my-cluster",
    })
    ```


    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of tags, each pair of which must exactly match
           a pair on the desired Load Balancers.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:lb/getLbs:getLbs', __args__, opts=opts, typ=GetLbsResult).value

    return AwaitableGetLbsResult(
        arns=pulumi.get(__ret__, 'arns'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_lbs_output(region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                   tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLbsResult]:
    """
    Use this data source to get a list of Load Balancer ARNs matching the specified criteria. Useful for passing to other
    resources.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.lb.get_lbs(tags={
        "elbv2.k8s.aws/cluster": "my-cluster",
    })
    ```


    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of tags, each pair of which must exactly match
           a pair on the desired Load Balancers.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:lb/getLbs:getLbs', __args__, opts=opts, typ=GetLbsResult)
    return __ret__.apply(lambda __response__: GetLbsResult(
        arns=pulumi.get(__response__, 'arns'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
