# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ListenerArgs', 'Listener']

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 default_actions: pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]],
                 load_balancer_arn: pulumi.Input[builtins.str],
                 alpn_policy: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_arn: Optional[pulumi.Input[builtins.str]] = None,
                 mutual_authentication: Optional[pulumi.Input['ListenerMutualAuthenticationArgs']] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_issuer_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_leaf_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_subject_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_validity_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_tls_cipher_suite_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_tls_version_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_allow_credentials_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_allow_headers_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_allow_methods_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_allow_origin_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_expose_headers_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_max_age_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_content_security_policy_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_server_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 routing_http_response_strict_transport_security_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_x_content_type_options_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_x_frame_options_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_policy: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tcp_idle_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a Listener resource.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]] default_actions: Configuration block for default actions. See below.
        :param pulumi.Input[builtins.str] load_balancer_arn: ARN of the load balancer.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] alpn_policy: Name of the Application-Layer Protocol Negotiation (ALPN) policy. Can be set if `protocol` is `TLS`. Valid values are `HTTP1Only`, `HTTP2Only`, `HTTP2Optional`, `HTTP2Preferred`, and `None`.
        :param pulumi.Input[builtins.str] certificate_arn: ARN of the default SSL server certificate. Exactly one certificate is required if the protocol is HTTPS. For adding additional SSL certificates, see the `lb.ListenerCertificate` resource.
        :param pulumi.Input['ListenerMutualAuthenticationArgs'] mutual_authentication: The mutual authentication configuration information. See below.
        :param pulumi.Input[builtins.int] port: Port on which the load balancer is listening. Not valid for Gateway Load Balancers.
        :param pulumi.Input[builtins.str] protocol: Protocol for connections from clients to the load balancer. For Application Load Balancers, valid values are `HTTP` and `HTTPS`, with a default of `HTTP`. For Network Load Balancers, valid values are `TCP`, `TLS`, `UDP`, and `TCP_UDP`. Not valid to use `UDP` or `TCP_UDP` if dual-stack mode is enabled. Not valid for Gateway Load Balancers.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_issuer_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Issuer` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_leaf_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Leaf` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Serial-Number` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_subject_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Subject` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_validity_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Validity` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_tls_cipher_suite_header_name: Enables you to modify the header name of the `X-Amzn-Tls-Cipher-Suite` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_tls_version_header_name: Enables you to modify the header name of the `X-Amzn-Tls-Version` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_allow_credentials_header_value: Specifies which headers the browser can expose to the requesting client. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is `true`.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_allow_headers_header_value: Specifies which headers can be used during the request. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Accept`, `Accept-Language`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, `Pragma`. Dependent on your use-case other headers can be exposed and then set as a value consult the Access-Control-Allow-Headers documentation.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_allow_methods_header_value: Set which HTTP methods are allowed when accessing the server from a different origin. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `GET`, `HEAD`, `POST`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE` or `PATCH`.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_allow_origin_header_value: Specifies which origins are allowed to access the server. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. A valid value is a URI, eg: `https://example.com`.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_expose_headers_header_value: Specifies whether the browser should include credentials such as cookies or authentication when making requests. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, or `Pragma`. Dependent on your use-case other headers can be exposed, consult the Access-Control-Expose-Headers documentation.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_max_age_header_value: Specifies how long the results of a preflight request can be cached, in seconds. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are between `0` and `86400`. This value is browser specific, consult the Access-Control-Max-Age documentation.
        :param pulumi.Input[builtins.str] routing_http_response_content_security_policy_header_value: Specifies restrictions enforced by the browser to help minimize the risk of certain types of security threats. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Values for this are extensive, and can be impactful when set, consult Content-Security-Policy documentation.
        :param pulumi.Input[builtins.bool] routing_http_response_server_enabled: Enables you to allow or remove the HTTP response server header. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `true` or `false`.
        :param pulumi.Input[builtins.str] routing_http_response_strict_transport_security_header_value: Informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS. Default values are `max-age=31536000; includeSubDomains; preload` consult the Strict-Transport-Security documentation for further details.
        :param pulumi.Input[builtins.str] routing_http_response_x_content_type_options_header_value: Indicates whether the MIME types advertised in the Content-Type headers should be followed and not be changed. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is `nosniff`.
        :param pulumi.Input[builtins.str] routing_http_response_x_frame_options_header_value: Indicates whether the browser is allowed to render a page in a frame, iframe, embed or object. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid values are `DENY`, `SAMEORIGIN`, or `ALLOW-FROM https://example.com`.
        :param pulumi.Input[builtins.str] ssl_policy: Name of the SSL Policy for the listener. Required if `protocol` is `HTTPS` or `TLS`. Default is `ELBSecurityPolicy-2016-08`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               > **Note::** When a `Name` key is specified in the map, the AWS Console maps the value to the `Name Tag` column value inside the `Listener Rules` table within a specific load balancer listener page. Otherwise, the value resolves to `Default`.
        :param pulumi.Input[builtins.int] tcp_idle_timeout_seconds: TCP idle timeout value in seconds. Can only be set if protocol is `TCP` on Network Load Balancer, or with a Gateway Load Balancer. Not supported for Application Load Balancers. Valid values are between `60` and `6000` inclusive. Default: `350`.
        """
        pulumi.set(__self__, "default_actions", default_actions)
        pulumi.set(__self__, "load_balancer_arn", load_balancer_arn)
        if alpn_policy is not None:
            pulumi.set(__self__, "alpn_policy", alpn_policy)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if mutual_authentication is not None:
            pulumi.set(__self__, "mutual_authentication", mutual_authentication)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routing_http_request_x_amzn_mtls_clientcert_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_header_name", routing_http_request_x_amzn_mtls_clientcert_header_name)
        if routing_http_request_x_amzn_mtls_clientcert_issuer_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_issuer_header_name", routing_http_request_x_amzn_mtls_clientcert_issuer_header_name)
        if routing_http_request_x_amzn_mtls_clientcert_leaf_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_leaf_header_name", routing_http_request_x_amzn_mtls_clientcert_leaf_header_name)
        if routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name", routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name)
        if routing_http_request_x_amzn_mtls_clientcert_subject_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_subject_header_name", routing_http_request_x_amzn_mtls_clientcert_subject_header_name)
        if routing_http_request_x_amzn_mtls_clientcert_validity_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_validity_header_name", routing_http_request_x_amzn_mtls_clientcert_validity_header_name)
        if routing_http_request_x_amzn_tls_cipher_suite_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_tls_cipher_suite_header_name", routing_http_request_x_amzn_tls_cipher_suite_header_name)
        if routing_http_request_x_amzn_tls_version_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_tls_version_header_name", routing_http_request_x_amzn_tls_version_header_name)
        if routing_http_response_access_control_allow_credentials_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_allow_credentials_header_value", routing_http_response_access_control_allow_credentials_header_value)
        if routing_http_response_access_control_allow_headers_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_allow_headers_header_value", routing_http_response_access_control_allow_headers_header_value)
        if routing_http_response_access_control_allow_methods_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_allow_methods_header_value", routing_http_response_access_control_allow_methods_header_value)
        if routing_http_response_access_control_allow_origin_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_allow_origin_header_value", routing_http_response_access_control_allow_origin_header_value)
        if routing_http_response_access_control_expose_headers_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_expose_headers_header_value", routing_http_response_access_control_expose_headers_header_value)
        if routing_http_response_access_control_max_age_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_max_age_header_value", routing_http_response_access_control_max_age_header_value)
        if routing_http_response_content_security_policy_header_value is not None:
            pulumi.set(__self__, "routing_http_response_content_security_policy_header_value", routing_http_response_content_security_policy_header_value)
        if routing_http_response_server_enabled is not None:
            pulumi.set(__self__, "routing_http_response_server_enabled", routing_http_response_server_enabled)
        if routing_http_response_strict_transport_security_header_value is not None:
            pulumi.set(__self__, "routing_http_response_strict_transport_security_header_value", routing_http_response_strict_transport_security_header_value)
        if routing_http_response_x_content_type_options_header_value is not None:
            pulumi.set(__self__, "routing_http_response_x_content_type_options_header_value", routing_http_response_x_content_type_options_header_value)
        if routing_http_response_x_frame_options_header_value is not None:
            pulumi.set(__self__, "routing_http_response_x_frame_options_header_value", routing_http_response_x_frame_options_header_value)
        if ssl_policy is not None:
            pulumi.set(__self__, "ssl_policy", ssl_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tcp_idle_timeout_seconds is not None:
            pulumi.set(__self__, "tcp_idle_timeout_seconds", tcp_idle_timeout_seconds)

    @property
    @pulumi.getter(name="defaultActions")
    def default_actions(self) -> pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]]:
        """
        Configuration block for default actions. See below.
        """
        return pulumi.get(self, "default_actions")

    @default_actions.setter
    def default_actions(self, value: pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]]):
        pulumi.set(self, "default_actions", value)

    @property
    @pulumi.getter(name="loadBalancerArn")
    def load_balancer_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the load balancer.

        The following arguments are optional:
        """
        return pulumi.get(self, "load_balancer_arn")

    @load_balancer_arn.setter
    def load_balancer_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "load_balancer_arn", value)

    @property
    @pulumi.getter(name="alpnPolicy")
    def alpn_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Application-Layer Protocol Negotiation (ALPN) policy. Can be set if `protocol` is `TLS`. Valid values are `HTTP1Only`, `HTTP2Only`, `HTTP2Optional`, `HTTP2Preferred`, and `None`.
        """
        return pulumi.get(self, "alpn_policy")

    @alpn_policy.setter
    def alpn_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alpn_policy", value)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the default SSL server certificate. Exactly one certificate is required if the protocol is HTTPS. For adding additional SSL certificates, see the `lb.ListenerCertificate` resource.
        """
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_arn", value)

    @property
    @pulumi.getter(name="mutualAuthentication")
    def mutual_authentication(self) -> Optional[pulumi.Input['ListenerMutualAuthenticationArgs']]:
        """
        The mutual authentication configuration information. See below.
        """
        return pulumi.get(self, "mutual_authentication")

    @mutual_authentication.setter
    def mutual_authentication(self, value: Optional[pulumi.Input['ListenerMutualAuthenticationArgs']]):
        pulumi.set(self, "mutual_authentication", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Port on which the load balancer is listening. Not valid for Gateway Load Balancers.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Protocol for connections from clients to the load balancer. For Application Load Balancers, valid values are `HTTP` and `HTTPS`, with a default of `HTTP`. For Network Load Balancers, valid values are `TCP`, `TLS`, `UDP`, and `TCP_UDP`. Not valid to use `UDP` or `TCP_UDP` if dual-stack mode is enabled. Not valid for Gateway Load Balancers.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_header_name", value)

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertIssuerHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_issuer_header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Issuer` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_issuer_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_issuer_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_issuer_header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_issuer_header_name", value)

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertLeafHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_leaf_header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Leaf` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_leaf_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_leaf_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_leaf_header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_leaf_header_name", value)

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertSerialNumberHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Serial-Number` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name", value)

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertSubjectHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_subject_header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Subject` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_subject_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_subject_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_subject_header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_subject_header_name", value)

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertValidityHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_validity_header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Validity` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_validity_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_validity_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_validity_header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_validity_header_name", value)

    @property
    @pulumi.getter(name="routingHttpRequestXAmznTlsCipherSuiteHeaderName")
    def routing_http_request_x_amzn_tls_cipher_suite_header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Tls-Cipher-Suite` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_tls_cipher_suite_header_name")

    @routing_http_request_x_amzn_tls_cipher_suite_header_name.setter
    def routing_http_request_x_amzn_tls_cipher_suite_header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_tls_cipher_suite_header_name", value)

    @property
    @pulumi.getter(name="routingHttpRequestXAmznTlsVersionHeaderName")
    def routing_http_request_x_amzn_tls_version_header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Tls-Version` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_tls_version_header_name")

    @routing_http_request_x_amzn_tls_version_header_name.setter
    def routing_http_request_x_amzn_tls_version_header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_tls_version_header_name", value)

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlAllowCredentialsHeaderValue")
    def routing_http_response_access_control_allow_credentials_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies which headers the browser can expose to the requesting client. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is `true`.
        """
        return pulumi.get(self, "routing_http_response_access_control_allow_credentials_header_value")

    @routing_http_response_access_control_allow_credentials_header_value.setter
    def routing_http_response_access_control_allow_credentials_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_allow_credentials_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlAllowHeadersHeaderValue")
    def routing_http_response_access_control_allow_headers_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies which headers can be used during the request. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Accept`, `Accept-Language`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, `Pragma`. Dependent on your use-case other headers can be exposed and then set as a value consult the Access-Control-Allow-Headers documentation.
        """
        return pulumi.get(self, "routing_http_response_access_control_allow_headers_header_value")

    @routing_http_response_access_control_allow_headers_header_value.setter
    def routing_http_response_access_control_allow_headers_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_allow_headers_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlAllowMethodsHeaderValue")
    def routing_http_response_access_control_allow_methods_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set which HTTP methods are allowed when accessing the server from a different origin. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `GET`, `HEAD`, `POST`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE` or `PATCH`.
        """
        return pulumi.get(self, "routing_http_response_access_control_allow_methods_header_value")

    @routing_http_response_access_control_allow_methods_header_value.setter
    def routing_http_response_access_control_allow_methods_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_allow_methods_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlAllowOriginHeaderValue")
    def routing_http_response_access_control_allow_origin_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies which origins are allowed to access the server. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. A valid value is a URI, eg: `https://example.com`.
        """
        return pulumi.get(self, "routing_http_response_access_control_allow_origin_header_value")

    @routing_http_response_access_control_allow_origin_header_value.setter
    def routing_http_response_access_control_allow_origin_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_allow_origin_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlExposeHeadersHeaderValue")
    def routing_http_response_access_control_expose_headers_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the browser should include credentials such as cookies or authentication when making requests. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, or `Pragma`. Dependent on your use-case other headers can be exposed, consult the Access-Control-Expose-Headers documentation.
        """
        return pulumi.get(self, "routing_http_response_access_control_expose_headers_header_value")

    @routing_http_response_access_control_expose_headers_header_value.setter
    def routing_http_response_access_control_expose_headers_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_expose_headers_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlMaxAgeHeaderValue")
    def routing_http_response_access_control_max_age_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies how long the results of a preflight request can be cached, in seconds. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are between `0` and `86400`. This value is browser specific, consult the Access-Control-Max-Age documentation.
        """
        return pulumi.get(self, "routing_http_response_access_control_max_age_header_value")

    @routing_http_response_access_control_max_age_header_value.setter
    def routing_http_response_access_control_max_age_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_max_age_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseContentSecurityPolicyHeaderValue")
    def routing_http_response_content_security_policy_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies restrictions enforced by the browser to help minimize the risk of certain types of security threats. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Values for this are extensive, and can be impactful when set, consult Content-Security-Policy documentation.
        """
        return pulumi.get(self, "routing_http_response_content_security_policy_header_value")

    @routing_http_response_content_security_policy_header_value.setter
    def routing_http_response_content_security_policy_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_content_security_policy_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseServerEnabled")
    def routing_http_response_server_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables you to allow or remove the HTTP response server header. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `true` or `false`.
        """
        return pulumi.get(self, "routing_http_response_server_enabled")

    @routing_http_response_server_enabled.setter
    def routing_http_response_server_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "routing_http_response_server_enabled", value)

    @property
    @pulumi.getter(name="routingHttpResponseStrictTransportSecurityHeaderValue")
    def routing_http_response_strict_transport_security_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS. Default values are `max-age=31536000; includeSubDomains; preload` consult the Strict-Transport-Security documentation for further details.
        """
        return pulumi.get(self, "routing_http_response_strict_transport_security_header_value")

    @routing_http_response_strict_transport_security_header_value.setter
    def routing_http_response_strict_transport_security_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_strict_transport_security_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseXContentTypeOptionsHeaderValue")
    def routing_http_response_x_content_type_options_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether the MIME types advertised in the Content-Type headers should be followed and not be changed. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is `nosniff`.
        """
        return pulumi.get(self, "routing_http_response_x_content_type_options_header_value")

    @routing_http_response_x_content_type_options_header_value.setter
    def routing_http_response_x_content_type_options_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_x_content_type_options_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseXFrameOptionsHeaderValue")
    def routing_http_response_x_frame_options_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether the browser is allowed to render a page in a frame, iframe, embed or object. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid values are `DENY`, `SAMEORIGIN`, or `ALLOW-FROM https://example.com`.
        """
        return pulumi.get(self, "routing_http_response_x_frame_options_header_value")

    @routing_http_response_x_frame_options_header_value.setter
    def routing_http_response_x_frame_options_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_x_frame_options_header_value", value)

    @property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the SSL Policy for the listener. Required if `protocol` is `HTTPS` or `TLS`. Default is `ELBSecurityPolicy-2016-08`.
        """
        return pulumi.get(self, "ssl_policy")

    @ssl_policy.setter
    def ssl_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_policy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        > **Note::** When a `Name` key is specified in the map, the AWS Console maps the value to the `Name Tag` column value inside the `Listener Rules` table within a specific load balancer listener page. Otherwise, the value resolves to `Default`.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tcpIdleTimeoutSeconds")
    def tcp_idle_timeout_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        TCP idle timeout value in seconds. Can only be set if protocol is `TCP` on Network Load Balancer, or with a Gateway Load Balancer. Not supported for Application Load Balancers. Valid values are between `60` and `6000` inclusive. Default: `350`.
        """
        return pulumi.get(self, "tcp_idle_timeout_seconds")

    @tcp_idle_timeout_seconds.setter
    def tcp_idle_timeout_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tcp_idle_timeout_seconds", value)


@pulumi.input_type
class _ListenerState:
    def __init__(__self__, *,
                 alpn_policy: Optional[pulumi.Input[builtins.str]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_arn: Optional[pulumi.Input[builtins.str]] = None,
                 default_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]]] = None,
                 load_balancer_arn: Optional[pulumi.Input[builtins.str]] = None,
                 mutual_authentication: Optional[pulumi.Input['ListenerMutualAuthenticationArgs']] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_issuer_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_leaf_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_subject_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_validity_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_tls_cipher_suite_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_tls_version_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_allow_credentials_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_allow_headers_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_allow_methods_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_allow_origin_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_expose_headers_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_max_age_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_content_security_policy_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_server_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 routing_http_response_strict_transport_security_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_x_content_type_options_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_x_frame_options_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_policy: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tcp_idle_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering Listener resources.
        :param pulumi.Input[builtins.str] alpn_policy: Name of the Application-Layer Protocol Negotiation (ALPN) policy. Can be set if `protocol` is `TLS`. Valid values are `HTTP1Only`, `HTTP2Only`, `HTTP2Optional`, `HTTP2Preferred`, and `None`.
        :param pulumi.Input[builtins.str] arn: ARN of the listener.
        :param pulumi.Input[builtins.str] certificate_arn: ARN of the default SSL server certificate. Exactly one certificate is required if the protocol is HTTPS. For adding additional SSL certificates, see the `lb.ListenerCertificate` resource.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]] default_actions: Configuration block for default actions. See below.
        :param pulumi.Input[builtins.str] load_balancer_arn: ARN of the load balancer.
               
               The following arguments are optional:
        :param pulumi.Input['ListenerMutualAuthenticationArgs'] mutual_authentication: The mutual authentication configuration information. See below.
        :param pulumi.Input[builtins.int] port: Port on which the load balancer is listening. Not valid for Gateway Load Balancers.
        :param pulumi.Input[builtins.str] protocol: Protocol for connections from clients to the load balancer. For Application Load Balancers, valid values are `HTTP` and `HTTPS`, with a default of `HTTP`. For Network Load Balancers, valid values are `TCP`, `TLS`, `UDP`, and `TCP_UDP`. Not valid to use `UDP` or `TCP_UDP` if dual-stack mode is enabled. Not valid for Gateway Load Balancers.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_issuer_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Issuer` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_leaf_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Leaf` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Serial-Number` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_subject_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Subject` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_validity_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Validity` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_tls_cipher_suite_header_name: Enables you to modify the header name of the `X-Amzn-Tls-Cipher-Suite` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_tls_version_header_name: Enables you to modify the header name of the `X-Amzn-Tls-Version` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_allow_credentials_header_value: Specifies which headers the browser can expose to the requesting client. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is `true`.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_allow_headers_header_value: Specifies which headers can be used during the request. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Accept`, `Accept-Language`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, `Pragma`. Dependent on your use-case other headers can be exposed and then set as a value consult the Access-Control-Allow-Headers documentation.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_allow_methods_header_value: Set which HTTP methods are allowed when accessing the server from a different origin. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `GET`, `HEAD`, `POST`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE` or `PATCH`.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_allow_origin_header_value: Specifies which origins are allowed to access the server. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. A valid value is a URI, eg: `https://example.com`.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_expose_headers_header_value: Specifies whether the browser should include credentials such as cookies or authentication when making requests. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, or `Pragma`. Dependent on your use-case other headers can be exposed, consult the Access-Control-Expose-Headers documentation.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_max_age_header_value: Specifies how long the results of a preflight request can be cached, in seconds. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are between `0` and `86400`. This value is browser specific, consult the Access-Control-Max-Age documentation.
        :param pulumi.Input[builtins.str] routing_http_response_content_security_policy_header_value: Specifies restrictions enforced by the browser to help minimize the risk of certain types of security threats. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Values for this are extensive, and can be impactful when set, consult Content-Security-Policy documentation.
        :param pulumi.Input[builtins.bool] routing_http_response_server_enabled: Enables you to allow or remove the HTTP response server header. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `true` or `false`.
        :param pulumi.Input[builtins.str] routing_http_response_strict_transport_security_header_value: Informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS. Default values are `max-age=31536000; includeSubDomains; preload` consult the Strict-Transport-Security documentation for further details.
        :param pulumi.Input[builtins.str] routing_http_response_x_content_type_options_header_value: Indicates whether the MIME types advertised in the Content-Type headers should be followed and not be changed. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is `nosniff`.
        :param pulumi.Input[builtins.str] routing_http_response_x_frame_options_header_value: Indicates whether the browser is allowed to render a page in a frame, iframe, embed or object. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid values are `DENY`, `SAMEORIGIN`, or `ALLOW-FROM https://example.com`.
        :param pulumi.Input[builtins.str] ssl_policy: Name of the SSL Policy for the listener. Required if `protocol` is `HTTPS` or `TLS`. Default is `ELBSecurityPolicy-2016-08`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               > **Note::** When a `Name` key is specified in the map, the AWS Console maps the value to the `Name Tag` column value inside the `Listener Rules` table within a specific load balancer listener page. Otherwise, the value resolves to `Default`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.int] tcp_idle_timeout_seconds: TCP idle timeout value in seconds. Can only be set if protocol is `TCP` on Network Load Balancer, or with a Gateway Load Balancer. Not supported for Application Load Balancers. Valid values are between `60` and `6000` inclusive. Default: `350`.
        """
        if alpn_policy is not None:
            pulumi.set(__self__, "alpn_policy", alpn_policy)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if default_actions is not None:
            pulumi.set(__self__, "default_actions", default_actions)
        if load_balancer_arn is not None:
            pulumi.set(__self__, "load_balancer_arn", load_balancer_arn)
        if mutual_authentication is not None:
            pulumi.set(__self__, "mutual_authentication", mutual_authentication)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routing_http_request_x_amzn_mtls_clientcert_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_header_name", routing_http_request_x_amzn_mtls_clientcert_header_name)
        if routing_http_request_x_amzn_mtls_clientcert_issuer_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_issuer_header_name", routing_http_request_x_amzn_mtls_clientcert_issuer_header_name)
        if routing_http_request_x_amzn_mtls_clientcert_leaf_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_leaf_header_name", routing_http_request_x_amzn_mtls_clientcert_leaf_header_name)
        if routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name", routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name)
        if routing_http_request_x_amzn_mtls_clientcert_subject_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_subject_header_name", routing_http_request_x_amzn_mtls_clientcert_subject_header_name)
        if routing_http_request_x_amzn_mtls_clientcert_validity_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_validity_header_name", routing_http_request_x_amzn_mtls_clientcert_validity_header_name)
        if routing_http_request_x_amzn_tls_cipher_suite_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_tls_cipher_suite_header_name", routing_http_request_x_amzn_tls_cipher_suite_header_name)
        if routing_http_request_x_amzn_tls_version_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_tls_version_header_name", routing_http_request_x_amzn_tls_version_header_name)
        if routing_http_response_access_control_allow_credentials_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_allow_credentials_header_value", routing_http_response_access_control_allow_credentials_header_value)
        if routing_http_response_access_control_allow_headers_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_allow_headers_header_value", routing_http_response_access_control_allow_headers_header_value)
        if routing_http_response_access_control_allow_methods_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_allow_methods_header_value", routing_http_response_access_control_allow_methods_header_value)
        if routing_http_response_access_control_allow_origin_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_allow_origin_header_value", routing_http_response_access_control_allow_origin_header_value)
        if routing_http_response_access_control_expose_headers_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_expose_headers_header_value", routing_http_response_access_control_expose_headers_header_value)
        if routing_http_response_access_control_max_age_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_max_age_header_value", routing_http_response_access_control_max_age_header_value)
        if routing_http_response_content_security_policy_header_value is not None:
            pulumi.set(__self__, "routing_http_response_content_security_policy_header_value", routing_http_response_content_security_policy_header_value)
        if routing_http_response_server_enabled is not None:
            pulumi.set(__self__, "routing_http_response_server_enabled", routing_http_response_server_enabled)
        if routing_http_response_strict_transport_security_header_value is not None:
            pulumi.set(__self__, "routing_http_response_strict_transport_security_header_value", routing_http_response_strict_transport_security_header_value)
        if routing_http_response_x_content_type_options_header_value is not None:
            pulumi.set(__self__, "routing_http_response_x_content_type_options_header_value", routing_http_response_x_content_type_options_header_value)
        if routing_http_response_x_frame_options_header_value is not None:
            pulumi.set(__self__, "routing_http_response_x_frame_options_header_value", routing_http_response_x_frame_options_header_value)
        if ssl_policy is not None:
            pulumi.set(__self__, "ssl_policy", ssl_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if tcp_idle_timeout_seconds is not None:
            pulumi.set(__self__, "tcp_idle_timeout_seconds", tcp_idle_timeout_seconds)

    @property
    @pulumi.getter(name="alpnPolicy")
    def alpn_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Application-Layer Protocol Negotiation (ALPN) policy. Can be set if `protocol` is `TLS`. Valid values are `HTTP1Only`, `HTTP2Only`, `HTTP2Optional`, `HTTP2Preferred`, and `None`.
        """
        return pulumi.get(self, "alpn_policy")

    @alpn_policy.setter
    def alpn_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alpn_policy", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the listener.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the default SSL server certificate. Exactly one certificate is required if the protocol is HTTPS. For adding additional SSL certificates, see the `lb.ListenerCertificate` resource.
        """
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_arn", value)

    @property
    @pulumi.getter(name="defaultActions")
    def default_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]]]:
        """
        Configuration block for default actions. See below.
        """
        return pulumi.get(self, "default_actions")

    @default_actions.setter
    def default_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionArgs']]]]):
        pulumi.set(self, "default_actions", value)

    @property
    @pulumi.getter(name="loadBalancerArn")
    def load_balancer_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the load balancer.

        The following arguments are optional:
        """
        return pulumi.get(self, "load_balancer_arn")

    @load_balancer_arn.setter
    def load_balancer_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "load_balancer_arn", value)

    @property
    @pulumi.getter(name="mutualAuthentication")
    def mutual_authentication(self) -> Optional[pulumi.Input['ListenerMutualAuthenticationArgs']]:
        """
        The mutual authentication configuration information. See below.
        """
        return pulumi.get(self, "mutual_authentication")

    @mutual_authentication.setter
    def mutual_authentication(self, value: Optional[pulumi.Input['ListenerMutualAuthenticationArgs']]):
        pulumi.set(self, "mutual_authentication", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Port on which the load balancer is listening. Not valid for Gateway Load Balancers.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Protocol for connections from clients to the load balancer. For Application Load Balancers, valid values are `HTTP` and `HTTPS`, with a default of `HTTP`. For Network Load Balancers, valid values are `TCP`, `TLS`, `UDP`, and `TCP_UDP`. Not valid to use `UDP` or `TCP_UDP` if dual-stack mode is enabled. Not valid for Gateway Load Balancers.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_header_name", value)

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertIssuerHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_issuer_header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Issuer` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_issuer_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_issuer_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_issuer_header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_issuer_header_name", value)

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertLeafHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_leaf_header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Leaf` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_leaf_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_leaf_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_leaf_header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_leaf_header_name", value)

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertSerialNumberHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Serial-Number` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name", value)

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertSubjectHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_subject_header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Subject` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_subject_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_subject_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_subject_header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_subject_header_name", value)

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertValidityHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_validity_header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Validity` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_validity_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_validity_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_validity_header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_validity_header_name", value)

    @property
    @pulumi.getter(name="routingHttpRequestXAmznTlsCipherSuiteHeaderName")
    def routing_http_request_x_amzn_tls_cipher_suite_header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Tls-Cipher-Suite` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_tls_cipher_suite_header_name")

    @routing_http_request_x_amzn_tls_cipher_suite_header_name.setter
    def routing_http_request_x_amzn_tls_cipher_suite_header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_tls_cipher_suite_header_name", value)

    @property
    @pulumi.getter(name="routingHttpRequestXAmznTlsVersionHeaderName")
    def routing_http_request_x_amzn_tls_version_header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Tls-Version` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_tls_version_header_name")

    @routing_http_request_x_amzn_tls_version_header_name.setter
    def routing_http_request_x_amzn_tls_version_header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_tls_version_header_name", value)

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlAllowCredentialsHeaderValue")
    def routing_http_response_access_control_allow_credentials_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies which headers the browser can expose to the requesting client. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is `true`.
        """
        return pulumi.get(self, "routing_http_response_access_control_allow_credentials_header_value")

    @routing_http_response_access_control_allow_credentials_header_value.setter
    def routing_http_response_access_control_allow_credentials_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_allow_credentials_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlAllowHeadersHeaderValue")
    def routing_http_response_access_control_allow_headers_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies which headers can be used during the request. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Accept`, `Accept-Language`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, `Pragma`. Dependent on your use-case other headers can be exposed and then set as a value consult the Access-Control-Allow-Headers documentation.
        """
        return pulumi.get(self, "routing_http_response_access_control_allow_headers_header_value")

    @routing_http_response_access_control_allow_headers_header_value.setter
    def routing_http_response_access_control_allow_headers_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_allow_headers_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlAllowMethodsHeaderValue")
    def routing_http_response_access_control_allow_methods_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set which HTTP methods are allowed when accessing the server from a different origin. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `GET`, `HEAD`, `POST`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE` or `PATCH`.
        """
        return pulumi.get(self, "routing_http_response_access_control_allow_methods_header_value")

    @routing_http_response_access_control_allow_methods_header_value.setter
    def routing_http_response_access_control_allow_methods_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_allow_methods_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlAllowOriginHeaderValue")
    def routing_http_response_access_control_allow_origin_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies which origins are allowed to access the server. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. A valid value is a URI, eg: `https://example.com`.
        """
        return pulumi.get(self, "routing_http_response_access_control_allow_origin_header_value")

    @routing_http_response_access_control_allow_origin_header_value.setter
    def routing_http_response_access_control_allow_origin_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_allow_origin_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlExposeHeadersHeaderValue")
    def routing_http_response_access_control_expose_headers_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies whether the browser should include credentials such as cookies or authentication when making requests. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, or `Pragma`. Dependent on your use-case other headers can be exposed, consult the Access-Control-Expose-Headers documentation.
        """
        return pulumi.get(self, "routing_http_response_access_control_expose_headers_header_value")

    @routing_http_response_access_control_expose_headers_header_value.setter
    def routing_http_response_access_control_expose_headers_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_expose_headers_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlMaxAgeHeaderValue")
    def routing_http_response_access_control_max_age_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies how long the results of a preflight request can be cached, in seconds. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are between `0` and `86400`. This value is browser specific, consult the Access-Control-Max-Age documentation.
        """
        return pulumi.get(self, "routing_http_response_access_control_max_age_header_value")

    @routing_http_response_access_control_max_age_header_value.setter
    def routing_http_response_access_control_max_age_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_max_age_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseContentSecurityPolicyHeaderValue")
    def routing_http_response_content_security_policy_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies restrictions enforced by the browser to help minimize the risk of certain types of security threats. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Values for this are extensive, and can be impactful when set, consult Content-Security-Policy documentation.
        """
        return pulumi.get(self, "routing_http_response_content_security_policy_header_value")

    @routing_http_response_content_security_policy_header_value.setter
    def routing_http_response_content_security_policy_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_content_security_policy_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseServerEnabled")
    def routing_http_response_server_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables you to allow or remove the HTTP response server header. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `true` or `false`.
        """
        return pulumi.get(self, "routing_http_response_server_enabled")

    @routing_http_response_server_enabled.setter
    def routing_http_response_server_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "routing_http_response_server_enabled", value)

    @property
    @pulumi.getter(name="routingHttpResponseStrictTransportSecurityHeaderValue")
    def routing_http_response_strict_transport_security_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS. Default values are `max-age=31536000; includeSubDomains; preload` consult the Strict-Transport-Security documentation for further details.
        """
        return pulumi.get(self, "routing_http_response_strict_transport_security_header_value")

    @routing_http_response_strict_transport_security_header_value.setter
    def routing_http_response_strict_transport_security_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_strict_transport_security_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseXContentTypeOptionsHeaderValue")
    def routing_http_response_x_content_type_options_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether the MIME types advertised in the Content-Type headers should be followed and not be changed. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is `nosniff`.
        """
        return pulumi.get(self, "routing_http_response_x_content_type_options_header_value")

    @routing_http_response_x_content_type_options_header_value.setter
    def routing_http_response_x_content_type_options_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_x_content_type_options_header_value", value)

    @property
    @pulumi.getter(name="routingHttpResponseXFrameOptionsHeaderValue")
    def routing_http_response_x_frame_options_header_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether the browser is allowed to render a page in a frame, iframe, embed or object. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid values are `DENY`, `SAMEORIGIN`, or `ALLOW-FROM https://example.com`.
        """
        return pulumi.get(self, "routing_http_response_x_frame_options_header_value")

    @routing_http_response_x_frame_options_header_value.setter
    def routing_http_response_x_frame_options_header_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_http_response_x_frame_options_header_value", value)

    @property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the SSL Policy for the listener. Required if `protocol` is `HTTPS` or `TLS`. Default is `ELBSecurityPolicy-2016-08`.
        """
        return pulumi.get(self, "ssl_policy")

    @ssl_policy.setter
    def ssl_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_policy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        > **Note::** When a `Name` key is specified in the map, the AWS Console maps the value to the `Name Tag` column value inside the `Listener Rules` table within a specific load balancer listener page. Otherwise, the value resolves to `Default`.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="tcpIdleTimeoutSeconds")
    def tcp_idle_timeout_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        TCP idle timeout value in seconds. Can only be set if protocol is `TCP` on Network Load Balancer, or with a Gateway Load Balancer. Not supported for Application Load Balancers. Valid values are between `60` and `6000` inclusive. Default: `350`.
        """
        return pulumi.get(self, "tcp_idle_timeout_seconds")

    @tcp_idle_timeout_seconds.setter
    def tcp_idle_timeout_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tcp_idle_timeout_seconds", value)


@pulumi.type_token("aws:lb/listener:Listener")
class Listener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alpn_policy: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_arn: Optional[pulumi.Input[builtins.str]] = None,
                 default_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerDefaultActionArgs', 'ListenerDefaultActionArgsDict']]]]] = None,
                 load_balancer_arn: Optional[pulumi.Input[builtins.str]] = None,
                 mutual_authentication: Optional[pulumi.Input[Union['ListenerMutualAuthenticationArgs', 'ListenerMutualAuthenticationArgsDict']]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_issuer_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_leaf_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_subject_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_validity_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_tls_cipher_suite_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_tls_version_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_allow_credentials_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_allow_headers_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_allow_methods_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_allow_origin_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_expose_headers_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_max_age_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_content_security_policy_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_server_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 routing_http_response_strict_transport_security_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_x_content_type_options_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_x_frame_options_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_policy: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tcp_idle_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Provides a Load Balancer Listener resource.

        > **Note:** `alb.Listener` is known as `lb.Listener`. The functionality is identical.

        ## Example Usage

        ### Forward Action

        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_target_group = aws.lb.TargetGroup("front_end")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=443,
            protocol="HTTPS",
            ssl_policy="ELBSecurityPolicy-2016-08",
            certificate_arn="arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            default_actions=[{
                "type": "forward",
                "target_group_arn": front_end_target_group.arn,
            }])
        ```

        To a NLB:

        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.Listener("front_end",
            load_balancer_arn=front_end_aws_lb["arn"],
            port=443,
            protocol="TLS",
            ssl_policy="ELBSecurityPolicy-2016-08",
            certificate_arn="arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            alpn_policy="HTTP2Preferred",
            default_actions=[{
                "type": "forward",
                "target_group_arn": front_end_aws_lb_target_group["arn"],
            }])
        ```

        ### Redirect Action

        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=80,
            protocol="HTTP",
            default_actions=[{
                "type": "redirect",
                "redirect": {
                    "port": "443",
                    "protocol": "HTTPS",
                    "status_code": "HTTP_301",
                },
            }])
        ```

        ### Fixed-response Action

        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=80,
            protocol="HTTP",
            default_actions=[{
                "type": "fixed-response",
                "fixed_response": {
                    "content_type": "text/plain",
                    "message_body": "Fixed response content",
                    "status_code": "200",
                },
            }])
        ```

        ### Authenticate-cognito Action

        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_target_group = aws.lb.TargetGroup("front_end")
        pool = aws.cognito.UserPool("pool")
        client = aws.cognito.UserPoolClient("client")
        domain = aws.cognito.UserPoolDomain("domain")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=80,
            protocol="HTTP",
            default_actions=[
                {
                    "type": "authenticate-cognito",
                    "authenticate_cognito": {
                        "user_pool_arn": pool.arn,
                        "user_pool_client_id": client.id,
                        "user_pool_domain": domain.domain,
                    },
                },
                {
                    "type": "forward",
                    "target_group_arn": front_end_target_group.arn,
                },
            ])
        ```

        ### Authenticate-OIDC Action

        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_target_group = aws.lb.TargetGroup("front_end")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=80,
            protocol="HTTP",
            default_actions=[
                {
                    "type": "authenticate-oidc",
                    "authenticate_oidc": {
                        "authorization_endpoint": "https://example.com/authorization_endpoint",
                        "client_id": "client_id",
                        "client_secret": "client_secret",
                        "issuer": "https://example.com",
                        "token_endpoint": "https://example.com/token_endpoint",
                        "user_info_endpoint": "https://example.com/user_info_endpoint",
                    },
                },
                {
                    "type": "forward",
                    "target_group_arn": front_end_target_group.arn,
                },
            ])
        ```

        ### Gateway Load Balancer Listener

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lb.LoadBalancer("example",
            load_balancer_type="gateway",
            name="example",
            subnet_mappings=[{
                "subnet_id": example_aws_subnet["id"],
            }])
        example_target_group = aws.lb.TargetGroup("example",
            name="example",
            port=6081,
            protocol="GENEVE",
            vpc_id=example_aws_vpc["id"],
            health_check={
                "port": "80",
                "protocol": "HTTP",
            })
        example_listener = aws.lb.Listener("example",
            load_balancer_arn=example.id,
            default_actions=[{
                "target_group_arn": example_target_group.id,
                "type": "forward",
            }])
        ```

        ### Mutual TLS Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lb.LoadBalancer("example", load_balancer_type="application")
        example_target_group = aws.lb.TargetGroup("example")
        example_listener = aws.lb.Listener("example",
            load_balancer_arn=example.id,
            default_actions=[{
                "target_group_arn": example_target_group.id,
                "type": "forward",
            }],
            mutual_authentication={
                "mode": "verify",
                "trust_store_arn": "...",
            })
        ```

        ## Import

        Using `pulumi import`, import listeners using their ARN. For example:

        ```sh
        $ pulumi import aws:lb/listener:Listener front_end arn:aws:elasticloadbalancing:us-west-2:187416307283:listener/app/front-end-alb/8e4497da625e2d8a/9ab28ade35828f96
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alpn_policy: Name of the Application-Layer Protocol Negotiation (ALPN) policy. Can be set if `protocol` is `TLS`. Valid values are `HTTP1Only`, `HTTP2Only`, `HTTP2Optional`, `HTTP2Preferred`, and `None`.
        :param pulumi.Input[builtins.str] certificate_arn: ARN of the default SSL server certificate. Exactly one certificate is required if the protocol is HTTPS. For adding additional SSL certificates, see the `lb.ListenerCertificate` resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListenerDefaultActionArgs', 'ListenerDefaultActionArgsDict']]]] default_actions: Configuration block for default actions. See below.
        :param pulumi.Input[builtins.str] load_balancer_arn: ARN of the load balancer.
               
               The following arguments are optional:
        :param pulumi.Input[Union['ListenerMutualAuthenticationArgs', 'ListenerMutualAuthenticationArgsDict']] mutual_authentication: The mutual authentication configuration information. See below.
        :param pulumi.Input[builtins.int] port: Port on which the load balancer is listening. Not valid for Gateway Load Balancers.
        :param pulumi.Input[builtins.str] protocol: Protocol for connections from clients to the load balancer. For Application Load Balancers, valid values are `HTTP` and `HTTPS`, with a default of `HTTP`. For Network Load Balancers, valid values are `TCP`, `TLS`, `UDP`, and `TCP_UDP`. Not valid to use `UDP` or `TCP_UDP` if dual-stack mode is enabled. Not valid for Gateway Load Balancers.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_issuer_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Issuer` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_leaf_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Leaf` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Serial-Number` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_subject_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Subject` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_validity_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Validity` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_tls_cipher_suite_header_name: Enables you to modify the header name of the `X-Amzn-Tls-Cipher-Suite` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_tls_version_header_name: Enables you to modify the header name of the `X-Amzn-Tls-Version` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_allow_credentials_header_value: Specifies which headers the browser can expose to the requesting client. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is `true`.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_allow_headers_header_value: Specifies which headers can be used during the request. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Accept`, `Accept-Language`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, `Pragma`. Dependent on your use-case other headers can be exposed and then set as a value consult the Access-Control-Allow-Headers documentation.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_allow_methods_header_value: Set which HTTP methods are allowed when accessing the server from a different origin. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `GET`, `HEAD`, `POST`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE` or `PATCH`.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_allow_origin_header_value: Specifies which origins are allowed to access the server. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. A valid value is a URI, eg: `https://example.com`.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_expose_headers_header_value: Specifies whether the browser should include credentials such as cookies or authentication when making requests. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, or `Pragma`. Dependent on your use-case other headers can be exposed, consult the Access-Control-Expose-Headers documentation.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_max_age_header_value: Specifies how long the results of a preflight request can be cached, in seconds. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are between `0` and `86400`. This value is browser specific, consult the Access-Control-Max-Age documentation.
        :param pulumi.Input[builtins.str] routing_http_response_content_security_policy_header_value: Specifies restrictions enforced by the browser to help minimize the risk of certain types of security threats. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Values for this are extensive, and can be impactful when set, consult Content-Security-Policy documentation.
        :param pulumi.Input[builtins.bool] routing_http_response_server_enabled: Enables you to allow or remove the HTTP response server header. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `true` or `false`.
        :param pulumi.Input[builtins.str] routing_http_response_strict_transport_security_header_value: Informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS. Default values are `max-age=31536000; includeSubDomains; preload` consult the Strict-Transport-Security documentation for further details.
        :param pulumi.Input[builtins.str] routing_http_response_x_content_type_options_header_value: Indicates whether the MIME types advertised in the Content-Type headers should be followed and not be changed. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is `nosniff`.
        :param pulumi.Input[builtins.str] routing_http_response_x_frame_options_header_value: Indicates whether the browser is allowed to render a page in a frame, iframe, embed or object. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid values are `DENY`, `SAMEORIGIN`, or `ALLOW-FROM https://example.com`.
        :param pulumi.Input[builtins.str] ssl_policy: Name of the SSL Policy for the listener. Required if `protocol` is `HTTPS` or `TLS`. Default is `ELBSecurityPolicy-2016-08`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               > **Note::** When a `Name` key is specified in the map, the AWS Console maps the value to the `Name Tag` column value inside the `Listener Rules` table within a specific load balancer listener page. Otherwise, the value resolves to `Default`.
        :param pulumi.Input[builtins.int] tcp_idle_timeout_seconds: TCP idle timeout value in seconds. Can only be set if protocol is `TCP` on Network Load Balancer, or with a Gateway Load Balancer. Not supported for Application Load Balancers. Valid values are between `60` and `6000` inclusive. Default: `350`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Load Balancer Listener resource.

        > **Note:** `alb.Listener` is known as `lb.Listener`. The functionality is identical.

        ## Example Usage

        ### Forward Action

        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_target_group = aws.lb.TargetGroup("front_end")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=443,
            protocol="HTTPS",
            ssl_policy="ELBSecurityPolicy-2016-08",
            certificate_arn="arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            default_actions=[{
                "type": "forward",
                "target_group_arn": front_end_target_group.arn,
            }])
        ```

        To a NLB:

        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.Listener("front_end",
            load_balancer_arn=front_end_aws_lb["arn"],
            port=443,
            protocol="TLS",
            ssl_policy="ELBSecurityPolicy-2016-08",
            certificate_arn="arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            alpn_policy="HTTP2Preferred",
            default_actions=[{
                "type": "forward",
                "target_group_arn": front_end_aws_lb_target_group["arn"],
            }])
        ```

        ### Redirect Action

        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=80,
            protocol="HTTP",
            default_actions=[{
                "type": "redirect",
                "redirect": {
                    "port": "443",
                    "protocol": "HTTPS",
                    "status_code": "HTTP_301",
                },
            }])
        ```

        ### Fixed-response Action

        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=80,
            protocol="HTTP",
            default_actions=[{
                "type": "fixed-response",
                "fixed_response": {
                    "content_type": "text/plain",
                    "message_body": "Fixed response content",
                    "status_code": "200",
                },
            }])
        ```

        ### Authenticate-cognito Action

        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_target_group = aws.lb.TargetGroup("front_end")
        pool = aws.cognito.UserPool("pool")
        client = aws.cognito.UserPoolClient("client")
        domain = aws.cognito.UserPoolDomain("domain")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=80,
            protocol="HTTP",
            default_actions=[
                {
                    "type": "authenticate-cognito",
                    "authenticate_cognito": {
                        "user_pool_arn": pool.arn,
                        "user_pool_client_id": client.id,
                        "user_pool_domain": domain.domain,
                    },
                },
                {
                    "type": "forward",
                    "target_group_arn": front_end_target_group.arn,
                },
            ])
        ```

        ### Authenticate-OIDC Action

        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_target_group = aws.lb.TargetGroup("front_end")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=80,
            protocol="HTTP",
            default_actions=[
                {
                    "type": "authenticate-oidc",
                    "authenticate_oidc": {
                        "authorization_endpoint": "https://example.com/authorization_endpoint",
                        "client_id": "client_id",
                        "client_secret": "client_secret",
                        "issuer": "https://example.com",
                        "token_endpoint": "https://example.com/token_endpoint",
                        "user_info_endpoint": "https://example.com/user_info_endpoint",
                    },
                },
                {
                    "type": "forward",
                    "target_group_arn": front_end_target_group.arn,
                },
            ])
        ```

        ### Gateway Load Balancer Listener

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lb.LoadBalancer("example",
            load_balancer_type="gateway",
            name="example",
            subnet_mappings=[{
                "subnet_id": example_aws_subnet["id"],
            }])
        example_target_group = aws.lb.TargetGroup("example",
            name="example",
            port=6081,
            protocol="GENEVE",
            vpc_id=example_aws_vpc["id"],
            health_check={
                "port": "80",
                "protocol": "HTTP",
            })
        example_listener = aws.lb.Listener("example",
            load_balancer_arn=example.id,
            default_actions=[{
                "target_group_arn": example_target_group.id,
                "type": "forward",
            }])
        ```

        ### Mutual TLS Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lb.LoadBalancer("example", load_balancer_type="application")
        example_target_group = aws.lb.TargetGroup("example")
        example_listener = aws.lb.Listener("example",
            load_balancer_arn=example.id,
            default_actions=[{
                "target_group_arn": example_target_group.id,
                "type": "forward",
            }],
            mutual_authentication={
                "mode": "verify",
                "trust_store_arn": "...",
            })
        ```

        ## Import

        Using `pulumi import`, import listeners using their ARN. For example:

        ```sh
        $ pulumi import aws:lb/listener:Listener front_end arn:aws:elasticloadbalancing:us-west-2:187416307283:listener/app/front-end-alb/8e4497da625e2d8a/9ab28ade35828f96
        ```

        :param str resource_name: The name of the resource.
        :param ListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alpn_policy: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_arn: Optional[pulumi.Input[builtins.str]] = None,
                 default_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerDefaultActionArgs', 'ListenerDefaultActionArgsDict']]]]] = None,
                 load_balancer_arn: Optional[pulumi.Input[builtins.str]] = None,
                 mutual_authentication: Optional[pulumi.Input[Union['ListenerMutualAuthenticationArgs', 'ListenerMutualAuthenticationArgsDict']]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_issuer_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_leaf_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_subject_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_validity_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_tls_cipher_suite_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_request_x_amzn_tls_version_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_allow_credentials_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_allow_headers_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_allow_methods_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_allow_origin_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_expose_headers_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_access_control_max_age_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_content_security_policy_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_server_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 routing_http_response_strict_transport_security_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_x_content_type_options_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 routing_http_response_x_frame_options_header_value: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_policy: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tcp_idle_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerArgs.__new__(ListenerArgs)

            __props__.__dict__["alpn_policy"] = alpn_policy
            __props__.__dict__["certificate_arn"] = certificate_arn
            if default_actions is None and not opts.urn:
                raise TypeError("Missing required property 'default_actions'")
            __props__.__dict__["default_actions"] = default_actions
            if load_balancer_arn is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_arn'")
            __props__.__dict__["load_balancer_arn"] = load_balancer_arn
            __props__.__dict__["mutual_authentication"] = mutual_authentication
            __props__.__dict__["port"] = port
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            __props__.__dict__["routing_http_request_x_amzn_mtls_clientcert_header_name"] = routing_http_request_x_amzn_mtls_clientcert_header_name
            __props__.__dict__["routing_http_request_x_amzn_mtls_clientcert_issuer_header_name"] = routing_http_request_x_amzn_mtls_clientcert_issuer_header_name
            __props__.__dict__["routing_http_request_x_amzn_mtls_clientcert_leaf_header_name"] = routing_http_request_x_amzn_mtls_clientcert_leaf_header_name
            __props__.__dict__["routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name"] = routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name
            __props__.__dict__["routing_http_request_x_amzn_mtls_clientcert_subject_header_name"] = routing_http_request_x_amzn_mtls_clientcert_subject_header_name
            __props__.__dict__["routing_http_request_x_amzn_mtls_clientcert_validity_header_name"] = routing_http_request_x_amzn_mtls_clientcert_validity_header_name
            __props__.__dict__["routing_http_request_x_amzn_tls_cipher_suite_header_name"] = routing_http_request_x_amzn_tls_cipher_suite_header_name
            __props__.__dict__["routing_http_request_x_amzn_tls_version_header_name"] = routing_http_request_x_amzn_tls_version_header_name
            __props__.__dict__["routing_http_response_access_control_allow_credentials_header_value"] = routing_http_response_access_control_allow_credentials_header_value
            __props__.__dict__["routing_http_response_access_control_allow_headers_header_value"] = routing_http_response_access_control_allow_headers_header_value
            __props__.__dict__["routing_http_response_access_control_allow_methods_header_value"] = routing_http_response_access_control_allow_methods_header_value
            __props__.__dict__["routing_http_response_access_control_allow_origin_header_value"] = routing_http_response_access_control_allow_origin_header_value
            __props__.__dict__["routing_http_response_access_control_expose_headers_header_value"] = routing_http_response_access_control_expose_headers_header_value
            __props__.__dict__["routing_http_response_access_control_max_age_header_value"] = routing_http_response_access_control_max_age_header_value
            __props__.__dict__["routing_http_response_content_security_policy_header_value"] = routing_http_response_content_security_policy_header_value
            __props__.__dict__["routing_http_response_server_enabled"] = routing_http_response_server_enabled
            __props__.__dict__["routing_http_response_strict_transport_security_header_value"] = routing_http_response_strict_transport_security_header_value
            __props__.__dict__["routing_http_response_x_content_type_options_header_value"] = routing_http_response_x_content_type_options_header_value
            __props__.__dict__["routing_http_response_x_frame_options_header_value"] = routing_http_response_x_frame_options_header_value
            __props__.__dict__["ssl_policy"] = ssl_policy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tcp_idle_timeout_seconds"] = tcp_idle_timeout_seconds
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="aws:elasticloadbalancingv2/listener:Listener")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Listener, __self__).__init__(
            'aws:lb/listener:Listener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alpn_policy: Optional[pulumi.Input[builtins.str]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            certificate_arn: Optional[pulumi.Input[builtins.str]] = None,
            default_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerDefaultActionArgs', 'ListenerDefaultActionArgsDict']]]]] = None,
            load_balancer_arn: Optional[pulumi.Input[builtins.str]] = None,
            mutual_authentication: Optional[pulumi.Input[Union['ListenerMutualAuthenticationArgs', 'ListenerMutualAuthenticationArgsDict']]] = None,
            port: Optional[pulumi.Input[builtins.int]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_request_x_amzn_mtls_clientcert_header_name: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_request_x_amzn_mtls_clientcert_issuer_header_name: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_request_x_amzn_mtls_clientcert_leaf_header_name: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_request_x_amzn_mtls_clientcert_subject_header_name: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_request_x_amzn_mtls_clientcert_validity_header_name: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_request_x_amzn_tls_cipher_suite_header_name: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_request_x_amzn_tls_version_header_name: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_response_access_control_allow_credentials_header_value: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_response_access_control_allow_headers_header_value: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_response_access_control_allow_methods_header_value: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_response_access_control_allow_origin_header_value: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_response_access_control_expose_headers_header_value: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_response_access_control_max_age_header_value: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_response_content_security_policy_header_value: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_response_server_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            routing_http_response_strict_transport_security_header_value: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_response_x_content_type_options_header_value: Optional[pulumi.Input[builtins.str]] = None,
            routing_http_response_x_frame_options_header_value: Optional[pulumi.Input[builtins.str]] = None,
            ssl_policy: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tcp_idle_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None) -> 'Listener':
        """
        Get an existing Listener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alpn_policy: Name of the Application-Layer Protocol Negotiation (ALPN) policy. Can be set if `protocol` is `TLS`. Valid values are `HTTP1Only`, `HTTP2Only`, `HTTP2Optional`, `HTTP2Preferred`, and `None`.
        :param pulumi.Input[builtins.str] arn: ARN of the listener.
        :param pulumi.Input[builtins.str] certificate_arn: ARN of the default SSL server certificate. Exactly one certificate is required if the protocol is HTTPS. For adding additional SSL certificates, see the `lb.ListenerCertificate` resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListenerDefaultActionArgs', 'ListenerDefaultActionArgsDict']]]] default_actions: Configuration block for default actions. See below.
        :param pulumi.Input[builtins.str] load_balancer_arn: ARN of the load balancer.
               
               The following arguments are optional:
        :param pulumi.Input[Union['ListenerMutualAuthenticationArgs', 'ListenerMutualAuthenticationArgsDict']] mutual_authentication: The mutual authentication configuration information. See below.
        :param pulumi.Input[builtins.int] port: Port on which the load balancer is listening. Not valid for Gateway Load Balancers.
        :param pulumi.Input[builtins.str] protocol: Protocol for connections from clients to the load balancer. For Application Load Balancers, valid values are `HTTP` and `HTTPS`, with a default of `HTTP`. For Network Load Balancers, valid values are `TCP`, `TLS`, `UDP`, and `TCP_UDP`. Not valid to use `UDP` or `TCP_UDP` if dual-stack mode is enabled. Not valid for Gateway Load Balancers.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_issuer_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Issuer` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_leaf_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Leaf` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Serial-Number` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_subject_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Subject` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_mtls_clientcert_validity_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Validity` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_tls_cipher_suite_header_name: Enables you to modify the header name of the `X-Amzn-Tls-Cipher-Suite` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_request_x_amzn_tls_version_header_name: Enables you to modify the header name of the `X-Amzn-Tls-Version` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_allow_credentials_header_value: Specifies which headers the browser can expose to the requesting client. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is `true`.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_allow_headers_header_value: Specifies which headers can be used during the request. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Accept`, `Accept-Language`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, `Pragma`. Dependent on your use-case other headers can be exposed and then set as a value consult the Access-Control-Allow-Headers documentation.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_allow_methods_header_value: Set which HTTP methods are allowed when accessing the server from a different origin. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `GET`, `HEAD`, `POST`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE` or `PATCH`.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_allow_origin_header_value: Specifies which origins are allowed to access the server. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. A valid value is a URI, eg: `https://example.com`.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_expose_headers_header_value: Specifies whether the browser should include credentials such as cookies or authentication when making requests. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, or `Pragma`. Dependent on your use-case other headers can be exposed, consult the Access-Control-Expose-Headers documentation.
        :param pulumi.Input[builtins.str] routing_http_response_access_control_max_age_header_value: Specifies how long the results of a preflight request can be cached, in seconds. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are between `0` and `86400`. This value is browser specific, consult the Access-Control-Max-Age documentation.
        :param pulumi.Input[builtins.str] routing_http_response_content_security_policy_header_value: Specifies restrictions enforced by the browser to help minimize the risk of certain types of security threats. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Values for this are extensive, and can be impactful when set, consult Content-Security-Policy documentation.
        :param pulumi.Input[builtins.bool] routing_http_response_server_enabled: Enables you to allow or remove the HTTP response server header. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `true` or `false`.
        :param pulumi.Input[builtins.str] routing_http_response_strict_transport_security_header_value: Informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS. Default values are `max-age=31536000; includeSubDomains; preload` consult the Strict-Transport-Security documentation for further details.
        :param pulumi.Input[builtins.str] routing_http_response_x_content_type_options_header_value: Indicates whether the MIME types advertised in the Content-Type headers should be followed and not be changed. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is `nosniff`.
        :param pulumi.Input[builtins.str] routing_http_response_x_frame_options_header_value: Indicates whether the browser is allowed to render a page in a frame, iframe, embed or object. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid values are `DENY`, `SAMEORIGIN`, or `ALLOW-FROM https://example.com`.
        :param pulumi.Input[builtins.str] ssl_policy: Name of the SSL Policy for the listener. Required if `protocol` is `HTTPS` or `TLS`. Default is `ELBSecurityPolicy-2016-08`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               > **Note::** When a `Name` key is specified in the map, the AWS Console maps the value to the `Name Tag` column value inside the `Listener Rules` table within a specific load balancer listener page. Otherwise, the value resolves to `Default`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.int] tcp_idle_timeout_seconds: TCP idle timeout value in seconds. Can only be set if protocol is `TCP` on Network Load Balancer, or with a Gateway Load Balancer. Not supported for Application Load Balancers. Valid values are between `60` and `6000` inclusive. Default: `350`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerState.__new__(_ListenerState)

        __props__.__dict__["alpn_policy"] = alpn_policy
        __props__.__dict__["arn"] = arn
        __props__.__dict__["certificate_arn"] = certificate_arn
        __props__.__dict__["default_actions"] = default_actions
        __props__.__dict__["load_balancer_arn"] = load_balancer_arn
        __props__.__dict__["mutual_authentication"] = mutual_authentication
        __props__.__dict__["port"] = port
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["routing_http_request_x_amzn_mtls_clientcert_header_name"] = routing_http_request_x_amzn_mtls_clientcert_header_name
        __props__.__dict__["routing_http_request_x_amzn_mtls_clientcert_issuer_header_name"] = routing_http_request_x_amzn_mtls_clientcert_issuer_header_name
        __props__.__dict__["routing_http_request_x_amzn_mtls_clientcert_leaf_header_name"] = routing_http_request_x_amzn_mtls_clientcert_leaf_header_name
        __props__.__dict__["routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name"] = routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name
        __props__.__dict__["routing_http_request_x_amzn_mtls_clientcert_subject_header_name"] = routing_http_request_x_amzn_mtls_clientcert_subject_header_name
        __props__.__dict__["routing_http_request_x_amzn_mtls_clientcert_validity_header_name"] = routing_http_request_x_amzn_mtls_clientcert_validity_header_name
        __props__.__dict__["routing_http_request_x_amzn_tls_cipher_suite_header_name"] = routing_http_request_x_amzn_tls_cipher_suite_header_name
        __props__.__dict__["routing_http_request_x_amzn_tls_version_header_name"] = routing_http_request_x_amzn_tls_version_header_name
        __props__.__dict__["routing_http_response_access_control_allow_credentials_header_value"] = routing_http_response_access_control_allow_credentials_header_value
        __props__.__dict__["routing_http_response_access_control_allow_headers_header_value"] = routing_http_response_access_control_allow_headers_header_value
        __props__.__dict__["routing_http_response_access_control_allow_methods_header_value"] = routing_http_response_access_control_allow_methods_header_value
        __props__.__dict__["routing_http_response_access_control_allow_origin_header_value"] = routing_http_response_access_control_allow_origin_header_value
        __props__.__dict__["routing_http_response_access_control_expose_headers_header_value"] = routing_http_response_access_control_expose_headers_header_value
        __props__.__dict__["routing_http_response_access_control_max_age_header_value"] = routing_http_response_access_control_max_age_header_value
        __props__.__dict__["routing_http_response_content_security_policy_header_value"] = routing_http_response_content_security_policy_header_value
        __props__.__dict__["routing_http_response_server_enabled"] = routing_http_response_server_enabled
        __props__.__dict__["routing_http_response_strict_transport_security_header_value"] = routing_http_response_strict_transport_security_header_value
        __props__.__dict__["routing_http_response_x_content_type_options_header_value"] = routing_http_response_x_content_type_options_header_value
        __props__.__dict__["routing_http_response_x_frame_options_header_value"] = routing_http_response_x_frame_options_header_value
        __props__.__dict__["ssl_policy"] = ssl_policy
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["tcp_idle_timeout_seconds"] = tcp_idle_timeout_seconds
        return Listener(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alpnPolicy")
    def alpn_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of the Application-Layer Protocol Negotiation (ALPN) policy. Can be set if `protocol` is `TLS`. Valid values are `HTTP1Only`, `HTTP2Only`, `HTTP2Optional`, `HTTP2Preferred`, and `None`.
        """
        return pulumi.get(self, "alpn_policy")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the listener.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ARN of the default SSL server certificate. Exactly one certificate is required if the protocol is HTTPS. For adding additional SSL certificates, see the `lb.ListenerCertificate` resource.
        """
        return pulumi.get(self, "certificate_arn")

    @property
    @pulumi.getter(name="defaultActions")
    def default_actions(self) -> pulumi.Output[Sequence['outputs.ListenerDefaultAction']]:
        """
        Configuration block for default actions. See below.
        """
        return pulumi.get(self, "default_actions")

    @property
    @pulumi.getter(name="loadBalancerArn")
    def load_balancer_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the load balancer.

        The following arguments are optional:
        """
        return pulumi.get(self, "load_balancer_arn")

    @property
    @pulumi.getter(name="mutualAuthentication")
    def mutual_authentication(self) -> pulumi.Output['outputs.ListenerMutualAuthentication']:
        """
        The mutual authentication configuration information. See below.
        """
        return pulumi.get(self, "mutual_authentication")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Port on which the load balancer is listening. Not valid for Gateway Load Balancers.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[builtins.str]:
        """
        Protocol for connections from clients to the load balancer. For Application Load Balancers, valid values are `HTTP` and `HTTPS`, with a default of `HTTP`. For Network Load Balancers, valid values are `TCP`, `TLS`, `UDP`, and `TCP_UDP`. Not valid to use `UDP` or `TCP_UDP` if dual-stack mode is enabled. Not valid for Gateway Load Balancers.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_header_name(self) -> pulumi.Output[builtins.str]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_header_name")

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertIssuerHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_issuer_header_name(self) -> pulumi.Output[builtins.str]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Issuer` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_issuer_header_name")

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertLeafHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_leaf_header_name(self) -> pulumi.Output[builtins.str]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Leaf` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_leaf_header_name")

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertSerialNumberHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name(self) -> pulumi.Output[builtins.str]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Serial-Number` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name")

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertSubjectHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_subject_header_name(self) -> pulumi.Output[builtins.str]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Subject` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_subject_header_name")

    @property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertValidityHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_validity_header_name(self) -> pulumi.Output[builtins.str]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Validity` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_validity_header_name")

    @property
    @pulumi.getter(name="routingHttpRequestXAmznTlsCipherSuiteHeaderName")
    def routing_http_request_x_amzn_tls_cipher_suite_header_name(self) -> pulumi.Output[builtins.str]:
        """
        Enables you to modify the header name of the `X-Amzn-Tls-Cipher-Suite` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_tls_cipher_suite_header_name")

    @property
    @pulumi.getter(name="routingHttpRequestXAmznTlsVersionHeaderName")
    def routing_http_request_x_amzn_tls_version_header_name(self) -> pulumi.Output[builtins.str]:
        """
        Enables you to modify the header name of the `X-Amzn-Tls-Version` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_tls_version_header_name")

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlAllowCredentialsHeaderValue")
    def routing_http_response_access_control_allow_credentials_header_value(self) -> pulumi.Output[builtins.str]:
        """
        Specifies which headers the browser can expose to the requesting client. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is `true`.
        """
        return pulumi.get(self, "routing_http_response_access_control_allow_credentials_header_value")

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlAllowHeadersHeaderValue")
    def routing_http_response_access_control_allow_headers_header_value(self) -> pulumi.Output[builtins.str]:
        """
        Specifies which headers can be used during the request. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Accept`, `Accept-Language`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, `Pragma`. Dependent on your use-case other headers can be exposed and then set as a value consult the Access-Control-Allow-Headers documentation.
        """
        return pulumi.get(self, "routing_http_response_access_control_allow_headers_header_value")

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlAllowMethodsHeaderValue")
    def routing_http_response_access_control_allow_methods_header_value(self) -> pulumi.Output[builtins.str]:
        """
        Set which HTTP methods are allowed when accessing the server from a different origin. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `GET`, `HEAD`, `POST`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE` or `PATCH`.
        """
        return pulumi.get(self, "routing_http_response_access_control_allow_methods_header_value")

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlAllowOriginHeaderValue")
    def routing_http_response_access_control_allow_origin_header_value(self) -> pulumi.Output[builtins.str]:
        """
        Specifies which origins are allowed to access the server. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. A valid value is a URI, eg: `https://example.com`.
        """
        return pulumi.get(self, "routing_http_response_access_control_allow_origin_header_value")

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlExposeHeadersHeaderValue")
    def routing_http_response_access_control_expose_headers_header_value(self) -> pulumi.Output[builtins.str]:
        """
        Specifies whether the browser should include credentials such as cookies or authentication when making requests. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, or `Pragma`. Dependent on your use-case other headers can be exposed, consult the Access-Control-Expose-Headers documentation.
        """
        return pulumi.get(self, "routing_http_response_access_control_expose_headers_header_value")

    @property
    @pulumi.getter(name="routingHttpResponseAccessControlMaxAgeHeaderValue")
    def routing_http_response_access_control_max_age_header_value(self) -> pulumi.Output[builtins.str]:
        """
        Specifies how long the results of a preflight request can be cached, in seconds. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are between `0` and `86400`. This value is browser specific, consult the Access-Control-Max-Age documentation.
        """
        return pulumi.get(self, "routing_http_response_access_control_max_age_header_value")

    @property
    @pulumi.getter(name="routingHttpResponseContentSecurityPolicyHeaderValue")
    def routing_http_response_content_security_policy_header_value(self) -> pulumi.Output[builtins.str]:
        """
        Specifies restrictions enforced by the browser to help minimize the risk of certain types of security threats. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Values for this are extensive, and can be impactful when set, consult Content-Security-Policy documentation.
        """
        return pulumi.get(self, "routing_http_response_content_security_policy_header_value")

    @property
    @pulumi.getter(name="routingHttpResponseServerEnabled")
    def routing_http_response_server_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enables you to allow or remove the HTTP response server header. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `true` or `false`.
        """
        return pulumi.get(self, "routing_http_response_server_enabled")

    @property
    @pulumi.getter(name="routingHttpResponseStrictTransportSecurityHeaderValue")
    def routing_http_response_strict_transport_security_header_value(self) -> pulumi.Output[builtins.str]:
        """
        Informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS. Default values are `max-age=31536000; includeSubDomains; preload` consult the Strict-Transport-Security documentation for further details.
        """
        return pulumi.get(self, "routing_http_response_strict_transport_security_header_value")

    @property
    @pulumi.getter(name="routingHttpResponseXContentTypeOptionsHeaderValue")
    def routing_http_response_x_content_type_options_header_value(self) -> pulumi.Output[builtins.str]:
        """
        Indicates whether the MIME types advertised in the Content-Type headers should be followed and not be changed. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is `nosniff`.
        """
        return pulumi.get(self, "routing_http_response_x_content_type_options_header_value")

    @property
    @pulumi.getter(name="routingHttpResponseXFrameOptionsHeaderValue")
    def routing_http_response_x_frame_options_header_value(self) -> pulumi.Output[builtins.str]:
        """
        Indicates whether the browser is allowed to render a page in a frame, iframe, embed or object. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid values are `DENY`, `SAMEORIGIN`, or `ALLOW-FROM https://example.com`.
        """
        return pulumi.get(self, "routing_http_response_x_frame_options_header_value")

    @property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> pulumi.Output[builtins.str]:
        """
        Name of the SSL Policy for the listener. Required if `protocol` is `HTTPS` or `TLS`. Default is `ELBSecurityPolicy-2016-08`.
        """
        return pulumi.get(self, "ssl_policy")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        > **Note::** When a `Name` key is specified in the map, the AWS Console maps the value to the `Name Tag` column value inside the `Listener Rules` table within a specific load balancer listener page. Otherwise, the value resolves to `Default`.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="tcpIdleTimeoutSeconds")
    def tcp_idle_timeout_seconds(self) -> pulumi.Output[builtins.int]:
        """
        TCP idle timeout value in seconds. Can only be set if protocol is `TCP` on Network Load Balancer, or with a Gateway Load Balancer. Not supported for Application Load Balancers. Valid values are between `60` and `6000` inclusive. Default: `350`.
        """
        return pulumi.get(self, "tcp_idle_timeout_seconds")

