# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IntentArgs', 'Intent']

@pulumi.input_type
class IntentArgs:
    def __init__(__self__, *,
                 fulfillment_activity: pulumi.Input['IntentFulfillmentActivityArgs'],
                 conclusion_statement: Optional[pulumi.Input['IntentConclusionStatementArgs']] = None,
                 confirmation_prompt: Optional[pulumi.Input['IntentConfirmationPromptArgs']] = None,
                 create_version: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dialog_code_hook: Optional[pulumi.Input['IntentDialogCodeHookArgs']] = None,
                 follow_up_prompt: Optional[pulumi.Input['IntentFollowUpPromptArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_intent_signature: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rejection_statement: Optional[pulumi.Input['IntentRejectionStatementArgs']] = None,
                 sample_utterances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 slots: Optional[pulumi.Input[Sequence[pulumi.Input['IntentSlotArgs']]]] = None):
        """
        The set of arguments for constructing a Intent resource.
        :param pulumi.Input['IntentFulfillmentActivityArgs'] fulfillment_activity: Describes how the intent is fulfilled. For example, after a
               user provides all of the information for a pizza order, `fulfillment_activity` defines how the bot
               places an order with a local pizza store. Attributes are documented under fulfillment_activity.
        :param pulumi.Input['IntentConclusionStatementArgs'] conclusion_statement: The statement that you want Amazon Lex to convey to the user
               after the intent is successfully fulfilled by the Lambda function. This element is relevant only if
               you provide a Lambda function in the `fulfillment_activity`. If you return the intent to the client
               application, you can't specify this element. The `follow_up_prompt` and `conclusion_statement` are
               mutually exclusive. You can specify only one. Attributes are documented under statement.
        :param pulumi.Input['IntentConfirmationPromptArgs'] confirmation_prompt: Prompts the user to confirm the intent. This question should
               have a yes or no answer. You you must provide both the `rejection_statement` and `confirmation_prompt`,
               or neither. Attributes are documented under prompt.
        :param pulumi.Input[builtins.bool] create_version: Determines if a new slot type version is created when the initial
               resource is created and on each update. Defaults to `false`.
        :param pulumi.Input[builtins.str] description: A description of the intent. Must be less than or equal to 200 characters in length.
        :param pulumi.Input['IntentDialogCodeHookArgs'] dialog_code_hook: Specifies a Lambda function to invoke for each user input. You can
               invoke this Lambda function to personalize user interaction. Attributes are documented under code_hook.
        :param pulumi.Input['IntentFollowUpPromptArgs'] follow_up_prompt: Amazon Lex uses this prompt to solicit additional activity after
               fulfilling an intent. For example, after the OrderPizza intent is fulfilled, you might prompt the
               user to order a drink. The `follow_up_prompt` field and the `conclusion_statement` field are mutually
               exclusive. You can specify only one. Attributes are documented under follow_up_prompt.
        :param pulumi.Input[builtins.str] name: The name of the intent, not case sensitive. Must be less than or equal to 100 characters in length.
        :param pulumi.Input[builtins.str] parent_intent_signature: A unique identifier for the built-in intent to base this
               intent on. To find the signature for an intent, see
               [Standard Built-in Intents](https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
               in the Alexa Skills Kit.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['IntentRejectionStatementArgs'] rejection_statement: When the user answers "no" to the question defined in
               `confirmation_prompt`, Amazon Lex responds with this statement to acknowledge that the intent was
               canceled. You must provide both the `rejection_statement` and the `confirmation_prompt`, or neither.
               Attributes are documented under statement.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sample_utterances: An array of utterances (strings) that a user might say to signal
               the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
               In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
        :param pulumi.Input[Sequence[pulumi.Input['IntentSlotArgs']]] slots: An list of intent slots. At runtime, Amazon Lex elicits required slot values
               from the user using prompts defined in the slots. Attributes are documented under slot.
        """
        pulumi.set(__self__, "fulfillment_activity", fulfillment_activity)
        if conclusion_statement is not None:
            pulumi.set(__self__, "conclusion_statement", conclusion_statement)
        if confirmation_prompt is not None:
            pulumi.set(__self__, "confirmation_prompt", confirmation_prompt)
        if create_version is not None:
            pulumi.set(__self__, "create_version", create_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dialog_code_hook is not None:
            pulumi.set(__self__, "dialog_code_hook", dialog_code_hook)
        if follow_up_prompt is not None:
            pulumi.set(__self__, "follow_up_prompt", follow_up_prompt)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_intent_signature is not None:
            pulumi.set(__self__, "parent_intent_signature", parent_intent_signature)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rejection_statement is not None:
            pulumi.set(__self__, "rejection_statement", rejection_statement)
        if sample_utterances is not None:
            pulumi.set(__self__, "sample_utterances", sample_utterances)
        if slots is not None:
            pulumi.set(__self__, "slots", slots)

    @property
    @pulumi.getter(name="fulfillmentActivity")
    def fulfillment_activity(self) -> pulumi.Input['IntentFulfillmentActivityArgs']:
        """
        Describes how the intent is fulfilled. For example, after a
        user provides all of the information for a pizza order, `fulfillment_activity` defines how the bot
        places an order with a local pizza store. Attributes are documented under fulfillment_activity.
        """
        return pulumi.get(self, "fulfillment_activity")

    @fulfillment_activity.setter
    def fulfillment_activity(self, value: pulumi.Input['IntentFulfillmentActivityArgs']):
        pulumi.set(self, "fulfillment_activity", value)

    @property
    @pulumi.getter(name="conclusionStatement")
    def conclusion_statement(self) -> Optional[pulumi.Input['IntentConclusionStatementArgs']]:
        """
        The statement that you want Amazon Lex to convey to the user
        after the intent is successfully fulfilled by the Lambda function. This element is relevant only if
        you provide a Lambda function in the `fulfillment_activity`. If you return the intent to the client
        application, you can't specify this element. The `follow_up_prompt` and `conclusion_statement` are
        mutually exclusive. You can specify only one. Attributes are documented under statement.
        """
        return pulumi.get(self, "conclusion_statement")

    @conclusion_statement.setter
    def conclusion_statement(self, value: Optional[pulumi.Input['IntentConclusionStatementArgs']]):
        pulumi.set(self, "conclusion_statement", value)

    @property
    @pulumi.getter(name="confirmationPrompt")
    def confirmation_prompt(self) -> Optional[pulumi.Input['IntentConfirmationPromptArgs']]:
        """
        Prompts the user to confirm the intent. This question should
        have a yes or no answer. You you must provide both the `rejection_statement` and `confirmation_prompt`,
        or neither. Attributes are documented under prompt.
        """
        return pulumi.get(self, "confirmation_prompt")

    @confirmation_prompt.setter
    def confirmation_prompt(self, value: Optional[pulumi.Input['IntentConfirmationPromptArgs']]):
        pulumi.set(self, "confirmation_prompt", value)

    @property
    @pulumi.getter(name="createVersion")
    def create_version(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if a new slot type version is created when the initial
        resource is created and on each update. Defaults to `false`.
        """
        return pulumi.get(self, "create_version")

    @create_version.setter
    def create_version(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "create_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the intent. Must be less than or equal to 200 characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dialogCodeHook")
    def dialog_code_hook(self) -> Optional[pulumi.Input['IntentDialogCodeHookArgs']]:
        """
        Specifies a Lambda function to invoke for each user input. You can
        invoke this Lambda function to personalize user interaction. Attributes are documented under code_hook.
        """
        return pulumi.get(self, "dialog_code_hook")

    @dialog_code_hook.setter
    def dialog_code_hook(self, value: Optional[pulumi.Input['IntentDialogCodeHookArgs']]):
        pulumi.set(self, "dialog_code_hook", value)

    @property
    @pulumi.getter(name="followUpPrompt")
    def follow_up_prompt(self) -> Optional[pulumi.Input['IntentFollowUpPromptArgs']]:
        """
        Amazon Lex uses this prompt to solicit additional activity after
        fulfilling an intent. For example, after the OrderPizza intent is fulfilled, you might prompt the
        user to order a drink. The `follow_up_prompt` field and the `conclusion_statement` field are mutually
        exclusive. You can specify only one. Attributes are documented under follow_up_prompt.
        """
        return pulumi.get(self, "follow_up_prompt")

    @follow_up_prompt.setter
    def follow_up_prompt(self, value: Optional[pulumi.Input['IntentFollowUpPromptArgs']]):
        pulumi.set(self, "follow_up_prompt", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the intent, not case sensitive. Must be less than or equal to 100 characters in length.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentIntentSignature")
    def parent_intent_signature(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier for the built-in intent to base this
        intent on. To find the signature for an intent, see
        [Standard Built-in Intents](https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
        in the Alexa Skills Kit.
        """
        return pulumi.get(self, "parent_intent_signature")

    @parent_intent_signature.setter
    def parent_intent_signature(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_intent_signature", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rejectionStatement")
    def rejection_statement(self) -> Optional[pulumi.Input['IntentRejectionStatementArgs']]:
        """
        When the user answers "no" to the question defined in
        `confirmation_prompt`, Amazon Lex responds with this statement to acknowledge that the intent was
        canceled. You must provide both the `rejection_statement` and the `confirmation_prompt`, or neither.
        Attributes are documented under statement.
        """
        return pulumi.get(self, "rejection_statement")

    @rejection_statement.setter
    def rejection_statement(self, value: Optional[pulumi.Input['IntentRejectionStatementArgs']]):
        pulumi.set(self, "rejection_statement", value)

    @property
    @pulumi.getter(name="sampleUtterances")
    def sample_utterances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of utterances (strings) that a user might say to signal
        the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
        In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
        """
        return pulumi.get(self, "sample_utterances")

    @sample_utterances.setter
    def sample_utterances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sample_utterances", value)

    @property
    @pulumi.getter
    def slots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntentSlotArgs']]]]:
        """
        An list of intent slots. At runtime, Amazon Lex elicits required slot values
        from the user using prompts defined in the slots. Attributes are documented under slot.
        """
        return pulumi.get(self, "slots")

    @slots.setter
    def slots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntentSlotArgs']]]]):
        pulumi.set(self, "slots", value)


@pulumi.input_type
class _IntentState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 checksum: Optional[pulumi.Input[builtins.str]] = None,
                 conclusion_statement: Optional[pulumi.Input['IntentConclusionStatementArgs']] = None,
                 confirmation_prompt: Optional[pulumi.Input['IntentConfirmationPromptArgs']] = None,
                 create_version: Optional[pulumi.Input[builtins.bool]] = None,
                 created_date: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dialog_code_hook: Optional[pulumi.Input['IntentDialogCodeHookArgs']] = None,
                 follow_up_prompt: Optional[pulumi.Input['IntentFollowUpPromptArgs']] = None,
                 fulfillment_activity: Optional[pulumi.Input['IntentFulfillmentActivityArgs']] = None,
                 last_updated_date: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_intent_signature: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rejection_statement: Optional[pulumi.Input['IntentRejectionStatementArgs']] = None,
                 sample_utterances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 slots: Optional[pulumi.Input[Sequence[pulumi.Input['IntentSlotArgs']]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Intent resources.
        :param pulumi.Input[builtins.str] arn: The ARN of the Lex intent.
        :param pulumi.Input[builtins.str] checksum: Checksum identifying the version of the intent that was created. The checksum is not
               included as an argument because the resource will add it automatically when updating the intent.
        :param pulumi.Input['IntentConclusionStatementArgs'] conclusion_statement: The statement that you want Amazon Lex to convey to the user
               after the intent is successfully fulfilled by the Lambda function. This element is relevant only if
               you provide a Lambda function in the `fulfillment_activity`. If you return the intent to the client
               application, you can't specify this element. The `follow_up_prompt` and `conclusion_statement` are
               mutually exclusive. You can specify only one. Attributes are documented under statement.
        :param pulumi.Input['IntentConfirmationPromptArgs'] confirmation_prompt: Prompts the user to confirm the intent. This question should
               have a yes or no answer. You you must provide both the `rejection_statement` and `confirmation_prompt`,
               or neither. Attributes are documented under prompt.
        :param pulumi.Input[builtins.bool] create_version: Determines if a new slot type version is created when the initial
               resource is created and on each update. Defaults to `false`.
        :param pulumi.Input[builtins.str] created_date: The date when the intent version was created.
        :param pulumi.Input[builtins.str] description: A description of the intent. Must be less than or equal to 200 characters in length.
        :param pulumi.Input['IntentDialogCodeHookArgs'] dialog_code_hook: Specifies a Lambda function to invoke for each user input. You can
               invoke this Lambda function to personalize user interaction. Attributes are documented under code_hook.
        :param pulumi.Input['IntentFollowUpPromptArgs'] follow_up_prompt: Amazon Lex uses this prompt to solicit additional activity after
               fulfilling an intent. For example, after the OrderPizza intent is fulfilled, you might prompt the
               user to order a drink. The `follow_up_prompt` field and the `conclusion_statement` field are mutually
               exclusive. You can specify only one. Attributes are documented under follow_up_prompt.
        :param pulumi.Input['IntentFulfillmentActivityArgs'] fulfillment_activity: Describes how the intent is fulfilled. For example, after a
               user provides all of the information for a pizza order, `fulfillment_activity` defines how the bot
               places an order with a local pizza store. Attributes are documented under fulfillment_activity.
        :param pulumi.Input[builtins.str] last_updated_date: The date when the $LATEST version of this intent was updated.
        :param pulumi.Input[builtins.str] name: The name of the intent, not case sensitive. Must be less than or equal to 100 characters in length.
        :param pulumi.Input[builtins.str] parent_intent_signature: A unique identifier for the built-in intent to base this
               intent on. To find the signature for an intent, see
               [Standard Built-in Intents](https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
               in the Alexa Skills Kit.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['IntentRejectionStatementArgs'] rejection_statement: When the user answers "no" to the question defined in
               `confirmation_prompt`, Amazon Lex responds with this statement to acknowledge that the intent was
               canceled. You must provide both the `rejection_statement` and the `confirmation_prompt`, or neither.
               Attributes are documented under statement.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sample_utterances: An array of utterances (strings) that a user might say to signal
               the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
               In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
        :param pulumi.Input[Sequence[pulumi.Input['IntentSlotArgs']]] slots: An list of intent slots. At runtime, Amazon Lex elicits required slot values
               from the user using prompts defined in the slots. Attributes are documented under slot.
        :param pulumi.Input[builtins.str] version: The version of the bot.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if conclusion_statement is not None:
            pulumi.set(__self__, "conclusion_statement", conclusion_statement)
        if confirmation_prompt is not None:
            pulumi.set(__self__, "confirmation_prompt", confirmation_prompt)
        if create_version is not None:
            pulumi.set(__self__, "create_version", create_version)
        if created_date is not None:
            pulumi.set(__self__, "created_date", created_date)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dialog_code_hook is not None:
            pulumi.set(__self__, "dialog_code_hook", dialog_code_hook)
        if follow_up_prompt is not None:
            pulumi.set(__self__, "follow_up_prompt", follow_up_prompt)
        if fulfillment_activity is not None:
            pulumi.set(__self__, "fulfillment_activity", fulfillment_activity)
        if last_updated_date is not None:
            pulumi.set(__self__, "last_updated_date", last_updated_date)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_intent_signature is not None:
            pulumi.set(__self__, "parent_intent_signature", parent_intent_signature)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rejection_statement is not None:
            pulumi.set(__self__, "rejection_statement", rejection_statement)
        if sample_utterances is not None:
            pulumi.set(__self__, "sample_utterances", sample_utterances)
        if slots is not None:
            pulumi.set(__self__, "slots", slots)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the Lex intent.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Checksum identifying the version of the intent that was created. The checksum is not
        included as an argument because the resource will add it automatically when updating the intent.
        """
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "checksum", value)

    @property
    @pulumi.getter(name="conclusionStatement")
    def conclusion_statement(self) -> Optional[pulumi.Input['IntentConclusionStatementArgs']]:
        """
        The statement that you want Amazon Lex to convey to the user
        after the intent is successfully fulfilled by the Lambda function. This element is relevant only if
        you provide a Lambda function in the `fulfillment_activity`. If you return the intent to the client
        application, you can't specify this element. The `follow_up_prompt` and `conclusion_statement` are
        mutually exclusive. You can specify only one. Attributes are documented under statement.
        """
        return pulumi.get(self, "conclusion_statement")

    @conclusion_statement.setter
    def conclusion_statement(self, value: Optional[pulumi.Input['IntentConclusionStatementArgs']]):
        pulumi.set(self, "conclusion_statement", value)

    @property
    @pulumi.getter(name="confirmationPrompt")
    def confirmation_prompt(self) -> Optional[pulumi.Input['IntentConfirmationPromptArgs']]:
        """
        Prompts the user to confirm the intent. This question should
        have a yes or no answer. You you must provide both the `rejection_statement` and `confirmation_prompt`,
        or neither. Attributes are documented under prompt.
        """
        return pulumi.get(self, "confirmation_prompt")

    @confirmation_prompt.setter
    def confirmation_prompt(self, value: Optional[pulumi.Input['IntentConfirmationPromptArgs']]):
        pulumi.set(self, "confirmation_prompt", value)

    @property
    @pulumi.getter(name="createVersion")
    def create_version(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if a new slot type version is created when the initial
        resource is created and on each update. Defaults to `false`.
        """
        return pulumi.get(self, "create_version")

    @create_version.setter
    def create_version(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "create_version", value)

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date when the intent version was created.
        """
        return pulumi.get(self, "created_date")

    @created_date.setter
    def created_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_date", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the intent. Must be less than or equal to 200 characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dialogCodeHook")
    def dialog_code_hook(self) -> Optional[pulumi.Input['IntentDialogCodeHookArgs']]:
        """
        Specifies a Lambda function to invoke for each user input. You can
        invoke this Lambda function to personalize user interaction. Attributes are documented under code_hook.
        """
        return pulumi.get(self, "dialog_code_hook")

    @dialog_code_hook.setter
    def dialog_code_hook(self, value: Optional[pulumi.Input['IntentDialogCodeHookArgs']]):
        pulumi.set(self, "dialog_code_hook", value)

    @property
    @pulumi.getter(name="followUpPrompt")
    def follow_up_prompt(self) -> Optional[pulumi.Input['IntentFollowUpPromptArgs']]:
        """
        Amazon Lex uses this prompt to solicit additional activity after
        fulfilling an intent. For example, after the OrderPizza intent is fulfilled, you might prompt the
        user to order a drink. The `follow_up_prompt` field and the `conclusion_statement` field are mutually
        exclusive. You can specify only one. Attributes are documented under follow_up_prompt.
        """
        return pulumi.get(self, "follow_up_prompt")

    @follow_up_prompt.setter
    def follow_up_prompt(self, value: Optional[pulumi.Input['IntentFollowUpPromptArgs']]):
        pulumi.set(self, "follow_up_prompt", value)

    @property
    @pulumi.getter(name="fulfillmentActivity")
    def fulfillment_activity(self) -> Optional[pulumi.Input['IntentFulfillmentActivityArgs']]:
        """
        Describes how the intent is fulfilled. For example, after a
        user provides all of the information for a pizza order, `fulfillment_activity` defines how the bot
        places an order with a local pizza store. Attributes are documented under fulfillment_activity.
        """
        return pulumi.get(self, "fulfillment_activity")

    @fulfillment_activity.setter
    def fulfillment_activity(self, value: Optional[pulumi.Input['IntentFulfillmentActivityArgs']]):
        pulumi.set(self, "fulfillment_activity", value)

    @property
    @pulumi.getter(name="lastUpdatedDate")
    def last_updated_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date when the $LATEST version of this intent was updated.
        """
        return pulumi.get(self, "last_updated_date")

    @last_updated_date.setter
    def last_updated_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_updated_date", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the intent, not case sensitive. Must be less than or equal to 100 characters in length.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentIntentSignature")
    def parent_intent_signature(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier for the built-in intent to base this
        intent on. To find the signature for an intent, see
        [Standard Built-in Intents](https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
        in the Alexa Skills Kit.
        """
        return pulumi.get(self, "parent_intent_signature")

    @parent_intent_signature.setter
    def parent_intent_signature(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_intent_signature", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rejectionStatement")
    def rejection_statement(self) -> Optional[pulumi.Input['IntentRejectionStatementArgs']]:
        """
        When the user answers "no" to the question defined in
        `confirmation_prompt`, Amazon Lex responds with this statement to acknowledge that the intent was
        canceled. You must provide both the `rejection_statement` and the `confirmation_prompt`, or neither.
        Attributes are documented under statement.
        """
        return pulumi.get(self, "rejection_statement")

    @rejection_statement.setter
    def rejection_statement(self, value: Optional[pulumi.Input['IntentRejectionStatementArgs']]):
        pulumi.set(self, "rejection_statement", value)

    @property
    @pulumi.getter(name="sampleUtterances")
    def sample_utterances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of utterances (strings) that a user might say to signal
        the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
        In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
        """
        return pulumi.get(self, "sample_utterances")

    @sample_utterances.setter
    def sample_utterances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sample_utterances", value)

    @property
    @pulumi.getter
    def slots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntentSlotArgs']]]]:
        """
        An list of intent slots. At runtime, Amazon Lex elicits required slot values
        from the user using prompts defined in the slots. Attributes are documented under slot.
        """
        return pulumi.get(self, "slots")

    @slots.setter
    def slots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntentSlotArgs']]]]):
        pulumi.set(self, "slots", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the bot.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("aws:lex/intent:Intent")
class Intent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conclusion_statement: Optional[pulumi.Input[Union['IntentConclusionStatementArgs', 'IntentConclusionStatementArgsDict']]] = None,
                 confirmation_prompt: Optional[pulumi.Input[Union['IntentConfirmationPromptArgs', 'IntentConfirmationPromptArgsDict']]] = None,
                 create_version: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dialog_code_hook: Optional[pulumi.Input[Union['IntentDialogCodeHookArgs', 'IntentDialogCodeHookArgsDict']]] = None,
                 follow_up_prompt: Optional[pulumi.Input[Union['IntentFollowUpPromptArgs', 'IntentFollowUpPromptArgsDict']]] = None,
                 fulfillment_activity: Optional[pulumi.Input[Union['IntentFulfillmentActivityArgs', 'IntentFulfillmentActivityArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_intent_signature: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rejection_statement: Optional[pulumi.Input[Union['IntentRejectionStatementArgs', 'IntentRejectionStatementArgsDict']]] = None,
                 sample_utterances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 slots: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntentSlotArgs', 'IntentSlotArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides an Amazon Lex Intent resource. For more information see
        [Amazon Lex: How It Works](https://docs.aws.amazon.com/lex/latest/dg/how-it-works.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        order_flowers_intent = aws.lex.Intent("order_flowers_intent",
            confirmation_prompt={
                "max_attempts": 2,
                "messages": [{
                    "content": "Okay, your {FlowerType} will be ready for pickup by {PickupTime} on {PickupDate}.  Does this sound okay?",
                    "content_type": "PlainText",
                }],
            },
            create_version=False,
            name="OrderFlowers",
            description="Intent to order a bouquet of flowers for pick up",
            fulfillment_activity={
                "type": "ReturnIntent",
            },
            rejection_statement={
                "messages": [{
                    "content": "Okay, I will not place your order.",
                    "content_type": "PlainText",
                }],
            },
            sample_utterances=[
                "I would like to order some flowers",
                "I would like to pick up flowers",
            ],
            slots=[
                {
                    "description": "The type of flowers to pick up",
                    "name": "FlowerType",
                    "priority": 1,
                    "sample_utterances": ["I would like to order {FlowerType}"],
                    "slot_constraint": "Required",
                    "slot_type": "FlowerTypes",
                    "slot_type_version": "$$LATEST",
                    "value_elicitation_prompt": {
                        "max_attempts": 2,
                        "messages": [{
                            "content": "What type of flowers would you like to order?",
                            "content_type": "PlainText",
                        }],
                    },
                },
                {
                    "description": "The date to pick up the flowers",
                    "name": "PickupDate",
                    "priority": 2,
                    "sample_utterances": ["I would like to order {FlowerType}"],
                    "slot_constraint": "Required",
                    "slot_type": "AMAZON.DATE",
                    "slot_type_version": "$$LATEST",
                    "value_elicitation_prompt": {
                        "max_attempts": 2,
                        "messages": [{
                            "content": "What day do you want the {FlowerType} to be picked up?",
                            "content_type": "PlainText",
                        }],
                    },
                },
                {
                    "description": "The time to pick up the flowers",
                    "name": "PickupTime",
                    "priority": 3,
                    "sample_utterances": ["I would like to order {FlowerType}"],
                    "slot_constraint": "Required",
                    "slot_type": "AMAZON.TIME",
                    "slot_type_version": "$$LATEST",
                    "value_elicitation_prompt": {
                        "max_attempts": 2,
                        "messages": [{
                            "content": "Pick up the {FlowerType} at what time on {PickupDate}?",
                            "content_type": "PlainText",
                        }],
                    },
                },
            ])
        ```

        ## Import

        Using `pulumi import`, import intents using their name. For example:

        ```sh
        $ pulumi import aws:lex/intent:Intent order_flowers_intent OrderFlowers
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IntentConclusionStatementArgs', 'IntentConclusionStatementArgsDict']] conclusion_statement: The statement that you want Amazon Lex to convey to the user
               after the intent is successfully fulfilled by the Lambda function. This element is relevant only if
               you provide a Lambda function in the `fulfillment_activity`. If you return the intent to the client
               application, you can't specify this element. The `follow_up_prompt` and `conclusion_statement` are
               mutually exclusive. You can specify only one. Attributes are documented under statement.
        :param pulumi.Input[Union['IntentConfirmationPromptArgs', 'IntentConfirmationPromptArgsDict']] confirmation_prompt: Prompts the user to confirm the intent. This question should
               have a yes or no answer. You you must provide both the `rejection_statement` and `confirmation_prompt`,
               or neither. Attributes are documented under prompt.
        :param pulumi.Input[builtins.bool] create_version: Determines if a new slot type version is created when the initial
               resource is created and on each update. Defaults to `false`.
        :param pulumi.Input[builtins.str] description: A description of the intent. Must be less than or equal to 200 characters in length.
        :param pulumi.Input[Union['IntentDialogCodeHookArgs', 'IntentDialogCodeHookArgsDict']] dialog_code_hook: Specifies a Lambda function to invoke for each user input. You can
               invoke this Lambda function to personalize user interaction. Attributes are documented under code_hook.
        :param pulumi.Input[Union['IntentFollowUpPromptArgs', 'IntentFollowUpPromptArgsDict']] follow_up_prompt: Amazon Lex uses this prompt to solicit additional activity after
               fulfilling an intent. For example, after the OrderPizza intent is fulfilled, you might prompt the
               user to order a drink. The `follow_up_prompt` field and the `conclusion_statement` field are mutually
               exclusive. You can specify only one. Attributes are documented under follow_up_prompt.
        :param pulumi.Input[Union['IntentFulfillmentActivityArgs', 'IntentFulfillmentActivityArgsDict']] fulfillment_activity: Describes how the intent is fulfilled. For example, after a
               user provides all of the information for a pizza order, `fulfillment_activity` defines how the bot
               places an order with a local pizza store. Attributes are documented under fulfillment_activity.
        :param pulumi.Input[builtins.str] name: The name of the intent, not case sensitive. Must be less than or equal to 100 characters in length.
        :param pulumi.Input[builtins.str] parent_intent_signature: A unique identifier for the built-in intent to base this
               intent on. To find the signature for an intent, see
               [Standard Built-in Intents](https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
               in the Alexa Skills Kit.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['IntentRejectionStatementArgs', 'IntentRejectionStatementArgsDict']] rejection_statement: When the user answers "no" to the question defined in
               `confirmation_prompt`, Amazon Lex responds with this statement to acknowledge that the intent was
               canceled. You must provide both the `rejection_statement` and the `confirmation_prompt`, or neither.
               Attributes are documented under statement.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sample_utterances: An array of utterances (strings) that a user might say to signal
               the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
               In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntentSlotArgs', 'IntentSlotArgsDict']]]] slots: An list of intent slots. At runtime, Amazon Lex elicits required slot values
               from the user using prompts defined in the slots. Attributes are documented under slot.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Amazon Lex Intent resource. For more information see
        [Amazon Lex: How It Works](https://docs.aws.amazon.com/lex/latest/dg/how-it-works.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        order_flowers_intent = aws.lex.Intent("order_flowers_intent",
            confirmation_prompt={
                "max_attempts": 2,
                "messages": [{
                    "content": "Okay, your {FlowerType} will be ready for pickup by {PickupTime} on {PickupDate}.  Does this sound okay?",
                    "content_type": "PlainText",
                }],
            },
            create_version=False,
            name="OrderFlowers",
            description="Intent to order a bouquet of flowers for pick up",
            fulfillment_activity={
                "type": "ReturnIntent",
            },
            rejection_statement={
                "messages": [{
                    "content": "Okay, I will not place your order.",
                    "content_type": "PlainText",
                }],
            },
            sample_utterances=[
                "I would like to order some flowers",
                "I would like to pick up flowers",
            ],
            slots=[
                {
                    "description": "The type of flowers to pick up",
                    "name": "FlowerType",
                    "priority": 1,
                    "sample_utterances": ["I would like to order {FlowerType}"],
                    "slot_constraint": "Required",
                    "slot_type": "FlowerTypes",
                    "slot_type_version": "$$LATEST",
                    "value_elicitation_prompt": {
                        "max_attempts": 2,
                        "messages": [{
                            "content": "What type of flowers would you like to order?",
                            "content_type": "PlainText",
                        }],
                    },
                },
                {
                    "description": "The date to pick up the flowers",
                    "name": "PickupDate",
                    "priority": 2,
                    "sample_utterances": ["I would like to order {FlowerType}"],
                    "slot_constraint": "Required",
                    "slot_type": "AMAZON.DATE",
                    "slot_type_version": "$$LATEST",
                    "value_elicitation_prompt": {
                        "max_attempts": 2,
                        "messages": [{
                            "content": "What day do you want the {FlowerType} to be picked up?",
                            "content_type": "PlainText",
                        }],
                    },
                },
                {
                    "description": "The time to pick up the flowers",
                    "name": "PickupTime",
                    "priority": 3,
                    "sample_utterances": ["I would like to order {FlowerType}"],
                    "slot_constraint": "Required",
                    "slot_type": "AMAZON.TIME",
                    "slot_type_version": "$$LATEST",
                    "value_elicitation_prompt": {
                        "max_attempts": 2,
                        "messages": [{
                            "content": "Pick up the {FlowerType} at what time on {PickupDate}?",
                            "content_type": "PlainText",
                        }],
                    },
                },
            ])
        ```

        ## Import

        Using `pulumi import`, import intents using their name. For example:

        ```sh
        $ pulumi import aws:lex/intent:Intent order_flowers_intent OrderFlowers
        ```

        :param str resource_name: The name of the resource.
        :param IntentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conclusion_statement: Optional[pulumi.Input[Union['IntentConclusionStatementArgs', 'IntentConclusionStatementArgsDict']]] = None,
                 confirmation_prompt: Optional[pulumi.Input[Union['IntentConfirmationPromptArgs', 'IntentConfirmationPromptArgsDict']]] = None,
                 create_version: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dialog_code_hook: Optional[pulumi.Input[Union['IntentDialogCodeHookArgs', 'IntentDialogCodeHookArgsDict']]] = None,
                 follow_up_prompt: Optional[pulumi.Input[Union['IntentFollowUpPromptArgs', 'IntentFollowUpPromptArgsDict']]] = None,
                 fulfillment_activity: Optional[pulumi.Input[Union['IntentFulfillmentActivityArgs', 'IntentFulfillmentActivityArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_intent_signature: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rejection_statement: Optional[pulumi.Input[Union['IntentRejectionStatementArgs', 'IntentRejectionStatementArgsDict']]] = None,
                 sample_utterances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 slots: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntentSlotArgs', 'IntentSlotArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntentArgs.__new__(IntentArgs)

            __props__.__dict__["conclusion_statement"] = conclusion_statement
            __props__.__dict__["confirmation_prompt"] = confirmation_prompt
            __props__.__dict__["create_version"] = create_version
            __props__.__dict__["description"] = description
            __props__.__dict__["dialog_code_hook"] = dialog_code_hook
            __props__.__dict__["follow_up_prompt"] = follow_up_prompt
            if fulfillment_activity is None and not opts.urn:
                raise TypeError("Missing required property 'fulfillment_activity'")
            __props__.__dict__["fulfillment_activity"] = fulfillment_activity
            __props__.__dict__["name"] = name
            __props__.__dict__["parent_intent_signature"] = parent_intent_signature
            __props__.__dict__["region"] = region
            __props__.__dict__["rejection_statement"] = rejection_statement
            __props__.__dict__["sample_utterances"] = sample_utterances
            __props__.__dict__["slots"] = slots
            __props__.__dict__["arn"] = None
            __props__.__dict__["checksum"] = None
            __props__.__dict__["created_date"] = None
            __props__.__dict__["last_updated_date"] = None
            __props__.__dict__["version"] = None
        super(Intent, __self__).__init__(
            'aws:lex/intent:Intent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            checksum: Optional[pulumi.Input[builtins.str]] = None,
            conclusion_statement: Optional[pulumi.Input[Union['IntentConclusionStatementArgs', 'IntentConclusionStatementArgsDict']]] = None,
            confirmation_prompt: Optional[pulumi.Input[Union['IntentConfirmationPromptArgs', 'IntentConfirmationPromptArgsDict']]] = None,
            create_version: Optional[pulumi.Input[builtins.bool]] = None,
            created_date: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            dialog_code_hook: Optional[pulumi.Input[Union['IntentDialogCodeHookArgs', 'IntentDialogCodeHookArgsDict']]] = None,
            follow_up_prompt: Optional[pulumi.Input[Union['IntentFollowUpPromptArgs', 'IntentFollowUpPromptArgsDict']]] = None,
            fulfillment_activity: Optional[pulumi.Input[Union['IntentFulfillmentActivityArgs', 'IntentFulfillmentActivityArgsDict']]] = None,
            last_updated_date: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent_intent_signature: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            rejection_statement: Optional[pulumi.Input[Union['IntentRejectionStatementArgs', 'IntentRejectionStatementArgsDict']]] = None,
            sample_utterances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            slots: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntentSlotArgs', 'IntentSlotArgsDict']]]]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'Intent':
        """
        Get an existing Intent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: The ARN of the Lex intent.
        :param pulumi.Input[builtins.str] checksum: Checksum identifying the version of the intent that was created. The checksum is not
               included as an argument because the resource will add it automatically when updating the intent.
        :param pulumi.Input[Union['IntentConclusionStatementArgs', 'IntentConclusionStatementArgsDict']] conclusion_statement: The statement that you want Amazon Lex to convey to the user
               after the intent is successfully fulfilled by the Lambda function. This element is relevant only if
               you provide a Lambda function in the `fulfillment_activity`. If you return the intent to the client
               application, you can't specify this element. The `follow_up_prompt` and `conclusion_statement` are
               mutually exclusive. You can specify only one. Attributes are documented under statement.
        :param pulumi.Input[Union['IntentConfirmationPromptArgs', 'IntentConfirmationPromptArgsDict']] confirmation_prompt: Prompts the user to confirm the intent. This question should
               have a yes or no answer. You you must provide both the `rejection_statement` and `confirmation_prompt`,
               or neither. Attributes are documented under prompt.
        :param pulumi.Input[builtins.bool] create_version: Determines if a new slot type version is created when the initial
               resource is created and on each update. Defaults to `false`.
        :param pulumi.Input[builtins.str] created_date: The date when the intent version was created.
        :param pulumi.Input[builtins.str] description: A description of the intent. Must be less than or equal to 200 characters in length.
        :param pulumi.Input[Union['IntentDialogCodeHookArgs', 'IntentDialogCodeHookArgsDict']] dialog_code_hook: Specifies a Lambda function to invoke for each user input. You can
               invoke this Lambda function to personalize user interaction. Attributes are documented under code_hook.
        :param pulumi.Input[Union['IntentFollowUpPromptArgs', 'IntentFollowUpPromptArgsDict']] follow_up_prompt: Amazon Lex uses this prompt to solicit additional activity after
               fulfilling an intent. For example, after the OrderPizza intent is fulfilled, you might prompt the
               user to order a drink. The `follow_up_prompt` field and the `conclusion_statement` field are mutually
               exclusive. You can specify only one. Attributes are documented under follow_up_prompt.
        :param pulumi.Input[Union['IntentFulfillmentActivityArgs', 'IntentFulfillmentActivityArgsDict']] fulfillment_activity: Describes how the intent is fulfilled. For example, after a
               user provides all of the information for a pizza order, `fulfillment_activity` defines how the bot
               places an order with a local pizza store. Attributes are documented under fulfillment_activity.
        :param pulumi.Input[builtins.str] last_updated_date: The date when the $LATEST version of this intent was updated.
        :param pulumi.Input[builtins.str] name: The name of the intent, not case sensitive. Must be less than or equal to 100 characters in length.
        :param pulumi.Input[builtins.str] parent_intent_signature: A unique identifier for the built-in intent to base this
               intent on. To find the signature for an intent, see
               [Standard Built-in Intents](https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
               in the Alexa Skills Kit.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['IntentRejectionStatementArgs', 'IntentRejectionStatementArgsDict']] rejection_statement: When the user answers "no" to the question defined in
               `confirmation_prompt`, Amazon Lex responds with this statement to acknowledge that the intent was
               canceled. You must provide both the `rejection_statement` and the `confirmation_prompt`, or neither.
               Attributes are documented under statement.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sample_utterances: An array of utterances (strings) that a user might say to signal
               the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
               In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntentSlotArgs', 'IntentSlotArgsDict']]]] slots: An list of intent slots. At runtime, Amazon Lex elicits required slot values
               from the user using prompts defined in the slots. Attributes are documented under slot.
        :param pulumi.Input[builtins.str] version: The version of the bot.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntentState.__new__(_IntentState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["checksum"] = checksum
        __props__.__dict__["conclusion_statement"] = conclusion_statement
        __props__.__dict__["confirmation_prompt"] = confirmation_prompt
        __props__.__dict__["create_version"] = create_version
        __props__.__dict__["created_date"] = created_date
        __props__.__dict__["description"] = description
        __props__.__dict__["dialog_code_hook"] = dialog_code_hook
        __props__.__dict__["follow_up_prompt"] = follow_up_prompt
        __props__.__dict__["fulfillment_activity"] = fulfillment_activity
        __props__.__dict__["last_updated_date"] = last_updated_date
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_intent_signature"] = parent_intent_signature
        __props__.__dict__["region"] = region
        __props__.__dict__["rejection_statement"] = rejection_statement
        __props__.__dict__["sample_utterances"] = sample_utterances
        __props__.__dict__["slots"] = slots
        __props__.__dict__["version"] = version
        return Intent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the Lex intent.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def checksum(self) -> pulumi.Output[builtins.str]:
        """
        Checksum identifying the version of the intent that was created. The checksum is not
        included as an argument because the resource will add it automatically when updating the intent.
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter(name="conclusionStatement")
    def conclusion_statement(self) -> pulumi.Output[Optional['outputs.IntentConclusionStatement']]:
        """
        The statement that you want Amazon Lex to convey to the user
        after the intent is successfully fulfilled by the Lambda function. This element is relevant only if
        you provide a Lambda function in the `fulfillment_activity`. If you return the intent to the client
        application, you can't specify this element. The `follow_up_prompt` and `conclusion_statement` are
        mutually exclusive. You can specify only one. Attributes are documented under statement.
        """
        return pulumi.get(self, "conclusion_statement")

    @property
    @pulumi.getter(name="confirmationPrompt")
    def confirmation_prompt(self) -> pulumi.Output[Optional['outputs.IntentConfirmationPrompt']]:
        """
        Prompts the user to confirm the intent. This question should
        have a yes or no answer. You you must provide both the `rejection_statement` and `confirmation_prompt`,
        or neither. Attributes are documented under prompt.
        """
        return pulumi.get(self, "confirmation_prompt")

    @property
    @pulumi.getter(name="createVersion")
    def create_version(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Determines if a new slot type version is created when the initial
        resource is created and on each update. Defaults to `false`.
        """
        return pulumi.get(self, "create_version")

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> pulumi.Output[builtins.str]:
        """
        The date when the intent version was created.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the intent. Must be less than or equal to 200 characters in length.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dialogCodeHook")
    def dialog_code_hook(self) -> pulumi.Output[Optional['outputs.IntentDialogCodeHook']]:
        """
        Specifies a Lambda function to invoke for each user input. You can
        invoke this Lambda function to personalize user interaction. Attributes are documented under code_hook.
        """
        return pulumi.get(self, "dialog_code_hook")

    @property
    @pulumi.getter(name="followUpPrompt")
    def follow_up_prompt(self) -> pulumi.Output[Optional['outputs.IntentFollowUpPrompt']]:
        """
        Amazon Lex uses this prompt to solicit additional activity after
        fulfilling an intent. For example, after the OrderPizza intent is fulfilled, you might prompt the
        user to order a drink. The `follow_up_prompt` field and the `conclusion_statement` field are mutually
        exclusive. You can specify only one. Attributes are documented under follow_up_prompt.
        """
        return pulumi.get(self, "follow_up_prompt")

    @property
    @pulumi.getter(name="fulfillmentActivity")
    def fulfillment_activity(self) -> pulumi.Output['outputs.IntentFulfillmentActivity']:
        """
        Describes how the intent is fulfilled. For example, after a
        user provides all of the information for a pizza order, `fulfillment_activity` defines how the bot
        places an order with a local pizza store. Attributes are documented under fulfillment_activity.
        """
        return pulumi.get(self, "fulfillment_activity")

    @property
    @pulumi.getter(name="lastUpdatedDate")
    def last_updated_date(self) -> pulumi.Output[builtins.str]:
        """
        The date when the $LATEST version of this intent was updated.
        """
        return pulumi.get(self, "last_updated_date")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the intent, not case sensitive. Must be less than or equal to 100 characters in length.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentIntentSignature")
    def parent_intent_signature(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A unique identifier for the built-in intent to base this
        intent on. To find the signature for an intent, see
        [Standard Built-in Intents](https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
        in the Alexa Skills Kit.
        """
        return pulumi.get(self, "parent_intent_signature")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="rejectionStatement")
    def rejection_statement(self) -> pulumi.Output[Optional['outputs.IntentRejectionStatement']]:
        """
        When the user answers "no" to the question defined in
        `confirmation_prompt`, Amazon Lex responds with this statement to acknowledge that the intent was
        canceled. You must provide both the `rejection_statement` and the `confirmation_prompt`, or neither.
        Attributes are documented under statement.
        """
        return pulumi.get(self, "rejection_statement")

    @property
    @pulumi.getter(name="sampleUtterances")
    def sample_utterances(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        An array of utterances (strings) that a user might say to signal
        the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
        In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
        """
        return pulumi.get(self, "sample_utterances")

    @property
    @pulumi.getter
    def slots(self) -> pulumi.Output[Optional[Sequence['outputs.IntentSlot']]]:
        """
        An list of intent slots. At runtime, Amazon Lex elicits required slot values
        from the user using prompts defined in the slots. Attributes are documented under slot.
        """
        return pulumi.get(self, "slots")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        The version of the bot.
        """
        return pulumi.get(self, "version")

