# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContainerServiceArgs', 'ContainerService']

@pulumi.input_type
class ContainerServiceArgs:
    def __init__(__self__, *,
                 power: pulumi.Input[builtins.str],
                 scale: pulumi.Input[builtins.int],
                 is_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 private_registry_access: Optional[pulumi.Input['ContainerServicePrivateRegistryAccessArgs']] = None,
                 public_domain_names: Optional[pulumi.Input['ContainerServicePublicDomainNamesArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ContainerService resource.
        :param pulumi.Input[builtins.str] power: Power specification for the container service. The power specifies the amount of memory, the number of vCPUs, and the monthly price of each node of the container service. Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
        :param pulumi.Input[builtins.int] scale: Scale specification for the container service. The scale specifies the allocated compute nodes of the container service.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.bool] is_disabled: Whether to disable the container service. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: Name of the container service. Names must be of length 1 to 63, and be unique within each AWS Region in your Lightsail account.
        :param pulumi.Input['ContainerServicePrivateRegistryAccessArgs'] private_registry_access: Configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See below.
        :param pulumi.Input['ContainerServicePublicDomainNamesArgs'] public_domain_names: Public domain names to use with the container service, such as example.com and www.example.com. You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container configured as the public endpoint of your container service. If you don't specify public domain names, then you can use the default domain of the container service. See below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "power", power)
        pulumi.set(__self__, "scale", scale)
        if is_disabled is not None:
            pulumi.set(__self__, "is_disabled", is_disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_registry_access is not None:
            pulumi.set(__self__, "private_registry_access", private_registry_access)
        if public_domain_names is not None:
            pulumi.set(__self__, "public_domain_names", public_domain_names)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def power(self) -> pulumi.Input[builtins.str]:
        """
        Power specification for the container service. The power specifies the amount of memory, the number of vCPUs, and the monthly price of each node of the container service. Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
        """
        return pulumi.get(self, "power")

    @power.setter
    def power(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "power", value)

    @property
    @pulumi.getter
    def scale(self) -> pulumi.Input[builtins.int]:
        """
        Scale specification for the container service. The scale specifies the allocated compute nodes of the container service.

        The following arguments are optional:
        """
        return pulumi.get(self, "scale")

    @scale.setter
    def scale(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "scale", value)

    @property
    @pulumi.getter(name="isDisabled")
    def is_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to disable the container service. Defaults to `false`.
        """
        return pulumi.get(self, "is_disabled")

    @is_disabled.setter
    def is_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_disabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the container service. Names must be of length 1 to 63, and be unique within each AWS Region in your Lightsail account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateRegistryAccess")
    def private_registry_access(self) -> Optional[pulumi.Input['ContainerServicePrivateRegistryAccessArgs']]:
        """
        Configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See below.
        """
        return pulumi.get(self, "private_registry_access")

    @private_registry_access.setter
    def private_registry_access(self, value: Optional[pulumi.Input['ContainerServicePrivateRegistryAccessArgs']]):
        pulumi.set(self, "private_registry_access", value)

    @property
    @pulumi.getter(name="publicDomainNames")
    def public_domain_names(self) -> Optional[pulumi.Input['ContainerServicePublicDomainNamesArgs']]:
        """
        Public domain names to use with the container service, such as example.com and www.example.com. You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container configured as the public endpoint of your container service. If you don't specify public domain names, then you can use the default domain of the container service. See below.
        """
        return pulumi.get(self, "public_domain_names")

    @public_domain_names.setter
    def public_domain_names(self, value: Optional[pulumi.Input['ContainerServicePublicDomainNamesArgs']]):
        pulumi.set(self, "public_domain_names", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ContainerServiceState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 is_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 power: Optional[pulumi.Input[builtins.str]] = None,
                 power_id: Optional[pulumi.Input[builtins.str]] = None,
                 principal_arn: Optional[pulumi.Input[builtins.str]] = None,
                 private_domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 private_registry_access: Optional[pulumi.Input['ContainerServicePrivateRegistryAccessArgs']] = None,
                 public_domain_names: Optional[pulumi.Input['ContainerServicePublicDomainNamesArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 scale: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ContainerService resources.
        :param pulumi.Input[builtins.str] arn: ARN of the container service.
        :param pulumi.Input[builtins.str] availability_zone: Availability Zone. Follows the format us-east-2a (case-sensitive).
        :param pulumi.Input[builtins.str] created_at: Date and time when the container service was created.
        :param pulumi.Input[builtins.bool] is_disabled: Whether to disable the container service. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: Name of the container service. Names must be of length 1 to 63, and be unique within each AWS Region in your Lightsail account.
        :param pulumi.Input[builtins.str] power: Power specification for the container service. The power specifies the amount of memory, the number of vCPUs, and the monthly price of each node of the container service. Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
        :param pulumi.Input[builtins.str] power_id: Power ID of the container service.
        :param pulumi.Input[builtins.str] principal_arn: Principal ARN of the container service. The principal ARN can be used to create a trust relationship between your standard AWS account and your Lightsail container service.
        :param pulumi.Input[builtins.str] private_domain_name: Private domain name of the container service. The private domain name is accessible only by other resources within the default virtual private cloud (VPC) of your Lightsail account.
        :param pulumi.Input['ContainerServicePrivateRegistryAccessArgs'] private_registry_access: Configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See below.
        :param pulumi.Input['ContainerServicePublicDomainNamesArgs'] public_domain_names: Public domain names to use with the container service, such as example.com and www.example.com. You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container configured as the public endpoint of your container service. If you don't specify public domain names, then you can use the default domain of the container service. See below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] resource_type: Lightsail resource type of the container service (i.e., ContainerService).
        :param pulumi.Input[builtins.int] scale: Scale specification for the container service. The scale specifies the allocated compute nodes of the container service.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] state: Current state of the container service.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] url: Publicly accessible URL of the container service. If no public endpoint is specified in the currentDeployment, this URL returns a 404 response.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if is_disabled is not None:
            pulumi.set(__self__, "is_disabled", is_disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if power is not None:
            pulumi.set(__self__, "power", power)
        if power_id is not None:
            pulumi.set(__self__, "power_id", power_id)
        if principal_arn is not None:
            pulumi.set(__self__, "principal_arn", principal_arn)
        if private_domain_name is not None:
            pulumi.set(__self__, "private_domain_name", private_domain_name)
        if private_registry_access is not None:
            pulumi.set(__self__, "private_registry_access", private_registry_access)
        if public_domain_names is not None:
            pulumi.set(__self__, "public_domain_names", public_domain_names)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the container service.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Availability Zone. Follows the format us-east-2a (case-sensitive).
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time when the container service was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="isDisabled")
    def is_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to disable the container service. Defaults to `false`.
        """
        return pulumi.get(self, "is_disabled")

    @is_disabled.setter
    def is_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_disabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the container service. Names must be of length 1 to 63, and be unique within each AWS Region in your Lightsail account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def power(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Power specification for the container service. The power specifies the amount of memory, the number of vCPUs, and the monthly price of each node of the container service. Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
        """
        return pulumi.get(self, "power")

    @power.setter
    def power(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "power", value)

    @property
    @pulumi.getter(name="powerId")
    def power_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Power ID of the container service.
        """
        return pulumi.get(self, "power_id")

    @power_id.setter
    def power_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "power_id", value)

    @property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Principal ARN of the container service. The principal ARN can be used to create a trust relationship between your standard AWS account and your Lightsail container service.
        """
        return pulumi.get(self, "principal_arn")

    @principal_arn.setter
    def principal_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_arn", value)

    @property
    @pulumi.getter(name="privateDomainName")
    def private_domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Private domain name of the container service. The private domain name is accessible only by other resources within the default virtual private cloud (VPC) of your Lightsail account.
        """
        return pulumi.get(self, "private_domain_name")

    @private_domain_name.setter
    def private_domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_domain_name", value)

    @property
    @pulumi.getter(name="privateRegistryAccess")
    def private_registry_access(self) -> Optional[pulumi.Input['ContainerServicePrivateRegistryAccessArgs']]:
        """
        Configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See below.
        """
        return pulumi.get(self, "private_registry_access")

    @private_registry_access.setter
    def private_registry_access(self, value: Optional[pulumi.Input['ContainerServicePrivateRegistryAccessArgs']]):
        pulumi.set(self, "private_registry_access", value)

    @property
    @pulumi.getter(name="publicDomainNames")
    def public_domain_names(self) -> Optional[pulumi.Input['ContainerServicePublicDomainNamesArgs']]:
        """
        Public domain names to use with the container service, such as example.com and www.example.com. You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container configured as the public endpoint of your container service. If you don't specify public domain names, then you can use the default domain of the container service. See below.
        """
        return pulumi.get(self, "public_domain_names")

    @public_domain_names.setter
    def public_domain_names(self, value: Optional[pulumi.Input['ContainerServicePublicDomainNamesArgs']]):
        pulumi.set(self, "public_domain_names", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lightsail resource type of the container service (i.e., ContainerService).
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def scale(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Scale specification for the container service. The scale specifies the allocated compute nodes of the container service.

        The following arguments are optional:
        """
        return pulumi.get(self, "scale")

    @scale.setter
    def scale(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "scale", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Current state of the container service.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Publicly accessible URL of the container service. If no public endpoint is specified in the currentDeployment, this URL returns a 404 response.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("aws:lightsail/containerService:ContainerService")
class ContainerService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 power: Optional[pulumi.Input[builtins.str]] = None,
                 private_registry_access: Optional[pulumi.Input[Union['ContainerServicePrivateRegistryAccessArgs', 'ContainerServicePrivateRegistryAccessArgsDict']]] = None,
                 public_domain_names: Optional[pulumi.Input[Union['ContainerServicePublicDomainNamesArgs', 'ContainerServicePublicDomainNamesArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scale: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Lightsail container service. Use this resource to create and manage a scalable compute and networking platform for deploying, running, and managing containerized applications in Lightsail.

        > **Note:** For more information about the AWS Regions in which you can create Amazon Lightsail container services, see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail).

        > **NOTE:** You must create and validate an SSL/TLS certificate before you can use `public_domain_names` with your container service. For more information, see [Enabling and managing custom domains for your Amazon Lightsail container services](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-container-services-certificates).

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lightsail.ContainerService("example",
            name="container-service-1",
            power="nano",
            scale=1,
            is_disabled=False,
            tags={
                "foo1": "bar1",
                "foo2": "",
            })
        ```

        ### Public Domain Names

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lightsail.ContainerService("example", public_domain_names={
            "certificates": [{
                "certificate_name": "example-certificate",
                "domain_names": ["www.example.com"],
            }],
        })
        ```

        ### Private Registry Access

        ```python
        import pulumi
        import pulumi_aws as aws

        example_container_service = aws.lightsail.ContainerService("example", private_registry_access={
            "ecr_image_puller_role": {
                "is_active": True,
            },
        })
        example = example_container_service.private_registry_access.apply(lambda private_registry_access: aws.iam.get_policy_document_output(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "AWS",
                "identifiers": [private_registry_access.ecr_image_puller_role.principal_arn],
            }],
            "actions": [
                "ecr:BatchGetImage",
                "ecr:GetDownloadUrlForLayer",
            ],
        }]))
        example_repository_policy = aws.ecr.RepositoryPolicy("example",
            repository=example_aws_ecr_repository["name"],
            policy=example.json)
        ```

        ## Import

        Using `pulumi import`, import Lightsail Container Service using the `name`. For example:

        ```sh
        $ pulumi import aws:lightsail/containerService:ContainerService example container-service-1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] is_disabled: Whether to disable the container service. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: Name of the container service. Names must be of length 1 to 63, and be unique within each AWS Region in your Lightsail account.
        :param pulumi.Input[builtins.str] power: Power specification for the container service. The power specifies the amount of memory, the number of vCPUs, and the monthly price of each node of the container service. Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
        :param pulumi.Input[Union['ContainerServicePrivateRegistryAccessArgs', 'ContainerServicePrivateRegistryAccessArgsDict']] private_registry_access: Configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See below.
        :param pulumi.Input[Union['ContainerServicePublicDomainNamesArgs', 'ContainerServicePublicDomainNamesArgsDict']] public_domain_names: Public domain names to use with the container service, such as example.com and www.example.com. You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container configured as the public endpoint of your container service. If you don't specify public domain names, then you can use the default domain of the container service. See below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] scale: Scale specification for the container service. The scale specifies the allocated compute nodes of the container service.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Lightsail container service. Use this resource to create and manage a scalable compute and networking platform for deploying, running, and managing containerized applications in Lightsail.

        > **Note:** For more information about the AWS Regions in which you can create Amazon Lightsail container services, see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail).

        > **NOTE:** You must create and validate an SSL/TLS certificate before you can use `public_domain_names` with your container service. For more information, see [Enabling and managing custom domains for your Amazon Lightsail container services](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-container-services-certificates).

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lightsail.ContainerService("example",
            name="container-service-1",
            power="nano",
            scale=1,
            is_disabled=False,
            tags={
                "foo1": "bar1",
                "foo2": "",
            })
        ```

        ### Public Domain Names

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lightsail.ContainerService("example", public_domain_names={
            "certificates": [{
                "certificate_name": "example-certificate",
                "domain_names": ["www.example.com"],
            }],
        })
        ```

        ### Private Registry Access

        ```python
        import pulumi
        import pulumi_aws as aws

        example_container_service = aws.lightsail.ContainerService("example", private_registry_access={
            "ecr_image_puller_role": {
                "is_active": True,
            },
        })
        example = example_container_service.private_registry_access.apply(lambda private_registry_access: aws.iam.get_policy_document_output(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "AWS",
                "identifiers": [private_registry_access.ecr_image_puller_role.principal_arn],
            }],
            "actions": [
                "ecr:BatchGetImage",
                "ecr:GetDownloadUrlForLayer",
            ],
        }]))
        example_repository_policy = aws.ecr.RepositoryPolicy("example",
            repository=example_aws_ecr_repository["name"],
            policy=example.json)
        ```

        ## Import

        Using `pulumi import`, import Lightsail Container Service using the `name`. For example:

        ```sh
        $ pulumi import aws:lightsail/containerService:ContainerService example container-service-1
        ```

        :param str resource_name: The name of the resource.
        :param ContainerServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 power: Optional[pulumi.Input[builtins.str]] = None,
                 private_registry_access: Optional[pulumi.Input[Union['ContainerServicePrivateRegistryAccessArgs', 'ContainerServicePrivateRegistryAccessArgsDict']]] = None,
                 public_domain_names: Optional[pulumi.Input[Union['ContainerServicePublicDomainNamesArgs', 'ContainerServicePublicDomainNamesArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 scale: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerServiceArgs.__new__(ContainerServiceArgs)

            __props__.__dict__["is_disabled"] = is_disabled
            __props__.__dict__["name"] = name
            if power is None and not opts.urn:
                raise TypeError("Missing required property 'power'")
            __props__.__dict__["power"] = power
            __props__.__dict__["private_registry_access"] = private_registry_access
            __props__.__dict__["public_domain_names"] = public_domain_names
            __props__.__dict__["region"] = region
            if scale is None and not opts.urn:
                raise TypeError("Missing required property 'scale'")
            __props__.__dict__["scale"] = scale
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["availability_zone"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["power_id"] = None
            __props__.__dict__["principal_arn"] = None
            __props__.__dict__["private_domain_name"] = None
            __props__.__dict__["resource_type"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["url"] = None
        super(ContainerService, __self__).__init__(
            'aws:lightsail/containerService:ContainerService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            availability_zone: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            is_disabled: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            power: Optional[pulumi.Input[builtins.str]] = None,
            power_id: Optional[pulumi.Input[builtins.str]] = None,
            principal_arn: Optional[pulumi.Input[builtins.str]] = None,
            private_domain_name: Optional[pulumi.Input[builtins.str]] = None,
            private_registry_access: Optional[pulumi.Input[Union['ContainerServicePrivateRegistryAccessArgs', 'ContainerServicePrivateRegistryAccessArgsDict']]] = None,
            public_domain_names: Optional[pulumi.Input[Union['ContainerServicePublicDomainNamesArgs', 'ContainerServicePublicDomainNamesArgsDict']]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            resource_type: Optional[pulumi.Input[builtins.str]] = None,
            scale: Optional[pulumi.Input[builtins.int]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None) -> 'ContainerService':
        """
        Get an existing ContainerService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the container service.
        :param pulumi.Input[builtins.str] availability_zone: Availability Zone. Follows the format us-east-2a (case-sensitive).
        :param pulumi.Input[builtins.str] created_at: Date and time when the container service was created.
        :param pulumi.Input[builtins.bool] is_disabled: Whether to disable the container service. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: Name of the container service. Names must be of length 1 to 63, and be unique within each AWS Region in your Lightsail account.
        :param pulumi.Input[builtins.str] power: Power specification for the container service. The power specifies the amount of memory, the number of vCPUs, and the monthly price of each node of the container service. Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
        :param pulumi.Input[builtins.str] power_id: Power ID of the container service.
        :param pulumi.Input[builtins.str] principal_arn: Principal ARN of the container service. The principal ARN can be used to create a trust relationship between your standard AWS account and your Lightsail container service.
        :param pulumi.Input[builtins.str] private_domain_name: Private domain name of the container service. The private domain name is accessible only by other resources within the default virtual private cloud (VPC) of your Lightsail account.
        :param pulumi.Input[Union['ContainerServicePrivateRegistryAccessArgs', 'ContainerServicePrivateRegistryAccessArgsDict']] private_registry_access: Configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See below.
        :param pulumi.Input[Union['ContainerServicePublicDomainNamesArgs', 'ContainerServicePublicDomainNamesArgsDict']] public_domain_names: Public domain names to use with the container service, such as example.com and www.example.com. You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container configured as the public endpoint of your container service. If you don't specify public domain names, then you can use the default domain of the container service. See below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] resource_type: Lightsail resource type of the container service (i.e., ContainerService).
        :param pulumi.Input[builtins.int] scale: Scale specification for the container service. The scale specifies the allocated compute nodes of the container service.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] state: Current state of the container service.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] url: Publicly accessible URL of the container service. If no public endpoint is specified in the currentDeployment, this URL returns a 404 response.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerServiceState.__new__(_ContainerServiceState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["is_disabled"] = is_disabled
        __props__.__dict__["name"] = name
        __props__.__dict__["power"] = power
        __props__.__dict__["power_id"] = power_id
        __props__.__dict__["principal_arn"] = principal_arn
        __props__.__dict__["private_domain_name"] = private_domain_name
        __props__.__dict__["private_registry_access"] = private_registry_access
        __props__.__dict__["public_domain_names"] = public_domain_names
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["scale"] = scale
        __props__.__dict__["state"] = state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["url"] = url
        return ContainerService(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the container service.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[builtins.str]:
        """
        Availability Zone. Follows the format us-east-2a (case-sensitive).
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Date and time when the container service was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="isDisabled")
    def is_disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to disable the container service. Defaults to `false`.
        """
        return pulumi.get(self, "is_disabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the container service. Names must be of length 1 to 63, and be unique within each AWS Region in your Lightsail account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def power(self) -> pulumi.Output[builtins.str]:
        """
        Power specification for the container service. The power specifies the amount of memory, the number of vCPUs, and the monthly price of each node of the container service. Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
        """
        return pulumi.get(self, "power")

    @property
    @pulumi.getter(name="powerId")
    def power_id(self) -> pulumi.Output[builtins.str]:
        """
        Power ID of the container service.
        """
        return pulumi.get(self, "power_id")

    @property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> pulumi.Output[builtins.str]:
        """
        Principal ARN of the container service. The principal ARN can be used to create a trust relationship between your standard AWS account and your Lightsail container service.
        """
        return pulumi.get(self, "principal_arn")

    @property
    @pulumi.getter(name="privateDomainName")
    def private_domain_name(self) -> pulumi.Output[builtins.str]:
        """
        Private domain name of the container service. The private domain name is accessible only by other resources within the default virtual private cloud (VPC) of your Lightsail account.
        """
        return pulumi.get(self, "private_domain_name")

    @property
    @pulumi.getter(name="privateRegistryAccess")
    def private_registry_access(self) -> pulumi.Output['outputs.ContainerServicePrivateRegistryAccess']:
        """
        Configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See below.
        """
        return pulumi.get(self, "private_registry_access")

    @property
    @pulumi.getter(name="publicDomainNames")
    def public_domain_names(self) -> pulumi.Output[Optional['outputs.ContainerServicePublicDomainNames']]:
        """
        Public domain names to use with the container service, such as example.com and www.example.com. You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container configured as the public endpoint of your container service. If you don't specify public domain names, then you can use the default domain of the container service. See below.
        """
        return pulumi.get(self, "public_domain_names")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[builtins.str]:
        """
        Lightsail resource type of the container service (i.e., ContainerService).
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def scale(self) -> pulumi.Output[builtins.int]:
        """
        Scale specification for the container service. The scale specifies the allocated compute nodes of the container service.

        The following arguments are optional:
        """
        return pulumi.get(self, "scale")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Current state of the container service.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        """
        Publicly accessible URL of the container service. If no public endpoint is specified in the currentDeployment, this URL returns a 404 response.
        """
        return pulumi.get(self, "url")

