# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['Disk_attachmentArgs', 'Disk_attachment']

@pulumi.input_type
class Disk_attachmentArgs:
    def __init__(__self__, *,
                 disk_name: pulumi.Input[builtins.str],
                 disk_path: pulumi.Input[builtins.str],
                 instance_name: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Disk_attachment resource.
        :param pulumi.Input[builtins.str] disk_name: Name of the Lightsail disk.
        :param pulumi.Input[builtins.str] disk_path: Disk path to expose to the instance.
        :param pulumi.Input[builtins.str] instance_name: Name of the Lightsail instance to attach to.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "disk_name", disk_name)
        pulumi.set(__self__, "disk_path", disk_path)
        pulumi.set(__self__, "instance_name", instance_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the Lightsail disk.
        """
        return pulumi.get(self, "disk_name")

    @disk_name.setter
    def disk_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "disk_name", value)

    @property
    @pulumi.getter(name="diskPath")
    def disk_path(self) -> pulumi.Input[builtins.str]:
        """
        Disk path to expose to the instance.
        """
        return pulumi.get(self, "disk_path")

    @disk_path.setter
    def disk_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "disk_path", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the Lightsail instance to attach to.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _Disk_attachmentState:
    def __init__(__self__, *,
                 disk_name: Optional[pulumi.Input[builtins.str]] = None,
                 disk_path: Optional[pulumi.Input[builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Disk_attachment resources.
        :param pulumi.Input[builtins.str] disk_name: Name of the Lightsail disk.
        :param pulumi.Input[builtins.str] disk_path: Disk path to expose to the instance.
        :param pulumi.Input[builtins.str] instance_name: Name of the Lightsail instance to attach to.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if disk_name is not None:
            pulumi.set(__self__, "disk_name", disk_name)
        if disk_path is not None:
            pulumi.set(__self__, "disk_path", disk_path)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Lightsail disk.
        """
        return pulumi.get(self, "disk_name")

    @disk_name.setter
    def disk_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "disk_name", value)

    @property
    @pulumi.getter(name="diskPath")
    def disk_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Disk path to expose to the instance.
        """
        return pulumi.get(self, "disk_path")

    @disk_path.setter
    def disk_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "disk_path", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Lightsail instance to attach to.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:lightsail/disk_attachment:Disk_attachment")
class Disk_attachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disk_name: Optional[pulumi.Input[builtins.str]] = None,
                 disk_path: Optional[pulumi.Input[builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Lightsail disk attachment. Use this resource to attach additional storage disks to your Lightsail instances for expanded storage capacity.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        available = aws.get_availability_zones(state="available",
            filters=[{
                "name": "opt-in-status",
                "values": ["opt-in-not-required"],
            }])
        example = aws.lightsail.Disk("example",
            name="example-disk",
            size_in_gb=8,
            availability_zone=available.names[0])
        example_instance = aws.lightsail.Instance("example",
            name="example-instance",
            availability_zone=available.names[0],
            blueprint_id="amazon_linux_2",
            bundle_id="nano_3_0")
        example_disk_attachment = aws.lightsail.Disk_attachment("example",
            disk_name=example.name,
            instance_name=example_instance.name,
            disk_path="/dev/xvdf")
        ```

        ## Import

        Using `pulumi import`, import `aws_lightsail_disk_attachment` using the id attribute. For example:

        ```sh
        $ pulumi import aws:lightsail/disk_attachment:Disk_attachment example example-disk,example-instance
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] disk_name: Name of the Lightsail disk.
        :param pulumi.Input[builtins.str] disk_path: Disk path to expose to the instance.
        :param pulumi.Input[builtins.str] instance_name: Name of the Lightsail instance to attach to.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Disk_attachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Lightsail disk attachment. Use this resource to attach additional storage disks to your Lightsail instances for expanded storage capacity.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        available = aws.get_availability_zones(state="available",
            filters=[{
                "name": "opt-in-status",
                "values": ["opt-in-not-required"],
            }])
        example = aws.lightsail.Disk("example",
            name="example-disk",
            size_in_gb=8,
            availability_zone=available.names[0])
        example_instance = aws.lightsail.Instance("example",
            name="example-instance",
            availability_zone=available.names[0],
            blueprint_id="amazon_linux_2",
            bundle_id="nano_3_0")
        example_disk_attachment = aws.lightsail.Disk_attachment("example",
            disk_name=example.name,
            instance_name=example_instance.name,
            disk_path="/dev/xvdf")
        ```

        ## Import

        Using `pulumi import`, import `aws_lightsail_disk_attachment` using the id attribute. For example:

        ```sh
        $ pulumi import aws:lightsail/disk_attachment:Disk_attachment example example-disk,example-instance
        ```

        :param str resource_name: The name of the resource.
        :param Disk_attachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Disk_attachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disk_name: Optional[pulumi.Input[builtins.str]] = None,
                 disk_path: Optional[pulumi.Input[builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Disk_attachmentArgs.__new__(Disk_attachmentArgs)

            if disk_name is None and not opts.urn:
                raise TypeError("Missing required property 'disk_name'")
            __props__.__dict__["disk_name"] = disk_name
            if disk_path is None and not opts.urn:
                raise TypeError("Missing required property 'disk_path'")
            __props__.__dict__["disk_path"] = disk_path
            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["region"] = region
        super(Disk_attachment, __self__).__init__(
            'aws:lightsail/disk_attachment:Disk_attachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            disk_name: Optional[pulumi.Input[builtins.str]] = None,
            disk_path: Optional[pulumi.Input[builtins.str]] = None,
            instance_name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'Disk_attachment':
        """
        Get an existing Disk_attachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] disk_name: Name of the Lightsail disk.
        :param pulumi.Input[builtins.str] disk_path: Disk path to expose to the instance.
        :param pulumi.Input[builtins.str] instance_name: Name of the Lightsail instance to attach to.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Disk_attachmentState.__new__(_Disk_attachmentState)

        __props__.__dict__["disk_name"] = disk_name
        __props__.__dict__["disk_path"] = disk_path
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["region"] = region
        return Disk_attachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Lightsail disk.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter(name="diskPath")
    def disk_path(self) -> pulumi.Output[builtins.str]:
        """
        Disk path to expose to the instance.
        """
        return pulumi.get(self, "disk_path")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Lightsail instance to attach to.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

