# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DistributionArgs', 'Distribution']

@pulumi.input_type
class DistributionArgs:
    def __init__(__self__, *,
                 bundle_id: pulumi.Input[builtins.str],
                 default_cache_behavior: pulumi.Input['DistributionDefaultCacheBehaviorArgs'],
                 origin: pulumi.Input['DistributionOriginArgs'],
                 cache_behavior_settings: Optional[pulumi.Input['DistributionCacheBehaviorSettingsArgs']] = None,
                 cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCacheBehaviorArgs']]]] = None,
                 certificate_name: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Distribution resource.
        :param pulumi.Input[builtins.str] bundle_id: Bundle ID to use for the distribution.
        :param pulumi.Input['DistributionDefaultCacheBehaviorArgs'] default_cache_behavior: Default cache behavior of the distribution. See below.
        :param pulumi.Input['DistributionOriginArgs'] origin: Origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer. See below.
               
               The following arguments are optional:
        :param pulumi.Input['DistributionCacheBehaviorSettingsArgs'] cache_behavior_settings: Cache behavior settings of the distribution. See below.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionCacheBehaviorArgs']]] cache_behaviors: Per-path cache behavior of the distribution. See below.
        :param pulumi.Input[builtins.str] certificate_name: Name of the SSL/TLS certificate attached to the distribution.
        :param pulumi.Input[builtins.str] ip_address_type: IP address type of the distribution. Valid values: `dualstack`, `ipv4`. Default: `dualstack`.
        :param pulumi.Input[builtins.bool] is_enabled: Whether the distribution is enabled. Default: `true`.
        :param pulumi.Input[builtins.str] name: Name of the distribution.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags for the Lightsail Distribution. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "bundle_id", bundle_id)
        pulumi.set(__self__, "default_cache_behavior", default_cache_behavior)
        pulumi.set(__self__, "origin", origin)
        if cache_behavior_settings is not None:
            pulumi.set(__self__, "cache_behavior_settings", cache_behavior_settings)
        if cache_behaviors is not None:
            pulumi.set(__self__, "cache_behaviors", cache_behaviors)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> pulumi.Input[builtins.str]:
        """
        Bundle ID to use for the distribution.
        """
        return pulumi.get(self, "bundle_id")

    @bundle_id.setter
    def bundle_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bundle_id", value)

    @property
    @pulumi.getter(name="defaultCacheBehavior")
    def default_cache_behavior(self) -> pulumi.Input['DistributionDefaultCacheBehaviorArgs']:
        """
        Default cache behavior of the distribution. See below.
        """
        return pulumi.get(self, "default_cache_behavior")

    @default_cache_behavior.setter
    def default_cache_behavior(self, value: pulumi.Input['DistributionDefaultCacheBehaviorArgs']):
        pulumi.set(self, "default_cache_behavior", value)

    @property
    @pulumi.getter
    def origin(self) -> pulumi.Input['DistributionOriginArgs']:
        """
        Origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer. See below.

        The following arguments are optional:
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: pulumi.Input['DistributionOriginArgs']):
        pulumi.set(self, "origin", value)

    @property
    @pulumi.getter(name="cacheBehaviorSettings")
    def cache_behavior_settings(self) -> Optional[pulumi.Input['DistributionCacheBehaviorSettingsArgs']]:
        """
        Cache behavior settings of the distribution. See below.
        """
        return pulumi.get(self, "cache_behavior_settings")

    @cache_behavior_settings.setter
    def cache_behavior_settings(self, value: Optional[pulumi.Input['DistributionCacheBehaviorSettingsArgs']]):
        pulumi.set(self, "cache_behavior_settings", value)

    @property
    @pulumi.getter(name="cacheBehaviors")
    def cache_behaviors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCacheBehaviorArgs']]]]:
        """
        Per-path cache behavior of the distribution. See below.
        """
        return pulumi.get(self, "cache_behaviors")

    @cache_behaviors.setter
    def cache_behaviors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCacheBehaviorArgs']]]]):
        pulumi.set(self, "cache_behaviors", value)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the SSL/TLS certificate attached to the distribution.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP address type of the distribution. Valid values: `dualstack`, `ipv4`. Default: `dualstack`.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the distribution is enabled. Default: `true`.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the distribution.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags for the Lightsail Distribution. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DistributionState:
    def __init__(__self__, *,
                 alternative_domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 bundle_id: Optional[pulumi.Input[builtins.str]] = None,
                 cache_behavior_settings: Optional[pulumi.Input['DistributionCacheBehaviorSettingsArgs']] = None,
                 cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCacheBehaviorArgs']]]] = None,
                 certificate_name: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 default_cache_behavior: Optional[pulumi.Input['DistributionDefaultCacheBehaviorArgs']] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionLocationArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 origin: Optional[pulumi.Input['DistributionOriginArgs']] = None,
                 origin_public_dns: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 support_code: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Distribution resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alternative_domain_names: Alternate domain names of the distribution.
        :param pulumi.Input[builtins.str] arn: ARN of the distribution.
        :param pulumi.Input[builtins.str] bundle_id: Bundle ID to use for the distribution.
        :param pulumi.Input['DistributionCacheBehaviorSettingsArgs'] cache_behavior_settings: Cache behavior settings of the distribution. See below.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionCacheBehaviorArgs']]] cache_behaviors: Per-path cache behavior of the distribution. See below.
        :param pulumi.Input[builtins.str] certificate_name: Name of the SSL/TLS certificate attached to the distribution.
        :param pulumi.Input[builtins.str] created_at: Timestamp when the distribution was created.
        :param pulumi.Input['DistributionDefaultCacheBehaviorArgs'] default_cache_behavior: Default cache behavior of the distribution. See below.
        :param pulumi.Input[builtins.str] domain_name: Domain name of the distribution.
        :param pulumi.Input[builtins.str] ip_address_type: IP address type of the distribution. Valid values: `dualstack`, `ipv4`. Default: `dualstack`.
        :param pulumi.Input[builtins.bool] is_enabled: Whether the distribution is enabled. Default: `true`.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionLocationArgs']]] locations: Location of the distribution, such as the AWS Region and Availability Zone. See below.
        :param pulumi.Input[builtins.str] name: Name of the distribution.
        :param pulumi.Input['DistributionOriginArgs'] origin: Origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer. See below.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] origin_public_dns: Public DNS of the origin.
               * `origin[0].resource_type` - Resource type of the origin resource (e.g., Instance).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] resource_type: Lightsail resource type (e.g., Distribution).
        :param pulumi.Input[builtins.str] status: Status of the distribution.
        :param pulumi.Input[builtins.str] support_code: Support code. Include this code in your email to support when you have questions about your Lightsail distribution. This code enables our support team to look up your Lightsail information more easily.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags for the Lightsail Distribution. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if alternative_domain_names is not None:
            pulumi.set(__self__, "alternative_domain_names", alternative_domain_names)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if bundle_id is not None:
            pulumi.set(__self__, "bundle_id", bundle_id)
        if cache_behavior_settings is not None:
            pulumi.set(__self__, "cache_behavior_settings", cache_behavior_settings)
        if cache_behaviors is not None:
            pulumi.set(__self__, "cache_behaviors", cache_behaviors)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if default_cache_behavior is not None:
            pulumi.set(__self__, "default_cache_behavior", default_cache_behavior)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if origin_public_dns is not None:
            pulumi.set(__self__, "origin_public_dns", origin_public_dns)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if support_code is not None:
            pulumi.set(__self__, "support_code", support_code)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter(name="alternativeDomainNames")
    def alternative_domain_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Alternate domain names of the distribution.
        """
        return pulumi.get(self, "alternative_domain_names")

    @alternative_domain_names.setter
    def alternative_domain_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "alternative_domain_names", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the distribution.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Bundle ID to use for the distribution.
        """
        return pulumi.get(self, "bundle_id")

    @bundle_id.setter
    def bundle_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bundle_id", value)

    @property
    @pulumi.getter(name="cacheBehaviorSettings")
    def cache_behavior_settings(self) -> Optional[pulumi.Input['DistributionCacheBehaviorSettingsArgs']]:
        """
        Cache behavior settings of the distribution. See below.
        """
        return pulumi.get(self, "cache_behavior_settings")

    @cache_behavior_settings.setter
    def cache_behavior_settings(self, value: Optional[pulumi.Input['DistributionCacheBehaviorSettingsArgs']]):
        pulumi.set(self, "cache_behavior_settings", value)

    @property
    @pulumi.getter(name="cacheBehaviors")
    def cache_behaviors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCacheBehaviorArgs']]]]:
        """
        Per-path cache behavior of the distribution. See below.
        """
        return pulumi.get(self, "cache_behaviors")

    @cache_behaviors.setter
    def cache_behaviors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCacheBehaviorArgs']]]]):
        pulumi.set(self, "cache_behaviors", value)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the SSL/TLS certificate attached to the distribution.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp when the distribution was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="defaultCacheBehavior")
    def default_cache_behavior(self) -> Optional[pulumi.Input['DistributionDefaultCacheBehaviorArgs']]:
        """
        Default cache behavior of the distribution. See below.
        """
        return pulumi.get(self, "default_cache_behavior")

    @default_cache_behavior.setter
    def default_cache_behavior(self, value: Optional[pulumi.Input['DistributionDefaultCacheBehaviorArgs']]):
        pulumi.set(self, "default_cache_behavior", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Domain name of the distribution.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP address type of the distribution. Valid values: `dualstack`, `ipv4`. Default: `dualstack`.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the distribution is enabled. Default: `true`.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionLocationArgs']]]]:
        """
        Location of the distribution, such as the AWS Region and Availability Zone. See below.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionLocationArgs']]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the distribution.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input['DistributionOriginArgs']]:
        """
        Origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer. See below.

        The following arguments are optional:
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input['DistributionOriginArgs']]):
        pulumi.set(self, "origin", value)

    @property
    @pulumi.getter(name="originPublicDns")
    def origin_public_dns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Public DNS of the origin.
        * `origin[0].resource_type` - Resource type of the origin resource (e.g., Instance).
        """
        return pulumi.get(self, "origin_public_dns")

    @origin_public_dns.setter
    def origin_public_dns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin_public_dns", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lightsail resource type (e.g., Distribution).
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of the distribution.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="supportCode")
    def support_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Support code. Include this code in your email to support when you have questions about your Lightsail distribution. This code enables our support team to look up your Lightsail information more easily.
        """
        return pulumi.get(self, "support_code")

    @support_code.setter
    def support_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "support_code", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags for the Lightsail Distribution. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:lightsail/distribution:Distribution")
class Distribution(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bundle_id: Optional[pulumi.Input[builtins.str]] = None,
                 cache_behavior_settings: Optional[pulumi.Input[Union['DistributionCacheBehaviorSettingsArgs', 'DistributionCacheBehaviorSettingsArgsDict']]] = None,
                 cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionCacheBehaviorArgs', 'DistributionCacheBehaviorArgsDict']]]]] = None,
                 certificate_name: Optional[pulumi.Input[builtins.str]] = None,
                 default_cache_behavior: Optional[pulumi.Input[Union['DistributionDefaultCacheBehaviorArgs', 'DistributionDefaultCacheBehaviorArgsDict']]] = None,
                 ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 origin: Optional[pulumi.Input[Union['DistributionOriginArgs', 'DistributionOriginArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Lightsail content delivery network (CDN) distribution. Use this resource to cache content at edge locations and reduce latency for users accessing your content.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lightsail.Bucket("example",
            name="example-bucket",
            bundle_id="small_1_0")
        example_distribution = aws.lightsail.Distribution("example",
            name="example-distribution",
            bundle_id="small_1_0",
            origin={
                "name": example.name,
                "region_name": example.region,
            },
            default_cache_behavior={
                "behavior": "cache",
            },
            cache_behavior_settings={
                "allowed_http_methods": "GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE",
                "cached_http_methods": "GET,HEAD",
                "default_ttl": 86400,
                "maximum_ttl": 31536000,
                "minimum_ttl": 0,
                "forwarded_cookies": {
                    "option": "none",
                },
                "forwarded_headers": {
                    "option": "default",
                },
                "forwarded_query_strings": {
                    "option": False,
                },
            })
        ```

        ### Instance Origin

        ```python
        import pulumi
        import pulumi_aws as aws

        available = aws.get_availability_zones(state="available",
            filters=[{
                "name": "opt-in-status",
                "values": ["opt-in-not-required"],
            }])
        example_static_ip = aws.lightsail.StaticIp("example", name="example-static-ip")
        example_instance = aws.lightsail.Instance("example",
            name="example-instance",
            availability_zone=available.names[0],
            blueprint_id="amazon_linux_2",
            bundle_id="micro_1_0")
        example = aws.lightsail.StaticIpAttachment("example",
            static_ip_name=example_static_ip.name,
            instance_name=example_instance.name)
        example_distribution = aws.lightsail.Distribution("example",
            name="example-distribution",
            bundle_id="small_1_0",
            origin={
                "name": example_instance.name,
                "region_name": available.id,
            },
            default_cache_behavior={
                "behavior": "cache",
            },
            opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ### Load Balancer Origin

        ```python
        import pulumi
        import pulumi_aws as aws

        available = aws.get_availability_zones(state="available",
            filters=[{
                "name": "opt-in-status",
                "values": ["opt-in-not-required"],
            }])
        example = aws.lightsail.Lb("example",
            name="example-load-balancer",
            health_check_path="/",
            instance_port=80,
            tags={
                "foo": "bar",
            })
        example_instance = aws.lightsail.Instance("example",
            name="example-instance",
            availability_zone=available.names[0],
            blueprint_id="amazon_linux_2",
            bundle_id="nano_3_0")
        example_lb_attachment = aws.lightsail.LbAttachment("example",
            lb_name=example.name,
            instance_name=example_instance.name)
        example_distribution = aws.lightsail.Distribution("example",
            name="example-distribution",
            bundle_id="small_1_0",
            origin={
                "name": example.name,
                "region_name": available.id,
            },
            default_cache_behavior={
                "behavior": "cache",
            },
            opts = pulumi.ResourceOptions(depends_on=[example_lb_attachment]))
        ```

        ## Import

        Using `pulumi import`, import Lightsail Distribution using the `name`. For example:

        ```sh
        $ pulumi import aws:lightsail/distribution:Distribution example example-distribution
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bundle_id: Bundle ID to use for the distribution.
        :param pulumi.Input[Union['DistributionCacheBehaviorSettingsArgs', 'DistributionCacheBehaviorSettingsArgsDict']] cache_behavior_settings: Cache behavior settings of the distribution. See below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DistributionCacheBehaviorArgs', 'DistributionCacheBehaviorArgsDict']]]] cache_behaviors: Per-path cache behavior of the distribution. See below.
        :param pulumi.Input[builtins.str] certificate_name: Name of the SSL/TLS certificate attached to the distribution.
        :param pulumi.Input[Union['DistributionDefaultCacheBehaviorArgs', 'DistributionDefaultCacheBehaviorArgsDict']] default_cache_behavior: Default cache behavior of the distribution. See below.
        :param pulumi.Input[builtins.str] ip_address_type: IP address type of the distribution. Valid values: `dualstack`, `ipv4`. Default: `dualstack`.
        :param pulumi.Input[builtins.bool] is_enabled: Whether the distribution is enabled. Default: `true`.
        :param pulumi.Input[builtins.str] name: Name of the distribution.
        :param pulumi.Input[Union['DistributionOriginArgs', 'DistributionOriginArgsDict']] origin: Origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer. See below.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags for the Lightsail Distribution. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DistributionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Lightsail content delivery network (CDN) distribution. Use this resource to cache content at edge locations and reduce latency for users accessing your content.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lightsail.Bucket("example",
            name="example-bucket",
            bundle_id="small_1_0")
        example_distribution = aws.lightsail.Distribution("example",
            name="example-distribution",
            bundle_id="small_1_0",
            origin={
                "name": example.name,
                "region_name": example.region,
            },
            default_cache_behavior={
                "behavior": "cache",
            },
            cache_behavior_settings={
                "allowed_http_methods": "GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE",
                "cached_http_methods": "GET,HEAD",
                "default_ttl": 86400,
                "maximum_ttl": 31536000,
                "minimum_ttl": 0,
                "forwarded_cookies": {
                    "option": "none",
                },
                "forwarded_headers": {
                    "option": "default",
                },
                "forwarded_query_strings": {
                    "option": False,
                },
            })
        ```

        ### Instance Origin

        ```python
        import pulumi
        import pulumi_aws as aws

        available = aws.get_availability_zones(state="available",
            filters=[{
                "name": "opt-in-status",
                "values": ["opt-in-not-required"],
            }])
        example_static_ip = aws.lightsail.StaticIp("example", name="example-static-ip")
        example_instance = aws.lightsail.Instance("example",
            name="example-instance",
            availability_zone=available.names[0],
            blueprint_id="amazon_linux_2",
            bundle_id="micro_1_0")
        example = aws.lightsail.StaticIpAttachment("example",
            static_ip_name=example_static_ip.name,
            instance_name=example_instance.name)
        example_distribution = aws.lightsail.Distribution("example",
            name="example-distribution",
            bundle_id="small_1_0",
            origin={
                "name": example_instance.name,
                "region_name": available.id,
            },
            default_cache_behavior={
                "behavior": "cache",
            },
            opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ### Load Balancer Origin

        ```python
        import pulumi
        import pulumi_aws as aws

        available = aws.get_availability_zones(state="available",
            filters=[{
                "name": "opt-in-status",
                "values": ["opt-in-not-required"],
            }])
        example = aws.lightsail.Lb("example",
            name="example-load-balancer",
            health_check_path="/",
            instance_port=80,
            tags={
                "foo": "bar",
            })
        example_instance = aws.lightsail.Instance("example",
            name="example-instance",
            availability_zone=available.names[0],
            blueprint_id="amazon_linux_2",
            bundle_id="nano_3_0")
        example_lb_attachment = aws.lightsail.LbAttachment("example",
            lb_name=example.name,
            instance_name=example_instance.name)
        example_distribution = aws.lightsail.Distribution("example",
            name="example-distribution",
            bundle_id="small_1_0",
            origin={
                "name": example.name,
                "region_name": available.id,
            },
            default_cache_behavior={
                "behavior": "cache",
            },
            opts = pulumi.ResourceOptions(depends_on=[example_lb_attachment]))
        ```

        ## Import

        Using `pulumi import`, import Lightsail Distribution using the `name`. For example:

        ```sh
        $ pulumi import aws:lightsail/distribution:Distribution example example-distribution
        ```

        :param str resource_name: The name of the resource.
        :param DistributionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DistributionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bundle_id: Optional[pulumi.Input[builtins.str]] = None,
                 cache_behavior_settings: Optional[pulumi.Input[Union['DistributionCacheBehaviorSettingsArgs', 'DistributionCacheBehaviorSettingsArgsDict']]] = None,
                 cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionCacheBehaviorArgs', 'DistributionCacheBehaviorArgsDict']]]]] = None,
                 certificate_name: Optional[pulumi.Input[builtins.str]] = None,
                 default_cache_behavior: Optional[pulumi.Input[Union['DistributionDefaultCacheBehaviorArgs', 'DistributionDefaultCacheBehaviorArgsDict']]] = None,
                 ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 origin: Optional[pulumi.Input[Union['DistributionOriginArgs', 'DistributionOriginArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DistributionArgs.__new__(DistributionArgs)

            if bundle_id is None and not opts.urn:
                raise TypeError("Missing required property 'bundle_id'")
            __props__.__dict__["bundle_id"] = bundle_id
            __props__.__dict__["cache_behavior_settings"] = cache_behavior_settings
            __props__.__dict__["cache_behaviors"] = cache_behaviors
            __props__.__dict__["certificate_name"] = certificate_name
            if default_cache_behavior is None and not opts.urn:
                raise TypeError("Missing required property 'default_cache_behavior'")
            __props__.__dict__["default_cache_behavior"] = default_cache_behavior
            __props__.__dict__["ip_address_type"] = ip_address_type
            __props__.__dict__["is_enabled"] = is_enabled
            __props__.__dict__["name"] = name
            if origin is None and not opts.urn:
                raise TypeError("Missing required property 'origin'")
            __props__.__dict__["origin"] = origin
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["alternative_domain_names"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["domain_name"] = None
            __props__.__dict__["locations"] = None
            __props__.__dict__["origin_public_dns"] = None
            __props__.__dict__["resource_type"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["support_code"] = None
            __props__.__dict__["tags_all"] = None
        super(Distribution, __self__).__init__(
            'aws:lightsail/distribution:Distribution',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alternative_domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            bundle_id: Optional[pulumi.Input[builtins.str]] = None,
            cache_behavior_settings: Optional[pulumi.Input[Union['DistributionCacheBehaviorSettingsArgs', 'DistributionCacheBehaviorSettingsArgsDict']]] = None,
            cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionCacheBehaviorArgs', 'DistributionCacheBehaviorArgsDict']]]]] = None,
            certificate_name: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            default_cache_behavior: Optional[pulumi.Input[Union['DistributionDefaultCacheBehaviorArgs', 'DistributionDefaultCacheBehaviorArgsDict']]] = None,
            domain_name: Optional[pulumi.Input[builtins.str]] = None,
            ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
            is_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionLocationArgs', 'DistributionLocationArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            origin: Optional[pulumi.Input[Union['DistributionOriginArgs', 'DistributionOriginArgsDict']]] = None,
            origin_public_dns: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            resource_type: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            support_code: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Distribution':
        """
        Get an existing Distribution resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alternative_domain_names: Alternate domain names of the distribution.
        :param pulumi.Input[builtins.str] arn: ARN of the distribution.
        :param pulumi.Input[builtins.str] bundle_id: Bundle ID to use for the distribution.
        :param pulumi.Input[Union['DistributionCacheBehaviorSettingsArgs', 'DistributionCacheBehaviorSettingsArgsDict']] cache_behavior_settings: Cache behavior settings of the distribution. See below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DistributionCacheBehaviorArgs', 'DistributionCacheBehaviorArgsDict']]]] cache_behaviors: Per-path cache behavior of the distribution. See below.
        :param pulumi.Input[builtins.str] certificate_name: Name of the SSL/TLS certificate attached to the distribution.
        :param pulumi.Input[builtins.str] created_at: Timestamp when the distribution was created.
        :param pulumi.Input[Union['DistributionDefaultCacheBehaviorArgs', 'DistributionDefaultCacheBehaviorArgsDict']] default_cache_behavior: Default cache behavior of the distribution. See below.
        :param pulumi.Input[builtins.str] domain_name: Domain name of the distribution.
        :param pulumi.Input[builtins.str] ip_address_type: IP address type of the distribution. Valid values: `dualstack`, `ipv4`. Default: `dualstack`.
        :param pulumi.Input[builtins.bool] is_enabled: Whether the distribution is enabled. Default: `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DistributionLocationArgs', 'DistributionLocationArgsDict']]]] locations: Location of the distribution, such as the AWS Region and Availability Zone. See below.
        :param pulumi.Input[builtins.str] name: Name of the distribution.
        :param pulumi.Input[Union['DistributionOriginArgs', 'DistributionOriginArgsDict']] origin: Origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer. See below.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] origin_public_dns: Public DNS of the origin.
               * `origin[0].resource_type` - Resource type of the origin resource (e.g., Instance).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] resource_type: Lightsail resource type (e.g., Distribution).
        :param pulumi.Input[builtins.str] status: Status of the distribution.
        :param pulumi.Input[builtins.str] support_code: Support code. Include this code in your email to support when you have questions about your Lightsail distribution. This code enables our support team to look up your Lightsail information more easily.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags for the Lightsail Distribution. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DistributionState.__new__(_DistributionState)

        __props__.__dict__["alternative_domain_names"] = alternative_domain_names
        __props__.__dict__["arn"] = arn
        __props__.__dict__["bundle_id"] = bundle_id
        __props__.__dict__["cache_behavior_settings"] = cache_behavior_settings
        __props__.__dict__["cache_behaviors"] = cache_behaviors
        __props__.__dict__["certificate_name"] = certificate_name
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["default_cache_behavior"] = default_cache_behavior
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["ip_address_type"] = ip_address_type
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["locations"] = locations
        __props__.__dict__["name"] = name
        __props__.__dict__["origin"] = origin
        __props__.__dict__["origin_public_dns"] = origin_public_dns
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["status"] = status
        __props__.__dict__["support_code"] = support_code
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Distribution(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alternativeDomainNames")
    def alternative_domain_names(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Alternate domain names of the distribution.
        """
        return pulumi.get(self, "alternative_domain_names")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the distribution.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> pulumi.Output[builtins.str]:
        """
        Bundle ID to use for the distribution.
        """
        return pulumi.get(self, "bundle_id")

    @property
    @pulumi.getter(name="cacheBehaviorSettings")
    def cache_behavior_settings(self) -> pulumi.Output[Optional['outputs.DistributionCacheBehaviorSettings']]:
        """
        Cache behavior settings of the distribution. See below.
        """
        return pulumi.get(self, "cache_behavior_settings")

    @property
    @pulumi.getter(name="cacheBehaviors")
    def cache_behaviors(self) -> pulumi.Output[Optional[Sequence['outputs.DistributionCacheBehavior']]]:
        """
        Per-path cache behavior of the distribution. See below.
        """
        return pulumi.get(self, "cache_behaviors")

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of the SSL/TLS certificate attached to the distribution.
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp when the distribution was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="defaultCacheBehavior")
    def default_cache_behavior(self) -> pulumi.Output['outputs.DistributionDefaultCacheBehavior']:
        """
        Default cache behavior of the distribution. See below.
        """
        return pulumi.get(self, "default_cache_behavior")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[builtins.str]:
        """
        Domain name of the distribution.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IP address type of the distribution. Valid values: `dualstack`, `ipv4`. Default: `dualstack`.
        """
        return pulumi.get(self, "ip_address_type")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the distribution is enabled. Default: `true`.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Sequence['outputs.DistributionLocation']]:
        """
        Location of the distribution, such as the AWS Region and Availability Zone. See below.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the distribution.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def origin(self) -> pulumi.Output['outputs.DistributionOrigin']:
        """
        Origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer. See below.

        The following arguments are optional:
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter(name="originPublicDns")
    def origin_public_dns(self) -> pulumi.Output[builtins.str]:
        """
        Public DNS of the origin.
        * `origin[0].resource_type` - Resource type of the origin resource (e.g., Instance).
        """
        return pulumi.get(self, "origin_public_dns")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[builtins.str]:
        """
        Lightsail resource type (e.g., Distribution).
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Status of the distribution.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportCode")
    def support_code(self) -> pulumi.Output[builtins.str]:
        """
        Support code. Include this code in your email to support when you have questions about your Lightsail distribution. This code enables our support team to look up your Lightsail information more easily.
        """
        return pulumi.get(self, "support_code")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags for the Lightsail Distribution. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

