# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetTrackerAssociationsResult',
    'AwaitableGetTrackerAssociationsResult',
    'get_tracker_associations',
    'get_tracker_associations_output',
]

@pulumi.output_type
class GetTrackerAssociationsResult:
    """
    A collection of values returned by getTrackerAssociations.
    """
    def __init__(__self__, consumer_arns=None, id=None, region=None, tracker_name=None):
        if consumer_arns and not isinstance(consumer_arns, list):
            raise TypeError("Expected argument 'consumer_arns' to be a list")
        pulumi.set(__self__, "consumer_arns", consumer_arns)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tracker_name and not isinstance(tracker_name, str):
            raise TypeError("Expected argument 'tracker_name' to be a str")
        pulumi.set(__self__, "tracker_name", tracker_name)

    @property
    @pulumi.getter(name="consumerArns")
    def consumer_arns(self) -> Sequence[builtins.str]:
        """
        List of geofence collection ARNs associated to the tracker resource.
        """
        return pulumi.get(self, "consumer_arns")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="trackerName")
    def tracker_name(self) -> builtins.str:
        return pulumi.get(self, "tracker_name")


class AwaitableGetTrackerAssociationsResult(GetTrackerAssociationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrackerAssociationsResult(
            consumer_arns=self.consumer_arns,
            id=self.id,
            region=self.region,
            tracker_name=self.tracker_name)


def get_tracker_associations(region: Optional[builtins.str] = None,
                             tracker_name: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrackerAssociationsResult:
    """
    Retrieve information about Location Service Tracker Associations.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.location.get_tracker_associations(tracker_name="example")
    ```


    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str tracker_name: Name of the tracker resource associated with a geofence collection.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['trackerName'] = tracker_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:location/getTrackerAssociations:getTrackerAssociations', __args__, opts=opts, typ=GetTrackerAssociationsResult).value

    return AwaitableGetTrackerAssociationsResult(
        consumer_arns=pulumi.get(__ret__, 'consumer_arns'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        tracker_name=pulumi.get(__ret__, 'tracker_name'))
def get_tracker_associations_output(region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    tracker_name: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTrackerAssociationsResult]:
    """
    Retrieve information about Location Service Tracker Associations.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.location.get_tracker_associations(tracker_name="example")
    ```


    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str tracker_name: Name of the tracker resource associated with a geofence collection.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['trackerName'] = tracker_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:location/getTrackerAssociations:getTrackerAssociations', __args__, opts=opts, typ=GetTrackerAssociationsResult)
    return __ret__.apply(lambda __response__: GetTrackerAssociationsResult(
        consumer_arns=pulumi.get(__response__, 'consumer_arns'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        tracker_name=pulumi.get(__response__, 'tracker_name')))
