# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ApplicationDefinition',
    'ApplicationTimeouts',
    'DeploymentTimeouts',
    'EnvironmentHighAvailabilityConfig',
    'EnvironmentStorageConfiguration',
    'EnvironmentStorageConfigurationEfs',
    'EnvironmentStorageConfigurationFsx',
    'EnvironmentTimeouts',
]

@pulumi.output_type
class ApplicationDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Location":
            suggest = "s3_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: Optional[builtins.str] = None,
                 s3_location: Optional[builtins.str] = None):
        """
        :param builtins.str content: JSON application definition. Either this or `s3_location` must be specified.
        :param builtins.str s3_location: Location of the application definition in S3. Either this or `content` must be specified.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if s3_location is not None:
            pulumi.set(__self__, "s3_location", s3_location)

    @property
    @pulumi.getter
    def content(self) -> Optional[builtins.str]:
        """
        JSON application definition. Either this or `s3_location` must be specified.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="s3Location")
    def s3_location(self) -> Optional[builtins.str]:
        """
        Location of the application definition in S3. Either this or `content` must be specified.
        """
        return pulumi.get(self, "s3_location")


@pulumi.output_type
class ApplicationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None,
                 update: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class DeploymentTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None,
                 update: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class EnvironmentHighAvailabilityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredCapacity":
            suggest = "desired_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentHighAvailabilityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentHighAvailabilityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentHighAvailabilityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired_capacity: builtins.int):
        """
        :param builtins.int desired_capacity: Desired number of instances for the Environment.
        """
        pulumi.set(__self__, "desired_capacity", desired_capacity)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> builtins.int:
        """
        Desired number of instances for the Environment.
        """
        return pulumi.get(self, "desired_capacity")


@pulumi.output_type
class EnvironmentStorageConfiguration(dict):
    def __init__(__self__, *,
                 efs: Optional['outputs.EnvironmentStorageConfigurationEfs'] = None,
                 fsx: Optional['outputs.EnvironmentStorageConfigurationFsx'] = None):
        if efs is not None:
            pulumi.set(__self__, "efs", efs)
        if fsx is not None:
            pulumi.set(__self__, "fsx", fsx)

    @property
    @pulumi.getter
    def efs(self) -> Optional['outputs.EnvironmentStorageConfigurationEfs']:
        return pulumi.get(self, "efs")

    @property
    @pulumi.getter
    def fsx(self) -> Optional['outputs.EnvironmentStorageConfigurationFsx']:
        return pulumi.get(self, "fsx")


@pulumi.output_type
class EnvironmentStorageConfigurationEfs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemId":
            suggest = "file_system_id"
        elif key == "mountPoint":
            suggest = "mount_point"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentStorageConfigurationEfs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentStorageConfigurationEfs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentStorageConfigurationEfs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_id: builtins.str,
                 mount_point: builtins.str):
        """
        :param builtins.str file_system_id: Id of the EFS filesystem to mount.
        :param builtins.str mount_point: Path to mount the filesystem on, must start with `/m2/mount/`.
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "mount_point", mount_point)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> builtins.str:
        """
        Id of the EFS filesystem to mount.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> builtins.str:
        """
        Path to mount the filesystem on, must start with `/m2/mount/`.
        """
        return pulumi.get(self, "mount_point")


@pulumi.output_type
class EnvironmentStorageConfigurationFsx(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemId":
            suggest = "file_system_id"
        elif key == "mountPoint":
            suggest = "mount_point"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentStorageConfigurationFsx. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentStorageConfigurationFsx.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentStorageConfigurationFsx.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_id: builtins.str,
                 mount_point: builtins.str):
        """
        :param builtins.str file_system_id: Id of the FSX filesystem to mount.
        :param builtins.str mount_point: Path to mount the filesystem on, must start with `/m2/mount/`.
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "mount_point", mount_point)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> builtins.str:
        """
        Id of the FSX filesystem to mount.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> builtins.str:
        """
        Path to mount the filesystem on, must start with `/m2/mount/`.
        """
        return pulumi.get(self, "mount_point")


@pulumi.output_type
class EnvironmentTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None,
                 update: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


