# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClassificationExportConfigurationS3Destination',
    'ClassificationJobS3JobDefinition',
    'ClassificationJobS3JobDefinitionBucketCriteria',
    'ClassificationJobS3JobDefinitionBucketCriteriaExcludes',
    'ClassificationJobS3JobDefinitionBucketCriteriaExcludesAnd',
    'ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndSimpleCriterion',
    'ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterion',
    'ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValue',
    'ClassificationJobS3JobDefinitionBucketCriteriaIncludes',
    'ClassificationJobS3JobDefinitionBucketCriteriaIncludesAnd',
    'ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndSimpleCriterion',
    'ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterion',
    'ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterionTagValue',
    'ClassificationJobS3JobDefinitionBucketDefinition',
    'ClassificationJobS3JobDefinitionScoping',
    'ClassificationJobS3JobDefinitionScopingExcludes',
    'ClassificationJobS3JobDefinitionScopingExcludesAnd',
    'ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTerm',
    'ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTerm',
    'ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValue',
    'ClassificationJobS3JobDefinitionScopingIncludes',
    'ClassificationJobS3JobDefinitionScopingIncludesAnd',
    'ClassificationJobS3JobDefinitionScopingIncludesAndSimpleScopeTerm',
    'ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTerm',
    'ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValue',
    'ClassificationJobScheduleFrequency',
    'ClassificationJobUserPausedDetail',
]

@pulumi.output_type
class ClassificationExportConfigurationS3Destination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "kmsKeyArn":
            suggest = "kms_key_arn"
        elif key == "keyPrefix":
            suggest = "key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassificationExportConfigurationS3Destination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassificationExportConfigurationS3Destination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassificationExportConfigurationS3Destination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str,
                 kms_key_arn: builtins.str,
                 key_prefix: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_name: The Amazon S3 bucket name in which Amazon Macie exports the data classification results.
        :param builtins.str kms_key_arn: Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.
               
               Additional information can be found in the [Storing and retaining sensitive data discovery results with Amazon Macie for AWS Macie documentation](https://docs.aws.amazon.com/macie/latest/user/discovery-results-repository-s3.html).
        :param builtins.str key_prefix: The object key for the bucket in which Amazon Macie exports the data classification results.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if key_prefix is not None:
            pulumi.set(__self__, "key_prefix", key_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The Amazon S3 bucket name in which Amazon Macie exports the data classification results.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> builtins.str:
        """
        Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.

        Additional information can be found in the [Storing and retaining sensitive data discovery results with Amazon Macie for AWS Macie documentation](https://docs.aws.amazon.com/macie/latest/user/discovery-results-repository-s3.html).
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="keyPrefix")
    def key_prefix(self) -> Optional[builtins.str]:
        """
        The object key for the bucket in which Amazon Macie exports the data classification results.
        """
        return pulumi.get(self, "key_prefix")


@pulumi.output_type
class ClassificationJobS3JobDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketCriteria":
            suggest = "bucket_criteria"
        elif key == "bucketDefinitions":
            suggest = "bucket_definitions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassificationJobS3JobDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassificationJobS3JobDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassificationJobS3JobDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_criteria: Optional['outputs.ClassificationJobS3JobDefinitionBucketCriteria'] = None,
                 bucket_definitions: Optional[Sequence['outputs.ClassificationJobS3JobDefinitionBucketDefinition']] = None,
                 scoping: Optional['outputs.ClassificationJobS3JobDefinitionScoping'] = None):
        """
        :param 'ClassificationJobS3JobDefinitionBucketCriteriaArgs' bucket_criteria: The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis. Conflicts with `bucket_definitions`. (documented below)
        :param Sequence['ClassificationJobS3JobDefinitionBucketDefinitionArgs'] bucket_definitions: An array of objects, one for each AWS account that owns buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for the account. Conflicts with `bucket_criteria`. (documented below)
        :param 'ClassificationJobS3JobDefinitionScopingArgs' scoping: The property- and tag-based conditions that determine which objects to include or exclude from the analysis. (documented below)
        """
        if bucket_criteria is not None:
            pulumi.set(__self__, "bucket_criteria", bucket_criteria)
        if bucket_definitions is not None:
            pulumi.set(__self__, "bucket_definitions", bucket_definitions)
        if scoping is not None:
            pulumi.set(__self__, "scoping", scoping)

    @property
    @pulumi.getter(name="bucketCriteria")
    def bucket_criteria(self) -> Optional['outputs.ClassificationJobS3JobDefinitionBucketCriteria']:
        """
        The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis. Conflicts with `bucket_definitions`. (documented below)
        """
        return pulumi.get(self, "bucket_criteria")

    @property
    @pulumi.getter(name="bucketDefinitions")
    def bucket_definitions(self) -> Optional[Sequence['outputs.ClassificationJobS3JobDefinitionBucketDefinition']]:
        """
        An array of objects, one for each AWS account that owns buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for the account. Conflicts with `bucket_criteria`. (documented below)
        """
        return pulumi.get(self, "bucket_definitions")

    @property
    @pulumi.getter
    def scoping(self) -> Optional['outputs.ClassificationJobS3JobDefinitionScoping']:
        """
        The property- and tag-based conditions that determine which objects to include or exclude from the analysis. (documented below)
        """
        return pulumi.get(self, "scoping")


@pulumi.output_type
class ClassificationJobS3JobDefinitionBucketCriteria(dict):
    def __init__(__self__, *,
                 excludes: Optional['outputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludes'] = None,
                 includes: Optional['outputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludes'] = None):
        """
        :param 'ClassificationJobS3JobDefinitionBucketCriteriaExcludesArgs' excludes: The property- or tag-based conditions that determine which S3 buckets to exclude from the analysis. (documented below)
        :param 'ClassificationJobS3JobDefinitionBucketCriteriaIncludesArgs' includes: The property- or tag-based conditions that determine which S3 buckets to include in the analysis. (documented below)
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional['outputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludes']:
        """
        The property- or tag-based conditions that determine which S3 buckets to exclude from the analysis. (documented below)
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional['outputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludes']:
        """
        The property- or tag-based conditions that determine which S3 buckets to include in the analysis. (documented below)
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class ClassificationJobS3JobDefinitionBucketCriteriaExcludes(dict):
    def __init__(__self__, *,
                 ands: Optional[Sequence['outputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludesAnd']] = None):
        """
        :param Sequence['ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndArgs'] ands: An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
        """
        if ands is not None:
            pulumi.set(__self__, "ands", ands)

    @property
    @pulumi.getter
    def ands(self) -> Optional[Sequence['outputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludesAnd']]:
        """
        An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
        """
        return pulumi.get(self, "ands")


@pulumi.output_type
class ClassificationJobS3JobDefinitionBucketCriteriaExcludesAnd(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "simpleCriterion":
            suggest = "simple_criterion"
        elif key == "tagCriterion":
            suggest = "tag_criterion"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassificationJobS3JobDefinitionBucketCriteriaExcludesAnd. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassificationJobS3JobDefinitionBucketCriteriaExcludesAnd.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassificationJobS3JobDefinitionBucketCriteriaExcludesAnd.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 simple_criterion: Optional['outputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndSimpleCriterion'] = None,
                 tag_criterion: Optional['outputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterion'] = None):
        """
        :param 'ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndSimpleCriterionArgs' simple_criterion: A property-based condition that defines a property, operator, and one or more values for including or excluding an S3 buckets from the job. (documented below)
        :param 'ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionArgs' tag_criterion: A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an S3 buckets from the job. (documented below)
        """
        if simple_criterion is not None:
            pulumi.set(__self__, "simple_criterion", simple_criterion)
        if tag_criterion is not None:
            pulumi.set(__self__, "tag_criterion", tag_criterion)

    @property
    @pulumi.getter(name="simpleCriterion")
    def simple_criterion(self) -> Optional['outputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndSimpleCriterion']:
        """
        A property-based condition that defines a property, operator, and one or more values for including or excluding an S3 buckets from the job. (documented below)
        """
        return pulumi.get(self, "simple_criterion")

    @property
    @pulumi.getter(name="tagCriterion")
    def tag_criterion(self) -> Optional['outputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterion']:
        """
        A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an S3 buckets from the job. (documented below)
        """
        return pulumi.get(self, "tag_criterion")


@pulumi.output_type
class ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndSimpleCriterion(dict):
    def __init__(__self__, *,
                 comparator: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str comparator: The operator to use in a condition. Valid combination of values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-jobcomparator)
        :param builtins.str key: The object property to use in the condition. Valid combination of values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-simplecriterionkeyforjob)
        :param Sequence[builtins.str] values: An array that lists the values to use in the condition. Valid combination of values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-simplecriterionforjob)
        """
        if comparator is not None:
            pulumi.set(__self__, "comparator", comparator)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def comparator(self) -> Optional[builtins.str]:
        """
        The operator to use in a condition. Valid combination of values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-jobcomparator)
        """
        return pulumi.get(self, "comparator")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The object property to use in the condition. Valid combination of values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-simplecriterionkeyforjob)
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        An array that lists the values to use in the condition. Valid combination of values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-simplecriterionforjob)
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagValues":
            suggest = "tag_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comparator: Optional[builtins.str] = None,
                 tag_values: Optional[Sequence['outputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValue']] = None):
        """
        :param builtins.str comparator: The operator to use in the condition. Valid combination and values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-jobcomparator)
        :param Sequence['ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValueArgs'] tag_values: The  tag key and value pairs to use in the condition. One or more blocks are allowed. (documented below)
        """
        if comparator is not None:
            pulumi.set(__self__, "comparator", comparator)
        if tag_values is not None:
            pulumi.set(__self__, "tag_values", tag_values)

    @property
    @pulumi.getter
    def comparator(self) -> Optional[builtins.str]:
        """
        The operator to use in the condition. Valid combination and values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-jobcomparator)
        """
        return pulumi.get(self, "comparator")

    @property
    @pulumi.getter(name="tagValues")
    def tag_values(self) -> Optional[Sequence['outputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValue']]:
        """
        The  tag key and value pairs to use in the condition. One or more blocks are allowed. (documented below)
        """
        return pulumi.get(self, "tag_values")


@pulumi.output_type
class ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionTagValue(dict):
    def __init__(__self__, *,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str key: The tag key.
        :param builtins.str value: The tag value.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The tag value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ClassificationJobS3JobDefinitionBucketCriteriaIncludes(dict):
    def __init__(__self__, *,
                 ands: Optional[Sequence['outputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesAnd']] = None):
        """
        :param Sequence['ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgs'] ands: An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
        """
        if ands is not None:
            pulumi.set(__self__, "ands", ands)

    @property
    @pulumi.getter
    def ands(self) -> Optional[Sequence['outputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesAnd']]:
        """
        An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
        """
        return pulumi.get(self, "ands")


@pulumi.output_type
class ClassificationJobS3JobDefinitionBucketCriteriaIncludesAnd(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "simpleCriterion":
            suggest = "simple_criterion"
        elif key == "tagCriterion":
            suggest = "tag_criterion"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassificationJobS3JobDefinitionBucketCriteriaIncludesAnd. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassificationJobS3JobDefinitionBucketCriteriaIncludesAnd.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassificationJobS3JobDefinitionBucketCriteriaIncludesAnd.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 simple_criterion: Optional['outputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndSimpleCriterion'] = None,
                 tag_criterion: Optional['outputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterion'] = None):
        """
        :param 'ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndSimpleCriterionArgs' simple_criterion: A property-based condition that defines a property, operator, and one or more values for including or excluding an S3 buckets from the job. (documented below)
        :param 'ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterionArgs' tag_criterion: A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an S3 buckets from the job. (documented below)
        """
        if simple_criterion is not None:
            pulumi.set(__self__, "simple_criterion", simple_criterion)
        if tag_criterion is not None:
            pulumi.set(__self__, "tag_criterion", tag_criterion)

    @property
    @pulumi.getter(name="simpleCriterion")
    def simple_criterion(self) -> Optional['outputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndSimpleCriterion']:
        """
        A property-based condition that defines a property, operator, and one or more values for including or excluding an S3 buckets from the job. (documented below)
        """
        return pulumi.get(self, "simple_criterion")

    @property
    @pulumi.getter(name="tagCriterion")
    def tag_criterion(self) -> Optional['outputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterion']:
        """
        A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an S3 buckets from the job. (documented below)
        """
        return pulumi.get(self, "tag_criterion")


@pulumi.output_type
class ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndSimpleCriterion(dict):
    def __init__(__self__, *,
                 comparator: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str comparator: The operator to use in a condition. Valid combination of values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-jobcomparator)
        :param builtins.str key: The object property to use in the condition. Valid combination of values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-simplecriterionkeyforjob)
        :param Sequence[builtins.str] values: An array that lists the values to use in the condition. Valid combination of values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-simplecriterionforjob)
        """
        if comparator is not None:
            pulumi.set(__self__, "comparator", comparator)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def comparator(self) -> Optional[builtins.str]:
        """
        The operator to use in a condition. Valid combination of values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-jobcomparator)
        """
        return pulumi.get(self, "comparator")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The object property to use in the condition. Valid combination of values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-simplecriterionkeyforjob)
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        An array that lists the values to use in the condition. Valid combination of values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-simplecriterionforjob)
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagValues":
            suggest = "tag_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comparator: Optional[builtins.str] = None,
                 tag_values: Optional[Sequence['outputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterionTagValue']] = None):
        """
        :param builtins.str comparator: The operator to use in the condition. Valid combination and values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-jobcomparator)
        :param Sequence['ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterionTagValueArgs'] tag_values: The  tag key and value pairs to use in the condition. One or more blocks are allowed. (documented below)
        """
        if comparator is not None:
            pulumi.set(__self__, "comparator", comparator)
        if tag_values is not None:
            pulumi.set(__self__, "tag_values", tag_values)

    @property
    @pulumi.getter
    def comparator(self) -> Optional[builtins.str]:
        """
        The operator to use in the condition. Valid combination and values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-jobcomparator)
        """
        return pulumi.get(self, "comparator")

    @property
    @pulumi.getter(name="tagValues")
    def tag_values(self) -> Optional[Sequence['outputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterionTagValue']]:
        """
        The  tag key and value pairs to use in the condition. One or more blocks are allowed. (documented below)
        """
        return pulumi.get(self, "tag_values")


@pulumi.output_type
class ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterionTagValue(dict):
    def __init__(__self__, *,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str key: The tag key.
        :param builtins.str value: The tag value.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The tag value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ClassificationJobS3JobDefinitionBucketDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassificationJobS3JobDefinitionBucketDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassificationJobS3JobDefinitionBucketDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassificationJobS3JobDefinitionBucketDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: builtins.str,
                 buckets: Sequence[builtins.str]):
        """
        :param builtins.str account_id: The unique identifier for the AWS account that owns the buckets.
        :param Sequence[builtins.str] buckets: An array that lists the names of the buckets.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "buckets", buckets)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        The unique identifier for the AWS account that owns the buckets.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def buckets(self) -> Sequence[builtins.str]:
        """
        An array that lists the names of the buckets.
        """
        return pulumi.get(self, "buckets")


@pulumi.output_type
class ClassificationJobS3JobDefinitionScoping(dict):
    def __init__(__self__, *,
                 excludes: Optional['outputs.ClassificationJobS3JobDefinitionScopingExcludes'] = None,
                 includes: Optional['outputs.ClassificationJobS3JobDefinitionScopingIncludes'] = None):
        """
        :param 'ClassificationJobS3JobDefinitionScopingExcludesArgs' excludes: The property- or tag-based conditions that determine which objects to exclude from the analysis. (documented below)
        :param 'ClassificationJobS3JobDefinitionScopingIncludesArgs' includes: The property- or tag-based conditions that determine which objects to include in the analysis. (documented below)
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional['outputs.ClassificationJobS3JobDefinitionScopingExcludes']:
        """
        The property- or tag-based conditions that determine which objects to exclude from the analysis. (documented below)
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional['outputs.ClassificationJobS3JobDefinitionScopingIncludes']:
        """
        The property- or tag-based conditions that determine which objects to include in the analysis. (documented below)
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class ClassificationJobS3JobDefinitionScopingExcludes(dict):
    def __init__(__self__, *,
                 ands: Optional[Sequence['outputs.ClassificationJobS3JobDefinitionScopingExcludesAnd']] = None):
        """
        :param Sequence['ClassificationJobS3JobDefinitionScopingExcludesAndArgs'] ands: An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
        """
        if ands is not None:
            pulumi.set(__self__, "ands", ands)

    @property
    @pulumi.getter
    def ands(self) -> Optional[Sequence['outputs.ClassificationJobS3JobDefinitionScopingExcludesAnd']]:
        """
        An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
        """
        return pulumi.get(self, "ands")


@pulumi.output_type
class ClassificationJobS3JobDefinitionScopingExcludesAnd(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "simpleScopeTerm":
            suggest = "simple_scope_term"
        elif key == "tagScopeTerm":
            suggest = "tag_scope_term"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassificationJobS3JobDefinitionScopingExcludesAnd. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassificationJobS3JobDefinitionScopingExcludesAnd.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassificationJobS3JobDefinitionScopingExcludesAnd.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 simple_scope_term: Optional['outputs.ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTerm'] = None,
                 tag_scope_term: Optional['outputs.ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTerm'] = None):
        """
        :param 'ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTermArgs' simple_scope_term: A property-based condition that defines a property, operator, and one or more values for including or excluding an object from the job. (documented below)
        :param 'ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermArgs' tag_scope_term: A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an object from the job. (documented below)
        """
        if simple_scope_term is not None:
            pulumi.set(__self__, "simple_scope_term", simple_scope_term)
        if tag_scope_term is not None:
            pulumi.set(__self__, "tag_scope_term", tag_scope_term)

    @property
    @pulumi.getter(name="simpleScopeTerm")
    def simple_scope_term(self) -> Optional['outputs.ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTerm']:
        """
        A property-based condition that defines a property, operator, and one or more values for including or excluding an object from the job. (documented below)
        """
        return pulumi.get(self, "simple_scope_term")

    @property
    @pulumi.getter(name="tagScopeTerm")
    def tag_scope_term(self) -> Optional['outputs.ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTerm']:
        """
        A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an object from the job. (documented below)
        """
        return pulumi.get(self, "tag_scope_term")


@pulumi.output_type
class ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTerm(dict):
    def __init__(__self__, *,
                 comparator: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str comparator: The operator to use in a condition. Valid values are: `EQ`, `GT`, `GTE`, `LT`, `LTE`, `NE`, `CONTAINS`, `STARTS_WITH`
        :param builtins.str key: The object property to use in the condition.
        :param Sequence[builtins.str] values: An array that lists the values to use in the condition.
        """
        if comparator is not None:
            pulumi.set(__self__, "comparator", comparator)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def comparator(self) -> Optional[builtins.str]:
        """
        The operator to use in a condition. Valid values are: `EQ`, `GT`, `GTE`, `LT`, `LTE`, `NE`, `CONTAINS`, `STARTS_WITH`
        """
        return pulumi.get(self, "comparator")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The object property to use in the condition.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        An array that lists the values to use in the condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTerm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagValues":
            suggest = "tag_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTerm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTerm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTerm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comparator: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 tag_values: Optional[Sequence['outputs.ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValue']] = None,
                 target: Optional[builtins.str] = None):
        """
        :param builtins.str comparator: The operator to use in the condition.
        :param builtins.str key: The tag key to use in the condition. The only valid value is `TAG`.
        :param Sequence['ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValueArgs'] tag_values: The tag keys or tag key and value pairs to use in the condition.
        :param builtins.str target: The type of object to apply the condition to. The only valid value is `S3_OBJECT`.
        """
        if comparator is not None:
            pulumi.set(__self__, "comparator", comparator)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if tag_values is not None:
            pulumi.set(__self__, "tag_values", tag_values)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def comparator(self) -> Optional[builtins.str]:
        """
        The operator to use in the condition.
        """
        return pulumi.get(self, "comparator")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The tag key to use in the condition. The only valid value is `TAG`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="tagValues")
    def tag_values(self) -> Optional[Sequence['outputs.ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValue']]:
        """
        The tag keys or tag key and value pairs to use in the condition.
        """
        return pulumi.get(self, "tag_values")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.str]:
        """
        The type of object to apply the condition to. The only valid value is `S3_OBJECT`.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValue(dict):
    def __init__(__self__, *,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str key: The tag key.
        :param builtins.str value: The tag value.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The tag value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ClassificationJobS3JobDefinitionScopingIncludes(dict):
    def __init__(__self__, *,
                 ands: Optional[Sequence['outputs.ClassificationJobS3JobDefinitionScopingIncludesAnd']] = None):
        """
        :param Sequence['ClassificationJobS3JobDefinitionScopingIncludesAndArgs'] ands: An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
        """
        if ands is not None:
            pulumi.set(__self__, "ands", ands)

    @property
    @pulumi.getter
    def ands(self) -> Optional[Sequence['outputs.ClassificationJobS3JobDefinitionScopingIncludesAnd']]:
        """
        An array of conditions, one for each condition that determines which objects to include or exclude from the job. (documented below)
        """
        return pulumi.get(self, "ands")


@pulumi.output_type
class ClassificationJobS3JobDefinitionScopingIncludesAnd(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "simpleScopeTerm":
            suggest = "simple_scope_term"
        elif key == "tagScopeTerm":
            suggest = "tag_scope_term"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassificationJobS3JobDefinitionScopingIncludesAnd. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassificationJobS3JobDefinitionScopingIncludesAnd.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassificationJobS3JobDefinitionScopingIncludesAnd.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 simple_scope_term: Optional['outputs.ClassificationJobS3JobDefinitionScopingIncludesAndSimpleScopeTerm'] = None,
                 tag_scope_term: Optional['outputs.ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTerm'] = None):
        """
        :param 'ClassificationJobS3JobDefinitionScopingIncludesAndSimpleScopeTermArgs' simple_scope_term: A property-based condition that defines a property, operator, and one or more values for including or excluding an object from the job. (documented below)
        :param 'ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermArgs' tag_scope_term: A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an object from the job. (documented below)
        """
        if simple_scope_term is not None:
            pulumi.set(__self__, "simple_scope_term", simple_scope_term)
        if tag_scope_term is not None:
            pulumi.set(__self__, "tag_scope_term", tag_scope_term)

    @property
    @pulumi.getter(name="simpleScopeTerm")
    def simple_scope_term(self) -> Optional['outputs.ClassificationJobS3JobDefinitionScopingIncludesAndSimpleScopeTerm']:
        """
        A property-based condition that defines a property, operator, and one or more values for including or excluding an object from the job. (documented below)
        """
        return pulumi.get(self, "simple_scope_term")

    @property
    @pulumi.getter(name="tagScopeTerm")
    def tag_scope_term(self) -> Optional['outputs.ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTerm']:
        """
        A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an object from the job. (documented below)
        """
        return pulumi.get(self, "tag_scope_term")


@pulumi.output_type
class ClassificationJobS3JobDefinitionScopingIncludesAndSimpleScopeTerm(dict):
    def __init__(__self__, *,
                 comparator: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str comparator: The operator to use in a condition. Valid values are: `EQ`, `GT`, `GTE`, `LT`, `LTE`, `NE`, `CONTAINS`, `STARTS_WITH`
        :param builtins.str key: The object property to use in the condition.
        :param Sequence[builtins.str] values: An array that lists the values to use in the condition.
        """
        if comparator is not None:
            pulumi.set(__self__, "comparator", comparator)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def comparator(self) -> Optional[builtins.str]:
        """
        The operator to use in a condition. Valid values are: `EQ`, `GT`, `GTE`, `LT`, `LTE`, `NE`, `CONTAINS`, `STARTS_WITH`
        """
        return pulumi.get(self, "comparator")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The object property to use in the condition.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        An array that lists the values to use in the condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTerm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagValues":
            suggest = "tag_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTerm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTerm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTerm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comparator: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 tag_values: Optional[Sequence['outputs.ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValue']] = None,
                 target: Optional[builtins.str] = None):
        """
        :param builtins.str comparator: The operator to use in the condition.
        :param builtins.str key: The tag key to use in the condition. The only valid value is `TAG`.
        :param Sequence['ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValueArgs'] tag_values: The tag keys or tag key and value pairs to use in the condition.
        :param builtins.str target: The type of object to apply the condition to. The only valid value is `S3_OBJECT`.
        """
        if comparator is not None:
            pulumi.set(__self__, "comparator", comparator)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if tag_values is not None:
            pulumi.set(__self__, "tag_values", tag_values)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def comparator(self) -> Optional[builtins.str]:
        """
        The operator to use in the condition.
        """
        return pulumi.get(self, "comparator")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The tag key to use in the condition. The only valid value is `TAG`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="tagValues")
    def tag_values(self) -> Optional[Sequence['outputs.ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValue']]:
        """
        The tag keys or tag key and value pairs to use in the condition.
        """
        return pulumi.get(self, "tag_values")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.str]:
        """
        The type of object to apply the condition to. The only valid value is `S3_OBJECT`.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ClassificationJobS3JobDefinitionScopingIncludesAndTagScopeTermTagValue(dict):
    def __init__(__self__, *,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str key: The tag key.
        :param builtins.str value: The tag value.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The tag value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ClassificationJobScheduleFrequency(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dailySchedule":
            suggest = "daily_schedule"
        elif key == "monthlySchedule":
            suggest = "monthly_schedule"
        elif key == "weeklySchedule":
            suggest = "weekly_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassificationJobScheduleFrequency. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassificationJobScheduleFrequency.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassificationJobScheduleFrequency.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 daily_schedule: Optional[builtins.bool] = None,
                 monthly_schedule: Optional[builtins.int] = None,
                 weekly_schedule: Optional[builtins.str] = None):
        """
        :param builtins.bool daily_schedule: Specifies a daily recurrence pattern for running the job.
        :param builtins.int monthly_schedule: Specifies a monthly recurrence pattern for running the job.
        :param builtins.str weekly_schedule: Specifies a weekly recurrence pattern for running the job.
        """
        if daily_schedule is not None:
            pulumi.set(__self__, "daily_schedule", daily_schedule)
        if monthly_schedule is not None:
            pulumi.set(__self__, "monthly_schedule", monthly_schedule)
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)

    @property
    @pulumi.getter(name="dailySchedule")
    def daily_schedule(self) -> Optional[builtins.bool]:
        """
        Specifies a daily recurrence pattern for running the job.
        """
        return pulumi.get(self, "daily_schedule")

    @property
    @pulumi.getter(name="monthlySchedule")
    def monthly_schedule(self) -> Optional[builtins.int]:
        """
        Specifies a monthly recurrence pattern for running the job.
        """
        return pulumi.get(self, "monthly_schedule")

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional[builtins.str]:
        """
        Specifies a weekly recurrence pattern for running the job.
        """
        return pulumi.get(self, "weekly_schedule")


@pulumi.output_type
class ClassificationJobUserPausedDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobExpiresAt":
            suggest = "job_expires_at"
        elif key == "jobImminentExpirationHealthEventArn":
            suggest = "job_imminent_expiration_health_event_arn"
        elif key == "jobPausedAt":
            suggest = "job_paused_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClassificationJobUserPausedDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClassificationJobUserPausedDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClassificationJobUserPausedDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_expires_at: Optional[builtins.str] = None,
                 job_imminent_expiration_health_event_arn: Optional[builtins.str] = None,
                 job_paused_at: Optional[builtins.str] = None):
        if job_expires_at is not None:
            pulumi.set(__self__, "job_expires_at", job_expires_at)
        if job_imminent_expiration_health_event_arn is not None:
            pulumi.set(__self__, "job_imminent_expiration_health_event_arn", job_imminent_expiration_health_event_arn)
        if job_paused_at is not None:
            pulumi.set(__self__, "job_paused_at", job_paused_at)

    @property
    @pulumi.getter(name="jobExpiresAt")
    def job_expires_at(self) -> Optional[builtins.str]:
        return pulumi.get(self, "job_expires_at")

    @property
    @pulumi.getter(name="jobImminentExpirationHealthEventArn")
    def job_imminent_expiration_health_event_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "job_imminent_expiration_health_event_arn")

    @property
    @pulumi.getter(name="jobPausedAt")
    def job_paused_at(self) -> Optional[builtins.str]:
        return pulumi.get(self, "job_paused_at")


