# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterClusterEndpoint',
    'ClusterShard',
    'ClusterShardNode',
    'ClusterShardNodeEndpoint',
    'MultiRegionClusterTimeouts',
    'ParameterGroupParameter',
    'SnapshotClusterConfiguration',
    'UserAuthenticationMode',
    'GetClusterClusterEndpointResult',
    'GetClusterShardResult',
    'GetClusterShardNodeResult',
    'GetClusterShardNodeEndpointResult',
    'GetParameterGroupParameterResult',
    'GetSnapshotClusterConfigurationResult',
    'GetUserAuthenticationModeResult',
]

@pulumi.output_type
class ClusterClusterEndpoint(dict):
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None):
        """
        :param builtins.str address: DNS hostname of the node.
        :param builtins.int port: The port number on which each of the nodes accepts connections. Defaults to `6379`.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        DNS hostname of the node.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port number on which each of the nodes accepts connections. Defaults to `6379`.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ClusterShard(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numNodes":
            suggest = "num_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterShard. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterShard.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterShard.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 nodes: Optional[Sequence['outputs.ClusterShardNode']] = None,
                 num_nodes: Optional[builtins.int] = None,
                 slots: Optional[builtins.str] = None):
        """
        :param builtins.str name: Name of the cluster. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        :param Sequence['ClusterShardNodeArgs'] nodes: Set of nodes in this shard.
        :param builtins.int num_nodes: Number of individual nodes in this shard.
        :param builtins.str slots: Keyspace for this shard. Example: `0-16383`.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if num_nodes is not None:
            pulumi.set(__self__, "num_nodes", num_nodes)
        if slots is not None:
            pulumi.set(__self__, "slots", slots)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the cluster. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nodes(self) -> Optional[Sequence['outputs.ClusterShardNode']]:
        """
        Set of nodes in this shard.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="numNodes")
    def num_nodes(self) -> Optional[builtins.int]:
        """
        Number of individual nodes in this shard.
        """
        return pulumi.get(self, "num_nodes")

    @property
    @pulumi.getter
    def slots(self) -> Optional[builtins.str]:
        """
        Keyspace for this shard. Example: `0-16383`.
        """
        return pulumi.get(self, "slots")


@pulumi.output_type
class ClusterShardNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "createTime":
            suggest = "create_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterShardNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterShardNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterShardNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[builtins.str] = None,
                 create_time: Optional[builtins.str] = None,
                 endpoints: Optional[Sequence['outputs.ClusterShardNodeEndpoint']] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str availability_zone: The Availability Zone in which the node resides.
        :param builtins.str create_time: The date and time when the node was created. Example: `2022-01-01T21:00:00Z`.
        :param builtins.str name: Name of the cluster. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[builtins.str]:
        """
        The Availability Zone in which the node resides.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[builtins.str]:
        """
        The date and time when the node was created. Example: `2022-01-01T21:00:00Z`.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence['outputs.ClusterShardNodeEndpoint']]:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the cluster. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ClusterShardNodeEndpoint(dict):
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None):
        """
        :param builtins.str address: DNS hostname of the node.
        :param builtins.int port: The port number on which each of the nodes accepts connections. Defaults to `6379`.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        DNS hostname of the node.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port number on which each of the nodes accepts connections. Defaults to `6379`.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class MultiRegionClusterTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None,
                 update: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class ParameterGroupParameter(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: The name of the parameter.
        :param builtins.str value: The value of the parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SnapshotClusterConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "engineVersion":
            suggest = "engine_version"
        elif key == "maintenanceWindow":
            suggest = "maintenance_window"
        elif key == "nodeType":
            suggest = "node_type"
        elif key == "numShards":
            suggest = "num_shards"
        elif key == "parameterGroupName":
            suggest = "parameter_group_name"
        elif key == "snapshotRetentionLimit":
            suggest = "snapshot_retention_limit"
        elif key == "snapshotWindow":
            suggest = "snapshot_window"
        elif key == "subnetGroupName":
            suggest = "subnet_group_name"
        elif key == "topicArn":
            suggest = "topic_arn"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotClusterConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotClusterConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotClusterConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[builtins.str] = None,
                 engine: Optional[builtins.str] = None,
                 engine_version: Optional[builtins.str] = None,
                 maintenance_window: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 node_type: Optional[builtins.str] = None,
                 num_shards: Optional[builtins.int] = None,
                 parameter_group_name: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 snapshot_retention_limit: Optional[builtins.int] = None,
                 snapshot_window: Optional[builtins.str] = None,
                 subnet_group_name: Optional[builtins.str] = None,
                 topic_arn: Optional[builtins.str] = None,
                 vpc_id: Optional[builtins.str] = None):
        """
        :param builtins.str description: Description for the cluster.
        :param builtins.str engine: The engine that will run on cluster nodes.
        :param builtins.str engine_version: Version number of the engine used by the cluster.
        :param builtins.str maintenance_window: The weekly time range during which maintenance on the cluster is performed.
        :param builtins.str name: Name of the snapshot. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        :param builtins.str node_type: Compute and memory capacity of the nodes in the cluster.
        :param builtins.int num_shards: Number of shards in the cluster.
        :param builtins.str parameter_group_name: Name of the parameter group associated with the cluster.
        :param builtins.int port: Port number on which the cluster accepts connections.
        :param builtins.int snapshot_retention_limit: Number of days for which MemoryDB retains automatic snapshots before deleting them.
        :param builtins.str snapshot_window: The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of the shard.
        :param builtins.str subnet_group_name: Name of the subnet group used by the cluster.
        :param builtins.str topic_arn: ARN of the SNS topic to which cluster notifications are sent.
        :param builtins.str vpc_id: The VPC in which the cluster exists.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if num_shards is not None:
            pulumi.set(__self__, "num_shards", num_shards)
        if parameter_group_name is not None:
            pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if snapshot_retention_limit is not None:
            pulumi.set(__self__, "snapshot_retention_limit", snapshot_retention_limit)
        if snapshot_window is not None:
            pulumi.set(__self__, "snapshot_window", snapshot_window)
        if subnet_group_name is not None:
            pulumi.set(__self__, "subnet_group_name", subnet_group_name)
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Description for the cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def engine(self) -> Optional[builtins.str]:
        """
        The engine that will run on cluster nodes.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[builtins.str]:
        """
        Version number of the engine used by the cluster.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[builtins.str]:
        """
        The weekly time range during which maintenance on the cluster is performed.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the snapshot. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[builtins.str]:
        """
        Compute and memory capacity of the nodes in the cluster.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> Optional[builtins.int]:
        """
        Number of shards in the cluster.
        """
        return pulumi.get(self, "num_shards")

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> Optional[builtins.str]:
        """
        Name of the parameter group associated with the cluster.
        """
        return pulumi.get(self, "parameter_group_name")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        Port number on which the cluster accepts connections.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> Optional[builtins.int]:
        """
        Number of days for which MemoryDB retains automatic snapshots before deleting them.
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> Optional[builtins.str]:
        """
        The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of the shard.
        """
        return pulumi.get(self, "snapshot_window")

    @property
    @pulumi.getter(name="subnetGroupName")
    def subnet_group_name(self) -> Optional[builtins.str]:
        """
        Name of the subnet group used by the cluster.
        """
        return pulumi.get(self, "subnet_group_name")

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[builtins.str]:
        """
        ARN of the SNS topic to which cluster notifications are sent.
        """
        return pulumi.get(self, "topic_arn")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[builtins.str]:
        """
        The VPC in which the cluster exists.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class UserAuthenticationMode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordCount":
            suggest = "password_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAuthenticationMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAuthenticationMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAuthenticationMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 password_count: Optional[builtins.int] = None,
                 passwords: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str type: Specifies the authentication type. Valid values are: `password` or `iam`.
        :param builtins.int password_count: Number of passwords belonging to the user if `type` is set to `password`.
        :param Sequence[builtins.str] passwords: Set of passwords used for authentication if `type` is set to `password`. You can create up to two passwords for each user.
        """
        pulumi.set(__self__, "type", type)
        if password_count is not None:
            pulumi.set(__self__, "password_count", password_count)
        if passwords is not None:
            pulumi.set(__self__, "passwords", passwords)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the authentication type. Valid values are: `password` or `iam`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="passwordCount")
    def password_count(self) -> Optional[builtins.int]:
        """
        Number of passwords belonging to the user if `type` is set to `password`.
        """
        return pulumi.get(self, "password_count")

    @property
    @pulumi.getter
    def passwords(self) -> Optional[Sequence[builtins.str]]:
        """
        Set of passwords used for authentication if `type` is set to `password`. You can create up to two passwords for each user.
        """
        return pulumi.get(self, "passwords")


@pulumi.output_type
class GetClusterClusterEndpointResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 port: builtins.int):
        """
        :param builtins.str address: DNS hostname of the node.
        :param builtins.int port: Port number that this node is listening on.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        DNS hostname of the node.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        Port number that this node is listening on.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetClusterShardResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 nodes: Sequence['outputs.GetClusterShardNodeResult'],
                 num_nodes: builtins.int,
                 slots: builtins.str):
        """
        :param builtins.str name: Name of the cluster.
        :param Sequence['GetClusterShardNodeArgs'] nodes: Set of nodes in this shard.
        :param builtins.int num_nodes: Number of individual nodes in this shard.
        :param builtins.str slots: Keyspace for this shard. Example: `0-16383`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "num_nodes", num_nodes)
        pulumi.set(__self__, "slots", slots)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetClusterShardNodeResult']:
        """
        Set of nodes in this shard.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="numNodes")
    def num_nodes(self) -> builtins.int:
        """
        Number of individual nodes in this shard.
        """
        return pulumi.get(self, "num_nodes")

    @property
    @pulumi.getter
    def slots(self) -> builtins.str:
        """
        Keyspace for this shard. Example: `0-16383`.
        """
        return pulumi.get(self, "slots")


@pulumi.output_type
class GetClusterShardNodeResult(dict):
    def __init__(__self__, *,
                 availability_zone: builtins.str,
                 create_time: builtins.str,
                 endpoints: Sequence['outputs.GetClusterShardNodeEndpointResult'],
                 name: builtins.str):
        """
        :param builtins.str availability_zone: The Availability Zone in which the node resides.
        :param builtins.str create_time: The date and time when the node was created. Example: `2022-01-01T21:00:00Z`.
        :param builtins.str name: Name of the cluster.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> builtins.str:
        """
        The Availability Zone in which the node resides.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> builtins.str:
        """
        The date and time when the node was created. Example: `2022-01-01T21:00:00Z`.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetClusterShardNodeEndpointResult']:
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the cluster.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetClusterShardNodeEndpointResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 port: builtins.int):
        """
        :param builtins.str address: DNS hostname of the node.
        :param builtins.int port: Port number that this node is listening on.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        DNS hostname of the node.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        Port number that this node is listening on.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetParameterGroupParameterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Name of the parameter group.
        :param builtins.str value: Value of the parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the parameter group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of the parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetSnapshotClusterConfigurationResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 engine: builtins.str,
                 engine_version: builtins.str,
                 maintenance_window: builtins.str,
                 name: builtins.str,
                 node_type: builtins.str,
                 num_shards: builtins.int,
                 parameter_group_name: builtins.str,
                 port: builtins.int,
                 snapshot_retention_limit: builtins.int,
                 snapshot_window: builtins.str,
                 subnet_group_name: builtins.str,
                 topic_arn: builtins.str,
                 vpc_id: builtins.str):
        """
        :param builtins.str description: Description for the cluster.
        :param builtins.str engine: The engine that will run on cluster nodes.
        :param builtins.str engine_version: Version number of the engine used by the cluster.
        :param builtins.str maintenance_window: The weekly time range during which maintenance on the cluster is performed.
        :param builtins.str name: Name of the snapshot.
        :param builtins.str node_type: Compute and memory capacity of the nodes in the cluster.
        :param builtins.int num_shards: Number of shards in the cluster.
        :param builtins.str parameter_group_name: Name of the parameter group associated with the cluster.
        :param builtins.int port: Port number on which the cluster accepts connections.
        :param builtins.int snapshot_retention_limit: Number of days for which MemoryDB retains automatic snapshots before deleting them.
        :param builtins.str snapshot_window: The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of the shard.
        :param builtins.str subnet_group_name: Name of the subnet group used by the cluster.
        :param builtins.str topic_arn: ARN of the SNS topic to which cluster notifications are sent.
        :param builtins.str vpc_id: The VPC in which the cluster exists.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "maintenance_window", maintenance_window)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "num_shards", num_shards)
        pulumi.set(__self__, "parameter_group_name", parameter_group_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "snapshot_retention_limit", snapshot_retention_limit)
        pulumi.set(__self__, "snapshot_window", snapshot_window)
        pulumi.set(__self__, "subnet_group_name", subnet_group_name)
        pulumi.set(__self__, "topic_arn", topic_arn)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description for the cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def engine(self) -> builtins.str:
        """
        The engine that will run on cluster nodes.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> builtins.str:
        """
        Version number of the engine used by the cluster.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> builtins.str:
        """
        The weekly time range during which maintenance on the cluster is performed.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the snapshot.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> builtins.str:
        """
        Compute and memory capacity of the nodes in the cluster.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> builtins.int:
        """
        Number of shards in the cluster.
        """
        return pulumi.get(self, "num_shards")

    @property
    @pulumi.getter(name="parameterGroupName")
    def parameter_group_name(self) -> builtins.str:
        """
        Name of the parameter group associated with the cluster.
        """
        return pulumi.get(self, "parameter_group_name")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        Port number on which the cluster accepts connections.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> builtins.int:
        """
        Number of days for which MemoryDB retains automatic snapshots before deleting them.
        """
        return pulumi.get(self, "snapshot_retention_limit")

    @property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> builtins.str:
        """
        The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of the shard.
        """
        return pulumi.get(self, "snapshot_window")

    @property
    @pulumi.getter(name="subnetGroupName")
    def subnet_group_name(self) -> builtins.str:
        """
        Name of the subnet group used by the cluster.
        """
        return pulumi.get(self, "subnet_group_name")

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> builtins.str:
        """
        ARN of the SNS topic to which cluster notifications are sent.
        """
        return pulumi.get(self, "topic_arn")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> builtins.str:
        """
        The VPC in which the cluster exists.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetUserAuthenticationModeResult(dict):
    def __init__(__self__, *,
                 password_count: builtins.int,
                 type: builtins.str):
        """
        :param builtins.int password_count: Number of passwords belonging to the user if `type` is set to `password`.
        :param builtins.str type: Type of authentication configured.
        """
        pulumi.set(__self__, "password_count", password_count)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="passwordCount")
    def password_count(self) -> builtins.int:
        """
        Number of passwords belonging to the user if `type` is set to `password`.
        """
        return pulumi.get(self, "password_count")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of authentication configured.
        """
        return pulumi.get(self, "type")


