# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBootstrapBrokersResult',
    'AwaitableGetBootstrapBrokersResult',
    'get_bootstrap_brokers',
    'get_bootstrap_brokers_output',
]

@pulumi.output_type
class GetBootstrapBrokersResult:
    """
    A collection of values returned by getBootstrapBrokers.
    """
    def __init__(__self__, bootstrap_brokers=None, bootstrap_brokers_public_sasl_iam=None, bootstrap_brokers_public_sasl_scram=None, bootstrap_brokers_public_tls=None, bootstrap_brokers_sasl_iam=None, bootstrap_brokers_sasl_scram=None, bootstrap_brokers_tls=None, bootstrap_brokers_vpc_connectivity_sasl_iam=None, bootstrap_brokers_vpc_connectivity_sasl_scram=None, bootstrap_brokers_vpc_connectivity_tls=None, cluster_arn=None, id=None, region=None):
        if bootstrap_brokers and not isinstance(bootstrap_brokers, str):
            raise TypeError("Expected argument 'bootstrap_brokers' to be a str")
        pulumi.set(__self__, "bootstrap_brokers", bootstrap_brokers)
        if bootstrap_brokers_public_sasl_iam and not isinstance(bootstrap_brokers_public_sasl_iam, str):
            raise TypeError("Expected argument 'bootstrap_brokers_public_sasl_iam' to be a str")
        pulumi.set(__self__, "bootstrap_brokers_public_sasl_iam", bootstrap_brokers_public_sasl_iam)
        if bootstrap_brokers_public_sasl_scram and not isinstance(bootstrap_brokers_public_sasl_scram, str):
            raise TypeError("Expected argument 'bootstrap_brokers_public_sasl_scram' to be a str")
        pulumi.set(__self__, "bootstrap_brokers_public_sasl_scram", bootstrap_brokers_public_sasl_scram)
        if bootstrap_brokers_public_tls and not isinstance(bootstrap_brokers_public_tls, str):
            raise TypeError("Expected argument 'bootstrap_brokers_public_tls' to be a str")
        pulumi.set(__self__, "bootstrap_brokers_public_tls", bootstrap_brokers_public_tls)
        if bootstrap_brokers_sasl_iam and not isinstance(bootstrap_brokers_sasl_iam, str):
            raise TypeError("Expected argument 'bootstrap_brokers_sasl_iam' to be a str")
        pulumi.set(__self__, "bootstrap_brokers_sasl_iam", bootstrap_brokers_sasl_iam)
        if bootstrap_brokers_sasl_scram and not isinstance(bootstrap_brokers_sasl_scram, str):
            raise TypeError("Expected argument 'bootstrap_brokers_sasl_scram' to be a str")
        pulumi.set(__self__, "bootstrap_brokers_sasl_scram", bootstrap_brokers_sasl_scram)
        if bootstrap_brokers_tls and not isinstance(bootstrap_brokers_tls, str):
            raise TypeError("Expected argument 'bootstrap_brokers_tls' to be a str")
        pulumi.set(__self__, "bootstrap_brokers_tls", bootstrap_brokers_tls)
        if bootstrap_brokers_vpc_connectivity_sasl_iam and not isinstance(bootstrap_brokers_vpc_connectivity_sasl_iam, str):
            raise TypeError("Expected argument 'bootstrap_brokers_vpc_connectivity_sasl_iam' to be a str")
        pulumi.set(__self__, "bootstrap_brokers_vpc_connectivity_sasl_iam", bootstrap_brokers_vpc_connectivity_sasl_iam)
        if bootstrap_brokers_vpc_connectivity_sasl_scram and not isinstance(bootstrap_brokers_vpc_connectivity_sasl_scram, str):
            raise TypeError("Expected argument 'bootstrap_brokers_vpc_connectivity_sasl_scram' to be a str")
        pulumi.set(__self__, "bootstrap_brokers_vpc_connectivity_sasl_scram", bootstrap_brokers_vpc_connectivity_sasl_scram)
        if bootstrap_brokers_vpc_connectivity_tls and not isinstance(bootstrap_brokers_vpc_connectivity_tls, str):
            raise TypeError("Expected argument 'bootstrap_brokers_vpc_connectivity_tls' to be a str")
        pulumi.set(__self__, "bootstrap_brokers_vpc_connectivity_tls", bootstrap_brokers_vpc_connectivity_tls)
        if cluster_arn and not isinstance(cluster_arn, str):
            raise TypeError("Expected argument 'cluster_arn' to be a str")
        pulumi.set(__self__, "cluster_arn", cluster_arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="bootstrapBrokers")
    def bootstrap_brokers(self) -> builtins.str:
        """
        Comma separated list of one or more hostname:port pairs of kafka brokers suitable to bootstrap connectivity to the kafka cluster.
        """
        return pulumi.get(self, "bootstrap_brokers")

    @property
    @pulumi.getter(name="bootstrapBrokersPublicSaslIam")
    def bootstrap_brokers_public_sasl_iam(self) -> builtins.str:
        """
        One or more DNS names (or IP addresses) and SASL IAM port pairs.
        """
        return pulumi.get(self, "bootstrap_brokers_public_sasl_iam")

    @property
    @pulumi.getter(name="bootstrapBrokersPublicSaslScram")
    def bootstrap_brokers_public_sasl_scram(self) -> builtins.str:
        """
        One or more DNS names (or IP addresses) and SASL SCRAM port pairs.
        """
        return pulumi.get(self, "bootstrap_brokers_public_sasl_scram")

    @property
    @pulumi.getter(name="bootstrapBrokersPublicTls")
    def bootstrap_brokers_public_tls(self) -> builtins.str:
        """
        One or more DNS names (or IP addresses) and TLS port pairs.
        """
        return pulumi.get(self, "bootstrap_brokers_public_tls")

    @property
    @pulumi.getter(name="bootstrapBrokersSaslIam")
    def bootstrap_brokers_sasl_iam(self) -> builtins.str:
        """
        One or more DNS names (or IP addresses) and SASL IAM port pairs.
        """
        return pulumi.get(self, "bootstrap_brokers_sasl_iam")

    @property
    @pulumi.getter(name="bootstrapBrokersSaslScram")
    def bootstrap_brokers_sasl_scram(self) -> builtins.str:
        """
        One or more DNS names (or IP addresses) and SASL SCRAM port pairs.
        """
        return pulumi.get(self, "bootstrap_brokers_sasl_scram")

    @property
    @pulumi.getter(name="bootstrapBrokersTls")
    def bootstrap_brokers_tls(self) -> builtins.str:
        """
        One or more DNS names (or IP addresses) and TLS port pairs.
        """
        return pulumi.get(self, "bootstrap_brokers_tls")

    @property
    @pulumi.getter(name="bootstrapBrokersVpcConnectivitySaslIam")
    def bootstrap_brokers_vpc_connectivity_sasl_iam(self) -> builtins.str:
        """
        A string containing one or more DNS names (or IP addresses) and SASL IAM port pairs for VPC connectivity.
        """
        return pulumi.get(self, "bootstrap_brokers_vpc_connectivity_sasl_iam")

    @property
    @pulumi.getter(name="bootstrapBrokersVpcConnectivitySaslScram")
    def bootstrap_brokers_vpc_connectivity_sasl_scram(self) -> builtins.str:
        """
        A string containing one or more DNS names (or IP addresses) and SASL SCRAM port pairs for VPC connectivity.
        """
        return pulumi.get(self, "bootstrap_brokers_vpc_connectivity_sasl_scram")

    @property
    @pulumi.getter(name="bootstrapBrokersVpcConnectivityTls")
    def bootstrap_brokers_vpc_connectivity_tls(self) -> builtins.str:
        """
        A string containing one or more DNS names (or IP addresses) and TLS port pairs for VPC connectivity.
        """
        return pulumi.get(self, "bootstrap_brokers_vpc_connectivity_tls")

    @property
    @pulumi.getter(name="clusterArn")
    def cluster_arn(self) -> builtins.str:
        return pulumi.get(self, "cluster_arn")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetBootstrapBrokersResult(GetBootstrapBrokersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBootstrapBrokersResult(
            bootstrap_brokers=self.bootstrap_brokers,
            bootstrap_brokers_public_sasl_iam=self.bootstrap_brokers_public_sasl_iam,
            bootstrap_brokers_public_sasl_scram=self.bootstrap_brokers_public_sasl_scram,
            bootstrap_brokers_public_tls=self.bootstrap_brokers_public_tls,
            bootstrap_brokers_sasl_iam=self.bootstrap_brokers_sasl_iam,
            bootstrap_brokers_sasl_scram=self.bootstrap_brokers_sasl_scram,
            bootstrap_brokers_tls=self.bootstrap_brokers_tls,
            bootstrap_brokers_vpc_connectivity_sasl_iam=self.bootstrap_brokers_vpc_connectivity_sasl_iam,
            bootstrap_brokers_vpc_connectivity_sasl_scram=self.bootstrap_brokers_vpc_connectivity_sasl_scram,
            bootstrap_brokers_vpc_connectivity_tls=self.bootstrap_brokers_vpc_connectivity_tls,
            cluster_arn=self.cluster_arn,
            id=self.id,
            region=self.region)


def get_bootstrap_brokers(cluster_arn: Optional[builtins.str] = None,
                          region: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBootstrapBrokersResult:
    """
    Get a list of brokers that a client application can use to bootstrap.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.msk.get_bootstrap_brokers(cluster_arn=example_aws_msk_cluster["arn"])
    ```


    :param builtins.str cluster_arn: ARN of the cluster the nodes belong to.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['clusterArn'] = cluster_arn
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:msk/getBootstrapBrokers:getBootstrapBrokers', __args__, opts=opts, typ=GetBootstrapBrokersResult).value

    return AwaitableGetBootstrapBrokersResult(
        bootstrap_brokers=pulumi.get(__ret__, 'bootstrap_brokers'),
        bootstrap_brokers_public_sasl_iam=pulumi.get(__ret__, 'bootstrap_brokers_public_sasl_iam'),
        bootstrap_brokers_public_sasl_scram=pulumi.get(__ret__, 'bootstrap_brokers_public_sasl_scram'),
        bootstrap_brokers_public_tls=pulumi.get(__ret__, 'bootstrap_brokers_public_tls'),
        bootstrap_brokers_sasl_iam=pulumi.get(__ret__, 'bootstrap_brokers_sasl_iam'),
        bootstrap_brokers_sasl_scram=pulumi.get(__ret__, 'bootstrap_brokers_sasl_scram'),
        bootstrap_brokers_tls=pulumi.get(__ret__, 'bootstrap_brokers_tls'),
        bootstrap_brokers_vpc_connectivity_sasl_iam=pulumi.get(__ret__, 'bootstrap_brokers_vpc_connectivity_sasl_iam'),
        bootstrap_brokers_vpc_connectivity_sasl_scram=pulumi.get(__ret__, 'bootstrap_brokers_vpc_connectivity_sasl_scram'),
        bootstrap_brokers_vpc_connectivity_tls=pulumi.get(__ret__, 'bootstrap_brokers_vpc_connectivity_tls'),
        cluster_arn=pulumi.get(__ret__, 'cluster_arn'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_bootstrap_brokers_output(cluster_arn: Optional[pulumi.Input[builtins.str]] = None,
                                 region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBootstrapBrokersResult]:
    """
    Get a list of brokers that a client application can use to bootstrap.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.msk.get_bootstrap_brokers(cluster_arn=example_aws_msk_cluster["arn"])
    ```


    :param builtins.str cluster_arn: ARN of the cluster the nodes belong to.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['clusterArn'] = cluster_arn
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:msk/getBootstrapBrokers:getBootstrapBrokers', __args__, opts=opts, typ=GetBootstrapBrokersResult)
    return __ret__.apply(lambda __response__: GetBootstrapBrokersResult(
        bootstrap_brokers=pulumi.get(__response__, 'bootstrap_brokers'),
        bootstrap_brokers_public_sasl_iam=pulumi.get(__response__, 'bootstrap_brokers_public_sasl_iam'),
        bootstrap_brokers_public_sasl_scram=pulumi.get(__response__, 'bootstrap_brokers_public_sasl_scram'),
        bootstrap_brokers_public_tls=pulumi.get(__response__, 'bootstrap_brokers_public_tls'),
        bootstrap_brokers_sasl_iam=pulumi.get(__response__, 'bootstrap_brokers_sasl_iam'),
        bootstrap_brokers_sasl_scram=pulumi.get(__response__, 'bootstrap_brokers_sasl_scram'),
        bootstrap_brokers_tls=pulumi.get(__response__, 'bootstrap_brokers_tls'),
        bootstrap_brokers_vpc_connectivity_sasl_iam=pulumi.get(__response__, 'bootstrap_brokers_vpc_connectivity_sasl_iam'),
        bootstrap_brokers_vpc_connectivity_sasl_scram=pulumi.get(__response__, 'bootstrap_brokers_vpc_connectivity_sasl_scram'),
        bootstrap_brokers_vpc_connectivity_tls=pulumi.get(__response__, 'bootstrap_brokers_vpc_connectivity_tls'),
        cluster_arn=pulumi.get(__response__, 'cluster_arn'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
