# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterResult',
    'AwaitableGetClusterResult',
    'get_cluster',
    'get_cluster_output',
]

@pulumi.output_type
class GetClusterResult:
    """
    A collection of values returned by getCluster.
    """
    def __init__(__self__, arn=None, bootstrap_brokers=None, bootstrap_brokers_public_sasl_iam=None, bootstrap_brokers_public_sasl_scram=None, bootstrap_brokers_public_tls=None, bootstrap_brokers_sasl_iam=None, bootstrap_brokers_sasl_scram=None, bootstrap_brokers_tls=None, broker_node_group_infos=None, cluster_name=None, cluster_uuid=None, id=None, kafka_version=None, number_of_broker_nodes=None, region=None, tags=None, zookeeper_connect_string=None, zookeeper_connect_string_tls=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if bootstrap_brokers and not isinstance(bootstrap_brokers, str):
            raise TypeError("Expected argument 'bootstrap_brokers' to be a str")
        pulumi.set(__self__, "bootstrap_brokers", bootstrap_brokers)
        if bootstrap_brokers_public_sasl_iam and not isinstance(bootstrap_brokers_public_sasl_iam, str):
            raise TypeError("Expected argument 'bootstrap_brokers_public_sasl_iam' to be a str")
        pulumi.set(__self__, "bootstrap_brokers_public_sasl_iam", bootstrap_brokers_public_sasl_iam)
        if bootstrap_brokers_public_sasl_scram and not isinstance(bootstrap_brokers_public_sasl_scram, str):
            raise TypeError("Expected argument 'bootstrap_brokers_public_sasl_scram' to be a str")
        pulumi.set(__self__, "bootstrap_brokers_public_sasl_scram", bootstrap_brokers_public_sasl_scram)
        if bootstrap_brokers_public_tls and not isinstance(bootstrap_brokers_public_tls, str):
            raise TypeError("Expected argument 'bootstrap_brokers_public_tls' to be a str")
        pulumi.set(__self__, "bootstrap_brokers_public_tls", bootstrap_brokers_public_tls)
        if bootstrap_brokers_sasl_iam and not isinstance(bootstrap_brokers_sasl_iam, str):
            raise TypeError("Expected argument 'bootstrap_brokers_sasl_iam' to be a str")
        pulumi.set(__self__, "bootstrap_brokers_sasl_iam", bootstrap_brokers_sasl_iam)
        if bootstrap_brokers_sasl_scram and not isinstance(bootstrap_brokers_sasl_scram, str):
            raise TypeError("Expected argument 'bootstrap_brokers_sasl_scram' to be a str")
        pulumi.set(__self__, "bootstrap_brokers_sasl_scram", bootstrap_brokers_sasl_scram)
        if bootstrap_brokers_tls and not isinstance(bootstrap_brokers_tls, str):
            raise TypeError("Expected argument 'bootstrap_brokers_tls' to be a str")
        pulumi.set(__self__, "bootstrap_brokers_tls", bootstrap_brokers_tls)
        if broker_node_group_infos and not isinstance(broker_node_group_infos, list):
            raise TypeError("Expected argument 'broker_node_group_infos' to be a list")
        pulumi.set(__self__, "broker_node_group_infos", broker_node_group_infos)
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_uuid and not isinstance(cluster_uuid, str):
            raise TypeError("Expected argument 'cluster_uuid' to be a str")
        pulumi.set(__self__, "cluster_uuid", cluster_uuid)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kafka_version and not isinstance(kafka_version, str):
            raise TypeError("Expected argument 'kafka_version' to be a str")
        pulumi.set(__self__, "kafka_version", kafka_version)
        if number_of_broker_nodes and not isinstance(number_of_broker_nodes, int):
            raise TypeError("Expected argument 'number_of_broker_nodes' to be a int")
        pulumi.set(__self__, "number_of_broker_nodes", number_of_broker_nodes)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if zookeeper_connect_string and not isinstance(zookeeper_connect_string, str):
            raise TypeError("Expected argument 'zookeeper_connect_string' to be a str")
        pulumi.set(__self__, "zookeeper_connect_string", zookeeper_connect_string)
        if zookeeper_connect_string_tls and not isinstance(zookeeper_connect_string_tls, str):
            raise TypeError("Expected argument 'zookeeper_connect_string_tls' to be a str")
        pulumi.set(__self__, "zookeeper_connect_string_tls", zookeeper_connect_string_tls)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the MSK cluster.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="bootstrapBrokers")
    def bootstrap_brokers(self) -> builtins.str:
        """
        Comma separated list of one or more hostname:port pairs of kafka brokers suitable to bootstrap connectivity to the kafka cluster. Contains a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `PLAINTEXT` or `TLS_PLAINTEXT`. The resource sorts values alphabetically. AWS may not always return all endpoints so this value is not guaranteed to be stable across applies.
        """
        return pulumi.get(self, "bootstrap_brokers")

    @property
    @pulumi.getter(name="bootstrapBrokersPublicSaslIam")
    def bootstrap_brokers_public_sasl_iam(self) -> builtins.str:
        """
        One or more DNS names (or IP addresses) and SASL IAM port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.iam` is set to `true` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        """
        return pulumi.get(self, "bootstrap_brokers_public_sasl_iam")

    @property
    @pulumi.getter(name="bootstrapBrokersPublicSaslScram")
    def bootstrap_brokers_public_sasl_scram(self) -> builtins.str:
        """
        One or more DNS names (or IP addresses) and SASL SCRAM port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.scram` is set to `true` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        """
        return pulumi.get(self, "bootstrap_brokers_public_sasl_scram")

    @property
    @pulumi.getter(name="bootstrapBrokersPublicTls")
    def bootstrap_brokers_public_tls(self) -> builtins.str:
        """
        One or more DNS names (or IP addresses) and TLS port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        """
        return pulumi.get(self, "bootstrap_brokers_public_tls")

    @property
    @pulumi.getter(name="bootstrapBrokersSaslIam")
    def bootstrap_brokers_sasl_iam(self) -> builtins.str:
        """
        One or more DNS names (or IP addresses) and SASL IAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.iam` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        """
        return pulumi.get(self, "bootstrap_brokers_sasl_iam")

    @property
    @pulumi.getter(name="bootstrapBrokersSaslScram")
    def bootstrap_brokers_sasl_scram(self) -> builtins.str:
        """
        One or more DNS names (or IP addresses) and SASL SCRAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.scram` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        """
        return pulumi.get(self, "bootstrap_brokers_sasl_scram")

    @property
    @pulumi.getter(name="bootstrapBrokersTls")
    def bootstrap_brokers_tls(self) -> builtins.str:
        """
        One or more DNS names (or IP addresses) and TLS port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
        """
        return pulumi.get(self, "bootstrap_brokers_tls")

    @property
    @pulumi.getter(name="brokerNodeGroupInfos")
    def broker_node_group_infos(self) -> Sequence['outputs.GetClusterBrokerNodeGroupInfoResult']:
        """
        Configuration block for the broker nodes of the Kafka cluster.
        """
        return pulumi.get(self, "broker_node_group_infos")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> builtins.str:
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> builtins.str:
        """
        UUID of the MSK cluster, for use in IAM policies.
        """
        return pulumi.get(self, "cluster_uuid")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kafkaVersion")
    def kafka_version(self) -> builtins.str:
        """
        Apache Kafka version.
        """
        return pulumi.get(self, "kafka_version")

    @property
    @pulumi.getter(name="numberOfBrokerNodes")
    def number_of_broker_nodes(self) -> builtins.int:
        """
        Number of broker nodes in the cluster.
        """
        return pulumi.get(self, "number_of_broker_nodes")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Map of key-value pairs assigned to the cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="zookeeperConnectString")
    def zookeeper_connect_string(self) -> builtins.str:
        """
        A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster. The returned values are sorted alphbetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
        """
        return pulumi.get(self, "zookeeper_connect_string")

    @property
    @pulumi.getter(name="zookeeperConnectStringTls")
    def zookeeper_connect_string_tls(self) -> builtins.str:
        """
        A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster via TLS. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
        """
        return pulumi.get(self, "zookeeper_connect_string_tls")


class AwaitableGetClusterResult(GetClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterResult(
            arn=self.arn,
            bootstrap_brokers=self.bootstrap_brokers,
            bootstrap_brokers_public_sasl_iam=self.bootstrap_brokers_public_sasl_iam,
            bootstrap_brokers_public_sasl_scram=self.bootstrap_brokers_public_sasl_scram,
            bootstrap_brokers_public_tls=self.bootstrap_brokers_public_tls,
            bootstrap_brokers_sasl_iam=self.bootstrap_brokers_sasl_iam,
            bootstrap_brokers_sasl_scram=self.bootstrap_brokers_sasl_scram,
            bootstrap_brokers_tls=self.bootstrap_brokers_tls,
            broker_node_group_infos=self.broker_node_group_infos,
            cluster_name=self.cluster_name,
            cluster_uuid=self.cluster_uuid,
            id=self.id,
            kafka_version=self.kafka_version,
            number_of_broker_nodes=self.number_of_broker_nodes,
            region=self.region,
            tags=self.tags,
            zookeeper_connect_string=self.zookeeper_connect_string,
            zookeeper_connect_string_tls=self.zookeeper_connect_string_tls)


def get_cluster(cluster_name: Optional[builtins.str] = None,
                region: Optional[builtins.str] = None,
                tags: Optional[Mapping[str, builtins.str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterResult:
    """
    Get information on an Amazon MSK Cluster.

    > **Note:** This data sources returns information on _provisioned_ clusters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.msk.get_cluster(cluster_name="example")
    ```


    :param builtins.str cluster_name: Name of the cluster.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of key-value pairs assigned to the cluster.
    """
    __args__ = dict()
    __args__['clusterName'] = cluster_name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:msk/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult).value

    return AwaitableGetClusterResult(
        arn=pulumi.get(__ret__, 'arn'),
        bootstrap_brokers=pulumi.get(__ret__, 'bootstrap_brokers'),
        bootstrap_brokers_public_sasl_iam=pulumi.get(__ret__, 'bootstrap_brokers_public_sasl_iam'),
        bootstrap_brokers_public_sasl_scram=pulumi.get(__ret__, 'bootstrap_brokers_public_sasl_scram'),
        bootstrap_brokers_public_tls=pulumi.get(__ret__, 'bootstrap_brokers_public_tls'),
        bootstrap_brokers_sasl_iam=pulumi.get(__ret__, 'bootstrap_brokers_sasl_iam'),
        bootstrap_brokers_sasl_scram=pulumi.get(__ret__, 'bootstrap_brokers_sasl_scram'),
        bootstrap_brokers_tls=pulumi.get(__ret__, 'bootstrap_brokers_tls'),
        broker_node_group_infos=pulumi.get(__ret__, 'broker_node_group_infos'),
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        cluster_uuid=pulumi.get(__ret__, 'cluster_uuid'),
        id=pulumi.get(__ret__, 'id'),
        kafka_version=pulumi.get(__ret__, 'kafka_version'),
        number_of_broker_nodes=pulumi.get(__ret__, 'number_of_broker_nodes'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        zookeeper_connect_string=pulumi.get(__ret__, 'zookeeper_connect_string'),
        zookeeper_connect_string_tls=pulumi.get(__ret__, 'zookeeper_connect_string_tls'))
def get_cluster_output(cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                       region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterResult]:
    """
    Get information on an Amazon MSK Cluster.

    > **Note:** This data sources returns information on _provisioned_ clusters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.msk.get_cluster(cluster_name="example")
    ```


    :param builtins.str cluster_name: Name of the cluster.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of key-value pairs assigned to the cluster.
    """
    __args__ = dict()
    __args__['clusterName'] = cluster_name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:msk/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult)
    return __ret__.apply(lambda __response__: GetClusterResult(
        arn=pulumi.get(__response__, 'arn'),
        bootstrap_brokers=pulumi.get(__response__, 'bootstrap_brokers'),
        bootstrap_brokers_public_sasl_iam=pulumi.get(__response__, 'bootstrap_brokers_public_sasl_iam'),
        bootstrap_brokers_public_sasl_scram=pulumi.get(__response__, 'bootstrap_brokers_public_sasl_scram'),
        bootstrap_brokers_public_tls=pulumi.get(__response__, 'bootstrap_brokers_public_tls'),
        bootstrap_brokers_sasl_iam=pulumi.get(__response__, 'bootstrap_brokers_sasl_iam'),
        bootstrap_brokers_sasl_scram=pulumi.get(__response__, 'bootstrap_brokers_sasl_scram'),
        bootstrap_brokers_tls=pulumi.get(__response__, 'bootstrap_brokers_tls'),
        broker_node_group_infos=pulumi.get(__response__, 'broker_node_group_infos'),
        cluster_name=pulumi.get(__response__, 'cluster_name'),
        cluster_uuid=pulumi.get(__response__, 'cluster_uuid'),
        id=pulumi.get(__response__, 'id'),
        kafka_version=pulumi.get(__response__, 'kafka_version'),
        number_of_broker_nodes=pulumi.get(__response__, 'number_of_broker_nodes'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags'),
        zookeeper_connect_string=pulumi.get(__response__, 'zookeeper_connect_string'),
        zookeeper_connect_string_tls=pulumi.get(__response__, 'zookeeper_connect_string_tls')))
