# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetVpcConnectionResult',
    'AwaitableGetVpcConnectionResult',
    'get_vpc_connection',
    'get_vpc_connection_output',
]

@pulumi.output_type
class GetVpcConnectionResult:
    """
    A collection of values returned by getVpcConnection.
    """
    def __init__(__self__, arn=None, authentication=None, client_subnets=None, id=None, region=None, security_groups=None, tags=None, target_cluster_arn=None, vpc_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if authentication and not isinstance(authentication, str):
            raise TypeError("Expected argument 'authentication' to be a str")
        pulumi.set(__self__, "authentication", authentication)
        if client_subnets and not isinstance(client_subnets, list):
            raise TypeError("Expected argument 'client_subnets' to be a list")
        pulumi.set(__self__, "client_subnets", client_subnets)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if security_groups and not isinstance(security_groups, list):
            raise TypeError("Expected argument 'security_groups' to be a list")
        pulumi.set(__self__, "security_groups", security_groups)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if target_cluster_arn and not isinstance(target_cluster_arn, str):
            raise TypeError("Expected argument 'target_cluster_arn' to be a str")
        pulumi.set(__self__, "target_cluster_arn", target_cluster_arn)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def authentication(self) -> builtins.str:
        """
        The authentication type for the client VPC Connection.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="clientSubnets")
    def client_subnets(self) -> Sequence[builtins.str]:
        """
        The list of subnets in the client VPC.
        """
        return pulumi.get(self, "client_subnets")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Sequence[builtins.str]:
        """
        The security groups attached to the ENIs for the broker nodes.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Map of key-value pairs assigned to the VPC Connection.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetClusterArn")
    def target_cluster_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the cluster.
        """
        return pulumi.get(self, "target_cluster_arn")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> builtins.str:
        """
        The VPC ID of the remote client.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetVpcConnectionResult(GetVpcConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcConnectionResult(
            arn=self.arn,
            authentication=self.authentication,
            client_subnets=self.client_subnets,
            id=self.id,
            region=self.region,
            security_groups=self.security_groups,
            tags=self.tags,
            target_cluster_arn=self.target_cluster_arn,
            vpc_id=self.vpc_id)


def get_vpc_connection(arn: Optional[builtins.str] = None,
                       region: Optional[builtins.str] = None,
                       tags: Optional[Mapping[str, builtins.str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcConnectionResult:
    """
    Get information on an Amazon MSK VPC Connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.msk.get_vpc_connection(arn=example_aws_msk_vpc_connection["arn"])
    ```


    :param builtins.str arn: ARN of the VPC Connection.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of key-value pairs assigned to the VPC Connection.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:msk/getVpcConnection:getVpcConnection', __args__, opts=opts, typ=GetVpcConnectionResult).value

    return AwaitableGetVpcConnectionResult(
        arn=pulumi.get(__ret__, 'arn'),
        authentication=pulumi.get(__ret__, 'authentication'),
        client_subnets=pulumi.get(__ret__, 'client_subnets'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        security_groups=pulumi.get(__ret__, 'security_groups'),
        tags=pulumi.get(__ret__, 'tags'),
        target_cluster_arn=pulumi.get(__ret__, 'target_cluster_arn'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_vpc_connection_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                              region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcConnectionResult]:
    """
    Get information on an Amazon MSK VPC Connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.msk.get_vpc_connection(arn=example_aws_msk_vpc_connection["arn"])
    ```


    :param builtins.str arn: ARN of the VPC Connection.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of key-value pairs assigned to the VPC Connection.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:msk/getVpcConnection:getVpcConnection', __args__, opts=opts, typ=GetVpcConnectionResult)
    return __ret__.apply(lambda __response__: GetVpcConnectionResult(
        arn=pulumi.get(__response__, 'arn'),
        authentication=pulumi.get(__response__, 'authentication'),
        client_subnets=pulumi.get(__response__, 'client_subnets'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        security_groups=pulumi.get(__response__, 'security_groups'),
        tags=pulumi.get(__response__, 'tags'),
        target_cluster_arn=pulumi.get(__response__, 'target_cluster_arn'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
