# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCustomPluginResult',
    'AwaitableGetCustomPluginResult',
    'get_custom_plugin',
    'get_custom_plugin_output',
]

@pulumi.output_type
class GetCustomPluginResult:
    """
    A collection of values returned by getCustomPlugin.
    """
    def __init__(__self__, arn=None, description=None, id=None, latest_revision=None, name=None, region=None, state=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if latest_revision and not isinstance(latest_revision, int):
            raise TypeError("Expected argument 'latest_revision' to be a int")
        pulumi.set(__self__, "latest_revision", latest_revision)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        the ARN of the custom plugin.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        a summary description of the custom plugin.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> builtins.int:
        """
        an ID of the latest successfully created revision of the custom plugin.
        """
        return pulumi.get(self, "latest_revision")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        the state of the custom plugin.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A map of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetCustomPluginResult(GetCustomPluginResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomPluginResult(
            arn=self.arn,
            description=self.description,
            id=self.id,
            latest_revision=self.latest_revision,
            name=self.name,
            region=self.region,
            state=self.state,
            tags=self.tags)


def get_custom_plugin(name: Optional[builtins.str] = None,
                      region: Optional[builtins.str] = None,
                      tags: Optional[Mapping[str, builtins.str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomPluginResult:
    """
    Get information on an Amazon MSK Connect custom plugin.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.mskconnect.get_custom_plugin(name="example-debezium-1")
    ```


    :param builtins.str name: Name of the custom plugin.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: A map of tags assigned to the resource.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:mskconnect/getCustomPlugin:getCustomPlugin', __args__, opts=opts, typ=GetCustomPluginResult).value

    return AwaitableGetCustomPluginResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        latest_revision=pulumi.get(__ret__, 'latest_revision'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        state=pulumi.get(__ret__, 'state'),
        tags=pulumi.get(__ret__, 'tags'))
def get_custom_plugin_output(name: Optional[pulumi.Input[builtins.str]] = None,
                             region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCustomPluginResult]:
    """
    Get information on an Amazon MSK Connect custom plugin.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.mskconnect.get_custom_plugin(name="example-debezium-1")
    ```


    :param builtins.str name: Name of the custom plugin.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: A map of tags assigned to the resource.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:mskconnect/getCustomPlugin:getCustomPlugin', __args__, opts=opts, typ=GetCustomPluginResult)
    return __ret__.apply(lambda __response__: GetCustomPluginResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        latest_revision=pulumi.get(__response__, 'latest_revision'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        state=pulumi.get(__response__, 'state'),
        tags=pulumi.get(__response__, 'tags')))
