# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterParameterGroupParameterArgs',
    'ClusterParameterGroupParameterArgsDict',
    'ClusterServerlessV2ScalingConfigurationArgs',
    'ClusterServerlessV2ScalingConfigurationArgsDict',
    'GlobalClusterGlobalClusterMemberArgs',
    'GlobalClusterGlobalClusterMemberArgsDict',
    'ParameterGroupParameterArgs',
    'ParameterGroupParameterArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterParameterGroupParameterArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name of the neptune parameter.
        """
        value: pulumi.Input[builtins.str]
        """
        The value of the neptune parameter.
        """
        apply_method: NotRequired[pulumi.Input[builtins.str]]
        """
        Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
        """
elif False:
    ClusterParameterGroupParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterParameterGroupParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str],
                 apply_method: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: The name of the neptune parameter.
        :param pulumi.Input[builtins.str] value: The value of the neptune parameter.
        :param pulumi.Input[builtins.str] apply_method: Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if apply_method is not None:
            pulumi.set(__self__, "apply_method", apply_method)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the neptune parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The value of the neptune parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="applyMethod")
    def apply_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
        """
        return pulumi.get(self, "apply_method")

    @apply_method.setter
    def apply_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "apply_method", value)


if not MYPY:
    class ClusterServerlessV2ScalingConfigurationArgsDict(TypedDict):
        max_capacity: NotRequired[pulumi.Input[builtins.float]]
        """
        Maximum Neptune Capacity Units (NCUs) for this cluster. Must be lower or equal than **128**. See [AWS Documentation](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-capacity-scaling.html) for more details.
        """
        min_capacity: NotRequired[pulumi.Input[builtins.float]]
        """
        Minimum Neptune Capacity Units (NCUs) for this cluster. Must be greater or equal than **1**. See [AWS Documentation](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-capacity-scaling.html) for more details.
        """
elif False:
    ClusterServerlessV2ScalingConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterServerlessV2ScalingConfigurationArgs:
    def __init__(__self__, *,
                 max_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 min_capacity: Optional[pulumi.Input[builtins.float]] = None):
        """
        :param pulumi.Input[builtins.float] max_capacity: Maximum Neptune Capacity Units (NCUs) for this cluster. Must be lower or equal than **128**. See [AWS Documentation](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-capacity-scaling.html) for more details.
        :param pulumi.Input[builtins.float] min_capacity: Minimum Neptune Capacity Units (NCUs) for this cluster. Must be greater or equal than **1**. See [AWS Documentation](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-capacity-scaling.html) for more details.
        """
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Maximum Neptune Capacity Units (NCUs) for this cluster. Must be lower or equal than **128**. See [AWS Documentation](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-capacity-scaling.html) for more details.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Minimum Neptune Capacity Units (NCUs) for this cluster. Must be greater or equal than **1**. See [AWS Documentation](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-capacity-scaling.html) for more details.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "min_capacity", value)


if not MYPY:
    class GlobalClusterGlobalClusterMemberArgsDict(TypedDict):
        db_cluster_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        ARN of member DB Cluster.
        """
        is_writer: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the member is the primary DB Cluster.
        """
elif False:
    GlobalClusterGlobalClusterMemberArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GlobalClusterGlobalClusterMemberArgs:
    def __init__(__self__, *,
                 db_cluster_arn: Optional[pulumi.Input[builtins.str]] = None,
                 is_writer: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] db_cluster_arn: ARN of member DB Cluster.
        :param pulumi.Input[builtins.bool] is_writer: Whether the member is the primary DB Cluster.
        """
        if db_cluster_arn is not None:
            pulumi.set(__self__, "db_cluster_arn", db_cluster_arn)
        if is_writer is not None:
            pulumi.set(__self__, "is_writer", is_writer)

    @property
    @pulumi.getter(name="dbClusterArn")
    def db_cluster_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of member DB Cluster.
        """
        return pulumi.get(self, "db_cluster_arn")

    @db_cluster_arn.setter
    def db_cluster_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_cluster_arn", value)

    @property
    @pulumi.getter(name="isWriter")
    def is_writer(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the member is the primary DB Cluster.
        """
        return pulumi.get(self, "is_writer")

    @is_writer.setter
    def is_writer(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_writer", value)


if not MYPY:
    class ParameterGroupParameterArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name of the Neptune parameter.
        """
        value: pulumi.Input[builtins.str]
        """
        The value of the Neptune parameter.
        """
        apply_method: NotRequired[pulumi.Input[builtins.str]]
        """
        The apply method of the Neptune parameter. Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
        """
elif False:
    ParameterGroupParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ParameterGroupParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str],
                 apply_method: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: The name of the Neptune parameter.
        :param pulumi.Input[builtins.str] value: The value of the Neptune parameter.
        :param pulumi.Input[builtins.str] apply_method: The apply method of the Neptune parameter. Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if apply_method is not None:
            pulumi.set(__self__, "apply_method", apply_method)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Neptune parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The value of the Neptune parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="applyMethod")
    def apply_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The apply method of the Neptune parameter. Valid values are `immediate` and `pending-reboot`. Defaults to `pending-reboot`.
        """
        return pulumi.get(self, "apply_method")

    @apply_method.setter
    def apply_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "apply_method", value)


