# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ClusterSnapshotArgs', 'ClusterSnapshot']

@pulumi.input_type
class ClusterSnapshotArgs:
    def __init__(__self__, *,
                 db_cluster_identifier: pulumi.Input[builtins.str],
                 db_cluster_snapshot_identifier: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ClusterSnapshot resource.
        :param pulumi.Input[builtins.str] db_cluster_identifier: The DB Cluster Identifier from which to take the snapshot.
        :param pulumi.Input[builtins.str] db_cluster_snapshot_identifier: The Identifier for the snapshot.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "db_cluster_identifier", db_cluster_identifier)
        pulumi.set(__self__, "db_cluster_snapshot_identifier", db_cluster_snapshot_identifier)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The DB Cluster Identifier from which to take the snapshot.
        """
        return pulumi.get(self, "db_cluster_identifier")

    @db_cluster_identifier.setter
    def db_cluster_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "db_cluster_identifier", value)

    @property
    @pulumi.getter(name="dbClusterSnapshotIdentifier")
    def db_cluster_snapshot_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The Identifier for the snapshot.
        """
        return pulumi.get(self, "db_cluster_snapshot_identifier")

    @db_cluster_snapshot_identifier.setter
    def db_cluster_snapshot_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "db_cluster_snapshot_identifier", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ClusterSnapshotState:
    def __init__(__self__, *,
                 allocated_storage: Optional[pulumi.Input[builtins.int]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_snapshot_arn: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 license_model: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_type: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_cluster_snapshot_arn: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 storage_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ClusterSnapshot resources.
        :param pulumi.Input[builtins.int] allocated_storage: Specifies the allocated storage size in gigabytes (GB).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] availability_zones: List of EC2 Availability Zones that instances in the DB cluster snapshot can be restored in.
        :param pulumi.Input[builtins.str] db_cluster_identifier: The DB Cluster Identifier from which to take the snapshot.
        :param pulumi.Input[builtins.str] db_cluster_snapshot_arn: The Amazon Resource Name (ARN) for the DB Cluster Snapshot.
        :param pulumi.Input[builtins.str] db_cluster_snapshot_identifier: The Identifier for the snapshot.
        :param pulumi.Input[builtins.str] engine: Specifies the name of the database engine.
        :param pulumi.Input[builtins.str] engine_version: Version of the database engine for this DB cluster snapshot.
        :param pulumi.Input[builtins.str] kms_key_id: If storage_encrypted is true, the AWS KMS key identifier for the encrypted DB cluster snapshot.
        :param pulumi.Input[builtins.str] license_model: License model information for the restored DB cluster.
        :param pulumi.Input[builtins.int] port: Port that the DB cluster was listening on at the time of the snapshot.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] status: The status of this DB Cluster Snapshot.
        :param pulumi.Input[builtins.bool] storage_encrypted: Specifies whether the DB cluster snapshot is encrypted.
        :param pulumi.Input[builtins.str] vpc_id: The VPC ID associated with the DB cluster snapshot.
        """
        if allocated_storage is not None:
            pulumi.set(__self__, "allocated_storage", allocated_storage)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if db_cluster_identifier is not None:
            pulumi.set(__self__, "db_cluster_identifier", db_cluster_identifier)
        if db_cluster_snapshot_arn is not None:
            pulumi.set(__self__, "db_cluster_snapshot_arn", db_cluster_snapshot_arn)
        if db_cluster_snapshot_identifier is not None:
            pulumi.set(__self__, "db_cluster_snapshot_identifier", db_cluster_snapshot_identifier)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if snapshot_type is not None:
            pulumi.set(__self__, "snapshot_type", snapshot_type)
        if source_db_cluster_snapshot_arn is not None:
            pulumi.set(__self__, "source_db_cluster_snapshot_arn", source_db_cluster_snapshot_arn)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_encrypted is not None:
            pulumi.set(__self__, "storage_encrypted", storage_encrypted)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the allocated storage size in gigabytes (GB).
        """
        return pulumi.get(self, "allocated_storage")

    @allocated_storage.setter
    def allocated_storage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "allocated_storage", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of EC2 Availability Zones that instances in the DB cluster snapshot can be restored in.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DB Cluster Identifier from which to take the snapshot.
        """
        return pulumi.get(self, "db_cluster_identifier")

    @db_cluster_identifier.setter
    def db_cluster_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_cluster_identifier", value)

    @property
    @pulumi.getter(name="dbClusterSnapshotArn")
    def db_cluster_snapshot_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the DB Cluster Snapshot.
        """
        return pulumi.get(self, "db_cluster_snapshot_arn")

    @db_cluster_snapshot_arn.setter
    def db_cluster_snapshot_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_cluster_snapshot_arn", value)

    @property
    @pulumi.getter(name="dbClusterSnapshotIdentifier")
    def db_cluster_snapshot_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Identifier for the snapshot.
        """
        return pulumi.get(self, "db_cluster_snapshot_identifier")

    @db_cluster_snapshot_identifier.setter
    def db_cluster_snapshot_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_cluster_snapshot_identifier", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the database engine.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Version of the database engine for this DB cluster snapshot.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If storage_encrypted is true, the AWS KMS key identifier for the encrypted DB cluster snapshot.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        License model information for the restored DB cluster.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Port that the DB cluster was listening on at the time of the snapshot.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="snapshotType")
    def snapshot_type(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "snapshot_type")

    @snapshot_type.setter
    def snapshot_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snapshot_type", value)

    @property
    @pulumi.getter(name="sourceDbClusterSnapshotArn")
    def source_db_cluster_snapshot_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "source_db_cluster_snapshot_arn")

    @source_db_cluster_snapshot_arn.setter
    def source_db_cluster_snapshot_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_db_cluster_snapshot_arn", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of this DB Cluster Snapshot.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the DB cluster snapshot is encrypted.
        """
        return pulumi.get(self, "storage_encrypted")

    @storage_encrypted.setter
    def storage_encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "storage_encrypted", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The VPC ID associated with the DB cluster snapshot.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("aws:neptune/clusterSnapshot:ClusterSnapshot")
class ClusterSnapshot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Neptune database cluster snapshot.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.neptune.ClusterSnapshot("example",
            db_cluster_identifier=example_aws_neptune_cluster["id"],
            db_cluster_snapshot_identifier="resourcetestsnapshot1234")
        ```

        ## Import

        Using `pulumi import`, import `aws_neptune_cluster_snapshot` using the cluster snapshot identifier. For example:

        ```sh
        $ pulumi import aws:neptune/clusterSnapshot:ClusterSnapshot example my-cluster-snapshot
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] db_cluster_identifier: The DB Cluster Identifier from which to take the snapshot.
        :param pulumi.Input[builtins.str] db_cluster_snapshot_identifier: The Identifier for the snapshot.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterSnapshotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Neptune database cluster snapshot.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.neptune.ClusterSnapshot("example",
            db_cluster_identifier=example_aws_neptune_cluster["id"],
            db_cluster_snapshot_identifier="resourcetestsnapshot1234")
        ```

        ## Import

        Using `pulumi import`, import `aws_neptune_cluster_snapshot` using the cluster snapshot identifier. For example:

        ```sh
        $ pulumi import aws:neptune/clusterSnapshot:ClusterSnapshot example my-cluster-snapshot
        ```

        :param str resource_name: The name of the resource.
        :param ClusterSnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterSnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterSnapshotArgs.__new__(ClusterSnapshotArgs)

            if db_cluster_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_identifier'")
            __props__.__dict__["db_cluster_identifier"] = db_cluster_identifier
            if db_cluster_snapshot_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_snapshot_identifier'")
            __props__.__dict__["db_cluster_snapshot_identifier"] = db_cluster_snapshot_identifier
            __props__.__dict__["region"] = region
            __props__.__dict__["allocated_storage"] = None
            __props__.__dict__["availability_zones"] = None
            __props__.__dict__["db_cluster_snapshot_arn"] = None
            __props__.__dict__["engine"] = None
            __props__.__dict__["engine_version"] = None
            __props__.__dict__["kms_key_id"] = None
            __props__.__dict__["license_model"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["snapshot_type"] = None
            __props__.__dict__["source_db_cluster_snapshot_arn"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["storage_encrypted"] = None
            __props__.__dict__["vpc_id"] = None
        super(ClusterSnapshot, __self__).__init__(
            'aws:neptune/clusterSnapshot:ClusterSnapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocated_storage: Optional[pulumi.Input[builtins.int]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
            db_cluster_snapshot_arn: Optional[pulumi.Input[builtins.str]] = None,
            db_cluster_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
            engine: Optional[pulumi.Input[builtins.str]] = None,
            engine_version: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            license_model: Optional[pulumi.Input[builtins.str]] = None,
            port: Optional[pulumi.Input[builtins.int]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            snapshot_type: Optional[pulumi.Input[builtins.str]] = None,
            source_db_cluster_snapshot_arn: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            storage_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
            vpc_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ClusterSnapshot':
        """
        Get an existing ClusterSnapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] allocated_storage: Specifies the allocated storage size in gigabytes (GB).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] availability_zones: List of EC2 Availability Zones that instances in the DB cluster snapshot can be restored in.
        :param pulumi.Input[builtins.str] db_cluster_identifier: The DB Cluster Identifier from which to take the snapshot.
        :param pulumi.Input[builtins.str] db_cluster_snapshot_arn: The Amazon Resource Name (ARN) for the DB Cluster Snapshot.
        :param pulumi.Input[builtins.str] db_cluster_snapshot_identifier: The Identifier for the snapshot.
        :param pulumi.Input[builtins.str] engine: Specifies the name of the database engine.
        :param pulumi.Input[builtins.str] engine_version: Version of the database engine for this DB cluster snapshot.
        :param pulumi.Input[builtins.str] kms_key_id: If storage_encrypted is true, the AWS KMS key identifier for the encrypted DB cluster snapshot.
        :param pulumi.Input[builtins.str] license_model: License model information for the restored DB cluster.
        :param pulumi.Input[builtins.int] port: Port that the DB cluster was listening on at the time of the snapshot.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] status: The status of this DB Cluster Snapshot.
        :param pulumi.Input[builtins.bool] storage_encrypted: Specifies whether the DB cluster snapshot is encrypted.
        :param pulumi.Input[builtins.str] vpc_id: The VPC ID associated with the DB cluster snapshot.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterSnapshotState.__new__(_ClusterSnapshotState)

        __props__.__dict__["allocated_storage"] = allocated_storage
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["db_cluster_identifier"] = db_cluster_identifier
        __props__.__dict__["db_cluster_snapshot_arn"] = db_cluster_snapshot_arn
        __props__.__dict__["db_cluster_snapshot_identifier"] = db_cluster_snapshot_identifier
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["port"] = port
        __props__.__dict__["region"] = region
        __props__.__dict__["snapshot_type"] = snapshot_type
        __props__.__dict__["source_db_cluster_snapshot_arn"] = source_db_cluster_snapshot_arn
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_encrypted"] = storage_encrypted
        __props__.__dict__["vpc_id"] = vpc_id
        return ClusterSnapshot(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the allocated storage size in gigabytes (GB).
        """
        return pulumi.get(self, "allocated_storage")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of EC2 Availability Zones that instances in the DB cluster snapshot can be restored in.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The DB Cluster Identifier from which to take the snapshot.
        """
        return pulumi.get(self, "db_cluster_identifier")

    @property
    @pulumi.getter(name="dbClusterSnapshotArn")
    def db_cluster_snapshot_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the DB Cluster Snapshot.
        """
        return pulumi.get(self, "db_cluster_snapshot_arn")

    @property
    @pulumi.getter(name="dbClusterSnapshotIdentifier")
    def db_cluster_snapshot_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The Identifier for the snapshot.
        """
        return pulumi.get(self, "db_cluster_snapshot_identifier")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the database engine.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[builtins.str]:
        """
        Version of the database engine for this DB cluster snapshot.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[builtins.str]:
        """
        If storage_encrypted is true, the AWS KMS key identifier for the encrypted DB cluster snapshot.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[builtins.str]:
        """
        License model information for the restored DB cluster.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[builtins.int]:
        """
        Port that the DB cluster was listening on at the time of the snapshot.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="snapshotType")
    def snapshot_type(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "snapshot_type")

    @property
    @pulumi.getter(name="sourceDbClusterSnapshotArn")
    def source_db_cluster_snapshot_arn(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "source_db_cluster_snapshot_arn")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The status of this DB Cluster Snapshot.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies whether the DB cluster snapshot is encrypted.
        """
        return pulumi.get(self, "storage_encrypted")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[builtins.str]:
        """
        The VPC ID associated with the DB cluster snapshot.
        """
        return pulumi.get(self, "vpc_id")

