# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GraphArgs', 'Graph']

@pulumi.input_type
class GraphArgs:
    def __init__(__self__, *,
                 provisioned_memory: pulumi.Input[builtins.int],
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 graph_name: Optional[pulumi.Input[builtins.str]] = None,
                 graph_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 public_connectivity: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['GraphTimeoutsArgs']] = None,
                 vector_search_configuration: Optional[pulumi.Input['GraphVectorSearchConfigurationArgs']] = None):
        """
        The set of arguments for constructing a Graph resource.
        :param pulumi.Input[builtins.int] provisioned_memory: The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.bool] deletion_protection: Value that indicates whether the Graph has deletion protection enabled. The graph can't be deleted when deletion protection is enabled.
        :param pulumi.Input[builtins.str] graph_name: The graph name. For example: my-graph-1. The name must contain from 1 to 63 letters, numbers, or hyphens, and its first
               character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens. If you don't specify a graph
               name, a unique graph name is generated for you using the prefix graph-for, followed by a combination of Stack Name and a
               UUID.
        :param pulumi.Input[builtins.str] graph_name_prefix: Allows user to specify name prefix and have remainder of name automatically generated.
        :param pulumi.Input[builtins.str] kms_key_identifier: The ARN for the KMS encryption key. By Default, Neptune Analytics will use an AWS provided key ("AWS_OWNED_KEY"). This parameter is used if you want to encrypt the graph using a KMS Customer Managed Key (CMK).
        :param pulumi.Input[builtins.bool] public_connectivity: Specifies whether the Graph can be reached over the internet. Access to all graphs requires IAM authentication.  When the Graph is publicly reachable, its Domain Name System (DNS) endpoint resolves to the public IP address from the internet.  When the Graph isn't publicly reachable, you need to create a PrivateGraphEndpoint in a given VPC to ensure the DNS name resolves to a private IP address that is reachable from the VPC.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] replica_count: Specifies the number of replicas you want when finished. All replicas will be provisioned in different availability zones.  Replica Count should always be less than or equal to 2.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value tags for the graph. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['GraphVectorSearchConfigurationArgs'] vector_search_configuration: Vector Search Configuration (see below for nested schema of vector_search_configuration)
        """
        pulumi.set(__self__, "provisioned_memory", provisioned_memory)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if graph_name is not None:
            pulumi.set(__self__, "graph_name", graph_name)
        if graph_name_prefix is not None:
            pulumi.set(__self__, "graph_name_prefix", graph_name_prefix)
        if kms_key_identifier is not None:
            pulumi.set(__self__, "kms_key_identifier", kms_key_identifier)
        if public_connectivity is not None:
            pulumi.set(__self__, "public_connectivity", public_connectivity)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if vector_search_configuration is not None:
            pulumi.set(__self__, "vector_search_configuration", vector_search_configuration)

    @property
    @pulumi.getter(name="provisionedMemory")
    def provisioned_memory(self) -> pulumi.Input[builtins.int]:
        """
        The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.

        The following arguments are optional:
        """
        return pulumi.get(self, "provisioned_memory")

    @provisioned_memory.setter
    def provisioned_memory(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "provisioned_memory", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Value that indicates whether the Graph has deletion protection enabled. The graph can't be deleted when deletion protection is enabled.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="graphName")
    def graph_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The graph name. For example: my-graph-1. The name must contain from 1 to 63 letters, numbers, or hyphens, and its first
        character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens. If you don't specify a graph
        name, a unique graph name is generated for you using the prefix graph-for, followed by a combination of Stack Name and a
        UUID.
        """
        return pulumi.get(self, "graph_name")

    @graph_name.setter
    def graph_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "graph_name", value)

    @property
    @pulumi.getter(name="graphNamePrefix")
    def graph_name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Allows user to specify name prefix and have remainder of name automatically generated.
        """
        return pulumi.get(self, "graph_name_prefix")

    @graph_name_prefix.setter
    def graph_name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "graph_name_prefix", value)

    @property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN for the KMS encryption key. By Default, Neptune Analytics will use an AWS provided key ("AWS_OWNED_KEY"). This parameter is used if you want to encrypt the graph using a KMS Customer Managed Key (CMK).
        """
        return pulumi.get(self, "kms_key_identifier")

    @kms_key_identifier.setter
    def kms_key_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_identifier", value)

    @property
    @pulumi.getter(name="publicConnectivity")
    def public_connectivity(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the Graph can be reached over the internet. Access to all graphs requires IAM authentication.  When the Graph is publicly reachable, its Domain Name System (DNS) endpoint resolves to the public IP address from the internet.  When the Graph isn't publicly reachable, you need to create a PrivateGraphEndpoint in a given VPC to ensure the DNS name resolves to a private IP address that is reachable from the VPC.
        """
        return pulumi.get(self, "public_connectivity")

    @public_connectivity.setter
    def public_connectivity(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_connectivity", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of replicas you want when finished. All replicas will be provisioned in different availability zones.  Replica Count should always be less than or equal to 2.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replica_count", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value tags for the graph. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['GraphTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['GraphTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="vectorSearchConfiguration")
    def vector_search_configuration(self) -> Optional[pulumi.Input['GraphVectorSearchConfigurationArgs']]:
        """
        Vector Search Configuration (see below for nested schema of vector_search_configuration)
        """
        return pulumi.get(self, "vector_search_configuration")

    @vector_search_configuration.setter
    def vector_search_configuration(self, value: Optional[pulumi.Input['GraphVectorSearchConfigurationArgs']]):
        pulumi.set(self, "vector_search_configuration", value)


@pulumi.input_type
class _GraphState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 graph_name: Optional[pulumi.Input[builtins.str]] = None,
                 graph_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 provisioned_memory: Optional[pulumi.Input[builtins.int]] = None,
                 public_connectivity: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['GraphTimeoutsArgs']] = None,
                 vector_search_configuration: Optional[pulumi.Input['GraphVectorSearchConfigurationArgs']] = None):
        """
        Input properties used for looking up and filtering Graph resources.
        :param pulumi.Input[builtins.str] arn: (String) Graph resource ARN
        :param pulumi.Input[builtins.bool] deletion_protection: Value that indicates whether the Graph has deletion protection enabled. The graph can't be deleted when deletion protection is enabled.
        :param pulumi.Input[builtins.str] endpoint: (String) The connection endpoint for the graph. For example: `g-12a3bcdef4.us-east-1.neptune-graph.amazonaws.com`
        :param pulumi.Input[builtins.str] graph_name: The graph name. For example: my-graph-1. The name must contain from 1 to 63 letters, numbers, or hyphens, and its first
               character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens. If you don't specify a graph
               name, a unique graph name is generated for you using the prefix graph-for, followed by a combination of Stack Name and a
               UUID.
        :param pulumi.Input[builtins.str] graph_name_prefix: Allows user to specify name prefix and have remainder of name automatically generated.
        :param pulumi.Input[builtins.str] kms_key_identifier: The ARN for the KMS encryption key. By Default, Neptune Analytics will use an AWS provided key ("AWS_OWNED_KEY"). This parameter is used if you want to encrypt the graph using a KMS Customer Managed Key (CMK).
        :param pulumi.Input[builtins.int] provisioned_memory: The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.bool] public_connectivity: Specifies whether the Graph can be reached over the internet. Access to all graphs requires IAM authentication.  When the Graph is publicly reachable, its Domain Name System (DNS) endpoint resolves to the public IP address from the internet.  When the Graph isn't publicly reachable, you need to create a PrivateGraphEndpoint in a given VPC to ensure the DNS name resolves to a private IP address that is reachable from the VPC.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] replica_count: Specifies the number of replicas you want when finished. All replicas will be provisioned in different availability zones.  Replica Count should always be less than or equal to 2.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value tags for the graph. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['GraphVectorSearchConfigurationArgs'] vector_search_configuration: Vector Search Configuration (see below for nested schema of vector_search_configuration)
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if graph_name is not None:
            pulumi.set(__self__, "graph_name", graph_name)
        if graph_name_prefix is not None:
            pulumi.set(__self__, "graph_name_prefix", graph_name_prefix)
        if kms_key_identifier is not None:
            pulumi.set(__self__, "kms_key_identifier", kms_key_identifier)
        if provisioned_memory is not None:
            pulumi.set(__self__, "provisioned_memory", provisioned_memory)
        if public_connectivity is not None:
            pulumi.set(__self__, "public_connectivity", public_connectivity)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if vector_search_configuration is not None:
            pulumi.set(__self__, "vector_search_configuration", vector_search_configuration)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (String) Graph resource ARN
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Value that indicates whether the Graph has deletion protection enabled. The graph can't be deleted when deletion protection is enabled.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (String) The connection endpoint for the graph. For example: `g-12a3bcdef4.us-east-1.neptune-graph.amazonaws.com`
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="graphName")
    def graph_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The graph name. For example: my-graph-1. The name must contain from 1 to 63 letters, numbers, or hyphens, and its first
        character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens. If you don't specify a graph
        name, a unique graph name is generated for you using the prefix graph-for, followed by a combination of Stack Name and a
        UUID.
        """
        return pulumi.get(self, "graph_name")

    @graph_name.setter
    def graph_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "graph_name", value)

    @property
    @pulumi.getter(name="graphNamePrefix")
    def graph_name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Allows user to specify name prefix and have remainder of name automatically generated.
        """
        return pulumi.get(self, "graph_name_prefix")

    @graph_name_prefix.setter
    def graph_name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "graph_name_prefix", value)

    @property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN for the KMS encryption key. By Default, Neptune Analytics will use an AWS provided key ("AWS_OWNED_KEY"). This parameter is used if you want to encrypt the graph using a KMS Customer Managed Key (CMK).
        """
        return pulumi.get(self, "kms_key_identifier")

    @kms_key_identifier.setter
    def kms_key_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_identifier", value)

    @property
    @pulumi.getter(name="provisionedMemory")
    def provisioned_memory(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.

        The following arguments are optional:
        """
        return pulumi.get(self, "provisioned_memory")

    @provisioned_memory.setter
    def provisioned_memory(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "provisioned_memory", value)

    @property
    @pulumi.getter(name="publicConnectivity")
    def public_connectivity(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the Graph can be reached over the internet. Access to all graphs requires IAM authentication.  When the Graph is publicly reachable, its Domain Name System (DNS) endpoint resolves to the public IP address from the internet.  When the Graph isn't publicly reachable, you need to create a PrivateGraphEndpoint in a given VPC to ensure the DNS name resolves to a private IP address that is reachable from the VPC.
        """
        return pulumi.get(self, "public_connectivity")

    @public_connectivity.setter
    def public_connectivity(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_connectivity", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of replicas you want when finished. All replicas will be provisioned in different availability zones.  Replica Count should always be less than or equal to 2.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replica_count", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value tags for the graph. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['GraphTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['GraphTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="vectorSearchConfiguration")
    def vector_search_configuration(self) -> Optional[pulumi.Input['GraphVectorSearchConfigurationArgs']]:
        """
        Vector Search Configuration (see below for nested schema of vector_search_configuration)
        """
        return pulumi.get(self, "vector_search_configuration")

    @vector_search_configuration.setter
    def vector_search_configuration(self, value: Optional[pulumi.Input['GraphVectorSearchConfigurationArgs']]):
        pulumi.set(self, "vector_search_configuration", value)


@pulumi.type_token("aws:neptunegraph/graph:Graph")
class Graph(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 graph_name: Optional[pulumi.Input[builtins.str]] = None,
                 graph_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 provisioned_memory: Optional[pulumi.Input[builtins.int]] = None,
                 public_connectivity: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['GraphTimeoutsArgs', 'GraphTimeoutsArgsDict']]] = None,
                 vector_search_configuration: Optional[pulumi.Input[Union['GraphVectorSearchConfigurationArgs', 'GraphVectorSearchConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        The `neptunegraph.Graph` resource creates an Amazon Analytics Graph.

        ## Example Usage

        ### Neptune Graph (with Vector Search configuration)

        Creates a Neptune Graph with 16GB provisioned memory, vector search capability with 128 dimensions, and a single replica for high availability.

        ```python
        import pulumi
        import pulumi_aws as aws

        # Create Neptune Graph
        example = aws.neptunegraph.Graph("example",
            graph_name="example-graph-test-20250203",
            provisioned_memory=16,
            deletion_protection=False,
            public_connectivity=False,
            replica_count=1,
            kms_key_identifier="arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012",
            vector_search_configuration={
                "vector_search_dimension": 128,
            },
            tags={
                "Environment": "Development",
                "ModifiedBy": "AWS",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_neptunegraph_graph` using the graph identifier. For example:

        ```sh
        $ pulumi import aws:neptunegraph/graph:Graph example "graph_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] deletion_protection: Value that indicates whether the Graph has deletion protection enabled. The graph can't be deleted when deletion protection is enabled.
        :param pulumi.Input[builtins.str] graph_name: The graph name. For example: my-graph-1. The name must contain from 1 to 63 letters, numbers, or hyphens, and its first
               character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens. If you don't specify a graph
               name, a unique graph name is generated for you using the prefix graph-for, followed by a combination of Stack Name and a
               UUID.
        :param pulumi.Input[builtins.str] graph_name_prefix: Allows user to specify name prefix and have remainder of name automatically generated.
        :param pulumi.Input[builtins.str] kms_key_identifier: The ARN for the KMS encryption key. By Default, Neptune Analytics will use an AWS provided key ("AWS_OWNED_KEY"). This parameter is used if you want to encrypt the graph using a KMS Customer Managed Key (CMK).
        :param pulumi.Input[builtins.int] provisioned_memory: The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.bool] public_connectivity: Specifies whether the Graph can be reached over the internet. Access to all graphs requires IAM authentication.  When the Graph is publicly reachable, its Domain Name System (DNS) endpoint resolves to the public IP address from the internet.  When the Graph isn't publicly reachable, you need to create a PrivateGraphEndpoint in a given VPC to ensure the DNS name resolves to a private IP address that is reachable from the VPC.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] replica_count: Specifies the number of replicas you want when finished. All replicas will be provisioned in different availability zones.  Replica Count should always be less than or equal to 2.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value tags for the graph. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['GraphVectorSearchConfigurationArgs', 'GraphVectorSearchConfigurationArgsDict']] vector_search_configuration: Vector Search Configuration (see below for nested schema of vector_search_configuration)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GraphArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `neptunegraph.Graph` resource creates an Amazon Analytics Graph.

        ## Example Usage

        ### Neptune Graph (with Vector Search configuration)

        Creates a Neptune Graph with 16GB provisioned memory, vector search capability with 128 dimensions, and a single replica for high availability.

        ```python
        import pulumi
        import pulumi_aws as aws

        # Create Neptune Graph
        example = aws.neptunegraph.Graph("example",
            graph_name="example-graph-test-20250203",
            provisioned_memory=16,
            deletion_protection=False,
            public_connectivity=False,
            replica_count=1,
            kms_key_identifier="arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012",
            vector_search_configuration={
                "vector_search_dimension": 128,
            },
            tags={
                "Environment": "Development",
                "ModifiedBy": "AWS",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_neptunegraph_graph` using the graph identifier. For example:

        ```sh
        $ pulumi import aws:neptunegraph/graph:Graph example "graph_id"
        ```

        :param str resource_name: The name of the resource.
        :param GraphArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GraphArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 graph_name: Optional[pulumi.Input[builtins.str]] = None,
                 graph_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 provisioned_memory: Optional[pulumi.Input[builtins.int]] = None,
                 public_connectivity: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['GraphTimeoutsArgs', 'GraphTimeoutsArgsDict']]] = None,
                 vector_search_configuration: Optional[pulumi.Input[Union['GraphVectorSearchConfigurationArgs', 'GraphVectorSearchConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GraphArgs.__new__(GraphArgs)

            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["graph_name"] = graph_name
            __props__.__dict__["graph_name_prefix"] = graph_name_prefix
            __props__.__dict__["kms_key_identifier"] = kms_key_identifier
            if provisioned_memory is None and not opts.urn:
                raise TypeError("Missing required property 'provisioned_memory'")
            __props__.__dict__["provisioned_memory"] = provisioned_memory
            __props__.__dict__["public_connectivity"] = public_connectivity
            __props__.__dict__["region"] = region
            __props__.__dict__["replica_count"] = replica_count
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["vector_search_configuration"] = vector_search_configuration
            __props__.__dict__["arn"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["tags_all"] = None
        super(Graph, __self__).__init__(
            'aws:neptunegraph/graph:Graph',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
            endpoint: Optional[pulumi.Input[builtins.str]] = None,
            graph_name: Optional[pulumi.Input[builtins.str]] = None,
            graph_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_identifier: Optional[pulumi.Input[builtins.str]] = None,
            provisioned_memory: Optional[pulumi.Input[builtins.int]] = None,
            public_connectivity: Optional[pulumi.Input[builtins.bool]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            replica_count: Optional[pulumi.Input[builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['GraphTimeoutsArgs', 'GraphTimeoutsArgsDict']]] = None,
            vector_search_configuration: Optional[pulumi.Input[Union['GraphVectorSearchConfigurationArgs', 'GraphVectorSearchConfigurationArgsDict']]] = None) -> 'Graph':
        """
        Get an existing Graph resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: (String) Graph resource ARN
        :param pulumi.Input[builtins.bool] deletion_protection: Value that indicates whether the Graph has deletion protection enabled. The graph can't be deleted when deletion protection is enabled.
        :param pulumi.Input[builtins.str] endpoint: (String) The connection endpoint for the graph. For example: `g-12a3bcdef4.us-east-1.neptune-graph.amazonaws.com`
        :param pulumi.Input[builtins.str] graph_name: The graph name. For example: my-graph-1. The name must contain from 1 to 63 letters, numbers, or hyphens, and its first
               character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens. If you don't specify a graph
               name, a unique graph name is generated for you using the prefix graph-for, followed by a combination of Stack Name and a
               UUID.
        :param pulumi.Input[builtins.str] graph_name_prefix: Allows user to specify name prefix and have remainder of name automatically generated.
        :param pulumi.Input[builtins.str] kms_key_identifier: The ARN for the KMS encryption key. By Default, Neptune Analytics will use an AWS provided key ("AWS_OWNED_KEY"). This parameter is used if you want to encrypt the graph using a KMS Customer Managed Key (CMK).
        :param pulumi.Input[builtins.int] provisioned_memory: The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.bool] public_connectivity: Specifies whether the Graph can be reached over the internet. Access to all graphs requires IAM authentication.  When the Graph is publicly reachable, its Domain Name System (DNS) endpoint resolves to the public IP address from the internet.  When the Graph isn't publicly reachable, you need to create a PrivateGraphEndpoint in a given VPC to ensure the DNS name resolves to a private IP address that is reachable from the VPC.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] replica_count: Specifies the number of replicas you want when finished. All replicas will be provisioned in different availability zones.  Replica Count should always be less than or equal to 2.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value tags for the graph. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union['GraphVectorSearchConfigurationArgs', 'GraphVectorSearchConfigurationArgsDict']] vector_search_configuration: Vector Search Configuration (see below for nested schema of vector_search_configuration)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GraphState.__new__(_GraphState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["graph_name"] = graph_name
        __props__.__dict__["graph_name_prefix"] = graph_name_prefix
        __props__.__dict__["kms_key_identifier"] = kms_key_identifier
        __props__.__dict__["provisioned_memory"] = provisioned_memory
        __props__.__dict__["public_connectivity"] = public_connectivity
        __props__.__dict__["region"] = region
        __props__.__dict__["replica_count"] = replica_count
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["vector_search_configuration"] = vector_search_configuration
        return Graph(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        (String) Graph resource ARN
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[builtins.bool]:
        """
        Value that indicates whether the Graph has deletion protection enabled. The graph can't be deleted when deletion protection is enabled.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[builtins.str]:
        """
        (String) The connection endpoint for the graph. For example: `g-12a3bcdef4.us-east-1.neptune-graph.amazonaws.com`
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="graphName")
    def graph_name(self) -> pulumi.Output[builtins.str]:
        """
        The graph name. For example: my-graph-1. The name must contain from 1 to 63 letters, numbers, or hyphens, and its first
        character must be a letter. It cannot end with a hyphen or contain two consecutive hyphens. If you don't specify a graph
        name, a unique graph name is generated for you using the prefix graph-for, followed by a combination of Stack Name and a
        UUID.
        """
        return pulumi.get(self, "graph_name")

    @property
    @pulumi.getter(name="graphNamePrefix")
    def graph_name_prefix(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Allows user to specify name prefix and have remainder of name automatically generated.
        """
        return pulumi.get(self, "graph_name_prefix")

    @property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The ARN for the KMS encryption key. By Default, Neptune Analytics will use an AWS provided key ("AWS_OWNED_KEY"). This parameter is used if you want to encrypt the graph using a KMS Customer Managed Key (CMK).
        """
        return pulumi.get(self, "kms_key_identifier")

    @property
    @pulumi.getter(name="provisionedMemory")
    def provisioned_memory(self) -> pulumi.Output[builtins.int]:
        """
        The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.

        The following arguments are optional:
        """
        return pulumi.get(self, "provisioned_memory")

    @property
    @pulumi.getter(name="publicConnectivity")
    def public_connectivity(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies whether the Graph can be reached over the internet. Access to all graphs requires IAM authentication.  When the Graph is publicly reachable, its Domain Name System (DNS) endpoint resolves to the public IP address from the internet.  When the Graph isn't publicly reachable, you need to create a PrivateGraphEndpoint in a given VPC to ensure the DNS name resolves to a private IP address that is reachable from the VPC.
        """
        return pulumi.get(self, "public_connectivity")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the number of replicas you want when finished. All replicas will be provisioned in different availability zones.  Replica Count should always be less than or equal to 2.
        """
        return pulumi.get(self, "replica_count")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value tags for the graph. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.GraphTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="vectorSearchConfiguration")
    def vector_search_configuration(self) -> pulumi.Output[Optional['outputs.GraphVectorSearchConfiguration']]:
        """
        Vector Search Configuration (see below for nested schema of vector_search_configuration)
        """
        return pulumi.get(self, "vector_search_configuration")

