# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuleGroupArgs', 'RuleGroup']

@pulumi.input_type
class RuleGroupArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input[builtins.int],
                 type: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_configuration: Optional[pulumi.Input['RuleGroupEncryptionConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rule_group: Optional[pulumi.Input['RuleGroupRuleGroupArgs']] = None,
                 rules: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a RuleGroup resource.
        :param pulumi.Input[builtins.int] capacity: The maximum number of operating resources that this rule group can use. For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules. For a stateful rule group, the minimum capacity required is the number of individual rules.
        :param pulumi.Input[builtins.str] type: Whether the rule group is stateless (containing stateless rules) or stateful (containing stateful rules). Valid values include: `STATEFUL` or `STATELESS`.
        :param pulumi.Input[builtins.str] description: A friendly description of the rule group.
        :param pulumi.Input['RuleGroupEncryptionConfigurationArgs'] encryption_configuration: KMS encryption configuration settings. See Encryption Configuration below for details.
        :param pulumi.Input[builtins.str] name: A friendly name of the rule group.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['RuleGroupRuleGroupArgs'] rule_group: A configuration block that defines the rule group rules. Required unless `rules` is specified. See Rule Group below for details.
        :param pulumi.Input[builtins.str] rules: The stateful rule group rules specifications in Suricata file format, with one rule per line. Use this to import your existing Suricata compatible rule groups. Required unless `rule_group` is specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_group is not None:
            pulumi.set(__self__, "rule_group", rule_group)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[builtins.int]:
        """
        The maximum number of operating resources that this rule group can use. For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules. For a stateful rule group, the minimum capacity required is the number of individual rules.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Whether the rule group is stateless (containing stateless rules) or stateful (containing stateful rules). Valid values include: `STATEFUL` or `STATELESS`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A friendly description of the rule group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['RuleGroupEncryptionConfigurationArgs']]:
        """
        KMS encryption configuration settings. See Encryption Configuration below for details.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['RuleGroupEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A friendly name of the rule group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="ruleGroup")
    def rule_group(self) -> Optional[pulumi.Input['RuleGroupRuleGroupArgs']]:
        """
        A configuration block that defines the rule group rules. Required unless `rules` is specified. See Rule Group below for details.
        """
        return pulumi.get(self, "rule_group")

    @rule_group.setter
    def rule_group(self, value: Optional[pulumi.Input['RuleGroupRuleGroupArgs']]):
        pulumi.set(self, "rule_group", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The stateful rule group rules specifications in Suricata file format, with one rule per line. Use this to import your existing Suricata compatible rule groups. Required unless `rule_group` is specified.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RuleGroupState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 capacity: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_configuration: Optional[pulumi.Input['RuleGroupEncryptionConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rule_group: Optional[pulumi.Input['RuleGroupRuleGroupArgs']] = None,
                 rules: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 update_token: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RuleGroup resources.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) that identifies the rule group.
        :param pulumi.Input[builtins.int] capacity: The maximum number of operating resources that this rule group can use. For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules. For a stateful rule group, the minimum capacity required is the number of individual rules.
        :param pulumi.Input[builtins.str] description: A friendly description of the rule group.
        :param pulumi.Input['RuleGroupEncryptionConfigurationArgs'] encryption_configuration: KMS encryption configuration settings. See Encryption Configuration below for details.
        :param pulumi.Input[builtins.str] name: A friendly name of the rule group.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['RuleGroupRuleGroupArgs'] rule_group: A configuration block that defines the rule group rules. Required unless `rules` is specified. See Rule Group below for details.
        :param pulumi.Input[builtins.str] rules: The stateful rule group rules specifications in Suricata file format, with one rule per line. Use this to import your existing Suricata compatible rule groups. Required unless `rule_group` is specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] type: Whether the rule group is stateless (containing stateless rules) or stateful (containing stateful rules). Valid values include: `STATEFUL` or `STATELESS`.
        :param pulumi.Input[builtins.str] update_token: A string token used when updating the rule group.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_group is not None:
            pulumi.set(__self__, "rule_group", rule_group)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_token is not None:
            pulumi.set(__self__, "update_token", update_token)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) that identifies the rule group.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of operating resources that this rule group can use. For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules. For a stateful rule group, the minimum capacity required is the number of individual rules.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A friendly description of the rule group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['RuleGroupEncryptionConfigurationArgs']]:
        """
        KMS encryption configuration settings. See Encryption Configuration below for details.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['RuleGroupEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A friendly name of the rule group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="ruleGroup")
    def rule_group(self) -> Optional[pulumi.Input['RuleGroupRuleGroupArgs']]:
        """
        A configuration block that defines the rule group rules. Required unless `rules` is specified. See Rule Group below for details.
        """
        return pulumi.get(self, "rule_group")

    @rule_group.setter
    def rule_group(self, value: Optional[pulumi.Input['RuleGroupRuleGroupArgs']]):
        pulumi.set(self, "rule_group", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The stateful rule group rules specifications in Suricata file format, with one rule per line. Use this to import your existing Suricata compatible rule groups. Required unless `rule_group` is specified.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether the rule group is stateless (containing stateless rules) or stateful (containing stateful rules). Valid values include: `STATEFUL` or `STATELESS`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string token used when updating the rule group.
        """
        return pulumi.get(self, "update_token")

    @update_token.setter
    def update_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_token", value)


@pulumi.type_token("aws:networkfirewall/ruleGroup:RuleGroup")
class RuleGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['RuleGroupEncryptionConfigurationArgs', 'RuleGroupEncryptionConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rule_group: Optional[pulumi.Input[Union['RuleGroupRuleGroupArgs', 'RuleGroupRuleGroupArgsDict']]] = None,
                 rules: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides an AWS Network Firewall Rule Group Resource

        ## Example Usage

        ### Stateful Inspection for denying access to a domain

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.RuleGroup("example",
            capacity=100,
            name="example",
            type="STATEFUL",
            rule_group={
                "rules_source": {
                    "rules_source_list": {
                        "generated_rules_type": "DENYLIST",
                        "target_types": ["HTTP_HOST"],
                        "targets": ["test.example.com"],
                    },
                },
            },
            tags={
                "Tag1": "Value1",
                "Tag2": "Value2",
            })
        ```

        ### Stateful Inspection for permitting packets from a source IP address

        ```python
        import pulumi
        import pulumi_aws as aws

        ips = [
            "1.1.1.1/32",
            "1.0.0.1/32",
        ]
        example = aws.networkfirewall.RuleGroup("example",
            capacity=50,
            description="Permits http traffic from source",
            name="example",
            type="STATEFUL",
            rule_group={
                "rules_source": {
                    "stateful_rules": [{
                        "action": "PASS",
                        "header": {
                            "destination": "ANY",
                            "destination_port": "ANY",
                            "protocol": "HTTP",
                            "direction": "ANY",
                            "source_port": "ANY",
                            "source": entry["value"],
                        },
                        "rule_options": [{
                            "keyword": "sid",
                            "settings": ["1"],
                        }],
                    } for entry in [{"key": k, "value": v} for k, v in ips]],
                },
            },
            tags={
                "Name": "permit HTTP from source",
            })
        ```

        ### Stateful Inspection for blocking packets from going to an intended destination

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.RuleGroup("example",
            capacity=100,
            name="example",
            type="STATEFUL",
            rule_group={
                "rules_source": {
                    "stateful_rules": [{
                        "action": "DROP",
                        "header": {
                            "destination": "124.1.1.24/32",
                            "destination_port": "53",
                            "direction": "ANY",
                            "protocol": "TCP",
                            "source": "1.2.3.4/32",
                            "source_port": "53",
                        },
                        "rule_options": [{
                            "keyword": "sid",
                            "settings": ["1"],
                        }],
                    }],
                },
            },
            tags={
                "Tag1": "Value1",
                "Tag2": "Value2",
            })
        ```

        ### Stateful Inspection from rules specifications defined in Suricata flat format

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.networkfirewall.RuleGroup("example",
            capacity=100,
            name="example",
            type="STATEFUL",
            rules=std.file(input="example.rules").result,
            tags={
                "Tag1": "Value1",
                "Tag2": "Value2",
            })
        ```

        ### Stateful Inspection from rule group specifications using rule variables and Suricata format rules

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.networkfirewall.RuleGroup("example",
            capacity=100,
            name="example",
            type="STATEFUL",
            rule_group={
                "rule_variables": {
                    "ip_sets": [
                        {
                            "key": "WEBSERVERS_HOSTS",
                            "ip_set": {
                                "definitions": [
                                    "10.0.0.0/16",
                                    "10.0.1.0/24",
                                    "192.168.0.0/16",
                                ],
                            },
                        },
                        {
                            "key": "EXTERNAL_HOST",
                            "ip_set": {
                                "definitions": ["1.2.3.4/32"],
                            },
                        },
                    ],
                    "port_sets": [{
                        "key": "HTTP_PORTS",
                        "port_set": {
                            "definitions": [
                                "443",
                                "80",
                            ],
                        },
                    }],
                },
                "rules_source": {
                    "rules_string": std.file(input="suricata_rules_file").result,
                },
            },
            tags={
                "Tag1": "Value1",
                "Tag2": "Value2",
            })
        ```

        ### Stateless Inspection with a Custom Action

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.RuleGroup("example",
            description="Stateless Rate Limiting Rule",
            capacity=100,
            name="example",
            type="STATELESS",
            rule_group={
                "rules_source": {
                    "stateless_rules_and_custom_actions": {
                        "custom_actions": [{
                            "action_definition": {
                                "publish_metric_action": {
                                    "dimensions": [{
                                        "value": "2",
                                    }],
                                },
                            },
                            "action_name": "ExampleMetricsAction",
                        }],
                        "stateless_rules": [{
                            "priority": 1,
                            "rule_definition": {
                                "actions": [
                                    "aws:pass",
                                    "ExampleMetricsAction",
                                ],
                                "match_attributes": {
                                    "sources": [{
                                        "address_definition": "1.2.3.4/32",
                                    }],
                                    "source_ports": [{
                                        "from_port": 443,
                                        "to_port": 443,
                                    }],
                                    "destinations": [{
                                        "address_definition": "124.1.1.5/32",
                                    }],
                                    "destination_ports": [{
                                        "from_port": 443,
                                        "to_port": 443,
                                    }],
                                    "protocols": [6],
                                    "tcp_flags": [{
                                        "flags": ["SYN"],
                                        "masks": [
                                            "SYN",
                                            "ACK",
                                        ],
                                    }],
                                },
                            },
                        }],
                    },
                },
            },
            tags={
                "Tag1": "Value1",
                "Tag2": "Value2",
            })
        ```

        ### IP Set References to the Rule Group

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.RuleGroup("example",
            capacity=100,
            name="example",
            type="STATEFUL",
            rule_group={
                "rules_source": {
                    "rules_source_list": {
                        "generated_rules_type": "DENYLIST",
                        "target_types": ["HTTP_HOST"],
                        "targets": ["test.example.com"],
                    },
                },
                "reference_sets": {
                    "ip_set_references": [{
                        "key": "example",
                        "ip_set_references": [{
                            "reference_arn": this["arn"],
                        }],
                    }],
                },
            },
            tags={
                "Tag1": "Value1",
                "Tag2": "Value2",
            })
        ```

        ### Example with S3 as source for the suricata rules

        ```python
        import pulumi
        import pulumi_aws as aws

        suricata_rules = aws.s3.get_object(bucket=suricata_rules_aws_s3_bucket["id"],
            key="rules/custom.rules")
        s3_rules_example = aws.networkfirewall.RuleGroup("s3_rules_example",
            capacity=1000,
            name="my-terraform-s3-rules",
            type="STATEFUL",
            rule_group={
                "rule_variables": {
                    "ip_sets": [{
                        "key": "HOME_NET",
                        "ip_set": {
                            "definitions": [
                                "10.0.0.0/16",
                                "192.168.0.0/16",
                                "172.16.0.0/12",
                            ],
                        },
                    }],
                    "port_sets": [{
                        "key": "HTTP_PORTS",
                        "port_set": {
                            "definitions": [
                                "443",
                                "80",
                            ],
                        },
                    }],
                },
                "rules_source": {
                    "rules_string": suricata_rules.body,
                },
            },
            tags={
                "ManagedBy": "terraform",
            })
        ```

        ## Import

        Using `pulumi import`, import Network Firewall Rule Groups using their `arn`. For example:

        ```sh
        $ pulumi import aws:networkfirewall/ruleGroup:RuleGroup example arn:aws:network-firewall:us-west-1:123456789012:stateful-rulegroup/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] capacity: The maximum number of operating resources that this rule group can use. For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules. For a stateful rule group, the minimum capacity required is the number of individual rules.
        :param pulumi.Input[builtins.str] description: A friendly description of the rule group.
        :param pulumi.Input[Union['RuleGroupEncryptionConfigurationArgs', 'RuleGroupEncryptionConfigurationArgsDict']] encryption_configuration: KMS encryption configuration settings. See Encryption Configuration below for details.
        :param pulumi.Input[builtins.str] name: A friendly name of the rule group.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['RuleGroupRuleGroupArgs', 'RuleGroupRuleGroupArgsDict']] rule_group: A configuration block that defines the rule group rules. Required unless `rules` is specified. See Rule Group below for details.
        :param pulumi.Input[builtins.str] rules: The stateful rule group rules specifications in Suricata file format, with one rule per line. Use this to import your existing Suricata compatible rule groups. Required unless `rule_group` is specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] type: Whether the rule group is stateless (containing stateless rules) or stateful (containing stateful rules). Valid values include: `STATEFUL` or `STATELESS`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AWS Network Firewall Rule Group Resource

        ## Example Usage

        ### Stateful Inspection for denying access to a domain

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.RuleGroup("example",
            capacity=100,
            name="example",
            type="STATEFUL",
            rule_group={
                "rules_source": {
                    "rules_source_list": {
                        "generated_rules_type": "DENYLIST",
                        "target_types": ["HTTP_HOST"],
                        "targets": ["test.example.com"],
                    },
                },
            },
            tags={
                "Tag1": "Value1",
                "Tag2": "Value2",
            })
        ```

        ### Stateful Inspection for permitting packets from a source IP address

        ```python
        import pulumi
        import pulumi_aws as aws

        ips = [
            "1.1.1.1/32",
            "1.0.0.1/32",
        ]
        example = aws.networkfirewall.RuleGroup("example",
            capacity=50,
            description="Permits http traffic from source",
            name="example",
            type="STATEFUL",
            rule_group={
                "rules_source": {
                    "stateful_rules": [{
                        "action": "PASS",
                        "header": {
                            "destination": "ANY",
                            "destination_port": "ANY",
                            "protocol": "HTTP",
                            "direction": "ANY",
                            "source_port": "ANY",
                            "source": entry["value"],
                        },
                        "rule_options": [{
                            "keyword": "sid",
                            "settings": ["1"],
                        }],
                    } for entry in [{"key": k, "value": v} for k, v in ips]],
                },
            },
            tags={
                "Name": "permit HTTP from source",
            })
        ```

        ### Stateful Inspection for blocking packets from going to an intended destination

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.RuleGroup("example",
            capacity=100,
            name="example",
            type="STATEFUL",
            rule_group={
                "rules_source": {
                    "stateful_rules": [{
                        "action": "DROP",
                        "header": {
                            "destination": "124.1.1.24/32",
                            "destination_port": "53",
                            "direction": "ANY",
                            "protocol": "TCP",
                            "source": "1.2.3.4/32",
                            "source_port": "53",
                        },
                        "rule_options": [{
                            "keyword": "sid",
                            "settings": ["1"],
                        }],
                    }],
                },
            },
            tags={
                "Tag1": "Value1",
                "Tag2": "Value2",
            })
        ```

        ### Stateful Inspection from rules specifications defined in Suricata flat format

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.networkfirewall.RuleGroup("example",
            capacity=100,
            name="example",
            type="STATEFUL",
            rules=std.file(input="example.rules").result,
            tags={
                "Tag1": "Value1",
                "Tag2": "Value2",
            })
        ```

        ### Stateful Inspection from rule group specifications using rule variables and Suricata format rules

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.networkfirewall.RuleGroup("example",
            capacity=100,
            name="example",
            type="STATEFUL",
            rule_group={
                "rule_variables": {
                    "ip_sets": [
                        {
                            "key": "WEBSERVERS_HOSTS",
                            "ip_set": {
                                "definitions": [
                                    "10.0.0.0/16",
                                    "10.0.1.0/24",
                                    "192.168.0.0/16",
                                ],
                            },
                        },
                        {
                            "key": "EXTERNAL_HOST",
                            "ip_set": {
                                "definitions": ["1.2.3.4/32"],
                            },
                        },
                    ],
                    "port_sets": [{
                        "key": "HTTP_PORTS",
                        "port_set": {
                            "definitions": [
                                "443",
                                "80",
                            ],
                        },
                    }],
                },
                "rules_source": {
                    "rules_string": std.file(input="suricata_rules_file").result,
                },
            },
            tags={
                "Tag1": "Value1",
                "Tag2": "Value2",
            })
        ```

        ### Stateless Inspection with a Custom Action

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.RuleGroup("example",
            description="Stateless Rate Limiting Rule",
            capacity=100,
            name="example",
            type="STATELESS",
            rule_group={
                "rules_source": {
                    "stateless_rules_and_custom_actions": {
                        "custom_actions": [{
                            "action_definition": {
                                "publish_metric_action": {
                                    "dimensions": [{
                                        "value": "2",
                                    }],
                                },
                            },
                            "action_name": "ExampleMetricsAction",
                        }],
                        "stateless_rules": [{
                            "priority": 1,
                            "rule_definition": {
                                "actions": [
                                    "aws:pass",
                                    "ExampleMetricsAction",
                                ],
                                "match_attributes": {
                                    "sources": [{
                                        "address_definition": "1.2.3.4/32",
                                    }],
                                    "source_ports": [{
                                        "from_port": 443,
                                        "to_port": 443,
                                    }],
                                    "destinations": [{
                                        "address_definition": "124.1.1.5/32",
                                    }],
                                    "destination_ports": [{
                                        "from_port": 443,
                                        "to_port": 443,
                                    }],
                                    "protocols": [6],
                                    "tcp_flags": [{
                                        "flags": ["SYN"],
                                        "masks": [
                                            "SYN",
                                            "ACK",
                                        ],
                                    }],
                                },
                            },
                        }],
                    },
                },
            },
            tags={
                "Tag1": "Value1",
                "Tag2": "Value2",
            })
        ```

        ### IP Set References to the Rule Group

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.RuleGroup("example",
            capacity=100,
            name="example",
            type="STATEFUL",
            rule_group={
                "rules_source": {
                    "rules_source_list": {
                        "generated_rules_type": "DENYLIST",
                        "target_types": ["HTTP_HOST"],
                        "targets": ["test.example.com"],
                    },
                },
                "reference_sets": {
                    "ip_set_references": [{
                        "key": "example",
                        "ip_set_references": [{
                            "reference_arn": this["arn"],
                        }],
                    }],
                },
            },
            tags={
                "Tag1": "Value1",
                "Tag2": "Value2",
            })
        ```

        ### Example with S3 as source for the suricata rules

        ```python
        import pulumi
        import pulumi_aws as aws

        suricata_rules = aws.s3.get_object(bucket=suricata_rules_aws_s3_bucket["id"],
            key="rules/custom.rules")
        s3_rules_example = aws.networkfirewall.RuleGroup("s3_rules_example",
            capacity=1000,
            name="my-terraform-s3-rules",
            type="STATEFUL",
            rule_group={
                "rule_variables": {
                    "ip_sets": [{
                        "key": "HOME_NET",
                        "ip_set": {
                            "definitions": [
                                "10.0.0.0/16",
                                "192.168.0.0/16",
                                "172.16.0.0/12",
                            ],
                        },
                    }],
                    "port_sets": [{
                        "key": "HTTP_PORTS",
                        "port_set": {
                            "definitions": [
                                "443",
                                "80",
                            ],
                        },
                    }],
                },
                "rules_source": {
                    "rules_string": suricata_rules.body,
                },
            },
            tags={
                "ManagedBy": "terraform",
            })
        ```

        ## Import

        Using `pulumi import`, import Network Firewall Rule Groups using their `arn`. For example:

        ```sh
        $ pulumi import aws:networkfirewall/ruleGroup:RuleGroup example arn:aws:network-firewall:us-west-1:123456789012:stateful-rulegroup/example
        ```

        :param str resource_name: The name of the resource.
        :param RuleGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['RuleGroupEncryptionConfigurationArgs', 'RuleGroupEncryptionConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rule_group: Optional[pulumi.Input[Union['RuleGroupRuleGroupArgs', 'RuleGroupRuleGroupArgsDict']]] = None,
                 rules: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleGroupArgs.__new__(RuleGroupArgs)

            if capacity is None and not opts.urn:
                raise TypeError("Missing required property 'capacity'")
            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["description"] = description
            __props__.__dict__["encryption_configuration"] = encryption_configuration
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["rule_group"] = rule_group
            __props__.__dict__["rules"] = rules
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["update_token"] = None
        super(RuleGroup, __self__).__init__(
            'aws:networkfirewall/ruleGroup:RuleGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            capacity: Optional[pulumi.Input[builtins.int]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            encryption_configuration: Optional[pulumi.Input[Union['RuleGroupEncryptionConfigurationArgs', 'RuleGroupEncryptionConfigurationArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            rule_group: Optional[pulumi.Input[Union['RuleGroupRuleGroupArgs', 'RuleGroupRuleGroupArgsDict']]] = None,
            rules: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            update_token: Optional[pulumi.Input[builtins.str]] = None) -> 'RuleGroup':
        """
        Get an existing RuleGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) that identifies the rule group.
        :param pulumi.Input[builtins.int] capacity: The maximum number of operating resources that this rule group can use. For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules. For a stateful rule group, the minimum capacity required is the number of individual rules.
        :param pulumi.Input[builtins.str] description: A friendly description of the rule group.
        :param pulumi.Input[Union['RuleGroupEncryptionConfigurationArgs', 'RuleGroupEncryptionConfigurationArgsDict']] encryption_configuration: KMS encryption configuration settings. See Encryption Configuration below for details.
        :param pulumi.Input[builtins.str] name: A friendly name of the rule group.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['RuleGroupRuleGroupArgs', 'RuleGroupRuleGroupArgsDict']] rule_group: A configuration block that defines the rule group rules. Required unless `rules` is specified. See Rule Group below for details.
        :param pulumi.Input[builtins.str] rules: The stateful rule group rules specifications in Suricata file format, with one rule per line. Use this to import your existing Suricata compatible rule groups. Required unless `rule_group` is specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] type: Whether the rule group is stateless (containing stateless rules) or stateful (containing stateful rules). Valid values include: `STATEFUL` or `STATELESS`.
        :param pulumi.Input[builtins.str] update_token: A string token used when updating the rule group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleGroupState.__new__(_RuleGroupState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["description"] = description
        __props__.__dict__["encryption_configuration"] = encryption_configuration
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["rule_group"] = rule_group
        __props__.__dict__["rules"] = rules
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["type"] = type
        __props__.__dict__["update_token"] = update_token
        return RuleGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) that identifies the rule group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[builtins.int]:
        """
        The maximum number of operating resources that this rule group can use. For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules. For a stateful rule group, the minimum capacity required is the number of individual rules.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A friendly description of the rule group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> pulumi.Output[Optional['outputs.RuleGroupEncryptionConfiguration']]:
        """
        KMS encryption configuration settings. See Encryption Configuration below for details.
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A friendly name of the rule group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="ruleGroup")
    def rule_group(self) -> pulumi.Output['outputs.RuleGroupRuleGroup']:
        """
        A configuration block that defines the rule group rules. Required unless `rules` is specified. See Rule Group below for details.
        """
        return pulumi.get(self, "rule_group")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The stateful rule group rules specifications in Suricata file format, with one rule per line. Use this to import your existing Suricata compatible rule groups. Required unless `rule_group` is specified.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Whether the rule group is stateless (containing stateless rules) or stateful (containing stateful rules). Valid values include: `STATEFUL` or `STATELESS`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> pulumi.Output[builtins.str]:
        """
        A string token used when updating the rule group.
        """
        return pulumi.get(self, "update_token")

