# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TlsInspectionConfigurationArgs', 'TlsInspectionConfiguration']

@pulumi.input_type
class TlsInspectionConfigurationArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['TlsInspectionConfigurationEncryptionConfigurationArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['TlsInspectionConfigurationTimeoutsArgs']] = None,
                 tls_inspection_configuration: Optional[pulumi.Input['TlsInspectionConfigurationTlsInspectionConfigurationArgs']] = None):
        """
        The set of arguments for constructing a TlsInspectionConfiguration resource.
        :param pulumi.Input[builtins.str] description: Description of the TLS inspection configuration.
        :param pulumi.Input[Sequence[pulumi.Input['TlsInspectionConfigurationEncryptionConfigurationArgs']]] encryption_configurations: Encryption configuration block. Detailed below.
        :param pulumi.Input[builtins.str] name: Descriptive name of the TLS inspection configuration.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['TlsInspectionConfigurationTlsInspectionConfigurationArgs'] tls_inspection_configuration: TLS inspection configuration block. Detailed below.
               
               The following arguments are optional:
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_configurations is not None:
            pulumi.set(__self__, "encryption_configurations", encryption_configurations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if tls_inspection_configuration is not None:
            pulumi.set(__self__, "tls_inspection_configuration", tls_inspection_configuration)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the TLS inspection configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptionConfigurations")
    def encryption_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TlsInspectionConfigurationEncryptionConfigurationArgs']]]]:
        """
        Encryption configuration block. Detailed below.
        """
        return pulumi.get(self, "encryption_configurations")

    @encryption_configurations.setter
    def encryption_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TlsInspectionConfigurationEncryptionConfigurationArgs']]]]):
        pulumi.set(self, "encryption_configurations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Descriptive name of the TLS inspection configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['TlsInspectionConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['TlsInspectionConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="tlsInspectionConfiguration")
    def tls_inspection_configuration(self) -> Optional[pulumi.Input['TlsInspectionConfigurationTlsInspectionConfigurationArgs']]:
        """
        TLS inspection configuration block. Detailed below.

        The following arguments are optional:
        """
        return pulumi.get(self, "tls_inspection_configuration")

    @tls_inspection_configuration.setter
    def tls_inspection_configuration(self, value: Optional[pulumi.Input['TlsInspectionConfigurationTlsInspectionConfigurationArgs']]):
        pulumi.set(self, "tls_inspection_configuration", value)


@pulumi.input_type
class _TlsInspectionConfigurationState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_authorities: Optional[pulumi.Input[Sequence[pulumi.Input['TlsInspectionConfigurationCertificateAuthorityArgs']]]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input['TlsInspectionConfigurationCertificateArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['TlsInspectionConfigurationEncryptionConfigurationArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 number_of_associations: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['TlsInspectionConfigurationTimeoutsArgs']] = None,
                 tls_inspection_configuration: Optional[pulumi.Input['TlsInspectionConfigurationTlsInspectionConfigurationArgs']] = None,
                 tls_inspection_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 update_token: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering TlsInspectionConfiguration resources.
        :param pulumi.Input[builtins.str] arn: ARN of the TLS Inspection Configuration.
        :param pulumi.Input[Sequence[pulumi.Input['TlsInspectionConfigurationCertificateAuthorityArgs']]] certificate_authorities: Certificate Manager certificate block. See Certificate Authority below for details.
        :param pulumi.Input[Sequence[pulumi.Input['TlsInspectionConfigurationCertificateArgs']]] certificates: List of certificate blocks describing certificates associated with the TLS inspection configuration. See Certificates below for details.
        :param pulumi.Input[builtins.str] description: Description of the TLS inspection configuration.
        :param pulumi.Input[Sequence[pulumi.Input['TlsInspectionConfigurationEncryptionConfigurationArgs']]] encryption_configurations: Encryption configuration block. Detailed below.
        :param pulumi.Input[builtins.str] name: Descriptive name of the TLS inspection configuration.
        :param pulumi.Input[builtins.int] number_of_associations: Number of firewall policies that use this TLS inspection configuration.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['TlsInspectionConfigurationTlsInspectionConfigurationArgs'] tls_inspection_configuration: TLS inspection configuration block. Detailed below.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] tls_inspection_configuration_id: A unique identifier for the TLS inspection configuration.
        :param pulumi.Input[builtins.str] update_token: String token used when updating the rule group.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if certificate_authorities is not None:
            pulumi.set(__self__, "certificate_authorities", certificate_authorities)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_configurations is not None:
            pulumi.set(__self__, "encryption_configurations", encryption_configurations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_associations is not None:
            pulumi.set(__self__, "number_of_associations", number_of_associations)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if tls_inspection_configuration is not None:
            pulumi.set(__self__, "tls_inspection_configuration", tls_inspection_configuration)
        if tls_inspection_configuration_id is not None:
            pulumi.set(__self__, "tls_inspection_configuration_id", tls_inspection_configuration_id)
        if update_token is not None:
            pulumi.set(__self__, "update_token", update_token)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the TLS Inspection Configuration.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="certificateAuthorities")
    def certificate_authorities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TlsInspectionConfigurationCertificateAuthorityArgs']]]]:
        """
        Certificate Manager certificate block. See Certificate Authority below for details.
        """
        return pulumi.get(self, "certificate_authorities")

    @certificate_authorities.setter
    def certificate_authorities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TlsInspectionConfigurationCertificateAuthorityArgs']]]]):
        pulumi.set(self, "certificate_authorities", value)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TlsInspectionConfigurationCertificateArgs']]]]:
        """
        List of certificate blocks describing certificates associated with the TLS inspection configuration. See Certificates below for details.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TlsInspectionConfigurationCertificateArgs']]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the TLS inspection configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptionConfigurations")
    def encryption_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TlsInspectionConfigurationEncryptionConfigurationArgs']]]]:
        """
        Encryption configuration block. Detailed below.
        """
        return pulumi.get(self, "encryption_configurations")

    @encryption_configurations.setter
    def encryption_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TlsInspectionConfigurationEncryptionConfigurationArgs']]]]):
        pulumi.set(self, "encryption_configurations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Descriptive name of the TLS inspection configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfAssociations")
    def number_of_associations(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of firewall policies that use this TLS inspection configuration.
        """
        return pulumi.get(self, "number_of_associations")

    @number_of_associations.setter
    def number_of_associations(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "number_of_associations", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['TlsInspectionConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['TlsInspectionConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="tlsInspectionConfiguration")
    def tls_inspection_configuration(self) -> Optional[pulumi.Input['TlsInspectionConfigurationTlsInspectionConfigurationArgs']]:
        """
        TLS inspection configuration block. Detailed below.

        The following arguments are optional:
        """
        return pulumi.get(self, "tls_inspection_configuration")

    @tls_inspection_configuration.setter
    def tls_inspection_configuration(self, value: Optional[pulumi.Input['TlsInspectionConfigurationTlsInspectionConfigurationArgs']]):
        pulumi.set(self, "tls_inspection_configuration", value)

    @property
    @pulumi.getter(name="tlsInspectionConfigurationId")
    def tls_inspection_configuration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier for the TLS inspection configuration.
        """
        return pulumi.get(self, "tls_inspection_configuration_id")

    @tls_inspection_configuration_id.setter
    def tls_inspection_configuration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tls_inspection_configuration_id", value)

    @property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        String token used when updating the rule group.
        """
        return pulumi.get(self, "update_token")

    @update_token.setter
    def update_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_token", value)


@pulumi.type_token("aws:networkfirewall/tlsInspectionConfiguration:TlsInspectionConfiguration")
class TlsInspectionConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TlsInspectionConfigurationEncryptionConfigurationArgs', 'TlsInspectionConfigurationEncryptionConfigurationArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['TlsInspectionConfigurationTimeoutsArgs', 'TlsInspectionConfigurationTimeoutsArgsDict']]] = None,
                 tls_inspection_configuration: Optional[pulumi.Input[Union['TlsInspectionConfigurationTlsInspectionConfigurationArgs', 'TlsInspectionConfigurationTlsInspectionConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Network Firewall TLS Inspection Configuration.

        ## Example Usage

        > **NOTE:** You must configure either inbound inspection, outbound inspection, or both.

        ### Basic inbound/ingress inspection

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.TlsInspectionConfiguration("example",
            name="example",
            description="example",
            encryption_configurations=[{
                "key_id": "AWS_OWNED_KMS_KEY",
                "type": "AWS_OWNED_KMS_KEY",
            }],
            tls_inspection_configuration={
                "server_certificate_configuration": {
                    "server_certificates": [{
                        "resource_arn": example1["arn"],
                    }],
                    "scopes": [{
                        "protocols": [6],
                        "destination_ports": [{
                            "from_port": 443,
                            "to_port": 443,
                        }],
                        "destinations": [{
                            "address_definition": "0.0.0.0/0",
                        }],
                        "source_ports": [{
                            "from_port": 0,
                            "to_port": 65535,
                        }],
                        "sources": [{
                            "address_definition": "0.0.0.0/0",
                        }],
                    }],
                },
            })
        ```

        ### Basic outbound/engress inspection

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.TlsInspectionConfiguration("example",
            name="example",
            description="example",
            encryption_configurations=[{
                "key_id": "AWS_OWNED_KMS_KEY",
                "type": "AWS_OWNED_KMS_KEY",
            }],
            tls_inspection_configuration={
                "server_certificate_configuration": {
                    "certificate_authority_arn": example1["arn"],
                    "check_certificate_revocation_status": {
                        "revoked_status_action": "REJECT",
                        "unknown_status_action": "PASS",
                    },
                    "scopes": [{
                        "protocols": [6],
                        "destination_ports": [{
                            "from_port": 443,
                            "to_port": 443,
                        }],
                        "destinations": [{
                            "address_definition": "0.0.0.0/0",
                        }],
                        "source_ports": [{
                            "from_port": 0,
                            "to_port": 65535,
                        }],
                        "sources": [{
                            "address_definition": "0.0.0.0/0",
                        }],
                    }],
                },
            })
        ```

        ### Inbound with encryption configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="example",
            deletion_window_in_days=7)
        example_tls_inspection_configuration = aws.networkfirewall.TlsInspectionConfiguration("example",
            name="example",
            description="example",
            encryption_configurations=[{
                "key_id": example.arn,
                "type": "CUSTOMER_KMS",
            }],
            tls_inspection_configuration={
                "server_certificate_configuration": {
                    "server_certificates": [{
                        "resource_arn": example1["arn"],
                    }],
                    "scopes": [{
                        "protocols": [6],
                        "destination_ports": [{
                            "from_port": 443,
                            "to_port": 443,
                        }],
                        "destinations": [{
                            "address_definition": "0.0.0.0/0",
                        }],
                        "source_ports": [{
                            "from_port": 0,
                            "to_port": 65535,
                        }],
                        "sources": [{
                            "address_definition": "0.0.0.0/0",
                        }],
                    }],
                },
            })
        ```

        ### Combined inbound and outbound

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.TlsInspectionConfiguration("example",
            name="example",
            description="example",
            encryption_configurations=[{
                "key_id": "AWS_OWNED_KMS_KEY",
                "type": "AWS_OWNED_KMS_KEY",
            }],
            tls_inspection_configuration={
                "server_certificate_configuration": {
                    "certificate_authority_arn": example1["arn"],
                    "check_certificate_revocation_status": {
                        "revoked_status_action": "REJECT",
                        "unknown_status_action": "PASS",
                    },
                    "server_certificates": [{
                        "resource_arn": example2["arn"],
                    }],
                    "scopes": [{
                        "protocols": [6],
                        "destination_ports": [{
                            "from_port": 443,
                            "to_port": 443,
                        }],
                        "destinations": [{
                            "address_definition": "0.0.0.0/0",
                        }],
                        "source_ports": [{
                            "from_port": 0,
                            "to_port": 65535,
                        }],
                        "sources": [{
                            "address_definition": "0.0.0.0/0",
                        }],
                    }],
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Network Firewall TLS Inspection Configuration using the `arn`. For example:

        ```sh
        $ pulumi import aws:networkfirewall/tlsInspectionConfiguration:TlsInspectionConfiguration example arn:aws:network-firewall::<region>:<account_id>:tls-configuration/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description of the TLS inspection configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TlsInspectionConfigurationEncryptionConfigurationArgs', 'TlsInspectionConfigurationEncryptionConfigurationArgsDict']]]] encryption_configurations: Encryption configuration block. Detailed below.
        :param pulumi.Input[builtins.str] name: Descriptive name of the TLS inspection configuration.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['TlsInspectionConfigurationTlsInspectionConfigurationArgs', 'TlsInspectionConfigurationTlsInspectionConfigurationArgsDict']] tls_inspection_configuration: TLS inspection configuration block. Detailed below.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TlsInspectionConfigurationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Network Firewall TLS Inspection Configuration.

        ## Example Usage

        > **NOTE:** You must configure either inbound inspection, outbound inspection, or both.

        ### Basic inbound/ingress inspection

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.TlsInspectionConfiguration("example",
            name="example",
            description="example",
            encryption_configurations=[{
                "key_id": "AWS_OWNED_KMS_KEY",
                "type": "AWS_OWNED_KMS_KEY",
            }],
            tls_inspection_configuration={
                "server_certificate_configuration": {
                    "server_certificates": [{
                        "resource_arn": example1["arn"],
                    }],
                    "scopes": [{
                        "protocols": [6],
                        "destination_ports": [{
                            "from_port": 443,
                            "to_port": 443,
                        }],
                        "destinations": [{
                            "address_definition": "0.0.0.0/0",
                        }],
                        "source_ports": [{
                            "from_port": 0,
                            "to_port": 65535,
                        }],
                        "sources": [{
                            "address_definition": "0.0.0.0/0",
                        }],
                    }],
                },
            })
        ```

        ### Basic outbound/engress inspection

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.TlsInspectionConfiguration("example",
            name="example",
            description="example",
            encryption_configurations=[{
                "key_id": "AWS_OWNED_KMS_KEY",
                "type": "AWS_OWNED_KMS_KEY",
            }],
            tls_inspection_configuration={
                "server_certificate_configuration": {
                    "certificate_authority_arn": example1["arn"],
                    "check_certificate_revocation_status": {
                        "revoked_status_action": "REJECT",
                        "unknown_status_action": "PASS",
                    },
                    "scopes": [{
                        "protocols": [6],
                        "destination_ports": [{
                            "from_port": 443,
                            "to_port": 443,
                        }],
                        "destinations": [{
                            "address_definition": "0.0.0.0/0",
                        }],
                        "source_ports": [{
                            "from_port": 0,
                            "to_port": 65535,
                        }],
                        "sources": [{
                            "address_definition": "0.0.0.0/0",
                        }],
                    }],
                },
            })
        ```

        ### Inbound with encryption configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example",
            description="example",
            deletion_window_in_days=7)
        example_tls_inspection_configuration = aws.networkfirewall.TlsInspectionConfiguration("example",
            name="example",
            description="example",
            encryption_configurations=[{
                "key_id": example.arn,
                "type": "CUSTOMER_KMS",
            }],
            tls_inspection_configuration={
                "server_certificate_configuration": {
                    "server_certificates": [{
                        "resource_arn": example1["arn"],
                    }],
                    "scopes": [{
                        "protocols": [6],
                        "destination_ports": [{
                            "from_port": 443,
                            "to_port": 443,
                        }],
                        "destinations": [{
                            "address_definition": "0.0.0.0/0",
                        }],
                        "source_ports": [{
                            "from_port": 0,
                            "to_port": 65535,
                        }],
                        "sources": [{
                            "address_definition": "0.0.0.0/0",
                        }],
                    }],
                },
            })
        ```

        ### Combined inbound and outbound

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.TlsInspectionConfiguration("example",
            name="example",
            description="example",
            encryption_configurations=[{
                "key_id": "AWS_OWNED_KMS_KEY",
                "type": "AWS_OWNED_KMS_KEY",
            }],
            tls_inspection_configuration={
                "server_certificate_configuration": {
                    "certificate_authority_arn": example1["arn"],
                    "check_certificate_revocation_status": {
                        "revoked_status_action": "REJECT",
                        "unknown_status_action": "PASS",
                    },
                    "server_certificates": [{
                        "resource_arn": example2["arn"],
                    }],
                    "scopes": [{
                        "protocols": [6],
                        "destination_ports": [{
                            "from_port": 443,
                            "to_port": 443,
                        }],
                        "destinations": [{
                            "address_definition": "0.0.0.0/0",
                        }],
                        "source_ports": [{
                            "from_port": 0,
                            "to_port": 65535,
                        }],
                        "sources": [{
                            "address_definition": "0.0.0.0/0",
                        }],
                    }],
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Network Firewall TLS Inspection Configuration using the `arn`. For example:

        ```sh
        $ pulumi import aws:networkfirewall/tlsInspectionConfiguration:TlsInspectionConfiguration example arn:aws:network-firewall::<region>:<account_id>:tls-configuration/example
        ```

        :param str resource_name: The name of the resource.
        :param TlsInspectionConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TlsInspectionConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TlsInspectionConfigurationEncryptionConfigurationArgs', 'TlsInspectionConfigurationEncryptionConfigurationArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['TlsInspectionConfigurationTimeoutsArgs', 'TlsInspectionConfigurationTimeoutsArgsDict']]] = None,
                 tls_inspection_configuration: Optional[pulumi.Input[Union['TlsInspectionConfigurationTlsInspectionConfigurationArgs', 'TlsInspectionConfigurationTlsInspectionConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TlsInspectionConfigurationArgs.__new__(TlsInspectionConfigurationArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["encryption_configurations"] = encryption_configurations
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["tls_inspection_configuration"] = tls_inspection_configuration
            __props__.__dict__["arn"] = None
            __props__.__dict__["certificate_authorities"] = None
            __props__.__dict__["certificates"] = None
            __props__.__dict__["number_of_associations"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["tls_inspection_configuration_id"] = None
            __props__.__dict__["update_token"] = None
        super(TlsInspectionConfiguration, __self__).__init__(
            'aws:networkfirewall/tlsInspectionConfiguration:TlsInspectionConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            certificate_authorities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TlsInspectionConfigurationCertificateAuthorityArgs', 'TlsInspectionConfigurationCertificateAuthorityArgsDict']]]]] = None,
            certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TlsInspectionConfigurationCertificateArgs', 'TlsInspectionConfigurationCertificateArgsDict']]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            encryption_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TlsInspectionConfigurationEncryptionConfigurationArgs', 'TlsInspectionConfigurationEncryptionConfigurationArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            number_of_associations: Optional[pulumi.Input[builtins.int]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['TlsInspectionConfigurationTimeoutsArgs', 'TlsInspectionConfigurationTimeoutsArgsDict']]] = None,
            tls_inspection_configuration: Optional[pulumi.Input[Union['TlsInspectionConfigurationTlsInspectionConfigurationArgs', 'TlsInspectionConfigurationTlsInspectionConfigurationArgsDict']]] = None,
            tls_inspection_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
            update_token: Optional[pulumi.Input[builtins.str]] = None) -> 'TlsInspectionConfiguration':
        """
        Get an existing TlsInspectionConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the TLS Inspection Configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TlsInspectionConfigurationCertificateAuthorityArgs', 'TlsInspectionConfigurationCertificateAuthorityArgsDict']]]] certificate_authorities: Certificate Manager certificate block. See Certificate Authority below for details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TlsInspectionConfigurationCertificateArgs', 'TlsInspectionConfigurationCertificateArgsDict']]]] certificates: List of certificate blocks describing certificates associated with the TLS inspection configuration. See Certificates below for details.
        :param pulumi.Input[builtins.str] description: Description of the TLS inspection configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TlsInspectionConfigurationEncryptionConfigurationArgs', 'TlsInspectionConfigurationEncryptionConfigurationArgsDict']]]] encryption_configurations: Encryption configuration block. Detailed below.
        :param pulumi.Input[builtins.str] name: Descriptive name of the TLS inspection configuration.
        :param pulumi.Input[builtins.int] number_of_associations: Number of firewall policies that use this TLS inspection configuration.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['TlsInspectionConfigurationTlsInspectionConfigurationArgs', 'TlsInspectionConfigurationTlsInspectionConfigurationArgsDict']] tls_inspection_configuration: TLS inspection configuration block. Detailed below.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] tls_inspection_configuration_id: A unique identifier for the TLS inspection configuration.
        :param pulumi.Input[builtins.str] update_token: String token used when updating the rule group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TlsInspectionConfigurationState.__new__(_TlsInspectionConfigurationState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["certificate_authorities"] = certificate_authorities
        __props__.__dict__["certificates"] = certificates
        __props__.__dict__["description"] = description
        __props__.__dict__["encryption_configurations"] = encryption_configurations
        __props__.__dict__["name"] = name
        __props__.__dict__["number_of_associations"] = number_of_associations
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["tls_inspection_configuration"] = tls_inspection_configuration
        __props__.__dict__["tls_inspection_configuration_id"] = tls_inspection_configuration_id
        __props__.__dict__["update_token"] = update_token
        return TlsInspectionConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the TLS Inspection Configuration.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="certificateAuthorities")
    def certificate_authorities(self) -> pulumi.Output[Sequence['outputs.TlsInspectionConfigurationCertificateAuthority']]:
        """
        Certificate Manager certificate block. See Certificate Authority below for details.
        """
        return pulumi.get(self, "certificate_authorities")

    @property
    @pulumi.getter
    def certificates(self) -> pulumi.Output[Sequence['outputs.TlsInspectionConfigurationCertificate']]:
        """
        List of certificate blocks describing certificates associated with the TLS inspection configuration. See Certificates below for details.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the TLS inspection configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptionConfigurations")
    def encryption_configurations(self) -> pulumi.Output[Sequence['outputs.TlsInspectionConfigurationEncryptionConfiguration']]:
        """
        Encryption configuration block. Detailed below.
        """
        return pulumi.get(self, "encryption_configurations")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Descriptive name of the TLS inspection configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfAssociations")
    def number_of_associations(self) -> pulumi.Output[builtins.int]:
        """
        Number of firewall policies that use this TLS inspection configuration.
        """
        return pulumi.get(self, "number_of_associations")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.TlsInspectionConfigurationTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="tlsInspectionConfiguration")
    def tls_inspection_configuration(self) -> pulumi.Output[Optional['outputs.TlsInspectionConfigurationTlsInspectionConfiguration']]:
        """
        TLS inspection configuration block. Detailed below.

        The following arguments are optional:
        """
        return pulumi.get(self, "tls_inspection_configuration")

    @property
    @pulumi.getter(name="tlsInspectionConfigurationId")
    def tls_inspection_configuration_id(self) -> pulumi.Output[builtins.str]:
        """
        A unique identifier for the TLS inspection configuration.
        """
        return pulumi.get(self, "tls_inspection_configuration_id")

    @property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> pulumi.Output[builtins.str]:
        """
        String token used when updating the rule group.
        """
        return pulumi.get(self, "update_token")

