# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ConnectAttachmentOptionsArgs',
    'ConnectAttachmentOptionsArgsDict',
    'ConnectPeerBgpOptionsArgs',
    'ConnectPeerBgpOptionsArgsDict',
    'ConnectPeerConfigurationArgs',
    'ConnectPeerConfigurationArgsDict',
    'ConnectPeerConfigurationBgpConfigurationArgs',
    'ConnectPeerConfigurationBgpConfigurationArgsDict',
    'CoreNetworkEdgeArgs',
    'CoreNetworkEdgeArgsDict',
    'CoreNetworkSegmentArgs',
    'CoreNetworkSegmentArgsDict',
    'DeviceAwsLocationArgs',
    'DeviceAwsLocationArgsDict',
    'DeviceLocationArgs',
    'DeviceLocationArgsDict',
    'DxGatewayAttachmentTimeoutsArgs',
    'DxGatewayAttachmentTimeoutsArgsDict',
    'LinkBandwidthArgs',
    'LinkBandwidthArgsDict',
    'SiteLocationArgs',
    'SiteLocationArgsDict',
    'VpcAttachmentOptionsArgs',
    'VpcAttachmentOptionsArgsDict',
    'GetCoreNetworkPolicyDocumentAttachmentPolicyArgs',
    'GetCoreNetworkPolicyDocumentAttachmentPolicyArgsDict',
    'GetCoreNetworkPolicyDocumentAttachmentPolicyActionArgs',
    'GetCoreNetworkPolicyDocumentAttachmentPolicyActionArgsDict',
    'GetCoreNetworkPolicyDocumentAttachmentPolicyConditionArgs',
    'GetCoreNetworkPolicyDocumentAttachmentPolicyConditionArgsDict',
    'GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs',
    'GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgsDict',
    'GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs',
    'GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgsDict',
    'GetCoreNetworkPolicyDocumentNetworkFunctionGroupArgs',
    'GetCoreNetworkPolicyDocumentNetworkFunctionGroupArgsDict',
    'GetCoreNetworkPolicyDocumentSegmentArgs',
    'GetCoreNetworkPolicyDocumentSegmentArgsDict',
    'GetCoreNetworkPolicyDocumentSegmentActionArgs',
    'GetCoreNetworkPolicyDocumentSegmentActionArgsDict',
    'GetCoreNetworkPolicyDocumentSegmentActionViaArgs',
    'GetCoreNetworkPolicyDocumentSegmentActionViaArgsDict',
    'GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverrideArgs',
    'GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverrideArgsDict',
    'GetCoreNetworkPolicyDocumentSegmentActionWhenSentToArgs',
    'GetCoreNetworkPolicyDocumentSegmentActionWhenSentToArgsDict',
]

MYPY = False

if not MYPY:
    class ConnectAttachmentOptionsArgsDict(TypedDict):
        protocol: NotRequired[pulumi.Input[builtins.str]]
        """
        Protocol used for the attachment connection. Valid values: `GRE`, `NO_ENCAP`.
        """
elif False:
    ConnectAttachmentOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectAttachmentOptionsArgs:
    def __init__(__self__, *,
                 protocol: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] protocol: Protocol used for the attachment connection. Valid values: `GRE`, `NO_ENCAP`.
        """
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Protocol used for the attachment connection. Valid values: `GRE`, `NO_ENCAP`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)


if not MYPY:
    class ConnectPeerBgpOptionsArgsDict(TypedDict):
        peer_asn: NotRequired[pulumi.Input[builtins.int]]
        """
        Peer ASN.
        """
elif False:
    ConnectPeerBgpOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectPeerBgpOptionsArgs:
    def __init__(__self__, *,
                 peer_asn: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] peer_asn: Peer ASN.
        """
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Peer ASN.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "peer_asn", value)


if not MYPY:
    class ConnectPeerConfigurationArgsDict(TypedDict):
        bgp_configurations: NotRequired[pulumi.Input[Sequence[pulumi.Input['ConnectPeerConfigurationBgpConfigurationArgsDict']]]]
        core_network_address: NotRequired[pulumi.Input[builtins.str]]
        """
        Connect peer core network address.
        """
        inside_cidr_blocks: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Inside IP addresses used for BGP peering. Required when the Connect attachment protocol is `GRE`. See `networkmanager.ConnectAttachment` for details.
        """
        peer_address: NotRequired[pulumi.Input[builtins.str]]
        """
        Connect peer address.

        The following arguments are optional:
        """
        protocol: NotRequired[pulumi.Input[builtins.str]]
elif False:
    ConnectPeerConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectPeerConfigurationArgs:
    def __init__(__self__, *,
                 bgp_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectPeerConfigurationBgpConfigurationArgs']]]] = None,
                 core_network_address: Optional[pulumi.Input[builtins.str]] = None,
                 inside_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 peer_address: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] core_network_address: Connect peer core network address.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] inside_cidr_blocks: Inside IP addresses used for BGP peering. Required when the Connect attachment protocol is `GRE`. See `networkmanager.ConnectAttachment` for details.
        :param pulumi.Input[builtins.str] peer_address: Connect peer address.
               
               The following arguments are optional:
        """
        if bgp_configurations is not None:
            pulumi.set(__self__, "bgp_configurations", bgp_configurations)
        if core_network_address is not None:
            pulumi.set(__self__, "core_network_address", core_network_address)
        if inside_cidr_blocks is not None:
            pulumi.set(__self__, "inside_cidr_blocks", inside_cidr_blocks)
        if peer_address is not None:
            pulumi.set(__self__, "peer_address", peer_address)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="bgpConfigurations")
    def bgp_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectPeerConfigurationBgpConfigurationArgs']]]]:
        return pulumi.get(self, "bgp_configurations")

    @bgp_configurations.setter
    def bgp_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectPeerConfigurationBgpConfigurationArgs']]]]):
        pulumi.set(self, "bgp_configurations", value)

    @property
    @pulumi.getter(name="coreNetworkAddress")
    def core_network_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Connect peer core network address.
        """
        return pulumi.get(self, "core_network_address")

    @core_network_address.setter
    def core_network_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "core_network_address", value)

    @property
    @pulumi.getter(name="insideCidrBlocks")
    def inside_cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Inside IP addresses used for BGP peering. Required when the Connect attachment protocol is `GRE`. See `networkmanager.ConnectAttachment` for details.
        """
        return pulumi.get(self, "inside_cidr_blocks")

    @inside_cidr_blocks.setter
    def inside_cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "inside_cidr_blocks", value)

    @property
    @pulumi.getter(name="peerAddress")
    def peer_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Connect peer address.

        The following arguments are optional:
        """
        return pulumi.get(self, "peer_address")

    @peer_address.setter
    def peer_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_address", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)


if not MYPY:
    class ConnectPeerConfigurationBgpConfigurationArgsDict(TypedDict):
        core_network_address: NotRequired[pulumi.Input[builtins.str]]
        """
        Connect peer core network address.
        """
        core_network_asn: NotRequired[pulumi.Input[builtins.int]]
        peer_address: NotRequired[pulumi.Input[builtins.str]]
        """
        Connect peer address.

        The following arguments are optional:
        """
        peer_asn: NotRequired[pulumi.Input[builtins.int]]
        """
        Peer ASN.
        """
elif False:
    ConnectPeerConfigurationBgpConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectPeerConfigurationBgpConfigurationArgs:
    def __init__(__self__, *,
                 core_network_address: Optional[pulumi.Input[builtins.str]] = None,
                 core_network_asn: Optional[pulumi.Input[builtins.int]] = None,
                 peer_address: Optional[pulumi.Input[builtins.str]] = None,
                 peer_asn: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] core_network_address: Connect peer core network address.
        :param pulumi.Input[builtins.str] peer_address: Connect peer address.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.int] peer_asn: Peer ASN.
        """
        if core_network_address is not None:
            pulumi.set(__self__, "core_network_address", core_network_address)
        if core_network_asn is not None:
            pulumi.set(__self__, "core_network_asn", core_network_asn)
        if peer_address is not None:
            pulumi.set(__self__, "peer_address", peer_address)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)

    @property
    @pulumi.getter(name="coreNetworkAddress")
    def core_network_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Connect peer core network address.
        """
        return pulumi.get(self, "core_network_address")

    @core_network_address.setter
    def core_network_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "core_network_address", value)

    @property
    @pulumi.getter(name="coreNetworkAsn")
    def core_network_asn(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "core_network_asn")

    @core_network_asn.setter
    def core_network_asn(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "core_network_asn", value)

    @property
    @pulumi.getter(name="peerAddress")
    def peer_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Connect peer address.

        The following arguments are optional:
        """
        return pulumi.get(self, "peer_address")

    @peer_address.setter
    def peer_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peer_address", value)

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Peer ASN.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "peer_asn", value)


if not MYPY:
    class CoreNetworkEdgeArgsDict(TypedDict):
        asn: NotRequired[pulumi.Input[builtins.int]]
        """
        ASN of a core network edge.
        """
        edge_location: NotRequired[pulumi.Input[builtins.str]]
        """
        Region where a core network edge is located.
        """
        inside_cidr_blocks: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Inside IP addresses used for core network edges.
        """
elif False:
    CoreNetworkEdgeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreNetworkEdgeArgs:
    def __init__(__self__, *,
                 asn: Optional[pulumi.Input[builtins.int]] = None,
                 edge_location: Optional[pulumi.Input[builtins.str]] = None,
                 inside_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.int] asn: ASN of a core network edge.
        :param pulumi.Input[builtins.str] edge_location: Region where a core network edge is located.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] inside_cidr_blocks: Inside IP addresses used for core network edges.
        """
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if edge_location is not None:
            pulumi.set(__self__, "edge_location", edge_location)
        if inside_cidr_blocks is not None:
            pulumi.set(__self__, "inside_cidr_blocks", inside_cidr_blocks)

    @property
    @pulumi.getter
    def asn(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ASN of a core network edge.
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "asn", value)

    @property
    @pulumi.getter(name="edgeLocation")
    def edge_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where a core network edge is located.
        """
        return pulumi.get(self, "edge_location")

    @edge_location.setter
    def edge_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "edge_location", value)

    @property
    @pulumi.getter(name="insideCidrBlocks")
    def inside_cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Inside IP addresses used for core network edges.
        """
        return pulumi.get(self, "inside_cidr_blocks")

    @inside_cidr_blocks.setter
    def inside_cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "inside_cidr_blocks", value)


if not MYPY:
    class CoreNetworkSegmentArgsDict(TypedDict):
        edge_locations: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Regions where the edges are located.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of a core network segment.
        """
        shared_segments: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Shared segments of a core network.
        """
elif False:
    CoreNetworkSegmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreNetworkSegmentArgs:
    def __init__(__self__, *,
                 edge_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 shared_segments: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] edge_locations: Regions where the edges are located.
        :param pulumi.Input[builtins.str] name: Name of a core network segment.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] shared_segments: Shared segments of a core network.
        """
        if edge_locations is not None:
            pulumi.set(__self__, "edge_locations", edge_locations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if shared_segments is not None:
            pulumi.set(__self__, "shared_segments", shared_segments)

    @property
    @pulumi.getter(name="edgeLocations")
    def edge_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Regions where the edges are located.
        """
        return pulumi.get(self, "edge_locations")

    @edge_locations.setter
    def edge_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "edge_locations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of a core network segment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sharedSegments")
    def shared_segments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Shared segments of a core network.
        """
        return pulumi.get(self, "shared_segments")

    @shared_segments.setter
    def shared_segments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "shared_segments", value)


if not MYPY:
    class DeviceAwsLocationArgsDict(TypedDict):
        subnet_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        ARN of the subnet that the device is located in.
        """
        zone: NotRequired[pulumi.Input[builtins.str]]
        """
        Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.
        """
elif False:
    DeviceAwsLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceAwsLocationArgs:
    def __init__(__self__, *,
                 subnet_arn: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] subnet_arn: ARN of the subnet that the device is located in.
        :param pulumi.Input[builtins.str] zone: Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.
        """
        if subnet_arn is not None:
            pulumi.set(__self__, "subnet_arn", subnet_arn)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="subnetArn")
    def subnet_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the subnet that the device is located in.
        """
        return pulumi.get(self, "subnet_arn")

    @subnet_arn.setter
    def subnet_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_arn", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


if not MYPY:
    class DeviceLocationArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[builtins.str]]
        """
        Physical address.
        """
        latitude: NotRequired[pulumi.Input[builtins.str]]
        """
        Latitude.
        """
        longitude: NotRequired[pulumi.Input[builtins.str]]
        """
        Longitude.
        """
elif False:
    DeviceLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceLocationArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 latitude: Optional[pulumi.Input[builtins.str]] = None,
                 longitude: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] address: Physical address.
        :param pulumi.Input[builtins.str] latitude: Latitude.
        :param pulumi.Input[builtins.str] longitude: Longitude.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Physical address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def latitude(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Latitude.
        """
        return pulumi.get(self, "latitude")

    @latitude.setter
    def latitude(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "latitude", value)

    @property
    @pulumi.getter
    def longitude(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Longitude.
        """
        return pulumi.get(self, "longitude")

    @longitude.setter
    def longitude(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "longitude", value)


if not MYPY:
    class DxGatewayAttachmentTimeoutsArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        delete: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        update: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
elif False:
    DxGatewayAttachmentTimeoutsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DxGatewayAttachmentTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[builtins.str]] = None,
                 delete: Optional[pulumi.Input[builtins.str]] = None,
                 update: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[builtins.str] delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param pulumi.Input[builtins.str] update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update", value)


if not MYPY:
    class LinkBandwidthArgsDict(TypedDict):
        download_speed: NotRequired[pulumi.Input[builtins.int]]
        """
        Download speed in Mbps.
        """
        upload_speed: NotRequired[pulumi.Input[builtins.int]]
        """
        Upload speed in Mbps.
        """
elif False:
    LinkBandwidthArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LinkBandwidthArgs:
    def __init__(__self__, *,
                 download_speed: Optional[pulumi.Input[builtins.int]] = None,
                 upload_speed: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] download_speed: Download speed in Mbps.
        :param pulumi.Input[builtins.int] upload_speed: Upload speed in Mbps.
        """
        if download_speed is not None:
            pulumi.set(__self__, "download_speed", download_speed)
        if upload_speed is not None:
            pulumi.set(__self__, "upload_speed", upload_speed)

    @property
    @pulumi.getter(name="downloadSpeed")
    def download_speed(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Download speed in Mbps.
        """
        return pulumi.get(self, "download_speed")

    @download_speed.setter
    def download_speed(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "download_speed", value)

    @property
    @pulumi.getter(name="uploadSpeed")
    def upload_speed(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Upload speed in Mbps.
        """
        return pulumi.get(self, "upload_speed")

    @upload_speed.setter
    def upload_speed(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "upload_speed", value)


if not MYPY:
    class SiteLocationArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[builtins.str]]
        """
        Address of the location.
        """
        latitude: NotRequired[pulumi.Input[builtins.str]]
        """
        Latitude of the location.
        """
        longitude: NotRequired[pulumi.Input[builtins.str]]
        """
        Longitude of the location.
        """
elif False:
    SiteLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SiteLocationArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 latitude: Optional[pulumi.Input[builtins.str]] = None,
                 longitude: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] address: Address of the location.
        :param pulumi.Input[builtins.str] latitude: Latitude of the location.
        :param pulumi.Input[builtins.str] longitude: Longitude of the location.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Address of the location.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def latitude(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Latitude of the location.
        """
        return pulumi.get(self, "latitude")

    @latitude.setter
    def latitude(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "latitude", value)

    @property
    @pulumi.getter
    def longitude(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Longitude of the location.
        """
        return pulumi.get(self, "longitude")

    @longitude.setter
    def longitude(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "longitude", value)


if not MYPY:
    class VpcAttachmentOptionsArgsDict(TypedDict):
        appliance_mode_support: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to enable appliance mode support. If enabled, traffic flow between a source and destination use the same Availability Zone for the VPC attachment for the lifetime of that flow. If the VPC attachment is pending acceptance, changing this value will recreate the resource.
        """
        ipv6_support: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to enable IPv6 support. If the VPC attachment is pending acceptance, changing this value will recreate the resource.
        """
elif False:
    VpcAttachmentOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VpcAttachmentOptionsArgs:
    def __init__(__self__, *,
                 appliance_mode_support: Optional[pulumi.Input[builtins.bool]] = None,
                 ipv6_support: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] appliance_mode_support: Whether to enable appliance mode support. If enabled, traffic flow between a source and destination use the same Availability Zone for the VPC attachment for the lifetime of that flow. If the VPC attachment is pending acceptance, changing this value will recreate the resource.
        :param pulumi.Input[builtins.bool] ipv6_support: Whether to enable IPv6 support. If the VPC attachment is pending acceptance, changing this value will recreate the resource.
        """
        if appliance_mode_support is not None:
            pulumi.set(__self__, "appliance_mode_support", appliance_mode_support)
        if ipv6_support is not None:
            pulumi.set(__self__, "ipv6_support", ipv6_support)

    @property
    @pulumi.getter(name="applianceModeSupport")
    def appliance_mode_support(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable appliance mode support. If enabled, traffic flow between a source and destination use the same Availability Zone for the VPC attachment for the lifetime of that flow. If the VPC attachment is pending acceptance, changing this value will recreate the resource.
        """
        return pulumi.get(self, "appliance_mode_support")

    @appliance_mode_support.setter
    def appliance_mode_support(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "appliance_mode_support", value)

    @property
    @pulumi.getter(name="ipv6Support")
    def ipv6_support(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable IPv6 support. If the VPC attachment is pending acceptance, changing this value will recreate the resource.
        """
        return pulumi.get(self, "ipv6_support")

    @ipv6_support.setter
    def ipv6_support(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ipv6_support", value)


if not MYPY:
    class GetCoreNetworkPolicyDocumentAttachmentPolicyArgsDict(TypedDict):
        action: 'GetCoreNetworkPolicyDocumentAttachmentPolicyActionArgsDict'
        """
        Action to take when a condition is true. Detailed Below.
        """
        conditions: Sequence['GetCoreNetworkPolicyDocumentAttachmentPolicyConditionArgsDict']
        """
        A block argument. Detailed Below.
        """
        rule_number: builtins.int
        """
        An integer from `1` to `65535` indicating the rule's order number. Rules are processed in order from the lowest numbered rule to the highest. Rules stop processing when a rule is matched. It's important to make sure that you number your rules in the exact order that you want them processed.
        """
        condition_logic: NotRequired[builtins.str]
        """
        Valid values include `and` or `or`. This is a mandatory parameter only if you have more than one condition. The `condition_logic` apply to all of the conditions for a rule, which also means nested conditions of `and` or `or` are not supported. Use `or` if you want to associate the attachment with the segment by either the segment name or attachment tag value, or by the chosen conditions. Use `and` if you want to associate the attachment with the segment by either the segment name or attachment tag value and by the chosen conditions. Detailed Below.
        """
        description: NotRequired[builtins.str]
        """
        A user-defined description that further helps identify the rule.
        """
elif False:
    GetCoreNetworkPolicyDocumentAttachmentPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetCoreNetworkPolicyDocumentAttachmentPolicyArgs:
    def __init__(__self__, *,
                 action: 'GetCoreNetworkPolicyDocumentAttachmentPolicyActionArgs',
                 conditions: Sequence['GetCoreNetworkPolicyDocumentAttachmentPolicyConditionArgs'],
                 rule_number: builtins.int,
                 condition_logic: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None):
        """
        :param 'GetCoreNetworkPolicyDocumentAttachmentPolicyActionArgs' action: Action to take when a condition is true. Detailed Below.
        :param Sequence['GetCoreNetworkPolicyDocumentAttachmentPolicyConditionArgs'] conditions: A block argument. Detailed Below.
        :param builtins.int rule_number: An integer from `1` to `65535` indicating the rule's order number. Rules are processed in order from the lowest numbered rule to the highest. Rules stop processing when a rule is matched. It's important to make sure that you number your rules in the exact order that you want them processed.
        :param builtins.str condition_logic: Valid values include `and` or `or`. This is a mandatory parameter only if you have more than one condition. The `condition_logic` apply to all of the conditions for a rule, which also means nested conditions of `and` or `or` are not supported. Use `or` if you want to associate the attachment with the segment by either the segment name or attachment tag value, or by the chosen conditions. Use `and` if you want to associate the attachment with the segment by either the segment name or attachment tag value and by the chosen conditions. Detailed Below.
        :param builtins.str description: A user-defined description that further helps identify the rule.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "rule_number", rule_number)
        if condition_logic is not None:
            pulumi.set(__self__, "condition_logic", condition_logic)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def action(self) -> 'GetCoreNetworkPolicyDocumentAttachmentPolicyActionArgs':
        """
        Action to take when a condition is true. Detailed Below.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: 'GetCoreNetworkPolicyDocumentAttachmentPolicyActionArgs'):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['GetCoreNetworkPolicyDocumentAttachmentPolicyConditionArgs']:
        """
        A block argument. Detailed Below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Sequence['GetCoreNetworkPolicyDocumentAttachmentPolicyConditionArgs']):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="ruleNumber")
    def rule_number(self) -> builtins.int:
        """
        An integer from `1` to `65535` indicating the rule's order number. Rules are processed in order from the lowest numbered rule to the highest. Rules stop processing when a rule is matched. It's important to make sure that you number your rules in the exact order that you want them processed.
        """
        return pulumi.get(self, "rule_number")

    @rule_number.setter
    def rule_number(self, value: builtins.int):
        pulumi.set(self, "rule_number", value)

    @property
    @pulumi.getter(name="conditionLogic")
    def condition_logic(self) -> Optional[builtins.str]:
        """
        Valid values include `and` or `or`. This is a mandatory parameter only if you have more than one condition. The `condition_logic` apply to all of the conditions for a rule, which also means nested conditions of `and` or `or` are not supported. Use `or` if you want to associate the attachment with the segment by either the segment name or attachment tag value, or by the chosen conditions. Use `and` if you want to associate the attachment with the segment by either the segment name or attachment tag value and by the chosen conditions. Detailed Below.
        """
        return pulumi.get(self, "condition_logic")

    @condition_logic.setter
    def condition_logic(self, value: Optional[builtins.str]):
        pulumi.set(self, "condition_logic", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A user-defined description that further helps identify the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[builtins.str]):
        pulumi.set(self, "description", value)


if not MYPY:
    class GetCoreNetworkPolicyDocumentAttachmentPolicyActionArgsDict(TypedDict):
        add_to_network_function_group: NotRequired[builtins.str]
        """
        The name of the network function group to attach to the attachment policy.
        """
        association_method: NotRequired[builtins.str]
        """
        Defines how a segment is mapped. Values can be `constant` or `tag`. `constant` statically defines the segment to associate the attachment to. `tag` uses the value of a tag to dynamically try to map to a segment.reference_policies_elements_condition_operators.html) to evaluate.
        """
        require_acceptance: NotRequired[builtins.bool]
        """
        Determines if this mapping should override the segment value for `require_attachment_acceptance`. You can only set this to `true`, indicating that this setting applies only to segments that have `require_attachment_acceptance` set to `false`. If the segment already has the default `require_attachment_acceptance`, you can set this to inherit segment’s acceptance value.
        """
        segment: NotRequired[builtins.str]
        """
        Name of the `segment` to share as defined in the `segments` section. This is used only when the `association_method` is `constant`.
        """
        tag_value_of_key: NotRequired[builtins.str]
        """
        Maps the attachment to the value of a known key. This is used with the `association_method` is `tag`. For example a `tag` of `stage = “test”`, will map to a segment named `test`. The value must exactly match the name of a segment. This allows you to have many segments, but use only a single rule without having to define multiple nearly identical conditions. This prevents creating many similar conditions that all use the same keys to map to segments.
        """
elif False:
    GetCoreNetworkPolicyDocumentAttachmentPolicyActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetCoreNetworkPolicyDocumentAttachmentPolicyActionArgs:
    def __init__(__self__, *,
                 add_to_network_function_group: Optional[builtins.str] = None,
                 association_method: Optional[builtins.str] = None,
                 require_acceptance: Optional[builtins.bool] = None,
                 segment: Optional[builtins.str] = None,
                 tag_value_of_key: Optional[builtins.str] = None):
        """
        :param builtins.str add_to_network_function_group: The name of the network function group to attach to the attachment policy.
        :param builtins.str association_method: Defines how a segment is mapped. Values can be `constant` or `tag`. `constant` statically defines the segment to associate the attachment to. `tag` uses the value of a tag to dynamically try to map to a segment.reference_policies_elements_condition_operators.html) to evaluate.
        :param builtins.bool require_acceptance: Determines if this mapping should override the segment value for `require_attachment_acceptance`. You can only set this to `true`, indicating that this setting applies only to segments that have `require_attachment_acceptance` set to `false`. If the segment already has the default `require_attachment_acceptance`, you can set this to inherit segment’s acceptance value.
        :param builtins.str segment: Name of the `segment` to share as defined in the `segments` section. This is used only when the `association_method` is `constant`.
        :param builtins.str tag_value_of_key: Maps the attachment to the value of a known key. This is used with the `association_method` is `tag`. For example a `tag` of `stage = “test”`, will map to a segment named `test`. The value must exactly match the name of a segment. This allows you to have many segments, but use only a single rule without having to define multiple nearly identical conditions. This prevents creating many similar conditions that all use the same keys to map to segments.
        """
        if add_to_network_function_group is not None:
            pulumi.set(__self__, "add_to_network_function_group", add_to_network_function_group)
        if association_method is not None:
            pulumi.set(__self__, "association_method", association_method)
        if require_acceptance is not None:
            pulumi.set(__self__, "require_acceptance", require_acceptance)
        if segment is not None:
            pulumi.set(__self__, "segment", segment)
        if tag_value_of_key is not None:
            pulumi.set(__self__, "tag_value_of_key", tag_value_of_key)

    @property
    @pulumi.getter(name="addToNetworkFunctionGroup")
    def add_to_network_function_group(self) -> Optional[builtins.str]:
        """
        The name of the network function group to attach to the attachment policy.
        """
        return pulumi.get(self, "add_to_network_function_group")

    @add_to_network_function_group.setter
    def add_to_network_function_group(self, value: Optional[builtins.str]):
        pulumi.set(self, "add_to_network_function_group", value)

    @property
    @pulumi.getter(name="associationMethod")
    def association_method(self) -> Optional[builtins.str]:
        """
        Defines how a segment is mapped. Values can be `constant` or `tag`. `constant` statically defines the segment to associate the attachment to. `tag` uses the value of a tag to dynamically try to map to a segment.reference_policies_elements_condition_operators.html) to evaluate.
        """
        return pulumi.get(self, "association_method")

    @association_method.setter
    def association_method(self, value: Optional[builtins.str]):
        pulumi.set(self, "association_method", value)

    @property
    @pulumi.getter(name="requireAcceptance")
    def require_acceptance(self) -> Optional[builtins.bool]:
        """
        Determines if this mapping should override the segment value for `require_attachment_acceptance`. You can only set this to `true`, indicating that this setting applies only to segments that have `require_attachment_acceptance` set to `false`. If the segment already has the default `require_attachment_acceptance`, you can set this to inherit segment’s acceptance value.
        """
        return pulumi.get(self, "require_acceptance")

    @require_acceptance.setter
    def require_acceptance(self, value: Optional[builtins.bool]):
        pulumi.set(self, "require_acceptance", value)

    @property
    @pulumi.getter
    def segment(self) -> Optional[builtins.str]:
        """
        Name of the `segment` to share as defined in the `segments` section. This is used only when the `association_method` is `constant`.
        """
        return pulumi.get(self, "segment")

    @segment.setter
    def segment(self, value: Optional[builtins.str]):
        pulumi.set(self, "segment", value)

    @property
    @pulumi.getter(name="tagValueOfKey")
    def tag_value_of_key(self) -> Optional[builtins.str]:
        """
        Maps the attachment to the value of a known key. This is used with the `association_method` is `tag`. For example a `tag` of `stage = “test”`, will map to a segment named `test`. The value must exactly match the name of a segment. This allows you to have many segments, but use only a single rule without having to define multiple nearly identical conditions. This prevents creating many similar conditions that all use the same keys to map to segments.
        """
        return pulumi.get(self, "tag_value_of_key")

    @tag_value_of_key.setter
    def tag_value_of_key(self, value: Optional[builtins.str]):
        pulumi.set(self, "tag_value_of_key", value)


if not MYPY:
    class GetCoreNetworkPolicyDocumentAttachmentPolicyConditionArgsDict(TypedDict):
        type: builtins.str
        """
        Valid values include: `account-id`, `any`, `tag-value`, `tag-exists`, `resource-id`, `region`, `attachment-type`.
        """
        key: NotRequired[builtins.str]
        """
        string value
        """
        operator: NotRequired[builtins.str]
        """
        Valid values include: `equals`, `not-equals`, `contains`, `begins-with`.
        """
        value: NotRequired[builtins.str]
        """
        string value
        """
elif False:
    GetCoreNetworkPolicyDocumentAttachmentPolicyConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetCoreNetworkPolicyDocumentAttachmentPolicyConditionArgs:
    def __init__(__self__, *,
                 type: builtins.str,
                 key: Optional[builtins.str] = None,
                 operator: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str type: Valid values include: `account-id`, `any`, `tag-value`, `tag-exists`, `resource-id`, `region`, `attachment-type`.
        :param builtins.str key: string value
        :param builtins.str operator: Valid values include: `equals`, `not-equals`, `contains`, `begins-with`.
        :param builtins.str value: string value
        """
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Valid values include: `account-id`, `any`, `tag-value`, `tag-exists`, `resource-id`, `region`, `attachment-type`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: builtins.str):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        string value
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[builtins.str]:
        """
        Valid values include: `equals`, `not-equals`, `contains`, `begins-with`.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[builtins.str]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        string value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgsDict(TypedDict):
        asn_ranges: Sequence[builtins.str]
        """
        List of strings containing Autonomous System Numbers (ASNs) to assign to Core Network Edges. By default, the core network automatically assigns an ASN for each Core Network Edge but you can optionally define the ASN in the edge-locations for each Region. The ASN uses an array of integer ranges only from `64512` to `65534` and `4200000000` to `4294967294` expressed as a string like `"64512-65534"`. No other ASN ranges can be used.
        """
        edge_locations: Sequence['GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgsDict']
        """
        A block value of AWS Region locations where you're creating Core Network Edges. Detailed below.
        """
        dns_support: NotRequired[builtins.bool]
        """
        Indicates whether DNS resolution is enabled for the core network. The value can be either `true` or `false`. When set to `true`, DNS resolution is enabled for VPCs attached to the core network, allowing resources in different VPCs to resolve each other's domain names. The default is `true`.
        """
        inside_cidr_blocks: NotRequired[Sequence[builtins.str]]
        """
        The Classless Inter-Domain Routing (CIDR) block range used to create tunnels for AWS Transit Gateway Connect. The format is standard AWS CIDR range (for example, `10.0.1.0/24`). You can optionally define the inside CIDR in the Core Network Edges section per Region. The minimum is a `/24` for IPv4 or `/64` for IPv6. You can provide multiple `/24` subnets or a larger CIDR range. If you define a larger CIDR range, new Core Network Edges will be automatically assigned `/24` and `/64` subnets from the larger CIDR. an Inside CIDR block is required for attaching Connect attachments to a Core Network Edge.
        """
        security_group_referencing_support: NotRequired[builtins.bool]
        """
        — (Optional) Indicates whether security group referencing is enabled for the core network. The value can be either `true` or `false`. When set to `true`, security groups in one VPC can reference security groups in another VPC attached to the core network, enabling more flexible security configurations across your network. The default is `false`.
        """
        vpn_ecmp_support: NotRequired[builtins.bool]
        """
        Indicates whether the core network forwards traffic over multiple equal-cost routes using VPN. The value can be either `true` or `false`. The default is `true`.
        """
elif False:
    GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs:
    def __init__(__self__, *,
                 asn_ranges: Sequence[builtins.str],
                 edge_locations: Sequence['GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs'],
                 dns_support: Optional[builtins.bool] = None,
                 inside_cidr_blocks: Optional[Sequence[builtins.str]] = None,
                 security_group_referencing_support: Optional[builtins.bool] = None,
                 vpn_ecmp_support: Optional[builtins.bool] = None):
        """
        :param Sequence[builtins.str] asn_ranges: List of strings containing Autonomous System Numbers (ASNs) to assign to Core Network Edges. By default, the core network automatically assigns an ASN for each Core Network Edge but you can optionally define the ASN in the edge-locations for each Region. The ASN uses an array of integer ranges only from `64512` to `65534` and `4200000000` to `4294967294` expressed as a string like `"64512-65534"`. No other ASN ranges can be used.
        :param Sequence['GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs'] edge_locations: A block value of AWS Region locations where you're creating Core Network Edges. Detailed below.
        :param builtins.bool dns_support: Indicates whether DNS resolution is enabled for the core network. The value can be either `true` or `false`. When set to `true`, DNS resolution is enabled for VPCs attached to the core network, allowing resources in different VPCs to resolve each other's domain names. The default is `true`.
        :param Sequence[builtins.str] inside_cidr_blocks: The Classless Inter-Domain Routing (CIDR) block range used to create tunnels for AWS Transit Gateway Connect. The format is standard AWS CIDR range (for example, `10.0.1.0/24`). You can optionally define the inside CIDR in the Core Network Edges section per Region. The minimum is a `/24` for IPv4 or `/64` for IPv6. You can provide multiple `/24` subnets or a larger CIDR range. If you define a larger CIDR range, new Core Network Edges will be automatically assigned `/24` and `/64` subnets from the larger CIDR. an Inside CIDR block is required for attaching Connect attachments to a Core Network Edge.
        :param builtins.bool security_group_referencing_support: — (Optional) Indicates whether security group referencing is enabled for the core network. The value can be either `true` or `false`. When set to `true`, security groups in one VPC can reference security groups in another VPC attached to the core network, enabling more flexible security configurations across your network. The default is `false`.
        :param builtins.bool vpn_ecmp_support: Indicates whether the core network forwards traffic over multiple equal-cost routes using VPN. The value can be either `true` or `false`. The default is `true`.
        """
        pulumi.set(__self__, "asn_ranges", asn_ranges)
        pulumi.set(__self__, "edge_locations", edge_locations)
        if dns_support is not None:
            pulumi.set(__self__, "dns_support", dns_support)
        if inside_cidr_blocks is not None:
            pulumi.set(__self__, "inside_cidr_blocks", inside_cidr_blocks)
        if security_group_referencing_support is not None:
            pulumi.set(__self__, "security_group_referencing_support", security_group_referencing_support)
        if vpn_ecmp_support is not None:
            pulumi.set(__self__, "vpn_ecmp_support", vpn_ecmp_support)

    @property
    @pulumi.getter(name="asnRanges")
    def asn_ranges(self) -> Sequence[builtins.str]:
        """
        List of strings containing Autonomous System Numbers (ASNs) to assign to Core Network Edges. By default, the core network automatically assigns an ASN for each Core Network Edge but you can optionally define the ASN in the edge-locations for each Region. The ASN uses an array of integer ranges only from `64512` to `65534` and `4200000000` to `4294967294` expressed as a string like `"64512-65534"`. No other ASN ranges can be used.
        """
        return pulumi.get(self, "asn_ranges")

    @asn_ranges.setter
    def asn_ranges(self, value: Sequence[builtins.str]):
        pulumi.set(self, "asn_ranges", value)

    @property
    @pulumi.getter(name="edgeLocations")
    def edge_locations(self) -> Sequence['GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs']:
        """
        A block value of AWS Region locations where you're creating Core Network Edges. Detailed below.
        """
        return pulumi.get(self, "edge_locations")

    @edge_locations.setter
    def edge_locations(self, value: Sequence['GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs']):
        pulumi.set(self, "edge_locations", value)

    @property
    @pulumi.getter(name="dnsSupport")
    def dns_support(self) -> Optional[builtins.bool]:
        """
        Indicates whether DNS resolution is enabled for the core network. The value can be either `true` or `false`. When set to `true`, DNS resolution is enabled for VPCs attached to the core network, allowing resources in different VPCs to resolve each other's domain names. The default is `true`.
        """
        return pulumi.get(self, "dns_support")

    @dns_support.setter
    def dns_support(self, value: Optional[builtins.bool]):
        pulumi.set(self, "dns_support", value)

    @property
    @pulumi.getter(name="insideCidrBlocks")
    def inside_cidr_blocks(self) -> Optional[Sequence[builtins.str]]:
        """
        The Classless Inter-Domain Routing (CIDR) block range used to create tunnels for AWS Transit Gateway Connect. The format is standard AWS CIDR range (for example, `10.0.1.0/24`). You can optionally define the inside CIDR in the Core Network Edges section per Region. The minimum is a `/24` for IPv4 or `/64` for IPv6. You can provide multiple `/24` subnets or a larger CIDR range. If you define a larger CIDR range, new Core Network Edges will be automatically assigned `/24` and `/64` subnets from the larger CIDR. an Inside CIDR block is required for attaching Connect attachments to a Core Network Edge.
        """
        return pulumi.get(self, "inside_cidr_blocks")

    @inside_cidr_blocks.setter
    def inside_cidr_blocks(self, value: Optional[Sequence[builtins.str]]):
        pulumi.set(self, "inside_cidr_blocks", value)

    @property
    @pulumi.getter(name="securityGroupReferencingSupport")
    def security_group_referencing_support(self) -> Optional[builtins.bool]:
        """
        — (Optional) Indicates whether security group referencing is enabled for the core network. The value can be either `true` or `false`. When set to `true`, security groups in one VPC can reference security groups in another VPC attached to the core network, enabling more flexible security configurations across your network. The default is `false`.
        """
        return pulumi.get(self, "security_group_referencing_support")

    @security_group_referencing_support.setter
    def security_group_referencing_support(self, value: Optional[builtins.bool]):
        pulumi.set(self, "security_group_referencing_support", value)

    @property
    @pulumi.getter(name="vpnEcmpSupport")
    def vpn_ecmp_support(self) -> Optional[builtins.bool]:
        """
        Indicates whether the core network forwards traffic over multiple equal-cost routes using VPN. The value can be either `true` or `false`. The default is `true`.
        """
        return pulumi.get(self, "vpn_ecmp_support")

    @vpn_ecmp_support.setter
    def vpn_ecmp_support(self, value: Optional[builtins.bool]):
        pulumi.set(self, "vpn_ecmp_support", value)


if not MYPY:
    class GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgsDict(TypedDict):
        location: builtins.str
        asn: NotRequired[builtins.str]
        """
        ASN of the Core Network Edge in an AWS Region. By default, the ASN will be a single integer automatically assigned from `asn_ranges`
        """
        inside_cidr_blocks: NotRequired[Sequence[builtins.str]]
        """
        The local CIDR blocks for this Core Network Edge for AWS Transit Gateway Connect attachments. By default, this CIDR block will be one or more optional IPv4 and IPv6 CIDR prefixes auto-assigned from `inside_cidr_blocks`.
        """
elif False:
    GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs:
    def __init__(__self__, *,
                 location: builtins.str,
                 asn: Optional[builtins.str] = None,
                 inside_cidr_blocks: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str asn: ASN of the Core Network Edge in an AWS Region. By default, the ASN will be a single integer automatically assigned from `asn_ranges`
        :param Sequence[builtins.str] inside_cidr_blocks: The local CIDR blocks for this Core Network Edge for AWS Transit Gateway Connect attachments. By default, this CIDR block will be one or more optional IPv4 and IPv6 CIDR prefixes auto-assigned from `inside_cidr_blocks`.
        """
        pulumi.set(__self__, "location", location)
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if inside_cidr_blocks is not None:
            pulumi.set(__self__, "inside_cidr_blocks", inside_cidr_blocks)

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: builtins.str):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def asn(self) -> Optional[builtins.str]:
        """
        ASN of the Core Network Edge in an AWS Region. By default, the ASN will be a single integer automatically assigned from `asn_ranges`
        """
        return pulumi.get(self, "asn")

    @asn.setter
    def asn(self, value: Optional[builtins.str]):
        pulumi.set(self, "asn", value)

    @property
    @pulumi.getter(name="insideCidrBlocks")
    def inside_cidr_blocks(self) -> Optional[Sequence[builtins.str]]:
        """
        The local CIDR blocks for this Core Network Edge for AWS Transit Gateway Connect attachments. By default, this CIDR block will be one or more optional IPv4 and IPv6 CIDR prefixes auto-assigned from `inside_cidr_blocks`.
        """
        return pulumi.get(self, "inside_cidr_blocks")

    @inside_cidr_blocks.setter
    def inside_cidr_blocks(self, value: Optional[Sequence[builtins.str]]):
        pulumi.set(self, "inside_cidr_blocks", value)


if not MYPY:
    class GetCoreNetworkPolicyDocumentNetworkFunctionGroupArgsDict(TypedDict):
        name: builtins.str
        """
        This identifies the network function group container.
        """
        require_attachment_acceptance: builtins.bool
        """
        This will be either `true`, that attachment acceptance is required, or `false`, that it is not required.
        """
        description: NotRequired[builtins.str]
        """
        Optional description of the network function group.
        """
elif False:
    GetCoreNetworkPolicyDocumentNetworkFunctionGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetCoreNetworkPolicyDocumentNetworkFunctionGroupArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 require_attachment_acceptance: builtins.bool,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str name: This identifies the network function group container.
        :param builtins.bool require_attachment_acceptance: This will be either `true`, that attachment acceptance is required, or `false`, that it is not required.
        :param builtins.str description: Optional description of the network function group.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "require_attachment_acceptance", require_attachment_acceptance)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        This identifies the network function group container.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="requireAttachmentAcceptance")
    def require_attachment_acceptance(self) -> builtins.bool:
        """
        This will be either `true`, that attachment acceptance is required, or `false`, that it is not required.
        """
        return pulumi.get(self, "require_attachment_acceptance")

    @require_attachment_acceptance.setter
    def require_attachment_acceptance(self, value: builtins.bool):
        pulumi.set(self, "require_attachment_acceptance", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Optional description of the network function group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[builtins.str]):
        pulumi.set(self, "description", value)


if not MYPY:
    class GetCoreNetworkPolicyDocumentSegmentArgsDict(TypedDict):
        name: builtins.str
        """
        Unique name for a segment. The name is a string used in other parts of the policy document, as well as in the console for metrics and other reference points. Valid characters are a–z, and 0–9.
        """
        allow_filters: NotRequired[Sequence[builtins.str]]
        """
        List of strings of segment names that explicitly allows only routes from the segments that are listed in the array. Use the `allow_filter` setting if a segment has a well-defined group of other segments that connectivity should be restricted to. It is applied after routes have been shared in `segment_actions`. If a segment is listed in `allow_filter`, attachments between the two segments will have routes if they are also shared in the segment-actions area. For example, you might have a segment named "video-producer" that should only ever share routes with a "video-distributor" segment, no matter how many other share statements are created.
        """
        deny_filters: NotRequired[Sequence[builtins.str]]
        """
        An array of segments that disallows routes from the segments listed in the array. It is applied only after routes have been shared in `segment_actions`. If a segment is listed in the `deny_filter`, attachments between the two segments will never have routes shared across them. For example, you might have a "financial" payment segment that should never share routes with a "development" segment, regardless of how many other share statements are created. Adding the payments segment to the deny-filter parameter prevents any shared routes from being created with other segments.
        """
        description: NotRequired[builtins.str]
        """
        A user-defined string describing the segment.
        """
        edge_locations: NotRequired[Sequence[builtins.str]]
        """
        A list of strings of AWS Region names. Allows you to define a more restrictive set of Regions for a segment. The edge location must be a subset of the locations that are defined for `edge_locations` in the `core_network_configuration`.
        """
        isolate_attachments: NotRequired[builtins.bool]
        """
        This Boolean setting determines whether attachments on the same segment can communicate with each other. If set to `true`, the only routes available will be either shared routes through the share actions, which are attachments in other segments, or static routes. The default value is `false`. For example, you might have a segment dedicated to "development" that should never allow VPCs to talk to each other, even if they’re on the same segment. In this example, you would keep the default parameter of `false`.
        """
        require_attachment_acceptance: NotRequired[builtins.bool]
        """
        This Boolean setting determines whether attachment requests are automatically approved or require acceptance. The default is `true`, indicating that attachment requests require acceptance. For example, you might use this setting to allow a "sandbox" segment to allow any attachment request so that a core network or attachment administrator does not need to review and approve attachment requests. In this example, `require_attachment_acceptance` is set to `false`.
        """
elif False:
    GetCoreNetworkPolicyDocumentSegmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetCoreNetworkPolicyDocumentSegmentArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 allow_filters: Optional[Sequence[builtins.str]] = None,
                 deny_filters: Optional[Sequence[builtins.str]] = None,
                 description: Optional[builtins.str] = None,
                 edge_locations: Optional[Sequence[builtins.str]] = None,
                 isolate_attachments: Optional[builtins.bool] = None,
                 require_attachment_acceptance: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Unique name for a segment. The name is a string used in other parts of the policy document, as well as in the console for metrics and other reference points. Valid characters are a–z, and 0–9.
        :param Sequence[builtins.str] allow_filters: List of strings of segment names that explicitly allows only routes from the segments that are listed in the array. Use the `allow_filter` setting if a segment has a well-defined group of other segments that connectivity should be restricted to. It is applied after routes have been shared in `segment_actions`. If a segment is listed in `allow_filter`, attachments between the two segments will have routes if they are also shared in the segment-actions area. For example, you might have a segment named "video-producer" that should only ever share routes with a "video-distributor" segment, no matter how many other share statements are created.
        :param Sequence[builtins.str] deny_filters: An array of segments that disallows routes from the segments listed in the array. It is applied only after routes have been shared in `segment_actions`. If a segment is listed in the `deny_filter`, attachments between the two segments will never have routes shared across them. For example, you might have a "financial" payment segment that should never share routes with a "development" segment, regardless of how many other share statements are created. Adding the payments segment to the deny-filter parameter prevents any shared routes from being created with other segments.
        :param builtins.str description: A user-defined string describing the segment.
        :param Sequence[builtins.str] edge_locations: A list of strings of AWS Region names. Allows you to define a more restrictive set of Regions for a segment. The edge location must be a subset of the locations that are defined for `edge_locations` in the `core_network_configuration`.
        :param builtins.bool isolate_attachments: This Boolean setting determines whether attachments on the same segment can communicate with each other. If set to `true`, the only routes available will be either shared routes through the share actions, which are attachments in other segments, or static routes. The default value is `false`. For example, you might have a segment dedicated to "development" that should never allow VPCs to talk to each other, even if they’re on the same segment. In this example, you would keep the default parameter of `false`.
        :param builtins.bool require_attachment_acceptance: This Boolean setting determines whether attachment requests are automatically approved or require acceptance. The default is `true`, indicating that attachment requests require acceptance. For example, you might use this setting to allow a "sandbox" segment to allow any attachment request so that a core network or attachment administrator does not need to review and approve attachment requests. In this example, `require_attachment_acceptance` is set to `false`.
        """
        pulumi.set(__self__, "name", name)
        if allow_filters is not None:
            pulumi.set(__self__, "allow_filters", allow_filters)
        if deny_filters is not None:
            pulumi.set(__self__, "deny_filters", deny_filters)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if edge_locations is not None:
            pulumi.set(__self__, "edge_locations", edge_locations)
        if isolate_attachments is not None:
            pulumi.set(__self__, "isolate_attachments", isolate_attachments)
        if require_attachment_acceptance is not None:
            pulumi.set(__self__, "require_attachment_acceptance", require_attachment_acceptance)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Unique name for a segment. The name is a string used in other parts of the policy document, as well as in the console for metrics and other reference points. Valid characters are a–z, and 0–9.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="allowFilters")
    def allow_filters(self) -> Optional[Sequence[builtins.str]]:
        """
        List of strings of segment names that explicitly allows only routes from the segments that are listed in the array. Use the `allow_filter` setting if a segment has a well-defined group of other segments that connectivity should be restricted to. It is applied after routes have been shared in `segment_actions`. If a segment is listed in `allow_filter`, attachments between the two segments will have routes if they are also shared in the segment-actions area. For example, you might have a segment named "video-producer" that should only ever share routes with a "video-distributor" segment, no matter how many other share statements are created.
        """
        return pulumi.get(self, "allow_filters")

    @allow_filters.setter
    def allow_filters(self, value: Optional[Sequence[builtins.str]]):
        pulumi.set(self, "allow_filters", value)

    @property
    @pulumi.getter(name="denyFilters")
    def deny_filters(self) -> Optional[Sequence[builtins.str]]:
        """
        An array of segments that disallows routes from the segments listed in the array. It is applied only after routes have been shared in `segment_actions`. If a segment is listed in the `deny_filter`, attachments between the two segments will never have routes shared across them. For example, you might have a "financial" payment segment that should never share routes with a "development" segment, regardless of how many other share statements are created. Adding the payments segment to the deny-filter parameter prevents any shared routes from being created with other segments.
        """
        return pulumi.get(self, "deny_filters")

    @deny_filters.setter
    def deny_filters(self, value: Optional[Sequence[builtins.str]]):
        pulumi.set(self, "deny_filters", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A user-defined string describing the segment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="edgeLocations")
    def edge_locations(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of strings of AWS Region names. Allows you to define a more restrictive set of Regions for a segment. The edge location must be a subset of the locations that are defined for `edge_locations` in the `core_network_configuration`.
        """
        return pulumi.get(self, "edge_locations")

    @edge_locations.setter
    def edge_locations(self, value: Optional[Sequence[builtins.str]]):
        pulumi.set(self, "edge_locations", value)

    @property
    @pulumi.getter(name="isolateAttachments")
    def isolate_attachments(self) -> Optional[builtins.bool]:
        """
        This Boolean setting determines whether attachments on the same segment can communicate with each other. If set to `true`, the only routes available will be either shared routes through the share actions, which are attachments in other segments, or static routes. The default value is `false`. For example, you might have a segment dedicated to "development" that should never allow VPCs to talk to each other, even if they’re on the same segment. In this example, you would keep the default parameter of `false`.
        """
        return pulumi.get(self, "isolate_attachments")

    @isolate_attachments.setter
    def isolate_attachments(self, value: Optional[builtins.bool]):
        pulumi.set(self, "isolate_attachments", value)

    @property
    @pulumi.getter(name="requireAttachmentAcceptance")
    def require_attachment_acceptance(self) -> Optional[builtins.bool]:
        """
        This Boolean setting determines whether attachment requests are automatically approved or require acceptance. The default is `true`, indicating that attachment requests require acceptance. For example, you might use this setting to allow a "sandbox" segment to allow any attachment request so that a core network or attachment administrator does not need to review and approve attachment requests. In this example, `require_attachment_acceptance` is set to `false`.
        """
        return pulumi.get(self, "require_attachment_acceptance")

    @require_attachment_acceptance.setter
    def require_attachment_acceptance(self, value: Optional[builtins.bool]):
        pulumi.set(self, "require_attachment_acceptance", value)


if not MYPY:
    class GetCoreNetworkPolicyDocumentSegmentActionArgsDict(TypedDict):
        action: builtins.str
        """
        Action to take for the chosen segment. Valid values: `create-route`, `share`, `send-via` and `send-to`.
        """
        segment: builtins.str
        """
        Name of the segment.
        """
        description: NotRequired[builtins.str]
        """
        A user-defined string describing the segment action.
        """
        destination_cidr_blocks: NotRequired[Sequence[builtins.str]]
        """
        List of strings containing CIDRs. You can define the IPv4 and IPv6 CIDR notation for each AWS Region. For example, `10.1.0.0/16` or `2001:db8::/56`. This is an array of CIDR notation strings.
        """
        destinations: NotRequired[Sequence[builtins.str]]
        """
        A list of strings. Valid values include `["blackhole"]` or a list of attachment ids.
        """
        mode: NotRequired[builtins.str]
        """
        String. When `action` is `share`, a `mode` value of `attachment-route` places the attachment and return routes in each of the `share_with` segments. When `action` is `send-via`, indicates the mode used for packets. Valid values: `attachment-route`, `single-hop`, `dual-hop`.
        """
        share_with_excepts: NotRequired[Sequence[builtins.str]]
        """
        A set subtraction of segments to not share with.
        """
        share_withs: NotRequired[Sequence[builtins.str]]
        """
        A list of strings to share with. Must be a substring is all segments. Valid values include: `["*"]` or `["<segment-names>"]`.
        """
        via: NotRequired['GetCoreNetworkPolicyDocumentSegmentActionViaArgsDict']
        """
        The network function groups and any edge overrides associated with the action.
        """
        when_sent_to: NotRequired['GetCoreNetworkPolicyDocumentSegmentActionWhenSentToArgsDict']
        """
        The destination segments for the `send-via` or `send-to` `action`.
        """
elif False:
    GetCoreNetworkPolicyDocumentSegmentActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetCoreNetworkPolicyDocumentSegmentActionArgs:
    def __init__(__self__, *,
                 action: builtins.str,
                 segment: builtins.str,
                 description: Optional[builtins.str] = None,
                 destination_cidr_blocks: Optional[Sequence[builtins.str]] = None,
                 destinations: Optional[Sequence[builtins.str]] = None,
                 mode: Optional[builtins.str] = None,
                 share_with_excepts: Optional[Sequence[builtins.str]] = None,
                 share_withs: Optional[Sequence[builtins.str]] = None,
                 via: Optional['GetCoreNetworkPolicyDocumentSegmentActionViaArgs'] = None,
                 when_sent_to: Optional['GetCoreNetworkPolicyDocumentSegmentActionWhenSentToArgs'] = None):
        """
        :param builtins.str action: Action to take for the chosen segment. Valid values: `create-route`, `share`, `send-via` and `send-to`.
        :param builtins.str segment: Name of the segment.
        :param builtins.str description: A user-defined string describing the segment action.
        :param Sequence[builtins.str] destination_cidr_blocks: List of strings containing CIDRs. You can define the IPv4 and IPv6 CIDR notation for each AWS Region. For example, `10.1.0.0/16` or `2001:db8::/56`. This is an array of CIDR notation strings.
        :param Sequence[builtins.str] destinations: A list of strings. Valid values include `["blackhole"]` or a list of attachment ids.
        :param builtins.str mode: String. When `action` is `share`, a `mode` value of `attachment-route` places the attachment and return routes in each of the `share_with` segments. When `action` is `send-via`, indicates the mode used for packets. Valid values: `attachment-route`, `single-hop`, `dual-hop`.
        :param Sequence[builtins.str] share_with_excepts: A set subtraction of segments to not share with.
        :param Sequence[builtins.str] share_withs: A list of strings to share with. Must be a substring is all segments. Valid values include: `["*"]` or `["<segment-names>"]`.
        :param 'GetCoreNetworkPolicyDocumentSegmentActionViaArgs' via: The network function groups and any edge overrides associated with the action.
        :param 'GetCoreNetworkPolicyDocumentSegmentActionWhenSentToArgs' when_sent_to: The destination segments for the `send-via` or `send-to` `action`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "segment", segment)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_cidr_blocks is not None:
            pulumi.set(__self__, "destination_cidr_blocks", destination_cidr_blocks)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if share_with_excepts is not None:
            pulumi.set(__self__, "share_with_excepts", share_with_excepts)
        if share_withs is not None:
            pulumi.set(__self__, "share_withs", share_withs)
        if via is not None:
            pulumi.set(__self__, "via", via)
        if when_sent_to is not None:
            pulumi.set(__self__, "when_sent_to", when_sent_to)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        Action to take for the chosen segment. Valid values: `create-route`, `share`, `send-via` and `send-to`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: builtins.str):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def segment(self) -> builtins.str:
        """
        Name of the segment.
        """
        return pulumi.get(self, "segment")

    @segment.setter
    def segment(self, value: builtins.str):
        pulumi.set(self, "segment", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A user-defined string describing the segment action.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationCidrBlocks")
    def destination_cidr_blocks(self) -> Optional[Sequence[builtins.str]]:
        """
        List of strings containing CIDRs. You can define the IPv4 and IPv6 CIDR notation for each AWS Region. For example, `10.1.0.0/16` or `2001:db8::/56`. This is an array of CIDR notation strings.
        """
        return pulumi.get(self, "destination_cidr_blocks")

    @destination_cidr_blocks.setter
    def destination_cidr_blocks(self, value: Optional[Sequence[builtins.str]]):
        pulumi.set(self, "destination_cidr_blocks", value)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of strings. Valid values include `["blackhole"]` or a list of attachment ids.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[Sequence[builtins.str]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[builtins.str]:
        """
        String. When `action` is `share`, a `mode` value of `attachment-route` places the attachment and return routes in each of the `share_with` segments. When `action` is `send-via`, indicates the mode used for packets. Valid values: `attachment-route`, `single-hop`, `dual-hop`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[builtins.str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="shareWithExcepts")
    def share_with_excepts(self) -> Optional[Sequence[builtins.str]]:
        """
        A set subtraction of segments to not share with.
        """
        return pulumi.get(self, "share_with_excepts")

    @share_with_excepts.setter
    def share_with_excepts(self, value: Optional[Sequence[builtins.str]]):
        pulumi.set(self, "share_with_excepts", value)

    @property
    @pulumi.getter(name="shareWiths")
    def share_withs(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of strings to share with. Must be a substring is all segments. Valid values include: `["*"]` or `["<segment-names>"]`.
        """
        return pulumi.get(self, "share_withs")

    @share_withs.setter
    def share_withs(self, value: Optional[Sequence[builtins.str]]):
        pulumi.set(self, "share_withs", value)

    @property
    @pulumi.getter
    def via(self) -> Optional['GetCoreNetworkPolicyDocumentSegmentActionViaArgs']:
        """
        The network function groups and any edge overrides associated with the action.
        """
        return pulumi.get(self, "via")

    @via.setter
    def via(self, value: Optional['GetCoreNetworkPolicyDocumentSegmentActionViaArgs']):
        pulumi.set(self, "via", value)

    @property
    @pulumi.getter(name="whenSentTo")
    def when_sent_to(self) -> Optional['GetCoreNetworkPolicyDocumentSegmentActionWhenSentToArgs']:
        """
        The destination segments for the `send-via` or `send-to` `action`.
        """
        return pulumi.get(self, "when_sent_to")

    @when_sent_to.setter
    def when_sent_to(self, value: Optional['GetCoreNetworkPolicyDocumentSegmentActionWhenSentToArgs']):
        pulumi.set(self, "when_sent_to", value)


if not MYPY:
    class GetCoreNetworkPolicyDocumentSegmentActionViaArgsDict(TypedDict):
        network_function_groups: NotRequired[Sequence[builtins.str]]
        """
        A list of strings. The network function group to use for the service insertion action.
        """
        with_edge_overrides: NotRequired[Sequence['GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverrideArgsDict']]
        """
        Any edge overrides and the preferred edge to use.
        """
elif False:
    GetCoreNetworkPolicyDocumentSegmentActionViaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetCoreNetworkPolicyDocumentSegmentActionViaArgs:
    def __init__(__self__, *,
                 network_function_groups: Optional[Sequence[builtins.str]] = None,
                 with_edge_overrides: Optional[Sequence['GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverrideArgs']] = None):
        """
        :param Sequence[builtins.str] network_function_groups: A list of strings. The network function group to use for the service insertion action.
        :param Sequence['GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverrideArgs'] with_edge_overrides: Any edge overrides and the preferred edge to use.
        """
        if network_function_groups is not None:
            pulumi.set(__self__, "network_function_groups", network_function_groups)
        if with_edge_overrides is not None:
            pulumi.set(__self__, "with_edge_overrides", with_edge_overrides)

    @property
    @pulumi.getter(name="networkFunctionGroups")
    def network_function_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of strings. The network function group to use for the service insertion action.
        """
        return pulumi.get(self, "network_function_groups")

    @network_function_groups.setter
    def network_function_groups(self, value: Optional[Sequence[builtins.str]]):
        pulumi.set(self, "network_function_groups", value)

    @property
    @pulumi.getter(name="withEdgeOverrides")
    def with_edge_overrides(self) -> Optional[Sequence['GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverrideArgs']]:
        """
        Any edge overrides and the preferred edge to use.
        """
        return pulumi.get(self, "with_edge_overrides")

    @with_edge_overrides.setter
    def with_edge_overrides(self, value: Optional[Sequence['GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverrideArgs']]):
        pulumi.set(self, "with_edge_overrides", value)


if not MYPY:
    class GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverrideArgsDict(TypedDict):
        edge_sets: NotRequired[Sequence[Sequence[builtins.str]]]
        """
        A list of a list of strings. The list of edges associated with the network function group.
        """
        use_edge: NotRequired[builtins.str]
        """
        The preferred edge to use.
        """
        use_edge_location: NotRequired[builtins.str]
        """
        The preferred edge to use.
        """
elif False:
    GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverrideArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverrideArgs:
    def __init__(__self__, *,
                 edge_sets: Optional[Sequence[Sequence[builtins.str]]] = None,
                 use_edge: Optional[builtins.str] = None,
                 use_edge_location: Optional[builtins.str] = None):
        """
        :param Sequence[Sequence[builtins.str]] edge_sets: A list of a list of strings. The list of edges associated with the network function group.
        :param builtins.str use_edge: The preferred edge to use.
        :param builtins.str use_edge_location: The preferred edge to use.
        """
        if edge_sets is not None:
            pulumi.set(__self__, "edge_sets", edge_sets)
        if use_edge is not None:
            warnings.warn("""use_edge is deprecated. Use use_edge_location instead.""", DeprecationWarning)
            pulumi.log.warn("""use_edge is deprecated: use_edge is deprecated. Use use_edge_location instead.""")
        if use_edge is not None:
            pulumi.set(__self__, "use_edge", use_edge)
        if use_edge_location is not None:
            pulumi.set(__self__, "use_edge_location", use_edge_location)

    @property
    @pulumi.getter(name="edgeSets")
    def edge_sets(self) -> Optional[Sequence[Sequence[builtins.str]]]:
        """
        A list of a list of strings. The list of edges associated with the network function group.
        """
        return pulumi.get(self, "edge_sets")

    @edge_sets.setter
    def edge_sets(self, value: Optional[Sequence[Sequence[builtins.str]]]):
        pulumi.set(self, "edge_sets", value)

    @property
    @pulumi.getter(name="useEdge")
    @_utilities.deprecated("""use_edge is deprecated. Use use_edge_location instead.""")
    def use_edge(self) -> Optional[builtins.str]:
        """
        The preferred edge to use.
        """
        return pulumi.get(self, "use_edge")

    @use_edge.setter
    def use_edge(self, value: Optional[builtins.str]):
        pulumi.set(self, "use_edge", value)

    @property
    @pulumi.getter(name="useEdgeLocation")
    def use_edge_location(self) -> Optional[builtins.str]:
        """
        The preferred edge to use.
        """
        return pulumi.get(self, "use_edge_location")

    @use_edge_location.setter
    def use_edge_location(self, value: Optional[builtins.str]):
        pulumi.set(self, "use_edge_location", value)


if not MYPY:
    class GetCoreNetworkPolicyDocumentSegmentActionWhenSentToArgsDict(TypedDict):
        segments: NotRequired[Sequence[builtins.str]]
        """
        A list of strings. The list of segments that the `send-via` `action` uses.
        """
elif False:
    GetCoreNetworkPolicyDocumentSegmentActionWhenSentToArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetCoreNetworkPolicyDocumentSegmentActionWhenSentToArgs:
    def __init__(__self__, *,
                 segments: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] segments: A list of strings. The list of segments that the `send-via` `action` uses.
        """
        if segments is not None:
            pulumi.set(__self__, "segments", segments)

    @property
    @pulumi.getter
    def segments(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of strings. The list of segments that the `send-via` `action` uses.
        """
        return pulumi.get(self, "segments")

    @segments.setter
    def segments(self, value: Optional[Sequence[builtins.str]]):
        pulumi.set(self, "segments", value)


